/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import org.eclipse.jdt.core.compiler.CharOperation;

public final class SimpleSetOfCharArray
implements Cloneable {
    public char[][] values;
    public int elementSize;
    public int threshold;

    public SimpleSetOfCharArray() {
        this(13);
    }

    public SimpleSetOfCharArray(int n) {
        if (n < 3) {
            n = 3;
        }
        this.elementSize = 0;
        this.threshold = n + 1;
        this.values = new char[2 * n + 1][];
    }

    public Object add(char[] cArray) {
        char[] cArray2;
        int n = this.values.length;
        int n2 = (CharOperation.hashCode(cArray) & Integer.MAX_VALUE) % n;
        while ((cArray2 = this.values[n2]) != null) {
            if (CharOperation.equals(cArray2, cArray)) {
                this.values[n2] = cArray;
                return cArray;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.values[n2] = cArray;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return cArray;
    }

    public void asArray(Object[] objectArray) {
        if (this.elementSize != objectArray.length) {
            throw new IllegalArgumentException();
        }
        int n = this.elementSize;
        int n2 = this.values.length;
        for (int i = 0; i < n2 && n > 0; ++i) {
            if (this.values[i] == null) continue;
            objectArray[--n] = this.values[i];
        }
    }

    public void clear() {
        int n = this.values.length;
        while (--n >= 0) {
            this.values[n] = null;
        }
        this.elementSize = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleSetOfCharArray simpleSetOfCharArray = (SimpleSetOfCharArray)super.clone();
        simpleSetOfCharArray.elementSize = this.elementSize;
        simpleSetOfCharArray.threshold = this.threshold;
        int n = this.values.length;
        simpleSetOfCharArray.values = new char[n][];
        System.arraycopy(this.values, 0, simpleSetOfCharArray.values, 0, n);
        return simpleSetOfCharArray;
    }

    public char[] get(char[] cArray) {
        char[] cArray2;
        int n = this.values.length;
        int n2 = (CharOperation.hashCode(cArray) & Integer.MAX_VALUE) % n;
        while ((cArray2 = this.values[n2]) != null) {
            if (CharOperation.equals(cArray2, cArray)) {
                return cArray2;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.values[n2] = cArray;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return cArray;
    }

    public boolean includes(char[] cArray) {
        char[] cArray2;
        int n = this.values.length;
        int n2 = (CharOperation.hashCode(cArray) & Integer.MAX_VALUE) % n;
        while ((cArray2 = this.values[n2]) != null) {
            if (CharOperation.equals(cArray2, cArray)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    public char[] remove(char[] cArray) {
        char[] cArray2;
        int n = this.values.length;
        int n2 = (CharOperation.hashCode(cArray) & Integer.MAX_VALUE) % n;
        while ((cArray2 = this.values[n2]) != null) {
            if (CharOperation.equals(cArray2, cArray)) {
                --this.elementSize;
                char[] cArray3 = this.values[n2];
                this.values[n2] = null;
                if (this.values[n2 + 1 == n ? 0 : n2 + 1] != null) {
                    this.rehash();
                }
                return cArray3;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    private void rehash() {
        SimpleSetOfCharArray simpleSetOfCharArray = new SimpleSetOfCharArray(this.elementSize * 2);
        int n = this.values.length;
        while (--n >= 0) {
            char[] cArray = this.values[n];
            if (cArray == null) continue;
            simpleSetOfCharArray.add(cArray);
        }
        this.values = simpleSetOfCharArray.values;
        this.elementSize = simpleSetOfCharArray.elementSize;
        this.threshold = simpleSetOfCharArray.threshold;
    }

    public String toString() {
        String string = "";
        for (char[] cArray : this.values) {
            if (cArray == null) continue;
            string = string + new String(cArray) + "\n";
        }
        return string;
    }
}

