/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;

public final class Region
extends Resource {
    public int handle;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        super(device);
        this.handle = OS.gdk_region_new();
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    Region(Device device, int n) {
        super(device);
        this.handle = n;
    }

    static int gdk_region_polygon(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (!OS.GTK3) {
            return OS.gdk_region_polygon(nArray, n, n2);
        }
        int n8 = n7 = nArray[0];
        int n9 = n6 = nArray[1];
        int n10 = n * 2;
        for (n5 = 2; n5 < n10; n5 += 2) {
            n4 = nArray[n5];
            n3 = nArray[n5 + 1];
            if (n4 < n7) {
                n7 = n4;
            }
            if (n4 > n8) {
                n8 = n4;
            }
            if (n3 < n6) {
                n6 = n3;
            }
            if (n3 <= n9) continue;
            n9 = n3;
        }
        n5 = Cairo.cairo_image_surface_create(0, n8 - n7, n9 - n6);
        if (n5 == 0) {
            SWT.error(2);
        }
        if ((n4 = Cairo.cairo_create(n5)) == 0) {
            SWT.error(2);
        }
        Cairo.cairo_move_to(n4, nArray[0] - n7, nArray[1] - n6);
        for (n3 = 2; n3 < n10; n3 += 2) {
            Cairo.cairo_line_to(n4, nArray[n3] - n7, nArray[n3 + 1] - n6);
        }
        Cairo.cairo_close_path(n4);
        Cairo.cairo_set_source_rgb(n4, 1.0, 1.0, 1.0);
        n3 = 0;
        if (n2 == 0) {
            n3 = 1;
        }
        Cairo.cairo_set_fill_rule(n4, n3);
        Cairo.cairo_fill(n4);
        Cairo.cairo_destroy(n4);
        int n11 = OS.gdk_cairo_region_create_from_surface(n5);
        OS.gdk_region_offset(n11, n7, n6);
        Cairo.cairo_surface_destroy(n5);
        return n11;
    }

    static void gdk_region_get_rectangles(int n, int[] nArray, int[] nArray2) {
        if (!OS.GTK3) {
            OS.gdk_region_get_rectangles(n, nArray, nArray2);
            return;
        }
        int n2 = Cairo.cairo_region_num_rectangles(n);
        if (nArray2 != null) {
            nArray2[0] = n2;
        }
        nArray[0] = OS.g_malloc(GdkRectangle.sizeof * n2);
        for (int i = 0; i < n2; ++i) {
            Cairo.cairo_region_get_rectangle(n, i, nArray[0] + i * GdkRectangle.sizeof);
        }
    }

    public void add(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length < 6) {
            return;
        }
        int n = Region.gdk_region_polygon(nArray, nArray.length / 2, 0);
        OS.gdk_region_union(this.handle, n);
        OS.gdk_region_destroy(n);
    }

    public void add(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.add(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void add(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n;
        gdkRectangle.y = n2;
        gdkRectangle.width = n3;
        gdkRectangle.height = n4;
        OS.gdk_region_union_with_rect(this.handle, gdkRectangle);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_region_union(this.handle, region.handle);
    }

    public boolean contains(int n, int n2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.gdk_region_point_in(this.handle, n, n2);
    }

    public boolean contains(Point point) {
        if (point == null) {
            SWT.error(4);
        }
        return this.contains(point.x, point.y);
    }

    @Override
    void destroy() {
        OS.gdk_region_destroy(this.handle);
        this.handle = 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gdk_region_get_clipbox(this.handle, gdkRectangle);
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
    }

    public static Region gtk_new(Device device, int n) {
        return new Region(device, n);
    }

    public int hashCode() {
        return this.handle;
    }

    public void intersect(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void intersect(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n;
        gdkRectangle.y = n2;
        gdkRectangle.width = n3;
        gdkRectangle.height = n4;
        int n5 = OS.gdk_region_rectangle(gdkRectangle);
        OS.gdk_region_intersect(this.handle, n5);
        OS.gdk_region_destroy(n5);
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_region_intersect(this.handle, region.handle);
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n;
        gdkRectangle.y = n2;
        gdkRectangle.width = n3;
        gdkRectangle.height = n4;
        return OS.gdk_region_rect_in(this.handle, gdkRectangle) != 1;
    }

    public boolean intersects(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        return this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.gdk_region_empty(this.handle);
    }

    public void subtract(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length < 6) {
            return;
        }
        int n = Region.gdk_region_polygon(nArray, nArray.length / 2, 0);
        OS.gdk_region_subtract(this.handle, n);
        OS.gdk_region_destroy(n);
    }

    public void subtract(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.subtract(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void subtract(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n;
        gdkRectangle.y = n2;
        gdkRectangle.width = n3;
        gdkRectangle.height = n4;
        int n5 = OS.gdk_region_rectangle(gdkRectangle);
        OS.gdk_region_subtract(this.handle, n5);
        OS.gdk_region_destroy(n5);
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_region_subtract(this.handle, region.handle);
    }

    public void translate(int n, int n2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.gdk_region_offset(this.handle, n, n2);
    }

    public void translate(Point point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        this.translate(point.x, point.y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

