/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.NetigsoModule;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class ModuleData {
    private static final Module.PackageExport[] ZERO_PACKAGE_ARRAY = new Module.PackageExport[0];
    private static final String[] ZERO_STRING_ARRAY = new String[0];
    private final String codeName;
    private final String codeNameBase;
    private final int codeNameRelease;
    private final String implVersion;
    private final String buildVersion;
    private final Set<String> friendNames;
    private final SpecificationVersion specVers;
    private final Module.PackageExport[] publicPackages;
    private final String[] provides;
    private final Dependency[] dependencies;
    private final Set<String> coveredPackages;
    private final String agentClass;

    ModuleData(Manifest manifest, Module module) throws InvalidException {
        Attributes attributes = manifest.getMainAttributes();
        this.codeName = attributes.getValue("OpenIDE-Module");
        if (this.codeName == null) {
            InvalidException invalidException = new InvalidException("Not a module: no OpenIDE-Module tag in manifest of " + this, manifest);
            Exceptions.attachLocalizedMessage((Throwable)invalidException, (String)NbBundle.getMessage(Module.class, (String)"EXC_not_a_module", (Object)this.toString()));
            throw invalidException;
        }
        module.assignData(this);
        try {
            String string;
            Object object;
            Object object2;
            Object object3;
            boolean bl;
            if (this.codeName.indexOf(44) != -1) {
                throw new InvalidException("Illegal code name syntax parsing OpenIDE-Module: " + this.codeName);
            }
            Object[] objectArray = Util.parseCodeName(this.codeName);
            this.codeNameBase = (String)objectArray[0];
            Set<Dependency> set = module.getManager().loadDependencies(this.codeNameBase);
            boolean bl2 = bl = set == null;
            if (bl) {
                Dependency.create((int)1, (String)this.codeName);
            }
            int n = this.codeNameRelease = objectArray[1] != null ? (Integer)objectArray[1] : -1;
            if (objectArray[2] != null) {
                throw new NumberFormatException(this.codeName);
            }
            String string2 = attributes.getValue("OpenIDE-Module-Specification-Version");
            if (string2 != null) {
                try {
                    this.specVers = new SpecificationVersion(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw (InvalidException)new InvalidException("While parsing OpenIDE-Module-Specification-Version: " + numberFormatException.toString()).initCause(numberFormatException);
                }
            } else {
                this.specVers = null;
            }
            String string3 = attributes.getValue("OpenIDE-Module-Implementation-Version");
            this.implVersion = string3 == null ? "" : string3;
            String string4 = attributes.getValue("OpenIDE-Module-Build-Version");
            this.buildVersion = string4 == null ? this.implVersion : string4;
            this.provides = this.computeProvides(module, attributes, bl, false);
            String string5 = attributes.getValue("OpenIDE-Module-Public-Packages");
            if (string5 != null) {
                if (string5.trim().equals("-")) {
                    this.publicPackages = ZERO_PACKAGE_ARRAY;
                } else {
                    object3 = new StringTokenizer(string5, ", ");
                    object2 = new ArrayList(Math.max(((StringTokenizer)object3).countTokens(), 1));
                    while (((StringTokenizer)object3).hasMoreTokens()) {
                        object = ((StringTokenizer)object3).nextToken();
                        if (((String)object).endsWith(".*")) {
                            string = ((String)object).substring(0, ((String)object).length() - 2);
                            if (bl) {
                                Dependency.create((int)1, (String)string);
                            }
                            if (string.lastIndexOf(47) != -1) {
                                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string5);
                            }
                            object2.add(new Module.PackageExport(string.replace('.', '/') + '/', false));
                            continue;
                        }
                        if (((String)object).endsWith(".**")) {
                            string = ((String)object).substring(0, ((String)object).length() - 3);
                            if (bl) {
                                Dependency.create((int)1, (String)string);
                            }
                            if (string.lastIndexOf(47) != -1) {
                                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string5);
                            }
                            object2.add(new Module.PackageExport(string.replace('.', '/') + '/', true));
                            continue;
                        }
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string5);
                    }
                    if (object2.isEmpty()) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string5);
                    }
                    this.publicPackages = object2.toArray(new Module.PackageExport[object2.size()]);
                }
            } else {
                Util.err.log(Level.WARNING, "module {0} does not declare OpenIDE-Module-Public-Packages in its manifest, so all packages are considered public by default: http://bits.netbeans.org/dev/javadoc/org-openide-modules/org/openide/modules/doc-files/api.html#how-vers", this.codeNameBase);
                this.publicPackages = null;
            }
            object3 = null;
            object2 = attributes.getValue("OpenIDE-Module-Friends");
            if (object2 != null) {
                object = new StringTokenizer((String)object2, ", ");
                object3 = new HashSet();
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string = ((StringTokenizer)object).nextToken();
                    if (string.indexOf(47) != -1) {
                        throw new IllegalArgumentException("May specify only module code name bases in OpenIDE-Module-Friends, not major release versions: " + string);
                    }
                    if (bl) {
                        Dependency.create((int)1, (String)string);
                    }
                    ((HashSet)object3).add(string);
                }
                if (((HashSet)object3).isEmpty()) {
                    throw new IllegalArgumentException("Empty OpenIDE-Module-Friends: " + (String)object2);
                }
                if (this.publicPackages == null || this.publicPackages.length == 0) {
                    throw new IllegalArgumentException("No use specifying OpenIDE-Module-Friends without any public packages: " + (String)object2);
                }
            }
            this.friendNames = object3;
            this.dependencies = this.initDeps(module, set, attributes);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (InvalidException)new InvalidException("While parsing " + this.codeName + " a dependency attribute: " + illegalArgumentException.toString()).initCause(illegalArgumentException);
        }
        this.coveredPackages = new HashSet<String>();
        this.agentClass = attributes.getValue("Agent-Class");
    }

    ModuleData(Manifest manifest, NetigsoModule netigsoModule) throws InvalidException {
        String string = ModuleData.getMainAttribute(manifest, "Bundle-SymbolicName");
        if (string == null) {
            throw new InvalidException("Not an OSGi bundle: " + (Object)((Object)netigsoModule));
        }
        netigsoModule.assignData(this);
        this.codeName = string.replace('-', '_');
        int n = this.codeName.lastIndexOf(47);
        this.codeNameRelease = n != -1 ? Integer.parseInt(string.substring(n + 1)) : -1;
        String string2 = ModuleData.getMainAttribute(manifest, "Bundle-Version");
        if (string2 == null) {
            Logger.getLogger(ModuleData.class.getName()).log(Level.WARNING, "No Bundle-Version for {0}", (Object)netigsoModule);
            string2 = "0.0";
            this.specVers = new SpecificationVersion("0.0");
        } else {
            this.specVers = ModuleData.computeVersion(string2);
        }
        this.codeNameBase = this.codeName;
        String string3 = ModuleData.getMainAttribute(manifest, "OpenIDE-Module-Implementation-Version");
        this.implVersion = string3 == null ? string2 : string3;
        String string4 = ModuleData.getMainAttribute(manifest, "OpenIDE-Module-Build-Version");
        this.buildVersion = string4 == null ? this.implVersion : string4;
        this.friendNames = Collections.emptySet();
        this.publicPackages = null;
        this.provides = this.computeProvides(netigsoModule, manifest.getMainAttributes(), false, true);
        this.dependencies = this.computeImported(manifest.getMainAttributes());
        this.coveredPackages = new HashSet<String>();
        this.agentClass = ModuleData.getMainAttribute(manifest, "Agent-Class");
    }

    ModuleData(ObjectInput objectInput) throws IOException {
        try {
            this.codeName = objectInput.readUTF();
            this.codeNameBase = objectInput.readUTF();
            this.codeNameRelease = objectInput.readInt();
            this.coveredPackages = this.readStrings(objectInput, new HashSet(), true);
            this.dependencies = (Dependency[])objectInput.readObject();
            this.implVersion = objectInput.readUTF();
            this.buildVersion = objectInput.readUTF();
            this.provides = this.readStrings(objectInput);
            this.friendNames = this.readStrings(objectInput, new HashSet(), false);
            this.specVers = new SpecificationVersion(objectInput.readUTF());
            this.publicPackages = Module.PackageExport.read(objectInput);
            this.agentClass = objectInput.readUTF();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException);
        }
    }

    void write(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.codeName);
        objectOutput.writeUTF(this.codeNameBase);
        objectOutput.writeInt(this.codeNameRelease);
        this.writeStrings((DataOutput)objectOutput, this.coveredPackages);
        objectOutput.writeObject(this.dependencies);
        objectOutput.writeUTF(this.implVersion);
        objectOutput.writeUTF(this.buildVersion);
        this.writeStrings(objectOutput, this.provides);
        this.writeStrings((DataOutput)objectOutput, this.friendNames);
        objectOutput.writeUTF(this.specVers != null ? this.specVers.toString() : "0");
        Module.PackageExport.write(objectOutput, this.publicPackages);
        objectOutput.writeUTF(this.agentClass == null ? "" : this.agentClass);
    }

    private Dependency[] computeImported(Attributes attributes) {
        Object object;
        Object object2;
        String string = attributes.getValue("Import-Package");
        ArrayList arrayList = null;
        if (string != null) {
            arrayList = new ArrayList();
            object2 = ModuleData.createTokenizer(string);
            while (((StringTokenizer)object2).hasMoreElements()) {
                object = ModuleData.beforeSemicolon((StringTokenizer)object2);
                arrayList.addAll(Dependency.create((int)7, (String)object));
            }
        }
        if ((object2 = attributes.getValue("Require-Bundle")) != null) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            object = ModuleData.createTokenizer((String)object2);
            while (((StringTokenizer)object).hasMoreElements()) {
                String string2 = ModuleData.beforeSemicolon((StringTokenizer)object);
                arrayList.addAll(Dependency.create((int)7, (String)("cnb." + string2)));
            }
        }
        return arrayList == null ? null : arrayList.toArray(new Dependency[0]);
    }

    private static StringTokenizer createTokenizer(String string) {
        int n;
        int n2;
        while ((n2 = string.indexOf(34)) != -1 && (n = string.indexOf(34, n2 + 1)) != -1) {
            string = string.substring(0, n2 - 1) + string.substring(n + 1);
        }
        return new StringTokenizer(string, ",");
    }

    private static String beforeSemicolon(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken().trim();
        int n = string.indexOf(59);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string.replace('-', '_');
    }

    private String[] computeExported(boolean bl, Collection<String> collection, Attributes attributes) {
        if (!bl) {
            return collection.toArray(ZERO_STRING_ARRAY);
        }
        String string = attributes.getValue("Export-Package");
        if (string == null) {
            return collection.toArray(ZERO_STRING_ARRAY);
        }
        StringTokenizer stringTokenizer = ModuleData.createTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            collection.add(ModuleData.beforeSemicolon(stringTokenizer));
        }
        return collection.toArray(ZERO_STRING_ARRAY);
    }

    private String[] computeProvides(Module module, Attributes attributes, boolean bl, boolean bl2) throws InvalidException, IllegalArgumentException {
        Object object;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        String string = attributes.getValue("OpenIDE-Module-Provides");
        if (string != null) {
            object = new StringTokenizer(string, ", ");
            int n = ((StringTokenizer)object).countTokens();
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                if (string2.indexOf(44) != -1) {
                    throw new InvalidException("Illegal code name syntax parsing OpenIDE-Module-Provides: " + string2);
                }
                if (bl) {
                    Dependency.create((int)1, (String)string2);
                }
                if (string2.lastIndexOf(47) != -1) {
                    throw new IllegalArgumentException("Illegal OpenIDE-Module-Provides: " + string2);
                }
                linkedHashSet.add(string2);
            }
            if (linkedHashSet.size() != n) {
                throw new IllegalArgumentException("Duplicate entries in OpenIDE-Module-Provides: " + string);
            }
        }
        if ((object = module.getManager().refineProvides(module)) != null) {
            linkedHashSet.addAll(Arrays.asList(object));
        }
        linkedHashSet.add("cnb." + this.getCodeNameBase());
        return this.computeExported(bl2, linkedHashSet, attributes);
    }

    private Dependency[] initDeps(Module module, Set<?> set, Attributes attributes) throws IllegalStateException, IllegalArgumentException {
        Object object;
        if (set != null) {
            return set.toArray(new Dependency[set.size()]);
        }
        HashSet<Dependency> hashSet = new HashSet<Dependency>(20);
        Set set2 = Dependency.create((int)4, (String)attributes.getValue("OpenIDE-Module-IDE-Dependencies"));
        if (!set2.isEmpty()) {
            object = (Dependency)set2.iterator().next();
            String string = object.getName();
            if (!string.startsWith("IDE/")) {
                throw new IllegalStateException("Weird IDE dep: " + string);
            }
            hashSet.addAll(Dependency.create((int)1, (String)("org.openide/" + string.substring(4) + " > " + object.getVersion())));
            if (hashSet.size() != 1) {
                throw new IllegalStateException("Should be singleton: " + hashSet);
            }
            Util.err.log(Level.WARNING, "the module {0} uses OpenIDE-Module-IDE-Dependencies which is deprecated. See http://openide.netbeans.org/proposals/arch/modularize.html", this.codeNameBase);
        }
        hashSet.addAll(Dependency.create((int)3, (String)attributes.getValue("OpenIDE-Module-Java-Dependencies")));
        hashSet.addAll(Dependency.create((int)1, (String)attributes.getValue("OpenIDE-Module-Module-Dependencies")));
        object = attributes.getValue("OpenIDE-Module-Package-Dependencies");
        if (object != null) {
            hashSet.addAll(Dependency.create((int)2, (String)object));
        }
        hashSet.addAll(Dependency.create((int)5, (String)attributes.getValue("OpenIDE-Module-Requires")));
        hashSet.addAll(Dependency.create((int)6, (String)attributes.getValue("OpenIDE-Module-Needs")));
        hashSet.addAll(Dependency.create((int)7, (String)attributes.getValue("OpenIDE-Module-Recommends")));
        module.refineDependencies(hashSet);
        return hashSet.toArray(new Dependency[hashSet.size()]);
    }

    final String getCodeName() {
        return this.codeName;
    }

    final String getCodeNameBase() {
        return this.codeNameBase;
    }

    final int getCodeNameRelease() {
        return this.codeNameRelease;
    }

    final String[] getProvides() {
        return this.provides;
    }

    final SpecificationVersion getSpecificationVersion() {
        return this.specVers;
    }

    final Module.PackageExport[] getPublicPackages() {
        return this.publicPackages;
    }

    final Set<String> getFriendNames() {
        return this.friendNames;
    }

    final Dependency[] getDependencies() {
        return this.dependencies;
    }

    final String getBuildVersion() {
        return this.buildVersion.isEmpty() ? null : this.buildVersion;
    }

    final String getImplementationVersion() {
        return this.implVersion.isEmpty() ? null : this.implVersion;
    }

    void registerCoveredPackages(Set<String> set) {
        assert (this.coveredPackages.isEmpty());
        this.coveredPackages.addAll(set);
    }

    Set<String> getCoveredPackages() {
        return this.coveredPackages.isEmpty() ? null : this.coveredPackages;
    }

    private <T extends Collection<String>> T readStrings(DataInput dataInput, T t, boolean bl) throws IOException {
        int n = dataInput.readInt();
        if (!bl && n == 0) {
            return null;
        }
        while (n-- > 0) {
            t.add((String)dataInput.readUTF());
        }
        return t;
    }

    private String[] readStrings(ObjectInput objectInput) throws IOException {
        ArrayList arrayList = new ArrayList();
        this.readStrings(objectInput, arrayList, false);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void writeStrings(DataOutput dataOutput, Collection<String> collection) throws IOException {
        if (collection == null) {
            dataOutput.writeInt(0);
            return;
        }
        dataOutput.writeInt(collection.size());
        for (String string : collection) {
            dataOutput.writeUTF(string);
        }
    }

    private void writeStrings(ObjectOutput objectOutput, String[] stringArray) throws IOException {
        this.writeStrings((DataOutput)objectOutput, Arrays.asList(stringArray));
    }

    private static String getMainAttribute(Manifest manifest, String string) {
        String string2 = manifest.getMainAttributes().getValue(string);
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf(59);
        if (n == -1) {
            return string2;
        }
        return string2.substring(0, n);
    }

    private static SpecificationVersion computeVersion(String string) {
        int n = -1;
        for (int i = 0; i < 3; ++i) {
            if ((n = string.indexOf(46, n + 1)) != -1) continue;
            return new SpecificationVersion(string);
        }
        return new SpecificationVersion(string.substring(0, n));
    }

    final String getAgentClass() {
        return this.agentClass == null || this.agentClass.isEmpty() ? null : this.agentClass;
    }
}

