/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherCore;
import com.sun.crypto.provider.ConstructKeys;
import com.sun.crypto.provider.DESCrypt;
import com.sun.crypto.provider.DESedeCrypt;
import com.sun.crypto.provider.SunJCE;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class PBECipherCore {
    private CipherCore cipher;
    private MessageDigest md;
    private int blkSize;
    private String algo = null;
    private byte[] salt = null;
    private int iCount = 10;

    PBECipherCore(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.algo = string;
        if (this.algo.equals("DES")) {
            this.cipher = new CipherCore(new DESCrypt(), 8);
        } else if (this.algo.equals("DESede")) {
            this.cipher = new CipherCore(new DESedeCrypt(), 8);
        } else {
            throw new NoSuchAlgorithmException("No Cipher implementation for PBEWithMD5And" + this.algo);
        }
        this.cipher.setMode("CBC");
        this.cipher.setPadding("PKCS5Padding");
        this.md = MessageDigest.getInstance("MD5");
    }

    void setMode(String string) throws NoSuchAlgorithmException {
        this.cipher.setMode(string);
    }

    void setPadding(String string) throws NoSuchPaddingException {
        this.cipher.setPadding(string);
    }

    int getBlockSize() {
        return 8;
    }

    int getOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }

    byte[] getIV() {
        return this.cipher.getIV();
    }

    AlgorithmParameters getParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (this.salt == null) {
            this.salt = new byte[8];
            SunJCE.getRandom().nextBytes(this.salt);
        }
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.salt, this.iCount);
        try {
            algorithmParameters = AlgorithmParameters.getInstance("PBEWithMD5And" + (this.algo.equalsIgnoreCase("DES") ? "DES" : "TripleDES"), SunJCE.getInstance());
            algorithmParameters.init(pBEParameterSpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("SunJCE called, but not configured");
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException("PBEParameterSpec not supported");
        }
        return algorithmParameters;
    }

    void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if ((n == 2 || n == 4) && algorithmParameterSpec == null) {
            throw new InvalidAlgorithmParameterException("Parameters missing");
        }
        if (key == null || key.getEncoded() == null || !key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) {
            throw new InvalidKeyException("Missing password");
        }
        if (algorithmParameterSpec == null) {
            this.salt = new byte[8];
            secureRandom.nextBytes(this.salt);
        } else {
            if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
            }
            this.salt = ((PBEParameterSpec)algorithmParameterSpec).getSalt();
            if (this.salt.length != 8) {
                throw new InvalidAlgorithmParameterException("Salt must be 8 bytes long");
            }
            this.iCount = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
            if (this.iCount <= 0) {
                throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
            }
        }
        byte[] byArray = this.deriveCipherKey(key);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 0, byArray.length - 8, this.algo);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray, byArray.length - 8, 8);
        this.cipher.init(n, (Key)secretKeySpec, ivParameterSpec, secureRandom);
    }

    private byte[] deriveCipherKey(Key key) {
        byte[] byArray = null;
        byte[] byArray2 = key.getEncoded();
        if (this.algo.equals("DES")) {
            byte[] byArray3 = new byte[byArray2.length + this.salt.length];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            Arrays.fill(byArray2, (byte)0);
            System.arraycopy(this.salt, 0, byArray3, byArray2.length, this.salt.length);
            byte[] byArray4 = byArray3;
            for (int i = 0; i < this.iCount; ++i) {
                this.md.update(byArray4);
                byArray4 = this.md.digest();
            }
            Arrays.fill(byArray3, (byte)0);
            byArray = byArray4;
        } else if (this.algo.equals("DESede")) {
            int n;
            for (n = 0; n < 4 && this.salt[n] == this.salt[n + 4]; ++n) {
            }
            if (n == 4) {
                for (n = 0; n < 2; ++n) {
                    byte by = this.salt[n];
                    this.salt[n] = this.salt[3 - n];
                    this.salt[2] = by;
                }
            }
            Object var5_8 = null;
            Object var6_10 = null;
            byte[] byArray5 = null;
            byArray = new byte[32];
            for (n = 0; n < 2; ++n) {
                byArray5 = new byte[this.salt.length / 2];
                System.arraycopy(this.salt, n * (this.salt.length / 2), byArray5, 0, byArray5.length);
                for (int i = 0; i < this.iCount; ++i) {
                    this.md.update(byArray5);
                    this.md.update(byArray2);
                    byArray5 = this.md.digest();
                }
                System.arraycopy(byArray5, 0, byArray, n * 16, byArray5.length);
            }
        }
        return byArray;
    }

    void init(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEParameterSpec pBEParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                pBEParameterSpec = algorithmParameters.getParameterSpec(PBEParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
            }
        }
        this.init(n, key, pBEParameterSpec, secureRandom);
    }

    byte[] update(byte[] byArray, int n, int n2) {
        return this.cipher.update(byArray, n, n2);
    }

    int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.cipher.update(byArray, n, n2, byArray2, n3);
    }

    byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(byArray, n, n2);
    }

    int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(byArray, n, n2, byArray2, n3);
    }

    byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = null;
        try {
            byte[] byArray2 = key.getEncoded();
            if (byArray2 == null || byArray2.length == 0) {
                throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
            }
            byArray = this.doFinal(byArray2, 0, byArray2.length);
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        return byArray;
    }

    Key unwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        try {
            byArray2 = this.doFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("The wrapped key is not padded correctly");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException("The wrapped key does not have the correct length");
        }
        return ConstructKeys.constructKey(byArray2, string, n);
    }
}

