/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.math.RoundingMode;

public final class MathContext
implements Serializable {
    private static final int DEFAULT_DIGITS = 9;
    private static final RoundingMode DEFAULT_ROUNDINGMODE = RoundingMode.HALF_UP;
    private static final int MIN_DIGITS = 0;
    private static final long serialVersionUID = 5579720004786848255L;
    public static final MathContext UNLIMITED = new MathContext(0, RoundingMode.HALF_UP);
    public static final MathContext DECIMAL32 = new MathContext(7, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL64 = new MathContext(16, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL128 = new MathContext(34, RoundingMode.HALF_EVEN);
    final int precision;
    final RoundingMode roundingMode;

    public MathContext(int n) {
        this(n, DEFAULT_ROUNDINGMODE);
    }

    public MathContext(int n, RoundingMode roundingMode) {
        if (n < 0) {
            throw new IllegalArgumentException("Digits < 0");
        }
        if (roundingMode == null) {
            throw new NullPointerException("null RoundingMode");
        }
        this.precision = n;
        this.roundingMode = roundingMode;
    }

    public MathContext(String string) {
        int n;
        boolean bl = false;
        if (string == null) {
            throw new NullPointerException("null String");
        }
        try {
            if (!string.startsWith("precision=")) {
                throw new RuntimeException();
            }
            int n2 = string.indexOf(32);
            int n3 = 10;
            n = Integer.parseInt(string.substring(10, n2));
            if (!string.startsWith("roundingMode=", n2 + 1)) {
                throw new RuntimeException();
            }
            n3 = n2 + 1 + 13;
            String string2 = string.substring(n3, string.length());
            this.roundingMode = RoundingMode.valueOf(string2);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("bad string format");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Digits < 0");
        }
        this.precision = n;
    }

    public int getPrecision() {
        return this.precision;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MathContext)) {
            return false;
        }
        MathContext mathContext = (MathContext)object;
        return mathContext.precision == this.precision && mathContext.roundingMode == this.roundingMode;
    }

    public int hashCode() {
        return this.precision + this.roundingMode.hashCode() * 59;
    }

    public String toString() {
        return "precision=" + this.precision + " " + "roundingMode=" + this.roundingMode.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.precision < 0) {
            String string = "MathContext: invalid digits in stream";
            throw new StreamCorruptedException(string);
        }
        if (this.roundingMode == null) {
            String string = "MathContext: null roundingMode in stream";
            throw new StreamCorruptedException(string);
        }
    }
}

