/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.border.Border;

public abstract class AbstractBorder
implements Border,
Serializable {
    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        insets.bottom = 0;
        insets.right = 0;
        insets.top = 0;
        insets.left = 0;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public Rectangle getInteriorRectangle(Component component, int n, int n2, int n3, int n4) {
        return AbstractBorder.getInteriorRectangle(component, this, n, n2, n3, n4);
    }

    public static Rectangle getInteriorRectangle(Component component, Border border, int n, int n2, int n3, int n4) {
        Insets insets = border != null ? border.getBorderInsets(component) : new Insets(0, 0, 0, 0);
        return new Rectangle(n + insets.left, n2 + insets.top, n3 - insets.right - insets.left, n4 - insets.top - insets.bottom);
    }

    public int getBaseline(Component component, int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Width and height must be >= 0");
        }
        return -1;
    }

    public Component.BaselineResizeBehavior getBaselineResizeBehavior(Component component) {
        if (component == null) {
            throw new NullPointerException("Component must be non-null");
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }
}

