/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.Position;
import sun.awt.shell.ShellFolder;
import sun.awt.shell.ShellFolderColumnInfo;
import sun.swing.SwingUtilities2;

public class FilePane
extends JPanel
implements PropertyChangeListener {
    public static final String ACTION_APPROVE_SELECTION = "approveSelection";
    public static final String ACTION_CANCEL = "cancelSelection";
    public static final String ACTION_EDIT_FILE_NAME = "editFileName";
    public static final String ACTION_REFRESH = "refresh";
    public static final String ACTION_CHANGE_TO_PARENT_DIRECTORY = "Go Up";
    public static final String ACTION_NEW_FOLDER = "New Folder";
    public static final String ACTION_VIEW_LIST = "viewTypeList";
    public static final String ACTION_VIEW_DETAILS = "viewTypeDetails";
    private Action[] actions;
    public static final int VIEWTYPE_LIST = 0;
    public static final int VIEWTYPE_DETAILS = 1;
    private static final int VIEWTYPE_COUNT = 2;
    private int viewType = -1;
    private JPanel[] viewPanels = new JPanel[2];
    private JPanel currentViewPanel;
    private String[] viewTypeActionNames;
    private String filesListAccessibleName = null;
    private String filesDetailsAccessibleName = null;
    private JPopupMenu contextMenu;
    private JMenu viewMenu;
    private String viewMenuLabelText;
    private String refreshActionLabelText;
    private String newFolderActionLabelText;
    private String kiloByteString;
    private String megaByteString;
    private String gigaByteString;
    private String renameErrorTitleText;
    private String renameErrorText;
    private String renameErrorFileExistsText;
    private static final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    private final KeyListener detailsKeyListener = new KeyAdapter(){
        private final long timeFactor;
        private final StringBuilder typedString = new StringBuilder();
        private long lastTime = 1000L;
        {
            Long l = (Long)UIManager.get("Table.timeFactor");
            this.timeFactor = l != null ? l : 1000L;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            int n;
            BasicDirectoryModel basicDirectoryModel = FilePane.this.getModel();
            int n2 = basicDirectoryModel.getSize();
            if (FilePane.this.detailsTable == null || n2 == 0 || keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                return;
            }
            InputMap inputMap = FilePane.this.detailsTable.getInputMap(1);
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            if (inputMap != null && inputMap.get(keyStroke) != null) {
                return;
            }
            int n3 = FilePane.this.detailsTable.getSelectionModel().getLeadSelectionIndex();
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 >= n2) {
                n3 = n2 - 1;
            }
            char c = keyEvent.getKeyChar();
            long l = keyEvent.getWhen();
            if (l - this.lastTime < this.timeFactor) {
                if (this.typedString.length() == 1 && this.typedString.charAt(0) == c) {
                    ++n3;
                } else {
                    this.typedString.append(c);
                }
            } else {
                ++n3;
                this.typedString.setLength(0);
                this.typedString.append(c);
            }
            this.lastTime = l;
            if (n3 >= n2) {
                n3 = 0;
            }
            if ((n = this.getNextMatch(n3, n2 - 1)) < 0 && n3 > 0) {
                n = this.getNextMatch(0, n3 - 1);
            }
            if (n >= 0) {
                FilePane.this.detailsTable.getSelectionModel().setSelectionInterval(n, n);
                Rectangle rectangle = FilePane.this.detailsTable.getCellRect(n, FilePane.this.detailsTable.convertColumnIndexToView(0), false);
                FilePane.this.detailsTable.scrollRectToVisible(rectangle);
            }
        }

        private int getNextMatch(int n, int n2) {
            BasicDirectoryModel basicDirectoryModel = FilePane.this.getModel();
            JFileChooser jFileChooser = FilePane.this.getFileChooser();
            DetailsTableRowSorter detailsTableRowSorter = FilePane.this.getRowSorter();
            String string = this.typedString.toString().toLowerCase();
            for (int i = n; i <= n2; ++i) {
                File file = (File)basicDirectoryModel.getElementAt(detailsTableRowSorter.convertRowIndexToModel(i));
                String string2 = jFileChooser.getName(file).toLowerCase();
                if (!string2.startsWith(string)) continue;
                return i;
            }
            return -1;
        }
    };
    private FocusListener editorFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                FilePane.this.applyEdit();
            }
        }
    };
    private static FocusListener repaintListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.repaintSelection(focusEvent.getSource());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.repaintSelection(focusEvent.getSource());
        }

        private void repaintSelection(Object object) {
            if (object instanceof JList) {
                this.repaintListSelection((JList)object);
            } else if (object instanceof JTable) {
                this.repaintTableSelection((JTable)object);
            }
        }

        private void repaintListSelection(JList jList) {
            int[] nArray;
            for (int n : nArray = jList.getSelectedIndices()) {
                Rectangle rectangle = jList.getCellBounds(n, n);
                jList.repaint(rectangle);
            }
        }

        private void repaintTableSelection(JTable jTable) {
            int n = jTable.getSelectionModel().getMinSelectionIndex();
            int n2 = jTable.getSelectionModel().getMaxSelectionIndex();
            if (n == -1 || n2 == -1) {
                return;
            }
            int n3 = jTable.convertColumnIndexToView(0);
            Rectangle rectangle = jTable.getCellRect(n, n3, false);
            Rectangle rectangle2 = jTable.getCellRect(n2, n3, false);
            Rectangle rectangle3 = rectangle.union(rectangle2);
            jTable.repaint(rectangle3);
        }
    };
    private boolean smallIconsView = false;
    private Border listViewBorder;
    private Color listViewBackground;
    private boolean listViewWindowsStyle;
    private boolean readOnly;
    private boolean fullRowSelection = false;
    private ListSelectionModel listSelectionModel;
    private JList list;
    private JTable detailsTable;
    private static final int COLUMN_FILENAME = 0;
    private File newFolderFile;
    private FileChooserUIAccessor fileChooserUIAccessor;
    private DetailsTableModel detailsTableModel;
    private DetailsTableRowSorter rowSorter;
    private DetailsTableCellEditor tableCellEditor;
    int lastIndex = -1;
    File editFile = null;
    JTextField editCell = null;
    protected Action newFolderAction;
    private Handler handler;

    public FilePane(FileChooserUIAccessor fileChooserUIAccessor) {
        super(new BorderLayout());
        this.fileChooserUIAccessor = fileChooserUIAccessor;
        this.installDefaults();
        this.createActionMap();
    }

    public void uninstallUI() {
        if (this.getModel() != null) {
            this.getModel().removePropertyChangeListener(this);
        }
    }

    protected JFileChooser getFileChooser() {
        return this.fileChooserUIAccessor.getFileChooser();
    }

    protected BasicDirectoryModel getModel() {
        return this.fileChooserUIAccessor.getModel();
    }

    public int getViewType() {
        return this.viewType;
    }

    public void setViewType(int n) {
        if (n == this.viewType) {
            return;
        }
        int n2 = this.viewType;
        this.viewType = n;
        JPanel jPanel = null;
        JComponent jComponent = null;
        switch (n) {
            case 0: {
                if (this.viewPanels[n] == null) {
                    jPanel = this.fileChooserUIAccessor.createList();
                    if (jPanel == null) {
                        jPanel = this.createList();
                    }
                    this.list = (JList)this.findChildComponent(jPanel, JList.class);
                    if (this.listSelectionModel == null) {
                        this.listSelectionModel = this.list.getSelectionModel();
                        if (this.detailsTable != null) {
                            this.detailsTable.setSelectionModel(this.listSelectionModel);
                        }
                    } else {
                        this.list.setSelectionModel(this.listSelectionModel);
                    }
                }
                this.list.setLayoutOrientation(1);
                jComponent = this.list;
                break;
            }
            case 1: {
                if (this.viewPanels[n] == null) {
                    jPanel = this.fileChooserUIAccessor.createDetailsView();
                    if (jPanel == null) {
                        jPanel = this.createDetailsView();
                    }
                    this.detailsTable = (JTable)this.findChildComponent(jPanel, JTable.class);
                    this.detailsTable.setRowHeight(Math.max(this.detailsTable.getFont().getSize() + 4, 17));
                    if (this.listSelectionModel != null) {
                        this.detailsTable.setSelectionModel(this.listSelectionModel);
                    }
                }
                jComponent = this.detailsTable;
            }
        }
        if (jPanel != null) {
            this.viewPanels[n] = jPanel;
            FilePane.recursivelySetInheritsPopupMenu(jPanel, true);
        }
        boolean bl = false;
        if (this.currentViewPanel != null) {
            Component component = DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            bl = component == this.detailsTable || component == this.list;
            this.remove(this.currentViewPanel);
        }
        this.currentViewPanel = this.viewPanels[n];
        this.add((Component)this.currentViewPanel, "Center");
        if (bl && jComponent != null) {
            ((Component)jComponent).requestFocusInWindow();
        }
        this.revalidate();
        this.repaint();
        this.updateViewMenu();
        this.firePropertyChange("viewType", n2, n);
    }

    public Action getViewTypeAction(int n) {
        return new ViewTypeAction(n);
    }

    private static void recursivelySetInheritsPopupMenu(Container container, boolean bl) {
        if (container instanceof JComponent) {
            ((JComponent)container).setInheritsPopupMenu(bl);
        }
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            FilePane.recursivelySetInheritsPopupMenu((Container)container.getComponent(i), bl);
        }
    }

    protected void installDefaults() {
        Locale locale = this.getFileChooser().getLocale();
        this.listViewBorder = UIManager.getBorder("FileChooser.listViewBorder");
        this.listViewBackground = UIManager.getColor("FileChooser.listViewBackground");
        this.listViewWindowsStyle = UIManager.getBoolean("FileChooser.listViewWindowsStyle");
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
        this.viewMenuLabelText = UIManager.getString((Object)"FileChooser.viewMenuLabelText", locale);
        this.refreshActionLabelText = UIManager.getString((Object)"FileChooser.refreshActionLabelText", locale);
        this.newFolderActionLabelText = UIManager.getString((Object)"FileChooser.newFolderActionLabelText", locale);
        this.viewTypeActionNames = new String[2];
        this.viewTypeActionNames[0] = UIManager.getString((Object)"FileChooser.listViewActionLabelText", locale);
        this.viewTypeActionNames[1] = UIManager.getString((Object)"FileChooser.detailsViewActionLabelText", locale);
        this.kiloByteString = UIManager.getString((Object)"FileChooser.fileSizeKiloBytes", locale);
        this.megaByteString = UIManager.getString((Object)"FileChooser.fileSizeMegaBytes", locale);
        this.gigaByteString = UIManager.getString((Object)"FileChooser.fileSizeGigaBytes", locale);
        this.fullRowSelection = UIManager.getBoolean("FileView.fullRowSelection");
        this.filesListAccessibleName = UIManager.getString((Object)"FileChooser.filesListAccessibleName", locale);
        this.filesDetailsAccessibleName = UIManager.getString((Object)"FileChooser.filesDetailsAccessibleName", locale);
        this.renameErrorTitleText = UIManager.getString((Object)"FileChooser.renameErrorTitleText", locale);
        this.renameErrorText = UIManager.getString((Object)"FileChooser.renameErrorText", locale);
        this.renameErrorFileExistsText = UIManager.getString((Object)"FileChooser.renameErrorFileExistsText", locale);
    }

    public Action[] getActions() {
        if (this.actions == null) {
            ArrayList<Action> arrayList = new ArrayList<Action>(8);
            class FilePaneAction
            extends AbstractAction {
                FilePaneAction(String string) {
                    this(string, string);
                }

                FilePaneAction(String string, String string2) {
                    super(string);
                    this.putValue("ActionCommandKey", string2);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)this.getValue("ActionCommandKey");
                    if (string == FilePane.ACTION_CANCEL) {
                        if (FilePane.this.editFile != null) {
                            FilePane.this.cancelEdit();
                        } else {
                            FilePane.this.getFileChooser().cancelSelection();
                        }
                    } else if (string == FilePane.ACTION_EDIT_FILE_NAME) {
                        JFileChooser jFileChooser = FilePane.this.getFileChooser();
                        int n = FilePane.this.listSelectionModel.getMinSelectionIndex();
                        if (!(n < 0 || FilePane.this.editFile != null || jFileChooser.isMultiSelectionEnabled() && jFileChooser.getSelectedFiles().length > 1)) {
                            FilePane.this.editFileName(n);
                        }
                    } else if (string == FilePane.ACTION_REFRESH) {
                        FilePane.this.getFileChooser().rescanCurrentDirectory();
                    }
                }

                @Override
                public boolean isEnabled() {
                    String string = (String)this.getValue("ActionCommandKey");
                    if (string == FilePane.ACTION_CANCEL) {
                        return FilePane.this.getFileChooser().isEnabled();
                    }
                    if (string == FilePane.ACTION_EDIT_FILE_NAME) {
                        return !FilePane.this.readOnly && FilePane.this.getFileChooser().isEnabled();
                    }
                    return true;
                }
            }
            arrayList.add(new FilePaneAction(ACTION_CANCEL));
            arrayList.add(new FilePaneAction(ACTION_EDIT_FILE_NAME));
            arrayList.add(new FilePaneAction(this.refreshActionLabelText, ACTION_REFRESH));
            Action action = this.fileChooserUIAccessor.getApproveSelectionAction();
            if (action != null) {
                arrayList.add(action);
            }
            if ((action = this.fileChooserUIAccessor.getChangeToParentDirectoryAction()) != null) {
                arrayList.add(action);
            }
            if ((action = this.getNewFolderAction()) != null) {
                arrayList.add(action);
            }
            if ((action = this.getViewTypeAction(0)) != null) {
                arrayList.add(action);
            }
            if ((action = this.getViewTypeAction(1)) != null) {
                arrayList.add(action);
            }
            this.actions = arrayList.toArray(new Action[arrayList.size()]);
        }
        return this.actions;
    }

    protected void createActionMap() {
        FilePane.addActionsToMap(super.getActionMap(), this.getActions());
    }

    public static void addActionsToMap(ActionMap actionMap, Action[] actionArray) {
        if (actionMap != null && actionArray != null) {
            for (Action action : actionArray) {
                String string = (String)action.getValue("ActionCommandKey");
                if (string == null) {
                    string = (String)action.getValue("Name");
                }
                actionMap.put(string, action);
            }
        }
    }

    private void updateListRowCount(JList jList) {
        if (this.smallIconsView) {
            jList.setVisibleRowCount(this.getModel().getSize() / 3);
        } else {
            jList.setVisibleRowCount(-1);
        }
    }

    public JPanel createList() {
        JPanel jPanel = new JPanel(new BorderLayout());
        final JFileChooser jFileChooser = this.getFileChooser();
        final JList<Object> jList = new JList<Object>(){

            @Override
            public int getNextMatch(String string, int n, Position.Bias bias) {
                ListModel listModel = this.getModel();
                int n2 = listModel.getSize();
                if (string == null || n < 0 || n >= n2) {
                    throw new IllegalArgumentException();
                }
                boolean bl = bias == Position.Bias.Backward;
                int n3 = n;
                while (bl ? n3 >= 0 : n3 < n2) {
                    String string2 = jFileChooser.getName((File)listModel.getElementAt(n3));
                    if (string2.regionMatches(true, 0, string, 0, string.length())) {
                        return n3;
                    }
                    n3 += bl ? -1 : 1;
                }
                return -1;
            }
        };
        jList.setCellRenderer(new FileRenderer());
        jList.setLayoutOrientation(1);
        jList.putClientProperty("List.isFileList", Boolean.TRUE);
        if (this.listViewWindowsStyle) {
            jList.addFocusListener(repaintListener);
        }
        this.updateListRowCount(jList);
        this.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                FilePane.this.updateListRowCount(jList);
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                FilePane.this.updateListRowCount(jList);
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                if (FilePane.this.isShowing()) {
                    FilePane.this.clearSelection();
                }
                FilePane.this.updateListRowCount(jList);
            }
        });
        this.getModel().addPropertyChangeListener(this);
        if (jFileChooser.isMultiSelectionEnabled()) {
            jList.setSelectionMode(2);
        } else {
            jList.setSelectionMode(0);
        }
        jList.setModel(new SortableListModel());
        jList.addListSelectionListener(this.createListSelectionListener());
        jList.addMouseListener(this.getMouseHandler());
        JScrollPane jScrollPane = new JScrollPane(jList);
        if (this.listViewBackground != null) {
            jList.setBackground(this.listViewBackground);
        }
        if (this.listViewBorder != null) {
            jScrollPane.setBorder(this.listViewBorder);
        }
        jList.putClientProperty("AccessibleName", this.filesListAccessibleName);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private DetailsTableModel getDetailsTableModel() {
        if (this.detailsTableModel == null) {
            this.detailsTableModel = new DetailsTableModel(this.getFileChooser());
        }
        return this.detailsTableModel;
    }

    private void updateDetailsColumnModel(JTable jTable) {
        if (jTable != null) {
            ShellFolderColumnInfo[] shellFolderColumnInfoArray = this.detailsTableModel.getColumns();
            DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
            for (int i = 0; i < shellFolderColumnInfoArray.length; ++i) {
                Object object;
                ShellFolderColumnInfo shellFolderColumnInfo = shellFolderColumnInfoArray[i];
                TableColumn tableColumn = new TableColumn(i);
                Object object2 = shellFolderColumnInfo.getTitle();
                if (object2 != null && ((String)object2).startsWith("FileChooser.") && ((String)object2).endsWith("HeaderText") && (object = UIManager.getString(object2, jTable.getLocale())) != null) {
                    object2 = object;
                }
                tableColumn.setHeaderValue(object2);
                object = shellFolderColumnInfo.getWidth();
                if (object != null) {
                    tableColumn.setPreferredWidth((Integer)object);
                }
                defaultTableColumnModel.addColumn(tableColumn);
            }
            if (!this.readOnly && defaultTableColumnModel.getColumnCount() > 0) {
                defaultTableColumnModel.getColumn(0).setCellEditor(this.getDetailsTableCellEditor());
            }
            jTable.setColumnModel(defaultTableColumnModel);
        }
    }

    private DetailsTableRowSorter getRowSorter() {
        if (this.rowSorter == null) {
            this.rowSorter = new DetailsTableRowSorter();
        }
        return this.rowSorter;
    }

    private DetailsTableCellEditor getDetailsTableCellEditor() {
        if (this.tableCellEditor == null) {
            this.tableCellEditor = new DetailsTableCellEditor(new JTextField());
        }
        return this.tableCellEditor;
    }

    public JPanel createDetailsView() {
        final JFileChooser jFileChooser = this.getFileChooser();
        JPanel jPanel = new JPanel(new BorderLayout());
        JTable jTable = new JTable(this.getDetailsTableModel()){

            @Override
            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                if (keyEvent.getKeyCode() == 27 && this.getCellEditor() == null) {
                    jFileChooser.dispatchEvent(keyEvent);
                    return true;
                }
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                super.tableChanged(tableModelEvent);
                if (tableModelEvent.getFirstRow() == -1) {
                    FilePane.this.updateDetailsColumnModel(this);
                }
            }
        };
        jTable.setRowSorter(this.getRowSorter());
        jTable.setAutoCreateColumnsFromModel(false);
        jTable.setComponentOrientation(jFileChooser.getComponentOrientation());
        jTable.setAutoResizeMode(0);
        jTable.setShowGrid(false);
        jTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        jTable.addKeyListener(this.detailsKeyListener);
        Font font = this.list.getFont();
        jTable.setFont(font);
        jTable.setIntercellSpacing(new Dimension(0, 0));
        AlignableTableHeaderRenderer alignableTableHeaderRenderer = new AlignableTableHeaderRenderer(jTable.getTableHeader().getDefaultRenderer());
        jTable.getTableHeader().setDefaultRenderer(alignableTableHeaderRenderer);
        DetailsTableCellRenderer detailsTableCellRenderer = new DetailsTableCellRenderer(jFileChooser);
        jTable.setDefaultRenderer(Object.class, detailsTableCellRenderer);
        jTable.getColumnModel().getSelectionModel().setSelectionMode(0);
        jTable.addMouseListener(this.getMouseHandler());
        jTable.putClientProperty("Table.isFileList", Boolean.TRUE);
        if (this.listViewWindowsStyle) {
            jTable.addFocusListener(repaintListener);
        }
        ActionMap actionMap = SwingUtilities.getUIActionMap(jTable);
        actionMap.remove("selectNextRowCell");
        actionMap.remove("selectPreviousRowCell");
        actionMap.remove("selectNextColumnCell");
        actionMap.remove("selectPreviousColumnCell");
        jTable.setFocusTraversalKeys(0, null);
        jTable.setFocusTraversalKeys(1, null);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setComponentOrientation(jFileChooser.getComponentOrientation());
        LookAndFeel.installColors(jScrollPane.getViewport(), "Table.background", "Table.foreground");
        jScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                JScrollPane jScrollPane = (JScrollPane)componentEvent.getComponent();
                FilePane.this.fixNameColumnWidth(jScrollPane.getViewport().getSize().width);
                jScrollPane.removeComponentListener(this);
            }
        });
        jScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JScrollPane jScrollPane = (JScrollPane)mouseEvent.getComponent();
                JTable jTable = (JTable)jScrollPane.getViewport().getView();
                if (!mouseEvent.isShiftDown() || jTable.getSelectionModel().getSelectionMode() == 0) {
                    FilePane.this.clearSelection();
                    TableCellEditor tableCellEditor = jTable.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.stopCellEditing();
                    }
                }
            }
        });
        jTable.setForeground(this.list.getForeground());
        jTable.setBackground(this.list.getBackground());
        if (this.listViewBorder != null) {
            jScrollPane.setBorder(this.listViewBorder);
        }
        jPanel.add((Component)jScrollPane, "Center");
        this.detailsTableModel.fireTableStructureChanged();
        jTable.putClientProperty("AccessibleName", this.filesDetailsAccessibleName);
        return jPanel;
    }

    private void fixNameColumnWidth(int n) {
        TableColumn tableColumn = this.detailsTable.getColumnModel().getColumn(0);
        int n2 = this.detailsTable.getPreferredSize().width;
        if (n2 < n) {
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n - n2);
        }
    }

    public ListSelectionListener createListSelectionListener() {
        return this.fileChooserUIAccessor.createListSelectionListener();
    }

    private int getEditIndex() {
        return this.lastIndex;
    }

    private void setEditIndex(int n) {
        this.lastIndex = n;
    }

    private void resetEditIndex() {
        this.lastIndex = -1;
    }

    private void cancelEdit() {
        if (this.editFile != null) {
            this.editFile = null;
            this.list.remove(this.editCell);
            this.repaint();
        } else if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().cancelCellEditing();
        }
    }

    private void editFileName(int n) {
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getCurrentDirectory();
        if (this.readOnly || !this.canWrite(file)) {
            return;
        }
        this.ensureIndexIsVisible(n);
        switch (this.viewType) {
            case 0: {
                int n2;
                this.editFile = (File)this.getModel().getElementAt(this.getRowSorter().convertRowIndexToModel(n));
                Rectangle rectangle = this.list.getCellBounds(n, n);
                if (this.editCell == null) {
                    this.editCell = new JTextField();
                    this.editCell.setName("Tree.cellEditor");
                    this.editCell.addActionListener(new EditActionListener());
                    this.editCell.addFocusListener(this.editorFocusListener);
                    this.editCell.setNextFocusableComponent(this.list);
                }
                this.list.add(this.editCell);
                this.editCell.setText(jFileChooser.getName(this.editFile));
                ComponentOrientation componentOrientation = this.list.getComponentOrientation();
                this.editCell.setComponentOrientation(componentOrientation);
                Icon icon = jFileChooser.getIcon(this.editFile);
                int n3 = n2 = icon == null ? 20 : icon.getIconWidth() + 4;
                if (componentOrientation.isLeftToRight()) {
                    this.editCell.setBounds(n2 + rectangle.x, rectangle.y, rectangle.width - n2, rectangle.height);
                } else {
                    this.editCell.setBounds(rectangle.x, rectangle.y, rectangle.width - n2, rectangle.height);
                }
                this.editCell.requestFocus();
                this.editCell.selectAll();
                break;
            }
            case 1: {
                this.detailsTable.editCellAt(n, 0);
            }
        }
    }

    private void applyEdit() {
        if (this.editFile != null && this.editFile.exists()) {
            JFileChooser jFileChooser = this.getFileChooser();
            String string = jFileChooser.getName(this.editFile);
            String string2 = this.editFile.getName();
            String string3 = this.editCell.getText().trim();
            if (!string3.equals(string)) {
                FileSystemView fileSystemView;
                File file;
                int n;
                String string4 = string3;
                int n2 = string2.length();
                if (n2 > (n = string.length()) && string2.charAt(n) == '.') {
                    string4 = string3 + string2.substring(n);
                }
                if ((file = (fileSystemView = jFileChooser.getFileSystemView()).createFileObject(this.editFile.getParentFile(), string4)).exists()) {
                    JOptionPane.showMessageDialog(jFileChooser, MessageFormat.format(this.renameErrorFileExistsText, string2), this.renameErrorTitleText, 0);
                } else if (this.getModel().renameFile(this.editFile, file)) {
                    if (fileSystemView.isParent(jFileChooser.getCurrentDirectory(), file)) {
                        if (jFileChooser.isMultiSelectionEnabled()) {
                            jFileChooser.setSelectedFiles(new File[]{file});
                        } else {
                            jFileChooser.setSelectedFile(file);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(jFileChooser, MessageFormat.format(this.renameErrorText, string2), this.renameErrorTitleText, 0);
                }
            }
        }
        if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().stopCellEditing();
        }
        this.cancelEdit();
    }

    public Action getNewFolderAction() {
        if (!this.readOnly && this.newFolderAction == null) {
            this.newFolderAction = new AbstractAction(this.newFolderActionLabelText){
                private Action basicNewFolderAction;
                {
                    this.putValue("ActionCommandKey", FilePane.ACTION_NEW_FOLDER);
                    File file = FilePane.this.getFileChooser().getCurrentDirectory();
                    if (file != null) {
                        this.setEnabled(FilePane.this.canWrite(file));
                    }
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.basicNewFolderAction == null) {
                        this.basicNewFolderAction = FilePane.this.fileChooserUIAccessor.getNewFolderAction();
                    }
                    JFileChooser jFileChooser = FilePane.this.getFileChooser();
                    File file = jFileChooser.getSelectedFile();
                    this.basicNewFolderAction.actionPerformed(actionEvent);
                    File file2 = jFileChooser.getSelectedFile();
                    if (file2 != null && !file2.equals(file) && file2.isDirectory()) {
                        FilePane.this.newFolderFile = file2;
                    }
                }
            };
        }
        return this.newFolderAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            Object[] objectArray = this.getFileChooser().getSelectedFiles();
            Object[] objectArray2 = this.list.getSelectedValues();
            this.listSelectionModel.setValueIsAdjusting(true);
            try {
                int n = this.listSelectionModel.getLeadSelectionIndex();
                int n2 = this.listSelectionModel.getAnchorSelectionIndex();
                Arrays.sort(objectArray);
                Arrays.sort(objectArray2);
                int n3 = 0;
                int n4 = 0;
                while (n3 < objectArray.length && n4 < objectArray2.length) {
                    int n5 = ((File)objectArray[n3]).compareTo((File)objectArray2[n4]);
                    if (n5 < 0) {
                        this.doSelectFile((File)objectArray[n3++]);
                        continue;
                    }
                    if (n5 > 0) {
                        this.doDeselectFile(objectArray2[n4++]);
                        continue;
                    }
                    ++n3;
                    ++n4;
                }
                while (n3 < objectArray.length) {
                    this.doSelectFile((File)objectArray[n3++]);
                }
                while (n4 < objectArray2.length) {
                    this.doDeselectFile(objectArray2[n4++]);
                }
                if (!(this.listSelectionModel instanceof DefaultListSelectionModel)) return;
                ((DefaultListSelectionModel)this.listSelectionModel).moveLeadSelectionIndex(n);
                this.listSelectionModel.setAnchorSelectionIndex(n2);
                return;
            }
            finally {
                this.listSelectionModel.setValueIsAdjusting(false);
            }
        } else {
            int n;
            JFileChooser jFileChooser = this.getFileChooser();
            File file = this.isDirectorySelected() ? this.getDirectory() : jFileChooser.getSelectedFile();
            if (file != null && (n = this.getModel().indexOf(file)) >= 0) {
                int n6 = this.getRowSorter().convertRowIndexToView(n);
                this.listSelectionModel.setSelectionInterval(n6, n6);
                this.ensureIndexIsVisible(n6);
                return;
            } else {
                this.clearSelection();
            }
        }
    }

    private void doSelectFile(File file) {
        int n = this.getModel().indexOf(file);
        if (n >= 0) {
            n = this.getRowSorter().convertRowIndexToView(n);
            this.listSelectionModel.addSelectionInterval(n, n);
        }
    }

    private void doDeselectFile(Object object) {
        int n = this.getRowSorter().convertRowIndexToView(this.getModel().indexOf(object));
        this.listSelectionModel.removeSelectionInterval(n, n);
    }

    private void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File file = (File)propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && (jFileChooser.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && jFileChooser.isDirectorySelectionEnabled())) {
            this.setFileSelected();
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File[] fileArray = (File[])propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (fileArray != null && fileArray.length > 0 && (fileArray.length > 1 || jFileChooser.isDirectorySelectionEnabled() || !fileArray[0].isDirectory())) {
            this.setFileSelected();
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        this.getDetailsTableModel().updateColumnInfo();
        JFileChooser jFileChooser = this.getFileChooser();
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        this.applyEdit();
        this.resetEditIndex();
        this.ensureIndexIsVisible(0);
        File file = jFileChooser.getCurrentDirectory();
        if (file != null) {
            if (!this.readOnly) {
                this.getNewFolderAction().setEnabled(this.canWrite(file));
            }
            this.fileChooserUIAccessor.getChangeToParentDirectoryAction().setEnabled(!fileSystemView.isRoot(file));
        }
        if (this.list != null) {
            this.list.clearSelection();
        }
    }

    private void doFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearSelection();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearSelection();
    }

    private void doMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (this.viewType == -1) {
            this.setViewType(0);
        }
        if ((string = propertyChangeEvent.getPropertyName()).equals("SelectedFileChangedProperty")) {
            this.doSelectedFileChanged(propertyChangeEvent);
        } else if (string.equals("SelectedFilesChangedProperty")) {
            this.doSelectedFilesChanged(propertyChangeEvent);
        } else if (string.equals("directoryChanged")) {
            this.doDirectoryChanged(propertyChangeEvent);
        } else if (string.equals("fileFilterChanged")) {
            this.doFilterChanged(propertyChangeEvent);
        } else if (string.equals("fileSelectionChanged")) {
            this.doFileSelectionModeChanged(propertyChangeEvent);
        } else if (string.equals("MultiSelectionEnabledChangedProperty")) {
            this.doMultiSelectionChanged(propertyChangeEvent);
        } else if (string.equals("CancelSelection")) {
            this.applyEdit();
        } else if (string.equals("busy")) {
            this.setCursor((Boolean)propertyChangeEvent.getNewValue() != false ? waitCursor : null);
        } else if (string.equals("componentOrientation")) {
            ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
            JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
            if (componentOrientation != propertyChangeEvent.getOldValue()) {
                jFileChooser.applyComponentOrientation(componentOrientation);
            }
            if (this.detailsTable != null) {
                this.detailsTable.setComponentOrientation(componentOrientation);
                this.detailsTable.getParent().getParent().setComponentOrientation(componentOrientation);
            }
        }
    }

    private void ensureIndexIsVisible(int n) {
        if (n >= 0) {
            if (this.list != null) {
                this.list.ensureIndexIsVisible(n);
            }
            if (this.detailsTable != null) {
                this.detailsTable.scrollRectToVisible(this.detailsTable.getCellRect(n, 0, true));
            }
        }
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        int n = this.getModel().indexOf(file);
        if (n >= 0) {
            this.ensureIndexIsVisible(this.getRowSorter().convertRowIndexToView(n));
        }
    }

    public void rescanCurrentDirectory() {
        this.getModel().validateFileCache();
    }

    public void clearSelection() {
        if (this.listSelectionModel != null) {
            this.listSelectionModel.clearSelection();
            if (this.listSelectionModel instanceof DefaultListSelectionModel) {
                ((DefaultListSelectionModel)this.listSelectionModel).moveLeadSelectionIndex(0);
                this.listSelectionModel.setAnchorSelectionIndex(0);
            }
        }
    }

    public JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu(this.viewMenuLabelText);
            ButtonGroup buttonGroup = new ButtonGroup();
            for (int i = 0; i < 2; ++i) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new ViewTypeAction(i));
                buttonGroup.add(jRadioButtonMenuItem);
                this.viewMenu.add(jRadioButtonMenuItem);
            }
            this.updateViewMenu();
        }
        return this.viewMenu;
    }

    private void updateViewMenu() {
        if (this.viewMenu != null) {
            Component[] componentArray;
            for (Component component : componentArray = this.viewMenu.getMenuComponents()) {
                JRadioButtonMenuItem jRadioButtonMenuItem;
                if (!(component instanceof JRadioButtonMenuItem) || ((ViewTypeAction)(jRadioButtonMenuItem = (JRadioButtonMenuItem)component).getAction()).viewType != this.viewType) continue;
                jRadioButtonMenuItem.setSelected(true);
            }
        }
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        JPopupMenu jPopupMenu = this.getFileChooser().getComponentPopupMenu();
        if (jPopupMenu != null) {
            return jPopupMenu;
        }
        JMenu jMenu = this.getViewMenu();
        if (this.contextMenu == null) {
            this.contextMenu = new JPopupMenu();
            if (jMenu != null) {
                this.contextMenu.add(jMenu);
                if (this.listViewWindowsStyle) {
                    this.contextMenu.addSeparator();
                }
            }
            ActionMap actionMap = this.getActionMap();
            Action action = actionMap.get(ACTION_REFRESH);
            Action action2 = actionMap.get(ACTION_NEW_FOLDER);
            if (action != null) {
                this.contextMenu.add(action);
                if (this.listViewWindowsStyle && action2 != null) {
                    this.contextMenu.addSeparator();
                }
            }
            if (action2 != null) {
                this.contextMenu.add(action2);
            }
        }
        if (jMenu != null) {
            jMenu.getPopupMenu().setInvoker(jMenu);
        }
        return this.contextMenu;
    }

    protected Handler getMouseHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected boolean isDirectorySelected() {
        return this.fileChooserUIAccessor.isDirectorySelected();
    }

    protected File getDirectory() {
        return this.fileChooserUIAccessor.getDirectory();
    }

    private Component findChildComponent(Container container, Class clazz) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component;
            Component component2 = container.getComponent(i);
            if (clazz.isInstance(component2)) {
                return component2;
            }
            if (!(component2 instanceof Container) || (component = this.findChildComponent((Container)component2, clazz)) == null) continue;
            return component;
        }
        return null;
    }

    public boolean canWrite(File file) {
        if (!file.exists()) {
            return false;
        }
        try {
            if (file instanceof ShellFolder) {
                return file.canWrite();
            }
            if (FilePane.usesShellFolder(this.getFileChooser())) {
                try {
                    return ShellFolder.getShellFolder(file).canWrite();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return false;
                }
            }
            return file.canWrite();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static boolean usesShellFolder(JFileChooser jFileChooser) {
        Boolean bl = (Boolean)jFileChooser.getClientProperty("FileChooser.useShellFolder");
        return bl == null ? jFileChooser.getFileSystemView().equals(FileSystemView.getFileSystemView()) : bl.booleanValue();
    }

    public static interface FileChooserUIAccessor {
        public JFileChooser getFileChooser();

        public BasicDirectoryModel getModel();

        public JPanel createList();

        public JPanel createDetailsView();

        public boolean isDirectorySelected();

        public File getDirectory();

        public Action getApproveSelectionAction();

        public Action getChangeToParentDirectoryAction();

        public Action getNewFolderAction();

        public MouseListener createDoubleClickListener(JList var1);

        public ListSelectionListener createListSelectionListener();
    }

    private class Handler
    implements MouseListener {
        private MouseListener doubleClickListener;

        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JComponent jComponent;
            int n;
            JComponent jComponent2 = (JComponent)mouseEvent.getSource();
            if (jComponent2 instanceof JList) {
                n = SwingUtilities2.loc2IndexFileList(FilePane.this.list, mouseEvent.getPoint());
            } else if (jComponent2 instanceof JTable) {
                jComponent = (JTable)jComponent2;
                Point point = mouseEvent.getPoint();
                n = ((JTable)jComponent).rowAtPoint(point);
                boolean bl = SwingUtilities2.pointOutsidePrefSize((JTable)jComponent, n, ((JTable)jComponent).columnAtPoint(point), point);
                if (bl && !FilePane.this.fullRowSelection) {
                    return;
                }
                if (n >= 0 && FilePane.this.list != null && FilePane.this.listSelectionModel.isSelectedIndex(n)) {
                    Rectangle rectangle = FilePane.this.list.getCellBounds(n, n);
                    mouseEvent = new MouseEvent(FilePane.this.list, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), rectangle.x + 1, rectangle.y + rectangle.height / 2, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                }
            } else {
                return;
            }
            if (n >= 0 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                jComponent = FilePane.this.getFileChooser();
                if (mouseEvent.getClickCount() == 1 && jComponent2 instanceof JList) {
                    if ((!((JFileChooser)jComponent).isMultiSelectionEnabled() || ((JFileChooser)jComponent).getSelectedFiles().length <= 1) && n >= 0 && FilePane.this.listSelectionModel.isSelectedIndex(n) && FilePane.this.getEditIndex() == n && FilePane.this.editFile == null) {
                        FilePane.this.editFileName(n);
                    } else if (n >= 0) {
                        FilePane.this.setEditIndex(n);
                    } else {
                        FilePane.this.resetEditIndex();
                    }
                } else if (mouseEvent.getClickCount() == 2) {
                    FilePane.this.resetEditIndex();
                }
            }
            if (this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseClicked(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            if (jComponent instanceof JTable) {
                boolean bl;
                TransferHandler transferHandler;
                JTable jTable = (JTable)mouseEvent.getSource();
                TransferHandler transferHandler2 = FilePane.this.getFileChooser().getTransferHandler();
                if (transferHandler2 != (transferHandler = jTable.getTransferHandler())) {
                    jTable.setTransferHandler(transferHandler2);
                }
                if ((bl = FilePane.this.getFileChooser().getDragEnabled()) != jTable.getDragEnabled()) {
                    jTable.setDragEnabled(bl);
                }
            } else if (jComponent instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseEntered(mouseEvent);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseExited(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseReleased(mouseEvent);
            }
        }

        private MouseListener getDoubleClickListener() {
            if (this.doubleClickListener == null && FilePane.this.list != null) {
                this.doubleClickListener = FilePane.this.fileChooserUIAccessor.createDoubleClickListener(FilePane.this.list);
            }
            return this.doubleClickListener;
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (FilePane.this.listViewWindowsStyle && !jList.isFocusOwner()) {
                bl = false;
            }
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            File file = (File)object;
            String string = FilePane.this.getFileChooser().getName(file);
            this.setText(string);
            this.setFont(jList.getFont());
            Icon icon = FilePane.this.getFileChooser().getIcon(file);
            if (icon != null) {
                this.setIcon(icon);
            } else if (FilePane.this.getFileChooser().getFileSystemView().isTraversable(file).booleanValue()) {
                this.setText(string + File.separator);
            }
            return this;
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FilePane.this.applyEdit();
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        File editFile;

        DelayedSelectionUpdater() {
            this(null);
        }

        DelayedSelectionUpdater(File file) {
            this.editFile = file;
            if (FilePane.this.isShowing()) {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            FilePane.this.setFileSelected();
            if (this.editFile != null) {
                FilePane.this.editFileName(FilePane.this.getRowSorter().convertRowIndexToView(FilePane.this.getModel().indexOf(this.editFile)));
                this.editFile = null;
            }
        }
    }

    private class AlignableTableHeaderRenderer
    implements TableCellRenderer {
        TableCellRenderer wrappedRenderer;

        public AlignableTableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.wrappedRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.wrappedRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = jTable.convertColumnIndexToModel(n2);
            ShellFolderColumnInfo shellFolderColumnInfo = FilePane.this.detailsTableModel.getColumns()[n3];
            Integer n4 = shellFolderColumnInfo.getAlignment();
            if (n4 == null) {
                n4 = 0;
            }
            if (component instanceof JLabel) {
                ((JLabel)component).setHorizontalAlignment(n4);
            }
            return component;
        }
    }

    class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        JFileChooser chooser;
        DateFormat df;

        DetailsTableCellRenderer(JFileChooser jFileChooser) {
            this.chooser = jFileChooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, jFileChooser.getLocale());
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            if (this.getHorizontalAlignment() == 10 && !FilePane.this.fullRowSelection) {
                n3 = Math.min(n3, this.getPreferredSize().width + 4);
            } else {
                n -= 4;
            }
            super.setBounds(n, n2, n3, n4);
        }

        @Override
        public Insets getInsets(Insets insets) {
            insets = super.getInsets(insets);
            insets.left += 4;
            insets.right += 4;
            return insets;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            if ((jTable.convertColumnIndexToModel(n2) != 0 || FilePane.this.listViewWindowsStyle && !jTable.isFocusOwner()) && !FilePane.this.fullRowSelection) {
                bl = false;
            }
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setIcon(null);
            int n3 = jTable.convertColumnIndexToModel(n2);
            ShellFolderColumnInfo shellFolderColumnInfo = FilePane.this.detailsTableModel.getColumns()[n3];
            Integer n4 = shellFolderColumnInfo.getAlignment();
            if (n4 == null) {
                n4 = object instanceof Number ? 4 : 10;
            }
            this.setHorizontalAlignment(n4);
            if (object == null) {
                string = "";
            } else if (object instanceof File) {
                File file = (File)object;
                string = this.chooser.getName(file);
                Icon icon = this.chooser.getIcon(file);
                this.setIcon(icon);
            } else if (object instanceof Long) {
                long l = (Long)object / 1024L;
                string = FilePane.this.listViewWindowsStyle ? MessageFormat.format(FilePane.this.kiloByteString, l + 1L) : (l < 1024L ? MessageFormat.format(FilePane.this.kiloByteString, l == 0L ? 1L : l) : ((l /= 1024L) < 1024L ? MessageFormat.format(FilePane.this.megaByteString, l) : MessageFormat.format(FilePane.this.gigaByteString, l /= 1024L)));
            } else {
                string = object instanceof Date ? this.df.format((Date)object) : object.toString();
            }
            this.setText(string);
            return this;
        }
    }

    private class DetailsTableCellEditor
    extends DefaultCellEditor {
        private final JTextField tf;

        public DetailsTableCellEditor(JTextField jTextField) {
            super(jTextField);
            this.tf = jTextField;
            jTextField.setName("Table.editor");
            jTextField.addFocusListener(FilePane.this.editorFocusListener);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            if (object instanceof File) {
                this.tf.setText(FilePane.this.getFileChooser().getName((File)object));
                this.tf.selectAll();
            }
            return component;
        }
    }

    private class DirectoriesFirstComparatorWrapper
    implements Comparator<File> {
        private Comparator comparator;
        private int column;

        public DirectoriesFirstComparatorWrapper(int n, Comparator comparator) {
            this.column = n;
            this.comparator = comparator;
        }

        @Override
        public int compare(File file, File file2) {
            if (file != null && file2 != null) {
                boolean bl = FilePane.this.getFileChooser().isTraversable(file);
                boolean bl2 = FilePane.this.getFileChooser().isTraversable(file2);
                if (bl && !bl2) {
                    return -1;
                }
                if (!bl && bl2) {
                    return 1;
                }
            }
            if (FilePane.this.detailsTableModel.getColumns()[this.column].isCompareByColumn()) {
                return this.comparator.compare(FilePane.this.getDetailsTableModel().getFileColumnValue(file, this.column), FilePane.this.getDetailsTableModel().getFileColumnValue(file2, this.column));
            }
            return this.comparator.compare(file, file2);
        }
    }

    private class DetailsTableRowSorter
    extends TableRowSorter<TableModel> {
        public DetailsTableRowSorter() {
            this.setModelWrapper(new SorterModelWrapper());
        }

        public void updateComparators(ShellFolderColumnInfo[] shellFolderColumnInfoArray) {
            for (int i = 0; i < shellFolderColumnInfoArray.length; ++i) {
                Comparator comparator = shellFolderColumnInfoArray[i].getComparator();
                if (comparator != null) {
                    comparator = new DirectoriesFirstComparatorWrapper(i, comparator);
                }
                this.setComparator(i, comparator);
            }
        }

        @Override
        public void sort() {
            ShellFolder.invoke(new Callable<Void>(){

                @Override
                public Void call() {
                    DetailsTableRowSorter.super.sort();
                    return null;
                }
            });
        }

        @Override
        public void modelStructureChanged() {
            super.modelStructureChanged();
            this.updateComparators(FilePane.this.detailsTableModel.getColumns());
        }

        private class SorterModelWrapper
        extends DefaultRowSorter.ModelWrapper<TableModel, Integer> {
            private SorterModelWrapper() {
            }

            @Override
            public TableModel getModel() {
                return FilePane.this.getDetailsTableModel();
            }

            @Override
            public int getColumnCount() {
                return FilePane.this.getDetailsTableModel().getColumnCount();
            }

            @Override
            public int getRowCount() {
                return FilePane.this.getDetailsTableModel().getRowCount();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return FilePane.this.getModel().getElementAt(n);
            }

            @Override
            public Integer getIdentifier(int n) {
                return n;
            }
        }
    }

    class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener {
        JFileChooser chooser;
        BasicDirectoryModel directoryModel;
        ShellFolderColumnInfo[] columns;
        int[] columnMap;

        DetailsTableModel(JFileChooser jFileChooser) {
            this.chooser = jFileChooser;
            this.directoryModel = FilePane.this.getModel();
            this.directoryModel.addListDataListener(this);
            this.updateColumnInfo();
        }

        void updateColumnInfo() {
            File file = this.chooser.getCurrentDirectory();
            if (file != null && FilePane.usesShellFolder(this.chooser)) {
                try {
                    file = ShellFolder.getShellFolder(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            ShellFolderColumnInfo[] shellFolderColumnInfoArray = ShellFolder.getFolderColumns(file);
            ArrayList<ShellFolderColumnInfo> arrayList = new ArrayList<ShellFolderColumnInfo>();
            this.columnMap = new int[shellFolderColumnInfoArray.length];
            for (int i = 0; i < shellFolderColumnInfoArray.length; ++i) {
                ShellFolderColumnInfo shellFolderColumnInfo = shellFolderColumnInfoArray[i];
                if (!shellFolderColumnInfo.isVisible()) continue;
                this.columnMap[arrayList.size()] = i;
                arrayList.add(shellFolderColumnInfo);
            }
            this.columns = new ShellFolderColumnInfo[arrayList.size()];
            arrayList.toArray(this.columns);
            this.columnMap = Arrays.copyOf(this.columnMap, this.columns.length);
            List<RowSorter.SortKey> list = FilePane.this.rowSorter == null ? null : FilePane.this.rowSorter.getSortKeys();
            this.fireTableStructureChanged();
            this.restoreSortKeys(list);
        }

        private void restoreSortKeys(List<? extends RowSorter.SortKey> list) {
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    RowSorter.SortKey sortKey = list.get(i);
                    if (sortKey.getColumn() < this.columns.length) continue;
                    list = null;
                    break;
                }
                if (list != null) {
                    FilePane.this.rowSorter.setSortKeys(list);
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.directoryModel.getSize();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.getFileColumnValue((File)this.directoryModel.getElementAt(n), n2);
        }

        private Object getFileColumnValue(File file, int n) {
            return n == 0 ? file : ShellFolder.getFolderColumnValue(file, this.columnMap[n]);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                final JFileChooser jFileChooser = FilePane.this.getFileChooser();
                File file = (File)this.getValueAt(n, n2);
                if (file != null) {
                    String string = jFileChooser.getName(file);
                    String string2 = file.getName();
                    String string3 = ((String)object).trim();
                    if (!string3.equals(string)) {
                        FileSystemView fileSystemView;
                        File file2;
                        int n3;
                        String string4 = string3;
                        int n4 = string2.length();
                        if (n4 > (n3 = string.length()) && string2.charAt(n3) == '.') {
                            string4 = string3 + string2.substring(n3);
                        }
                        if ((file2 = (fileSystemView = jFileChooser.getFileSystemView()).createFileObject(file.getParentFile(), string4)).exists()) {
                            JOptionPane.showMessageDialog(jFileChooser, MessageFormat.format(FilePane.this.renameErrorFileExistsText, string2), FilePane.this.renameErrorTitleText, 0);
                        } else if (FilePane.this.getModel().renameFile(file, file2)) {
                            if (fileSystemView.isParent(jFileChooser.getCurrentDirectory(), file2)) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (jFileChooser.isMultiSelectionEnabled()) {
                                            jFileChooser.setSelectedFiles(new File[]{file2});
                                        } else {
                                            jFileChooser.setSelectedFile(file2);
                                        }
                                    }
                                });
                            }
                        } else {
                            JOptionPane.showMessageDialog(jFileChooser, MessageFormat.format(FilePane.this.renameErrorText, string2), FilePane.this.renameErrorTitleText, 0);
                        }
                    }
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            File file = FilePane.this.getFileChooser().getCurrentDirectory();
            return !FilePane.this.readOnly && n2 == 0 && FilePane.this.canWrite(file);
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            new DelayedSelectionUpdater();
            this.fireTableDataChanged();
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            File file;
            int n;
            int n2 = listDataEvent.getIndex0();
            if (n2 == (n = listDataEvent.getIndex1()) && (file = (File)FilePane.this.getModel().getElementAt(n2)).equals(FilePane.this.newFolderFile)) {
                new DelayedSelectionUpdater(file);
                FilePane.this.newFolderFile = null;
            }
            this.fireTableRowsInserted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireTableRowsDeleted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        public ShellFolderColumnInfo[] getColumns() {
            return this.columns;
        }
    }

    private class SortableListModel
    extends AbstractListModel<Object>
    implements TableModelListener,
    RowSorterListener {
        public SortableListModel() {
            FilePane.this.getDetailsTableModel().addTableModelListener(this);
            FilePane.this.getRowSorter().addRowSorterListener(this);
        }

        @Override
        public int getSize() {
            return FilePane.this.getModel().getSize();
        }

        @Override
        public Object getElementAt(int n) {
            return FilePane.this.getModel().getElementAt(FilePane.this.getRowSorter().convertRowIndexToModel(n));
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public void sorterChanged(RowSorterEvent rowSorterEvent) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    class ViewTypeAction
    extends AbstractAction {
        private int viewType;

        ViewTypeAction(int n) {
            String string;
            super(FilePane.this.viewTypeActionNames[n]);
            this.viewType = n;
            switch (n) {
                case 0: {
                    string = FilePane.ACTION_VIEW_LIST;
                    break;
                }
                case 1: {
                    string = FilePane.ACTION_VIEW_DETAILS;
                    break;
                }
                default: {
                    string = (String)this.getValue("Name");
                }
            }
            this.putValue("ActionCommandKey", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FilePane.this.setViewType(this.viewType);
        }
    }
}

