<?php
// @codingStandardsIgnoreFile
/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 8.0 db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();

$connection->schema()->createTable('access', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'mask' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('actions', array(
  'fields' => array(
    'aid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'parameters' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'description' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('actions')
->fields(array(
  'aid',
  'type',
  'callback',
  'parameters',
  'description',
))
->values(array(
  'aid' => '1',
  'type' => 'comment',
  'callback' => 'comment_unpublish_by_keyword_action',
  'parameters' => 'a:1:{s:8:"keywords";a:1:{i:0;s:6:"drupal";}}',
  'description' => 'Unpublish comment containing keyword(s)',
))
->values(array(
  'aid' => '2',
  'type' => 'node',
  'callback' => 'node_assign_owner_action',
  'parameters' => 'a:1:{s:9:"owner_uid";s:1:"2";}',
  'description' => 'Change the author of a post',
))
->values(array(
  'aid' => '3',
  'type' => 'node',
  'callback' => 'node_unpublish_by_keyword_action',
  'parameters' => 'a:1:{s:8:"keywords";a:1:{i:0;s:6:"drupal";}}',
  'description' => 'Unpublish post containing keyword(s)',
))
->values(array(
  'aid' => '4',
  'type' => 'system',
  'callback' => 'system_message_action',
  'parameters' => 'a:1:{s:7:"message";s:21:"Drupal migration test";}',
  'description' => 'Display a message to the user',
))
->values(array(
  'aid' => '5',
  'type' => 'system',
  'callback' => 'system_send_email_action',
  'parameters' => 'a:3:{s:9:"recipient";s:16:"test@example.com";s:7:"subject";s:21:"Drupal migration test";s:7:"message";s:21:"Drupal migration test";}',
  'description' => 'Send e-mail',
))
->values(array(
  'aid' => '6',
  'type' => 'system',
  'callback' => 'system_goto_action',
  'parameters' => 'a:1:{s:3:"url";s:22:"https://www.drupal.org";}',
  'description' => 'Redirect to URL',
))
->values(array(
  'aid' => 'comment_publish_action',
  'type' => 'comment',
  'callback' => 'comment_publish_action',
  'parameters' => '',
  'description' => 'Publish comment',
))
->values(array(
  'aid' => 'comment_unpublish_action',
  'type' => 'comment',
  'callback' => 'comment_unpublish_action',
  'parameters' => '',
  'description' => 'Unpublish comment',
))
->values(array(
  'aid' => 'imagecache_flush_action',
  'type' => 'node',
  'callback' => 'imagecache_flush_action',
  'parameters' => '',
  'description' => "ImageCache: Flush ALL presets for this node's filefield images",
))
->values(array(
  'aid' => 'imagecache_generate_all_action',
  'type' => 'node',
  'callback' => 'imagecache_generate_all_action',
  'parameters' => '',
  'description' => "ImageCache: Generate ALL presets for this node's filefield images",
))
->values(array(
  'aid' => 'node_make_sticky_action',
  'type' => 'node',
  'callback' => 'node_make_sticky_action',
  'parameters' => '',
  'description' => 'Make post sticky',
))
->values(array(
  'aid' => 'node_make_unsticky_action',
  'type' => 'node',
  'callback' => 'node_make_unsticky_action',
  'parameters' => '',
  'description' => 'Make post unsticky',
))
->values(array(
  'aid' => 'node_promote_action',
  'type' => 'node',
  'callback' => 'node_promote_action',
  'parameters' => '',
  'description' => 'Promote post to front page',
))
->values(array(
  'aid' => 'node_publish_action',
  'type' => 'node',
  'callback' => 'node_publish_action',
  'parameters' => '',
  'description' => 'Publish post',
))
->values(array(
  'aid' => 'node_save_action',
  'type' => 'node',
  'callback' => 'node_save_action',
  'parameters' => '',
  'description' => 'Save post',
))
->values(array(
  'aid' => 'node_unpromote_action',
  'type' => 'node',
  'callback' => 'node_unpromote_action',
  'parameters' => '',
  'description' => 'Remove post from front page',
))
->values(array(
  'aid' => 'node_unpublish_action',
  'type' => 'node',
  'callback' => 'node_unpublish_action',
  'parameters' => '',
  'description' => 'Unpublish post',
))
->values(array(
  'aid' => 'user_block_ip_action',
  'type' => 'user',
  'callback' => 'user_block_ip_action',
  'parameters' => '',
  'description' => 'Ban IP address of current user',
))
->values(array(
  'aid' => 'user_block_user_action',
  'type' => 'user',
  'callback' => 'user_block_user_action',
  'parameters' => '',
  'description' => 'Block current user',
))
->execute();

$connection->schema()->createTable('actions_aid', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('actions_aid')
->fields(array(
  'aid',
))
->values(array(
  'aid' => '1',
))
->values(array(
  'aid' => '2',
))
->values(array(
  'aid' => '3',
))
->values(array(
  'aid' => '4',
))
->values(array(
  'aid' => '5',
))
->values(array(
  'aid' => '6',
))
->execute();

$connection->schema()->createTable('aggregator_category', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'block' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('aggregator_feed', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'url' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'refresh' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'checked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'link' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'image' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'etag' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'modified' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'block' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('aggregator_feed')
->fields(array(
  'fid',
  'title',
  'url',
  'refresh',
  'checked',
  'link',
  'description',
  'image',
  'etag',
  'modified',
  'block',
))
->values(array(
  'fid' => '5',
  'title' => 'Know Your Meme',
  'url' => 'http://knowyourmeme.com/newsfeed.rss',
  'refresh' => '900',
  'checked' => '1387659487',
  'link' => 'http://knowyourmeme.com',
  'description' => 'New items added to the News Feed',
  'image' => 'http://b.thumbs.redditmedia.com/harEHsUUZVajabtC.png',
  'etag' => '"213cc1365b96c310e92053c5551f0504"',
  'modified' => '0',
  'block' => '5',
))
->execute();

$connection->schema()->createTable('aggregator_item', array(
  'fields' => array(
    'iid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'fid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'link' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'author' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'guid' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'iid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('aggregator_item')
->fields(array(
  'iid',
  'fid',
  'title',
  'link',
  'author',
  'description',
  'timestamp',
  'guid',
))
->values(array(
  'iid' => '1',
  'fid' => '5',
  'title' => 'This (three) weeks in Drupal Core - January 10th 2014',
  'link' => 'https://groups.drupal.org/node/395218',
  'author' => 'larowlan',
  'description' => "<h2 id='new'>What's new with Drupal 8?</h2>",
  'timestamp' => '1389297196',
  'guid' => '395218 at https://groups.drupal.org',
))
->execute();

$connection->schema()->createTable('authmap', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'authname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('batch', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'token' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'batch' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('blocks', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '0',
    ),
    'theme' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'region' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'throttle' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'visibility' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'pages' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('blocks')
->fields(array(
  'bid',
  'module',
  'delta',
  'theme',
  'status',
  'weight',
  'region',
  'custom',
  'throttle',
  'visibility',
  'pages',
  'title',
  'cache',
))
->values(array(
  'bid' => '1',
  'module' => 'user',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '0',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => "<front>\r\nnode/1\nblog/*",
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '2',
  'module' => 'user',
  'delta' => '1',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '0',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '3',
  'module' => 'system',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-5',
  'region' => 'footer',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => 'node/1',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '4',
  'module' => 'comment',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-9',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '5',
  'module' => 'menu',
  'delta' => 'primary-links',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-5',
  'region' => 'header',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '6',
  'module' => 'menu',
  'delta' => 'secondary-links',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-8',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '7',
  'module' => 'node',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-7',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '8',
  'module' => 'user',
  'delta' => '2',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-9',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '9',
  'module' => 'user',
  'delta' => '3',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-6',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '10',
  'module' => 'block',
  'delta' => '1',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '0',
  'region' => 'content',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '1',
  'pages' => '<front>',
  'title' => 'Static Block',
  'cache' => '-1',
))
->values(array(
  'bid' => '11',
  'module' => 'block',
  'delta' => '2',
  'theme' => 'bluemarine',
  'status' => '1',
  'weight' => '-4',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '1',
  'pages' => 'node',
  'title' => 'Another Static Block',
  'cache' => '-1',
))
->values(array(
  'bid' => '12',
  'module' => 'block',
  'delta' => '1',
  'theme' => 'test_theme',
  'status' => '1',
  'weight' => '-7',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '13',
  'module' => 'block',
  'delta' => '2',
  'theme' => 'test_theme',
  'status' => '1',
  'weight' => '-2',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '2',
  'pages' => "<?php\nreturn TRUE;",
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '14',
  'module' => 'aggregator',
  'delta' => 'feed-5',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-2',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '15',
  'module' => 'block',
  'delta' => '2',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '1',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '16',
  'module' => 'profile',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-5',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '5',
))
->values(array(
  'bid' => '17',
  'module' => 'event',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-3',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '18',
  'module' => 'event',
  'delta' => '1',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '0',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '19',
  'module' => 'event',
  'delta' => 'event-upcoming-event',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-1',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '20',
  'module' => 'book',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-4',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '5',
))
->values(array(
  'bid' => '21',
  'module' => 'locale',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '0',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->execute();

$connection->schema()->createTable('blocks_roles', array(
  'fields' => array(
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'module',
    'delta',
    'rid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('blocks_roles')
->fields(array(
  'module',
  'delta',
  'rid',
))
->values(array(
  'module' => 'user',
  'delta' => '2',
  'rid' => '2',
))
->values(array(
  'module' => 'user',
  'delta' => '3',
  'rid' => '3',
))
->execute();

$connection->schema()->createTable('book', array(
  'fields' => array(
    'mlid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'bid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'mlid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('book')
->fields(array(
  'mlid',
  'nid',
  'bid',
))
->values(array(
  'mlid' => '1',
  'nid' => '4',
  'bid' => '4',
))
->values(array(
  'mlid' => '2',
  'nid' => '5',
  'bid' => '4',
))
->values(array(
  'mlid' => '3',
  'nid' => '6',
  'bid' => '4',
))
->values(array(
  'mlid' => '4',
  'nid' => '7',
  'bid' => '4',
))
->values(array(
  'mlid' => '5',
  'nid' => '8',
  'bid' => '8',
))
->execute();

$connection->schema()->createTable('boxes', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'info' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('boxes')
->fields(array(
  'bid',
  'body',
  'info',
  'format',
))
->values(array(
  'bid' => '1',
  'body' => '<h3>My first custom block body</h3>',
  'info' => 'My block 1',
  'format' => '2',
))
->values(array(
  'bid' => '2',
  'body' => '<h3>My second custom block body</h3>',
  'info' => 'My block 2',
  'format' => '2',
))
->execute();

$connection->schema()->createTable('cache', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_block', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_bootstrap', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'checksum_invalidations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'checksum_deletions' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_config', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'checksum_invalidations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'checksum_deletions' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_content', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_discovery', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'checksum_invalidations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'checksum_deletions' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_filter', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_form', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_menu', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_page', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_update', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cachetags', array(
  'fields' => array(
    'tag' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'invalidations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'deletions' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'tag',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('comments', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'pid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'subject' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'comment' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'thread' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ),
    'mail' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '64',
    ),
    'homepage' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'pid' => array(
      'pid',
    ),
    'comment_uid' => array(
      'uid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('comments')
->fields(array(
  'cid',
  'pid',
  'nid',
  'uid',
  'subject',
  'comment',
  'hostname',
  'timestamp',
  'status',
  'format',
  'thread',
  'name',
  'mail',
  'homepage',
))
->values(array(
  'cid' => '1',
  'pid' => '0',
  'nid' => '1',
  'uid' => '0',
  'subject' => 'The first comment.',
  'comment' => 'The first comment body.',
  'hostname' => '127.0.0.1',
  'timestamp' => '1390264918',
  'status' => '0',
  'format' => '1',
  'thread' => '01/',
  'name' => '1st comment author name',
  'mail' => 'comment1@example.com',
  'homepage' => 'https://www.drupal.org',
))
->values(array(
  'cid' => '2',
  'pid' => '3',
  'nid' => '1',
  'uid' => '0',
  'subject' => 'The response to the second comment.',
  'comment' => 'The second comment response body.',
  'hostname' => '127.0.0.1',
  'timestamp' => '1390264938',
  'status' => '0',
  'format' => '1',
  'thread' => '02/01',
  'name' => '3rd comment author name',
  'mail' => 'comment3@example.com',
  'homepage' => 'https://www.drupal.org',
))
->values(array(
  'cid' => '3',
  'pid' => '0',
  'nid' => '1',
  'uid' => '0',
  'subject' => 'The second comment.',
  'comment' => 'The second comment body.',
  'hostname' => '127.0.0.1',
  'timestamp' => '1390264948',
  'status' => '1',
  'format' => '1',
  'thread' => '02/',
  'name' => '3rd comment author name',
  'mail' => 'comment3@example.com',
  'homepage' => 'https://www.drupal.org',
))
->execute();

$connection->schema()->createTable('config', array(
  'fields' => array(
    'collection' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'collection',
    'name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('config')
->fields(array(
  'collection',
  'name',
  'data',
))
->values(array(
  'collection' => '',
  'name' => 'system.file',
  'data' => 'a:1:{s:4:"path";a:1:{s:9:"temporary";s:4:"/tmp";}}',
))
->execute();

$connection->schema()->createTable('contact', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'category' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'recipients' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'reply' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'selected' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('contact')
->fields(array(
  'cid',
  'category',
  'recipients',
  'reply',
  'weight',
  'selected',
))
->values(array(
  'cid' => '1',
  'category' => 'Website feedback',
  'recipients' => 'admin@example.com',
  'reply' => '',
  'weight' => '0',
  'selected' => '0',
))
->values(array(
  'cid' => '2',
  'category' => 'Some other category',
  'recipients' => 'test@example.com',
  'reply' => 'Thanks for contacting us, we will reply ASAP!',
  'weight' => '1',
  'selected' => '1',
))
->values(array(
  'cid' => '3',
  'category' => 'A category much longer than thirty two characters',
  'recipients' => 'fortyninechars@example.com',
  'reply' => '',
  'weight' => '2',
  'selected' => '0',
))
->execute();

$connection->schema()->createTable('content_field_image', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_image_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_image_list' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_image_data' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_field_image')
->fields(array(
  'vid',
  'nid',
  'field_image_fid',
  'field_image_list',
  'field_image_data',
))
->values(array(
  'vid' => '1',
  'nid' => '1',
  'field_image_fid' => '2',
  'field_image_list' => '1',
  'field_image_data' => 'a:2:{s:3:"alt";s:0:"";s:5:"title";s:0:"";}',
))
->values(array(
  'vid' => '2',
  'nid' => '2',
  'field_image_fid' => NULL,
  'field_image_list' => NULL,
  'field_image_data' => NULL,
))
->values(array(
  'vid' => '3',
  'nid' => '1',
  'field_image_fid' => '2',
  'field_image_list' => '1',
  'field_image_data' => 'a:2:{s:3:"alt";s:0:"";s:5:"title";s:0:"";}',
))
->execute();

$connection->schema()->createTable('content_field_multivalue', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_multivalue_value' => array(
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '2',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
    'delta',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_field_multivalue')
->fields(array(
  'vid',
  'nid',
  'field_multivalue_value',
  'delta',
))
->values(array(
  'vid' => '4',
  'nid' => '3',
  'field_multivalue_value' => '33.00',
  'delta' => '0',
))
->values(array(
  'vid' => '4',
  'nid' => '3',
  'field_multivalue_value' => '44.00',
  'delta' => '1',
))
->execute();

$connection->schema()->createTable('content_field_test', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_test_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_format' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_field_test')
->fields(array(
  'vid',
  'nid',
  'field_test_value',
  'field_test_format',
))
->values(array(
  'vid' => '1',
  'nid' => '1',
  'field_test_value' => 'This is a shared text field',
  'field_test_format' => '1',
))
->values(array(
  'vid' => '2',
  'nid' => '1',
  'field_test_value' => 'This is a shared text field',
  'field_test_format' => '1',
))
->values(array(
  'vid' => '3',
  'nid' => '2',
  'field_test_value' => NULL,
  'field_test_format' => NULL,
))
->values(array(
  'vid' => '5',
  'nid' => '2',
  'field_test_value' => NULL,
  'field_test_format' => NULL,
))
->values(array(
  'vid' => '12',
  'nid' => '9',
  'field_test_value' => 'text for default value',
  'field_test_format' => '1',
))
->execute();

$connection->schema()->createTable('content_field_test_text_single_checkbox', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_test_text_single_checkbox_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_field_test_text_single_checkbox')
->fields(array(
  'vid',
  'nid',
  'field_test_text_single_checkbox_value',
))
->values(array(
  'vid' => '1',
  'nid' => '1',
  'field_test_text_single_checkbox_value' => '0',
))
->values(array(
  'vid' => '2',
  'nid' => '1',
  'field_test_text_single_checkbox_value' => NULL,
))
->values(array(
  'vid' => '3',
  'nid' => '2',
  'field_test_text_single_checkbox_value' => NULL,
))
->values(array(
  'vid' => '5',
  'nid' => '2',
  'field_test_text_single_checkbox_value' => NULL,
))
->values(array(
  'vid' => '12',
  'nid' => '9',
  'field_test_text_single_checkbox_value' => '0',
))
->execute();

$connection->schema()->createTable('content_field_test_two', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_test_two_value' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'vid',
    'delta',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_field_test_two')
->fields(array(
  'vid',
  'nid',
  'delta',
  'field_test_two_value',
))
->values(array(
  'vid' => '1',
  'nid' => '1',
  'delta' => '0',
  'field_test_two_value' => '10',
))
->values(array(
  'vid' => '2',
  'nid' => '1',
  'delta' => '0',
  'field_test_two_value' => NULL,
))
->values(array(
  'vid' => '3',
  'nid' => '2',
  'delta' => '0',
  'field_test_two_value' => NULL,
))
->values(array(
  'vid' => '5',
  'nid' => '2',
  'delta' => '0',
  'field_test_two_value' => NULL,
))
->values(array(
  'vid' => '12',
  'nid' => '9',
  'delta' => '0',
  'field_test_two_value' => NULL,
))
->values(array(
  'vid' => '1',
  'nid' => '1',
  'delta' => '1',
  'field_test_two_value' => '20',
))
->execute();

$connection->schema()->createTable('content_group', array(
  'fields' => array(
    'group_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => 'standard',
    ),
    'type_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'group_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'settings' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'type_name',
    'group_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('content_group_fields', array(
  'fields' => array(
    'type_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'group_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'type_name',
    'group_name',
    'field_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('content_node_field', array(
  'fields' => array(
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '127',
      'default' => '',
    ),
    'global_settings' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'required' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'multiple' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'db_storage' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '127',
      'default' => '',
    ),
    'db_columns' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'active' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'field_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_node_field')
->fields(array(
  'field_name',
  'type',
  'global_settings',
  'required',
  'multiple',
  'db_storage',
  'module',
  'db_columns',
  'active',
  'locked',
))
->values(array(
  'field_name' => 'field_multivalue',
  'type' => 'number_decimal',
  'global_settings' => 'a:9:{s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:3:"min";s:0:"";s:3:"max";s:0:"";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";s:9:"precision";s:2:"10";s:5:"scale";s:1:"2";s:7:"decimal";s:1:".";}',
  'required' => '0',
  'multiple' => '1',
  'db_storage' => '0',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:5:{s:4:"type";s:7:"numeric";s:9:"precision";s:2:"10";s:5:"scale";s:1:"2";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test',
  'type' => 'text',
  'global_settings' => 'a:4:{s:15:"text_processing";s:1:"1";s:10:"max_length";s:0:"";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '0',
  'module' => 'text',
  'db_columns' => 'a:2:{s:5:"value";a:5:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;s:8:"sortable";b:1;s:5:"views";b:1;}s:6:"format";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;s:5:"views";b:0;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_date',
  'type' => 'date',
  'global_settings' => 'a:7:{s:11:"granularity";a:5:{s:4:"year";s:4:"year";s:5:"month";s:5:"month";s:3:"day";s:3:"day";s:4:"hour";s:4:"hour";s:6:"minute";s:6:"minute";}s:11:"timezone_db";s:3:"UTC";s:11:"tz_handling";s:4:"site";s:6:"todate";s:0:"";s:6:"repeat";i:0;s:16:"repeat_collapsed";s:0:"";s:14:"default_format";s:6:"medium";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'date',
  'db_columns' => 'a:1:{s:5:"value";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:20;s:8:"not null";b:0;s:8:"sortable";b:1;s:5:"views";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_datestamp',
  'type' => 'datestamp',
  'global_settings' => 'a:7:{s:11:"granularity";a:5:{s:4:"year";s:4:"year";s:5:"month";s:5:"month";s:3:"day";s:3:"day";s:4:"hour";s:4:"hour";s:6:"minute";s:6:"minute";}s:11:"timezone_db";s:3:"UTC";s:11:"tz_handling";s:4:"site";s:6:"todate";s:0:"";s:6:"repeat";i:0;s:16:"repeat_collapsed";s:0:"";s:14:"default_format";s:6:"medium";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'date',
  'db_columns' => 'a:1:{s:5:"value";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:0;s:8:"sortable";b:1;s:5:"views";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_datetime',
  'type' => 'datetime',
  'global_settings' => 'a:7:{s:11:"granularity";a:5:{s:4:"year";s:4:"year";s:5:"month";s:5:"month";s:3:"day";s:3:"day";s:4:"hour";s:4:"hour";s:6:"minute";s:6:"minute";}s:11:"timezone_db";s:3:"UTC";s:11:"tz_handling";s:4:"site";s:6:"todate";s:0:"";s:6:"repeat";i:0;s:16:"repeat_collapsed";s:0:"";s:14:"default_format";s:6:"medium";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'date',
  'db_columns' => 'a:1:{s:5:"value";a:4:{s:4:"type";s:8:"datetime";s:8:"not null";b:0;s:8:"sortable";b:1;s:5:"views";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_decimal_radio_buttons',
  'type' => 'number_decimal',
  'global_settings' => "a:9:{s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:14:\"allowed_values\";s:8:\"1.2\r\n2.1\";s:18:\"allowed_values_php\";s:0:\"\";s:9:\"precision\";s:2:\"10\";s:5:\"scale\";s:1:\"2\";s:7:\"decimal\";s:1:\".\";}",
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:5:{s:4:"type";s:7:"numeric";s:9:"precision";s:2:"10";s:5:"scale";s:1:"2";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_email',
  'type' => 'email',
  'global_settings' => 'a:0:{}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'email',
  'db_columns' => 'a:1:{s:5:"email";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_exclude_unset',
  'type' => 'text',
  'global_settings' => 'a:4:{s:15:"text_processing";s:1:"1";s:10:"max_length";s:0:"";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'text',
  'db_columns' => 'a:2:{s:5:"value";a:5:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;s:8:"sortable";b:1;s:5:"views";b:1;}s:6:"format";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;s:5:"views";b:0;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_filefield',
  'type' => 'filefield',
  'global_settings' => 'a:3:{s:10:"list_field";s:1:"0";s:12:"list_default";i:1;s:17:"description_field";s:1:"1";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'filefield',
  'db_columns' => 'a:3:{s:3:"fid";a:3:{s:4:"type";s:3:"int";s:8:"not null";b:0;s:5:"views";b:1;}s:4:"list";a:4:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;s:5:"views";b:1;}s:4:"data";a:3:{s:4:"type";s:4:"text";s:9:"serialize";b:1;s:5:"views";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_float_single_checkbox',
  'type' => 'number_float',
  'global_settings' => "a:6:{s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:14:\"allowed_values\";s:12:\"3.142\r\n1.234\";s:18:\"allowed_values_php\";s:0:\"\";}",
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:3:{s:4:"type";s:5:"float";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_four',
  'type' => 'number_float',
  'global_settings' => 'a:6:{s:6:"prefix";s:3:"id-";s:6:"suffix";s:0:"";s:3:"min";s:3:"100";s:3:"max";s:3:"200";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:3:{s:4:"type";s:5:"float";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_identical1',
  'type' => 'number_integer',
  'global_settings' => 'a:6:{s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:3:"min";s:0:"";s:3:"max";s:0:"";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_identical2',
  'type' => 'number_integer',
  'global_settings' => 'a:6:{s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:3:"min";s:0:"";s:3:"max";s:0:"";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_imagefield',
  'type' => 'filefield',
  'global_settings' => 'a:3:{s:10:"list_field";s:1:"0";s:12:"list_default";i:1;s:17:"description_field";s:1:"0";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'filefield',
  'db_columns' => 'a:3:{s:3:"fid";a:3:{s:4:"type";s:3:"int";s:8:"not null";b:0;s:5:"views";b:1;}s:4:"list";a:4:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;s:5:"views";b:1;}s:4:"data";a:3:{s:4:"type";s:4:"text";s:9:"serialize";b:1;s:5:"views";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_integer_selectlist',
  'type' => 'number_integer',
  'global_settings' => "a:6:{s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:14:\"allowed_values\";s:22:\"1234\r\n2341\r\n3412\r\n4123\";s:18:\"allowed_values_php\";s:0:\"\";}",
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_link',
  'type' => 'link',
  'global_settings' => 'a:7:{s:10:"attributes";a:4:{s:6:"target";s:4:"user";s:3:"rel";s:8:"nofollow";s:5:"class";s:0:"";s:5:"title";s:10:"Link Title";}s:7:"display";a:1:{s:10:"url_cutoff";s:2:"80";}s:3:"url";i:0;s:5:"title";s:8:"required";s:11:"title_value";s:0:"";s:13:"enable_tokens";s:0:"";s:12:"validate_url";i:1;}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'link',
  'db_columns' => 'a:3:{s:3:"url";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:2048;s:8:"not null";b:0;s:8:"sortable";b:1;}s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;s:8:"sortable";b:1;}s:10:"attributes";a:3:{s:4:"type";s:4:"text";s:4:"size";s:6:"medium";s:8:"not null";b:0;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_phone',
  'type' => 'au_phone',
  'global_settings' => 'a:1:{s:18:"phone_country_code";i:0;}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'phone',
  'db_columns' => 'a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_text_single_checkbox',
  'type' => 'text',
  'global_settings' => "a:4:{s:15:\"text_processing\";s:1:\"0\";s:10:\"max_length\";s:0:\"\";s:14:\"allowed_values\";s:18:\"0|Hello\r\n1|Goodbye\";s:18:\"allowed_values_php\";s:0:\"\";}",
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '0',
  'module' => 'text',
  'db_columns' => 'a:1:{s:5:"value";a:5:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;s:8:"sortable";b:1;s:5:"views";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_text_single_checkbox2',
  'type' => 'text',
  'global_settings' => "a:4:{s:15:\"text_processing\";s:1:\"0\";s:10:\"max_length\";s:0:\"\";s:14:\"allowed_values\";s:10:\"Off\r\nHello\";s:18:\"allowed_values_php\";s:0:\"\";}",
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'text',
  'db_columns' => 'a:1:{s:5:"value";a:5:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;s:8:"sortable";b:1;s:5:"views";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_three',
  'type' => 'number_decimal',
  'global_settings' => 'a:9:{s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:3:"min";s:0:"";s:3:"max";s:3:"600";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";s:9:"precision";s:2:"10";s:5:"scale";s:1:"2";s:7:"decimal";s:1:".";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:5:{s:4:"type";s:7:"numeric";s:9:"precision";s:2:"10";s:5:"scale";s:1:"2";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_two',
  'type' => 'number_integer',
  'global_settings' => 'a:6:{s:6:"prefix";s:4:"pref";s:6:"suffix";s:3:"suf";s:3:"min";s:2:"10";s:3:"max";s:3:"100";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";}',
  'required' => '0',
  'multiple' => '1',
  'db_storage' => '0',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->execute();

$connection->schema()->createTable('content_node_field_instance', array(
  'fields' => array(
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'type_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'widget_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'widget_settings' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'display_settings' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'widget_module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '127',
      'default' => '',
    ),
    'widget_active' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'field_name',
    'type_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_node_field_instance')
->fields(array(
  'field_name',
  'type_name',
  'weight',
  'label',
  'widget_type',
  'widget_settings',
  'display_settings',
  'description',
  'widget_module',
  'widget_active',
))
->values(array(
  'field_name' => 'field_multivalue',
  'type_name' => 'test_planet',
  'weight' => '2',
  'label' => 'Decimal Field',
  'widget_type' => 'number',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:0:"";s:14:"_error_element";s:48:"default_value_widget][field_multivalue][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:6:{s:6:"weight";i:2;s:6:"parent";s:0:"";s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example multi-valued decimal field.',
  'widget_module' => 'number',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test',
  'type_name' => 'story',
  'weight' => '1',
  'label' => 'Text Field',
  'widget_type' => 'text_textfield',
  'widget_settings' => 'a:4:{s:4:"rows";i:5;s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:22:"text for default value";s:14:"_error_element";s:42:"default_value_widget][field_test][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"1";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"trimmed";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"trimmed";s:7:"exclude";i:0;}}',
  'description' => 'An example text field.',
  'widget_module' => 'text',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test',
  'type_name' => 'test_page',
  'weight' => '35',
  'label' => 'Text Field',
  'widget_type' => 'text_textfield',
  'widget_settings' => 'a:4:{s:4:"rows";i:5;s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:3:{s:5:"value";s:22:"text for default value";s:6:"format";s:1:"1";s:14:"_error_element";s:42:"default_value_widget][field_test][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:6:{s:6:"weight";s:2:"35";s:6:"parent";s:0:"";s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"trimmed";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example text field.',
  'widget_module' => 'text',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_date',
  'type_name' => 'story',
  'weight' => '10',
  'label' => 'Date Field',
  'widget_type' => 'date_select',
  'widget_settings' => 'a:10:{s:13:"default_value";s:5:"blank";s:18:"default_value_code";s:0:"";s:14:"default_value2";s:4:"same";s:19:"default_value_code2";s:0:"";s:12:"input_format";s:13:"m/d/Y - H:i:s";s:19:"input_format_custom";s:0:"";s:9:"increment";s:1:"1";s:10:"text_parts";a:0:{}s:10:"year_range";s:5:"-3:+3";s:14:"label_position";s:5:"above";}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"10";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:4:"long";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example date field.',
  'widget_module' => 'date',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_datestamp',
  'type_name' => 'story',
  'weight' => '11',
  'label' => 'Date Stamp Field',
  'widget_type' => 'date_select',
  'widget_settings' => 'a:10:{s:13:"default_value";s:5:"blank";s:18:"default_value_code";s:0:"";s:14:"default_value2";s:4:"same";s:19:"default_value_code2";s:0:"";s:12:"input_format";s:13:"m/d/Y - H:i:s";s:19:"input_format_custom";s:0:"";s:9:"increment";s:1:"1";s:10:"text_parts";a:0:{}s:10:"year_range";s:5:"-3:+3";s:14:"label_position";s:5:"above";}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"11";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:6:"medium";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example date stamp field.',
  'widget_module' => 'date',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_datetime',
  'type_name' => 'story',
  'weight' => '12',
  'label' => 'Datetime Field',
  'widget_type' => 'date_select',
  'widget_settings' => 'a:10:{s:13:"default_value";s:5:"blank";s:18:"default_value_code";s:0:"";s:14:"default_value2";s:4:"same";s:19:"default_value_code2";s:0:"";s:12:"input_format";s:13:"m/d/Y - H:i:s";s:19:"input_format_custom";s:0:"";s:9:"increment";s:1:"1";s:10:"text_parts";a:0:{}s:10:"year_range";s:5:"-3:+3";s:14:"label_position";s:5:"above";}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"12";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:5:"short";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example datetime field.',
  'widget_module' => 'date',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_decimal_radio_buttons',
  'type_name' => 'story',
  'weight' => '14',
  'label' => 'Decimal Radio Buttons Field',
  'widget_type' => 'optionwidgets_buttons',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"14";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example decimal field using radio buttons.',
  'widget_module' => 'optionwidgets',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_email',
  'type_name' => 'story',
  'weight' => '6',
  'label' => 'Email Field',
  'widget_type' => 'email_textfield',
  'widget_settings' => 'a:3:{s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:1:{s:5:"email";s:17:"benjy@example.com";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"6";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example email field.',
  'widget_module' => 'email',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_exclude_unset',
  'type_name' => 'story',
  'weight' => '0',
  'label' => 'Text Field',
  'widget_type' => 'text_textfield',
  'widget_settings' => 'a:4:{s:4:"rows";i:5;s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:22:"text for default value";s:14:"_error_element";s:42:"default_value_widget][field_test][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:8:{s:6:"weight";i:0;s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"trimmed";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"trimmed";s:7:"exclude";i:0;}i:1;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example text field without exclude.',
  'widget_module' => 'text',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_filefield',
  'type_name' => 'story',
  'weight' => '8',
  'label' => 'File Field',
  'widget_type' => 'filefield_widget',
  'widget_settings' => 'a:5:{s:15:"file_extensions";s:11:"txt pdf doc";s:9:"file_path";s:6:"images";s:18:"progress_indicator";s:3:"bar";s:21:"max_filesize_per_file";s:4:"200K";s:21:"max_filesize_per_node";s:3:"20M";}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"8";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:10:"path_plain";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example image field.',
  'widget_module' => 'filefield',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_float_single_checkbox',
  'type_name' => 'story',
  'weight' => '15',
  'label' => 'Float Single Checkbox Field',
  'widget_type' => 'optionwidgets_onoff',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";N;}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"15";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example float field using a single on/off checkbox.',
  'widget_module' => 'optionwidgets',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_four',
  'type_name' => 'story',
  'weight' => '3',
  'label' => 'Float Field',
  'widget_type' => 'number',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:3:"101";s:14:"_error_element";s:47:"default_value_widget][field_test_four][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"3";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example float field.',
  'widget_module' => 'number',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_identical1',
  'type_name' => 'story',
  'weight' => '4',
  'label' => 'Integer Field',
  'widget_type' => 'number',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:0:"";s:14:"_error_element";s:41:"default_value_widget][field_int][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"4";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}}',
  'description' => 'An example integer field.',
  'widget_module' => 'number',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_identical2',
  'type_name' => 'story',
  'weight' => '5',
  'label' => 'Integer Field',
  'widget_type' => 'number',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:0:"";s:14:"_error_element";s:41:"default_value_widget][field_int][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"5";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}}',
  'description' => 'An example integer field.',
  'widget_module' => 'number',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_imagefield',
  'type_name' => 'story',
  'weight' => '9',
  'label' => 'Image Field',
  'widget_type' => 'imagefield_widget',
  'widget_settings' => 'a:14:{s:15:"file_extensions";s:16:"png gif jpg jpeg";s:9:"file_path";s:0:"";s:18:"progress_indicator";s:3:"bar";s:21:"max_filesize_per_file";s:0:"";s:21:"max_filesize_per_node";s:0:"";s:14:"max_resolution";s:1:"0";s:14:"min_resolution";s:1:"0";s:3:"alt";s:8:"Test alt";s:10:"custom_alt";i:0;s:5:"title";s:10:"Test title";s:12:"custom_title";i:0;s:10:"title_type";s:9:"textfield";s:13:"default_image";N;s:17:"use_default_image";i:0;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"9";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:15:"image_imagelink";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:11:"image_plain";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example image field.',
  'widget_module' => 'imagefield',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_integer_selectlist',
  'type_name' => 'story',
  'weight' => '16',
  'label' => 'Integer Select List Field',
  'widget_type' => 'optionwidgets_select',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"16";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example integer field using a select list.',
  'widget_module' => 'optionwidgets',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_link',
  'type_name' => 'story',
  'weight' => '7',
  'label' => 'Link Field',
  'widget_type' => 'link',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"title";s:18:"default link title";s:3:"url";s:22:"https://www.drupal.org";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"7";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:8:"absolute";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example link field.',
  'widget_module' => 'link',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_phone',
  'type_name' => 'story',
  'weight' => '13',
  'label' => 'Phone Field',
  'widget_type' => 'phone_textfield',
  'widget_settings' => 'a:3:{s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:0:"";s:14:"_error_element";s:48:"default_value_widget][field_test_phone][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"13";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example phone field.',
  'widget_module' => 'phone',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_text_single_checkbox',
  'type_name' => 'story',
  'weight' => '17',
  'label' => 'Text Single Checkbox Field',
  'widget_type' => 'optionwidgets_onoff',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:1:"a";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"17";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example text field using a single on/off checkbox.',
  'widget_module' => 'optionwidgets',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_text_single_checkbox',
  'type_name' => 'test_planet',
  'weight' => '32',
  'label' => 'Text Single Checkbox Field',
  'widget_type' => 'text_textfield',
  'widget_settings' => 'a:4:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:1:"0";s:14:"_error_element";s:63:"default_value_widget][field_test_text_single_checkbox][0][value";}}s:17:"default_value_php";N;s:4:"rows";i:5;s:4:"size";s:3:"255";}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"17";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example text field using a single on/off checkbox.',
  'widget_module' => 'text',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_text_single_checkbox2',
  'type_name' => 'story',
  'weight' => '19',
  'label' => 'Text Single Checkbox Field 2',
  'widget_type' => 'optionwidgets_onoff',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";N;}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'Checkbox that uses keys only and no label.',
  'widget_module' => 'optionwidgets',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_three',
  'type_name' => 'story',
  'weight' => '2',
  'label' => 'Decimal Field',
  'widget_type' => 'number',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";d:101;s:14:"_error_element";s:48:"default_value_widget][field_test_three][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"2";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:4:"us_2";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}}',
  'description' => 'An example decimal field.',
  'widget_module' => 'number',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_two',
  'type_name' => 'story',
  'weight' => '1',
  'label' => 'Integer Field',
  'widget_type' => 'number',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:0:"";s:14:"_error_element";s:46:"default_value_widget][field_test_two][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"1";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:4:"us_0";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:4:"us_0";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}}',
  'description' => 'An example integer field.',
  'widget_module' => 'number',
  'widget_active' => '1',
))
->execute();

$connection->schema()->createTable('content_type_page', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_text_field_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_type_page')
->fields(array(
  'vid',
  'nid',
  'field_text_field_value',
))
->values(array(
  'vid' => '1',
  'nid' => '1',
  'field_text_field_value' => NULL,
))
->values(array(
  'vid' => '3',
  'nid' => '1',
  'field_text_field_value' => NULL,
))
->execute();

$connection->schema()->createTable('content_type_story', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_test_three_value' => array(
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '2',
    ),
    'field_test_identical1_value' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_test_identical2_value' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_test_link_url' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '2048',
    ),
    'field_test_link_title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'field_test_link_attributes' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_date_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '20',
    ),
    'field_test_datestamp_value' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_datetime_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '100',
    ),
    'field_test_email_email' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'field_test_filefield_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_filefield_list' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_filefield_data' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_four_value' => array(
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '0',
    ),
    'field_test_integer_selectlist_value' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_float_single_checkbox_value' => array(
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '0',
    ),
    'field_test_decimal_radio_buttons_value' => array(
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '2',
    ),
    'field_test_phone_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'field_test_exclude_unset_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_exclude_unset_format' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_test_imagefield_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_imagefield_list' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_imagefield_data' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_text_single_checkbox2_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_type_story')
->fields(array(
  'nid',
  'vid',
  'uid',
  'field_test_three_value',
  'field_test_identical1_value',
  'field_test_identical2_value',
  'field_test_link_url',
  'field_test_link_title',
  'field_test_link_attributes',
  'field_test_date_value',
  'field_test_datestamp_value',
  'field_test_datetime_value',
  'field_test_email_email',
  'field_test_filefield_fid',
  'field_test_filefield_list',
  'field_test_filefield_data',
  'field_test_four_value',
  'field_test_integer_selectlist_value',
  'field_test_float_single_checkbox_value',
  'field_test_decimal_radio_buttons_value',
  'field_test_phone_value',
  'field_test_exclude_unset_value',
  'field_test_exclude_unset_format',
  'field_test_imagefield_fid',
  'field_test_imagefield_list',
  'field_test_imagefield_data',
  'field_test_text_single_checkbox2_value',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'uid' => '1',
  'field_test_three_value' => '42.42',
  'field_test_identical1_value' => '1',
  'field_test_identical2_value' => '1',
  'field_test_link_url' => 'https://www.drupal.org/project/drupal',
  'field_test_link_title' => 'Drupal project page',
  'field_test_link_attributes' => 's:32:"a:1:{s:6:"target";s:6:"_blank";}";',
  'field_test_date_value' => NULL,
  'field_test_datestamp_value' => NULL,
  'field_test_datetime_value' => NULL,
  'field_test_email_email' => NULL,
  'field_test_filefield_fid' => '5',
  'field_test_filefield_list' => '1',
  'field_test_filefield_data' => 'a:1:{s:11:"description";s:4:"desc";}',
  'field_test_four_value' => NULL,
  'field_test_integer_selectlist_value' => '3412',
  'field_test_float_single_checkbox_value' => '3',
  'field_test_decimal_radio_buttons_value' => NULL,
  'field_test_phone_value' => NULL,
  'field_test_exclude_unset_value' => 'This is a field with exclude unset.',
  'field_test_exclude_unset_format' => '1',
  'field_test_imagefield_fid' => NULL,
  'field_test_imagefield_list' => NULL,
  'field_test_imagefield_data' => NULL,
  'field_test_text_single_checkbox2_value' => 'Hello',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'uid' => '1',
  'field_test_three_value' => '42.42',
  'field_test_identical1_value' => '1',
  'field_test_identical2_value' => '1',
  'field_test_link_url' => 'https://www.drupal.org/project/drupal',
  'field_test_link_title' => 'Drupal project page',
  'field_test_link_attributes' => 's:32:"a:1:{s:6:"target";s:6:"_blank";}";',
  'field_test_date_value' => NULL,
  'field_test_datestamp_value' => NULL,
  'field_test_datetime_value' => NULL,
  'field_test_email_email' => NULL,
  'field_test_filefield_fid' => NULL,
  'field_test_filefield_list' => NULL,
  'field_test_filefield_data' => NULL,
  'field_test_four_value' => NULL,
  'field_test_integer_selectlist_value' => NULL,
  'field_test_float_single_checkbox_value' => NULL,
  'field_test_decimal_radio_buttons_value' => NULL,
  'field_test_phone_value' => NULL,
  'field_test_exclude_unset_value' => NULL,
  'field_test_exclude_unset_format' => NULL,
  'field_test_imagefield_fid' => NULL,
  'field_test_imagefield_list' => NULL,
  'field_test_imagefield_data' => NULL,
  'field_test_text_single_checkbox2_value' => NULL,
))
->values(array(
  'nid' => '2',
  'vid' => '3',
  'uid' => '1',
  'field_test_three_value' => '23.20',
  'field_test_identical1_value' => '1',
  'field_test_identical2_value' => '1',
  'field_test_link_url' => 'http://groups.drupal.org/',
  'field_test_link_title' => 'Drupal Groups',
  'field_test_link_attributes' => 's:6:"a:0:{}";',
  'field_test_date_value' => NULL,
  'field_test_datestamp_value' => NULL,
  'field_test_datetime_value' => NULL,
  'field_test_email_email' => NULL,
  'field_test_filefield_fid' => NULL,
  'field_test_filefield_list' => NULL,
  'field_test_filefield_data' => NULL,
  'field_test_four_value' => NULL,
  'field_test_integer_selectlist_value' => NULL,
  'field_test_float_single_checkbox_value' => NULL,
  'field_test_decimal_radio_buttons_value' => NULL,
  'field_test_phone_value' => NULL,
  'field_test_exclude_unset_value' => NULL,
  'field_test_exclude_unset_format' => NULL,
  'field_test_imagefield_fid' => NULL,
  'field_test_imagefield_list' => NULL,
  'field_test_imagefield_data' => NULL,
  'field_test_text_single_checkbox2_value' => NULL,
))
->values(array(
  'nid' => '2',
  'vid' => '5',
  'uid' => '1',
  'field_test_three_value' => '23.20',
  'field_test_identical1_value' => '1',
  'field_test_identical2_value' => '1',
  'field_test_link_url' => 'http://groups.drupal.org/',
  'field_test_link_title' => 'Drupal Groups',
  'field_test_link_attributes' => 's:6:"a:0:{}";',
  'field_test_date_value' => NULL,
  'field_test_datestamp_value' => NULL,
  'field_test_datetime_value' => NULL,
  'field_test_email_email' => NULL,
  'field_test_filefield_fid' => NULL,
  'field_test_filefield_list' => NULL,
  'field_test_filefield_data' => NULL,
  'field_test_four_value' => NULL,
  'field_test_integer_selectlist_value' => NULL,
  'field_test_float_single_checkbox_value' => NULL,
  'field_test_decimal_radio_buttons_value' => NULL,
  'field_test_phone_value' => NULL,
  'field_test_exclude_unset_value' => NULL,
  'field_test_exclude_unset_format' => NULL,
  'field_test_imagefield_fid' => NULL,
  'field_test_imagefield_list' => NULL,
  'field_test_imagefield_data' => NULL,
  'field_test_text_single_checkbox2_value' => NULL,
))
->values(array(
  'nid' => '9',
  'vid' => '12',
  'uid' => '0',
  'field_test_three_value' => '101.00',
  'field_test_identical1_value' => NULL,
  'field_test_identical2_value' => NULL,
  'field_test_link_url' => 'http://www.example.com/buy-one-upon-a-time',
  'field_test_link_title' => 'Buy it now',
  'field_test_link_attributes' => 'a:1:{s:6:"target";s:6:"_blank";}',
  'field_test_date_value' => NULL,
  'field_test_datestamp_value' => NULL,
  'field_test_datetime_value' => NULL,
  'field_test_email_email' => NULL,
  'field_test_filefield_fid' => NULL,
  'field_test_filefield_list' => NULL,
  'field_test_filefield_data' => NULL,
  'field_test_four_value' => '101',
  'field_test_integer_selectlist_value' => NULL,
  'field_test_float_single_checkbox_value' => '3',
  'field_test_decimal_radio_buttons_value' => NULL,
  'field_test_phone_value' => NULL,
  'field_test_exclude_unset_value' => 'text for default value',
  'field_test_exclude_unset_format' => '1',
  'field_test_imagefield_fid' => NULL,
  'field_test_imagefield_list' => NULL,
  'field_test_imagefield_data' => NULL,
  'field_test_text_single_checkbox2_value' => NULL,
))
->execute();

$connection->schema()->createTable('content_type_test_page', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_test_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_format' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('content_type_test_planet', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_type_test_planet')
->fields(array(
  'nid',
  'vid',
))
->values(array(
  'nid' => '3',
  'vid' => '4',
))
->values(array(
  'nid' => '4',
  'vid' => '6',
))
->values(array(
  'nid' => '5',
  'vid' => '7',
))
->values(array(
  'nid' => '6',
  'vid' => '8',
))
->values(array(
  'nid' => '7',
  'vid' => '9',
))
->values(array(
  'nid' => '8',
  'vid' => '10',
))
->values(array(
  'nid' => '9',
  'vid' => '11',
))
->execute();

$connection->schema()->createTable('date_format_locale', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '200',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
    ),
  ),
  'primary key' => array(
    'type',
    'language',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('date_format_types', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '200',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('date_format_types')
->fields(array(
  'type',
  'title',
  'locked',
))
->values(array(
  'type' => 'long',
  'title' => 'Long',
  'locked' => '1',
))
->values(array(
  'type' => 'medium',
  'title' => 'Medium',
  'locked' => '1',
))
->values(array(
  'type' => 'short',
  'title' => 'Short',
  'locked' => '1',
))
->execute();

$connection->schema()->createTable('date_formats', array(
  'fields' => array(
    'dfid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '200',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'dfid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('date_formats')
->fields(array(
  'dfid',
  'format',
  'type',
  'locked',
))
->values(array(
  'dfid' => '1',
  'format' => 'Y-m-d H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '2',
  'format' => 'm/d/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '3',
  'format' => 'd/m/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '4',
  'format' => 'Y/m/d - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '5',
  'format' => 'd.m.Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '6',
  'format' => 'm/d/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '7',
  'format' => 'd/m/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '8',
  'format' => 'Y/m/d - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '9',
  'format' => 'M j Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '10',
  'format' => 'j M Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '11',
  'format' => 'Y M j - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '12',
  'format' => 'M j Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '13',
  'format' => 'j M Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '14',
  'format' => 'Y M j - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '15',
  'format' => 'D, Y-m-d H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '16',
  'format' => 'D, m/d/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '17',
  'format' => 'D, d/m/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '18',
  'format' => 'D, Y/m/d - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '19',
  'format' => 'F j, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '20',
  'format' => 'j F, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '21',
  'format' => 'Y, F j - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '22',
  'format' => 'D, m/d/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '23',
  'format' => 'D, d/m/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '24',
  'format' => 'D, Y/m/d - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '25',
  'format' => 'F j, Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '26',
  'format' => 'j F Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '27',
  'format' => 'Y, F j - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '28',
  'format' => 'j. F Y - G:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '29',
  'format' => 'l, F j, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '30',
  'format' => 'l, j F, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '31',
  'format' => 'l, Y,  F j - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '32',
  'format' => 'l, F j, Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '33',
  'format' => 'l, j F Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '34',
  'format' => 'l, Y,  F j - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '35',
  'format' => 'l, j. F Y - G:i',
  'type' => 'long',
  'locked' => '1',
))
->execute();

$connection->schema()->createTable('event', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'event_start' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'event_end' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'timezone' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'start_in_dst' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'end_in_dst' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'has_time' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'has_end_date' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('event_timezones', array(
  'fields' => array(
    'timezone' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'offset' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
      'default' => '00:00:00',
    ),
    'offset_dst' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
      'default' => '00:00:00',
    ),
    'dst_region' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'is_dst' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'timezone',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('event_timezones')
->fields(array(
  'timezone',
  'name',
  'offset',
  'offset_dst',
  'dst_region',
  'is_dst',
))
->values(array(
  'timezone' => '1',
  'name' => 'Africa/Addis Ababa',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '2',
  'name' => 'Africa/Algiers',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '3',
  'name' => 'Africa/Asmera',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '4',
  'name' => 'Africa/Bangui',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '5',
  'name' => 'Africa/Blantyre',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '6',
  'name' => 'Africa/Brazzaville',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '7',
  'name' => 'Africa/Bujumbura',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '8',
  'name' => 'Africa/Cairo',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '1',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '9',
  'name' => 'Africa/Ceuta',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '1',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '10',
  'name' => 'Africa/Dar es Salaam',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '11',
  'name' => 'Africa/Djibouti',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '12',
  'name' => 'Africa/Douala',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '13',
  'name' => 'Africa/Gaborone',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '14',
  'name' => 'Africa/Harare',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '15',
  'name' => 'Africa/Johannesburg',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '16',
  'name' => 'Africa/Kampala',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '17',
  'name' => 'Africa/Khartoum',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '18',
  'name' => 'Africa/Kigali',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '19',
  'name' => 'Africa/Kinshasa',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '20',
  'name' => 'Africa/Lagos',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '21',
  'name' => 'Africa/Libreville',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '22',
  'name' => 'Africa/Luanda',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '23',
  'name' => 'Africa/Lubumbashi',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '24',
  'name' => 'Africa/Lusaka',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '25',
  'name' => 'Africa/Malabo',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '26',
  'name' => 'Africa/Maputo',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '27',
  'name' => 'Africa/Maseru',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '28',
  'name' => 'Africa/Mbabane',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '29',
  'name' => 'Africa/Mogadishu',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '30',
  'name' => 'Africa/Nairobi',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '31',
  'name' => 'Africa/Ndjamena',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '32',
  'name' => 'Africa/Niamey',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '33',
  'name' => 'Africa/Porto-Novo',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '34',
  'name' => 'Africa/Tripoli',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '35',
  'name' => 'Africa/Tunis',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '36',
  'name' => 'Africa/Windhoek',
  'offset' => '02:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '2',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '37',
  'name' => 'America/Adak',
  'offset' => '-10:00:00',
  'offset_dst' => '-09:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '38',
  'name' => 'America/Anchorage',
  'offset' => '-09:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '39',
  'name' => 'America/Anguilla',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '40',
  'name' => 'America/Antigua',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '41',
  'name' => 'America/Araguaina',
  'offset' => '-02:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '17',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '42',
  'name' => 'America/Aruba',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '43',
  'name' => 'America/Asuncion',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '20',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '44',
  'name' => 'America/Atka',
  'offset' => '-10:00:00',
  'offset_dst' => '-09:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '45',
  'name' => 'America/Barbados',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '46',
  'name' => 'America/Belem',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '47',
  'name' => 'America/Belize',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '48',
  'name' => 'America/Boa Vista',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '49',
  'name' => 'America/Bogota',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '50',
  'name' => 'America/Boise',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '51',
  'name' => 'America/Buenos Aires',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '52',
  'name' => 'America/Cambridge Bay',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '53',
  'name' => 'America/Cancun',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '54',
  'name' => 'America/Caracas',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '55',
  'name' => 'America/Catamarca',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '56',
  'name' => 'America/Cayenne',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '57',
  'name' => 'America/Cayman',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '58',
  'name' => 'America/Chicago',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '59',
  'name' => 'America/Chihuahua',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '60',
  'name' => 'America/Cordoba',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '61',
  'name' => 'America/Costa Rica',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '62',
  'name' => 'America/Cuiaba',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '17',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '63',
  'name' => 'America/Curacao',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '64',
  'name' => 'America/Dawson',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '65',
  'name' => 'America/Dawson Creek',
  'offset' => '-07:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '66',
  'name' => 'America/Denver',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '67',
  'name' => 'America/Detroit',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '68',
  'name' => 'America/Dominica',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '69',
  'name' => 'America/Edmonton',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '70',
  'name' => 'America/Eirunepe',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '71',
  'name' => 'America/El Salvador',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '72',
  'name' => 'America/Ensenada',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '73',
  'name' => 'America/Fort Wayne',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '74',
  'name' => 'America/Fortaleza',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '75',
  'name' => 'America/Glace Bay',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '76',
  'name' => 'America/Godthab',
  'offset' => '-03:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '77',
  'name' => 'America/Goose Bay',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '78',
  'name' => 'America/Grand Turk',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '16',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '79',
  'name' => 'America/Grenada',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '80',
  'name' => 'America/Guadeloupe',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '81',
  'name' => 'America/Guatemala',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '82',
  'name' => 'America/Guayaquil',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '83',
  'name' => 'America/Guyana',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '84',
  'name' => 'America/Halifax',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '85',
  'name' => 'America/Havana',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '16',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '86',
  'name' => 'America/Hermosillo',
  'offset' => '-07:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '87',
  'name' => 'America/Indiana/Indianapolis',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '88',
  'name' => 'America/Indiana/Knox',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '89',
  'name' => 'America/Indiana/Marengo',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '90',
  'name' => 'America/Indiana/Vevay',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '91',
  'name' => 'America/Indianapolis',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '92',
  'name' => 'America/Inuvik',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '93',
  'name' => 'America/Iqaluit',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '94',
  'name' => 'America/Jamaica',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '95',
  'name' => 'America/Jujuy',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '96',
  'name' => 'America/Juneau',
  'offset' => '-09:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '97',
  'name' => 'America/Kentucky/Louisville',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '98',
  'name' => 'America/Kentucky/Monticello',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '99',
  'name' => 'America/Knox IN',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '100',
  'name' => 'America/La Paz',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '101',
  'name' => 'America/Lima',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '102',
  'name' => 'America/Los Angeles',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '103',
  'name' => 'America/Louisville',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '104',
  'name' => 'America/Maceio',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '105',
  'name' => 'America/Managua',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '106',
  'name' => 'America/Manaus',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '107',
  'name' => 'America/Martinique',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '108',
  'name' => 'America/Mazatlan',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '109',
  'name' => 'America/Mendoza',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '110',
  'name' => 'America/Menominee',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '111',
  'name' => 'America/Merida',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '112',
  'name' => 'America/Mexico City',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '113',
  'name' => 'America/Miquelon',
  'offset' => '-03:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '114',
  'name' => 'America/Monterrey',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '115',
  'name' => 'America/Montevideo',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '116',
  'name' => 'America/Montreal',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '117',
  'name' => 'America/Montserrat',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '118',
  'name' => 'America/Nassau',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '119',
  'name' => 'America/New York',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '120',
  'name' => 'America/Nipigon',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '121',
  'name' => 'America/Nome',
  'offset' => '-09:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '122',
  'name' => 'America/Noronha',
  'offset' => '-02:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '123',
  'name' => 'America/Panama',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '124',
  'name' => 'America/Pangnirtung',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '125',
  'name' => 'America/Paramaribo',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '126',
  'name' => 'America/Phoenix',
  'offset' => '-07:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '127',
  'name' => 'America/Port-au-Prince',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '128',
  'name' => 'America/Port of Spain',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '129',
  'name' => 'America/Porto Acre',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '130',
  'name' => 'America/Porto Velho',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '131',
  'name' => 'America/Puerto Rico',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '132',
  'name' => 'America/Rainy River',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '133',
  'name' => 'America/Rankin Inlet',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '134',
  'name' => 'America/Recife',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '135',
  'name' => 'America/Regina',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '136',
  'name' => 'America/Rio Branco',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '137',
  'name' => 'America/Rosario',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '138',
  'name' => 'America/Santiago',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '139',
  'name' => 'America/Santo Domingo',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '140',
  'name' => 'America/Sao Paulo',
  'offset' => '-02:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '141',
  'name' => 'America/Scoresbysund',
  'offset' => '-01:00:00',
  'offset_dst' => '00:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '142',
  'name' => 'America/Shiprock',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '143',
  'name' => 'America/St Johns',
  'offset' => '-03:30:00',
  'offset_dst' => '-02:30:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '144',
  'name' => 'America/St Kitts',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '145',
  'name' => 'America/St Lucia',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '146',
  'name' => 'America/St Thomas',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '147',
  'name' => 'America/St Vincent',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '148',
  'name' => 'America/Swift Current',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '149',
  'name' => 'America/Tegucigalpa',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '150',
  'name' => 'America/Thule',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '151',
  'name' => 'America/Thunder Bay',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '152',
  'name' => 'America/Tijuana',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '153',
  'name' => 'America/Tortola',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '154',
  'name' => 'America/Vancouver',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '155',
  'name' => 'America/Virgin',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '156',
  'name' => 'America/Whitehorse',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '157',
  'name' => 'America/Winnipeg',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '158',
  'name' => 'America/Yakutat',
  'offset' => '-09:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '159',
  'name' => 'America/Yellowknife',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '160',
  'name' => 'Antarctica/Casey',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '161',
  'name' => 'Antarctica/Davis',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '162',
  'name' => 'Antarctica/DumontDUrville',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '163',
  'name' => 'Antarctica/Mawson',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '164',
  'name' => 'Antarctica/McMurdo',
  'offset' => '13:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '11',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '165',
  'name' => 'Antarctica/Palmer',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '18',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '166',
  'name' => 'Antarctica/South Pole',
  'offset' => '13:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '11',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '167',
  'name' => 'Antarctica/Syowa',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '168',
  'name' => 'Antarctica/Vostok',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '169',
  'name' => 'Arctic/Longyearbyen',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '14',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '170',
  'name' => 'Asia/Aden',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '171',
  'name' => 'Asia/Almaty',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '172',
  'name' => 'Asia/Amman',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '8',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '173',
  'name' => 'Asia/Anadyr',
  'offset' => '12:00:00',
  'offset_dst' => '13:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '174',
  'name' => 'Asia/Aqtau',
  'offset' => '04:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '175',
  'name' => 'Asia/Aqtobe',
  'offset' => '05:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '176',
  'name' => 'Asia/Ashgabat',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '177',
  'name' => 'Asia/Ashkhabad',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '178',
  'name' => 'Asia/Baghdad',
  'offset' => '03:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '4',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '179',
  'name' => 'Asia/Bahrain',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '180',
  'name' => 'Asia/Baku',
  'offset' => '04:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '181',
  'name' => 'Asia/Bangkok',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '182',
  'name' => 'Asia/Beirut',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '6',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '183',
  'name' => 'Asia/Bishkek',
  'offset' => '05:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '6',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '184',
  'name' => 'Asia/Brunei',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '185',
  'name' => 'Asia/Calcutta',
  'offset' => '05:30:00',
  'offset_dst' => '05:30:30',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '186',
  'name' => 'Asia/Chungking',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '187',
  'name' => 'Asia/Colombo',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '188',
  'name' => 'Asia/Dacca',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '189',
  'name' => 'Asia/Damascus',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '4',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '190',
  'name' => 'Asia/Dhaka',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '191',
  'name' => 'Asia/Dili',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '192',
  'name' => 'Asia/Dubai',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '193',
  'name' => 'Asia/Dushanbe',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '194',
  'name' => 'Asia/Gaza',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '7',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '195',
  'name' => 'Asia/Harbin',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '196',
  'name' => 'Asia/Hong Kong',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '197',
  'name' => 'Asia/Hovd',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '198',
  'name' => 'Asia/Irkutsk',
  'offset' => '08:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '199',
  'name' => 'Asia/Istanbul',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '200',
  'name' => 'Asia/Jakarta',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '201',
  'name' => 'Asia/Jayapura',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '202',
  'name' => 'Asia/Jerusalem',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '5',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '203',
  'name' => 'Asia/Kabul',
  'offset' => '04:30:00',
  'offset_dst' => '04:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '204',
  'name' => 'Asia/Kamchatka',
  'offset' => '12:00:00',
  'offset_dst' => '13:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '205',
  'name' => 'Asia/Karachi',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '206',
  'name' => 'Asia/Kashgar',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '207',
  'name' => 'Asia/Katmandu',
  'offset' => '05:45:00',
  'offset_dst' => '05:45:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '208',
  'name' => 'Asia/Krasnoyarsk',
  'offset' => '07:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '209',
  'name' => 'Asia/Kuala Lumpur',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '210',
  'name' => 'Asia/Kuching',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '211',
  'name' => 'Asia/Kuwait',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '212',
  'name' => 'Asia/Macao',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '213',
  'name' => 'Asia/Magadan',
  'offset' => '11:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '214',
  'name' => 'Asia/Manila',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '215',
  'name' => 'Asia/Muscat',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '216',
  'name' => 'Asia/Nicosia',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '217',
  'name' => 'Asia/Novosibirsk',
  'offset' => '06:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '218',
  'name' => 'Asia/Omsk',
  'offset' => '06:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '219',
  'name' => 'Asia/Phnom Penh',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '220',
  'name' => 'Asia/Pyongyang',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '221',
  'name' => 'Asia/Qatar',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '222',
  'name' => 'Asia/Rangoon',
  'offset' => '06:30:00',
  'offset_dst' => '06:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '223',
  'name' => 'Asia/Riyadh',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '224',
  'name' => 'Asia/Riyadh87',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '225',
  'name' => 'Asia/Riyadh88',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '226',
  'name' => 'Asia/Riyadh89',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '227',
  'name' => 'Asia/Saigon',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '228',
  'name' => 'Asia/Samarkand',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '229',
  'name' => 'Asia/Seoul',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '230',
  'name' => 'Asia/Shanghai',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '231',
  'name' => 'Asia/Singapore',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '232',
  'name' => 'Asia/Taipei',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '233',
  'name' => 'Asia/Tashkent',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '234',
  'name' => 'Asia/Tbilisi',
  'offset' => '04:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '235',
  'name' => 'Asia/Tehran',
  'offset' => '03:30:00',
  'offset_dst' => '04:30:00',
  'dst_region' => '8',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '236',
  'name' => 'Asia/Tel Aviv',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '5',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '237',
  'name' => 'Asia/Thimbu',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '238',
  'name' => 'Asia/Thimphu',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '239',
  'name' => 'Asia/Tokyo',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '240',
  'name' => 'Asia/Ujung Pandang',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '241',
  'name' => 'Asia/Ulaanbaatar',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '242',
  'name' => 'Asia/Ulan Bator',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '243',
  'name' => 'Asia/Urumqi',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '244',
  'name' => 'Asia/Vientiane',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '245',
  'name' => 'Asia/Vladivostok',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '246',
  'name' => 'Asia/Yakutsk',
  'offset' => '09:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '247',
  'name' => 'Asia/Yekaterinburg',
  'offset' => '05:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '248',
  'name' => 'Asia/Yerevan',
  'offset' => '04:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '249',
  'name' => 'Atlantic/Azores',
  'offset' => '-01:00:00',
  'offset_dst' => '00:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '250',
  'name' => 'Atlantic/Bermuda',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '251',
  'name' => 'Atlantic/Canary',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '252',
  'name' => 'Atlantic/Cape Verde',
  'offset' => '-01:00:00',
  'offset_dst' => '-01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '253',
  'name' => 'Atlantic/Faeroe',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '254',
  'name' => 'Atlantic/Jan Mayen',
  'offset' => '-01:00:00',
  'offset_dst' => '-01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '255',
  'name' => 'Atlantic/Madeira',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '256',
  'name' => 'Atlantic/South Georgia',
  'offset' => '-02:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '257',
  'name' => 'Atlantic/Stanley',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '19',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '258',
  'name' => 'Australia/ACT',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '259',
  'name' => 'Australia/Adelaide',
  'offset' => '10:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '260',
  'name' => 'Australia/Brisbane',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '261',
  'name' => 'Australia/Broken Hill',
  'offset' => '10:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '262',
  'name' => 'Australia/Canberra',
  'offset' => '11:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '263',
  'name' => 'Australia/Darwin',
  'offset' => '09:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '264',
  'name' => 'Australia/Hobart',
  'offset' => '11:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '10',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '265',
  'name' => 'Australia/LHI',
  'offset' => '11:00:00',
  'offset_dst' => '10:30:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '266',
  'name' => 'Australia/Lindeman',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '267',
  'name' => 'Australia/Lord Howe',
  'offset' => '11:00:00',
  'offset_dst' => '10:30:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '268',
  'name' => 'Australia/Melbourne',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '10',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '269',
  'name' => 'Australia/NSW',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '270',
  'name' => 'Australia/North',
  'offset' => '09:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '271',
  'name' => 'Australia/Perth',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '272',
  'name' => 'Australia/Queensland',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '273',
  'name' => 'Australia/South',
  'offset' => '10:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '274',
  'name' => 'Australia/Sydney',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '10',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '275',
  'name' => 'Australia/Tasmania',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '276',
  'name' => 'Australia/Victoria',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '277',
  'name' => 'Australia/West',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '278',
  'name' => 'Australia/Yancowinna',
  'offset' => '10:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '10',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '279',
  'name' => 'Brazil/Acre',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '280',
  'name' => 'Brazil/DeNoronha',
  'offset' => '-02:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '281',
  'name' => 'Brazil/East',
  'offset' => '-02:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '17',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '282',
  'name' => 'Brazil/West',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '285',
  'name' => 'Canada/Atlantic',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '286',
  'name' => 'Canada/Central',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '287',
  'name' => 'Canada/Central-Saskatchewan',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '288',
  'name' => 'Canada/Eastern',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '289',
  'name' => 'Canada/Mountain',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '290',
  'name' => 'Canada/Newfoundland',
  'offset' => '-03:30:00',
  'offset_dst' => '-02:30:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '291',
  'name' => 'Canada/Pacific',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '292',
  'name' => 'Canada/Saskatchewan',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '293',
  'name' => 'Canada/Yukon',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '294',
  'name' => 'Chile/Continental',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '18',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '295',
  'name' => 'Chile/EasterIsland',
  'offset' => '-05:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '18',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '296',
  'name' => 'Cuba',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '16',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '298',
  'name' => 'EST',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '300',
  'name' => 'Egypt',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '1',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '301',
  'name' => 'Eire',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '302',
  'name' => 'Etc/GMT-1',
  'offset' => '-01:00:00',
  'offset_dst' => '-01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '303',
  'name' => 'Etc/GMT-10',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '304',
  'name' => 'Etc/GMT-11',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '305',
  'name' => 'Etc/GMT-12',
  'offset' => '-12:00:00',
  'offset_dst' => '-12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '306',
  'name' => 'Etc/GMT-2',
  'offset' => '-02:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '307',
  'name' => 'Etc/GMT-3',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '308',
  'name' => 'Etc/GMT-4',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '309',
  'name' => 'Etc/GMT-5',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '310',
  'name' => 'Etc/GMT-6',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '311',
  'name' => 'Etc/GMT-7',
  'offset' => '-07:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '312',
  'name' => 'Etc/GMT-8',
  'offset' => '-08:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '313',
  'name' => 'Etc/GMT-9',
  'offset' => '-09:00:00',
  'offset_dst' => '-09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '314',
  'name' => 'Etc/GMT+1',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '315',
  'name' => 'Etc/GMT+10',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '316',
  'name' => 'Etc/GMT+11',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '317',
  'name' => 'Etc/GMT+12',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '318',
  'name' => 'Etc/GMT+13',
  'offset' => '13:00:00',
  'offset_dst' => '13:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '319',
  'name' => 'Etc/GMT+14',
  'offset' => '14:00:00',
  'offset_dst' => '14:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '320',
  'name' => 'Etc/GMT+2',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '321',
  'name' => 'Etc/GMT+3',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '322',
  'name' => 'Etc/GMT+4',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '323',
  'name' => 'Etc/GMT+5',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '324',
  'name' => 'Etc/GMT+6',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '325',
  'name' => 'Etc/GMT+7',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '326',
  'name' => 'Etc/GMT+8',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '327',
  'name' => 'Etc/GMT+9',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '328',
  'name' => 'Europe/Amsterdam',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '329',
  'name' => 'Europe/Andorra',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '330',
  'name' => 'Europe/Athens',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '331',
  'name' => 'Europe/Belfast',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '332',
  'name' => 'Europe/Belgrade',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '333',
  'name' => 'Europe/Berlin',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '334',
  'name' => 'Europe/Bratislava',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '335',
  'name' => 'Europe/Brussels',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '336',
  'name' => 'Europe/Bucharest',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '337',
  'name' => 'Europe/Budapest',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '338',
  'name' => 'Europe/Chisinau',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '339',
  'name' => 'Europe/Copenhagen',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '340',
  'name' => 'Europe/Dublin',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '341',
  'name' => 'Europe/Gibraltar',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '342',
  'name' => 'Europe/Helsinki',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '343',
  'name' => 'Europe/Istanbul',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '344',
  'name' => 'Europe/Kaliningrad',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '345',
  'name' => 'Europe/Kiev',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '346',
  'name' => 'Europe/Lisbon',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '347',
  'name' => 'Europe/Ljubljana',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '348',
  'name' => 'Europe/London',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '349',
  'name' => 'Europe/Luxembourg',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '350',
  'name' => 'Europe/Madrid',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '351',
  'name' => 'Europe/Malta',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '352',
  'name' => 'Europe/Minsk',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '353',
  'name' => 'Europe/Monaco',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '354',
  'name' => 'Europe/Moscow',
  'offset' => '03:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '14',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '355',
  'name' => 'Europe/Nicosia',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '356',
  'name' => 'Europe/Oslo',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '357',
  'name' => 'Europe/Paris',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '358',
  'name' => 'Europe/Prague',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '359',
  'name' => 'Europe/Riga',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '360',
  'name' => 'Europe/Rome',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '361',
  'name' => 'Europe/Samara',
  'offset' => '04:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '362',
  'name' => 'Europe/San Marino',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '363',
  'name' => 'Europe/Sarajevo',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '364',
  'name' => 'Europe/Simferopol',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '365',
  'name' => 'Europe/Skopje',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '366',
  'name' => 'Europe/Sofia',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '367',
  'name' => 'Europe/Stockholm',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '368',
  'name' => 'Europe/Tallinn',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '369',
  'name' => 'Europe/Tirane',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '370',
  'name' => 'Europe/Tiraspol',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '371',
  'name' => 'Europe/Uzhgorod',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '372',
  'name' => 'Europe/Vaduz',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '373',
  'name' => 'Europe/Vatican',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '374',
  'name' => 'Europe/Vienna',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '375',
  'name' => 'Europe/Vilnius',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '376',
  'name' => 'Europe/Warsaw',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '377',
  'name' => 'Europe/Zagreb',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '378',
  'name' => 'Europe/Zaporozhye',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '379',
  'name' => 'Europe/Zurich',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '380',
  'name' => 'GB',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '381',
  'name' => 'GB-Eire',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '383',
  'name' => 'Hongkong',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '384',
  'name' => 'Indian/Antananarivo',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '385',
  'name' => 'Indian/Chagos',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '386',
  'name' => 'Indian/Christmas',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '387',
  'name' => 'Indian/Cocos',
  'offset' => '06:30:00',
  'offset_dst' => '06:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '388',
  'name' => 'Indian/Comoro',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '389',
  'name' => 'Indian/Kerguelen',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '390',
  'name' => 'Indian/Mahe',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '391',
  'name' => 'Indian/Maldives',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '392',
  'name' => 'Indian/Mauritius',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '393',
  'name' => 'Indian/Mayotte',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '394',
  'name' => 'Indian/Reunion',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '395',
  'name' => 'Iran',
  'offset' => '03:30:00',
  'offset_dst' => '04:30:00',
  'dst_region' => '8',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '396',
  'name' => 'Israel',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '5',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '397',
  'name' => 'Jamaica',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '398',
  'name' => 'Japan',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '399',
  'name' => 'Kwajalein',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '400',
  'name' => 'Libya',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '404',
  'name' => 'Mexico/BajaNorte',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '405',
  'name' => 'Mexico/BajaSur',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '406',
  'name' => 'Mexico/General',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '407',
  'name' => 'Mideast/Riyadh87',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '408',
  'name' => 'Mideast/Riyadh88',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '409',
  'name' => 'Mideast/Riyadh89',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '410',
  'name' => 'NZ',
  'offset' => '13:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '11',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '412',
  'name' => 'Navajo',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '415',
  'name' => 'Pacific/Apia',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '416',
  'name' => 'Pacific/Auckland',
  'offset' => '13:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '417',
  'name' => 'Pacific/Chatham',
  'offset' => '13:45:00',
  'offset_dst' => '12:45:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '418',
  'name' => 'Pacific/Easter',
  'offset' => '-05:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '419',
  'name' => 'Pacific/Efate',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '420',
  'name' => 'Pacific/Enderbury',
  'offset' => '13:00:00',
  'offset_dst' => '13:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '421',
  'name' => 'Pacific/Fakaofo',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '422',
  'name' => 'Pacific/Fiji',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '423',
  'name' => 'Pacific/Funafuti',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '424',
  'name' => 'Pacific/Galapagos',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '425',
  'name' => 'Pacific/Gambier',
  'offset' => '-09:00:00',
  'offset_dst' => '-09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '426',
  'name' => 'Pacific/Guadalcanal',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '427',
  'name' => 'Pacific/Guam',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '428',
  'name' => 'Pacific/Honolulu',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '429',
  'name' => 'Pacific/Johnston',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '430',
  'name' => 'Pacific/Kiritimati',
  'offset' => '14:00:00',
  'offset_dst' => '14:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '431',
  'name' => 'Pacific/Kosrae',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '432',
  'name' => 'Pacific/Kwajalein',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '433',
  'name' => 'Pacific/Majuro',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '434',
  'name' => 'Pacific/Marquesas',
  'offset' => '-09:30:00',
  'offset_dst' => '-09:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '435',
  'name' => 'Pacific/Midway',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '436',
  'name' => 'Pacific/Nauru',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '437',
  'name' => 'Pacific/Niue',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '438',
  'name' => 'Pacific/Norfolk',
  'offset' => '11:30:00',
  'offset_dst' => '11:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '439',
  'name' => 'Pacific/Noumea',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '440',
  'name' => 'Pacific/Pago Pago',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '441',
  'name' => 'Pacific/Palau',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '442',
  'name' => 'Pacific/Pitcairn',
  'offset' => '-08:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '443',
  'name' => 'Pacific/Ponape',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '444',
  'name' => 'Pacific/Port Moresby',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '445',
  'name' => 'Pacific/Rarotonga',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '446',
  'name' => 'Pacific/Saipan',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '447',
  'name' => 'Pacific/Samoa',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '448',
  'name' => 'Pacific/Tahiti',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '449',
  'name' => 'Pacific/Tarawa',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '450',
  'name' => 'Pacific/Tongatapu',
  'offset' => '13:00:00',
  'offset_dst' => '13:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '451',
  'name' => 'Pacific/Truk',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '452',
  'name' => 'Pacific/Wake',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '453',
  'name' => 'Pacific/Wallis',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '454',
  'name' => 'Pacific/Yap',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '455',
  'name' => 'Poland',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '456',
  'name' => 'Portugal',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '459',
  'name' => 'Singapore',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '473',
  'name' => 'Turkey',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '474',
  'name' => 'US/Alaska',
  'offset' => '-09:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '475',
  'name' => 'US/Aleutian',
  'offset' => '-10:00:00',
  'offset_dst' => '-09:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '476',
  'name' => 'US/Arizona',
  'offset' => '-07:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '477',
  'name' => 'US/Central',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '478',
  'name' => 'US/East-Indiana',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '479',
  'name' => 'US/Eastern',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '480',
  'name' => 'US/Hawaii',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '481',
  'name' => 'US/Indiana-Starke',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '482',
  'name' => 'US/Michigan',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '483',
  'name' => 'US/Mountain',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '484',
  'name' => 'US/Pacific',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '485',
  'name' => 'US/Samoa',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '486',
  'name' => 'Pacific/French Polynesia-Marquesas Islands',
  'offset' => '-09:30:00',
  'offset_dst' => '-09:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '487',
  'name' => 'Etc/GMT',
  'offset' => '00:00:00',
  'offset_dst' => '00:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->execute();

$connection->schema()->createTable('files', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filepath' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filemime' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filesize' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('files')
->fields(array(
  'fid',
  'uid',
  'filename',
  'filepath',
  'filemime',
  'filesize',
  'status',
  'timestamp',
))
->values(array(
  'fid' => '1',
  'uid' => '1',
  'filename' => 'Image1.png',
  'filepath' => 'core/modules/simpletest/files/image-1.png',
  'filemime' => 'image/png',
  'filesize' => '39325',
  'status' => '1',
  'timestamp' => '1388880660',
))
->values(array(
  'fid' => '2',
  'uid' => '1',
  'filename' => 'Image2.jpg',
  'filepath' => 'core/modules/simpletest/files/image-2.jpg',
  'filemime' => 'image/jpeg',
  'filesize' => '1831',
  'status' => '1',
  'timestamp' => '1388880664',
))
->values(array(
  'fid' => '3',
  'uid' => '1',
  'filename' => 'Image-test.gif',
  'filepath' => 'core/modules/simpletest/files/image-test.gif',
  'filemime' => 'image/jpeg',
  'filesize' => '183',
  'status' => '1',
  'timestamp' => '1388880668',
))
->values(array(
  'fid' => '5',
  'uid' => '1',
  'filename' => 'html-1.txt',
  'filepath' => 'core/modules/simpletest/files/html-1.txt',
  'filemime' => 'text/plain',
  'filesize' => '24',
  'status' => '1',
  'timestamp' => '1420858106',
))
->values(array(
  'fid' => '6',
  'uid' => '1',
  'filename' => 'some-temp-file.jpg',
  'filepath' => '/tmp/some-temp-file.jpg',
  'filemime' => 'image/jpeg',
  'filesize' => '24',
  'status' => '0',
  'timestamp' => '1420858106',
))
->execute();

$connection->schema()->createTable('filter_formats', array(
  'fields' => array(
    'format' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'roles' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'format',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('filter_formats')
->fields(array(
  'format',
  'name',
  'roles',
  'cache',
))
->values(array(
  'format' => '1',
  'name' => 'Filtered HTML',
  'roles' => ',1,2,',
  'cache' => '1',
))
->values(array(
  'format' => '2',
  'name' => 'Full HTML',
  'roles' => '3',
  'cache' => '1',
))
->values(array(
  'format' => '3',
  'name' => 'Escape HTML Filter',
  'roles' => '',
  'cache' => '1',
))
->values(array(
  'format' => '4',
  'name' => 'PHP Code',
  'roles' => ',3,4,5,',
  'cache' => '0',
))
->execute();

$connection->schema()->createTable('filters', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('filters')
->fields(array(
  'fid',
  'format',
  'module',
  'delta',
  'weight',
))
->values(array(
  'fid' => '1',
  'format' => '1',
  'module' => 'filter',
  'delta' => '2',
  'weight' => '0',
))
->values(array(
  'fid' => '2',
  'format' => '1',
  'module' => 'filter',
  'delta' => '0',
  'weight' => '1',
))
->values(array(
  'fid' => '3',
  'format' => '1',
  'module' => 'filter',
  'delta' => '1',
  'weight' => '2',
))
->values(array(
  'fid' => '4',
  'format' => '1',
  'module' => 'filter',
  'delta' => '3',
  'weight' => '10',
))
->values(array(
  'fid' => '5',
  'format' => '2',
  'module' => 'filter',
  'delta' => '2',
  'weight' => '0',
))
->values(array(
  'fid' => '6',
  'format' => '2',
  'module' => 'filter',
  'delta' => '1',
  'weight' => '1',
))
->values(array(
  'fid' => '7',
  'format' => '2',
  'module' => 'filter',
  'delta' => '3',
  'weight' => '10',
))
->values(array(
  'fid' => '8',
  'format' => '6',
  'module' => 'filter',
  'delta' => '2',
  'weight' => '0',
))
->values(array(
  'fid' => '9',
  'format' => '6',
  'module' => 'filter',
  'delta' => '0',
  'weight' => '1',
))
->values(array(
  'fid' => '10',
  'format' => '6',
  'module' => 'filter',
  'delta' => '1',
  'weight' => '2',
))
->values(array(
  'fid' => '11',
  'format' => '6',
  'module' => 'filter',
  'delta' => '3',
  'weight' => '10',
))
->values(array(
  'fid' => '16',
  'format' => '4',
  'module' => 'php',
  'delta' => '0',
  'weight' => '10',
))
->execute();

$connection->schema()->createTable('flood', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'event' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('history', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'uid',
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('imagecache_action', array(
  'fields' => array(
    'actionid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'presetid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'action' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'data' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'actionid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('imagecache_action')
->fields(array(
  'actionid',
  'presetid',
  'weight',
  'module',
  'action',
  'data',
))
->values(array(
  'actionid' => '3',
  'presetid' => '1',
  'weight' => '0',
  'module' => 'imagecache',
  'action' => 'imagecache_scale_and_crop',
  'data' => 'a:2:{s:5:"width";s:4:"100%";s:6:"height";s:4:"100%";}',
))
->values(array(
  'actionid' => '4',
  'presetid' => '2',
  'weight' => '0',
  'module' => 'imagecache',
  'action' => 'imagecache_crop',
  'data' => 'a:4:{s:5:"width";s:3:"555";s:6:"height";s:4:"5555";s:7:"xoffset";s:6:"center";s:7:"yoffset";s:6:"center";}',
))
->values(array(
  'actionid' => '5',
  'presetid' => '2',
  'weight' => '0',
  'module' => 'imagecache',
  'action' => 'imagecache_resize',
  'data' => 'a:2:{s:5:"width";s:3:"55%";s:6:"height";s:3:"55%";}',
))
->values(array(
  'actionid' => '6',
  'presetid' => '2',
  'weight' => '0',
  'module' => 'imagecache',
  'action' => 'imagecache_rotate',
  'data' => 'a:3:{s:7:"degrees";s:2:"55";s:6:"random";i:0;s:7:"bgcolor";s:0:"";}',
))
->execute();

$connection->schema()->createTable('imagecache_preset', array(
  'fields' => array(
    'presetid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'presetname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'presetid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('imagecache_preset')
->fields(array(
  'presetid',
  'presetname',
))
->values(array(
  'presetid' => '1',
  'presetname' => 'slackjaw_boys',
))
->values(array(
  'presetid' => '2',
  'presetname' => 'big_blue_cheese',
))
->execute();

$connection->schema()->createTable('languages', array(
  'fields' => array(
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'native' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'direction' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'enabled' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'plurals' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'formula' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'domain' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'prefix' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'javascript' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'language',
  ),
  'indexes' => array(
    'list' => array(
      'weight',
      'name',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('languages')
->fields(array(
  'language',
  'name',
  'native',
  'direction',
  'enabled',
  'plurals',
  'formula',
  'domain',
  'prefix',
  'weight',
  'javascript',
))
->values(array(
  'language' => 'en',
  'name' => 'English',
  'native' => 'English',
  'direction' => '0',
  'enabled' => '1',
  'plurals' => '0',
  'formula' => '',
  'domain' => '',
  'prefix' => '',
  'weight' => '0',
  'javascript' => '',
))
->values(array(
  'language' => 'fr',
  'name' => 'French',
  'native' => 'Français',
  'direction' => '0',
  'enabled' => '1',
  'plurals' => '2',
  'formula' => '($n>1)',
  'domain' => '',
  'prefix' => 'fr',
  'weight' => '0',
  'javascript' => '',
))
->execute();

$connection->schema()->createTable('locales_source', array(
  'fields' => array(
    'lid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'location' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'textgroup' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => 'default',
    ),
    'source' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'version' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '20',
      'default' => 'none',
    ),
  ),
  'primary key' => array(
    'lid',
  ),
  'indexes' => array(
    'source' => array(
      array(
        'source',
        '30',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('locales_source')
->fields(array(
  'lid',
  'location',
  'textgroup',
  'source',
  'version',
))
->values(array(
  'lid' => '1',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'Unspecified error',
  'version' => 'none',
))
->values(array(
  'lid' => '2',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'An error occurred. \n@uri\n@text',
  'version' => 'none',
))
->values(array(
  'lid' => '3',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'An error occurred. \n@uri\n(no information available).',
  'version' => 'none',
))
->values(array(
  'lid' => '4',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'An HTTP error @status occurred. \n@uri',
  'version' => 'none',
))
->values(array(
  'lid' => '5',
  'location' => 'content.module:21',
  'textgroup' => 'default',
  'source' => 'The content module, a required component of the Content Construction Kit (CCK), allows administrators to associate custom fields with content types. In Drupal, content types are used to define the characteristics of a post, including the title and description of the fields displayed on its add and edit pages. Using the content module (and the other helper modules included in CCK), custom fields beyond the default "Title" and "Body" may be added. CCK features are accessible through tabs on the <a href="@content-types">content types administration page</a>. (See the <a href="@node-help">node module help page</a> for more information about content types.)',
  'version' => 'none',
))
->values(array(
  'lid' => '6',
  'location' => 'content.module:22',
  'textgroup' => 'default',
  'source' => 'When adding a custom field to a content type, you determine its type (whether it will contain text, numbers, or references to other objects) and how it will be displayed (either as a text field or area, a select box, checkbox, radio button, or autocompleting field). A field may have multiple values (i.e., a "person" may have multiple e-mail addresses) or a single value (i.e., an "employee" has a single employee identification number). As you add and edit fields, CCK automatically adjusts the structure of the database as necessary. CCK also provides a number of other features, including intelligent caching for your custom data, an import and export facility for content type definitions, and integration with other contributed modules.',
  'version' => 'none',
))
->values(array(
  'lid' => '7',
  'location' => 'content.module:23',
  'textgroup' => 'default',
  'source' => 'Custom field types are provided by a set of optional modules included with CCK (each module provides a different type). The <a href="@modules">modules page</a> allows you to enable or disable CCK components. A default installation of CCK includes:',
  'version' => 'none',
))
->values(array(
  'lid' => '8',
  'location' => 'content.module:25',
  'textgroup' => 'default',
  'source' => '<em>number</em>, which adds numeric field types, in integer, decimal or floating point form. You may define a set of allowed inputs, or specify an allowable range of values. A variety of common formats for displaying numeric data are available.',
  'version' => 'none',
))
->values(array(
  'lid' => '9',
  'location' => 'content.module:26',
  'textgroup' => 'default',
  'source' => "<em>text</em>, which adds text field types. A text field may contain plain text only, or optionally, may use Drupal's input format filters to securely manage rich text input. Text input fields may be either a single line (text field), multiple lines (text area), or for greater input control, a select box, checkbox, or radio buttons. If desired, CCK can validate the input to a set of allowed values.",
  'version' => 'none',
))
->values(array(
  'lid' => '10',
  'location' => 'content.module:27',
  'textgroup' => 'default',
  'source' => '<em>nodereference</em>, which creates custom references between Drupal nodes. By adding a <em>nodereference</em> field and two different content types, for instance, you can easily create complex parent/child relationships between data (multiple "employee" nodes may contain a <em>nodereference</em> field linking to an "employer" node).',
  'version' => 'none',
))
->values(array(
  'lid' => '11',
  'location' => 'content.module:28',
  'textgroup' => 'default',
  'source' => "<em>userreference</em>, which creates custom references to your sites' user accounts. By adding a <em>userreference</em> field, you can create complex relationships between your site's users and posts. To track user involvement in a post beyond Drupal's standard <em>Authored by</em> field, for instance, add a <em>userreference</em> field named \"Edited by\" to a content type to store a link to an editor's user account page.",
  'version' => 'none',
))
->values(array(
  'lid' => '12',
  'location' => 'content.module:29',
  'textgroup' => 'default',
  'source' => '<em>fieldgroup</em>, which creates collapsible fieldsets to hold a group of related fields. A fieldset may either be open or closed by default. The order of your fieldsets, and the order of fields within a fieldset, is managed via a drag-and-drop interface provided by content module.',
  'version' => 'none',
))
->values(array(
  'lid' => '13',
  'location' => 'content.module:31',
  'textgroup' => 'default',
  'source' => 'For more information, see the online handbook entry for <a href="@handbook-cck">CCK</a> or the <a href="@project-cck">CCK project page</a>.',
  'version' => 'none',
))
->values(array(
  'lid' => '14',
  'location' => 'theme/theme.inc:111',
  'textgroup' => 'default',
  'source' => "Configure how this content type's fields and field labels should be displayed when it's viewed in teaser and full-page mode.",
  'version' => 'none',
))
->values(array(
  'lid' => '15',
  'location' => 'theme/theme.inc:114',
  'textgroup' => 'default',
  'source' => "Configure how this content type's fields should be displayed when it's rendered in the following contexts.",
  'version' => 'none',
))
->values(array(
  'lid' => '16',
  'location' => 'content.module:48',
  'textgroup' => 'default',
  'source' => 'Control the order of fields in the input form.',
  'version' => 'none',
))
->values(array(
  'lid' => '17',
  'location' => 'content.module:486,  modules/content_multigroup/content_multigroup.module:1422',
  'textgroup' => 'default',
  'source' => 'This field is required.',
  'version' => 'none',
))
->values(array(
  'lid' => '18',
  'location' => 'content.module:490',
  'textgroup' => 'default',
  'source' => '!title: !required',
  'version' => 'none',
))
->values(array(
  'lid' => '19',
  'location' => 'content.module:493,  modules/content_multigroup/content_multigroup.module:1434',
  'textgroup' => 'default',
  'source' => 'Order',
  'version' => 'none',
))
->values(array(
  'lid' => '20',
  'location' => 'content.module:1640',
  'textgroup' => 'default',
  'source' => 'RSS Item',
  'version' => 'none',
))
->values(array(
  'lid' => '21',
  'location' => 'content.module:1897',
  'textgroup' => 'default',
  'source' => 'Search Index',
  'version' => 'none',
))
->values(array(
  'lid' => '22',
  'location' => 'content.module:1901',
  'textgroup' => 'default',
  'source' => 'Search Result',
  'version' => 'none',
))
->values(array(
  'lid' => '23',
  'location' => 'content.module:2363',
  'textgroup' => 'default',
  'source' => 'Language',
  'version' => 'none',
))
->values(array(
  'lid' => '24',
  'location' => 'content.module:2377',
  'textgroup' => 'default',
  'source' => 'Taxonomy',
  'version' => 'none',
))
->values(array(
  'lid' => '25',
  'location' => 'content.module:2408',
  'textgroup' => 'default',
  'source' => 'File attachments',
  'version' => 'none',
))
->values(array(
  'lid' => '26',
  'location' => 'content.module:600',
  'textgroup' => 'default',
  'source' => 'Updating field type %type with module %module.',
  'version' => 'none',
))
->values(array(
  'lid' => '27',
  'location' => 'content.module:607',
  'textgroup' => 'default',
  'source' => 'Updating widget type %type with module %module.',
  'version' => 'none',
))
->values(array(
  'lid' => '28',
  'location' => 'content.module:63',
  'textgroup' => 'default',
  'source' => 'Use PHP input for field settings (dangerous - grant with care)',
  'version' => 'none',
))
->values(array(
  'lid' => '29',
  'location' => 'content.module:104',
  'textgroup' => 'default',
  'source' => 'Manage fields',
  'version' => 'none',
))
->values(array(
  'lid' => '30',
  'location' => 'content.module:113',
  'textgroup' => 'default',
  'source' => 'Display fields',
  'version' => 'none',
))
->values(array(
  'lid' => '31',
  'location' => 'content.module:143',
  'textgroup' => 'default',
  'source' => 'General',
  'version' => 'none',
))
->values(array(
  'lid' => '32',
  'location' => 'content.module:149',
  'textgroup' => 'default',
  'source' => 'Advanced',
  'version' => 'none',
))
->values(array(
  'lid' => '33',
  'location' => 'content.module:144',
  'textgroup' => 'default',
  'source' => 'Remove field',
  'version' => 'none',
))
->values(array(
  'lid' => '34',
  'location' => 'content.info:0,  includes/content.rules.inc:19;200,  includes/views/content.views.inc:178;254',
  'textgroup' => 'default',
  'source' => 'Content',
  'version' => 'none',
))
->values(array(
  'lid' => '35',
  'location' => 'content.info:0',
  'textgroup' => 'default',
  'source' => 'Allows administrators to define new content types.',
  'version' => 'none',
))
->values(array(
  'lid' => '36',
  'location' => 'content.info:0,  modules/content_copy/content_copy.info:0,  modules/content_multigroup/content_multigroup.info:0,  modules/content_permissions/content_permissions.info:0',
  'textgroup' => 'default',
  'source' => 'CCK',
  'version' => 'none',
))
->values(array(
  'lid' => '37',
  'location' => 'modules/text/text.module:41,  modules/text/text.info:0',
  'textgroup' => 'default',
  'source' => 'Text',
  'version' => 'none',
))
->values(array(
  'lid' => '38',
  'location' => 'examples/example_field.php:178',
  'textgroup' => 'default',
  'source' => 'The possible values this field can contain. Enter one value per line, in the format key|label. The key is the value that will be stored in the database and it must match the field storage type, %type. The label is optional and the key will be used as the label if no label is specified.',
  'version' => 'none',
))
->values(array(
  'lid' => '39',
  'location' => 'examples/example_field.php:484',
  'textgroup' => 'default',
  'source' => 'Text area',
  'version' => 'none',
))
->values(array(
  'lid' => '40',
  'location' => 'includes/content.admin.inc:148;164;790,  modules/fieldgroup/fieldgroup.module:236',
  'textgroup' => 'default',
  'source' => 'Remove',
  'version' => 'none',
))
->values(array(
  'lid' => '41',
  'location' => 'content.module:1868',
  'textgroup' => 'default',
  'source' => 'Basic',
  'version' => 'none',
))
->values(array(
  'lid' => '42',
  'location' => 'content.module:1635 modules/nodereference/nodereference.module:215',
  'textgroup' => 'default',
  'source' => 'Teaser',
  'version' => 'none',
))
->values(array(
  'lid' => '43',
  'location' => 'content.module:1636 modules/nodereference/nodereference.module:210',
  'textgroup' => 'default',
  'source' => 'Full node',
  'version' => 'none',
))
->values(array(
  'lid' => '44',
  'location' => 'content.module:1881;1884',
  'textgroup' => 'default',
  'source' => 'RSS',
  'version' => 'none',
))
->values(array(
  'lid' => '45',
  'location' => 'content.module:1894',
  'textgroup' => 'default',
  'source' => 'Search',
  'version' => 'none',
))
->values(array(
  'lid' => '46',
  'location' => 'content.module:2349;2356',
  'textgroup' => 'default',
  'source' => 'Node module form.',
  'version' => 'none',
))
->values(array(
  'lid' => '47',
  'location' => 'content.module:2364',
  'textgroup' => 'default',
  'source' => 'Locale module form.',
  'version' => 'none',
))
->values(array(
  'lid' => '48',
  'location' => 'content.module:2370',
  'textgroup' => 'default',
  'source' => 'Menu settings',
  'version' => 'none',
))
->values(array(
  'lid' => '49',
  'location' => 'content.module:2371',
  'textgroup' => 'default',
  'source' => 'Menu module form.',
  'version' => 'none',
))
->values(array(
  'lid' => '50',
  'location' => 'content.module:2378',
  'textgroup' => 'default',
  'source' => 'Taxonomy module form.',
  'version' => 'none',
))
->values(array(
  'lid' => '51',
  'location' => 'content.module:2384',
  'textgroup' => 'default',
  'source' => 'Book',
  'version' => 'none',
))
->values(array(
  'lid' => '52',
  'location' => 'content.module:2385',
  'textgroup' => 'default',
  'source' => 'Book module form.',
  'version' => 'none',
))
->values(array(
  'lid' => '53',
  'location' => 'content.module:2391',
  'textgroup' => 'default',
  'source' => 'Poll title',
  'version' => 'none',
))
->values(array(
  'lid' => '54',
  'location' => 'content.module:2392',
  'textgroup' => 'default',
  'source' => 'Poll module title.',
  'version' => 'none',
))
->values(array(
  'lid' => '55',
  'location' => 'content.module:2396',
  'textgroup' => 'default',
  'source' => 'Poll choices',
  'version' => 'none',
))
->values(array(
  'lid' => '56',
  'location' => 'content.module:2397',
  'textgroup' => 'default',
  'source' => 'Poll module choices.',
  'version' => 'none',
))
->values(array(
  'lid' => '57',
  'location' => 'content.module:2401',
  'textgroup' => 'default',
  'source' => 'Poll settings',
  'version' => 'none',
))
->values(array(
  'lid' => '58',
  'location' => 'content.module:2402',
  'textgroup' => 'default',
  'source' => 'Poll module settings.',
  'version' => 'none',
))
->values(array(
  'lid' => '59',
  'location' => 'content.module:2409',
  'textgroup' => 'default',
  'source' => 'Upload module form.',
  'version' => 'none',
))
->values(array(
  'lid' => '60',
  'location' => 'content.module:557;564;0 includes/content.crud.inc:591;629',
  'textgroup' => 'default',
  'source' => 'content',
  'version' => 'none',
))
->values(array(
  'lid' => '61',
  'location' => 'content.module:103 modules/content_copy/content_copy.module:125',
  'textgroup' => 'default',
  'source' => 'Fields',
  'version' => 'none',
))
->values(array(
  'lid' => '62',
  'location' => 'content.install:236',
  'textgroup' => 'default',
  'source' => "Updates for CCK-related modules are not run until the modules are enabled on the <a href=\"@admin-modules-path\">administer modules page</a>. When you enable them, you'll need to return to <a href=\"@update-php\">update.php</a> and run the remaining updates.",
  'version' => 'none',
))
->values(array(
  'lid' => '63',
  'location' => 'content.install:239',
  'textgroup' => 'default',
  'source' => '!module.module has updates but cannot be updated because content.module is not enabled.<br />If and when content.module is enabled, you will need to re-run the update script. You will continue to see this message until the module is enabled and updates are run.',
  'version' => 'none',
))
->values(array(
  'lid' => '64',
  'location' => 'content.install:244',
  'textgroup' => 'default',
  'source' => '!module.module has updates and is available in the modules folder but is not enabled.<br />If and when it is enabled, you will need to re-run the update script. You will continue to see this message until the module is enabled and updates are run.',
  'version' => 'none',
))
->values(array(
  'lid' => '65',
  'location' => 'content.install:251',
  'textgroup' => 'default',
  'source' => 'Some updates are still pending. Please return to <a href="@update-php">update.php</a> and run the remaining updates.',
  'version' => 'none',
))
->values(array(
  'lid' => '66',
  'location' => '(duplicate) content.install:10',
  'textgroup' => 'default',
  'source' => 'CCK - No Views integration',
  'version' => 'none',
))
->values(array(
  'lid' => '67',
  'location' => '(duplicate) content.install:11',
  'textgroup' => 'default',
  'source' => 'CCK integration with Views module requires Views 6.x-2.0-rc2 or greater.',
  'version' => 'none',
))
->values(array(
  'lid' => '68',
  'location' => 'includes/content.admin.inc:16;212',
  'textgroup' => 'default',
  'source' => 'Name',
  'version' => 'none',
))
->values(array(
  'lid' => '69',
  'location' => 'includes/content.admin.inc:16;212',
  'textgroup' => 'default',
  'source' => 'Type',
  'version' => 'none',
))
->values(array(
  'lid' => '70',
  'location' => 'includes/content.admin.inc:16 modules/fieldgroup/fieldgroup.module:156',
  'textgroup' => 'default',
  'source' => 'Description',
  'version' => 'none',
))
->values(array(
  'lid' => '71',
  'location' => 'includes/content.admin.inc:16;212',
  'textgroup' => 'default',
  'source' => 'Operations',
  'version' => 'none',
))
->values(array(
  'lid' => '72',
  'location' => 'includes/content.admin.inc:30',
  'textgroup' => 'default',
  'source' => 'edit',
  'version' => 'none',
))
->values(array(
  'lid' => '73',
  'location' => 'includes/content.admin.inc:34',
  'textgroup' => 'default',
  'source' => 'manage fields',
  'version' => 'none',
))
->values(array(
  'lid' => '74',
  'location' => 'includes/content.admin.inc:37',
  'textgroup' => 'default',
  'source' => 'delete',
  'version' => 'none',
))
->values(array(
  'lid' => '75',
  'location' => 'includes/content.admin.inc:48',
  'textgroup' => 'default',
  'source' => 'No content types available.',
  'version' => 'none',
))
->values(array(
  'lid' => '76',
  'location' => 'includes/content.admin.inc:55',
  'textgroup' => 'default',
  'source' => '» Add a new content type',
  'version' => 'none',
))
->values(array(
  'lid' => '77',
  'location' => 'includes/content.admin.inc:64;602;856',
  'textgroup' => 'default',
  'source' => 'Field name',
  'version' => 'none',
))
->values(array(
  'lid' => '78',
  'location' => 'includes/content.admin.inc:64;632;643;862',
  'textgroup' => 'default',
  'source' => 'Field type',
  'version' => 'none',
))
->values(array(
  'lid' => '79',
  'location' => 'includes/content.admin.inc:64',
  'textgroup' => 'default',
  'source' => 'Used in',
  'version' => 'none',
))
->values(array(
  'lid' => '80',
  'location' => 'includes/content.admin.inc:71',
  'textgroup' => 'default',
  'source' => '@field_name (Locked)',
  'version' => 'none',
))
->values(array(
  'lid' => '81',
  'location' => 'includes/content.admin.inc:87',
  'textgroup' => 'default',
  'source' => 'No fields have been defined for any content type yet.',
  'version' => 'none',
))
->values(array(
  'lid' => '82',
  'location' => 'includes/content.admin.inc:106',
  'textgroup' => 'default',
  'source' => 'This content type has inactive fields. Inactive fields are not included in lists of available fields until their modules are enabled.',
  'version' => 'none',
))
->values(array(
  'lid' => '83',
  'location' => 'includes/content.admin.inc:108',
  'textgroup' => 'default',
  'source' => '!field (!field_name) is an inactive !field_type field that uses a !widget_type widget.',
  'version' => 'none',
))
->values(array(
  'lid' => '84',
  'location' => 'includes/content.admin.inc:147;163',
  'textgroup' => 'default',
  'source' => 'Configure',
  'version' => 'none',
))
->values(array(
  'lid' => '85',
  'location' => 'includes/content.admin.inc:181',
  'textgroup' => 'default',
  'source' => 'Locked',
  'version' => 'none',
))
->values(array(
  'lid' => '86',
  'location' => 'includes/content.admin.inc:237',
  'textgroup' => 'default',
  'source' => '- Select a field type -',
  'version' => 'none',
))
->values(array(
  'lid' => '87',
  'location' => 'includes/content.admin.inc:238',
  'textgroup' => 'default',
  'source' => '- Select a widget -',
  'version' => 'none',
))
->values(array(
  'lid' => '88',
  'location' => 'includes/content.admin.inc:212;413;623;850,  modules/fieldgroup/fieldgroup.module:121',
  'textgroup' => 'default',
  'source' => 'Label',
  'version' => 'none',
))
->values(array(
  'lid' => '89',
  'location' => 'includes/content.admin.inc:253',
  'textgroup' => 'default',
  'source' => 'Field name (a-z, 0-9, _)',
  'version' => 'none',
))
->values(array(
  'lid' => '90',
  'location' => 'includes/content.admin.inc:258',
  'textgroup' => 'default',
  'source' => 'Type of data to store.',
  'version' => 'none',
))
->values(array(
  'lid' => '91',
  'location' => 'includes/content.admin.inc:263;295',
  'textgroup' => 'default',
  'source' => 'Form element to edit the data.',
  'version' => 'none',
))
->values(array(
  'lid' => '92',
  'location' => 'includes/content.admin.inc:279',
  'textgroup' => 'default',
  'source' => '- Select an existing field -',
  'version' => 'none',
))
->values(array(
  'lid' => '93',
  'location' => 'includes/content.admin.inc:290',
  'textgroup' => 'default',
  'source' => 'Field to share',
  'version' => 'none',
))
->values(array(
  'lid' => '94',
  'location' => 'includes/content.admin.inc:324',
  'textgroup' => 'default',
  'source' => 'Group name (a-z, 0-9, _)',
  'version' => 'none',
))
->values(array(
  'lid' => '95',
  'location' => 'includes/content.admin.inc:201;402,  modules/fieldgroup/fieldgroup.module:110;363',
  'textgroup' => 'default',
  'source' => 'Save',
  'version' => 'none',
))
->values(array(
  'lid' => '96',
  'location' => 'includes/content.admin.inc:365',
  'textgroup' => 'default',
  'source' => 'Add new field: you need to provide a label.',
  'version' => 'none',
))
->values(array(
  'lid' => '97',
  'location' => 'includes/content.admin.inc:370',
  'textgroup' => 'default',
  'source' => 'Add new field: you need to provide a field name.',
  'version' => 'none',
))
->values(array(
  'lid' => '98',
  'location' => 'includes/content.admin.inc:384',
  'textgroup' => 'default',
  'source' => 'Add new field: the field name %field_name is invalid. The name must include only lowercase unaccentuated letters, numbers, and underscores.',
  'version' => 'none',
))
->values(array(
  'lid' => '99',
  'location' => 'includes/content.admin.inc:387',
  'textgroup' => 'default',
  'source' => "Add new field: the field name %field_name is too long. The name is limited to 32 characters, including the 'field_' prefix.",
  'version' => 'none',
))
->values(array(
  'lid' => '100',
  'location' => 'includes/content.admin.inc:391',
  'textgroup' => 'default',
  'source' => "Add new field: the name 'field_instance' is a reserved name.",
  'version' => 'none',
))
->values(array(
  'lid' => '101',
  'location' => 'includes/content.admin.inc:403',
  'textgroup' => 'default',
  'source' => 'Add new field: the field name %field_name already exists.',
  'version' => 'none',
))
->values(array(
  'lid' => '102',
  'location' => 'includes/content.admin.inc:409',
  'textgroup' => 'default',
  'source' => 'Add new field: you need to select a field type.',
  'version' => 'none',
))
->values(array(
  'lid' => '103',
  'location' => 'includes/content.admin.inc:414',
  'textgroup' => 'default',
  'source' => 'Add new field: you need to select a widget.',
  'version' => 'none',
))
->values(array(
  'lid' => '104',
  'location' => 'includes/content.admin.inc:420',
  'textgroup' => 'default',
  'source' => 'Add new field: invalid widget.',
  'version' => 'none',
))
->values(array(
  'lid' => '105',
  'location' => 'includes/content.admin.inc:441',
  'textgroup' => 'default',
  'source' => 'Add existing field: you need to provide a label.',
  'version' => 'none',
))
->values(array(
  'lid' => '106',
  'location' => 'includes/content.admin.inc:446',
  'textgroup' => 'default',
  'source' => 'Add existing field: you need to select a field.',
  'version' => 'none',
))
->values(array(
  'lid' => '107',
  'location' => 'includes/content.admin.inc:451',
  'textgroup' => 'default',
  'source' => 'Add existing field: you need to select a widget.',
  'version' => 'none',
))
->values(array(
  'lid' => '108',
  'location' => 'includes/content.admin.inc:457',
  'textgroup' => 'default',
  'source' => 'Add existing field: invalid widget.',
  'version' => 'none',
))
->values(array(
  'lid' => '109',
  'location' => 'includes/content.admin.inc:745',
  'textgroup' => 'default',
  'source' => 'There was a problem creating field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '110',
  'location' => 'includes/content.admin.inc:518',
  'textgroup' => 'default',
  'source' => 'The field %label cannot be added to a content type because it is locked.',
  'version' => 'none',
))
->values(array(
  'lid' => '111',
  'location' => 'includes/content.admin.inc:550',
  'textgroup' => 'default',
  'source' => 'There was a problem adding field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '112',
  'location' => 'includes/content.admin.inc:571',
  'textgroup' => 'default',
  'source' => 'There are no fields configured for this content type. You can add new fields on the <a href="@link">Manage fields</a> page.',
  'version' => 'none',
))
->values(array(
  'lid' => '113',
  'location' => 'includes/content.admin.inc:319;360',
  'textgroup' => 'default',
  'source' => 'Above',
  'version' => 'none',
))
->values(array(
  'lid' => '114',
  'location' => 'includes/content.admin.inc:320',
  'textgroup' => 'default',
  'source' => 'Inline',
  'version' => 'none',
))
->values(array(
  'lid' => '115',
  'location' => 'includes/content.admin.inc:618;661',
  'textgroup' => 'default',
  'source' => 'Include',
  'version' => 'none',
))
->values(array(
  'lid' => '116',
  'location' => 'includes/content.admin.inc:618;661,  theme/content-admin-display-overview-form.tpl.php:17',
  'textgroup' => 'default',
  'source' => 'Exclude',
  'version' => 'none',
))
->values(array(
  'lid' => '117',
  'location' => 'includes/content.admin.inc:364',
  'textgroup' => 'default',
  'source' => 'no styling',
  'version' => 'none',
))
->values(array(
  'lid' => '118',
  'location' => 'includes/content.admin.inc:365',
  'textgroup' => 'default',
  'source' => 'simple',
  'version' => 'none',
))
->values(array(
  'lid' => '119',
  'location' => 'includes/content.admin.inc:366',
  'textgroup' => 'default',
  'source' => 'fieldset',
  'version' => 'none',
))
->values(array(
  'lid' => '120',
  'location' => 'includes/content.admin.inc:367',
  'textgroup' => 'default',
  'source' => 'fieldset - collapsible',
  'version' => 'none',
))
->values(array(
  'lid' => '121',
  'location' => 'includes/content.admin.inc:368',
  'textgroup' => 'default',
  'source' => 'fieldset - collapsed',
  'version' => 'none',
))
->values(array(
  'lid' => '122',
  'location' => 'includes/content.admin.inc:460',
  'textgroup' => 'default',
  'source' => 'Your settings have been saved.',
  'version' => 'none',
))
->values(array(
  'lid' => '123',
  'location' => 'includes/content.admin.inc:760',
  'textgroup' => 'default',
  'source' => '@type: @field (@label)',
  'version' => 'none',
))
->values(array(
  'lid' => '124',
  'location' => 'includes/content.admin.inc:597',
  'textgroup' => 'default',
  'source' => 'Edit basic information',
  'version' => 'none',
))
->values(array(
  'lid' => '125',
  'location' => 'includes/content.admin.inc:792',
  'textgroup' => 'default',
  'source' => 'The machine-readable name of the field. This name cannot be changed.',
  'version' => 'none',
))
->values(array(
  'lid' => '126',
  'location' => 'includes/content.admin.inc:626',
  'textgroup' => 'default',
  'source' => 'A human-readable name to be used as the label for this field in the %type content type.',
  'version' => 'none',
))
->values(array(
  'lid' => '127',
  'location' => 'includes/content.admin.inc:646',
  'textgroup' => 'default',
  'source' => 'The type of data you would like to store in the database with this field. This option cannot be changed.',
  'version' => 'none',
))
->values(array(
  'lid' => '128',
  'location' => 'includes/content.admin.inc:651;869',
  'textgroup' => 'default',
  'source' => 'Widget type',
  'version' => 'none',
))
->values(array(
  'lid' => '129',
  'location' => 'includes/content.admin.inc:655',
  'textgroup' => 'default',
  'source' => 'The type of form element you would like to present to the user when creating this field in the %type content type.',
  'version' => 'none',
))
->values(array(
  'lid' => '130',
  'location' => 'includes/content.admin.inc:669',
  'textgroup' => 'default',
  'source' => 'Continue',
  'version' => 'none',
))
->values(array(
  'lid' => '131',
  'location' => 'includes/content.admin.inc:854',
  'textgroup' => 'default',
  'source' => 'Updated basic settings for field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '132',
  'location' => 'includes/content.admin.inc:858',
  'textgroup' => 'default',
  'source' => 'There was a problem updating the basic settings for field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '133',
  'location' => 'includes/content.admin.inc:786',
  'textgroup' => 'default',
  'source' => 'Are you sure you want to remove the field %field?',
  'version' => 'none',
))
->values(array(
  'lid' => '134',
  'location' => 'includes/content.admin.inc:789',
  'textgroup' => 'default',
  'source' => 'If you have any content left in this field, it will be lost. This action cannot be undone.',
  'version' => 'none',
))
->values(array(
  'lid' => '135',
  'location' => 'includes/content.admin.inc:790 modules/fieldgroup/fieldgroup.module:236',
  'textgroup' => 'default',
  'source' => 'Cancel',
  'version' => 'none',
))
->values(array(
  'lid' => '136',
  'location' => 'includes/content.admin.inc:894',
  'textgroup' => 'default',
  'source' => 'This field is <strong>locked</strong> and cannot be removed.',
  'version' => 'none',
))
->values(array(
  'lid' => '137',
  'location' => 'includes/content.admin.inc:808',
  'textgroup' => 'default',
  'source' => 'Removed field %field from %type.',
  'version' => 'none',
))
->values(array(
  'lid' => '138',
  'location' => 'includes/content.admin.inc:813',
  'textgroup' => 'default',
  'source' => 'There was a problem deleting %field from %type.',
  'version' => 'none',
))
->values(array(
  'lid' => '139',
  'location' => 'includes/content.admin.inc:939',
  'textgroup' => 'default',
  'source' => 'The field %field is locked and cannot be edited.',
  'version' => 'none',
))
->values(array(
  'lid' => '140',
  'location' => 'includes/content.admin.inc:846',
  'textgroup' => 'default',
  'source' => '%type basic information',
  'version' => 'none',
))
->values(array(
  'lid' => '141',
  'location' => 'includes/content.admin.inc:876',
  'textgroup' => 'default',
  'source' => 'Change basic information',
  'version' => 'none',
))
->values(array(
  'lid' => '142',
  'location' => 'includes/content.admin.inc:882',
  'textgroup' => 'default',
  'source' => '%type settings',
  'version' => 'none',
))
->values(array(
  'lid' => '143',
  'location' => 'includes/content.admin.inc:883',
  'textgroup' => 'default',
  'source' => 'These settings apply only to the %field field as it appears in the %type content type.',
  'version' => 'none',
))
->values(array(
  'lid' => '144',
  'location' => 'includes/content.admin.inc:897 modules/fieldgroup/fieldgroup.module:143',
  'textgroup' => 'default',
  'source' => 'Help text',
  'version' => 'none',
))
->values(array(
  'lid' => '145',
  'location' => 'includes/content.admin.inc:900',
  'textgroup' => 'default',
  'source' => 'Instructions to present to the user below this field on the editing form.<br />Allowed HTML tags: @tags',
  'version' => 'none',
))
->values(array(
  'lid' => '146',
  'location' => 'includes/content.admin.inc:908',
  'textgroup' => 'default',
  'source' => 'Default value',
  'version' => 'none',
))
->values(array(
  'lid' => '147',
  'location' => 'examples/example_field.php:182 includes/content.admin.inc:930,  modules/number/number.module:137 modules/text/text.module:96',
  'textgroup' => 'default',
  'source' => 'PHP code',
  'version' => 'none',
))
->values(array(
  'lid' => '148',
  'location' => 'includes/content.admin.inc:1083;1238,  includes/content.rules.inc:93',
  'textgroup' => 'default',
  'source' => "'@column' => value for @column",
  'version' => 'none',
))
->values(array(
  'lid' => '149',
  'location' => 'includes/content.admin.inc:1085;1240,  includes/content.rules.inc:95',
  'textgroup' => 'default',
  'source' => "return array(\n  0 => array(@columns),\n  // You'll usually want to stop here. Provide more values\n  // if you want your 'default value' to be multi-valued:\n  1 => array(@columns),\n  2 => ...\n);",
  'version' => 'none',
))
->values(array(
  'lid' => '150',
  'location' => 'examples/example_field.php:188 includes/content.admin.inc:951;964,  modules/number/number.module:144;153 modules/text/text.module:103;112',
  'textgroup' => 'default',
  'source' => 'Code',
  'version' => 'none',
))
->values(array(
  'lid' => '151',
  'location' => 'includes/content.admin.inc:1093',
  'textgroup' => 'default',
  'source' => 'Advanced usage only: PHP code that returns a default value. Should not include &lt;?php ?&gt; delimiters. If this field is filled out, the value returned by this code will override any value specified above. Expected format: <pre>!sample</pre>To figure out the expected format, you can use the <em>devel load</em> tab provided by <a href="@link_devel">devel module</a> on a %type content page.',
  'version' => 'none',
))
->values(array(
  'lid' => '152',
  'location' => 'includes/content.admin.inc:965 modules/number/number.module:154,  modules/text/text.module:113',
  'textgroup' => 'default',
  'source' => '&lt;none&gt;',
  'version' => 'none',
))
->values(array(
  'lid' => '153',
  'location' => 'includes/content.admin.inc:966 modules/number/number.module:155,  modules/text/text.module:114',
  'textgroup' => 'default',
  'source' => "You're not allowed to input PHP code.",
  'version' => 'none',
))
->values(array(
  'lid' => '154',
  'location' => 'includes/content.admin.inc:966',
  'textgroup' => 'default',
  'source' => 'This PHP code was set by an administrator and will override any value specified above.',
  'version' => 'none',
))
->values(array(
  'lid' => '155',
  'location' => 'includes/content.admin.inc:973',
  'textgroup' => 'default',
  'source' => 'Global settings',
  'version' => 'none',
))
->values(array(
  'lid' => '156',
  'location' => 'includes/content.admin.inc:974',
  'textgroup' => 'default',
  'source' => 'These settings apply to the %field field in every content type in which it appears.',
  'version' => 'none',
))
->values(array(
  'lid' => '157',
  'location' => 'includes/content.admin.inc:978',
  'textgroup' => 'default',
  'source' => 'Required',
  'version' => 'none',
))
->values(array(
  'lid' => '158',
  'location' => 'includes/content.admin.inc:1119',
  'textgroup' => 'default',
  'source' => 'Maximum number of values users can enter for this field.',
  'version' => 'none',
))
->values(array(
  'lid' => '159',
  'location' => 'includes/content.admin.inc:1121',
  'textgroup' => 'default',
  'source' => "'Unlimited' will provide an 'Add more' button so the users can add as many values as they like.",
  'version' => 'none',
))
->values(array(
  'lid' => '160',
  'location' => 'includes/content.admin.inc:986',
  'textgroup' => 'default',
  'source' => 'Warning! Changing this setting after data has been created could result in the loss of data!',
  'version' => 'none',
))
->values(array(
  'lid' => '161',
  'location' => 'includes/content.admin.inc:983',
  'textgroup' => 'default',
  'source' => 'Number of values',
  'version' => 'none',
))
->values(array(
  'lid' => '162',
  'location' => 'includes/content.admin.inc:984',
  'textgroup' => 'default',
  'source' => 'Unlimited',
  'version' => 'none',
))
->values(array(
  'lid' => '163',
  'location' => 'includes/content.admin.inc:1001',
  'textgroup' => 'default',
  'source' => 'Save field settings',
  'version' => 'none',
))
->values(array(
  'lid' => '164',
  'location' => 'includes/content.admin.inc:1281',
  'textgroup' => 'default',
  'source' => "The PHP code for 'default value' returned @value, which is invalid.",
  'version' => 'none',
))
->values(array(
  'lid' => '165',
  'location' => 'includes/content.admin.inc:1135',
  'textgroup' => 'default',
  'source' => 'The default value is invalid.',
  'version' => 'none',
))
->values(array(
  'lid' => '166',
  'location' => 'includes/content.admin.inc:547',
  'textgroup' => 'default',
  'source' => 'Added field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '167',
  'location' => 'includes/content.admin.inc:1158',
  'textgroup' => 'default',
  'source' => 'Saved field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '168',
  'location' => 'includes/content.admin.inc:1463',
  'textgroup' => 'default',
  'source' => 'Processing',
  'version' => 'none',
))
->values(array(
  'lid' => '169',
  'location' => 'includes/content.admin.inc:1464',
  'textgroup' => 'default',
  'source' => 'The update has encountered an error.',
  'version' => 'none',
))
->values(array(
  'lid' => '170',
  'location' => 'includes/content.admin.inc:1478',
  'textgroup' => 'default',
  'source' => 'The database has been altered and data has been migrated or deleted.',
  'version' => 'none',
))
->values(array(
  'lid' => '171',
  'location' => 'includes/content.admin.inc:1481',
  'textgroup' => 'default',
  'source' => 'An error occurred and database alteration did not complete.',
  'version' => 'none',
))
->values(array(
  'lid' => '172',
  'location' => 'includes/content.admin.inc:1584',
  'textgroup' => 'default',
  'source' => 'Processing %title',
  'version' => 'none',
))
->values(array(
  'lid' => '173',
  'location' => 'includes/content.admin.inc:1849',
  'textgroup' => 'default',
  'source' => '%name must be an integer.',
  'version' => 'none',
))
->values(array(
  'lid' => '174',
  'location' => 'includes/content.admin.inc:1859',
  'textgroup' => 'default',
  'source' => '%name must be a positive integer.',
  'version' => 'none',
))
->values(array(
  'lid' => '175',
  'location' => 'includes/content.admin.inc:1869',
  'textgroup' => 'default',
  'source' => '%name must be a number.',
  'version' => 'none',
))
->values(array(
  'lid' => '176',
  'location' => 'includes/content.admin.inc:1482',
  'textgroup' => 'default',
  'source' => '1 item successfully processed:',
  'version' => 'none',
))
->values(array(
  'lid' => '177',
  'location' => 'includes/content.admin.inc:1482',
  'textgroup' => 'default',
  'source' => '@count items successfully processed:',
  'version' => 'none',
))
->values(array(
  'lid' => '178',
  'location' => 'includes/content.crud.inc:591',
  'textgroup' => 'default',
  'source' => 'Content fields table %old_name has been renamed to %new_name and field instances have been updated.',
  'version' => 'none',
))
->values(array(
  'lid' => '179',
  'location' => 'includes/content.crud.inc:629',
  'textgroup' => 'default',
  'source' => 'The content fields table %name has been deleted.',
  'version' => 'none',
))
->values(array(
  'lid' => '180',
  'location' => 'includes/content.node_form.inc:206',
  'textgroup' => 'default',
  'source' => 'Add another item',
  'version' => 'none',
))
->values(array(
  'lid' => '181',
  'location' => 'includes/content.panels.inc:21;35',
  'textgroup' => 'default',
  'source' => 'Content field',
  'version' => 'none',
))
->values(array(
  'lid' => '182',
  'location' => 'includes/content.panels.inc:38',
  'textgroup' => 'default',
  'source' => 'A content field from the referenced node.',
  'version' => 'none',
))
->values(array(
  'lid' => '183',
  'location' => 'includes/content.panels.inc:39,  modules/fieldgroup/fieldgroup.panels.inc:31',
  'textgroup' => 'default',
  'source' => 'Node',
  'version' => 'none',
))
->values(array(
  'lid' => '184',
  'location' => 'includes/content.panels.inc:40,  modules/fieldgroup/fieldgroup.panels.inc:32',
  'textgroup' => 'default',
  'source' => 'Node context',
  'version' => 'none',
))
->values(array(
  'lid' => '185',
  'location' => 'includes/content.panels.inc:52',
  'textgroup' => 'default',
  'source' => 'Block title',
  'version' => 'none',
))
->values(array(
  'lid' => '186',
  'location' => 'includes/content.panels.inc:55',
  'textgroup' => 'default',
  'source' => 'Hidden',
  'version' => 'none',
))
->values(array(
  'lid' => '187',
  'location' => 'includes/content.panels.inc:57',
  'textgroup' => 'default',
  'source' => 'Configure how the label is going to be displayed.',
  'version' => 'none',
))
->values(array(
  'lid' => '188',
  'location' => 'includes/content.panels.inc:73',
  'textgroup' => 'default',
  'source' => 'Field / Formatter',
  'version' => 'none',
))
->values(array(
  'lid' => '189',
  'location' => 'includes/content.panels.inc:76',
  'textgroup' => 'default',
  'source' => 'Select a field and formatter.',
  'version' => 'none',
))
->values(array(
  'lid' => '190',
  'location' => 'includes/content.panels.inc:92',
  'textgroup' => 'default',
  'source' => '"@s" field @name',
  'version' => 'none',
))
->values(array(
  'lid' => '191',
  'location' => 'includes/content.rules.inc:15',
  'textgroup' => 'default',
  'source' => 'Populate a field',
  'version' => 'none',
))
->values(array(
  'lid' => '192',
  'location' => 'includes/content.rules.inc:23;212',
  'textgroup' => 'default',
  'source' => 'You should make sure that the used field exists in the given content type.',
  'version' => 'none',
))
->values(array(
  'lid' => '193',
  'location' => 'includes/content.admin.inc:413',
  'textgroup' => 'default',
  'source' => 'Field',
  'version' => 'none',
))
->values(array(
  'lid' => '194',
  'location' => 'includes/content.rules.inc:56',
  'textgroup' => 'default',
  'source' => 'Select the machine-name of the field.',
  'version' => 'none',
))
->values(array(
  'lid' => '195',
  'location' => 'includes/content.rules.inc:84',
  'textgroup' => 'default',
  'source' => 'Advanced: Specify the fields value with PHP code',
  'version' => 'none',
))
->values(array(
  'lid' => '196',
  'location' => 'includes/content.rules.inc:102',
  'textgroup' => 'default',
  'source' => "Advanced usage only: PHP code that returns the value to set. Should not include &lt;?php ?&gt; delimiters. If this field is filled out, the value returned by this code will override any value specified above. Expected format: <pre>!sample</pre>Using <a href=\"@link_devel\">devel.module's</a> 'devel load' tab on a content page might help you figure out the expected format.",
  'version' => 'none',
))
->values(array(
  'lid' => '197',
  'location' => 'includes/content.rules.inc:130',
  'textgroup' => 'default',
  'source' => 'You have to return the default value in the expected format.',
  'version' => 'none',
))
->values(array(
  'lid' => '198',
  'location' => 'includes/content.rules.inc:181',
  'textgroup' => 'default',
  'source' => "Populate @node's field '@field'",
  'version' => 'none',
))
->values(array(
  'lid' => '199',
  'location' => 'includes/content.rules.inc:198',
  'textgroup' => 'default',
  'source' => 'Field has value',
  'version' => 'none',
))
->values(array(
  'lid' => '200',
  'location' => 'includes/content.rules.inc:203',
  'textgroup' => 'default',
  'source' => 'You should make sure that the used field exists in the given content type. The condition returns TRUE, if the selected field has the given value.',
  'version' => 'none',
))
->values(array(
  'lid' => '201',
  'location' => 'includes/content.rules.inc:207',
  'textgroup' => 'default',
  'source' => 'Field has changed',
  'version' => 'none',
))
->values(array(
  'lid' => '202',
  'location' => 'includes/content.rules.inc:209',
  'textgroup' => 'default',
  'source' => 'Content containing changes',
  'version' => 'none',
))
->values(array(
  'lid' => '203',
  'location' => 'includes/content.rules.inc:210',
  'textgroup' => 'default',
  'source' => 'Content not containing changes',
  'version' => 'none',
))
->values(array(
  'lid' => '204',
  'location' => 'includes/content.rules.inc:249',
  'textgroup' => 'default',
  'source' => "@node's field '@field' has value",
  'version' => 'none',
))
->values(array(
  'lid' => '205',
  'location' => 'includes/content.rules.inc:269',
  'textgroup' => 'default',
  'source' => 'Select the machine-name of the field to look at.',
  'version' => 'none',
))
->values(array(
  'lid' => '206',
  'location' => 'includes/content.rules.inc:275',
  'textgroup' => 'default',
  'source' => "@node's field '@field' has been changed",
  'version' => 'none',
))
->values(array(
  'lid' => '207',
  'location' => 'includes/content.token.inc:12;15',
  'textgroup' => 'default',
  'source' => 'Token',
  'version' => 'none',
))
->values(array(
  'lid' => '208',
  'location' => 'includes/content.token.inc:60',
  'textgroup' => 'default',
  'source' => 'Referenced node ID',
  'version' => 'none',
))
->values(array(
  'lid' => '209',
  'location' => 'includes/content.token.inc:61',
  'textgroup' => 'default',
  'source' => 'Referenced node title',
  'version' => 'none',
))
->values(array(
  'lid' => '210',
  'location' => 'includes/content.token.inc:83',
  'textgroup' => 'default',
  'source' => 'Referenced node unfiltered title. WARNING - raw user input.',
  'version' => 'none',
))
->values(array(
  'lid' => '211',
  'location' => 'includes/content.token.inc:84',
  'textgroup' => 'default',
  'source' => 'Formatted html link to the referenced node.',
  'version' => 'none',
))
->values(array(
  'lid' => '212',
  'location' => 'includes/content.token.inc:85',
  'textgroup' => 'default',
  'source' => 'Relative path alias to the referenced node.',
  'version' => 'none',
))
->values(array(
  'lid' => '213',
  'location' => 'includes/content.token.inc:86',
  'textgroup' => 'default',
  'source' => 'Absolute path alias to the referenced node.',
  'version' => 'none',
))
->values(array(
  'lid' => '214',
  'location' => 'includes/content.token.inc:86',
  'textgroup' => 'default',
  'source' => 'Raw number value',
  'version' => 'none',
))
->values(array(
  'lid' => '215',
  'location' => 'includes/content.token.inc:87',
  'textgroup' => 'default',
  'source' => 'Formatted number value',
  'version' => 'none',
))
->values(array(
  'lid' => '216',
  'location' => 'includes/content.token.inc:110',
  'textgroup' => 'default',
  'source' => 'Raw, unfiltered text',
  'version' => 'none',
))
->values(array(
  'lid' => '217',
  'location' => 'includes/content.token.inc:111',
  'textgroup' => 'default',
  'source' => 'Formatted and filtered text',
  'version' => 'none',
))
->values(array(
  'lid' => '218',
  'location' => 'includes/content.token.inc:133',
  'textgroup' => 'default',
  'source' => 'Referenced user ID',
  'version' => 'none',
))
->values(array(
  'lid' => '219',
  'location' => 'includes/content.token.inc:134',
  'textgroup' => 'default',
  'source' => 'Referenced user name',
  'version' => 'none',
))
->values(array(
  'lid' => '220',
  'location' => 'includes/content.token.inc:135',
  'textgroup' => 'default',
  'source' => 'Formatted HTML link to referenced user',
  'version' => 'none',
))
->values(array(
  'lid' => '221',
  'location' => 'includes/content.token.inc:164',
  'textgroup' => 'default',
  'source' => 'Relative path alias to the referenced user.',
  'version' => 'none',
))
->values(array(
  'lid' => '222',
  'location' => 'includes/content.token.inc:165',
  'textgroup' => 'default',
  'source' => 'Absolute path alias to the referenced user.',
  'version' => 'none',
))
->values(array(
  'lid' => '223',
  'location' => 'includes/views/content.views.inc:245;261',
  'textgroup' => 'default',
  'source' => '@label (!name)',
  'version' => 'none',
))
->values(array(
  'lid' => '224',
  'location' => 'includes/views/content.views.inc:249',
  'textgroup' => 'default',
  'source' => '@label (!name) - !column',
  'version' => 'none',
))
->values(array(
  'lid' => '225',
  'location' => 'includes/views/content.views.inc:250',
  'textgroup' => 'default',
  'source' => '@label-truncated - !column',
  'version' => 'none',
))
->values(array(
  'lid' => '226',
  'location' => 'includes/content.views.inc:93',
  'textgroup' => 'default',
  'source' => 'Appears in: @types',
  'version' => 'none',
))
->values(array(
  'lid' => '227',
  'location' => 'includes/views/handlers/content_handler_field.inc:59',
  'textgroup' => 'default',
  'source' => 'None',
  'version' => 'none',
))
->values(array(
  'lid' => '228',
  'location' => 'includes/views/handlers/content_handler_field.inc:60',
  'textgroup' => 'default',
  'source' => 'Widget label (@label)',
  'version' => 'none',
))
->values(array(
  'lid' => '229',
  'location' => 'includes/views/handlers/content_handler_field.inc:61',
  'textgroup' => 'default',
  'source' => 'Custom',
  'version' => 'none',
))
->values(array(
  'lid' => '230',
  'location' => 'includes/views/handlers/content_handler_field.inc:67',
  'textgroup' => 'default',
  'source' => 'Custom label',
  'version' => 'none',
))
->values(array(
  'lid' => '231',
  'location' => 'includes/content.views.inc:291',
  'textgroup' => 'default',
  'source' => 'Format',
  'version' => 'none',
))
->values(array(
  'lid' => '232',
  'location' => 'includes/content.views.inc:372',
  'textgroup' => 'default',
  'source' => 'Group multiple values',
  'version' => 'none',
))
->values(array(
  'lid' => '233',
  'location' => 'includes/views/handlers/content_handler_field_multiple.inc:61',
  'textgroup' => 'default',
  'source' => 'If unchecked, each item in the field will create a new row, which may appear to cause duplicates. This setting is not compatible with click-sorting in table displays.',
  'version' => 'none',
))
->values(array(
  'lid' => '234',
  'location' => 'includes/content.views.inc:378',
  'textgroup' => 'default',
  'source' => 'Show @count value(s)',
  'version' => 'none',
))
->values(array(
  'lid' => '235',
  'location' => 'includes/content.views.inc:387',
  'textgroup' => 'default',
  'source' => 'starting from @count',
  'version' => 'none',
))
->values(array(
  'lid' => '236',
  'location' => 'includes/content.views.inc:396',
  'textgroup' => 'default',
  'source' => 'Reversed (start from last values)',
  'version' => 'none',
))
->values(array(
  'lid' => '237',
  'location' => 'includes/views/handlers/content_handler_relationship.inc:40,  includes/views/handlers/content_handler_sort.inc:41',
  'textgroup' => 'default',
  'source' => 'All',
  'version' => 'none',
))
->values(array(
  'lid' => '238',
  'location' => 'includes/views/handlers/content_handler_relationship.inc:48,  includes/views/handlers/content_handler_sort.inc:49',
  'textgroup' => 'default',
  'source' => 'Delta',
  'version' => 'none',
))
->values(array(
  'lid' => '239',
  'location' => 'includes/views/handlers/content_handler_relationship.inc:49',
  'textgroup' => 'default',
  'source' => 'The delta allows you to select which item in a multiple value field to key the relationship off of. Select "1" to use the first item, "2" for the second item, and so on. If you select "All", each item in the field will create a new row, which may appear to cause duplicates.',
  'version' => 'none',
))
->values(array(
  'lid' => '240',
  'location' => 'includes/views/handlers/content_handler_sort.inc:50',
  'textgroup' => 'default',
  'source' => 'The delta allows you to select which item in a multiple value field will be used for sorting. Select "1" to use the first item, "2" for the second item, and so on. If you select "All", each item in the field will create a new row, which may appear to cause duplicates.',
  'version' => 'none',
))
->values(array(
  'lid' => '241',
  'location' => 'modules/content_copy/content_copy_export_form.tpl.php:9,  modules/content_copy/content_copy.module:191;38',
  'textgroup' => 'default',
  'source' => 'Export',
  'version' => 'none',
))
->values(array(
  'lid' => '242',
  'location' => 'modules/content_copy/content_copy.module:97',
  'textgroup' => 'default',
  'source' => 'This form will process a content type and one or more fields from that type and export the settings. The export created by this process can be copied and pasted as an import into the current or any other database. The import will add the fields to into an existing content type or create a new content type that includes the selected fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '243',
  'location' => 'modules/content_copy/content_copy.module:103',
  'textgroup' => 'default',
  'source' => 'Types',
  'version' => 'none',
))
->values(array(
  'lid' => '244',
  'location' => 'modules/content_copy/content_copy.module:107',
  'textgroup' => 'default',
  'source' => 'Select the content type to export.',
  'version' => 'none',
))
->values(array(
  'lid' => '245',
  'location' => 'modules/content_copy/content_copy.module:175',
  'textgroup' => 'default',
  'source' => 'Export data',
  'version' => 'none',
))
->values(array(
  'lid' => '246',
  'location' => 'modules/content_copy/content_copy.module:180',
  'textgroup' => 'default',
  'source' => 'Copy the export text and paste it into another content type using the import function.',
  'version' => 'none',
))
->values(array(
  'lid' => '247',
  'location' => 'modules/content_copy/content_copy.module:184',
  'textgroup' => 'default',
  'source' => 'Content types',
  'version' => 'none',
))
->values(array(
  'lid' => '248',
  'location' => 'modules/content_copy/content_copy.module:308',
  'textgroup' => 'default',
  'source' => 'Content type',
  'version' => 'none',
))
->values(array(
  'lid' => '249',
  'location' => 'modules/content_copy/content_copy.module:309',
  'textgroup' => 'default',
  'source' => 'Select the content type to import these fields into.<br/>Select &lt;Create&gt; to create a new content type to contain the fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '250',
  'location' => 'modules/content_copy/content_copy.module:314',
  'textgroup' => 'default',
  'source' => 'Import data',
  'version' => 'none',
))
->values(array(
  'lid' => '251',
  'location' => 'modules/content_copy/content_copy.module:316',
  'textgroup' => 'default',
  'source' => 'Paste the text created by a content export into this field.',
  'version' => 'none',
))
->values(array(
  'lid' => '252',
  'location' => 'modules/content_copy/content_copy.module:320;46',
  'textgroup' => 'default',
  'source' => 'Import',
  'version' => 'none',
))
->values(array(
  'lid' => '253',
  'location' => 'modules/content_copy/content_copy.module:328',
  'textgroup' => 'default',
  'source' => 'A file has been pre-loaded for import.',
  'version' => 'none',
))
->values(array(
  'lid' => '254',
  'location' => 'modules/content_copy/content_copy.module:354',
  'textgroup' => 'default',
  'source' => 'The import data is not valid import text.',
  'version' => 'none',
))
->values(array(
  'lid' => '255',
  'location' => 'modules/content_copy/content_copy.module:403',
  'textgroup' => 'default',
  'source' => 'The following modules must be enabled for this import to work: %modules.',
  'version' => 'none',
))
->values(array(
  'lid' => '256',
  'location' => 'modules/content_copy/content_copy.module:411',
  'textgroup' => 'default',
  'source' => 'The content type %type already exists in this database.',
  'version' => 'none',
))
->values(array(
  'lid' => '257',
  'location' => 'modules/content_copy/content_copy.module:418',
  'textgroup' => 'default',
  'source' => 'Exiting. No import performed.',
  'version' => 'none',
))
->values(array(
  'lid' => '258',
  'location' => 'modules/content_copy/content_copy.module:442',
  'textgroup' => 'default',
  'source' => 'An error has occurred adding the content type %type.<br/>Please check the errors displayed for more details.',
  'version' => 'none',
))
->values(array(
  'lid' => '259',
  'location' => 'modules/content_copy/content_copy.module:467',
  'textgroup' => 'default',
  'source' => 'The imported field %field_label (%field_name) was not added to %type because that field already exists in %type.',
  'version' => 'none',
))
->values(array(
  'lid' => '260',
  'location' => 'modules/content_copy/content_copy.module:476',
  'textgroup' => 'default',
  'source' => 'The field %field_label (%field_name) was added to the content type %type.',
  'version' => 'none',
))
->values(array(
  'lid' => '261',
  'location' => 'modules/content_copy/content_copy.module:0',
  'textgroup' => 'default',
  'source' => 'content_copy',
  'version' => 'none',
))
->values(array(
  'lid' => '262',
  'location' => 'modules/content_copy/content_copy.info:0',
  'textgroup' => 'default',
  'source' => 'Content Copy',
  'version' => 'none',
))
->values(array(
  'lid' => '263',
  'location' => 'modules/content_copy/content_copy.info:0',
  'textgroup' => 'default',
  'source' => 'Enables ability to import/export field definitions.',
  'version' => 'none',
))
->values(array(
  'lid' => '264',
  'location' => 'modules/content_multigroup/content_multigroup.module:12',
  'textgroup' => 'default',
  'source' => 'The fields in a Standard group are independent of each other and each can have either single or multiple values. The fields in a Multigroup are treated as a repeating collection of single value fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '265',
  'location' => 'modules/content_multigroup/content_multigroup.module:65;135',
  'textgroup' => 'default',
  'source' => 'Multigroup',
  'version' => 'none',
))
->values(array(
  'lid' => '266',
  'location' => 'modules/content_multigroup/content_multigroup.module:134',
  'textgroup' => 'default',
  'source' => 'Standard',
  'version' => 'none',
))
->values(array(
  'lid' => '267',
  'location' => 'modules/content_multigroup/content_multigroup.module:138',
  'textgroup' => 'default',
  'source' => 'Type of group.',
  'version' => 'none',
))
->values(array(
  'lid' => '268',
  'location' => 'modules/content_multigroup/content_multigroup.module:215',
  'textgroup' => 'default',
  'source' => 'The field %field has been updated to use %multiple values, to match the multiple value setting of the Multigroup %group.',
  'version' => 'none',
))
->values(array(
  'lid' => '269',
  'location' => 'modules/content_multigroup/content_multigroup.module:248',
  'textgroup' => 'default',
  'source' => 'This change is not allowed. The field %field already has %multiple values in the database but the group %group only allows %group_max. Making this change would result in the loss of data.',
  'version' => 'none',
))
->values(array(
  'lid' => '270',
  'location' => 'modules/content_multigroup/content_multigroup.module:272',
  'textgroup' => 'default',
  'source' => 'This change is not allowed. The field %field handles multiple values differently than the Content module. Making this change could result in the loss of data.',
  'version' => 'none',
))
->values(array(
  'lid' => '271',
  'location' => 'modules/content_multigroup/content_multigroup.module:287',
  'textgroup' => 'default',
  'source' => 'You are moving the field %field into a Multigroup.',
  'version' => 'none',
))
->values(array(
  'lid' => '272',
  'location' => 'modules/content_multigroup/content_multigroup.module:320',
  'textgroup' => 'default',
  'source' => 'This change is not allowed. The field %field already has data created and uses a widget that stores data differently in a Standard group than in a Multigroup. Making this change could result in the loss of data.',
  'version' => 'none',
))
->values(array(
  'lid' => '273',
  'location' => 'modules/content_multigroup/content_multigroup.module:334',
  'textgroup' => 'default',
  'source' => 'You are moving the field %field out of a Multigroup.',
  'version' => 'none',
))
->values(array(
  'lid' => '274',
  'location' => 'modules/content_multigroup/content_multigroup.module:369',
  'textgroup' => 'default',
  'source' => 'Simple',
  'version' => 'none',
))
->values(array(
  'lid' => '275',
  'location' => 'modules/content_multigroup/content_multigroup.module:370',
  'textgroup' => 'default',
  'source' => 'Fieldset',
  'version' => 'none',
))
->values(array(
  'lid' => '276',
  'location' => 'modules/content_multigroup/content_multigroup.module:371',
  'textgroup' => 'default',
  'source' => 'Horizontal line',
  'version' => 'none',
))
->values(array(
  'lid' => '277',
  'location' => 'modules/content_multigroup/content_multigroup.module:372',
  'textgroup' => 'default',
  'source' => 'Table - Single column',
  'version' => 'none',
))
->values(array(
  'lid' => '278',
  'location' => 'modules/content_multigroup/content_multigroup.module:373',
  'textgroup' => 'default',
  'source' => 'Table - Multiple columns',
  'version' => 'none',
))
->values(array(
  'lid' => '279',
  'location' => 'modules/content_multigroup/content_multigroup.module:384',
  'textgroup' => 'default',
  'source' => '[Subgroup format]',
  'version' => 'none',
))
->values(array(
  'lid' => '280',
  'location' => 'modules/content_multigroup/content_multigroup.module:461',
  'textgroup' => 'default',
  'source' => 'Multigroup settings',
  'version' => 'none',
))
->values(array(
  'lid' => '281',
  'location' => 'modules/content_multigroup/content_multigroup.module:476',
  'textgroup' => 'default',
  'source' => 'Multiple columns',
  'version' => 'none',
))
->values(array(
  'lid' => '282',
  'location' => 'modules/content_multigroup/content_multigroup.module:478',
  'textgroup' => 'default',
  'source' => 'Enable this option to render each field on a separate column on the node edit form.',
  'version' => 'none',
))
->values(array(
  'lid' => '283',
  'location' => 'modules/content_multigroup/content_multigroup.module:485',
  'textgroup' => 'default',
  'source' => 'Enable this option to require a minimum of one collection of fields in this Multigroup.',
  'version' => 'none',
))
->values(array(
  'lid' => '284',
  'location' => 'modules/content_multigroup/content_multigroup.module:488',
  'textgroup' => 'default',
  'source' => 'Number of times to repeat the collection of Multigroup fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '285',
  'location' => 'modules/content_multigroup/content_multigroup.module:489',
  'textgroup' => 'default',
  'source' => "'Unlimited' will provide an 'Add more' button so the users can add items as many times as they like.",
  'version' => 'none',
))
->values(array(
  'lid' => '286',
  'location' => 'modules/content_multigroup/content_multigroup.module:490',
  'textgroup' => 'default',
  'source' => 'All fields in this group will automatically be set to allow this number of values.',
  'version' => 'none',
))
->values(array(
  'lid' => '287',
  'location' => 'modules/content_multigroup/content_multigroup.module:495',
  'textgroup' => 'default',
  'source' => 'Number of repeats',
  'version' => 'none',
))
->values(array(
  'lid' => '288',
  'location' => 'modules/content_multigroup/content_multigroup.module:503',
  'textgroup' => 'default',
  'source' => 'Labels',
  'version' => 'none',
))
->values(array(
  'lid' => '289',
  'location' => 'modules/content_multigroup/content_multigroup.module:504',
  'textgroup' => 'default',
  'source' => "Labels for each subgroup of fields. Labels can be hidden or shown in various contexts using the 'Display fields' screen.",
  'version' => 'none',
))
->values(array(
  'lid' => '290',
  'location' => 'modules/content_multigroup/content_multigroup.module:512',
  'textgroup' => 'default',
  'source' => 'Subgroup %number label',
  'version' => 'none',
))
->values(array(
  'lid' => '291',
  'location' => 'modules/content_multigroup/content_multigroup.module:539',
  'textgroup' => 'default',
  'source' => 'The field %field in this group already has %multiple values in the database. To prevent the loss of data you cannot set the number of Multigroup values to less than this.',
  'version' => 'none',
))
->values(array(
  'lid' => '292',
  'location' => 'modules/content_multigroup/content_multigroup.module:932',
  'textgroup' => 'default',
  'source' => '!name field is required in group @group.',
  'version' => 'none',
))
->values(array(
  'lid' => '293',
  'location' => 'modules/content_multigroup/content_multigroup.module:946',
  'textgroup' => 'default',
  'source' => 'Group @name requires one collection of fields minimum.',
  'version' => 'none',
))
->values(array(
  'lid' => '294',
  'location' => 'modules/content_multigroup/content_multigroup.module:1145',
  'textgroup' => 'default',
  'source' => 'Add more values',
  'version' => 'none',
))
->values(array(
  'lid' => '295',
  'location' => 'modules/content_multigroup/content_multigroup.module:0',
  'textgroup' => 'default',
  'source' => 'content_multigroup',
  'version' => 'none',
))
->values(array(
  'lid' => '296',
  'location' => 'modules/content_multigroup/content_multigroup.info:0',
  'textgroup' => 'default',
  'source' => 'Content Multigroup',
  'version' => 'none',
))
->values(array(
  'lid' => '297',
  'location' => 'modules/content_multigroup/content_multigroup.info:0',
  'textgroup' => 'default',
  'source' => 'Combine multiple CCK fields into repeating field collections that work in unison.',
  'version' => 'none',
))
->values(array(
  'lid' => '298',
  'location' => 'modules/content_permissions/content_permissions.module:10',
  'textgroup' => 'default',
  'source' => 'edit ',
  'version' => 'none',
))
->values(array(
  'lid' => '299',
  'location' => 'modules/content_permissions/content_permissions.module:10;11',
  'textgroup' => 'default',
  'source' => 'field_name',
  'version' => 'none',
))
->values(array(
  'lid' => '300',
  'location' => 'modules/content_permissions/content_permissions.module:11',
  'textgroup' => 'default',
  'source' => 'view ',
  'version' => 'none',
))
->values(array(
  'lid' => '301',
  'location' => 'modules/content_permissions/content_permissions.module:0',
  'textgroup' => 'default',
  'source' => 'content_permissions',
  'version' => 'none',
))
->values(array(
  'lid' => '302',
  'location' => 'modules/content_permissions/content_permissions.install:9',
  'textgroup' => 'default',
  'source' => 'Please <a href="!url">configure your field permissions</a> immediately. All fields are inaccessible by default.',
  'version' => 'none',
))
->values(array(
  'lid' => '303',
  'location' => 'modules/content_permissions/content_permissions.info:0',
  'textgroup' => 'default',
  'source' => 'Content Permissions',
  'version' => 'none',
))
->values(array(
  'lid' => '304',
  'location' => 'modules/content_permissions/content_permissions.info:0',
  'textgroup' => 'default',
  'source' => 'Set field-level permissions for CCK fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '305',
  'location' => 'modules/fieldgroup/fieldgroup.panels.inc:10;27',
  'textgroup' => 'default',
  'source' => 'Content fieldgroup',
  'version' => 'none',
))
->values(array(
  'lid' => '306',
  'location' => 'modules/fieldgroup/fieldgroup.panels.inc:30',
  'textgroup' => 'default',
  'source' => 'All fields from a fieldgroup on the referenced node.',
  'version' => 'none',
))
->values(array(
  'lid' => '307',
  'location' => 'modules/fieldgroup/fieldgroup.panels.inc:91',
  'textgroup' => 'default',
  'source' => '@group_label (@group_type_name)',
  'version' => 'none',
))
->values(array(
  'lid' => '308',
  'location' => 'modules/fieldgroup/fieldgroup.panels.inc:102,  modules/fieldgroup/fieldgroup.info:0',
  'textgroup' => 'default',
  'source' => 'Fieldgroup',
  'version' => 'none',
))
->values(array(
  'lid' => '309',
  'location' => 'modules/fieldgroup/fieldgroup.panels.inc:112',
  'textgroup' => 'default',
  'source' => 'Text to display if group has no data. Note that title will not display unless overridden.',
  'version' => 'none',
))
->values(array(
  'lid' => '310',
  'location' => 'modules/fieldgroup/fieldgroup.panels.inc:128',
  'textgroup' => 'default',
  'source' => '"@s" fieldgroup @name',
  'version' => 'none',
))
->values(array(
  'lid' => '311',
  'location' => 'modules/fieldgroup/fieldgroup.module:124',
  'textgroup' => 'default',
  'source' => 'Form settings',
  'version' => 'none',
))
->values(array(
  'lid' => '312',
  'location' => 'modules/fieldgroup/fieldgroup.module:125',
  'textgroup' => 'default',
  'source' => 'These settings apply to the group in the node editing form.',
  'version' => 'none',
))
->values(array(
  'lid' => '313',
  'location' => 'modules/fieldgroup/fieldgroup.module:129',
  'textgroup' => 'default',
  'source' => 'Style',
  'version' => 'none',
))
->values(array(
  'lid' => '314',
  'location' => 'modules/fieldgroup/fieldgroup.module:132',
  'textgroup' => 'default',
  'source' => 'always open',
  'version' => 'none',
))
->values(array(
  'lid' => '315',
  'location' => 'modules/fieldgroup/fieldgroup.module:133',
  'textgroup' => 'default',
  'source' => 'collapsible',
  'version' => 'none',
))
->values(array(
  'lid' => '316',
  'location' => 'modules/fieldgroup/fieldgroup.module:134',
  'textgroup' => 'default',
  'source' => 'collapsed',
  'version' => 'none',
))
->values(array(
  'lid' => '317',
  'location' => 'modules/fieldgroup/fieldgroup.module:142',
  'textgroup' => 'default',
  'source' => 'Instructions to present to the user on the editing form.',
  'version' => 'none',
))
->values(array(
  'lid' => '318',
  'location' => 'modules/fieldgroup/fieldgroup.module:147',
  'textgroup' => 'default',
  'source' => 'Display settings',
  'version' => 'none',
))
->values(array(
  'lid' => '319',
  'location' => 'modules/fieldgroup/fieldgroup.module:148',
  'textgroup' => 'default',
  'source' => 'These settings apply to the group on node display.',
  'version' => 'none',
))
->values(array(
  'lid' => '320',
  'location' => 'modules/fieldgroup/fieldgroup.module:155',
  'textgroup' => 'default',
  'source' => 'A description of the group.',
  'version' => 'none',
))
->values(array(
  'lid' => '321',
  'location' => 'modules/fieldgroup/fieldgroup.module:200',
  'textgroup' => 'default',
  'source' => 'Are you sure you want to remove the group %label?',
  'version' => 'none',
))
->values(array(
  'lid' => '322',
  'location' => 'modules/fieldgroup/fieldgroup.module:202',
  'textgroup' => 'default',
  'source' => 'This action cannot be undone.',
  'version' => 'none',
))
->values(array(
  'lid' => '323',
  'location' => 'modules/fieldgroup/fieldgroup.module:211',
  'textgroup' => 'default',
  'source' => 'The group %group_name has been removed.',
  'version' => 'none',
))
->values(array(
  'lid' => '324',
  'location' => 'modules/fieldgroup/fieldgroup.module:293,  modules/nodereference/nodereference.module:544,  modules/userreference/userreference.module:439',
  'textgroup' => 'default',
  'source' => 'none',
  'version' => 'none',
))
->values(array(
  'lid' => '325',
  'location' => 'modules/fieldgroup/fieldgroup.module:353',
  'textgroup' => 'default',
  'source' => 'You need to provide a label.',
  'version' => 'none',
))
->values(array(
  'lid' => '326',
  'location' => 'modules/fieldgroup/fieldgroup.module:358',
  'textgroup' => 'default',
  'source' => 'You need to provide a group name.',
  'version' => 'none',
))
->values(array(
  'lid' => '327',
  'location' => 'modules/fieldgroup/fieldgroup.module:372',
  'textgroup' => 'default',
  'source' => 'The group name %group_name is invalid. The name must include only lowercase unaccentuated letters, numbers, and underscores.',
  'version' => 'none',
))
->values(array(
  'lid' => '328',
  'location' => 'modules/fieldgroup/fieldgroup.module:375',
  'textgroup' => 'default',
  'source' => "The group name %group_name is too long. The name is limited to 32 characters, including the 'group_' prefix.",
  'version' => 'none',
))
->values(array(
  'lid' => '329',
  'location' => 'modules/fieldgroup/fieldgroup.module:381',
  'textgroup' => 'default',
  'source' => 'The group name %group_name already exists.',
  'version' => 'none',
))
->values(array(
  'lid' => '330',
  'location' => 'modules/fieldgroup/fieldgroup.module:400;403',
  'textgroup' => 'default',
  'source' => 'Add new group:',
  'version' => 'none',
))
->values(array(
  'lid' => '331',
  'location' => 'modules/fieldgroup/fieldgroup.module:418',
  'textgroup' => 'default',
  'source' => 'Add new group: you need to provide a label.',
  'version' => 'none',
))
->values(array(
  'lid' => '332',
  'location' => 'modules/fieldgroup/fieldgroup.module:419',
  'textgroup' => 'default',
  'source' => 'Add new group: you need to provide a group name.',
  'version' => 'none',
))
->values(array(
  'lid' => '333',
  'location' => 'modules/fieldgroup/fieldgroup.module:648',
  'textgroup' => 'default',
  'source' => 'Standard group',
  'version' => 'none',
))
->values(array(
  'lid' => '334',
  'location' => 'modules/fieldgroup/fieldgroup.module:39;46',
  'textgroup' => 'default',
  'source' => 'Edit group',
  'version' => 'none',
))
->values(array(
  'lid' => '335',
  'location' => 'modules/fieldgroup/fieldgroup.module:0',
  'textgroup' => 'default',
  'source' => 'fieldgroup',
  'version' => 'none',
))
->values(array(
  'lid' => '336',
  'location' => 'modules/fieldgroup/fieldgroup.info:0',
  'textgroup' => 'default',
  'source' => 'Create display groups for CCK fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '337',
  'location' => 'modules/nodereference/nodereference.rules.inc:15',
  'textgroup' => 'default',
  'source' => 'Load a referenced node',
  'version' => 'none',
))
->values(array(
  'lid' => '338',
  'location' => 'modules/nodereference/nodereference.rules.inc:19',
  'textgroup' => 'default',
  'source' => 'Content containing the node reference field',
  'version' => 'none',
))
->values(array(
  'lid' => '339',
  'location' => 'modules/nodereference/nodereference.rules.inc:25',
  'textgroup' => 'default',
  'source' => 'Referenced content',
  'version' => 'none',
))
->values(array(
  'lid' => '340',
  'location' => 'modules/nodereference/nodereference.rules.inc:29',
  'textgroup' => 'default',
  'source' => 'Note that if the field has multiple values, only the first content node will be loaded.',
  'version' => 'none',
))
->values(array(
  'lid' => '341',
  'location' => 'modules/nodereference/nodereference.rules.inc:50',
  'textgroup' => 'default',
  'source' => 'There are no nodereference fields defined.',
  'version' => 'none',
))
->values(array(
  'lid' => '342',
  'location' => 'modules/nodereference/nodereference.module:60',
  'textgroup' => 'default',
  'source' => 'Node reference',
  'version' => 'none',
))
->values(array(
  'lid' => '343',
  'location' => 'modules/nodereference/nodereference.module:61',
  'textgroup' => 'default',
  'source' => 'Store the ID of a related node as an integer value.',
  'version' => 'none',
))
->values(array(
  'lid' => '344',
  'location' => 'modules/nodereference/nodereference.module:75',
  'textgroup' => 'default',
  'source' => 'Content types that can be referenced',
  'version' => 'none',
))
->values(array(
  'lid' => '345',
  'location' => 'modules/nodereference/nodereference.module:87,  modules/userreference/userreference.module:84',
  'textgroup' => 'default',
  'source' => 'Default Views',
  'version' => 'none',
))
->values(array(
  'lid' => '346',
  'location' => 'modules/nodereference/nodereference.module:90,  modules/userreference/userreference.module:87',
  'textgroup' => 'default',
  'source' => 'Existing Views',
  'version' => 'none',
))
->values(array(
  'lid' => '347',
  'location' => 'modules/nodereference/nodereference.module:97',
  'textgroup' => 'default',
  'source' => 'Advanced - Nodes that can be referenced (View)',
  'version' => 'none',
))
->values(array(
  'lid' => '348',
  'location' => 'modules/nodereference/nodereference.module:104',
  'textgroup' => 'default',
  'source' => 'View used to select the nodes',
  'version' => 'none',
))
->values(array(
  'lid' => '349',
  'location' => 'modules/nodereference/nodereference.module:107',
  'textgroup' => 'default',
  'source' => '<p>Choose the "Views module" view that selects the nodes that can be referenced.<br />Note:</p>',
  'version' => 'none',
))
->values(array(
  'lid' => '350',
  'location' => 'modules/nodereference/nodereference.module:108;121',
  'textgroup' => 'default',
  'source' => "<ul><li>Only views that have fields will work for this purpose.</li><li>This will discard the \"Content types\" settings above. Use the view's \"filters\" section instead.</li><li>Use the view's \"fields\" section to display additional informations about candidate nodes on node creation/edition form.</li><li>Use the view's \"sort criteria\" section to determine the order in which candidate nodes will be displayed.</li></ul>",
  'version' => 'none',
))
->values(array(
  'lid' => '351',
  'location' => 'modules/nodereference/nodereference.module:112,  modules/userreference/userreference.module:109',
  'textgroup' => 'default',
  'source' => 'View arguments',
  'version' => 'none',
))
->values(array(
  'lid' => '352',
  'location' => 'modules/nodereference/nodereference.module:115,  modules/userreference/userreference.module:112',
  'textgroup' => 'default',
  'source' => 'Provide a comma separated list of arguments to pass to the view.',
  'version' => 'none',
))
->values(array(
  'lid' => '353',
  'location' => 'modules/nodereference/nodereference.module:120',
  'textgroup' => 'default',
  'source' => '<p>The list of nodes that can be referenced can be based on a "Views module" view but no appropriate views were found. <br />Note:</p>',
  'version' => 'none',
))
->values(array(
  'lid' => '354',
  'location' => 'modules/nodereference/nodereference.module:205,  modules/userreference/userreference.module:184',
  'textgroup' => 'default',
  'source' => '%name: invalid input.',
  'version' => 'none',
))
->values(array(
  'lid' => '355',
  'location' => 'modules/nodereference/nodereference.module:217',
  'textgroup' => 'default',
  'source' => "%name: this post can't be referenced.",
  'version' => 'none',
))
->values(array(
  'lid' => '356',
  'location' => 'modules/nodereference/nodereference.module:242',
  'textgroup' => 'default',
  'source' => 'Title (link)',
  'version' => 'none',
))
->values(array(
  'lid' => '357',
  'location' => 'modules/nodereference/nodereference.module:247',
  'textgroup' => 'default',
  'source' => 'Title (no link)',
  'version' => 'none',
))
->values(array(
  'lid' => '358',
  'location' => 'modules/nodereference/nodereference.module:303,  modules/optionwidgets/optionwidgets.module:62,  modules/userreference/userreference.module:198',
  'textgroup' => 'default',
  'source' => 'Select list',
  'version' => 'none',
))
->values(array(
  'lid' => '359',
  'location' => 'modules/optionwidgets/optionwidgets.module:70',
  'textgroup' => 'default',
  'source' => 'Check boxes/radio buttons',
  'version' => 'none',
))
->values(array(
  'lid' => '360',
  'location' => 'modules/nodereference/nodereference.module:311,  modules/userreference/userreference.module:206',
  'textgroup' => 'default',
  'source' => 'Autocomplete text field',
  'version' => 'none',
))
->values(array(
  'lid' => '361',
  'location' => 'modules/nodereference/nodereference.module:417,  modules/userreference/userreference.module:343',
  'textgroup' => 'default',
  'source' => 'Autocomplete matching',
  'version' => 'none',
))
->values(array(
  'lid' => '362',
  'location' => 'modules/nodereference/nodereference.module:420,  modules/userreference/userreference.module:346',
  'textgroup' => 'default',
  'source' => 'Starts with',
  'version' => 'none',
))
->values(array(
  'lid' => '363',
  'location' => 'modules/nodereference/nodereference.module:421,  modules/userreference/userreference.module:347',
  'textgroup' => 'default',
  'source' => 'Contains',
  'version' => 'none',
))
->values(array(
  'lid' => '364',
  'location' => 'modules/nodereference/nodereference.module:423',
  'textgroup' => 'default',
  'source' => 'Select the method used to collect autocomplete suggestions. Note that <em>Contains</em> can cause performance issues on sites with thousands of nodes.',
  'version' => 'none',
))
->values(array(
  'lid' => '365',
  'location' => 'modules/nodereference/nodereference.module:671',
  'textgroup' => 'default',
  'source' => '%name: title mismatch. Please check your selection.',
  'version' => 'none',
))
->values(array(
  'lid' => '366',
  'location' => 'modules/nodereference/nodereference.module:678',
  'textgroup' => 'default',
  'source' => '%name: found no valid post with that title.',
  'version' => 'none',
))
->values(array(
  'lid' => '367',
  'location' => 'modules/nodereference/nodereference.module:15',
  'textgroup' => 'default',
  'source' => 'Nodereference autocomplete',
  'version' => 'none',
))
->values(array(
  'lid' => '368',
  'location' => 'modules/nodereference/nodereference.module:0',
  'textgroup' => 'default',
  'source' => 'nodereference',
  'version' => 'none',
))
->values(array(
  'lid' => '369',
  'location' => 'modules/nodereference/nodereference.info:0',
  'textgroup' => 'default',
  'source' => 'Node Reference',
  'version' => 'none',
))
->values(array(
  'lid' => '370',
  'location' => 'modules/nodereference/nodereference.info:0',
  'textgroup' => 'default',
  'source' => 'Defines a field type for referencing one node from another.',
  'version' => 'none',
))
->values(array(
  'lid' => '371',
  'location' => 'modules/number/number.module:41',
  'textgroup' => 'default',
  'source' => 'Integer',
  'version' => 'none',
))
->values(array(
  'lid' => '372',
  'location' => 'modules/number/number.module:42',
  'textgroup' => 'default',
  'source' => 'Store a number in the database as an integer.',
  'version' => 'none',
))
->values(array(
  'lid' => '373',
  'location' => 'modules/number/number.module:49',
  'textgroup' => 'default',
  'source' => 'Decimal',
  'version' => 'none',
))
->values(array(
  'lid' => '374',
  'location' => 'modules/number/number.module:50',
  'textgroup' => 'default',
  'source' => 'Store a number in the database in a fixed decimal format.',
  'version' => 'none',
))
->values(array(
  'lid' => '375',
  'location' => 'modules/number/number.module:57',
  'textgroup' => 'default',
  'source' => 'Float',
  'version' => 'none',
))
->values(array(
  'lid' => '376',
  'location' => 'modules/number/number.module:58',
  'textgroup' => 'default',
  'source' => 'Store a number in the database in a floating point format.',
  'version' => 'none',
))
->values(array(
  'lid' => '377',
  'location' => 'modules/number/number.module:76',
  'textgroup' => 'default',
  'source' => 'Minimum',
  'version' => 'none',
))
->values(array(
  'lid' => '378',
  'location' => 'modules/number/number.module:81',
  'textgroup' => 'default',
  'source' => 'Maximum',
  'version' => 'none',
))
->values(array(
  'lid' => '379',
  'location' => 'modules/number/number.module:88',
  'textgroup' => 'default',
  'source' => 'Precision',
  'version' => 'none',
))
->values(array(
  'lid' => '380',
  'location' => 'modules/number/number.module:89',
  'textgroup' => 'default',
  'source' => 'The total number of digits to store in the database, including those to the right of the decimal.',
  'version' => 'none',
))
->values(array(
  'lid' => '381',
  'location' => 'modules/number/number.module:95',
  'textgroup' => 'default',
  'source' => 'Scale',
  'version' => 'none',
))
->values(array(
  'lid' => '382',
  'location' => 'modules/number/number.module:96',
  'textgroup' => 'default',
  'source' => 'The number of digits to the right of the decimal.',
  'version' => 'none',
))
->values(array(
  'lid' => '383',
  'location' => 'modules/number/number.module:102',
  'textgroup' => 'default',
  'source' => 'Decimal marker',
  'version' => 'none',
))
->values(array(
  'lid' => '384',
  'location' => 'modules/number/number.module:103',
  'textgroup' => 'default',
  'source' => 'The character users will input to mark the decimal point in forms.',
  'version' => 'none',
))
->values(array(
  'lid' => '385',
  'location' => 'modules/number/number.module:109',
  'textgroup' => 'default',
  'source' => 'Prefix',
  'version' => 'none',
))
->values(array(
  'lid' => '386',
  'location' => 'modules/number/number.module:112',
  'textgroup' => 'default',
  'source' => 'Define a string that should be prefixed to the value, like $ or €. Leave blank for none. Separate singular and plural values with a pipe (pound|pounds).',
  'version' => 'none',
))
->values(array(
  'lid' => '387',
  'location' => 'modules/number/number.module:116',
  'textgroup' => 'default',
  'source' => 'Suffix',
  'version' => 'none',
))
->values(array(
  'lid' => '388',
  'location' => 'modules/number/number.module:119',
  'textgroup' => 'default',
  'source' => 'Define a string that should suffixed to the value, like m², m/s², kb/s. Leave blank for none. Separate singular and plural values with a pipe (pound|pounds).',
  'version' => 'none',
))
->values(array(
  'lid' => '389',
  'location' => 'modules/number/number.module:123 modules/text/text.module:82',
  'textgroup' => 'default',
  'source' => 'Allowed values',
  'version' => 'none',
))
->values(array(
  'lid' => '390',
  'location' => 'examples/example_field.php:174 modules/number/number.module:129,  modules/text/text.module:88',
  'textgroup' => 'default',
  'source' => 'Allowed values list',
  'version' => 'none',
))
->values(array(
  'lid' => '391',
  'location' => 'modules/number/number.module:116,  modules/text/text.module:81',
  'textgroup' => 'default',
  'source' => 'The possible values this field can contain. Enter one value per line, in the format key|label. The key is the value that will be stored in the database, and it must match the field storage type (%type). The label is optional, and the key will be used as the label if no label is specified.<br />Allowed HTML tags: @tags',
  'version' => 'none',
))
->values(array(
  'lid' => '392',
  'location' => 'examples/example_field.php:191 modules/number/number.module:147,  modules/text/text.module:106',
  'textgroup' => 'default',
  'source' => 'Advanced usage only: PHP code that returns a keyed array of allowed values. Should not include &lt;?php ?&gt; delimiters. If this field is filled out, the array returned by this code will override the allowed values list above.',
  'version' => 'none',
))
->values(array(
  'lid' => '393',
  'location' => 'modules/number/number.module:155 modules/text/text.module:114',
  'textgroup' => 'default',
  'source' => 'This PHP code was set by an administrator and will override the allowed values list above.',
  'version' => 'none',
))
->values(array(
  'lid' => '394',
  'location' => 'modules/number/number.module:178,  modules/text/text.module:132',
  'textgroup' => 'default',
  'source' => '@label (!name) - Allowed values',
  'version' => 'none',
))
->values(array(
  'lid' => '395',
  'location' => 'modules/number/number.module:162',
  'textgroup' => 'default',
  'source' => '"Minimum" must be a number.',
  'version' => 'none',
))
->values(array(
  'lid' => '396',
  'location' => 'modules/number/number.module:165',
  'textgroup' => 'default',
  'source' => '"Maximum" must be a number.',
  'version' => 'none',
))
->values(array(
  'lid' => '397',
  'location' => 'modules/number/number.module:219',
  'textgroup' => 'default',
  'source' => '%name: the value may be no smaller than %min.',
  'version' => 'none',
))
->values(array(
  'lid' => '398',
  'location' => 'modules/number/number.module:222',
  'textgroup' => 'default',
  'source' => '%name: the value may be no larger than %max.',
  'version' => 'none',
))
->values(array(
  'lid' => '399',
  'location' => 'modules/number/number.module:235,  modules/text/text.module:156',
  'textgroup' => 'default',
  'source' => '%name: illegal value.',
  'version' => 'none',
))
->values(array(
  'lid' => '400',
  'location' => 'modules/number/number.module:263',
  'textgroup' => 'default',
  'source' => 'unformatted',
  'version' => 'none',
))
->values(array(
  'lid' => '401',
  'location' => 'examples/example_field.php:476 examples/simple_field.php:400,  modules/number/number.module:342 modules/text/text.module:264',
  'textgroup' => 'default',
  'source' => 'Text field',
  'version' => 'none',
))
->values(array(
  'lid' => '402',
  'location' => 'modules/number/number.module:512',
  'textgroup' => 'default',
  'source' => 'Only numbers and decimals are allowed in %field.',
  'version' => 'none',
))
->values(array(
  'lid' => '403',
  'location' => 'modules/number/number.module:535',
  'textgroup' => 'default',
  'source' => 'Only numbers are allowed in %field.',
  'version' => 'none',
))
->values(array(
  'lid' => '404',
  'location' => 'modules/number/number.module:559',
  'textgroup' => 'default',
  'source' => 'Only numbers and the decimal character (%decimal) are allowed in %field.',
  'version' => 'none',
))
->values(array(
  'lid' => '405',
  'location' => 'modules/number/number.module:0',
  'textgroup' => 'default',
  'source' => 'number',
  'version' => 'none',
))
->values(array(
  'lid' => '406',
  'location' => 'modules/number/number.info:0',
  'textgroup' => 'default',
  'source' => 'Number',
  'version' => 'none',
))
->values(array(
  'lid' => '407',
  'location' => 'modules/number/number.info:0',
  'textgroup' => 'default',
  'source' => 'Defines numeric field types.',
  'version' => 'none',
))
->values(array(
  'lid' => '408',
  'location' => 'modules/optionwidgets/optionwidgets.module:19',
  'textgroup' => 'default',
  'source' => 'Create a list of options as a list in <strong>Allowed values list</strong> or as an array in PHP code. These values will be the same for %field in all content types.',
  'version' => 'none',
))
->values(array(
  'lid' => '409',
  'location' => 'modules/optionwidgets/optionwidgets.module:12',
  'textgroup' => 'default',
  'source' => "For a 'single on/off checkbox' widget, define the 'off' value first, then the 'on' value in the <strong>Allowed values</strong> section. Note that the checkbox will be labeled with the label of the 'on' value.",
  'version' => 'none',
))
->values(array(
  'lid' => '410',
  'location' => 'modules/optionwidgets/optionwidgets.module:15',
  'textgroup' => 'default',
  'source' => "The 'checkboxes/radio buttons' widget will display checkboxes if the multiple values option is selected for this field, otherwise radios will be displayed.",
  'version' => 'none',
))
->values(array(
  'lid' => '411',
  'location' => 'modules/optionwidgets/optionwidgets.module:37',
  'textgroup' => 'default',
  'source' => "You need to specify the 'allowed values' for this field.",
  'version' => 'none',
))
->values(array(
  'lid' => '412',
  'location' => 'modules/optionwidgets/optionwidgets.module:78',
  'textgroup' => 'default',
  'source' => 'Single on/off checkbox',
  'version' => 'none',
))
->values(array(
  'lid' => '413',
  'location' => 'modules/optionwidgets/optionwidgets.module:331',
  'textgroup' => 'default',
  'source' => '%name: this field cannot hold more that @count values.',
  'version' => 'none',
))
->values(array(
  'lid' => '414',
  'location' => 'modules/optionwidgets/optionwidgets.module:364',
  'textgroup' => 'default',
  'source' => 'N/A',
  'version' => 'none',
))
->values(array(
  'lid' => '415',
  'location' => 'modules/optionwidgets/optionwidgets.module:420',
  'textgroup' => 'default',
  'source' => '- None -',
  'version' => 'none',
))
->values(array(
  'lid' => '416',
  'location' => 'modules/optionwidgets/optionwidgets.module:0',
  'textgroup' => 'default',
  'source' => 'optionwidgets',
  'version' => 'none',
))
->values(array(
  'lid' => '417',
  'location' => 'modules/optionwidgets/optionwidgets.info:0',
  'textgroup' => 'default',
  'source' => 'Option Widgets',
  'version' => 'none',
))
->values(array(
  'lid' => '418',
  'location' => 'modules/optionwidgets/optionwidgets.info:0',
  'textgroup' => 'default',
  'source' => 'Defines selection, check box and radio button widgets for text and numeric fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '419',
  'location' => 'modules/text/text.module:50',
  'textgroup' => 'default',
  'source' => 'Store text in the database.',
  'version' => 'none',
))
->values(array(
  'lid' => '420',
  'location' => 'examples/example_field.php:158;388 examples/simple_field.php:332,  modules/text/text.module:66;209,  modules/userreference/userreference.module:151',
  'textgroup' => 'default',
  'source' => 'Plain text',
  'version' => 'none',
))
->values(array(
  'lid' => '421',
  'location' => 'examples/example_field.php:158 modules/text/text.module:66',
  'textgroup' => 'default',
  'source' => 'Filtered text (user selects input format)',
  'version' => 'none',
))
->values(array(
  'lid' => '422',
  'location' => 'examples/example_field.php:161 modules/text/text.module:69',
  'textgroup' => 'default',
  'source' => 'Text processing',
  'version' => 'none',
))
->values(array(
  'lid' => '423',
  'location' => 'examples/example_field.php:167 examples/simple_field.php:164,  modules/text/text.module:75',
  'textgroup' => 'default',
  'source' => 'Maximum length',
  'version' => 'none',
))
->values(array(
  'lid' => '424',
  'location' => 'examples/example_field.php:170 examples/simple_field.php:167,  modules/text/text.module:78',
  'textgroup' => 'default',
  'source' => 'The maximum length of the field in characters. Leave blank for an unlimited size.',
  'version' => 'none',
))
->values(array(
  'lid' => '425',
  'location' => 'modules/text/text.module:159',
  'textgroup' => 'default',
  'source' => '%name: the value may not be longer than %max characters.',
  'version' => 'none',
))
->values(array(
  'lid' => '426',
  'location' => 'examples/example_field.php:383 examples/simple_field.php:327,  modules/text/text.module:204 modules/userreference/userreference.module:146',
  'textgroup' => 'default',
  'source' => 'Default',
  'version' => 'none',
))
->values(array(
  'lid' => '427',
  'location' => 'examples/example_field.php:393 modules/text/text.module:214',
  'textgroup' => 'default',
  'source' => 'Trimmed',
  'version' => 'none',
))
->values(array(
  'lid' => '428',
  'location' => 'modules/text/text.module:272',
  'textgroup' => 'default',
  'source' => 'Text area (multiple rows)',
  'version' => 'none',
))
->values(array(
  'lid' => '429',
  'location' => 'modules/text/text.module:316',
  'textgroup' => 'default',
  'source' => 'Size of textfield',
  'version' => 'none',
))
->values(array(
  'lid' => '430',
  'location' => 'examples/example_field.php:551 examples/simple_field.php:430,  modules/text/text.module:324',
  'textgroup' => 'default',
  'source' => 'Rows',
  'version' => 'none',
))
->values(array(
  'lid' => '431',
  'location' => 'modules/text/text.module:0',
  'textgroup' => 'default',
  'source' => 'text',
  'version' => 'none',
))
->values(array(
  'lid' => '432',
  'location' => 'modules/text/text.info:0',
  'textgroup' => 'default',
  'source' => 'Defines simple text field types.',
  'version' => 'none',
))
->values(array(
  'lid' => '433',
  'location' => 'modules/userreference/userreference.rules.inc:15',
  'textgroup' => 'default',
  'source' => 'Load a referenced user',
  'version' => 'none',
))
->values(array(
  'lid' => '434',
  'location' => 'modules/userreference/userreference.rules.inc:19',
  'textgroup' => 'default',
  'source' => 'Content containing the user reference field',
  'version' => 'none',
))
->values(array(
  'lid' => '435',
  'location' => 'modules/userreference/userreference.rules.inc:25',
  'textgroup' => 'default',
  'source' => 'Referenced user',
  'version' => 'none',
))
->values(array(
  'lid' => '436',
  'location' => 'modules/userreference/userreference.rules.inc:29',
  'textgroup' => 'default',
  'source' => 'Note that if the field has multiple values, only the first user will be loaded.',
  'version' => 'none',
))
->values(array(
  'lid' => '437',
  'location' => 'modules/userreference/userreference.rules.inc:52',
  'textgroup' => 'default',
  'source' => 'There are no userreference fields defined.',
  'version' => 'none',
))
->values(array(
  'lid' => '438',
  'location' => 'modules/userreference/userreference.module:52',
  'textgroup' => 'default',
  'source' => 'User reference',
  'version' => 'none',
))
->values(array(
  'lid' => '439',
  'location' => 'modules/userreference/userreference.module:53',
  'textgroup' => 'default',
  'source' => 'Store the ID of a related user as an integer value.',
  'version' => 'none',
))
->values(array(
  'lid' => '440',
  'location' => 'modules/userreference/userreference.module:67',
  'textgroup' => 'default',
  'source' => 'User roles that can be referenced',
  'version' => 'none',
))
->values(array(
  'lid' => '441',
  'location' => 'modules/userreference/userreference.module:73',
  'textgroup' => 'default',
  'source' => 'User status that can be referenced',
  'version' => 'none',
))
->values(array(
  'lid' => '442',
  'location' => 'modules/userreference/userreference.module:75',
  'textgroup' => 'default',
  'source' => 'Active',
  'version' => 'none',
))
->values(array(
  'lid' => '443',
  'location' => 'modules/userreference/userreference.module:75',
  'textgroup' => 'default',
  'source' => 'Blocked',
  'version' => 'none',
))
->values(array(
  'lid' => '444',
  'location' => 'modules/userreference/userreference.module:94',
  'textgroup' => 'default',
  'source' => 'Advanced - Users that can be referenced (View)',
  'version' => 'none',
))
->values(array(
  'lid' => '445',
  'location' => 'modules/userreference/userreference.module:101',
  'textgroup' => 'default',
  'source' => 'View used to select the users',
  'version' => 'none',
))
->values(array(
  'lid' => '446',
  'location' => 'modules/userreference/userreference.module:104',
  'textgroup' => 'default',
  'source' => '<p>Choose the "Views module" view that selects the users that can be referenced.<br />Note:</p>',
  'version' => 'none',
))
->values(array(
  'lid' => '447',
  'location' => 'modules/userreference/userreference.module:105;118',
  'textgroup' => 'default',
  'source' => "<ul><li>Only views that have fields will work for this purpose.</li><li>This will discard the \"Referenceable Roles\" and \"Referenceable Status\" settings above. Use the view's \"filters\" section instead.</li><li>Use the view's \"fields\" section to display additional informations about candidate users on user creation/edition form.</li><li>Use the view's \"sort criteria\" section to determine the order in which candidate users will be displayed.</li></ul>",
  'version' => 'none',
))
->values(array(
  'lid' => '448',
  'location' => 'modules/userreference/userreference.module:117',
  'textgroup' => 'default',
  'source' => '<p>The list of user that can be referenced can be based on a "Views module" view but no appropriate views were found. <br />Note:</p>',
  'version' => 'none',
))
->values(array(
  'lid' => '449',
  'location' => 'modules/userreference/userreference.module:196',
  'textgroup' => 'default',
  'source' => '%name: invalid user.',
  'version' => 'none',
))
->values(array(
  'lid' => '450',
  'location' => 'modules/userreference/userreference.module:349',
  'textgroup' => 'default',
  'source' => 'Select the method used to collect autocomplete suggestions. Note that <em>Contains</em> can cause performance issues on sites with thousands of users.',
  'version' => 'none',
))
->values(array(
  'lid' => '451',
  'location' => 'modules/userreference/userreference.module:357',
  'textgroup' => 'default',
  'source' => 'Reverse link',
  'version' => 'none',
))
->values(array(
  'lid' => '452',
  'location' => 'modules/userreference/userreference.module:359',
  'textgroup' => 'default',
  'source' => 'If selected, a reverse link back to the referencing node will displayed on the referenced user record.',
  'version' => 'none',
))
->values(array(
  'lid' => '453',
  'location' => 'modules/userreference/userreference.module:594',
  'textgroup' => 'default',
  'source' => '%name: found no valid user with that name.',
  'version' => 'none',
))
->values(array(
  'lid' => '454',
  'location' => 'modules/userreference/userreference.module:887',
  'textgroup' => 'default',
  'source' => 'Related content',
  'version' => 'none',
))
->values(array(
  'lid' => '455',
  'location' => 'modules/userreference/userreference.module:15',
  'textgroup' => 'default',
  'source' => 'Userreference autocomplete',
  'version' => 'none',
))
->values(array(
  'lid' => '456',
  'location' => 'modules/userreference/userreference.module:0',
  'textgroup' => 'default',
  'source' => 'userreference',
  'version' => 'none',
))
->values(array(
  'lid' => '457',
  'location' => 'modules/userreference/userreference.info:0',
  'textgroup' => 'default',
  'source' => 'User Reference',
  'version' => 'none',
))
->values(array(
  'lid' => '458',
  'location' => 'modules/userreference/userreference.info:0',
  'textgroup' => 'default',
  'source' => 'Defines a field type for referencing a user from a node.',
  'version' => 'none',
))
->values(array(
  'lid' => '459',
  'location' => 'includes/content.admin.inc:212',
  'textgroup' => 'default',
  'source' => 'Weight',
  'version' => 'none',
))
->values(array(
  'lid' => '460',
  'location' => 'theme/content-admin-field-overview-form.tpl.php:53',
  'textgroup' => 'default',
  'source' => 'Add',
  'version' => 'none',
))
->values(array(
  'lid' => '461',
  'location' => 'theme/content-admin-field-overview-form.tpl.php:59',
  'textgroup' => 'default',
  'source' => 'New field',
  'version' => 'none',
))
->values(array(
  'lid' => '462',
  'location' => 'theme/content-admin-field-overview-form.tpl.php:72',
  'textgroup' => 'default',
  'source' => 'Existing field',
  'version' => 'none',
))
->values(array(
  'lid' => '463',
  'location' => 'theme/content-admin-field-overview-form.tpl.php:84',
  'textgroup' => 'default',
  'source' => 'New group',
  'version' => 'none',
))
->values(array(
  'lid' => '464',
  'location' => 'theme/theme.inc:11',
  'textgroup' => 'default',
  'source' => 'Add fields and groups to the content type, and arrange them on content display and input forms.',
  'version' => 'none',
))
->values(array(
  'lid' => '465',
  'location' => 'theme/theme.inc:13',
  'textgroup' => 'default',
  'source' => 'You can add a field to a group by dragging it below and to the right of the group.',
  'version' => 'none',
))
->values(array(
  'lid' => '466',
  'location' => 'theme/theme.inc:16',
  'textgroup' => 'default',
  'source' => 'Note: Installing the <a href="!adv_help">Advanced help</a> module will let you access more and better help.',
  'version' => 'none',
))
->values(array(
  'lid' => '467',
  'location' => 'theme/theme.inc:116',
  'textgroup' => 'default',
  'source' => "Use the 'Exclude' checkbox to exclude an item from the !content value passed to the node template.",
  'version' => 'none',
))
->values(array(
  'lid' => '468',
  'location' => 'theme/content-edit.js:0',
  'textgroup' => 'default',
  'source' => 'Remove this item',
  'version' => 'none',
))
->values(array(
  'lid' => '469',
  'location' => 'content.module:156 includes/content.admin.inc:528',
  'textgroup' => 'default',
  'source' => 'Add field',
  'version' => 'none',
))
->values(array(
  'lid' => '470',
  'location' => 'examples/example_field.php:278 modules/number/number.module:228,  modules/text/text.module:160',
  'textgroup' => 'default',
  'source' => 'Illegal value for %name.',
  'version' => 'none',
))
->values(array(
  'lid' => '471',
  'location' => 'examples/example_field.php:287 examples/simple_field.php:231,  modules/text/text.module:169',
  'textgroup' => 'default',
  'source' => '%label is longer than %max characters.',
  'version' => 'none',
))
->values(array(
  'lid' => '472',
  'location' => 'examples/example_field.php:560 examples/simple_field.php:438,  modules/text/text.module:333',
  'textgroup' => 'default',
  'source' => '"Rows" must be a positive integer.',
  'version' => 'none',
))
->values(array(
  'lid' => '473',
  'location' => 'modules/number/number.module:133 modules/text/text.module:92',
  'textgroup' => 'default',
  'source' => 'The possible values this field can contain. Enter one value per line, in the format key|label. The key is the value that will be stored in the database and it must match the field storage type, %type. The label is optional and the key will be used as the label if no label is specified.<br />Allowed HTML tags: @tags',
  'version' => 'none',
))
->values(array(
  'lid' => '474',
  'location' => 'includes/content.admin.inc:33',
  'textgroup' => 'default',
  'source' => 'add field',
  'version' => 'none',
))
->values(array(
  'lid' => '475',
  'location' => 'includes/content.admin.inc:112;291',
  'textgroup' => 'default',
  'source' => 'There are no fields configured for this content type. You can !link.',
  'version' => 'none',
))
->values(array(
  'lid' => '476',
  'location' => 'includes/content.admin.inc:113;292',
  'textgroup' => 'default',
  'source' => 'Add a new field',
  'version' => 'none',
))
->values(array(
  'lid' => '477',
  'location' => 'includes/content.admin.inc:137',
  'textgroup' => 'default',
  'source' => 'To change the order of a field, grab a drag-and-drop handle under the Label column and drag the field to a new location in the list. (Grab a handle by clicking and holding the mouse while hovering over a handle icon.) Remember that your changes will not be saved until you click the Save button at the bottom of the page.',
  'version' => 'none',
))
->values(array(
  'lid' => '478',
  'location' => 'includes/content.admin.inc:477',
  'textgroup' => 'default',
  'source' => 'No field modules are enabled. You need to <a href="!modules_url">enable one</a>, such as text.module, before you can add new fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '479',
  'location' => 'includes/content.admin.inc:519',
  'textgroup' => 'default',
  'source' => 'Add existing field',
  'version' => 'none',
))
->values(array(
  'lid' => '480',
  'location' => 'includes/content.admin.inc:590',
  'textgroup' => 'default',
  'source' => 'Create new field',
  'version' => 'none',
))
->values(array(
  'lid' => '481',
  'location' => 'includes/content.admin.inc:606',
  'textgroup' => 'default',
  'source' => 'The machine-readable name of the field.',
  'version' => 'none',
))
->values(array(
  'lid' => '482',
  'location' => 'includes/content.admin.inc:610',
  'textgroup' => 'default',
  'source' => 'This name cannot be changed.',
  'version' => 'none',
))
->values(array(
  'lid' => '483',
  'location' => 'includes/content.admin.inc:618',
  'textgroup' => 'default',
  'source' => "This name cannot be changed later! The name will be prefixed with 'field_' and can include lowercase unaccented letters, numbers, and underscores. The length of the name, including the prefix, is limited to no more than 32 letters.",
  'version' => 'none',
))
->values(array(
  'lid' => '484',
  'location' => 'includes/content.admin.inc:636',
  'textgroup' => 'default',
  'source' => 'The type of data you would like to store in the database with this field.',
  'version' => 'none',
))
->values(array(
  'lid' => '485',
  'location' => 'includes/content.admin.inc:692',
  'textgroup' => 'default',
  'source' => 'The field name %field_name is invalid. The name must include only lowercase unaccentuated letters, numbers, and underscores.',
  'version' => 'none',
))
->values(array(
  'lid' => '486',
  'location' => 'includes/content.admin.inc:695',
  'textgroup' => 'default',
  'source' => "The field name %field_name is too long. The name is limited to 32 characters, including the 'field_' prefix.",
  'version' => 'none',
))
->values(array(
  'lid' => '487',
  'location' => 'includes/content.admin.inc:706',
  'textgroup' => 'default',
  'source' => 'The field name %field_name already exists.',
  'version' => 'none',
))
->values(array(
  'lid' => '488',
  'location' => 'includes/content.admin.inc:709',
  'textgroup' => 'default',
  'source' => "The name 'field_instance' is a reserved name.",
  'version' => 'none',
))
->values(array(
  'lid' => '489',
  'location' => 'includes/content.admin.inc:741',
  'textgroup' => 'default',
  'source' => 'Created field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '490',
  'location' => 'includes/content.admin.inc:754',
  'textgroup' => 'default',
  'source' => 'Update field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '491',
  'location' => 'includes/content.admin.inc:758',
  'textgroup' => 'default',
  'source' => 'There was a problem updating field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '492',
  'location' => 'includes/content.admin.inc:955',
  'textgroup' => 'default',
  'source' => "Advanced usage only: PHP code that returns a default value. Should not include &lt;?php ?&gt; delimiters. If this field is filled out, the value returned by this code will override any value specified above. Expected format: <pre>!sample</pre>Using !link_devel's 'devel load' tab on a %type content page might help you figure out the expected format.",
  'version' => 'none',
))
->values(array(
  'lid' => '493',
  'location' => 'includes/content.admin.inc:986',
  'textgroup' => 'default',
  'source' => "Select a specific number of values for this field, or 'Unlimited' to provide an 'Add more' button so the users can add as many values as they like.",
  'version' => 'none',
))
->values(array(
  'lid' => '494',
  'location' => 'includes/content.admin.inc:1131',
  'textgroup' => 'default',
  'source' => 'The default value PHP code created @value which is invalid.',
  'version' => 'none',
))
->values(array(
  'lid' => '495',
  'location' => 'includes/content.token.inc:62',
  'textgroup' => 'default',
  'source' => 'Formatted HTML link to the node',
  'version' => 'none',
))
->values(array(
  'lid' => '496',
  'location' => 'modules/number/number.module:222',
  'textgroup' => 'default',
  'source' => 'The value of %name may be no smaller than %min.',
  'version' => 'none',
))
->values(array(
  'lid' => '497',
  'location' => 'modules/number/number.module:225',
  'textgroup' => 'default',
  'source' => 'The value of %name may be no larger than %max.',
  'version' => 'none',
))
->values(array(
  'lid' => '498',
  'location' => 'modules/number/number.module:476',
  'textgroup' => 'default',
  'source' => 'Only numbers and decimals are allowed in %field. %start was changed to %value.',
  'version' => 'none',
))
->values(array(
  'lid' => '499',
  'location' => 'modules/number/number.module:494',
  'textgroup' => 'default',
  'source' => 'Only numbers are allowed in %field. %start was changed to %value.',
  'version' => 'none',
))
->values(array(
  'lid' => '500',
  'location' => 'modules/number/number.module:513',
  'textgroup' => 'default',
  'source' => 'Only numbers and the decimal character (%decimal) are allowed in %field. %start was changed to %value.',
  'version' => 'none',
))
->values(array(
  'lid' => '501',
  'location' => 'modules/optionwidgets/optionwidgets.module:10',
  'textgroup' => 'default',
  'source' => 'Create a list of options as a list in <strong>Allowed values</strong> or as an array in PHP code. These values will be the same for %field in all content types.',
  'version' => 'none',
))
->values(array(
  'lid' => '502',
  'location' => 'misc/tabledrag.js',
  'textgroup' => 'default',
  'source' => 'Drag to re-order',
  'version' => 'none',
))
->values(array(
  'lid' => '503',
  'location' => 'misc/tabledrag.js',
  'textgroup' => 'default',
  'source' => 'Changes made in this table will not be saved until the form is submitted.',
  'version' => 'none',
))
->execute();

$connection->schema()->createTable('locales_target', array(
  'fields' => array(
    'lid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'translation' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'plid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'plural' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'language',
    'lid',
    'plural',
  ),
  'indexes' => array(
    'lid' => array(
      'lid',
    ),
    'plid' => array(
      'plid',
    ),
    'plural' => array(
      'plural',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('locales_target')
->fields(array(
  'lid',
  'translation',
  'language',
  'plid',
  'plural',
))
->values(array(
  'lid' => '5',
  'translation' => "Le module Content, composant obligatoire du kit CCK (Content Construction Kit) permet aux administrateurs d'associer des champs personnalisés à des types de contenus. Au sein de Drupal, les types de contenus servent à définir les caractéristiques d'une publication, y compris le titre et la description des champs affichés sur ses pages \"ajouter\" et \"éditer\". Le module Content (et les modules auxiliaires inclus dans CCK) permet d'ajouter des champs personnalisés en plus des champs par défaut \"Titre\" et \"Corps\". Les fonctionnalités de CCK sont accessible via différents onglets sur la <a href=\"@content-types\">page d'administration des types de contenus</a>. (Voir la <a href=\"@node-help\">page d'aide du module Node</a> pour plus d'informations sur les types de contenus).",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '6',
  'translation' => "Lorsque vous ajoutez un champ personnalisé à un type de contenu, vous déterminez son type (c'est-à-dire s'il doit contenir du texte, des nombres ou des références à d'autres objets) et la façon dont il doit être affiché (en tant que champ ou zone de texte, liste de sélection, case à cocher, bouton radio, ou champ à auto-complètement). Un champ peut présenter plusieurs valeurs (par exemple, une \"personne\" peut disposer de plusieurs adresses courriel) ou une seule (par exemple, un \"employé\" possède un numéro d'identification unique). À mesure que vous ajoutez et modifiez des champs, CCK ajuste automatiquement la structure de la base de données en fonction. CCK propose également un certain nombre d'autres fonctionnalités, par exemple un cache intelligent pour vos données personnalisées, des fonctionnalités d'import et d'export pour les définitions de types de contenus, ainsi qu'une intégration à d'autres modules provenant des contributions.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '7',
  'translation' => "Des types de champs personnalisés sont proposés par plusieurs modules optionnels inclus dans CCK (chaque module fournissant un type différent). La <a href=\"@modules\">page des modules</a> vous permet d'activer ou de désactiver des composants CCK. Une installation par défaut de CCK inclut :",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '8',
  'translation' => "<em>Number</em>, qui ajoute des types de champs numériques (formats entier, décimal ou réel à virgule flottante). Vous pouvez définir un jeu ou un intervalle de valeurs autorisées. Divers formats sont disponibles pour l'affichage des données numériques.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '9',
  'translation' => "<em>Text</em>, qui ajoute des types de champs de texte. Un champ texte peut contenir du texte brut uniquement ou, optionnellement, utiliser les filtres des formats d'entrée que propose Drupal pour gérer en toute sécurité des textes enrichis. Les champs de saisie de texte peuvent être constitués d'une seule ligne (champ texte), de plusieurs lignes (zone de texte) ou, pour un meilleur contrôle des valeurs saisies, une liste de sélection, des cases à cocher ou des boutons radio. Si besoin, CCK peut valider les saisies sur la base d'un ensemble de valeurs autorisées.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '10',
  'translation' => '<em>Node Reference</em>, qui crée des références personnalisées entre nœuds de Drupal. En ajoutant, par exemple, un champ <em>nodereference</em> et deux types de contenus différents, vous pouvez facilement créer des relations complexes de type parent/enfant entre données (par exemple plusieurs nœuds "employé" peuvent présenter un champ <em>nodereference</em> pointant vers un même nœud "employeur").',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '11',
  'translation' => "<em>User reference</em>, qui crée des références personnalisées vers les comptes des utilisateurs de votre site. En ajoutant un champ <em>userreference</em>, vous pouvez créer des relations complexes entre les utilisateurs de votre site et des publications. Ainsi, pour tracer l'implication d'un utilisateur dans une publication (au delà du champ Drupal standard <em>Écrit par</em>), vous pouvez ajouter à un type de contenu un champ <em>userreference</em> intitulé \"Édité par\" pour enregistrer un lien vers la page du compte utilisateur ayant édité la publication.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '12',
  'translation' => "<em>Fieldgroup</em>, qui crée des groupes de champs liés. Les groupe de champ peuvent être repliés, et vous pouvez choisir qu'ils soient dépliés ou repliés par défaut. L'ordre des groupes de champs, ainsi que l'ordre des champs au sein d'un groupe, est géré grâce à l'interface par glisser-déposer fournie par le module Content.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '13',
  'translation' => "Pour plus d'informations, reportez-vous à l'entrée de manuel en ligne relative à <a href=\"@handbook-cck\">CCK</a> ou à la <a href=\"@project-cck\">page du projet CCK</a>.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '14',
  'translation' => 'Configurez ici la manière dont les champs et étiquettes de champs de ce type de contenu doivent être affichées, lorsque le contenu est vu en mode résumé ou en pleine page.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '15',
  'translation' => "Configurez ici la façon dont les champs de ce type de contenu doivent être affichés lorsqu'il est rendu dans les contextes suivants.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '16',
  'translation' => "Contrôlez ici l'ordre des champs dans le formulaire de saisie.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '17',
  'translation' => 'Ce champ est obligatoire.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '18',
  'translation' => '!title : !required',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '19',
  'translation' => 'Ordre',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '20',
  'translation' => 'Élément de flux RSS',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '21',
  'translation' => 'Index de recherche',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '22',
  'translation' => 'Résultat de recherche',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '23',
  'translation' => 'Langue',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '24',
  'translation' => 'Taxonomie',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '25',
  'translation' => 'Fichiers attachés',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '26',
  'translation' => 'Mise à jour du type de champ %type avec le module %module.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '27',
  'translation' => 'Mise à jour du type de widget %widget avec le module %module.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '28',
  'translation' => "Utiliser du code PHP pour le paramétrage des champs (dangereux - à n'autoriser qu'avec précautions)",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '29',
  'translation' => 'Gérer les champs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '30',
  'translation' => 'Afficher les champs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '31',
  'translation' => 'Général',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '32',
  'translation' => 'Avancé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '33',
  'translation' => 'Supprimer un champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '34',
  'translation' => 'Content',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '35',
  'translation' => 'Permet aux administrateurs de définir des nouveaux types de contenu.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '36',
  'translation' => 'CCK',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '37',
  'translation' => 'Texte',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '38',
  'translation' => "Les valeurs possibles pour ce champ. Saisissez une valeur par ligne, sous la forme <em>clé|libellé</em>. La clé est la valeur enregistrée dans la base de données, et elle doit correspondre au type de stockage du champ, %type. Le libellé est optionnel et, s'il n'est pas spécifié, la clé sera utilisée comme libellé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '39',
  'translation' => 'Zone de texte',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '40',
  'translation' => 'Ôter',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '41',
  'translation' => 'Basique',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '42',
  'translation' => 'Résumé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '43',
  'translation' => 'Nœud complet',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '44',
  'translation' => 'RSS',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '45',
  'translation' => 'Recherche',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '46',
  'translation' => 'Formulaire du module node.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '47',
  'translation' => 'Formulaire du module locale.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '48',
  'translation' => 'Paramètres du menu',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '49',
  'translation' => 'Formulaire du module menu.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '50',
  'translation' => 'Formulaire du module taxonomy.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '51',
  'translation' => 'Livre',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '52',
  'translation' => 'Formulaire du module livre (book).',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '53',
  'translation' => 'Titre du sondage',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '54',
  'translation' => 'Titre du module sondage (Poll)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '55',
  'translation' => 'Choix du sondage',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '56',
  'translation' => 'Choix du module sondage (poll).',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '57',
  'translation' => 'Paramètrage du sondage',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '58',
  'translation' => 'Paramètres du module sondage (poll).',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '59',
  'translation' => 'Formulaire du module upload.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '60',
  'translation' => 'contenu',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '61',
  'translation' => 'Champs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '62',
  'translation' => "Les mises à jour des modules liés à CCK ne sont pas exécutées tant que les modules ne sont pas activés sur la  <a href=\"@admin-modules-path\">page d'administration des modules</a>. Lorsque vous les activerez, vous devrez retourner sur la page <a href=\"@update-php\">update.php</a> et exécuter les mises à jour restantes.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '63',
  'translation' => "!module.module possède des mises à jour mais ne peut pas être mis à jour car content.module n'est pas activé.<br /> Le cas échéant, lors de l'activation de content.module, vous devrez exécuter à nouveau le script de mise à jour. Vous continuerez à voir ce message jusqu'à ce que le module soit activé et les mises à jour exécutées.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '64',
  'translation' => "!module.module possède des mises à jour et est disponible dans le répertoire des modules, mais n'est pas activé.<br /> Le cas échéant, lorsque vous l'aurez activé, vous devrez ré-exécuter le script de mise à jour. Vous continuerez à voir ce message jusqu'à l'activation du module et l'exécution des mises à jour. ",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '65',
  'translation' => 'Des mises à jour sont toujours en attente. Veuillez retourner sur <a href="@update-php">update.php</a> et exécuter les mises à jour restarntes.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '66',
  'translation' => 'CCK - Aucune Intégration aux Vues',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '67',
  'translation' => 'L"intégration de CCK avec le module Views requiert Views 6.x-2.0-rc2 ou une version supérieure.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '68',
  'translation' => 'Nom',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '69',
  'translation' => 'Type',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '70',
  'translation' => 'Description',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '71',
  'translation' => 'Opérations',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '72',
  'translation' => 'éditer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '73',
  'translation' => 'gérer les champs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '74',
  'translation' => 'supprimer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '75',
  'translation' => 'Aucun type de contenu disponible.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '76',
  'translation' => '» Ajouter un nouveau type de contenu',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '77',
  'translation' => 'Nom du champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '78',
  'translation' => 'Type de champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '79',
  'translation' => 'Utilisé dans',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '80',
  'translation' => '@field_name (Verrouillé)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '81',
  'translation' => "Aucun champ n'est pour l'instant défini sur l'ensemble des types de contenu.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '82',
  'translation' => "Ce type de contenu possède des champs inactifs. Les champs inactifs ne sont pas inclus dans la liste de champs disponibles, jusqu'à l'activation des modules correspondants.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '83',
  'translation' => '!field (!field_name) est un champ inactif de type !field_type, qui utilise un widget de type !widget_type.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '84',
  'translation' => 'Configurer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '85',
  'translation' => 'Verrouillé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '86',
  'translation' => '- Sélectionnez un type de champ -',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '87',
  'translation' => '- Sélectionnez un widget -',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '88',
  'translation' => 'Étiquette',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '89',
  'translation' => 'Nom du champ (a-z, 0-9, _)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '90',
  'translation' => 'Type de données à stocker.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '91',
  'translation' => "Elément du formulaire pour l'édition des données.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '92',
  'translation' => '- Sélectionnez un champ existant -',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '93',
  'translation' => 'Champ à partager',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '94',
  'translation' => 'Nom du groupe (a-z, 0-9, _)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '95',
  'translation' => 'Enregistrer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '96',
  'translation' => 'Ajouter un nouveau champ : vous devez fournir une étiquette.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '97',
  'translation' => 'Ajouter un nouveau champ : vous devez fournir un nom de champ.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '98',
  'translation' => "Ajouter un nouveau champ : le nom de champ %field_name n'est pas valide. Le nom doit seulement contenir des lettre minuscules non accentuées, des nombres, et des underscores. ",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '99',
  'translation' => "Ajouter un nouveau champ : le nom de champ %field_name est trop long. Le nom est limité à 32 caractères, en comptant le préfixe 'field_'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '100',
  'translation' => "Ajouter un nouveau champ : le nom 'field_instance' est un nom réservé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '101',
  'translation' => 'Ajouter un nouveau champ : le nom du champ %field_name existe déjà.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '102',
  'translation' => 'Ajouter un nouveau champ : vous devez sélectionner un type de champ.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '103',
  'translation' => 'Ajouter un nouveau champ : vous devez sélectionner un widget.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '104',
  'translation' => 'Ajouter un nouveau champ : widget non valide.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '105',
  'translation' => 'Ajouter un champ existant : vous devez fournir une étiquette.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '106',
  'translation' => 'Ajouter un champ existant : vous devez sélectionner un champ.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '107',
  'translation' => 'Ajouter un champ existant: vous devez sélectionner un widget.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '108',
  'translation' => 'Ajouter un champ existant : widget non valide.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '109',
  'translation' => "Un problème est survenu à la création du champ '%label'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '110',
  'translation' => "Le champ %label n'a pas pu être ajouté au type de contenu car il est verrouillé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '111',
  'translation' => "Un problème est survenu lors de l'ajout du champ '%label'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '112',
  'translation' => "Il n'y a aucun champ configuré pour ce type de contenu. Vous pouvez ajouter de nouveaux champs sur la page <a href=\"@link\">Gérer les champs</a>.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '113',
  'translation' => 'Au dessus',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '114',
  'translation' => 'Sur la même ligne',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '115',
  'translation' => 'Inclure',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '116',
  'translation' => 'Exclure',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '117',
  'translation' => 'aucune mise en forme',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '118',
  'translation' => 'simple',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '119',
  'translation' => 'groupe de champs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '120',
  'translation' => 'groupe de champs - repliable',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '121',
  'translation' => 'groupe de champs - replié',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '122',
  'translation' => 'Vos paramètres ont été enregistrés.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '123',
  'translation' => '@type : @field (@label)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '124',
  'translation' => 'Éditer les informations de base',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '125',
  'translation' => 'Le nom lisible par une machine du champ. Ce nom ne peut être changé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '126',
  'translation' => "Nom lisible par une personne, destiné à servir d'étiquette pour ce champ au sein du type de contenu '%type'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '127',
  'translation' => 'Type de données que vous souhaitez enregistrer, par le biais de ce champ, dans la base de données. Cette option ne peut être modifiée.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '128',
  'translation' => 'Type de widget',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '129',
  'translation' => "Type d'élément de formulaire que vous souhaitez présenter à l'utilisateur lorsqu'il renseigne ce champ dans le type de contenu '%type'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '130',
  'translation' => 'Continuer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '131',
  'translation' => 'Les paramètres basiques du champ %label ont été mis à jour.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '132',
  'translation' => 'Un problème a été rencontré lors de la mise à jour des paramètres basiques du champ %label.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '133',
  'translation' => "Êtes-vous certain de vouloir enlever le champ '%field' ?",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '134',
  'translation' => 'Si vous avez encore du contenu dans ce champ, il sera perdu. Cette action est irréversible.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '135',
  'translation' => 'Annuler',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '136',
  'translation' => 'Ce champ est <strong>verrouillé</strong> et ne peut être supprimé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '137',
  'translation' => "Le champ '%field' de '%type' a été enlevé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '138',
  'translation' => "Un problème est survenu à la suppression du champ '%field' du type '%type'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '139',
  'translation' => 'Le champ %field est verouillé et ne peut être édité.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '140',
  'translation' => "Informations de base pour '%type'",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '141',
  'translation' => 'Modifier les informations de base',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '142',
  'translation' => "Paramètres de '%type'",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '143',
  'translation' => "Ces paramètres ne s'applique qu'au champ '%field' tel qu'il apparaît dans le type contenu '%type'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '144',
  'translation' => "Texte d'aide",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '145',
  'translation' => "Instructions à présenter à l'utilisateur sous ce champ, dans le formulaire d'édition.<br />Balises HTML autorisées : @tags",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '146',
  'translation' => 'Valeur par défaut',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '147',
  'translation' => 'Code PHP',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '148',
  'translation' => "'@column' => valeur de @column",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '149',
  'translation' => "return array(\n  0 => array(@columns),\n  // Vous voudrez vous arrêter là dans la plupart des cas. Fournir plus de valeurs\n  // si vous souhaitez que votre 'valeur par défaut' ait des valeurs multiples :\n  1 => array(@columns),\n  2 => ...\n);",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '150',
  'translation' => 'Code',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '151',
  'translation' => "Usage avancé seulement : code PHP retournant une valeur par défaut. Ne doit pas contenir les délimiteurs &lt;?php ?&gt;. Si ce champ est rempli, la valeur retournée par ce code écrasera toute valeur spécifiée ci-dessus. Format attendu : <pre>!sample</pre>. Pour vous faire une idée du format attendu, vous pouvez utiliser l'onglet <em>devel load</em> fourni par <a href=\"@link_devel\">le module devel</a> sur une page de contenu de type  %type.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '152',
  'translation' => '&lt;aucun&gt;',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '153',
  'translation' => "Vous n'êtes pas autorisé à saisir du code PHP.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '154',
  'translation' => 'Ce code PHP a été inséré par un administrateur et supplantera toute valeur spécifiée ci-dessus.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '155',
  'translation' => 'Paramètres globaux',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '156',
  'translation' => "Ces paramètres s'appliquent au champ '%field' dans tous les types de contenu où il apparaît.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '157',
  'translation' => 'Obligatoire',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '158',
  'translation' => "Le nombre maximum de valeurs qu'un utilisateur peut entrer pour ce champ.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '159',
  'translation' => "'Illimité' fournira un bouton 'Ajouter plus' pour que les utilisateurs puissent ajouter autant de valeurs qu'ils le souhaitent.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '160',
  'translation' => 'Attention ! Changer ce paramètre alors que des données ont déjà été créées peut conduire à perdre des données !',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '161',
  'translation' => 'Nombre de valeurs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '162',
  'translation' => 'Illimité',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '163',
  'translation' => 'Enregistrer les paramètres du champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '164',
  'translation' => "Le code PHP pour la 'valeur par défaut' a retourné @value, qui n'est pas valide.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '165',
  'translation' => 'La valeur par défaut est invalide.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '166',
  'translation' => "Le champ '%label' a été ajouté.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '167',
  'translation' => "Champ '%label' enregistré.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '168',
  'translation' => 'Exécution',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '169',
  'translation' => 'La mise à jour a échoué.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '170',
  'translation' => 'La base de données a été modifiée et des données ont été déplacées ou supprimées.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '171',
  'translation' => 'Une erreur est survenue et a interrompu la modification de la base de données.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '172',
  'translation' => "'%title' en cours de traitement",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '173',
  'translation' => '%name doit être un entier.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '174',
  'translation' => '%name doit être un entier positif.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '175',
  'translation' => '%name doit être un nombre.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '176',
  'translation' => '1 élément traité avec succès&nbsp:',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '177',
  'translation' => '@count éléments traités avec succès&nbsp:',
  'language' => 'fr',
  'plid' => '176',
  'plural' => '1',
))
->values(array(
  'lid' => '178',
  'translation' => "La table de champs a été renommée de '%old_name' à '%new_name' et les instances des champs ont été mises à jour.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '179',
  'translation' => "La table de champs '%name' a été supprimée.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '180',
  'translation' => 'Ajouter un autre élément',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '181',
  'translation' => 'Contenu du champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '182',
  'translation' => 'Un champ de contenu du node référencé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '183',
  'translation' => 'Noeud',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '184',
  'translation' => 'Contexte du noeud',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '185',
  'translation' => 'Titre du bloc',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '186',
  'translation' => 'Caché',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '187',
  'translation' => "Configurer la manière dont l'étiquette est affichée.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '188',
  'translation' => 'Champ / Formateur',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '189',
  'translation' => 'Sélectionner un champ et un formateur.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '190',
  'translation' => '"@s" champ @name',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '191',
  'translation' => 'Remplir un champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '192',
  'translation' => 'Vous devez vous assurer que le champ existe pour le type de contenu donné.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '193',
  'translation' => 'Champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '194',
  'translation' => 'Sélectionnez le nom-machine du champ.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '195',
  'translation' => 'Avancé : Préciser les valeurs des champs avec du code PHP',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '196',
  'translation' => "Usage avancé seulement : code PHP retournant la valeur à définir. Ne doit pas contenir les délimiteurs &lt;?php ?&gt;. Si ce champ est rempli, la valeur retournée par ce code écrasera toute valeur spécifiée ci-dessus. Format attendu : <pre>!sample</pre>. Pour vous faire une idée du format attendu, vous pouvez utiliser l'onglet <em>devel load</em> fourni par <a href=\"@link_devel\">le module devel</a> sur une page de contenu de type  %type.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '197',
  'translation' => 'Vous devez retourner la valeur par défaut dans le format attendu.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '198',
  'translation' => "Remplir le champ '@field' de @node",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '199',
  'translation' => 'Le champ possède une valeur',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '200',
  'translation' => 'Vous devez vous assurer que le champ utilisé existe dans le type de contenu donné. La condition retourne TRUE, si le champ sélectionné possède la valeur donnée.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '201',
  'translation' => 'Le champ a été modifié',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '202',
  'translation' => 'Contenu contenant des modifications',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '203',
  'translation' => 'Contenu ne contenant pas de modification',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '204',
  'translation' => "Le champ '@field' de @node possède une valeur",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '205',
  'translation' => 'Sélectionnez le nom-machine du champ à voir.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '206',
  'translation' => "Le champ '@field' de @node a été modifié",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '207',
  'translation' => 'Jeton (Token)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '208',
  'translation' => 'Identifiant du nœud référencé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '209',
  'translation' => 'Titre du nœud référencé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '210',
  'translation' => 'Titre non filtré du noeud référencé. ATTENTION - saisie brute utilisateur.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '211',
  'translation' => 'Lien html formaté vers le noeud référencé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '212',
  'translation' => 'Alias de chemin relatif vers le noeud référencé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '213',
  'translation' => 'Alias de chemin absolu vers le noeud référencé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '214',
  'translation' => 'Valeur numérique brute',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '215',
  'translation' => 'Valeur numérique mise en forme',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '216',
  'translation' => 'Texte brut, non filtré',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '217',
  'translation' => 'Texte filtré et mis en forme',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '218',
  'translation' => "Identifiant de l'utilisateur référencé",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '219',
  'translation' => "Nom de l'utilisateur référencé",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '220',
  'translation' => "Lien HTML mis en forme vers l'utilisateur référencé",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '221',
  'translation' => "Alias de chemin relatif vers l'utilisateur référencé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '222',
  'translation' => "Alias de chemin absolu vers l'utilisateur référencé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '223',
  'translation' => '@label (!name)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '224',
  'translation' => '@label (!name) - !column',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '225',
  'translation' => '@label-truncated - !column',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '226',
  'translation' => 'Apparaît dans : @types',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '227',
  'translation' => 'Aucun',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '228',
  'translation' => 'Étiquette du widget (@label)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '229',
  'translation' => 'Personnalisé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '230',
  'translation' => 'Étiquette personnalisée',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '231',
  'translation' => 'Format',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '232',
  'translation' => 'Grouper plusieurs valeurs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '233',
  'translation' => "Si non coché, chaque élément du champ créera une nouvelle ligne, ce qui pourrait apparemment entraîner des doublons. Ce paramètre n'est pas compatible avec le tri par clic dans l'affichage du tableau. ",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '234',
  'translation' => 'Afficher @count valeur(s)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '235',
  'translation' => 'en commençant à @count',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '236',
  'translation' => 'Inversé (commencer à partir des dernières valeurs)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '237',
  'translation' => 'Tous / Toutes',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '238',
  'translation' => 'Delta',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '239',
  'translation' => "Le delta vous permet de sélectionner quel élément d'un champ à valeur multiple sera la clé de la relation. Sélectionnez \"1\" pour utiliser le premier élément, \"2\" pour le second et ainsi de suite. Si vous sélectionnez \"Tous\", chaque élément du champ créera une nouvelle ligne, ce qui pourrait causer des doublons.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '240',
  'translation' => "Le delta vous permet de sélectionner quel élément d'un champ à valeur multiple sera utilisé pour les tris. Sélectionnez \"1\" pour utiliser le premier élément, \"2\" pour le second et ainsi de suite. Si vous sélectionnez \"Tous\", chaque élément du champ créera une nouvelle ligne, ce qui pourrait causer des doublons.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '241',
  'translation' => 'Exporter',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '242',
  'translation' => "Ce formulaire traitera un type de contenu et un ou plusieurs champs de ce type, pour en exporter les paramètres. Le code d'export ainsi généré peut être copié et collé dans la page d'import, vers la base de données courante ou vers une autre base de données. L'opération d'import ajoutera les champs à un type de contenu existant ou créera un nouveau type de contenu intégrant les champs sélectionnés.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '243',
  'translation' => 'Types',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '244',
  'translation' => 'Sélectionner le type de contenu à exporter.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '245',
  'translation' => 'Données exportée',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '246',
  'translation' => "Copiez le texte exporté et collez-le dans le type de contenu de votre choix, à l'aide de la fonction d'import.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '247',
  'translation' => 'Types de contenu',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '248',
  'translation' => 'Type de contenu',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '249',
  'translation' => 'Séléctionnez le type de contenu dans lequel importer ces champs.<br />Sélectionnez &lt;Créer&gt; pour créer un nouveau type de contenu qui contiendra ces champs.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '250',
  'translation' => 'Données à importer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '251',
  'translation' => 'Collez dans ce champ le texte créé par un export de contenu.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '252',
  'translation' => 'Importer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '253',
  'translation' => "Un fichier a été préchargé pour l'import.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '254',
  'translation' => "Les données d'import ne sont valides.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '255',
  'translation' => "Les modules suivants doivent être activés pour que l'import fonctionne : '%modules'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '256',
  'translation' => "Le type de contenu '%type' existe déjà dans cette base de données.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '257',
  'translation' => "Abandon. L'import n'a pas été réalisé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '258',
  'translation' => "Une erreur s'est produite lors de l'ajout du nouveau type de contenu %type.<br> Veuillez vérifier les erreurs affichées pour plus de détails.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '259',
  'translation' => "Le champ importé '%field_label' (%field_name) n'a pas été ajouté à '%type' car ce champ existe déjà.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '260',
  'translation' => "Le champ importé '%field_label' (%field_name) a été ajouté au type de contenu '%type'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '261',
  'translation' => 'content_copy',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '262',
  'translation' => 'Content Copy',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '263',
  'translation' => "Permet d'importer et d'exporter des définitions de champs.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '264',
  'translation' => "Les champs d'un groupe Standard sont indépendants les uns des autres, et chacun peut soit avoir une valeur unique, soit des valeurs multiples. Les champs d'un Multigroupe sont traités comme une ensemble répétable de champs à valeurs uniques.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '265',
  'translation' => 'Multigroupe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '266',
  'translation' => 'Standard',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '267',
  'translation' => 'Type de groupe.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '268',
  'translation' => "Le champ %field a été mis à jour pour l'utilisation de valeurs %multiple, afin de correspondre au paramètre de valeur multipe du Multigroup %group.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '269',
  'translation' => "Cette modification n'est pas autorisée. Le champ %field possède déjà des valeurs multiples dans la base de données, mais le groupe %group en autorise seulement %group_max. Effectuer cette modification pourrait entraîner la perte de données. ",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '270',
  'translation' => "Cette modification n'est pas autorisée. Le champ %field manipule les valeurs multiples différemment du module Content. Effectuer cette modification pourrait entraîner la perte de données. ",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '271',
  'translation' => "Vous êtes en train d'inclure le champ %field dans un Multigroupe",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '272',
  'translation' => "Cette modification n'est pas autorisée. Le champ %field possède déjà des données créées, et utilise un widget qui stocke les données différemment dans un groupe Standard que dans un Multigroupe. Effectuer ce changement pourrait entraîner la perte de données.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '273',
  'translation' => "Vous êtes en train de retirer le champ %field d'un Multigroupe",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '274',
  'translation' => 'Simple',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '275',
  'translation' => 'Groupe de champs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '276',
  'translation' => 'Ligne horizontale',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '277',
  'translation' => 'Tableau - Colonne unique',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '278',
  'translation' => 'Tableau - Colonnes multiples',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '279',
  'translation' => '[Format du sous-groupe]',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '280',
  'translation' => 'Paramètres multigroupe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '281',
  'translation' => 'Colonnes multiples',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '282',
  'translation' => "Activez cette option pour rendre chaque champs dans une colonne disctincte sur le formulaire d'édition de noeud.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '283',
  'translation' => "Activez cette option pour rendre obligatoire un minimum d'une collection de champs dans ce Multigroupe.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '284',
  'translation' => "Nombre de fois où répéter l'ensemble Multigroupe de champs.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '285',
  'translation' => "'Illimité' fournira un bouton 'Ajouter plus' pour que les utilisateurs puissent ajouter des éléments autant de fois qu'ils le souhaitent.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '286',
  'translation' => 'Tous les champs de ce groupe seront automatiquement paramétrés pour autoriser ce nombre de valeurs.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '287',
  'translation' => 'Nombre de répétitions',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '288',
  'translation' => 'Etiquettes',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '289',
  'translation' => "Etiquettes pour chaque sous-groupe de champs. Les étiquettes peuvent être cachées ou affichées dans des contextes divers en utilisant l'écran 'Afficher les champs'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '290',
  'translation' => 'Etiquette du sous-groupe %number',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '291',
  'translation' => 'Le champ %field dans ce groupe possède déjà %multiple valeurs dans la base de données. Pour éviter la perte de données, vous ne pouvez définir le nombre de valeurs du Multigroupe à une valeur inférieure.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '292',
  'translation' => 'Le champ !name est obligatoire dans le groupe @group.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '293',
  'translation' => 'Le groupe @name requiert au minimum un groupe de champs.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '294',
  'translation' => 'Ajouter plus de valeurs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '295',
  'translation' => 'content_multigroup',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '296',
  'translation' => 'Contenu Multigroupe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '297',
  'translation' => "Combinez de multiples champs CCK au sein de collections de champs qui fonctionnent à l'unisson.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '298',
  'translation' => 'éditer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '299',
  'translation' => 'field_name',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '300',
  'translation' => 'voir',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '301',
  'translation' => 'content_permissions',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '302',
  'translation' => 'Veuillez <a href="!url">configurer vos permissions sur les champs</a> immédiatement. Tous les champs sont inaccessibles par défaut.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '303',
  'translation' => 'Permissions sur les Contenus',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '304',
  'translation' => 'Définit un niveau de permission par champ pour les champs CCK.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '305',
  'translation' => 'Contenu du groupe de champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '306',
  'translation' => "Tous les champs d'un groupe de champs sur le node référencé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '307',
  'translation' => '@group_label (@group_type_name)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '308',
  'translation' => 'Fieldgroup',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '309',
  'translation' => "Texte à afficher si un groupe n'a pas de données. Notez que le titre ne s'affichera pas sauf s'il est surclassé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '310',
  'translation' => '"@s" groupe de champs @name',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '311',
  'translation' => 'Paramètres du formulaire',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '312',
  'translation' => "Ces paramètres s'appliquent au groupe dans le formulaire d'édition de nœud.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '313',
  'translation' => 'Style',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '314',
  'translation' => 'toujours déplié',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '315',
  'translation' => 'repliable',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '316',
  'translation' => 'replié',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '317',
  'translation' => "Instructions à présenter à l'utilisateur dans le formulaire d'édition.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '318',
  'translation' => "Paramètres d'affichage",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '319',
  'translation' => "Ces paramètres s'appliquent au groupe à l'affichage du nœud.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '320',
  'translation' => 'Description du groupe.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '321',
  'translation' => "Êtes-vous sûr(e) de vouloir supprimer le groupe '%label' ?",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '322',
  'translation' => 'Cette action est irréversible.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '323',
  'translation' => "Le groupe '%group_name' a été supprimé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '324',
  'translation' => 'aucun',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '325',
  'translation' => 'Vous devez fournir une étiquette.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '326',
  'translation' => 'Vous devez fournir un nom de groupe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '327',
  'translation' => "Le nom de groupe %group_name n'est pas valide. Le nom ne doit contenir que des lettres sans accents, des nombres, et des underscores.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '328',
  'translation' => "Le nom de groupe %group_name est trop long. Le nom est limité à 32 caractères, le préfixe 'group_' compris.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '329',
  'translation' => 'Le nom de groupe %group_name existe déjà.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '330',
  'translation' => 'Ajouter un nouveau groupe :',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '331',
  'translation' => 'Ajouter un nouveau groupe : vous devez fournir une étiquette.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '332',
  'translation' => 'Ajouter un nouveau groupe : vous devez fournir un nom de groupe.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '333',
  'translation' => 'Groupe standard',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '334',
  'translation' => 'Éditer le groupe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '335',
  'translation' => 'fieldgroup',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '336',
  'translation' => "Créée des groupes d'affichage pour les champs CCK.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '337',
  'translation' => 'Charge un noeud référencé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '338',
  'translation' => 'Contenu contenant le champ node reference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '339',
  'translation' => 'Contenu référencé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '340',
  'translation' => 'Notez que si le champs possède des valeurs multiples, seul le premier contenu sera chargé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '341',
  'translation' => "Il n'y a aucun champ  nodereference défini.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '342',
  'translation' => 'Node référence',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '343',
  'translation' => "Stocker l'ID du noeud lié en tant que valeur entière.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '344',
  'translation' => 'Types de contenu pouvant être référencés',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '345',
  'translation' => 'Vues par défaut',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '346',
  'translation' => 'Vues éxistantes',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '347',
  'translation' => 'Avancé - Nœuds pouvant être référencés (Vue)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '348',
  'translation' => 'Vue utilisée pour sélectionner les noeuds',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '349',
  'translation' => '<p>Choisissez la vue du "module Views" qui sélectionne les noeuds pouvant être référencés.<br />Note :</p>',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '350',
  'translation' => "<ul><li>Seules les vues qui possèdent des champs fonctionneront à cet effet.</li><li>Ceci annulera les paramètres \"Types de contenu\" ci-dessus. Utilisez la section \"filtres\" de la vue à la place.</li><li>Utilisez la section \"champs\" de la vue pour afficher des informations supplémentaires à propos des noeuds candidats sur le formulaire de création/édition.</li><li>Utilisez la section \"critère de tri\" de la vue pour déterminer l'ordre dans lequel les noeuds candidats seront affichés.</li></ul>",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '351',
  'translation' => 'Arguments de la vue',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '352',
  'translation' => "Fournit une liste d'arguments, séparés par des virgules, à transmettre à la vue.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '353',
  'translation' => "<p>La liste des noeuds pouvant être référencés peut s'appuyer sur une vue du \"module Views\" mais aucune vue appropriée n'a été trouvée. <br />Note :</p>",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '354',
  'translation' => '%name : saisie non valide.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '355',
  'translation' => '%name : ce contenu ne peut être référencé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '356',
  'translation' => 'Titre (avec lien)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '357',
  'translation' => 'Titre (sans lien)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '358',
  'translation' => 'Liste de sélection',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '359',
  'translation' => 'Cases à cocher/boutons radio',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '360',
  'translation' => 'Champ texte à auto-complètement',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '361',
  'translation' => "Correspondance de l'autocomplétion",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '362',
  'translation' => 'Commence par',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '363',
  'translation' => 'Contient',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '364',
  'translation' => "Séléctionnez la méthode utilisée pour collecter les suggestions de l'autocomplétion. Notez que <em>Contient</em> peut engendrer des problèmes de performances sur des sites avec des milliers de noeuds",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '365',
  'translation' => '%name : différence de titre. Veuillez vérifier votre sélection.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '366',
  'translation' => "%name : aucun contenu valide n'a été trouvé pour ce titre.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '367',
  'translation' => 'Autocomplétion de nodereference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '368',
  'translation' => 'nodereference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '369',
  'translation' => 'Node Reference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '370',
  'translation' => 'Définit un type de champ pour référencer un noeud depuis un autre noeud.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '371',
  'translation' => 'Entier',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '372',
  'translation' => 'Stocke un nombre dans la base de données en format entier.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '373',
  'translation' => 'Décimal',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '374',
  'translation' => 'Stocke un nombre dans la base de données en format décimal fixe.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '375',
  'translation' => 'Réel (Float)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '376',
  'translation' => 'Stocke un nombre dans la base de données en format réel.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '377',
  'translation' => 'Minimum',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '378',
  'translation' => 'Maximum',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '379',
  'translation' => 'Précision',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '380',
  'translation' => 'Le nombre total de chiffres à stocker dans la base de données, en incluant ceux à droite de la virgule.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '381',
  'translation' => 'Echelle',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '382',
  'translation' => 'Le nombre de chiffres à droite de la virgule',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '383',
  'translation' => 'Séparateur de décimales',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '384',
  'translation' => 'Le caractère que les utilisateurs saisiront pour séparer les décimales dans les formulaires.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '385',
  'translation' => 'Préfixe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '386',
  'translation' => 'Définissez une chaîne de caractères à utiliser pour préfixer la valeur, par exemple $ ou €. Laissez vide pour ne rien afficher de plus. Séparez les valeurs singulier et pluriel par une barre verticale (euro|euros).',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '387',
  'translation' => 'Suffixe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '388',
  'translation' => 'Définissez une chaîne qui sera ajoutée en suffixe à la valeur, comme m², m/s², kb/s. Laisser vide pour aucun suffixe. Séparez les singulier et pluriel avec un pipe (mètre|mètres).',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '389',
  'translation' => 'Valeurs autorisées',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '390',
  'translation' => 'Liste des valeurs autorisées',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '391',
  'translation' => "Les valeurs possibles que ce champ peut contenir. Entrez une valeur par ligne, sous la forme clé|étiquette. La clé est une valeur qui sera stocker dans la base de données, elle doit correspondre au type de champ défini (%type). L'étiquette est optionnelle, si elle n'est pas précisée, la clé sera utilisée également comme étiquette.<br />Balises HTML autorisées : @tags",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '392',
  'translation' => 'Pour usage avancé seulement : code PHP fournissant un tableau par clé des valeurs autorisées. Ne doit pas inclure les délimiteurs &lt;?php ?&gt;. Si ce champ est rempli, le tableau renvoyé par le code prendra le pas sur la liste des valeurs autorisées apparaissant ci-dessus.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '393',
  'translation' => 'Ce code PHP a été saisi par un administrateur et supplantera la liste des valeurs permises ci-dessus.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '394',
  'translation' => '@label (!name) - Valeurs autorisées',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '395',
  'translation' => '"Minimum" doit être un nombre.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '396',
  'translation' => '"Maximum" doit être un nombre.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '397',
  'translation' => '%name : la valeur ne peut être inférieure à %min.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '398',
  'translation' => '%name : la valeur ne peut être supérieure à %max.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '399',
  'translation' => '%name : valeur illégale.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '400',
  'translation' => 'non mis en forme',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '401',
  'translation' => 'Champ texte',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '402',
  'translation' => 'Seuls les nombres et les décimaux sont autorisés dans %field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '403',
  'translation' => 'Seuls les nombres sont autorisés dans %field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '404',
  'translation' => 'Seuls les nombres et le caractère décimal (%decimal) sont autorisés dans %field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '405',
  'translation' => 'nombre',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '406',
  'translation' => 'Nombre',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '407',
  'translation' => 'Définit des types de champs numériques.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '408',
  'translation' => "Créez une liste d'options en tant que liste dans la <strong>Liste des valeurs autorisées</strong>, ou en tant que tableau en code PHP. Ces valeurs seront les mêmes pour le champ %field au sein de tous les types de contenu.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '409',
  'translation' => "Pour un widget 'case à cocher oui/non', définissez la valeur 'non' en premier, puis la valeur 'oui', dans la section <strong>Valeurs autorisées</strong>. Notez que la case à cocher sera étiquetée avec l'étiquette de la valeur du 'oui'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '410',
  'translation' => "Le widget 'cases à cocher/boutons radio' affichera des cases à cocher si l'option valeurs multiples est sélectionnées pour ce champ, autrement, des boutons radio seront affichés.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '411',
  'translation' => "Vous devez préciser les 'valeurs autorisées' pour ce champ.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '412',
  'translation' => 'Case à cocher on/off unique',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '413',
  'translation' => '%name : ce champ ne peut contenir plus de @count valeurs.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '414',
  'translation' => 'N/A',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '415',
  'translation' => '- Aucun -',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '416',
  'translation' => 'optionwidgets',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '417',
  'translation' => 'Option Widgets',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '418',
  'translation' => 'Définit des widgets de liste déroulante, case à cocher et bouton radio pour des champs texte et numériques.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '419',
  'translation' => 'Enregistre le texte dans la base de données.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '420',
  'translation' => 'Texte simple',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '421',
  'translation' => "Texte filtré (l'utilisateur choisit le format d'entrée)",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '422',
  'translation' => 'Traitement du texte',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '423',
  'translation' => 'Taille maximale',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '424',
  'translation' => 'La taille maximale des champs, en caractères. Laisser vide pour ne pas limiter la taille.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '425',
  'translation' => '%name : la valeur ne doit pas dépasser %max caractères.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '426',
  'translation' => 'Par défaut',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '427',
  'translation' => 'Coupé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '428',
  'translation' => 'Zone de texte (plusieurs lignes)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '429',
  'translation' => 'Taille du champ texte',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '430',
  'translation' => 'Rangées',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '431',
  'translation' => 'texte',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '432',
  'translation' => 'Définit les types de champs en texte simple.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '433',
  'translation' => 'Charge un utilisateur référencé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '434',
  'translation' => 'Contenu contenant le champ userrefernece',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '435',
  'translation' => 'Utilisateur référencé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '436',
  'translation' => 'Noter que si le champ possède des valeurs multiples, seul le premier utilisateur sera chargé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '437',
  'translation' => "Il n'y a aucun champ userreference défini",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '438',
  'translation' => 'User reference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '439',
  'translation' => "Stocke l'ID d'un utilisateur lié sous forme d'entier",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '440',
  'translation' => 'Rôles utilisateur pouvant être référencés',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '441',
  'translation' => 'Statuts utilisateur pouvant être référencés',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '442',
  'translation' => 'Actif',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '443',
  'translation' => 'Bloqué',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '444',
  'translation' => 'Avancé - Utilisateurs pouvant être référencés (Vue)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '445',
  'translation' => 'Vue utilisée pour sélectionner les utilisateurs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '446',
  'translation' => '<p>Choisissez la vue du "module Views" qui sélectionne les utilisateurs pouvant être référencés.<br />Note :</p>',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '447',
  'translation' => "<ul><li>Seules les vues qui possèdent des champs fonctionneront à cet effet.</li><li>Ceci annulera les paramètres \"Rôles Référençables\" et \"Statut Référençable\" ci-dessus. Utilisez la section \"filtres\" de la vue à la place.</li><li>Utilisez la section \"champs\" de la vue pour afficher des informations supplémentaires à propos des utilisateurs candidats sur le formulaire de création/édition.</li><li>Utilisez la section \"critère de tri\" de la vue pour déterminer l'ordre dans lequel les utilisateurs candidats seront affichés.</li></ul>",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '448',
  'translation' => "<p>La liste d'utilisateurs pouvant être référencés peut s'appueyr sur une vue du \"module Views\", mais aucune vue appropriée n'a été trouvée. <br />Note :</p>",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '449',
  'translation' => '%name : utilisateur invalide.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '450',
  'translation' => "Séléctionnez la méthode utilisée pour collecter les suggestions de l'autocomplétion. Notez que <em>Contient</em> peut engendrer des problèmes de performances sur des sites avec des milliers d'utilisateurs.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '451',
  'translation' => 'Lien retour',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '452',
  'translation' => "Si cette option est sélectionnée, un lien réciproque vers le nœud référençant sera affiché dans l'enregistrement utilisateur référencé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '453',
  'translation' => "%name : nous n'avons pas trouvé d'utilisateur valide pour ce nom.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '454',
  'translation' => 'Contenu lié',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '455',
  'translation' => 'Autocomplétion Userreference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '456',
  'translation' => 'userreference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '457',
  'translation' => 'User Reference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '458',
  'translation' => 'Définit un type de champ pour référencer un utilisateur depuis un noeud.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '459',
  'translation' => 'Poids',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '460',
  'translation' => 'Ajouter',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '461',
  'translation' => 'Nouveau champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '462',
  'translation' => 'Champ existant',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '463',
  'translation' => 'Nouveau groupe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '464',
  'translation' => "Ajouter des champs et des groupes au type de contenu, et les paramétrer pour l'affichage du contenu et les formulaires de saisie.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '465',
  'translation' => 'Vous pouvez ajouter un champ à un groupe en le faisant glisser ci-dessous et à la droite du groupe.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '466',
  'translation' => "Note : l'installation du module <a href=\"!adv_help\">Aide avancée (Advanced help)</a> vous permettra d'accéder à plus d'aide, et de meilleure qualité.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '467',
  'translation' => "Utiliser la case à cocher 'Exclure' pour exclure un élément de la valeur de !content transmis au gabarit du node.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '468',
  'translation' => 'Supprimer cet élément',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '469',
  'translation' => 'Ajouter un champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '470',
  'translation' => "Valeur illégale pour le champ '%name'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '471',
  'translation' => "La longueur de '%label' dépasse %max caractères.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '472',
  'translation' => "Le champ 'Rangées' doit être un entier positif.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '473',
  'translation' => "Les valeurs que ce champ peut contenir. Saisissez une valeur par ligne, au format clé|libellé. La clé est la valeur qui sera enregistrée dans la base de données et elle doit correspondre au type définit pour le champ dans la base, '%type'. Le libellé est optionnel et, si aucune valeur n'est spécifiée, la clé sera utilisée comme libellé.<br />Balises HTML autorisées : @tags",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '474',
  'translation' => 'ajouter un champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '475',
  'translation' => "Il n'y a aucun champ configuré pour ce type de contenu. Vous pouvez néanmoins dès maintenant !link.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '476',
  'translation' => 'ajouter un nouveau champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '477',
  'translation' => "Pour changer l'ordre d'un champ, utilisez la poignée qui figure sous la colonne Étiquette et faites glisser le champ jusqu'à l'emplacement désiré. Pour manipuler la poignée (l'icône en forme de croix), cliquez sur l'icône et maintenez enfoncé le bouton de la souris. N'oubliez pas que vos modifications ne seront prises en compte que lorsque vous aurez cliqué sur le bouton <em>Enregistrer</em> qui figure en base de page.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '478',
  'translation' => "Aucun module de champs n'est activé. Vous devez en <a href=\"!modules_url\">activer un</a>, par exemple le module Text, avant de pouvoir ajouter des champs.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '479',
  'translation' => 'Ajouter un champ existant',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '480',
  'translation' => 'Créer un nouveau champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '481',
  'translation' => 'Nom du champ, lisible par une machine.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '482',
  'translation' => ' Ce nom ne peut être modifié.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '483',
  'translation' => " Ce nom ne pourra pas être modifié par la suite ! Le nom sera préfixé par 'field_' et peut inclure des lettres minuscules non accentués, des nombres et des caractères \"espace souligné\". La longueur du nom, y compris le préfixe, est limitée à un total de 32 caractères.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '484',
  'translation' => 'Type de données que vous souhaitez enregistrer, par le biais de ce champ, dans la base de données.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '485',
  'translation' => "Le nom de champ '%field_name' est invalide. Le nom ne doit comporter que des lettres minuscules non accentuées, des nombres ou des espaces soulignés.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '486',
  'translation' => "Le nom de champ '%field_name' est trop long. La longueur du nom est limitée à 32 caractères, y compris le préfixe 'field_'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '487',
  'translation' => "Le nom de champ '%field_name' existe déjà.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '488',
  'translation' => "Le nom 'field_instance' est un nom réservé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '489',
  'translation' => "Le champ '%label' a été créé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '490',
  'translation' => "Mettre à jour le champ '%label'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '491',
  'translation' => "Un problème est survenu à la mise à jour du champ '%label'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '492',
  'translation' => "Réservé à une utilisation avancée : code PHP renvoyant la valeur par défaut du champ. Ne doit pas inclure les délimiteurs &lt;?php ?&gt;. Si ce champ est renseigné, la valeur renvoyée par le code supplante toute valeur indiquée ci-desus. Format attendu : <pre>!sample</pre> Vous pouvez utiliser l'onglet 'devel load' du module !link_devel sur un nœud de type '%type' pour mieux comprendre le format attendu.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '493',
  'translation' => "Choisissez un nombre de valeurs pour ce champ, ou 'Illimité' pour proposer un bouton 'Ajouter' aux utilisateurs, de sorte qu'ils peuvent insérer autant de valeurs qu'ils le souhaitent.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '494',
  'translation' => 'Le code PHP de valeur par défaut a créé @value, qui est invalide.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '495',
  'translation' => 'Lien HTML mis en forme vers le nœud',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '496',
  'translation' => "La valeur de '%name 'ne peut être plus petite que %min.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '497',
  'translation' => "La valeur de '%name' ne peut pas être plus grande que %max.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '498',
  'translation' => "Seuls des nombres et des décimaux sont autorisés dans '%field'. La valeur saisie, '%start', a été modifié en '%value'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '499',
  'translation' => "Seuls des nombres sont autorisés dans '%field'. La valeur saisie, '%start', a été modifié en '%value'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '500',
  'translation' => "Seuls des nombres et le marqueur décimal (%decimal) sont autorisés dans '%field'. La valeur saisie, '%start', a été modifié en '%value'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->values(array(
  'lid' => '501',
  'translation' => "Créez une liste d'options en tant que liste dans les <strong>Valeurs permises</strong> ou en tant que tableau dans le code PHP. Ces valeurs seront identiques pour '%field' dans tous les types de contenus.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
))
->execute();

$connection->schema()->createTable('menu_custom', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'menu_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_custom')
->fields(array(
  'menu_name',
  'title',
  'description',
))
->values(array(
  'menu_name' => 'navigation',
  'title' => 'Navigation',
  'description' => 'The navigation menu is provided by Drupal and is the main interactive menu for any site. It is usually the only menu that contains personalized links for authenticated users, and is often not even visible to anonymous users.',
))
->values(array(
  'menu_name' => 'primary-links',
  'title' => 'Primary links',
  'description' => 'Primary links are often used at the theme layer to show the major sections of a site. A typical representation for primary links would be tabs along the top.',
))
->values(array(
  'menu_name' => 'secondary-links',
  'title' => 'Secondary links',
  'description' => 'Secondary links are often used for pages like legal notices, contact details, and other secondary navigation items that play a lesser role than primary links',
))
->execute();

$connection->schema()->createTable('menu_links', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'mlid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'plid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'link_path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'router_path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'link_title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'options' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => 'system',
    ),
    'hidden' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'external' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'has_children' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'expanded' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'depth' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'customized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'p1' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p2' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p3' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p4' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p5' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p6' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p7' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p8' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p9' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'updated' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'mlid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_links')
->fields(array(
  'menu_name',
  'mlid',
  'plid',
  'link_path',
  'router_path',
  'link_title',
  'options',
  'module',
  'hidden',
  'external',
  'has_children',
  'expanded',
  'weight',
  'depth',
  'customized',
  'p1',
  'p2',
  'p3',
  'p4',
  'p5',
  'p6',
  'p7',
  'p8',
  'p9',
  'updated',
))
->values(array(
  'menu_name' => 'book-toc-1',
  'mlid' => '1',
  'plid' => '0',
  'link_path' => 'node/4',
  'router_path' => 'node/%',
  'link_title' => 'Test top book title',
  'options' => 'a:0:{}',
  'module' => 'book',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '1',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'book-toc-1',
  'mlid' => '2',
  'plid' => '1',
  'link_path' => 'node/5',
  'router_path' => 'node/%',
  'link_title' => 'Test book title child 1',
  'options' => 'a:0:{}',
  'module' => 'book',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '2',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'book-toc-1',
  'mlid' => '3',
  'plid' => '2',
  'link_path' => 'node/6',
  'router_path' => 'node/%',
  'link_title' => 'Test book title child 1.1',
  'options' => 'a:0:{}',
  'module' => 'book',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '2',
  'p3' => '3',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'book-toc-1',
  'mlid' => '4',
  'plid' => '2',
  'link_path' => 'node/7',
  'router_path' => 'node/%',
  'link_title' => 'Test book title child 1.2',
  'options' => 'a:0:{}',
  'module' => 'book',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '2',
  'p3' => '4',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'book-toc-2',
  'mlid' => '5',
  'plid' => '0',
  'link_path' => 'node/8',
  'router_path' => 'node/%',
  'link_title' => 'Test top book 2 title',
  'options' => 'a:0:{}',
  'module' => 'book',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '5',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'secondary-links',
  'mlid' => '138',
  'plid' => '139',
  'link_path' => 'user/login',
  'router_path' => 'user/login',
  'link_title' => 'Test 1',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:16:"Test menu link 1";}}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-50',
  'depth' => '2',
  'customized' => '1',
  'p1' => '139',
  'p2' => '138',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'secondary-links',
  'mlid' => '139',
  'plid' => '0',
  'link_path' => 'admin',
  'router_path' => 'admin',
  'link_title' => 'Test 2',
  'options' => 'a:2:{s:5:"query";s:7:"foo=bar";s:10:"attributes";a:1:{s:5:"title";s:16:"Test menu link 2";}}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '1',
  'weight' => '-49',
  'depth' => '1',
  'customized' => '1',
  'p1' => '139',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'secondary-links',
  'mlid' => '140',
  'plid' => '0',
  'link_path' => 'https://www.drupal.org',
  'router_path' => '',
  'link_title' => 'Drupal.org',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:0:"";}}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '1',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-50',
  'depth' => '1',
  'customized' => '1',
  'p1' => '140',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '141',
  'plid' => '0',
  'link_path' => 'node',
  'router_path' => 'node',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '141',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '142',
  'plid' => '0',
  'link_path' => 'rss.xml',
  'router_path' => 'rss.xml',
  'link_title' => 'RSS feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '142',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '143',
  'plid' => '0',
  'link_path' => 'batch',
  'router_path' => 'batch',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '143',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '144',
  'plid' => '0',
  'link_path' => 'admin',
  'router_path' => 'admin',
  'link_title' => 'Administer',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '9',
  'depth' => '1',
  'customized' => '0',
  'p1' => '144',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '145',
  'plid' => '0',
  'link_path' => 'contact',
  'router_path' => 'contact',
  'link_title' => 'Contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '145',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '147',
  'plid' => '0',
  'link_path' => 'logout',
  'router_path' => 'logout',
  'link_title' => 'Log out',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '147',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '148',
  'plid' => '0',
  'link_path' => 'user',
  'router_path' => 'user',
  'link_title' => 'User account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '148',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '149',
  'plid' => '0',
  'link_path' => 'profile',
  'router_path' => 'profile',
  'link_title' => 'User list',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '149',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '150',
  'plid' => '0',
  'link_path' => 'node/%',
  'router_path' => 'node/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '150',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '151',
  'plid' => '0',
  'link_path' => 'content/js_add_more',
  'router_path' => 'content/js_add_more',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '151',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '152',
  'plid' => '0',
  'link_path' => 'upload/js',
  'router_path' => 'upload/js',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '152',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '153',
  'plid' => '0',
  'link_path' => 'taxonomy/autocomplete',
  'router_path' => 'taxonomy/autocomplete',
  'link_title' => 'Autocomplete taxonomy',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '153',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '155',
  'plid' => '144',
  'link_path' => 'admin/compact',
  'router_path' => 'admin/compact',
  'link_title' => 'Compact mode',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '155',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '156',
  'plid' => '0',
  'link_path' => 'filter/tips',
  'router_path' => 'filter/tips',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '156',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '157',
  'plid' => '144',
  'link_path' => 'admin/content',
  'router_path' => 'admin/content',
  'link_title' => 'Content management',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:27:\"Manage your site's content.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '158',
  'plid' => '0',
  'link_path' => 'node/add',
  'router_path' => 'node/add',
  'link_title' => 'Create content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '1',
  'customized' => '0',
  'p1' => '158',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '159',
  'plid' => '0',
  'link_path' => 'comment/delete',
  'router_path' => 'comment/delete',
  'link_title' => 'Delete comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '159',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '160',
  'plid' => '0',
  'link_path' => 'comment/edit',
  'router_path' => 'comment/edit',
  'link_title' => 'Edit comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '160',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '161',
  'plid' => '0',
  'link_path' => 'system/files',
  'router_path' => 'system/files',
  'link_title' => 'File download',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '161',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '163',
  'plid' => '149',
  'link_path' => 'profile/autocomplete',
  'router_path' => 'profile/autocomplete',
  'link_title' => 'Profile autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '149',
  'p2' => '163',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '165',
  'plid' => '144',
  'link_path' => 'admin/reports',
  'router_path' => 'admin/reports',
  'link_title' => 'Reports',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:59:"View reports from system logs and other status information.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '166',
  'plid' => '144',
  'link_path' => 'admin/build',
  'router_path' => 'admin/build',
  'link_title' => 'Site building',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Control how your site looks and feels.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '167',
  'plid' => '144',
  'link_path' => 'admin/settings',
  'router_path' => 'admin/settings',
  'link_title' => 'Site configuration',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:40:"Adjust basic site configuration options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '169',
  'plid' => '0',
  'link_path' => 'user/autocomplete',
  'router_path' => 'user/autocomplete',
  'link_title' => 'User autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '169',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '170',
  'plid' => '144',
  'link_path' => 'admin/user',
  'router_path' => 'admin/user',
  'link_title' => 'User management',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:61:\"Manage your site's users, groups and access to site features.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '171',
  'plid' => '0',
  'link_path' => 'user/timezone',
  'router_path' => 'user/timezone',
  'link_title' => 'User timezone',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '171',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '172',
  'plid' => '0',
  'link_path' => 'user/%',
  'router_path' => 'user/%',
  'link_title' => 'My account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '172',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '175',
  'plid' => '170',
  'link_path' => 'admin/user/rules',
  'router_path' => 'admin/user/rules',
  'link_title' => 'Access rules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:80:"List and create rules to disallow usernames, e-mail addresses, and IP addresses.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '175',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '176',
  'plid' => '167',
  'link_path' => 'admin/settings/actions',
  'router_path' => 'admin/settings/actions',
  'link_title' => 'Actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '177',
  'plid' => '167',
  'link_path' => 'admin/settings/admin',
  'router_path' => 'admin/settings/admin',
  'link_title' => 'Administration theme',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:55:"Settings for how your administrative pages should look.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '177',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '178',
  'plid' => '158',
  'link_path' => 'node/add/article',
  'router_path' => 'node/add/article',
  'link_title' => 'Article',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"An <em>article</em>, content type.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '178',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '179',
  'plid' => '166',
  'link_path' => 'admin/build/block',
  'router_path' => 'admin/build/block',
  'link_title' => 'Blocks',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:79:\"Configure what block content appears in your site's sidebars and other regions.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '180',
  'plid' => '167',
  'link_path' => 'admin/settings/clean-urls',
  'router_path' => 'admin/settings/clean-urls',
  'link_title' => 'Clean URLs',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Enable or disable clean URLs for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '180',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '181',
  'plid' => '157',
  'link_path' => 'admin/content/comment',
  'router_path' => 'admin/content/comment',
  'link_title' => 'Comments',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:61:"List and edit site comments and the comment moderation queue.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '181',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '182',
  'plid' => '158',
  'link_path' => 'node/add/company',
  'router_path' => 'node/add/company',
  'link_title' => 'Company',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Company node type";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '182',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '183',
  'plid' => '166',
  'link_path' => 'admin/build/contact',
  'router_path' => 'admin/build/contact',
  'link_title' => 'Contact form',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:71:"Create a system contact form and set up categories for the form to use.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '183',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '184',
  'plid' => '157',
  'link_path' => 'admin/content/node',
  'router_path' => 'admin/content/node',
  'link_title' => 'Content',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:43:\"View, edit, and delete your site's content.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '184',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '185',
  'plid' => '157',
  'link_path' => 'admin/content/types',
  'router_path' => 'admin/content/types',
  'link_title' => 'Content types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:82:"Manage posts by content type, including default status, front page promotion, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '185',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '186',
  'plid' => '167',
  'link_path' => 'admin/settings/date-time',
  'router_path' => 'admin/settings/date-time',
  'link_title' => 'Date and time',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:89:\"Settings for how Drupal displays date and time, as well as the system's default timezone.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '187',
  'plid' => '0',
  'link_path' => 'node/%/delete',
  'router_path' => 'node/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '1',
  'customized' => '0',
  'p1' => '187',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '188',
  'plid' => '172',
  'link_path' => 'user/%/delete',
  'router_path' => 'user/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '172',
  'p2' => '188',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '189',
  'plid' => '158',
  'link_path' => 'node/add/employee',
  'router_path' => 'node/add/employee',
  'link_title' => 'Employee',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Employee node type";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '189',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '190',
  'plid' => '167',
  'link_path' => 'admin/settings/error-reporting',
  'router_path' => 'admin/settings/error-reporting',
  'link_title' => 'Error reporting',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:93:"Control how Drupal deals with errors including 403/404 errors as well as PHP error reporting.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '190',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '192',
  'plid' => '167',
  'link_path' => 'admin/settings/file-system',
  'router_path' => 'admin/settings/file-system',
  'link_title' => 'File system',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:68:"Tell Drupal where to store uploaded files and how they are accessed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '192',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '193',
  'plid' => '167',
  'link_path' => 'admin/settings/uploads',
  'router_path' => 'admin/settings/uploads',
  'link_title' => 'File uploads',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Control how files may be attached to content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '193',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '194',
  'plid' => '167',
  'link_path' => 'admin/settings/image-toolkit',
  'router_path' => 'admin/settings/image-toolkit',
  'link_title' => 'Image toolkit',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '194',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '195',
  'plid' => '167',
  'link_path' => 'admin/settings/filters',
  'router_path' => 'admin/settings/filters',
  'link_title' => 'Input formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:127:"Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '195',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '196',
  'plid' => '167',
  'link_path' => 'admin/settings/logging',
  'router_path' => 'admin/settings/logging',
  'link_title' => 'Logging and alerts',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:156:\"Settings for logging and alerts modules. Various modules can route Drupal's system events to different destination, such as syslog, database, email, ...etc.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '196',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '197',
  'plid' => '166',
  'link_path' => 'admin/build/menu',
  'router_path' => 'admin/build/menu',
  'link_title' => 'Menus',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:116:\"Control your site's navigation menu, primary links and secondary links, as well as rename and reorganize menu items.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '198',
  'plid' => '158',
  'link_path' => 'node/add/test-event',
  'router_path' => 'node/add/test-event',
  'link_title' => 'Migrate test event',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:27:"test event description here";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '198',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '199',
  'plid' => '158',
  'link_path' => 'node/add/test-page',
  'router_path' => 'node/add/test-page',
  'link_title' => 'Migrate test page',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '199',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '200',
  'plid' => '158',
  'link_path' => 'node/add/test-planet',
  'router_path' => 'node/add/test-planet',
  'link_title' => 'Migrate test planet',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '200',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '201',
  'plid' => '158',
  'link_path' => 'node/add/test-story',
  'router_path' => 'node/add/test-story',
  'link_title' => 'Migrate test story',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '201',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '202',
  'plid' => '166',
  'link_path' => 'admin/build/modules',
  'router_path' => 'admin/build/modules',
  'link_title' => 'Modules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Enable or disable add-on modules for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '202',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '203',
  'plid' => '167',
  'link_path' => 'admin/settings/performance',
  'router_path' => 'admin/settings/performance',
  'link_title' => 'Performance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '203',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '204',
  'plid' => '170',
  'link_path' => 'admin/user/permissions',
  'router_path' => 'admin/user/permissions',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '204',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '205',
  'plid' => '157',
  'link_path' => 'admin/content/node-settings',
  'router_path' => 'admin/content/node-settings',
  'link_title' => 'Post settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:126:"Control posting behavior, such as teaser length, requiring previews before posting, and the number of posts on the front page.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '205',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '206',
  'plid' => '170',
  'link_path' => 'admin/user/profile',
  'router_path' => 'admin/user/profile',
  'link_title' => 'Profiles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:42:"Create customizable fields for your users.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '206',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '207',
  'plid' => '157',
  'link_path' => 'admin/content/rss-publishing',
  'router_path' => 'admin/content/rss-publishing',
  'link_title' => 'RSS publishing',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:92:"Configure the number of items per feed and whether feeds should be titles/teasers/full-text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '207',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '208',
  'plid' => '0',
  'link_path' => 'comment/reply/%',
  'router_path' => 'comment/reply/%',
  'link_title' => 'Reply to comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '208',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '209',
  'plid' => '170',
  'link_path' => 'admin/user/roles',
  'router_path' => 'admin/user/roles',
  'link_title' => 'Roles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"List, edit, or add user roles.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '209',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '210',
  'plid' => '167',
  'link_path' => 'admin/settings/site-information',
  'router_path' => 'admin/settings/site-information',
  'link_title' => 'Site information',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:107:"Change basic site information, such as the site name, slogan, e-mail address, mission, front page and more.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '210',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '211',
  'plid' => '167',
  'link_path' => 'admin/settings/site-maintenance',
  'router_path' => 'admin/settings/site-maintenance',
  'link_title' => 'Site maintenance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:63:"Take the site off-line for maintenance or bring it back online.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '211',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '212',
  'plid' => '158',
  'link_path' => 'node/add/sponsor',
  'router_path' => 'node/add/sponsor',
  'link_title' => 'Sponsor',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Sponsor node type";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '212',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '213',
  'plid' => '165',
  'link_path' => 'admin/reports/status',
  'router_path' => 'admin/reports/status',
  'link_title' => 'Status report',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:74:\"Get a status report about your site's operation and any detected problems.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '214',
  'plid' => '157',
  'link_path' => 'admin/content/taxonomy',
  'router_path' => 'admin/content/taxonomy',
  'link_title' => 'Taxonomy',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:67:"Manage tagging, categorization, and classification of your content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '215',
  'plid' => '0',
  'link_path' => 'taxonomy/term/%',
  'router_path' => 'taxonomy/term/%',
  'link_title' => 'Taxonomy term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '215',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '216',
  'plid' => '166',
  'link_path' => 'admin/build/themes',
  'router_path' => 'admin/build/themes',
  'link_title' => 'Themes',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:57:"Change which theme your site uses or allows users to set.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '216',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '217',
  'plid' => '170',
  'link_path' => 'admin/user/settings',
  'router_path' => 'admin/user/settings',
  'link_title' => 'User settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Configure default behavior of users, including registration requirements, e-mails, and user pictures.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '217',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '218',
  'plid' => '170',
  'link_path' => 'admin/user/user',
  'router_path' => 'admin/user/user',
  'link_title' => 'Users',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:26:"List, add, and edit users.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '218',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '219',
  'plid' => '195',
  'link_path' => 'admin/settings/filters/%',
  'router_path' => 'admin/settings/filters/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '195',
  'p4' => '219',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '220',
  'plid' => '206',
  'link_path' => 'admin/user/profile/add',
  'router_path' => 'admin/user/profile/add',
  'link_title' => 'Add field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '206',
  'p4' => '220',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '221',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/article',
  'router_path' => 'admin/content/node-type/article',
  'link_title' => 'Article',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '221',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '222',
  'plid' => '180',
  'link_path' => 'admin/settings/clean-urls/check',
  'router_path' => 'admin/settings/clean-urls/check',
  'link_title' => 'Clean URL check',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '180',
  'p4' => '222',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '223',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/company',
  'router_path' => 'admin/content/node-type/company',
  'link_title' => 'Company',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '223',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '224',
  'plid' => '176',
  'link_path' => 'admin/settings/actions/configure',
  'router_path' => 'admin/settings/actions/configure',
  'link_title' => 'Configure an advanced action',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '224',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '225',
  'plid' => '179',
  'link_path' => 'admin/build/block/configure',
  'router_path' => 'admin/build/block/configure',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '225',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '226',
  'plid' => '166',
  'link_path' => 'admin/build/menu-customize/%',
  'router_path' => 'admin/build/menu-customize/%',
  'link_title' => 'Customize menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '226',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '227',
  'plid' => '186',
  'link_path' => 'admin/settings/date-time/lookup',
  'router_path' => 'admin/settings/date-time/lookup',
  'link_title' => 'Date and time lookup',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '227',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '228',
  'plid' => '179',
  'link_path' => 'admin/build/block/delete',
  'router_path' => 'admin/build/block/delete',
  'link_title' => 'Delete block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '228',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '229',
  'plid' => '206',
  'link_path' => 'admin/user/profile/delete',
  'router_path' => 'admin/user/profile/delete',
  'link_title' => 'Delete field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '206',
  'p4' => '229',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '230',
  'plid' => '195',
  'link_path' => 'admin/settings/filters/delete',
  'router_path' => 'admin/settings/filters/delete',
  'link_title' => 'Delete input format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '195',
  'p4' => '230',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '231',
  'plid' => '175',
  'link_path' => 'admin/user/rules/delete',
  'router_path' => 'admin/user/rules/delete',
  'link_title' => 'Delete rule',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '175',
  'p4' => '231',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '232',
  'plid' => '206',
  'link_path' => 'admin/user/profile/edit',
  'router_path' => 'admin/user/profile/edit',
  'link_title' => 'Edit field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '206',
  'p4' => '232',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '233',
  'plid' => '209',
  'link_path' => 'admin/user/roles/edit',
  'router_path' => 'admin/user/roles/edit',
  'link_title' => 'Edit role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '209',
  'p4' => '233',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '234',
  'plid' => '175',
  'link_path' => 'admin/user/rules/edit',
  'router_path' => 'admin/user/rules/edit',
  'link_title' => 'Edit rule',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '175',
  'p4' => '234',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '235',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/employee',
  'router_path' => 'admin/content/node-type/employee',
  'link_title' => 'Employee',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '235',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '236',
  'plid' => '214',
  'link_path' => 'admin/content/taxonomy/%',
  'router_path' => 'admin/content/taxonomy/%',
  'link_title' => 'List terms',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '236',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '237',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/test-event',
  'router_path' => 'admin/content/node-type/test-event',
  'link_title' => 'Migrate test event',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '237',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '238',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/test-page',
  'router_path' => 'admin/content/node-type/test-page',
  'link_title' => 'Migrate test page',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '238',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '239',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/test-planet',
  'router_path' => 'admin/content/node-type/test-planet',
  'link_title' => 'Migrate test planet',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '239',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '240',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/test-story',
  'router_path' => 'admin/content/node-type/test-story',
  'link_title' => 'Migrate test story',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '240',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '241',
  'plid' => '213',
  'link_path' => 'admin/reports/status/php',
  'router_path' => 'admin/reports/status/php',
  'link_title' => 'PHP',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '241',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '242',
  'plid' => '206',
  'link_path' => 'admin/user/profile/autocomplete',
  'router_path' => 'admin/user/profile/autocomplete',
  'link_title' => 'Profile category autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '206',
  'p4' => '242',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '243',
  'plid' => '205',
  'link_path' => 'admin/content/node-settings/rebuild',
  'router_path' => 'admin/content/node-settings/rebuild',
  'link_title' => 'Rebuild permissions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '205',
  'p4' => '243',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '244',
  'plid' => '176',
  'link_path' => 'admin/settings/actions/orphan',
  'router_path' => 'admin/settings/actions/orphan',
  'link_title' => 'Remove orphans',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '244',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '245',
  'plid' => '213',
  'link_path' => 'admin/reports/status/run-cron',
  'router_path' => 'admin/reports/status/run-cron',
  'link_title' => 'Run cron',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '245',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '246',
  'plid' => '213',
  'link_path' => 'admin/reports/status/sql',
  'router_path' => 'admin/reports/status/sql',
  'link_title' => 'SQL',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '246',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '247',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/sponsor',
  'router_path' => 'admin/content/node-type/sponsor',
  'link_title' => 'Sponsor',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '247',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '248',
  'plid' => '186',
  'link_path' => 'admin/settings/date-time/formats/lookup',
  'router_path' => 'admin/settings/date-time/formats/lookup',
  'link_title' => 'Date and time lookup',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '248',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '249',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/article/delete',
  'router_path' => 'admin/content/node-type/article/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '249',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '250',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/company/delete',
  'router_path' => 'admin/content/node-type/company/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '250',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '251',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/employee/delete',
  'router_path' => 'admin/content/node-type/employee/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '251',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '252',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/sponsor/delete',
  'router_path' => 'admin/content/node-type/sponsor/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '252',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '253',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-event/delete',
  'router_path' => 'admin/content/node-type/test-event/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '253',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '254',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-page/delete',
  'router_path' => 'admin/content/node-type/test-page/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '254',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '255',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-planet/delete',
  'router_path' => 'admin/content/node-type/test-planet/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '255',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '256',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-story/delete',
  'router_path' => 'admin/content/node-type/test-story/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '256',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '257',
  'plid' => '176',
  'link_path' => 'admin/settings/actions/delete/%',
  'router_path' => 'admin/settings/actions/delete/%',
  'link_title' => 'Delete action',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Delete an action.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '257',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '258',
  'plid' => '183',
  'link_path' => 'admin/build/contact/delete/%',
  'router_path' => 'admin/build/contact/delete/%',
  'link_title' => 'Delete contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '183',
  'p4' => '258',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '259',
  'plid' => '186',
  'link_path' => 'admin/settings/date-time/delete/%',
  'router_path' => 'admin/settings/date-time/delete/%',
  'link_title' => 'Delete date format type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:52:"Allow users to delete a configured date format type.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '259',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '260',
  'plid' => '0',
  'link_path' => 'admin/build/menu-customize/%/delete',
  'router_path' => 'admin/build/menu-customize/%/delete',
  'link_title' => 'Delete menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '260',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '261',
  'plid' => '183',
  'link_path' => 'admin/build/contact/edit/%',
  'router_path' => 'admin/build/contact/edit/%',
  'link_title' => 'Edit contact category',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '183',
  'p4' => '261',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '262',
  'plid' => '214',
  'link_path' => 'admin/content/taxonomy/edit/term',
  'router_path' => 'admin/content/taxonomy/edit/term',
  'link_title' => 'Edit term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '262',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '263',
  'plid' => '179',
  'link_path' => 'admin/build/block/list/js',
  'router_path' => 'admin/build/block/list/js',
  'link_title' => 'JavaScript List Form',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '263',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '264',
  'plid' => '202',
  'link_path' => 'admin/build/modules/list/confirm',
  'router_path' => 'admin/build/modules/list/confirm',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '202',
  'p4' => '264',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '266',
  'plid' => '0',
  'link_path' => 'user/reset/%/%/%',
  'router_path' => 'user/reset/%/%/%',
  'link_title' => 'Reset password',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '266',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '267',
  'plid' => '202',
  'link_path' => 'admin/build/modules/uninstall/confirm',
  'router_path' => 'admin/build/modules/uninstall/confirm',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '202',
  'p4' => '267',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '269',
  'plid' => '0',
  'link_path' => 'node/%/revisions/%/delete',
  'router_path' => 'node/%/revisions/%/delete',
  'link_title' => 'Delete earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '269',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '270',
  'plid' => '0',
  'link_path' => 'node/%/revisions/%/revert',
  'router_path' => 'node/%/revisions/%/revert',
  'link_title' => 'Revert to earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '270',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '271',
  'plid' => '0',
  'link_path' => 'node/%/revisions/%/view',
  'router_path' => 'node/%/revisions/%/view',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '271',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '272',
  'plid' => '186',
  'link_path' => 'admin/settings/date-time/formats/delete/%',
  'router_path' => 'admin/settings/date-time/formats/delete/%',
  'link_title' => 'Delete date format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Allow users to delete a configured date format.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '272',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '273',
  'plid' => '197',
  'link_path' => 'admin/build/menu/item/%/delete',
  'router_path' => 'admin/build/menu/item/%/delete',
  'link_title' => 'Delete menu item',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '273',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '276',
  'plid' => '197',
  'link_path' => 'admin/build/menu/item/%/edit',
  'router_path' => 'admin/build/menu/item/%/edit',
  'link_title' => 'Edit menu item',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '276',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '277',
  'plid' => '214',
  'link_path' => 'admin/content/taxonomy/edit/vocabulary/%',
  'router_path' => 'admin/content/taxonomy/edit/vocabulary/%',
  'link_title' => 'Edit vocabulary',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '277',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '278',
  'plid' => '197',
  'link_path' => 'admin/build/menu/item/%/reset',
  'router_path' => 'admin/build/menu/item/%/reset',
  'link_title' => 'Reset menu item',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '278',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '299',
  'plid' => '0',
  'link_path' => 'event',
  'router_path' => 'event',
  'link_title' => 'Events',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '299',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '300',
  'plid' => '299',
  'link_path' => 'event/dst',
  'router_path' => 'event/dst',
  'link_title' => 'Event dst view',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '299',
  'p2' => '300',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '301',
  'plid' => '299',
  'link_path' => 'event/ical',
  'router_path' => 'event/ical',
  'link_title' => 'Event ical feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '299',
  'p2' => '301',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '302',
  'plid' => '299',
  'link_path' => 'event/feed',
  'router_path' => 'event/feed',
  'link_title' => 'Event rss feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '299',
  'p2' => '302',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '303',
  'plid' => '299',
  'link_path' => 'event/type',
  'router_path' => 'event/type',
  'link_title' => 'Filter by content type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '299',
  'p2' => '303',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '304',
  'plid' => '299',
  'link_path' => 'event/term',
  'router_path' => 'event/term',
  'link_title' => 'Filter by taxonomy',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '299',
  'p2' => '304',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '305',
  'plid' => '0',
  'link_path' => 'node/%/ical',
  'router_path' => 'node/%/ical',
  'link_title' => 'Event ical',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '305',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '306',
  'plid' => '167',
  'link_path' => 'admin/settings/event',
  'router_path' => 'admin/settings/event',
  'link_title' => 'Events',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:36:"Set up how your site handles events.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '306',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '307',
  'plid' => '306',
  'link_path' => 'admin/settings/event/overview',
  'router_path' => 'admin/settings/event/overview',
  'link_title' => 'Event overview',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:50:"Change how event summary information is displayed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '306',
  'p4' => '307',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '308',
  'plid' => '306',
  'link_path' => 'admin/settings/event/timezone',
  'router_path' => 'admin/settings/event/timezone',
  'link_title' => 'Timezone handling',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:55:"Change how timezone information is saved and displayed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '306',
  'p4' => '308',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '309',
  'plid' => '158',
  'link_path' => 'node/add/story',
  'router_path' => 'node/add/story',
  'link_title' => 'Story',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '309',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '310',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/story',
  'router_path' => 'admin/content/node-type/story',
  'link_title' => 'Story',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '310',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '311',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/delete',
  'router_path' => 'admin/content/node-type/story/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '311',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '328',
  'plid' => '0',
  'link_path' => 'filefield/progress',
  'router_path' => 'filefield/progress',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '328',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '329',
  'plid' => '0',
  'link_path' => 'filefield/ahah/%/%/%',
  'router_path' => 'filefield/ahah/%/%/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '329',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '333',
  'plid' => '167',
  'link_path' => 'admin/settings/email',
  'router_path' => 'admin/settings/email',
  'link_title' => 'CCK Email Contact Form Settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:57:"Administer flood control settings for email contact forms";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '333',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '334',
  'plid' => '0',
  'link_path' => 'email/%/%',
  'router_path' => 'email/%/%',
  'link_title' => 'Email Contact Form',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '334',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '350',
  'plid' => '0',
  'link_path' => 'aggregator',
  'router_path' => 'aggregator',
  'link_title' => 'Feed aggregator',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '1',
  'customized' => '0',
  'p1' => '350',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '351',
  'plid' => '350',
  'link_path' => 'aggregator/categories',
  'router_path' => 'aggregator/categories',
  'link_title' => 'Categories',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '350',
  'p2' => '351',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '352',
  'plid' => '350',
  'link_path' => 'aggregator/opml',
  'router_path' => 'aggregator/opml',
  'link_title' => 'OPML feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '350',
  'p2' => '352',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '353',
  'plid' => '350',
  'link_path' => 'aggregator/rss',
  'router_path' => 'aggregator/rss',
  'link_title' => 'RSS feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '350',
  'p2' => '353',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '354',
  'plid' => '350',
  'link_path' => 'aggregator/sources',
  'router_path' => 'aggregator/sources',
  'link_title' => 'Sources',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '350',
  'p2' => '354',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '355',
  'plid' => '351',
  'link_path' => 'aggregator/categories/%',
  'router_path' => 'aggregator/categories/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '350',
  'p2' => '351',
  'p3' => '355',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '356',
  'plid' => '354',
  'link_path' => 'aggregator/sources/%',
  'router_path' => 'aggregator/sources/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '350',
  'p2' => '354',
  'p3' => '356',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '357',
  'plid' => '157',
  'link_path' => 'admin/content/aggregator',
  'router_path' => 'admin/content/aggregator',
  'link_title' => 'Feed aggregator',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:116:\"Configure which content your site aggregates from other sites, how often it polls them, and how they're categorized.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '357',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '358',
  'plid' => '357',
  'link_path' => 'admin/content/aggregator/remove/%',
  'router_path' => 'admin/content/aggregator/remove/%',
  'link_title' => 'Remove items',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '357',
  'p4' => '358',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '359',
  'plid' => '357',
  'link_path' => 'admin/content/aggregator/update/%',
  'router_path' => 'admin/content/aggregator/update/%',
  'link_title' => 'Update items',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '357',
  'p4' => '359',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '360',
  'plid' => '357',
  'link_path' => 'admin/content/aggregator/edit/category/%',
  'router_path' => 'admin/content/aggregator/edit/category/%',
  'link_title' => 'Edit category',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '357',
  'p4' => '360',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '361',
  'plid' => '357',
  'link_path' => 'admin/content/aggregator/edit/feed/%',
  'router_path' => 'admin/content/aggregator/edit/feed/%',
  'link_title' => 'Edit feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '357',
  'p4' => '361',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '363',
  'plid' => '0',
  'link_path' => 'book',
  'router_path' => 'book',
  'link_title' => 'Books',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '363',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '364',
  'plid' => '363',
  'link_path' => 'book/js/form',
  'router_path' => 'book/js/form',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '363',
  'p2' => '364',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '366',
  'plid' => '157',
  'link_path' => 'admin/content/book',
  'router_path' => 'admin/content/book',
  'link_title' => 'Books',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:33:\"Manage your site's book outlines.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '366',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '367',
  'plid' => '363',
  'link_path' => 'book/export/%/%',
  'router_path' => 'book/export/%/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '363',
  'p2' => '367',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '369',
  'plid' => '366',
  'link_path' => 'admin/content/book/%',
  'router_path' => 'admin/content/book/%',
  'link_title' => 'Re-order book pages and change titles',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '366',
  'p4' => '369',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '370',
  'plid' => '0',
  'link_path' => 'node/%/outline/remove',
  'router_path' => 'node/%/outline/remove',
  'link_title' => 'Remove from outline',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '370',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '372',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '372',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '373',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_date/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_date/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '373',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '374',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_datestamp/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_datestamp/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '374',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '375',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_datetime/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_datetime/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '375',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '376',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_decimal_radio_buttons/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_decimal_radio_buttons/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '376',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '377',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_email/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_email/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '377',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '378',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_exclude_unset/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_exclude_unset/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '378',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '379',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_filefield/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_filefield/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '379',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '380',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_float_single_checkbox/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_float_single_checkbox/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '380',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '381',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_four/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_four/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '381',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '382',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_identical1/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_identical1/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '382',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '383',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_identical2/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_identical2/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '383',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '384',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_imagefield/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_imagefield/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '384',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '385',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_integer_selectlist/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_integer_selectlist/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '385',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '386',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_link/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_link/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '386',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '387',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_phone/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_phone/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '387',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '388',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '388',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '389',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_three/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_three/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '389',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '390',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_two/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_two/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '390',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '391',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-page/fields/field_test/remove',
  'router_path' => 'admin/content/node-type/test-page/fields/field_test/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '391',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '392',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-planet/fields/field_multivalue/remove',
  'router_path' => 'admin/content/node-type/test-planet/fields/field_multivalue/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '392',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'secondary-links',
  'mlid' => '393',
  'plid' => '0',
  'link_path' => 'user/login',
  'router_path' => 'user/login',
  'link_title' => 'Test 3',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-47',
  'depth' => '1',
  'customized' => '1',
  'p1' => '393',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '394',
  'plid' => '166',
  'link_path' => 'admin/build/path',
  'router_path' => 'admin/build/path',
  'link_title' => 'URL aliases',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:46:\"Change your site's URL paths by aliasing them.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '394',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '395',
  'plid' => '394',
  'link_path' => 'admin/build/path/delete',
  'router_path' => 'admin/build/path/delete',
  'link_title' => 'Delete alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '394',
  'p4' => '395',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '396',
  'plid' => '394',
  'link_path' => 'admin/build/path/edit',
  'router_path' => 'admin/build/path/edit',
  'link_title' => 'Edit alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '394',
  'p4' => '396',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '397',
  'plid' => '0',
  'link_path' => 'system/files/imagecache',
  'router_path' => 'system/files/imagecache',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '397',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '398',
  'plid' => '167',
  'link_path' => 'admin/settings/imageapi',
  'router_path' => 'admin/settings/imageapi',
  'link_title' => 'ImageAPI',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:19:"Configure ImageAPI.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '398',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '399',
  'plid' => '167',
  'link_path' => 'admin/settings/language',
  'router_path' => 'admin/settings/language',
  'link_title' => 'Languages',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:55:"Configure languages for content and the user interface.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '399',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '400',
  'plid' => '166',
  'link_path' => 'admin/build/translate',
  'router_path' => 'admin/build/translate',
  'link_title' => 'Translate interface',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:59:"Translate the built in interface and optionally other text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '400',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '401',
  'plid' => '399',
  'link_path' => 'admin/settings/language/delete/%',
  'router_path' => 'admin/settings/language/delete/%',
  'link_title' => 'Confirm',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '399',
  'p4' => '401',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '402',
  'plid' => '0',
  'link_path' => 'core/modules/simpletest/files/imagecache',
  'router_path' => 'core/modules/simpletest/files/imagecache',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '402',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '403',
  'plid' => '400',
  'link_path' => 'admin/build/translate/delete/%',
  'router_path' => 'admin/build/translate/delete/%',
  'link_title' => 'Delete string',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '400',
  'p4' => '403',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '404',
  'plid' => '399',
  'link_path' => 'admin/settings/language/edit/%',
  'router_path' => 'admin/settings/language/edit/%',
  'link_title' => 'Edit language',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '399',
  'p4' => '404',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '405',
  'plid' => '400',
  'link_path' => 'admin/build/translate/edit/%',
  'router_path' => 'admin/build/translate/edit/%',
  'link_title' => 'Edit string',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '400',
  'p4' => '405',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '406',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-planet/fields/field_test_text_single_checkbox/remove',
  'router_path' => 'admin/content/node-type/test-planet/fields/field_test_text_single_checkbox/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '406',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->execute();

$connection->schema()->createTable('menu_router', array(
  'fields' => array(
    'path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'load_functions' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'to_arg_functions' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'access_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'access_arguments' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'page_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'page_arguments' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'fit' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'number_parts' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tab_parent' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'tab_root' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title_arguments' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'block_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'position' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'file' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'path',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_router')
->fields(array(
  'path',
  'load_functions',
  'to_arg_functions',
  'access_callback',
  'access_arguments',
  'page_callback',
  'page_arguments',
  'fit',
  'number_parts',
  'tab_parent',
  'tab_root',
  'title',
  'title_callback',
  'title_arguments',
  'type',
  'block_callback',
  'description',
  'position',
  'weight',
  'file',
))
->values(array(
  'path' => 'admin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_main_admin_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'admin',
  'title' => 'Administer',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '9',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/build',
  'title' => 'Site building',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control how your site looks and feels.',
  'position' => 'right',
  'weight' => '-10',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/block',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block',
  'title' => 'Blocks',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Configure what block content appears in your site's sidebars and other regions.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/block',
  'tab_root' => 'admin/build/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"block_admin_configure";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block/configure',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:16:"block_box_delete";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block/delete',
  'title' => 'Delete block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/block',
  'tab_root' => 'admin/build/block',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/bluemarine',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/bluemarine/bluemarine.info";s:4:"name";s:10:"bluemarine";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:10:"Bluemarine";s:11:"description";s:66:"Table-based multi-column theme with a marine and ash color scheme.";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/bluemarine/script.js";}s:10:"screenshot";s:32:"themes/bluemarine/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:10:"bluemarine";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Bluemarine',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/chameleon',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:31:"themes/chameleon/chameleon.info";s:4:"name";s:9:"chameleon";s:4:"type";s:5:"theme";s:5:"owner";s:32:"themes/chameleon/chameleon.theme";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:12:{s:4:"name";s:9:"Chameleon";s:11:"description";s:42:"Minimalist tabled theme with light colors.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:8:"features";a:4:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:7:"scripts";a:1:{s:9:"script.js";s:26:"themes/chameleon/script.js";}s:10:"screenshot";s:31:"themes/chameleon/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:9:"chameleon";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Chameleon',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:7:"Garland";s:11:"description";s:66:"Tableless, recolorable, multi-column, fluid width theme (default).";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:24:"themes/garland/script.js";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/js',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display_js',
  'page_arguments' => 'a:0:{}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block/list/js',
  'title' => 'JavaScript List Form',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/marvin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:35:"themes/chameleon/marvin/marvin.info";s:4:"name";s:6:"marvin";s:4:"type";s:5:"theme";s:5:"owner";s:0:"";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:6:"Marvin";s:11:"description";s:31:"Boxy tabled theme in all grays.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:10:"base theme";s:9:"chameleon";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/chameleon/marvin/script.js";}s:10:"screenshot";s:38:"themes/chameleon/marvin/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:10:"base_theme";s:9:"chameleon";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"marvin";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Marvin',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/minnelli',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":13:{s:8:"filename";s:37:"themes/garland/minnelli/minnelli.info";s:4:"name";s:8:"minnelli";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:14:{s:4:"name";s:8:"Minnelli";s:11:"description";s:56:"Tableless, recolorable, multi-column, fixed width theme.";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:10:"base theme";s:7:"garland";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/garland/minnelli/script.js";}s:10:"screenshot";s:38:"themes/garland/minnelli/screenshot.png";s:3:"php";s:5:"4.3.5";s:6:"engine";s:11:"phptemplate";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:6:"engine";s:11:"phptemplate";s:10:"base_theme";s:7:"garland";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:8:"minnelli";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Minnelli',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/pushbutton',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/pushbutton/pushbutton.info";s:4:"name";s:10:"pushbutton";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:10:"Pushbutton";s:11:"description";s:52:"Tabled, multi-column theme in blue and orange tones.";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/pushbutton/script.js";}s:10:"screenshot";s:32:"themes/pushbutton/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:10:"pushbutton";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Pushbutton',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/contact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'contact_admin_categories',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/contact',
  'title' => 'Contact form',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Create a system contact form and set up categories for the form to use.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/build/contact/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"contact_admin_edit";i:1;i:3;}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/contact',
  'tab_root' => 'admin/build/contact',
  'title' => 'Add category',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/build/contact/delete/%',
  'load_functions' => 'a:1:{i:4;s:12:"contact_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"contact_admin_delete";i:1;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/contact/delete/%',
  'title' => 'Delete contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/build/contact/edit/%',
  'load_functions' => 'a:1:{i:4;s:12:"contact_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:18:"contact_admin_edit";i:1;i:3;i:2;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/contact/edit/%',
  'title' => 'Edit contact category',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/build/contact/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'contact_admin_categories',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/contact',
  'tab_root' => 'admin/build/contact',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/build/contact/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"contact_admin_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/contact',
  'tab_root' => 'admin/build/contact',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu',
  'title' => 'Menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Control your site's navigation menu, primary links and secondary links, as well as rename and reorganize menu items.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'Customize menu',
  'title_callback' => 'menu_overview_title',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/add',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:3:"add";i:2;N;i:3;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/menu-customize/%',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'Add item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/delete',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_delete_menu_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu-customize/%/delete',
  'title' => 'Delete menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/edit',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:14:"menu_edit_menu";i:1;s:4:"edit";i:2;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/menu-customize/%',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'Edit menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/list',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/menu-customize/%',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'List items',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"menu_edit_menu";i:1;s:3:"add";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/menu',
  'tab_root' => 'admin/build/menu',
  'title' => 'Add menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/item/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_item_delete_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'fit' => '61',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu/item/%/delete',
  'title' => 'Delete menu item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/item/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:4:"edit";i:2;i:4;i:3;N;}',
  'fit' => '61',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu/item/%/edit',
  'title' => 'Edit menu item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/item/%/reset',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"menu_reset_item_confirm";i:1;i:4;}',
  'fit' => '61',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu/item/%/reset',
  'title' => 'Reset menu item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/menu',
  'tab_root' => 'admin/build/menu',
  'title' => 'List menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"menu_configure";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/menu',
  'tab_root' => 'admin/build/menu',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/modules',
  'title' => 'Modules',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Enable or disable add-on modules for your site.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/modules',
  'tab_root' => 'admin/build/modules',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/list/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/modules/list/confirm',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/uninstall',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/modules',
  'tab_root' => 'admin/build/modules',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/uninstall/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/modules/uninstall/confirm',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/path',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/path',
  'title' => 'URL aliases',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Change your site's URL paths by aliasing them.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/path',
  'tab_root' => 'admin/build/path',
  'title' => 'Add alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"path_admin_delete_confirm";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/path/delete',
  'title' => 'Delete alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/path/edit',
  'title' => 'Edit alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/path',
  'tab_root' => 'admin/build/path',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"system_themes_form";i:1;N;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/themes',
  'title' => 'Themes',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Change which theme your site uses or allows users to set.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/select',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"system_themes_form";i:1;N;}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/themes',
  'tab_root' => 'admin/build/themes',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => 'Select the default theme.',
  'position' => '',
  'weight' => '-1',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/themes',
  'tab_root' => 'admin/build/themes',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/bluemarine',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/bluemarine/bluemarine.info";s:4:"name";s:10:"bluemarine";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:10:"Bluemarine";s:11:"description";s:66:"Table-based multi-column theme with a marine and ash color scheme.";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/bluemarine/script.js";}s:10:"screenshot";s:32:"themes/bluemarine/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:10:"bluemarine";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Bluemarine',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/chameleon',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:31:"themes/chameleon/chameleon.info";s:4:"name";s:9:"chameleon";s:4:"type";s:5:"theme";s:5:"owner";s:32:"themes/chameleon/chameleon.theme";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:12:{s:4:"name";s:9:"Chameleon";s:11:"description";s:42:"Minimalist tabled theme with light colors.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:8:"features";a:4:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:7:"scripts";a:1:{s:9:"script.js";s:26:"themes/chameleon/script.js";}s:10:"screenshot";s:31:"themes/chameleon/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:9:"chameleon";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Chameleon',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:7:"Garland";s:11:"description";s:66:"Tableless, recolorable, multi-column, fluid width theme (default).";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:24:"themes/garland/script.js";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:7:"garland";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/global',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Global settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-1',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/marvin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:35:"themes/chameleon/marvin/marvin.info";s:4:"name";s:6:"marvin";s:4:"type";s:5:"theme";s:5:"owner";s:0:"";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:6:"Marvin";s:11:"description";s:31:"Boxy tabled theme in all grays.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:10:"base theme";s:9:"chameleon";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/chameleon/marvin/script.js";}s:10:"screenshot";s:38:"themes/chameleon/marvin/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:10:"base_theme";s:9:"chameleon";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:6:"marvin";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Marvin',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/minnelli',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":13:{s:8:"filename";s:37:"themes/garland/minnelli/minnelli.info";s:4:"name";s:8:"minnelli";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:14:{s:4:"name";s:8:"Minnelli";s:11:"description";s:56:"Tableless, recolorable, multi-column, fixed width theme.";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:10:"base theme";s:7:"garland";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/garland/minnelli/script.js";}s:10:"screenshot";s:38:"themes/garland/minnelli/screenshot.png";s:3:"php";s:5:"4.3.5";s:6:"engine";s:11:"phptemplate";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:6:"engine";s:11:"phptemplate";s:10:"base_theme";s:7:"garland";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:8:"minnelli";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Minnelli',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/pushbutton',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/pushbutton/pushbutton.info";s:4:"name";s:10:"pushbutton";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:10:"Pushbutton";s:11:"description";s:52:"Tabled, multi-column theme in blue and orange tones.";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/pushbutton/script.js";}s:10:"screenshot";s:32:"themes/pushbutton/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:10:"pushbutton";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Pushbutton',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/translate',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:1:{i:0;s:32:"locale_translate_overview_screen";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/translate',
  'title' => 'Translate interface',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Translate the built in interface and optionally other text.',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/build/translate/delete/%',
  'load_functions' => 'a:1:{i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:2:{i:0;s:28:"locale_translate_delete_page";i:1;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/translate/delete/%',
  'title' => 'Delete string',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/build/translate/edit/%',
  'load_functions' => 'a:1:{i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:3:{i:0;s:15:"drupal_get_form";i:1;s:26:"locale_translate_edit_form";i:2;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/translate/edit/%',
  'title' => 'Edit string',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/build/translate/export',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:1:{i:0;s:30:"locale_translate_export_screen";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/translate',
  'tab_root' => 'admin/build/translate',
  'title' => 'Export',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '30',
  'file' => '',
))
->values(array(
  'path' => 'admin/build/translate/import',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:2:{i:0;s:15:"drupal_get_form";i:1;s:28:"locale_translate_import_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/translate',
  'tab_root' => 'admin/build/translate',
  'title' => 'Import',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '20',
  'file' => '',
))
->values(array(
  'path' => 'admin/build/translate/overview',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:1:{i:0;s:32:"locale_translate_overview_screen";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/translate',
  'tab_root' => 'admin/build/translate',
  'title' => 'Overview',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/build/translate/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:1:{i:0;s:28:"locale_translate_seek_screen";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/translate',
  'tab_root' => 'admin/build/translate',
  'title' => 'Search',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'file' => '',
))
->values(array(
  'path' => 'admin/by-module',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_by_module',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'By module',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/by-task',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_main_admin_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'By task',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/compact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_compact_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/compact',
  'title' => 'Compact mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/content',
  'title' => 'Content management',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Manage your site's content.",
  'position' => 'left',
  'weight' => '-10',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'aggregator_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/aggregator',
  'title' => 'Feed aggregator',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Configure which content your site aggregates from other sites, how often it polls them, and how they're categorized.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/add/category',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"aggregator_form_category";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/aggregator',
  'tab_root' => 'admin/content/aggregator',
  'title' => 'Add category',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/add/feed',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"aggregator_form_feed";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/aggregator',
  'tab_root' => 'admin/content/aggregator',
  'title' => 'Add feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/edit/category/%',
  'load_functions' => 'a:1:{i:5;s:24:"aggregator_category_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"aggregator_form_category";i:1;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/aggregator/edit/category/%',
  'title' => 'Edit category',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/edit/feed/%',
  'load_functions' => 'a:1:{i:5;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"aggregator_form_feed";i:1;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/aggregator/edit/feed/%',
  'title' => 'Edit feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'aggregator_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/aggregator',
  'tab_root' => 'admin/content/aggregator',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/remove/%',
  'load_functions' => 'a:1:{i:4;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"aggregator_admin_remove_feed";i:1;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/aggregator/remove/%',
  'title' => 'Remove items',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"aggregator_admin_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/aggregator',
  'tab_root' => 'admin/content/aggregator',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/update/%',
  'load_functions' => 'a:1:{i:4;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'aggregator_admin_refresh_feed',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/aggregator/update/%',
  'title' => 'Update items',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/book',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer book outlines";}',
  'page_callback' => 'book_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/book',
  'title' => 'Books',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Manage your site's book outlines.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.admin.inc',
))
->values(array(
  'path' => 'admin/content/book/%',
  'load_functions' => 'a:1:{i:3;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_book_outline_access',
  'access_arguments' => 'a:1:{i:0;i:3;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:15:"book_admin_edit";i:1;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/book/%',
  'title' => 'Re-order book pages and change titles',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.admin.inc',
))
->values(array(
  'path' => 'admin/content/book/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer book outlines";}',
  'page_callback' => 'book_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/book',
  'tab_root' => 'admin/content/book',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.admin.inc',
))
->values(array(
  'path' => 'admin/content/book/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"book_admin_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/book',
  'tab_root' => 'admin/content/book',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '8',
  'file' => 'modules/book/book.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/comment',
  'title' => 'Comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List and edit site comments and the comment moderation queue.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment/approval',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:1:{i:0;s:8:"approval";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content/comment',
  'title' => 'Approval queue',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment/new',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content/comment',
  'title' => 'Published comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer nodes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "View, edit, and delete your site's content.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer nodes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"node_configure";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-settings',
  'title' => 'Post settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control posting behavior, such as teaser length, requiring previews before posting, and the number of posts on the front page.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-settings/rebuild',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"node_configure_rebuild_confirm";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-settings/rebuild',
  'title' => 'Rebuild permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"article";s:4:"name";s:7:"Article";s:6:"module";s:4:"node";s:11:"description";s:34:"An <em>article</em>, content type.";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:5:"Title";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"story";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Article',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"article";s:4:"name";s:7:"Article";s:6:"module";s:4:"node";s:11:"description";s:34:"An <em>article</em>, content type.";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:5:"Title";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"story";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/article/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/article',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/article/display',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/article/display',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/article/display',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"article";s:4:"name";s:7:"Article";s:6:"module";s:4:"node";s:11:"description";s:34:"An <em>article</em>, content type.";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:5:"Title";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"story";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/article',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:7:"article";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/article',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"company";s:4:"name";s:7:"Company";s:6:"module";s:4:"node";s:11:"description";s:17:"Company node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:11:"Description";s:14:"min_word_count";s:2:"20";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:7:"company";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Company',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"company";s:4:"name";s:7:"Company";s:6:"module";s:4:"node";s:11:"description";s:17:"Company node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:11:"Description";s:14:"min_word_count";s:2:"20";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:7:"company";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/company/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/company',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/company/display',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/company/display',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/company/display',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"company";s:4:"name";s:7:"Company";s:6:"module";s:4:"node";s:11:"description";s:17:"Company node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:11:"Description";s:14:"min_word_count";s:2:"20";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:7:"company";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/company',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:7:"company";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/company',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:8:"employee";s:4:"name";s:8:"Employee";s:6:"module";s:4:"node";s:11:"description";s:18:"Employee node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:3:"Bio";s:14:"min_word_count";s:2:"20";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:8:"employee";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Employee',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:8:"employee";s:4:"name";s:8:"Employee";s:6:"module";s:4:"node";s:11:"description";s:18:"Employee node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:3:"Bio";s:14:"min_word_count";s:2:"20";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:8:"employee";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/employee/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:8:"employee";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/employee',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:8:"employee";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/employee/display',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:8:"employee";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/employee/display',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:8:"employee";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/employee/display',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:8:"employee";s:4:"name";s:8:"Employee";s:6:"module";s:4:"node";s:11:"description";s:18:"Employee node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:3:"Bio";s:14:"min_word_count";s:2:"20";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:8:"employee";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/employee',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:8:"employee";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/employee',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"sponsor";s:4:"name";s:7:"Sponsor";s:6:"module";s:4:"node";s:11:"description";s:17:"Sponsor node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"0";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:0:"";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Sponsor',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"sponsor";s:4:"name";s:7:"Sponsor";s:6:"module";s:4:"node";s:11:"description";s:17:"Sponsor node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"0";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:0:"";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/sponsor/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:7:"sponsor";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/sponsor',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"sponsor";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/sponsor/display',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"sponsor";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/sponsor/display',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"sponsor";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/sponsor/display',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"sponsor";s:4:"name";s:7:"Sponsor";s:6:"module";s:4:"node";s:11:"description";s:17:"Sponsor node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"0";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:0:"";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/sponsor',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:7:"sponsor";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/sponsor',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:5:\"story\";s:4:\"name\";s:5:\"Story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:5:\"story\";}}",
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Story',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:24:\"node_type_delete_confirm\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:5:\"story\";s:4:\"name\";s:5:\"Story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:5:\"story\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:5:"story";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/story',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:5:"story";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/display',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:5:"story";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/display',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:5:"story";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/display',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:5:\"story\";s:4:\"name\";s:5:\"Story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:5:\"story\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/story',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:5:"story";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/story',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:10:"field_test";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Text Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:10:"field_test";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_date',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:15:"field_test_date";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Date Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_date/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:15:"field_test_date";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_date/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_datestamp',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:20:"field_test_datestamp";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Date Stamp Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_datestamp/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:20:"field_test_datestamp";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_datestamp/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_datetime',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:19:"field_test_datetime";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Datetime Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_datetime/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:19:"field_test_datetime";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_datetime/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_decimal_radio_buttons',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:32:"field_test_decimal_radio_buttons";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Decimal Radio Buttons Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_decimal_radio_buttons/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:32:"field_test_decimal_radio_buttons";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_decimal_radio_buttons/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_email',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:16:"field_test_email";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Email Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_email/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:16:"field_test_email";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_email/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_exclude_unset',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:24:"field_test_exclude_unset";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Text Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_exclude_unset/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:24:"field_test_exclude_unset";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_exclude_unset/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_filefield',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:20:"field_test_filefield";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'File Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_filefield/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:20:"field_test_filefield";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_filefield/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_float_single_checkbox',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:32:"field_test_float_single_checkbox";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Float Single Checkbox Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_float_single_checkbox/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:32:"field_test_float_single_checkbox";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_float_single_checkbox/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_four',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:15:"field_test_four";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Float Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_four/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:15:"field_test_four";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_four/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_identical1',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:21:"field_test_identical1";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Integer Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_identical1/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:21:"field_test_identical1";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_identical1/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_identical2',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:21:"field_test_identical2";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Integer Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_identical2/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:21:"field_test_identical2";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_identical2/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_imagefield',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:21:"field_test_imagefield";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Image Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_imagefield/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:21:"field_test_imagefield";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_imagefield/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_integer_selectlist',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:29:"field_test_integer_selectlist";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Integer Select List Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_integer_selectlist/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:29:"field_test_integer_selectlist";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_integer_selectlist/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_link',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:15:"field_test_link";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Link Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_link/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:15:"field_test_link";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_link/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_phone',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:16:"field_test_phone";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Phone Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_phone/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:16:"field_test_phone";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_phone/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:31:"field_test_text_single_checkbox";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Text Single Checkbox Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:31:"field_test_text_single_checkbox";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox2',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:32:"field_test_text_single_checkbox2";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Text Single Checkbox Field 2',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox2/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:32:"field_test_text_single_checkbox2";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox2/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_three',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:16:"field_test_three";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Decimal Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_three/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:16:"field_test_three";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_three/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_two',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:14:"field_test_two";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Integer Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields/field_test_two/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:14:"field_test_two";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_two/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-event',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:10:"test_event";s:4:"name";s:18:"Migrate test event";s:6:"module";s:4:"node";s:11:"description";s:27:"test event description here";s:4:"help";s:14:"help text here";s:9:"has_title";s:1:"1";s:11:"title_label";s:10:"Event Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"event";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-event',
  'title' => 'Migrate test event',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-event/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:10:"test_event";s:4:"name";s:18:"Migrate test event";s:6:"module";s:4:"node";s:11:"description";s:27:"test event description here";s:4:"help";s:14:"help text here";s:9:"has_title";s:1:"1";s:11:"title_label";s:10:"Event Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"event";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-event/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-event/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_event";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-event',
  'tab_root' => 'admin/content/node-type/test-event',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-event/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_event";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-event/display',
  'tab_root' => 'admin/content/node-type/test-event',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-event/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_event";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-event/display',
  'tab_root' => 'admin/content/node-type/test-event',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-event/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_event";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-event/display',
  'tab_root' => 'admin/content/node-type/test-event',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-event/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:10:"test_event";s:4:"name";s:18:"Migrate test event";s:6:"module";s:4:"node";s:11:"description";s:27:"test event description here";s:4:"help";s:14:"help text here";s:9:"has_title";s:1:"1";s:11:"title_label";s:10:"Event Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"event";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-event',
  'tab_root' => 'admin/content/node-type/test-event',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-event/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:10:"test_event";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-event',
  'tab_root' => 'admin/content/node-type/test-event',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:9:\"test_page\";s:4:\"name\";s:17:\"Migrate test page\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:28:\"This is the body field label\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";}}",
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'Migrate test page',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-page/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:24:\"node_type_delete_confirm\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:9:\"test_page\";s:4:\"name\";s:17:\"Migrate test page\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:28:\"This is the body field label\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-page/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-page/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:9:"test_page";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-page',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-page/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:9:"test_page";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-page/display',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-page/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:9:"test_page";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-page/display',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-page/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:9:"test_page";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-page/display',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-page/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:9:\"test_page\";s:4:\"name\";s:17:\"Migrate test page\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:28:\"This is the body field label\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-page',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-page/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:9:"test_page";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-page',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-page/fields/field_test',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:9:"test_page";i:2;s:10:"field_test";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-page/fields',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'Text Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-page/fields/field_test/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:9:"test_page";i:2;s:10:"field_test";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-page/fields/field_test/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-planet',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:11:\"test_planet\";s:4:\"name\";s:19:\"Migrate test planet\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"0\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:11:\"test_planet\";}}",
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Migrate test planet',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-planet/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:24:\"node_type_delete_confirm\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:11:\"test_planet\";s:4:\"name\";s:19:\"Migrate test planet\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"0\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:11:\"test_planet\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-planet/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-planet/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:11:"test_planet";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-planet',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-planet/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:11:"test_planet";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-planet/display',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-planet/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:11:"test_planet";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-planet/display',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-planet/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:11:"test_planet";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-planet/display',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-planet/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:11:\"test_planet\";s:4:\"name\";s:19:\"Migrate test planet\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"0\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:11:\"test_planet\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-planet',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-planet/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:11:"test_planet";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-planet',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-planet/fields/field_multivalue',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:11:"test_planet";i:2;s:16:"field_multivalue";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-planet/fields',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Decimal Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-planet/fields/field_multivalue/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:11:"test_planet";i:2;s:16:"field_multivalue";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-planet/fields/field_multivalue/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-planet/fields/field_test_text_single_checkbox',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:11:"test_planet";i:2;s:31:"field_test_text_single_checkbox";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-planet/fields',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Text Single Checkbox Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-planet/fields/field_test_text_single_checkbox/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:11:"test_planet";i:2;s:31:"field_test_text_single_checkbox";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-planet/fields/field_test_text_single_checkbox/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-story',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:10:\"test_story\";s:4:\"name\";s:18:\"Migrate test story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"0\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:10:\"test_story\";}}",
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-story',
  'title' => 'Migrate test story',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-story/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:24:\"node_type_delete_confirm\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:10:\"test_story\";s:4:\"name\";s:18:\"Migrate test story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"0\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:10:\"test_story\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-story/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-story/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_story";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-story',
  'tab_root' => 'admin/content/node-type/test-story',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-story/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_story";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-story/display',
  'tab_root' => 'admin/content/node-type/test-story',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-story/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_story";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-story/display',
  'tab_root' => 'admin/content/node-type/test-story',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-story/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_story";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-story/display',
  'tab_root' => 'admin/content/node-type/test-story',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-story/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:10:\"test_story\";s:4:\"name\";s:18:\"Migrate test story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"0\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:10:\"test_story\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-story',
  'tab_root' => 'admin/content/node-type/test-story',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/test-story/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:10:"test_story";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-story',
  'tab_root' => 'admin/content/node-type/test-story',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node/overview',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer nodes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/node',
  'tab_root' => 'admin/content/node',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/rss-publishing',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_rss_feeds_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/rss-publishing',
  'title' => 'RSS publishing',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure the number of items per feed and whether feeds should be titles/teasers/full-text.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy',
  'title' => 'Taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Manage tagging, categorization, and classification of your content.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/%',
  'load_functions' => 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy/%',
  'title' => 'List terms',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/%/add/term',
  'load_functions' => 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'taxonomy_add_term_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '59',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/taxonomy/%',
  'tab_root' => 'admin/content/taxonomy/%',
  'title' => 'Add term',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/%/list',
  'load_functions' => 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/taxonomy/%',
  'tab_root' => 'admin/content/taxonomy/%',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/add/vocabulary',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"taxonomy_form_vocabulary";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/taxonomy',
  'tab_root' => 'admin/content/taxonomy',
  'title' => 'Add vocabulary',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/edit/term',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'taxonomy_admin_term_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy/edit/term',
  'title' => 'Edit term',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/edit/vocabulary/%',
  'load_functions' => 'a:1:{i:5;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'taxonomy_admin_vocabulary_edit',
  'page_arguments' => 'a:1:{i:0;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy/edit/vocabulary/%',
  'title' => 'Edit vocabulary',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/taxonomy',
  'tab_root' => 'admin/content/taxonomy',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'content_types_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/types',
  'title' => 'Content types',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Manage posts by content type, including default status, front page promotion, etc.',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"node_type_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/types',
  'tab_root' => 'admin/content/types',
  'title' => 'Add content type',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/types/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'content_fields_list',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/types',
  'tab_root' => 'admin/content/types',
  'title' => 'Fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/types/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'content_types_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/types',
  'tab_root' => 'admin/content/types',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/reports',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/reports',
  'title' => 'Reports',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'View reports from system logs and other status information.',
  'position' => 'left',
  'weight' => '5',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_status',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status',
  'title' => 'Status report',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Get a status report about your site's operation and any detected problems.",
  'position' => '',
  'weight' => '10',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/php',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_php',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/php',
  'title' => 'PHP',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/run-cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_run_cron',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/run-cron',
  'title' => 'Run cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/sql',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_sql',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/sql',
  'title' => 'SQL',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_settings_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/settings',
  'title' => 'Site configuration',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Adjust basic site configuration options.',
  'position' => 'right',
  'weight' => '-5',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/actions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions',
  'title' => 'Actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/actions/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_actions_configure";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions/configure',
  'title' => 'Configure an advanced action',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/actions/delete/%',
  'load_functions' => 'a:1:{i:4;s:12:"actions_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"system_actions_delete_form";i:1;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions/delete/%',
  'title' => 'Delete action',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => 'Delete an action.',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/actions/manage',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/actions',
  'tab_root' => 'admin/settings/actions',
  'title' => 'Manage actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '-2',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/actions/orphan',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_remove_orphans',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions/orphan',
  'title' => 'Remove orphans',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/admin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_admin_theme_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/admin',
  'title' => 'Administration theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => 'system_admin_theme_settings',
  'description' => 'Settings for how your administrative pages should look.',
  'position' => 'left',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/clean-urls',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_clean_url_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/clean-urls',
  'title' => 'Clean URLs',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Enable or disable clean URLs for your site.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/clean-urls/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_json',
  'page_arguments' => 'a:1:{i:0;a:1:{s:6:"status";b:1;}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/clean-urls/check',
  'title' => 'Clean URL check',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/date-time',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/date-time',
  'title' => 'Date and time',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Settings for how Drupal displays date and time, as well as the system's default timezone.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/date-time/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/date-time',
  'tab_root' => 'admin/settings/date-time',
  'title' => 'Date and time',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => "Settings for how Drupal displays date and time, as well as the system's default timezone.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/date-time/delete/%',
  'load_functions' => 'a:1:{i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:32:"date_api_delete_format_type_form";i:1;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/date-time/delete/%',
  'title' => 'Delete date format type',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => 'Allow users to delete a configured date format type.',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/date/date_api.admin.inc',
))
->values(array(
  'path' => 'admin/settings/date-time/formats',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:26:"date_api_date_formats_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/date-time',
  'tab_root' => 'admin/settings/date-time',
  'title' => 'Formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => 'Allow users to configure date formats',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/date/date_api.admin.inc',
))
->values(array(
  'path' => 'admin/settings/date-time/formats/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"date_api_add_date_formats_form";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/date-time/formats',
  'tab_root' => 'admin/settings/date-time',
  'title' => 'Add format',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => 'Allow users to add additional date formats.',
  'position' => '',
  'weight' => '3',
  'file' => 'sites/all/modules/date/date_api.admin.inc',
))
->values(array(
  'path' => 'admin/settings/date-time/formats/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:26:"date_api_date_formats_form";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/date-time/formats',
  'tab_root' => 'admin/settings/date-time',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => 'Allow users to configure date formats',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/date/date_api.admin.inc',
))
->values(array(
  'path' => 'admin/settings/date-time/formats/custom',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'date_api_configure_custom_date_formats',
  'page_arguments' => 'a:0:{}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/date-time/formats',
  'tab_root' => 'admin/settings/date-time',
  'title' => 'Custom formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => 'Allow users to configure custom date formats.',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/date/date_api.admin.inc',
))
->values(array(
  'path' => 'admin/settings/date-time/formats/delete/%',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"date_api_delete_format_form";i:1;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/date-time/formats/delete/%',
  'title' => 'Delete date format',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => 'Allow users to delete a configured date format.',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/date/date_api.admin.inc',
))
->values(array(
  'path' => 'admin/settings/date-time/formats/lookup',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'date_api_date_time_lookup',
  'page_arguments' => 'a:0:{}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/date-time/formats/lookup',
  'title' => 'Date and time lookup',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/date-time/lookup',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_lookup',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/date-time/lookup',
  'title' => 'Date and time lookup',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/email',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"email_admin_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/email',
  'title' => 'CCK Email Contact Form Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Administer flood control settings for email contact forms',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/error-reporting',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:31:"system_error_reporting_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/error-reporting',
  'title' => 'Error reporting',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control how Drupal deals with errors including 403/404 errors as well as PHP error reporting.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/event',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/event',
  'title' => 'Events',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Set up how your site handles events.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/event/overview',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"event_admin_overview_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/event/overview',
  'title' => 'Event overview',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Change how event summary information is displayed.',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/event/timezone',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"event_admin_timezone_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/event/timezone',
  'title' => 'Timezone handling',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Change how timezone information is saved and displayed.',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/file-system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_file_system_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/file-system',
  'title' => 'File system',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Tell Drupal where to store uploaded files and how they are accessed.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/filters',
  'title' => 'Input formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/%',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/filters/%',
  'title' => '',
  'title_callback' => 'filter_admin_format_title',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/%/configure',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_configure_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/filters/%',
  'tab_root' => 'admin/settings/filters/%',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/%/edit',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/filters/%',
  'tab_root' => 'admin/settings/filters/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/%/order',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_order_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/filters/%',
  'tab_root' => 'admin/settings/filters/%',
  'title' => 'Rearrange',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/filters',
  'tab_root' => 'admin/settings/filters',
  'title' => 'Add input format',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"filter_admin_delete";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/filters/delete',
  'title' => 'Delete input format',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/filters',
  'tab_root' => 'admin/settings/filters',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/image-toolkit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"system_image_toolkit_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/image-toolkit',
  'title' => 'Image toolkit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Choose which image toolkit to use if you have installed optional toolkits.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/imageapi',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer imageapi";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:17:"imageapi_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/imageapi',
  'title' => 'ImageAPI',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure ImageAPI.',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/language',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:2:{i:0;s:15:"drupal_get_form";i:1;s:30:"locale_languages_overview_form";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/language',
  'title' => 'Languages',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure languages for content and the user interface.',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/language/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:1:{i:0;s:27:"locale_languages_add_screen";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/language',
  'tab_root' => 'admin/settings/language',
  'title' => 'Add language',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/language/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:2:{i:0;s:15:"drupal_get_form";i:1;s:31:"locale_languages_configure_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/language',
  'tab_root' => 'admin/settings/language',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/language/delete/%',
  'load_functions' => 'a:1:{i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:3:{i:0;s:15:"drupal_get_form";i:1;s:28:"locale_languages_delete_form";i:2;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/language/delete/%',
  'title' => 'Confirm',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/language/edit/%',
  'load_functions' => 'a:1:{i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:3:{i:0;s:15:"drupal_get_form";i:1;s:26:"locale_languages_edit_form";i:2;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/language/edit/%',
  'title' => 'Edit language',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/language/overview',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:2:{i:0;s:15:"drupal_get_form";i:1;s:30:"locale_languages_overview_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/language',
  'tab_root' => 'admin/settings/language',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/logging',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_logging_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/logging',
  'title' => 'Logging and alerts',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Settings for logging and alerts modules. Various modules can route Drupal's system events to different destination, such as syslog, database, email, ...etc.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/performance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_performance_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/performance',
  'title' => 'Performance',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/site-information',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_site_information_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/site-information',
  'title' => 'Site information',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Change basic site information, such as the site name, slogan, e-mail address, mission, front page and more.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/site-maintenance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_site_maintenance_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/site-maintenance',
  'title' => 'Site maintenance',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Take the site off-line for maintenance or bring it back online.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/uploads',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"upload_admin_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/uploads',
  'title' => 'File uploads',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control how files may be attached to content.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/upload/upload.admin.inc',
))
->values(array(
  'path' => 'admin/user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/user',
  'title' => 'User management',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Manage your site's users, groups and access to site features.",
  'position' => 'left',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/user/permissions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:15:"user_admin_perm";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/permissions',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/profile',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"profile_admin_overview";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/profile',
  'title' => 'Profiles',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Create customizable fields for your users.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/profile/profile.admin.inc',
))
->values(array(
  'path' => 'admin/user/profile/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"profile_field_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/profile/add',
  'title' => 'Add field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/profile/profile.admin.inc',
))
->values(array(
  'path' => 'admin/user/profile/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'profile_admin_settings_autocomplete',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/profile/autocomplete',
  'title' => 'Profile category autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/profile/profile.admin.inc',
))
->values(array(
  'path' => 'admin/user/profile/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"profile_field_delete";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/profile/delete',
  'title' => 'Delete field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/profile/profile.admin.inc',
))
->values(array(
  'path' => 'admin/user/profile/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"profile_field_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/profile/edit',
  'title' => 'Edit field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/profile/profile.admin.inc',
))
->values(array(
  'path' => 'admin/user/roles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_new_role";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/roles',
  'title' => 'Roles',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List, edit, or add user roles.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/roles/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:15:"user_admin_role";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/roles/edit',
  'title' => 'Edit role',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/rules',
  'title' => 'Access rules',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List and create rules to disallow usernames, e-mail addresses, and IP addresses.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access_add',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/rules',
  'tab_root' => 'admin/user/rules',
  'title' => 'Add rule',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access_check',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/rules',
  'tab_root' => 'admin/user/rules',
  'title' => 'Check rules',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"user_admin_access_delete_confirm";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/rules/delete',
  'title' => 'Delete rule',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/rules/edit',
  'title' => 'Edit rule',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/rules',
  'tab_root' => 'admin/user/rules',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/settings',
  'title' => 'User settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure default behavior of users, including registration requirements, e-mails, and user pictures.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/user',
  'title' => 'Users',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List, add, and edit users.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/user/create',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:6:"create";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/user',
  'tab_root' => 'admin/user/user',
  'title' => 'Add user',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/user/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/user',
  'tab_root' => 'admin/user/user',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'aggregator',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_last',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'aggregator',
  'title' => 'Feed aggregator',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'file' => 'modules/aggregator/aggregator.pages.inc',
))
->values(array(
  'path' => 'aggregator/categories',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_aggregator_has_categories',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'aggregator_page_categories',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'aggregator/categories',
  'title' => 'Categories',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
))
->values(array(
  'path' => 'aggregator/categories/%',
  'load_functions' => 'a:1:{i:2;s:24:"aggregator_category_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_category',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '6',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'aggregator/categories/%',
  'title' => '',
  'title_callback' => '_aggregator_category_title',
  'title_arguments' => 'a:1:{i:0;i:2;}',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
))
->values(array(
  'path' => 'aggregator/categories/%/categorize',
  'load_functions' => 'a:1:{i:2;s:24:"aggregator_category_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"aggregator_page_category";i:1;i:2;}',
  'fit' => '13',
  'number_parts' => '4',
  'tab_parent' => 'aggregator/categories/%',
  'tab_root' => 'aggregator/categories/%',
  'title' => 'Categorize',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
))
->values(array(
  'path' => 'aggregator/categories/%/configure',
  'load_functions' => 'a:1:{i:2;s:24:"aggregator_category_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"aggregator_form_category";i:1;i:2;}',
  'fit' => '13',
  'number_parts' => '4',
  'tab_parent' => 'aggregator/categories/%',
  'tab_root' => 'aggregator/categories/%',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'aggregator/categories/%/view',
  'load_functions' => 'a:1:{i:2;s:24:"aggregator_category_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_category',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '13',
  'number_parts' => '4',
  'tab_parent' => 'aggregator/categories/%',
  'tab_root' => 'aggregator/categories/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/aggregator/aggregator.pages.inc',
))
->values(array(
  'path' => 'aggregator/opml',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_opml',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'aggregator/opml',
  'title' => 'OPML feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
))
->values(array(
  'path' => 'aggregator/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_rss',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'aggregator/rss',
  'title' => 'RSS feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
))
->values(array(
  'path' => 'aggregator/sources',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_sources',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'aggregator/sources',
  'title' => 'Sources',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
))
->values(array(
  'path' => 'aggregator/sources/%',
  'load_functions' => 'a:1:{i:2;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_source',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '6',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'aggregator/sources/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
))
->values(array(
  'path' => 'aggregator/sources/%/categorize',
  'load_functions' => 'a:1:{i:2;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:22:"aggregator_page_source";i:1;i:2;}',
  'fit' => '13',
  'number_parts' => '4',
  'tab_parent' => 'aggregator/sources/%',
  'tab_root' => 'aggregator/sources/%',
  'title' => 'Categorize',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
))
->values(array(
  'path' => 'aggregator/sources/%/configure',
  'load_functions' => 'a:1:{i:2;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"aggregator_form_feed";i:1;i:2;}',
  'fit' => '13',
  'number_parts' => '4',
  'tab_parent' => 'aggregator/sources/%',
  'tab_root' => 'aggregator/sources/%',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'aggregator/sources/%/view',
  'load_functions' => 'a:1:{i:2;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_source',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '13',
  'number_parts' => '4',
  'tab_parent' => 'aggregator/sources/%',
  'tab_root' => 'aggregator/sources/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/aggregator/aggregator.pages.inc',
))
->values(array(
  'path' => 'batch',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_batch_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'batch',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'book',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'book_render',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'book',
  'title' => 'Books',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.pages.inc',
))
->values(array(
  'path' => 'book/export/%/%',
  'load_functions' => 'a:2:{i:2;N;i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:31:"access printer-friendly version";}',
  'page_callback' => 'book_export',
  'page_arguments' => 'a:2:{i:0;i:2;i:1;i:3;}',
  'fit' => '12',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'book/export/%/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.pages.inc',
))
->values(array(
  'path' => 'book/js/form',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'book_form_update',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'book/js/form',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.pages.inc',
))
->values(array(
  'path' => 'comment/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_delete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'comment/delete',
  'title' => 'Delete comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'comment/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:13:"post comments";}',
  'page_callback' => 'comment_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'comment/edit',
  'title' => 'Edit comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.pages.inc',
))
->values(array(
  'path' => 'comment/reply/%',
  'load_functions' => 'a:1:{i:2;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:2;}',
  'page_callback' => 'comment_reply',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '6',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'comment/reply/%',
  'title' => 'Reply to comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.pages.inc',
))
->values(array(
  'path' => 'contact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"access site-wide contact form";}',
  'page_callback' => 'contact_site_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'contact',
  'title' => 'Contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/contact/contact.pages.inc',
))
->values(array(
  'path' => 'content/js_add_more',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'content_add_more_js',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'content/js_add_more',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.node_form.inc',
))
->values(array(
  'path' => 'core/modules/simpletest/files/imagecache',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_imagecache_menu_access_public_files',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'imagecache_cache',
  'page_arguments' => 'a:0:{}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'core/modules/simpletest/files/imagecache',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'email/%/%',
  'load_functions' => 'a:2:{i:1;s:9:"node_load";i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'email_mail_page',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;i:2;}',
  'fit' => '4',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'email/%/%',
  'title' => 'Email Contact Form',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'event',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'event_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'event',
  'title' => 'Events',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/event/ical.inc',
))
->values(array(
  'path' => 'event/dst',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'event_dst',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'event/dst',
  'title' => 'Event dst view',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'event/feed',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'event_feed',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'event/feed',
  'title' => 'Event rss feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'event/ical',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'event_ical',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'event/ical',
  'title' => 'Event ical feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/event/ical.inc',
))
->values(array(
  'path' => 'event/term',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'event_term',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'event/term',
  'title' => 'Filter by taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'event/type',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'event_type',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'event/type',
  'title' => 'Filter by content type',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'filefield/ahah/%/%/%',
  'load_functions' => 'a:3:{i:2;N;i:3;N;i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'filefield_edit_access',
  'access_arguments' => 'a:2:{i:0;i:2;i:1;i:3;}',
  'page_callback' => 'filefield_js',
  'page_arguments' => 'a:3:{i:0;i:2;i:1;i:3;i:2;i:4;}',
  'fit' => '24',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'filefield/ahah/%/%/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'filefield/progress',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'filefield_progress',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'filefield/progress',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'filter/tips',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'filter_tips_long',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'filter/tips',
  'title' => 'Compose tips',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.pages.inc',
))
->values(array(
  'path' => 'logout',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_logged_in',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_logout',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'logout',
  'title' => 'Log out',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_page_default',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'node',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'node/%',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '2',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 'node_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'node/%/delete',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"delete";i:1;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"node_delete_confirm";i:1;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/%/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"update";i:1;i:1;}',
  'page_callback' => 'node_page_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/ical',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'event_ical_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'event_node_ical',
  'page_arguments' => 'a:0:{}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/%/ical',
  'title' => 'Event ical',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/event/ical.inc',
))
->values(array(
  'path' => 'node/%/outline',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_book_outline_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'book_outline',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Outline',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/book/book.pages.inc',
))
->values(array(
  'path' => 'node/%/outline/remove',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_book_outline_remove_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:16:"book_remove_form";i:1;i:1;}',
  'fit' => '11',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'node/%/outline/remove',
  'title' => 'Remove from outline',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_revision_overview',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/delete',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"delete";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_delete_confirm";i:1;i:1;}',
  'fit' => '21',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/delete',
  'title' => 'Delete earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/revert',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"update";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_revert_confirm";i:1;i:1;}',
  'fit' => '21',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/revert',
  'title' => 'Revert to earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/view',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_show',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;N;i:2;b:1;}',
  'fit' => '21',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/view',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'node/%/translate',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_translation_tab_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'translation_node_overview',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/translation/translation.pages.inc',
))
->values(array(
  'path' => 'node/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => '',
))
->values(array(
  'path' => 'node/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_node_add_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'node_add_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'node/add',
  'title' => 'Create content',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/article',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:7:"article";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/article',
  'title' => 'Article',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'An <em>article</em>, content type.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/company',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:7:"company";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/company',
  'title' => 'Company',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Company node type',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/employee',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:8:"employee";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/employee',
  'title' => 'Employee',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Employee node type',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/sponsor',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:7:"sponsor";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/sponsor',
  'title' => 'Sponsor',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Sponsor node type',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/story',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:5:"story";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/story',
  'title' => 'Story',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/test-event',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:10:"test_event";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/test-event',
  'title' => 'Migrate test event',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'test event description here',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/test-page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:9:"test_page";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/test-page',
  'title' => 'Migrate test page',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/test-planet',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:11:"test_planet";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/test-planet',
  'title' => 'Migrate test planet',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/test-story',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:10:"test_story";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/test-story',
  'title' => 'Migrate test story',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'profile',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access user profiles";}',
  'page_callback' => 'profile_browse',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'profile',
  'title' => 'User list',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/profile/profile.pages.inc',
))
->values(array(
  'path' => 'profile/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access user profiles";}',
  'page_callback' => 'profile_autocomplete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'profile/autocomplete',
  'title' => 'Profile autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/profile/profile.pages.inc',
))
->values(array(
  'path' => 'rss.xml',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_feed',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'rss.xml',
  'title' => 'RSS feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'system/files',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:1:{i:0;s:19:"view uploaded files";}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'system/files',
  'title' => 'File download',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'system/files/imagecache',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'imagecache_cache_private',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'system/files/imagecache',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'taxonomy/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_autocomplete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/autocomplete',
  'title' => 'Autocomplete taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'taxonomy/term/%',
  'load_functions' => 'a:1:{i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_term_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '6',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Taxonomy term',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'upload/js',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:12:"upload files";}',
  'page_callback' => 'upload_js',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'upload/js',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'user',
  'title' => 'User account',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%',
  'load_functions' => 'a:1:{i:1;s:22:"user_uid_optional_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:24:"user_uid_optional_to_arg";}',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '2',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'user/%',
  'title' => 'My account',
  'title_callback' => 'user_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/contact',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_contact_user_tab_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'contact_user_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/contact/contact.pages.inc',
))
->values(array(
  'path' => 'user/%/delete',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_delete_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"user_confirm_delete";i:1;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'user/%/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit/account',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '11',
  'number_parts' => '4',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => 'Account',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit/Administrative data',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'profile_category_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:19:"Administrative data";}',
  'page_callback' => 'user_edit',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;i:3;}',
  'fit' => '11',
  'number_parts' => '4',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => '',
  'title_callback' => 'check_plain',
  'title_arguments' => 'a:1:{i:0;s:19:"Administrative data";}',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '3',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit/Communication preferences',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'profile_category_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:25:"Communication preferences";}',
  'page_callback' => 'user_edit',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;i:3;}',
  'fit' => '11',
  'number_parts' => '4',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => '',
  'title_callback' => 'check_plain',
  'title_arguments' => 'a:1:{i:0;s:25:"Communication preferences";}',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '3',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit/Personal information',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'profile_category_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:20:"Personal information";}',
  'page_callback' => 'user_edit',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;i:3;}',
  'fit' => '11',
  'number_parts' => '4',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => '',
  'title_callback' => 'check_plain',
  'title_arguments' => 'a:1:{i:0;s:20:"Personal information";}',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '3',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access user profiles";}',
  'page_callback' => 'user_autocomplete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'user/autocomplete',
  'title' => 'User autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/login',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_anonymous',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Log in',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/password',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_anonymous',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:9:"user_pass";}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Request new password',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/register',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_register_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:13:"user_register";}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Create new account',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/reset/%/%/%',
  'load_functions' => 'a:3:{i:2;N;i:3;N;i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:15:"user_pass_reset";i:1;i:2;i:2;i:3;i:3;i:4;}',
  'fit' => '24',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'user/reset/%/%/%',
  'title' => 'Reset password',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/timezone',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_timezone',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'user/timezone',
  'title' => 'User timezone',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->execute();

$connection->schema()->createTable('node', array(
  'fields' => array(
    'nid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'comment' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'promote' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'moderate' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tnid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'translate' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node')
->fields(array(
  'nid',
  'vid',
  'type',
  'language',
  'title',
  'uid',
  'status',
  'created',
  'changed',
  'comment',
  'promote',
  'moderate',
  'sticky',
  'tnid',
  'translate',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'type' => 'story',
  'language' => '',
  'title' => 'Test title',
  'uid' => '1',
  'status' => '1',
  'created' => '1388271197',
  'changed' => '1420861423',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '2',
  'vid' => '3',
  'type' => 'story',
  'language' => '',
  'title' => 'Test title rev 3',
  'uid' => '1',
  'status' => '1',
  'created' => '1388271197',
  'changed' => '1420718386',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '3',
  'vid' => '4',
  'type' => 'test_planet',
  'language' => '',
  'title' => 'Test planet title 3',
  'uid' => '1',
  'status' => '1',
  'created' => '1388271527',
  'changed' => '1390096401',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '4',
  'vid' => '6',
  'type' => 'test_planet',
  'language' => '',
  'title' => '',
  'uid' => '1',
  'status' => '1',
  'created' => '1388271527',
  'changed' => '1390096401',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '5',
  'vid' => '7',
  'type' => 'test_planet',
  'language' => '',
  'title' => '',
  'uid' => '1',
  'status' => '1',
  'created' => '1388271527',
  'changed' => '1390096401',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '6',
  'vid' => '8',
  'type' => 'test_planet',
  'language' => '',
  'title' => '',
  'uid' => '1',
  'status' => '1',
  'created' => '1388271527',
  'changed' => '1390096401',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '7',
  'vid' => '9',
  'type' => 'test_planet',
  'language' => '',
  'title' => '',
  'uid' => '1',
  'status' => '1',
  'created' => '1388271527',
  'changed' => '1390096401',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '8',
  'vid' => '10',
  'type' => 'test_planet',
  'language' => '',
  'title' => '',
  'uid' => '1',
  'status' => '1',
  'created' => '1388271527',
  'changed' => '1390096401',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '9',
  'vid' => '12',
  'type' => 'story',
  'language' => '',
  'title' => 'Once upon a time',
  'uid' => '1',
  'status' => '1',
  'created' => '1444671588',
  'changed' => '1444671588',
  'comment' => '2',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->execute();

$connection->schema()->createTable('node_access', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'gid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'realm' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'grant_view' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'grant_update' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'grant_delete' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
    'gid',
    'realm',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_access')
->fields(array(
  'nid',
  'gid',
  'realm',
  'grant_view',
  'grant_update',
  'grant_delete',
))
->values(array(
  'nid' => '0',
  'gid' => '0',
  'realm' => 'all',
  'grant_view' => '1',
  'grant_update' => '0',
  'grant_delete' => '0',
))
->execute();

$connection->schema()->createTable('node_comment_statistics', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'last_comment_timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'last_comment_name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ),
    'last_comment_uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'comment_count' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'indexes' => array(
    'comment_count' => array(
      'comment_count',
    ),
    'last_comment_uid' => array(
      'last_comment_uid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_comment_statistics')
->fields(array(
  'nid',
  'last_comment_timestamp',
  'last_comment_name',
  'last_comment_uid',
  'comment_count',
))
->values(array(
  'nid' => '1',
  'last_comment_timestamp' => '1388271197',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->values(array(
  'nid' => '2',
  'last_comment_timestamp' => '1389002813',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->values(array(
  'nid' => '9',
  'last_comment_timestamp' => '1444671588',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->execute();

$connection->schema()->createTable('node_counter', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'totalcount' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'daycount' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('node_revisions', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'body' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'teaser' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'log' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_revisions')
->fields(array(
  'nid',
  'vid',
  'uid',
  'title',
  'body',
  'teaser',
  'log',
  'timestamp',
  'format',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'uid' => '1',
  'title' => 'Test title',
  'body' => 'test',
  'teaser' => 'test',
  'log' => '',
  'timestamp' => '1420861423',
  'format' => '1',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'uid' => '2',
  'title' => 'Test title rev 2',
  'body' => 'body test rev 2',
  'teaser' => 'teaser test rev 2',
  'log' => 'modified rev 2',
  'timestamp' => '1390095702',
  'format' => '1',
))
->values(array(
  'nid' => '2',
  'vid' => '3',
  'uid' => '1',
  'title' => 'Test title rev 3',
  'body' => 'test rev 3',
  'teaser' => 'test rev 3',
  'log' => '',
  'timestamp' => '1420718386',
  'format' => '1',
))
->values(array(
  'nid' => '3',
  'vid' => '4',
  'uid' => '1',
  'title' => 'Test page title rev 4',
  'body' => 'test page body rev 4',
  'teaser' => 'test page teaser rev 4',
  'log' => '',
  'timestamp' => '1390095701',
  'format' => '0',
))
->values(array(
  'nid' => '1',
  'vid' => '5',
  'uid' => '1',
  'title' => 'Test title rev 3',
  'body' => 'body test rev 3',
  'teaser' => 'teaser test rev 3',
  'log' => 'modified rev 3',
  'timestamp' => '1390095703',
  'format' => '1',
))
->values(array(
  'nid' => '4',
  'vid' => '6',
  'uid' => '1',
  'title' => 'Node 4',
  'body' => 'Node 4 body',
  'teaser' => 'test for node 4',
  'log' => '',
  'timestamp' => '1390095701',
  'format' => '1',
))
->values(array(
  'nid' => '5',
  'vid' => '7',
  'uid' => '1',
  'title' => 'Node 5',
  'body' => 'Node 5 body',
  'teaser' => 'test for node 5',
  'log' => '',
  'timestamp' => '1390095701',
  'format' => '1',
))
->values(array(
  'nid' => '6',
  'vid' => '8',
  'uid' => '1',
  'title' => 'Node 6',
  'body' => 'Node 6 body',
  'teaser' => 'test for node 6',
  'log' => '',
  'timestamp' => '1390095701',
  'format' => '1',
))
->values(array(
  'nid' => '7',
  'vid' => '9',
  'uid' => '1',
  'title' => 'Node 7',
  'body' => 'Node 7 body',
  'teaser' => 'test for node 7',
  'log' => '',
  'timestamp' => '1390095701',
  'format' => '1',
))
->values(array(
  'nid' => '8',
  'vid' => '10',
  'uid' => '1',
  'title' => 'Node 8',
  'body' => 'Node 8 body',
  'teaser' => 'test for node 8',
  'log' => '',
  'timestamp' => '1390095701',
  'format' => '1',
))
->values(array(
  'nid' => '9',
  'vid' => '11',
  'uid' => '1',
  'title' => 'Node 9',
  'body' => 'Node 9 body',
  'teaser' => 'test for node 9',
  'log' => '',
  'timestamp' => '1390095701',
  'format' => '1',
))
->values(array(
  'nid' => '9',
  'vid' => '12',
  'uid' => '1',
  'title' => 'Once upon a time',
  'body' => 'Come on kid, go to sleep.',
  'teaser' => 'Come on kid, go to sleep.',
  'log' => '',
  'timestamp' => '1444671588',
  'format' => '1',
))
->execute();

$connection->schema()->createTable('node_type', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'help' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'has_title' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'title_label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'has_body' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body_label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'min_word_count' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'modified' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'orig_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_type')
->fields(array(
  'type',
  'name',
  'module',
  'description',
  'help',
  'has_title',
  'title_label',
  'has_body',
  'body_label',
  'min_word_count',
  'custom',
  'modified',
  'locked',
  'orig_type',
))
->values(array(
  'type' => 'article',
  'name' => 'Article',
  'module' => 'node',
  'description' => 'An <em>article</em>, content type.',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'has_body' => '1',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'story',
))
->values(array(
  'type' => 'company',
  'name' => 'Company',
  'module' => 'node',
  'description' => 'Company node type',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Name',
  'has_body' => '1',
  'body_label' => 'Description',
  'min_word_count' => '20',
  'custom' => '0',
  'modified' => '0',
  'locked' => '0',
  'orig_type' => 'company',
))
->values(array(
  'type' => 'employee',
  'name' => 'Employee',
  'module' => 'node',
  'description' => 'Employee node type',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Name',
  'has_body' => '1',
  'body_label' => 'Bio',
  'min_word_count' => '20',
  'custom' => '0',
  'modified' => '0',
  'locked' => '0',
  'orig_type' => 'employee',
))
->values(array(
  'type' => 'event',
  'name' => 'Event',
  'module' => 'node',
  'description' => 'Events have a start date and an optional end date as well as a teaser and a body. They can be extended by other modules, too.',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'has_body' => '1',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'event',
))
->values(array(
  'type' => 'page',
  'name' => 'Page',
  'module' => 'node',
  'description' => "A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.",
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'has_body' => '1',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'page',
))
->values(array(
  'type' => 'sponsor',
  'name' => 'Sponsor',
  'module' => 'node',
  'description' => 'Sponsor node type',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Name',
  'has_body' => '0',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '0',
  'modified' => '0',
  'locked' => '0',
  'orig_type' => '',
))
->values(array(
  'type' => 'story',
  'name' => 'Story',
  'module' => 'node',
  'description' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'has_body' => '1',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'story',
))
->values(array(
  'type' => 'test_event',
  'name' => 'Migrate test event',
  'module' => 'node',
  'description' => 'test event description here',
  'help' => 'help text here',
  'has_title' => '1',
  'title_label' => 'Event Name',
  'has_body' => '1',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'event',
))
->values(array(
  'type' => 'test_page',
  'name' => 'Migrate test page',
  'module' => 'node',
  'description' => "A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.",
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'has_body' => '1',
  'body_label' => 'This is the body field label',
  'min_word_count' => '0',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'page',
))
->values(array(
  'type' => 'test_planet',
  'name' => 'Migrate test planet',
  'module' => 'node',
  'description' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'has_body' => '0',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'test_planet',
))
->values(array(
  'type' => 'test_story',
  'name' => 'Migrate test story',
  'module' => 'node',
  'description' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'has_body' => '0',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'test_story',
))
->execute();

$connection->schema()->createTable('permission', array(
  'fields' => array(
    'pid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'perm' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'pid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('permission')
->fields(array(
  'pid',
  'rid',
  'perm',
  'tid',
))
->values(array(
  'pid' => '1',
  'rid' => '1',
  'perm' => 'migrate test anonymous permission',
  'tid' => '0',
))
->values(array(
  'pid' => '2',
  'rid' => '2',
  'perm' => 'migrate test authenticated permission',
  'tid' => '0',
))
->values(array(
  'pid' => '3',
  'rid' => '3',
  'perm' => 'migrate test role 1 test permission',
  'tid' => '0',
))
->values(array(
  'pid' => '4',
  'rid' => '4',
  'perm' => 'migrate test role 2 test permission, use PHP for settings, administer contact forms, skip comment approval, edit own blog content, edit any blog content, delete own blog content, delete any blog content, create forum content, delete any forum content, delete own forum content, edit any forum content, edit own forum content, administer nodes',
  'tid' => '0',
))
->values(array(
  'pid' => '5',
  'rid' => '1',
  'perm' => 'access content',
  'tid' => '0',
))
->values(array(
  'pid' => '6',
  'rid' => '2',
  'perm' => 'access comments, access content, post comments, post comments without approval',
  'tid' => '0',
))
->execute();

$connection->schema()->createTable('profile_fields', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'explanation' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'category' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'page' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'required' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'register' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'visibility' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'autocomplete' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'options' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('profile_fields')
->fields(array(
  'fid',
  'title',
  'name',
  'explanation',
  'category',
  'page',
  'type',
  'weight',
  'required',
  'register',
  'visibility',
  'autocomplete',
  'options',
))
->values(array(
  'fid' => '8',
  'title' => 'Favorite color',
  'name' => 'profile_color',
  'explanation' => 'List your favorite color',
  'category' => 'Personal information',
  'page' => 'Peole whose favorite color is %value',
  'type' => 'textfield',
  'weight' => '-10',
  'required' => '0',
  'register' => '1',
  'visibility' => '2',
  'autocomplete' => '1',
  'options' => '',
))
->values(array(
  'fid' => '9',
  'title' => 'Biography',
  'name' => 'profile_biography',
  'explanation' => 'Tell people a little bit about yourself',
  'category' => 'Personal information',
  'page' => '',
  'type' => 'textarea',
  'weight' => '-8',
  'required' => '0',
  'register' => '0',
  'visibility' => '2',
  'autocomplete' => '0',
  'options' => '',
))
->values(array(
  'fid' => '10',
  'title' => 'Sell your email address?',
  'name' => 'profile_sell_address',
  'explanation' => "If you check this box, we'll sell your address to spammers to help line the pockets of our shareholders. Thanks!",
  'category' => 'Communication preferences',
  'page' => 'People who want us to sell their address',
  'type' => 'checkbox',
  'weight' => '-10',
  'required' => '0',
  'register' => '1',
  'visibility' => '1',
  'autocomplete' => '0',
  'options' => '',
))
->values(array(
  'fid' => '11',
  'title' => 'Sales Category',
  'name' => 'profile_sold_to',
  'explanation' => "Select the sales categories to which this user's address was sold.",
  'category' => 'Administrative data',
  'page' => 'People whose address was sold to %value',
  'type' => 'selection',
  'weight' => '-10',
  'required' => '0',
  'register' => '0',
  'visibility' => '4',
  'autocomplete' => '0',
  'options' => "Pill spammers\r\nFitness spammers\r\nBack\\slash\r\nForward/slash\r\nDot.in.the.middle",
))
->values(array(
  'fid' => '12',
  'title' => 'Favorite bands',
  'name' => 'profile_bands',
  'explanation' => "Enter your favorite bands. When you've saved your profile, you'll be able to find other people with the same favorites.",
  'category' => 'Personal information',
  'page' => '',
  'type' => 'list',
  'weight' => '-6',
  'required' => '0',
  'register' => '1',
  'visibility' => '3',
  'autocomplete' => '1',
  'options' => '',
))
->values(array(
  'fid' => '14',
  'title' => 'Birthdate',
  'name' => 'profile_birthdate',
  'explanation' => "Enter your birth date and we'll send you a coupon.",
  'category' => 'Personal information',
  'page' => '',
  'type' => 'date',
  'weight' => '4',
  'required' => '0',
  'register' => '0',
  'visibility' => '2',
  'autocomplete' => '0',
  'options' => '',
))
->values(array(
  'fid' => '15',
  'title' => 'I love migrations',
  'name' => 'profile_love_migrations',
  'explanation' => 'If you check this box, you love migrations.',
  'category' => 'Personal information',
  'page' => 'People who love migrations',
  'type' => 'checkbox',
  'weight' => '-15',
  'required' => '0',
  'register' => '0',
  'visibility' => '2',
  'autocomplete' => '0',
  'options' => '',
))
->values(array(
  'fid' => '16',
  'title' => 'Blog',
  'name' => 'profile_blog',
  'explanation' => 'Paste the full URL, including http://, of your personal blog.',
  'category' => 'Personal information',
  'page' => '',
  'type' => 'url',
  'weight' => '3',
  'required' => '0',
  'register' => '0',
  'visibility' => '3',
  'autocomplete' => '0',
  'options' => '',
))
->execute();

$connection->schema()->createTable('profile_values', array(
  'fields' => array(
    'fid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'fid',
    'uid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('profile_values')
->fields(array(
  'fid',
  'uid',
  'value',
))
->values(array(
  'fid' => '8',
  'uid' => '2',
  'value' => 'red',
))
->values(array(
  'fid' => '8',
  'uid' => '8',
  'value' => 'brown',
))
->values(array(
  'fid' => '8',
  'uid' => '15',
  'value' => 'orange',
))
->values(array(
  'fid' => '8',
  'uid' => '16',
  'value' => 'blue',
))
->values(array(
  'fid' => '8',
  'uid' => '17',
  'value' => 'yellow',
))
->values(array(
  'fid' => '9',
  'uid' => '2',
  'value' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam nulla sapien, congue nec risus ut, adipiscing aliquet felis. Maecenas quis justo vel nulla varius euismod. Quisque metus metus, cursus sit amet sem non, bibendum vehicula elit. Cras dui nisl, eleifend at iaculis vitae, lacinia ut felis. Nullam aliquam ligula volutpat nulla consectetur accumsan. Maecenas tincidunt molestie diam, a accumsan enim fringilla sit amet. Morbi a tincidunt tellus. Donec imperdiet scelerisque porta. Sed quis sem bibendum eros congue sodales. Vivamus vel fermentum est, at rutrum orci. Nunc consectetur purus ut dolor pulvinar, ut volutpat felis congue. Cras tincidunt odio sed neque sollicitudin, vehicula tempor metus scelerisque.',
))
->values(array(
  'fid' => '9',
  'uid' => '8',
  'value' => 'Nunc condimentum ligula felis, eget lacinia purus accumsan at. Pellentesque eu lobortis felis. Duis at accumsan nisl, vel pulvinar risus. Nullam venenatis, tellus non eleifend hendrerit, augue nulla rhoncus leo, eget convallis enim sem ut velit. Mauris tincidunt enim ut eros volutpat dapibus. Curabitur augue libero, imperdiet eget orci sed, malesuada dapibus tellus. Nam lacus sapien, convallis vitae quam vel, bibendum commodo odio.',
))
->values(array(
  'fid' => '9',
  'uid' => '15',
  'value' => 'Donec a diam volutpat augue fringilla fringilla. Mauris ultricies turpis ut lacus tempus, vitae pharetra lacus mattis. Nulla semper dui euismod sem bibendum, in eleifend nisi malesuada. Vivamus orci mauris, volutpat vitae enim ac, aliquam tempus lectus.',
))
->values(array(
  'fid' => '9',
  'uid' => '16',
  'value' => 'Pellentesque sit amet sem et purus pretium consectetuer.',
))
->values(array(
  'fid' => '9',
  'uid' => '17',
  'value' => 'The quick brown fox jumped over the lazy dog.',
))
->values(array(
  'fid' => '10',
  'uid' => '2',
  'value' => '1',
))
->values(array(
  'fid' => '10',
  'uid' => '8',
  'value' => '0',
))
->values(array(
  'fid' => '10',
  'uid' => '15',
  'value' => '1',
))
->values(array(
  'fid' => '10',
  'uid' => '16',
  'value' => '0',
))
->values(array(
  'fid' => '10',
  'uid' => '17',
  'value' => '0',
))
->values(array(
  'fid' => '11',
  'uid' => '2',
  'value' => 'Back\slash',
))
->values(array(
  'fid' => '11',
  'uid' => '8',
  'value' => 'Forward/slash',
))
->values(array(
  'fid' => '11',
  'uid' => '15',
  'value' => 'Dot.in.the.middle',
))
->values(array(
  'fid' => '11',
  'uid' => '16',
  'value' => 'Faithful servant',
))
->values(array(
  'fid' => '11',
  'uid' => '17',
  'value' => 'Anonymous donor',
))
->values(array(
  'fid' => '12',
  'uid' => '2',
  'value' => "AC/DC\n,,Eagles\r\nElton John,Lemonheads\r\n\r\nRolling Stones\rQueen\nThe White Stripes",
))
->values(array(
  'fid' => '12',
  'uid' => '8',
  'value' => "Deep Purple\nWho\nThe Beatles",
))
->values(array(
  'fid' => '12',
  'uid' => '15',
  'value' => "ABBA\nBoney M",
))
->values(array(
  'fid' => '12',
  'uid' => '16',
  'value' => "Van Halen\nDave M",
))
->values(array(
  'fid' => '12',
  'uid' => '17',
  'value' => "Toto\nJohn Denver",
))
->values(array(
  'fid' => '13',
  'uid' => '2',
  'value' => 'http://example.com/blog',
))
->values(array(
  'fid' => '13',
  'uid' => '8',
  'value' => 'http://blog.example.com',
))
->values(array(
  'fid' => '13',
  'uid' => '15',
  'value' => 'http://example.com/journal',
))
->values(array(
  'fid' => '13',
  'uid' => '16',
  'value' => 'http://example.com/monkeys',
))
->values(array(
  'fid' => '13',
  'uid' => '17',
  'value' => 'http://example.com/penguins',
))
->values(array(
  'fid' => '14',
  'uid' => '2',
  'value' => 'a:3:{s:5:"month";s:1:"6";s:3:"day";s:1:"2";s:4:"year";s:4:"1974";}',
))
->values(array(
  'fid' => '14',
  'uid' => '8',
  'value' => 'a:3:{s:5:"month";s:1:"9";s:3:"day";s:1:"9";s:4:"year";s:4:"1980";}',
))
->values(array(
  'fid' => '14',
  'uid' => '15',
  'value' => 'a:3:{s:5:"month";s:2:"11";s:3:"day";s:2:"25";s:4:"year";s:4:"1982";}',
))
->values(array(
  'fid' => '14',
  'uid' => '16',
  'value' => 'a:3:{s:5:"month";s:1:"9";s:3:"day";s:2:"23";s:4:"year";s:4:"1939";}',
))
->values(array(
  'fid' => '14',
  'uid' => '17',
  'value' => 'a:3:{s:5:"month";s:2:"12";s:3:"day";s:2:"18";s:4:"year";s:4:"1942";}',
))
->execute();

$connection->schema()->createTable('role', array(
  'fields' => array(
    'rid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'rid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('role')
->fields(array(
  'rid',
  'name',
))
->values(array(
  'rid' => '1',
  'name' => 'anonymous user',
))
->values(array(
  'rid' => '2',
  'name' => 'authenticated user',
))
->values(array(
  'rid' => '3',
  'name' => 'migrate test role 1',
))
->values(array(
  'rid' => '4',
  'name' => 'migrate test role 2',
))
->values(array(
  'rid' => '5',
  'name' => 'migrate test role 3 that is longer than thirty two characters',
))
->execute();

$connection->schema()->createTable('semaphore', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'value' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'expire' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '10',
      'scale' => '0',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('sessions', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'sid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'session' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'sid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('system', array(
  'fields' => array(
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'owner' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'throttle' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'bootstrap' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'schema_version' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '-1',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'info' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'filename',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('system')
->fields(array(
  'filename',
  'name',
  'type',
  'owner',
  'status',
  'throttle',
  'bootstrap',
  'schema_version',
  'weight',
  'info',
))
->values(array(
  'filename' => 'modules/aggregator/aggregator.module',
  'name' => 'aggregator',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Aggregator";s:11:"description";s:57:"Aggregates syndicated content (RSS, RDF, and Atom feeds).";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/block/block.module',
  'name' => 'block',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:5:"Block";s:11:"description";s:62:"Controls the boxes that are displayed around the main content.";s:7:"package";s:15:"Core - required";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/blog/blog.module',
  'name' => 'blog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Blog";s:11:"description";s:69:"Enables keeping easily and regularly updated user web pages or blogs.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/blogapi/blogapi.module',
  'name' => 'blogapi',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Blog API";s:11:"description";s:79:"Allows users to post content using applications that support XML-RPC blog APIs.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/book/book.module',
  'name' => 'book',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6000',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Book";s:11:"description";s:63:"Allows users to structure site pages in a hierarchy or outline.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/color/color.module',
  'name' => 'color',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:5:"Color";s:11:"description";s:61:"Allows the user to change the color scheme of certain themes.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/comment/comment.module',
  'name' => 'comment',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6005',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Comment";s:11:"description";s:57:"Allows users to comment on and discuss published content.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/contact/contact.module',
  'name' => 'contact',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Contact";s:11:"description";s:61:"Enables the use of both personal and site-wide contact forms.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/dblog/dblog.module',
  'name' => 'dblog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:16:"Database logging";s:11:"description";s:47:"Logs and records system events to the database.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/filter/filter.module',
  'name' => 'filter',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"Filter";s:11:"description";s:60:"Handles the filtering of content in preparation for display.";s:7:"package";s:15:"Core - required";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/forum/forum.module',
  'name' => 'forum',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:5:"Forum";s:11:"description";s:50:"Enables threaded discussions about general topics.";s:12:"dependencies";a:2:{i:0;s:8:"taxonomy";i:1;s:7:"comment";}s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/help/help.module',
  'name' => 'help',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Help";s:11:"description";s:35:"Manages the display of online help.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/locale/locale.module',
  'name' => 'locale',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6007',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"Locale";s:11:"description";s:119:"Adds language handling functionality and enables the translation of the user interface to languages other than English.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/menu/menu.module',
  'name' => 'menu',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6000',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Menu";s:11:"description";s:60:"Allows administrators to customize the site navigation menu.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/node/node.module',
  'name' => 'node',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Node";s:11:"description";s:66:"Allows content to be submitted to the site and displayed on pages.";s:7:"package";s:15:"Core - required";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/openid/openid.module',
  'name' => 'openid',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"OpenID";s:11:"description";s:48:"Allows users to log into your site using OpenID.";s:7:"version";s:4:"6.37";s:7:"package";s:15:"Core - optional";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/path/path.module',
  'name' => 'path',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Path";s:11:"description";s:28:"Allows users to rename URLs.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/php/php.module',
  'name' => 'php',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"PHP filter";s:11:"description";s:50:"Allows embedded PHP code/snippets to be evaluated.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/ping/ping.module',
  'name' => 'ping',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Ping";s:11:"description";s:51:"Alerts other sites when your site has been updated.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/poll/poll.module',
  'name' => 'poll',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Poll";s:11:"description";s:95:"Allows your site to capture votes on different topics in the form of multiple choice questions.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/profile/profile.module',
  'name' => 'profile',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Profile";s:11:"description";s:36:"Supports configurable user profiles.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/search/search.module',
  'name' => 'search',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"Search";s:11:"description";s:36:"Enables site-wide keyword searching.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/statistics/statistics.module',
  'name' => 'statistics',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Statistics";s:11:"description";s:37:"Logs access statistics for your site.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/syslog/syslog.module',
  'name' => 'syslog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"Syslog";s:11:"description";s:41:"Logs and records system events to syslog.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/system/system.module',
  'name' => 'system',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6055',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"System";s:11:"description";s:54:"Handles general site configuration for administrators.";s:7:"package";s:15:"Core - required";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/taxonomy/taxonomy.module',
  'name' => 'taxonomy',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Taxonomy";s:11:"description";s:38:"Enables the categorization of content.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/throttle/throttle.module',
  'name' => 'throttle',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Throttle";s:11:"description";s:66:"Handles the auto-throttling mechanism, to control site congestion.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/tracker/tracker.module',
  'name' => 'tracker',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Tracker";s:11:"description";s:43:"Enables tracking of recent posts for users.";s:12:"dependencies";a:1:{i:0;s:7:"comment";}s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/translation/translation.module',
  'name' => 'translation',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:19:"Content translation";s:11:"description";s:57:"Allows content to be translated into different languages.";s:12:"dependencies";a:1:{i:0;s:6:"locale";}s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/trigger/trigger.module',
  'name' => 'trigger',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Trigger";s:11:"description";s:90:"Enables actions to be fired on certain system events, such as when new content is created.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/update/update.module',
  'name' => 'update',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:13:"Update status";s:11:"description";s:88:"Checks the status of available updates for Drupal and your installed modules and themes.";s:7:"version";s:4:"6.37";s:7:"package";s:15:"Core - optional";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/upload/upload.module',
  'name' => 'upload',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6000',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"Upload";s:11:"description";s:51:"Allows users to upload and attach files to content.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/user/user.module',
  'name' => 'user',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"User";s:11:"description";s:47:"Manages the user registration and login system.";s:7:"package";s:15:"Core - required";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/content.module',
  'name' => 'content',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6010',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Content";s:11:"description";s:50:"Allows administrators to define new content types.";s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/content_copy/content_copy.module',
  'name' => 'content_copy',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:12:"Content Copy";s:11:"description";s:51:"Enables ability to import/export field definitions.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/content_permissions/content_permissions.module',
  'name' => 'content_permissions',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:19:"Content Permissions";s:11:"description";s:43:"Set field-level permissions for CCK fields.";s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/fieldgroup/fieldgroup.module',
  'name' => 'fieldgroup',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Fieldgroup";s:11:"description";s:37:"Create display groups for CCK fields.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/nodereference/nodereference.module',
  'name' => 'nodereference',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"Node Reference";s:11:"description";s:59:"Defines a field type for referencing one node from another.";s:12:"dependencies";a:3:{i:0;s:7:"content";i:1;s:4:"text";i:2;s:13:"optionwidgets";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/number/number.module',
  'name' => 'number',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6000',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"Number";s:11:"description";s:28:"Defines numeric field types.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/optionwidgets/optionwidgets.module',
  'name' => 'optionwidgets',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"Option Widgets";s:11:"description";s:82:"Defines selection, check box and radio button widgets for text and numeric fields.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/text/text.module',
  'name' => 'text',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6003',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Text";s:11:"description";s:32:"Defines simple text field types.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/userreference/userreference.module',
  'name' => 'userreference',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"User Reference";s:11:"description";s:56:"Defines a field type for referencing a user from a node.";s:12:"dependencies";a:3:{i:0;s:7:"content";i:1;s:4:"text";i:2;s:13:"optionwidgets";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date/date.module',
  'name' => 'date',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6005',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Date";s:11:"description";s:41:"Defines CCK date/time fields and widgets.";s:12:"dependencies";a:3:{i:0;s:7:"content";i:1;s:8:"date_api";i:2;s:13:"date_timezone";}s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1396284252";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_api.module',
  'name' => 'date_api',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6006',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Date API";s:11:"description";s:45:"A Date API that can be used by other modules.";s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1396284252";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_locale/date_locale.module',
  'name' => 'date_locale',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:11:"Date Locale";s:11:"description";s:124:"Allows the site admin to configure multiple formats for date/time display to tailor dates for a specific locale or audience.";s:7:"package";s:9:"Date/Time";s:12:"dependencies";a:2:{i:0;s:8:"date_api";i:1;s:6:"locale";}s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1396284252";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_php4/date_php4.module',
  'name' => 'date_php4',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:9:"Date PHP4";s:11:"description";s:134:"Emulate PHP 5.2 date functions in PHP 4.x, PHP 5.0, and PHP 5.1. Required when using the Date API with PHP versions less than PHP 5.2.";s:7:"package";s:9:"Date/Time";s:12:"dependencies";a:1:{i:0;s:8:"date_api";}s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1396284252";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_popup/date_popup.module',
  'name' => 'date_popup',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Date Popup";s:11:"description";s:84:"Enables jquery popup calendars and time entry widgets for selecting dates and times.";s:12:"dependencies";a:3:{i:0;s:8:"date_api";i:1;s:13:"date_timezone";i:2;s:9:"jquery_ui";}s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1396284252";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_repeat/date_repeat.module',
  'name' => 'date_repeat',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:15:"Date Repeat API";s:11:"description";s:73:"A Date Repeat API to calculate repeating dates and times from iCal rules.";s:12:"dependencies";a:1:{i:0;s:8:"date_api";}s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1396284252";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_timezone/date_timezone.module',
  'name' => 'date_timezone',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '5200',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:13:"Date Timezone";s:11:"description";s:111:"Needed when using Date API. Overrides site and user timezone handling to set timezone names instead of offsets.";s:7:"package";s:9:"Date/Time";s:12:"dependencies";a:1:{i:0;s:8:"date_api";}s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1396284252";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_tools/date_tools.module',
  'name' => 'date_tools',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Date Tools";s:11:"description";s:52:"Tools to import and auto-create dates and calendars.";s:12:"dependencies";a:2:{i:0;s:7:"content";i:1;s:4:"date";}s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1396284252";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/ddblock/ddblock.module',
  'name' => 'ddblock',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:7:{s:4:"name";s:21:"Dynamic display block";s:11:"description";s:36:"Displays dynamic content in a block.";s:4:"core";s:3:"6.x";s:12:"dependencies";a:1:{i:0;s:13:"jquery_update";}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/devel/devel.module',
  'name' => 'devel',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:5:"Devel";s:11:"description";s:52:"Various blocks, pages, and functions for developers.";s:7:"package";s:11:"Development";s:12:"dependencies";a:1:{i:0;s:4:"menu";}s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-1.28";s:7:"project";s:5:"devel";s:9:"datestamp";s:10:"1391635706";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/devel/devel_generate.module',
  'name' => 'devel_generate',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"Devel generate";s:11:"description";s:48:"Generate dummy users, nodes, and taxonomy terms.";s:7:"package";s:11:"Development";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-1.28";s:7:"project";s:5:"devel";s:9:"datestamp";s:10:"1391635706";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/devel/devel_node_access.module',
  'name' => 'devel_node_access',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:17:"Devel node access";s:11:"description";s:67:"Developer block and page illustrating relevant node_access records.";s:7:"package";s:11:"Development";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-1.28";s:7:"project";s:5:"devel";s:9:"datestamp";s:10:"1391635706";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/email/email.module',
  'name' => 'email',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:5:"Email";s:11:"description";s:35:"Defines an email field type for cck";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.4";s:7:"project";s:5:"email";s:9:"datestamp";s:10:"1354093658";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/event/contrib/calendarsignup/calendarsignup.module',
  'name' => 'calendarsignup',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:15:"Calendar Signup";s:11:"description";s:44:"Add signup forms in an event.module calendar";s:7:"package";s:5:"Event";s:12:"dependencies";a:2:{i:0;s:5:"event";i:1;s:6:"signup";}s:4:"core";s:3:"6.x";s:7:"version";s:11:"6.x-2.x-dev";s:7:"project";s:5:"event";s:9:"datestamp";s:10:"1425082685";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/event/contrib/datepicker/datepicker.module',
  'name' => 'datepicker',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:11:"Date Picker";s:11:"description";s:40:"Add a date picker to event module forms.";s:7:"package";s:5:"Event";s:12:"dependencies";a:1:{i:0;s:5:"event";}s:4:"core";s:3:"6.x";s:7:"version";s:11:"6.x-2.x-dev";s:7:"project";s:5:"event";s:9:"datestamp";s:10:"1425082685";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/event/event.module',
  'name' => 'event',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6005',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:5:"Event";s:11:"description";s:44:"Calendaring API, calendar display and export";s:7:"package";s:5:"Event";s:4:"core";s:3:"6.x";s:7:"version";s:11:"6.x-2.x-dev";s:7:"project";s:5:"event";s:9:"datestamp";s:10:"1425082685";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/filefield/filefield.module',
  'name' => 'filefield',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6104',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:9:"FileField";s:11:"description";s:26:"Defines a file field type.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:3:"php";s:3:"5.0";s:7:"version";s:8:"6.x-3.13";s:7:"project";s:9:"filefield";s:9:"datestamp";s:10:"1405541029";s:10:"dependents";a:0:{}}',
))
->values(array(
  'filename' => 'sites/all/modules/filefield/filefield_meta/filefield_meta.module',
  'name' => 'filefield_meta',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"FileField Meta";s:11:"description";s:48:"Add metadata gathering and storage to FileField.";s:12:"dependencies";a:2:{i:0;s:9:"filefield";i:1;s:6:"getid3";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:3:"php";s:3:"5.0";s:7:"version";s:8:"6.x-3.13";s:7:"project";s:9:"filefield";s:9:"datestamp";s:10:"1405541029";s:10:"dependents";a:0:{}}',
))
->values(array(
  'filename' => 'sites/all/modules/imageapi/imageapi.module',
  'name' => 'imageapi',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"ImageAPI";s:11:"description";s:38:"ImageAPI supporting multiple toolkits.";s:7:"package";s:10:"ImageCache";s:4:"core";s:3:"6.x";s:3:"php";s:3:"5.1";s:7:"version";s:8:"6.x-1.10";s:7:"project";s:8:"imageapi";s:9:"datestamp";s:10:"1305563215";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}}',
))
->values(array(
  'filename' => 'sites/all/modules/imageapi/imageapi_gd.module',
  'name' => 'imageapi_gd',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:10:{s:4:\"name\";s:12:\"ImageAPI GD2\";s:11:\"description\";s:49:\"Uses PHP's built-in GD2 image processing support.\";s:7:\"package\";s:10:\"ImageCache\";s:4:\"core\";s:3:\"6.x\";s:7:\"version\";s:8:\"6.x-1.10\";s:7:\"project\";s:8:\"imageapi\";s:9:\"datestamp\";s:10:\"1305563215\";s:12:\"dependencies\";a:0:{}s:10:\"dependents\";a:0:{}s:3:\"php\";s:5:\"4.3.5\";}",
))
->values(array(
  'filename' => 'sites/all/modules/imageapi/imageapi_imagemagick.module',
  'name' => 'imageapi_imagemagick',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:20:"ImageAPI ImageMagick";s:11:"description";s:33:"Command Line ImageMagick support.";s:7:"package";s:10:"ImageCache";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-1.10";s:7:"project";s:8:"imageapi";s:9:"datestamp";s:10:"1305563215";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/imagecache/imagecache.module',
  'name' => 'imagecache',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"ImageCache";s:11:"description";s:36:"Dynamic image manipulator and cache.";s:7:"package";s:10:"ImageCache";s:12:"dependencies";a:1:{i:0;s:8:"imageapi";}s:4:"core";s:3:"6.x";s:7:"version";s:11:"6.x-2.0-rc1";s:7:"project";s:10:"imagecache";s:9:"datestamp";s:10:"1337742655";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/imagecache/imagecache_ui.module',
  'name' => 'imagecache_ui',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:13:"ImageCache UI";s:11:"description";s:26:"ImageCache User Interface.";s:12:"dependencies";a:2:{i:0;s:10:"imagecache";i:1;s:8:"imageapi";}s:7:"package";s:10:"ImageCache";s:4:"core";s:3:"6.x";s:7:"version";s:11:"6.x-2.0-rc1";s:7:"project";s:10:"imagecache";s:9:"datestamp";s:10:"1337742655";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/imagefield/imagefield.module',
  'name' => 'imagefield',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6006',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"ImageField";s:11:"description";s:28:"Defines an image field type.";s:4:"core";s:3:"6.x";s:12:"dependencies";a:2:{i:0;s:7:"content";i:1;s:9:"filefield";}s:7:"package";s:3:"CCK";s:7:"version";s:8:"6.x-3.11";s:7:"project";s:10:"imagefield";s:9:"datestamp";s:10:"1365969012";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/link/link.module',
  'name' => 'link',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6002',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:4:"Link";s:11:"description";s:32:"Defines simple link field types.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:5:"files";a:1:{i:0;s:16:"link.migrate.inc";}s:7:"version";s:8:"6.x-2.11";s:7:"project";s:4:"link";s:9:"datestamp";s:10:"1393559923";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/nodeaccess/nodeaccess.module',
  'name' => 'nodeaccess',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:10:"Nodeaccess";s:11:"description";s:32:"Provides per node access control";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.5";s:7:"project";s:10:"nodeaccess";s:9:"datestamp";s:10:"1412640229";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/phone/phone.module',
  'name' => 'phone',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6200',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:11:"Phone - CCK";s:11:"description";s:84:"The phone module allows administrators to define a CCK field type for phone numbers.";s:7:"package";s:3:"CCK";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.18";s:7:"project";s:5:"phone";s:9:"datestamp";s:10:"1294067495";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_test.module',
  'name' => 'views_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:10:"Views Test";s:11:"description";s:22:"Test module for Views.";s:7:"package";s:5:"Views";s:4:"core";s:3:"6.x";s:12:"dependencies";a:1:{i:0;s:5:"views";}s:6:"hidden";b:1;s:5:"files";a:2:{i:0;s:17:"views_test.module";i:1;s:18:"views_test.install";}s:7:"version";s:7:"6.x-3.0";s:7:"project";s:5:"views";s:9:"datestamp";s:10:"1325638545";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/views/views.module',
  'name' => 'views',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:5:"Views";s:11:"description";s:55:"Create customized lists and queries from your database.";s:7:"package";s:5:"Views";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-3.0";s:7:"project";s:5:"views";s:9:"datestamp";s:10:"1325638545";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/views/views_export/views_export.module',
  'name' => 'views_export',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"Views exporter";s:11:"description";s:40:"Allows exporting multiple views at once.";s:7:"package";s:5:"Views";s:12:"dependencies";a:1:{i:0;s:5:"views";}s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-3.0";s:7:"project";s:5:"views";s:9:"datestamp";s:10:"1325638545";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/views/views_ui.module',
  'name' => 'views_ui',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Views UI";s:11:"description";s:93:"Administrative interface to views. Without this module, you cannot create or edit your views.";s:7:"package";s:5:"Views";s:4:"core";s:3:"6.x";s:12:"dependencies";a:1:{i:0;s:5:"views";}s:7:"version";s:7:"6.x-3.0";s:7:"project";s:5:"views";s:9:"datestamp";s:10:"1325638545";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'themes/bluemarine/bluemarine.info',
  'name' => 'bluemarine',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Bluemarine";s:11:"description";s:66:"Table-based multi-column theme with a marine and ash color scheme.";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/bluemarine/script.js";}s:10:"screenshot";s:32:"themes/bluemarine/screenshot.png";s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'themes/chameleon/chameleon.info',
  'name' => 'chameleon',
  'type' => 'theme',
  'owner' => 'themes/chameleon/chameleon.theme',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:9:"Chameleon";s:11:"description";s:42:"Minimalist tabled theme with light colors.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:8:"features";a:4:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:7:"scripts";a:1:{s:9:"script.js";s:26:"themes/chameleon/script.js";}s:10:"screenshot";s:31:"themes/chameleon/screenshot.png";s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'themes/chameleon/marvin/marvin.info',
  'name' => 'marvin',
  'type' => 'theme',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:6:"Marvin";s:11:"description";s:31:"Boxy tabled theme in all grays.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:10:"base theme";s:9:"chameleon";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/chameleon/marvin/script.js";}s:10:"screenshot";s:38:"themes/chameleon/marvin/screenshot.png";s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'themes/garland/garland.info',
  'name' => 'garland',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:7:"Garland";s:11:"description";s:66:"Tableless, recolorable, multi-column, fluid width theme (default).";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:24:"themes/garland/script.js";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'themes/garland/minnelli/minnelli.info',
  'name' => 'minnelli',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:8:"Minnelli";s:11:"description";s:56:"Tableless, recolorable, multi-column, fixed width theme.";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:10:"base theme";s:7:"garland";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/garland/minnelli/script.js";}s:10:"screenshot";s:38:"themes/garland/minnelli/screenshot.png";s:3:"php";s:5:"4.3.5";s:6:"engine";s:11:"phptemplate";}',
))
->values(array(
  'filename' => 'themes/pushbutton/pushbutton.info',
  'name' => 'pushbutton',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Pushbutton";s:11:"description";s:52:"Tabled, multi-column theme in blue and orange tones.";s:7:"version";s:4:"6.37";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1440020160";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/pushbutton/script.js";}s:10:"screenshot";s:32:"themes/pushbutton/screenshot.png";s:3:"php";s:5:"4.3.5";}',
))
->execute();

$connection->schema()->createTable('term_data', array(
  'fields' => array(
    'tid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'tid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('term_data')
->fields(array(
  'tid',
  'vid',
  'name',
  'description',
  'weight',
))
->values(array(
  'tid' => '1',
  'vid' => '1',
  'name' => 'term 1 of vocabulary 1',
  'description' => 'description of term 1 of vocabulary 1',
  'weight' => '0',
))
->values(array(
  'tid' => '2',
  'vid' => '2',
  'name' => 'term 2 of vocabulary 2',
  'description' => 'description of term 2 of vocabulary 2',
  'weight' => '3',
))
->values(array(
  'tid' => '3',
  'vid' => '2',
  'name' => 'term 3 of vocabulary 2',
  'description' => 'description of term 3 of vocabulary 2',
  'weight' => '4',
))
->values(array(
  'tid' => '4',
  'vid' => '3',
  'name' => 'term 4 of vocabulary 3',
  'description' => 'description of term 4 of vocabulary 3',
  'weight' => '6',
))
->values(array(
  'tid' => '5',
  'vid' => '3',
  'name' => 'term 5 of vocabulary 3',
  'description' => 'description of term 5 of vocabulary 3',
  'weight' => '7',
))
->values(array(
  'tid' => '6',
  'vid' => '3',
  'name' => 'term 6 of vocabulary 3',
  'description' => 'description of term 6 of vocabulary 3',
  'weight' => '8',
))
->execute();

$connection->schema()->createTable('term_hierarchy', array(
  'fields' => array(
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'parent' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'tid',
    'parent',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('term_hierarchy')
->fields(array(
  'tid',
  'parent',
))
->values(array(
  'tid' => '1',
  'parent' => '0',
))
->values(array(
  'tid' => '2',
  'parent' => '0',
))
->values(array(
  'tid' => '4',
  'parent' => '0',
))
->values(array(
  'tid' => '3',
  'parent' => '2',
))
->values(array(
  'tid' => '5',
  'parent' => '4',
))
->values(array(
  'tid' => '6',
  'parent' => '4',
))
->values(array(
  'tid' => '6',
  'parent' => '5',
))
->execute();

$connection->schema()->createTable('term_node', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
    'tid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('term_node')
->fields(array(
  'nid',
  'vid',
  'tid',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'tid' => '1',
))
->values(array(
  'nid' => '2',
  'vid' => '3',
  'tid' => '2',
))
->values(array(
  'nid' => '2',
  'vid' => '3',
  'tid' => '3',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '4',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '5',
))
->execute();

$connection->schema()->createTable('term_relation', array(
  'fields' => array(
    'trid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'tid1' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'tid2' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'trid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('term_synonym', array(
  'fields' => array(
    'tsid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'tsid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('upload', array(
  'fields' => array(
    'fid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'description' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'list' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'fid',
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('upload')
->fields(array(
  'fid',
  'nid',
  'vid',
  'description',
  'list',
  'weight',
))
->values(array(
  'fid' => '1',
  'nid' => '1',
  'vid' => '1',
  'description' => 'file 1-1-1',
  'list' => '0',
  'weight' => '-1',
))
->values(array(
  'fid' => '2',
  'nid' => '1',
  'vid' => '2',
  'description' => 'file 1-2-2',
  'list' => '1',
  'weight' => '4',
))
->values(array(
  'fid' => '2',
  'nid' => '2',
  'vid' => '3',
  'description' => 'file 2-3-2',
  'list' => '1',
  'weight' => '2',
))
->values(array(
  'fid' => '3',
  'nid' => '1',
  'vid' => '2',
  'description' => 'file 1-2-3',
  'list' => '0',
  'weight' => '3',
))
->values(array(
  'fid' => '3',
  'nid' => '2',
  'vid' => '3',
  'description' => 'file 2-3-3',
  'list' => '0',
  'weight' => '1',
))
->execute();

$connection->schema()->createTable('url_alias', array(
  'fields' => array(
    'pid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'src' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'dst' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'pid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('url_alias')
->fields(array(
  'pid',
  'src',
  'dst',
  'language',
))
->values(array(
  'pid' => '1',
  'src' => 'node/1',
  'dst' => 'alias-one',
  'language' => 'af',
))
->values(array(
  'pid' => '2',
  'src' => 'node/2',
  'dst' => 'alias-two',
  'language' => 'en',
))
->values(array(
  'pid' => '3',
  'src' => 'node/3',
  'dst' => 'alias-three',
  'language' => '',
))
->execute();

$connection->schema()->createTable('users', array(
  'fields' => array(
    'uid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '60',
      'default' => '',
    ),
    'pass' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'mail' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '64',
      'default' => '',
    ),
    'mode' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'sort' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
    ),
    'threshold' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
    ),
    'theme' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'signature' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'signature_format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'access' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'login' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'timezone' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '8',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'picture' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'init' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '64',
      'default' => '',
    ),
    'data' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'timezone_name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '50',
      'default' => '',
    ),
    'pass_plain' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'expected_timezone' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '50',
    ),
    'timezone_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'uid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('users')
->fields(array(
  'uid',
  'name',
  'pass',
  'mail',
  'mode',
  'sort',
  'threshold',
  'theme',
  'signature',
  'signature_format',
  'created',
  'access',
  'login',
  'status',
  'timezone',
  'language',
  'picture',
  'init',
  'data',
  'timezone_name',
  'pass_plain',
  'expected_timezone',
  'timezone_id',
))
->values(array(
  'uid' => '1',
  'name' => 'root',
  'pass' => '63a9f0ea7bb98050796b649e85481845',
  'mail' => 'root@localhost',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => '',
  'signature_format' => '0',
  'created' => '0',
  'access' => '1444943005',
  'login' => '1444943005',
  'status' => '1',
  'timezone' => NULL,
  'language' => '',
  'picture' => '',
  'init' => 'root@localhost',
  'data' => 'b:0;',
  'timezone_name' => '',
  'pass_plain' => 'root',
  'expected_timezone' => NULL,
  'timezone_id' => '0',
))
->values(array(
  'uid' => '2',
  'name' => 'john.doe',
  'pass' => '671cc45b3e2c6eb751d6a554dc5a5fe7',
  'mail' => 'john.doe@example.com',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => 'John Doe | john.doe@example.com',
  'signature_format' => '1',
  'created' => '1391150052',
  'access' => '1391259672',
  'login' => '1391152253',
  'status' => '1',
  'timezone' => '3600',
  'language' => 'fr',
  'picture' => 'core/modules/simpletest/files/image-test.jpg',
  'init' => 'doe@example.com',
  'data' => 'a:2:{s:7:"contact";i:1;s:13:"form_build_id";s:48:"form-qu_DMjE-Vfg01arT5J4VbuBCkOgx_LeySJx4qrPOSuA";}',
  'timezone_name' => 'Europe/Berlin',
  'pass_plain' => 'john.doe_pass',
  'expected_timezone' => 'Europe/Berlin',
  'timezone_id' => '1',
))
->values(array(
  'uid' => '8',
  'name' => 'joe.roe',
  'pass' => '93a70546e6c032c135499fed70cfe438',
  'mail' => 'joe.roe@example.com',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => 'JR',
  'signature_format' => '2',
  'created' => '1391150053',
  'access' => '1391259673',
  'login' => '1391152254',
  'status' => '1',
  'timezone' => '7200',
  'language' => 'ro',
  'picture' => 'core/modules/simpletest/files/image-test.png',
  'init' => 'roe@example.com',
  'data' => 'a:2:{s:7:"contact";i:0;s:13:"form_build_id";s:48:"form-1TxjbL2_1dEHIxEu2Db6OvEsSN1x9ILH1VCgnvsO6LE";}',
  'timezone_name' => 'Europe/Helsinki',
  'pass_plain' => 'joe.roe_pass',
  'expected_timezone' => 'Europe/Helsinki',
  'timezone_id' => '0',
))
->values(array(
  'uid' => '15',
  'name' => 'joe.bloggs',
  'pass' => '2ff23139aeb404274dc67cbee8c64fb0',
  'mail' => 'joe.bloggs@example.com',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => 'bloggs',
  'signature_format' => '1',
  'created' => '1391150054',
  'access' => '1391259674',
  'login' => '1391152255',
  'status' => '1',
  'timezone' => '-28800',
  'language' => 'en',
  'picture' => '',
  'init' => 'bloggs@example.com',
  'data' => 'a:0:{}',
  'timezone_name' => 'America/Anchorage',
  'pass_plain' => 'joe.bloggs_pass',
  'expected_timezone' => NULL,
  'timezone_id' => '0',
))
->values(array(
  'uid' => '16',
  'name' => 'sal.saraniti',
  'pass' => '77404657c8bcd8e9aa8f3147856efb4f',
  'mail' => 'sal.saraniti@example.com',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => '',
  'signature_format' => '0',
  'created' => '1391151054',
  'access' => '1391259574',
  'login' => '1391162255',
  'status' => '1',
  'timezone' => '0',
  'language' => 'en',
  'picture' => '',
  'init' => 'sal.saraniti@example.com',
  'data' => 'a:0:{}',
  'timezone_name' => 'UTC',
  'pass_plain' => 'sal.saraniti',
  'expected_timezone' => NULL,
  'timezone_id' => '0',
))
->values(array(
  'uid' => '17',
  'name' => 'terry.saraniti',
  'pass' => '8fb310d3ec746d720e0e8efefd0cce5c',
  'mail' => 'terry.saraniti@example.com',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => '',
  'signature_format' => '0',
  'created' => '1390151054',
  'access' => '1390259574',
  'login' => '1390162255',
  'status' => '1',
  'timezone' => NULL,
  'language' => 'en',
  'picture' => '',
  'init' => 'terry.saraniti@example.com',
  'data' => 'a:0:{}',
  'timezone_name' => NULL,
  'pass_plain' => 'terry.saraniti',
  'expected_timezone' => NULL,
  'timezone_id' => '0',
))
->execute();

$connection->schema()->createTable('users_roles', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'uid',
    'rid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('users_roles')
->fields(array(
  'uid',
  'rid',
))
->values(array(
  'uid' => '2',
  'rid' => '3',
))
->values(array(
  'uid' => '15',
  'rid' => '3',
))
->values(array(
  'uid' => '16',
  'rid' => '3',
))
->values(array(
  'uid' => '8',
  'rid' => '4',
))
->values(array(
  'uid' => '15',
  'rid' => '4',
))
->values(array(
  'uid' => '17',
  'rid' => '4',
))
->values(array(
  'uid' => '8',
  'rid' => '5',
))
->values(array(
  'uid' => '15',
  'rid' => '5',
))
->values(array(
  'uid' => '16',
  'rid' => '5',
))
->execute();

$connection->schema()->createTable('variable', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'value' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('variable')
->fields(array(
  'name',
  'value',
))
->values(array(
  'name' => 'actions_max_stack',
  'value' => 'i:35;',
))
->values(array(
  'name' => 'admin_compact_mode',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'aggregator_allowed_html_tags',
  'value' => 's:70:"<a> <b> <br /> <dd> <dl> <dt> <em> <i> <li> <ol> <p> <strong> <u> <ul>";',
))
->values(array(
  'name' => 'aggregator_clear',
  'value' => 's:7:"9676800";',
))
->values(array(
  'name' => 'aggregator_fetcher',
  'value' => 's:10:"aggregator";',
))
->values(array(
  'name' => 'aggregator_parser',
  'value' => 's:10:"aggregator";',
))
->values(array(
  'name' => 'aggregator_processors',
  'value' => 'a:1:{i:0;s:10:"aggregator";}',
))
->values(array(
  'name' => 'aggregator_summary_items',
  'value' => 's:1:"3";',
))
->values(array(
  'name' => 'aggregator_teaser_length',
  'value' => 's:3:"600";',
))
->values(array(
  'name' => 'allowed_html_1',
  'value' => 's:61:"<a> <em> <strong> <cite> <code> <ul> <ol> <li> <dl> <dt> <dd>";',
))
->values(array(
  'name' => 'allow_insecure_uploads',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'anonymous',
  'value' => 's:5:"Guest";',
))
->values(array(
  'name' => 'book_allowed_types',
  'value' => 'a:1:{i:0;s:4:"book";}',
))
->values(array(
  'name' => 'book_block_mode',
  'value' => 's:9:"all pages";',
))
->values(array(
  'name' => 'book_child_type',
  'value' => 's:4:"book";',
))
->values(array(
  'name' => 'cache_lifetime',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_article',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_company',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_employee',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_page',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_sponsor',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_story',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_anonymous_test_event',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_test_page',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_test_planet',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_test_story',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_article',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_controls_article',
  'value' => 'i:3;',
))
->values(array(
  'name' => 'comment_controls_company',
  'value' => 'i:3;',
))
->values(array(
  'name' => 'comment_controls_employee',
  'value' => 'i:3;',
))
->values(array(
  'name' => 'comment_controls_page',
  'value' => 's:1:"3";',
))
->values(array(
  'name' => 'comment_controls_sponsor',
  'value' => 'i:3;',
))
->values(array(
  'name' => 'comment_controls_story',
  'value' => 'i:3;',
))
->values(array(
  'name' => 'comment_controls_test_event',
  'value' => 'i:3;',
))
->values(array(
  'name' => 'comment_controls_test_page',
  'value' => 'i:3;',
))
->values(array(
  'name' => 'comment_controls_test_planet',
  'value' => 'i:3;',
))
->values(array(
  'name' => 'comment_controls_test_story',
  'value' => 'i:3;',
))
->values(array(
  'name' => 'comment_default_mode_article',
  'value' => 'i:4;',
))
->values(array(
  'name' => 'comment_default_mode_company',
  'value' => 'i:4;',
))
->values(array(
  'name' => 'comment_default_mode_employee',
  'value' => 'i:4;',
))
->values(array(
  'name' => 'comment_default_mode_page',
  'value' => 's:1:"4";',
))
->values(array(
  'name' => 'comment_default_mode_sponsor',
  'value' => 'i:4;',
))
->values(array(
  'name' => 'comment_default_mode_story',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_default_mode_test_event',
  'value' => 'i:4;',
))
->values(array(
  'name' => 'comment_default_mode_test_page',
  'value' => 'i:4;',
))
->values(array(
  'name' => 'comment_default_mode_test_planet',
  'value' => 'i:4;',
))
->values(array(
  'name' => 'comment_default_mode_test_story',
  'value' => 'i:4;',
))
->values(array(
  'name' => 'comment_default_order_article',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_order_company',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_order_employee',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_order_page',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_default_order_sponsor',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_order_story',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_order_test_event',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_order_test_page',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_order_test_planet',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_order_test_story',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_per_page_article',
  'value' => 'i:50;',
))
->values(array(
  'name' => 'comment_default_per_page_company',
  'value' => 'i:50;',
))
->values(array(
  'name' => 'comment_default_per_page_employee',
  'value' => 'i:50;',
))
->values(array(
  'name' => 'comment_default_per_page_page',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_default_per_page_sponsor',
  'value' => 'i:50;',
))
->values(array(
  'name' => 'comment_default_per_page_story',
  'value' => 'i:70;',
))
->values(array(
  'name' => 'comment_default_per_page_test_event',
  'value' => 'i:50;',
))
->values(array(
  'name' => 'comment_default_per_page_test_page',
  'value' => 'i:50;',
))
->values(array(
  'name' => 'comment_default_per_page_test_planet',
  'value' => 'i:50;',
))
->values(array(
  'name' => 'comment_default_per_page_test_story',
  'value' => 'i:50;',
))
->values(array(
  'name' => 'comment_form_location_article',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_form_location_company',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_form_location_employee',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_form_location_page',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'comment_form_location_sponsor',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_form_location_story',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_form_location_test_event',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_form_location_test_page',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_form_location_test_planet',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_form_location_test_story',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_page',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'comment_preview_article',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_preview_company',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_preview_employee',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_preview_page',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_preview_sponsor',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_preview_story',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_preview_test_event',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_preview_test_page',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_preview_test_planet',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_preview_test_story',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_story',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_subject_field_article',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_company',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_employee',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_page',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_sponsor',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_story',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_subject_field_test_event',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_test_page',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_test_planet',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_test_story',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'configurable_timezones',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'contact_default_status',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'contact_hourly_threshold',
  'value' => 'i:3;',
))
->values(array(
  'name' => 'content_extra_weights_story',
  'value' => 'a:9:{s:5:"title";s:2:"-5";s:10:"body_field";s:2:"-2";s:20:"revision_information";s:2:"19";s:6:"author";s:2:"18";s:7:"options";s:2:"20";s:16:"comment_settings";s:2:"22";s:4:"menu";s:2:"-3";s:8:"taxonomy";s:2:"-4";s:11:"attachments";s:2:"21";}',
))
->values(array(
  'name' => 'content_extra_weights_test_page',
  'value' => 'a:8:{s:5:"title";s:2:"37";s:10:"body_field";s:2:"38";s:20:"revision_information";s:2:"40";s:6:"author";s:2:"39";s:7:"options";s:2:"41";s:16:"comment_settings";s:2:"42";s:4:"menu";s:2:"36";s:11:"attachments";s:2:"43";}',
))
->values(array(
  'name' => 'content_schema_version',
  'value' => 'i:6009;',
))
->values(array(
  'name' => 'cron_threshold_error',
  'value' => 'i:1209600;',
))
->values(array(
  'name' => 'cron_threshold_warning',
  'value' => 'i:172800;',
))
->values(array(
  'name' => 'css_js_query_string',
  'value' => 's:20:"SAkMTxRZndiw70000000";',
))
->values(array(
  'name' => 'date:story:4:field_test_datestamp_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:4:field_test_datestamp_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_datestamp_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_datestamp_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_datestamp_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:4:field_test_datetime_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:4:field_test_datetime_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_datetime_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_datetime_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_datetime_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:4:field_test_date_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:4:field_test_date_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_date_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_date_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_date_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:5:field_test_datestamp_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:5:field_test_datestamp_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_datestamp_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_datestamp_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_datestamp_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:5:field_test_datetime_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:5:field_test_datetime_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_datetime_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_datetime_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_datetime_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:5:field_test_date_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:5:field_test_date_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_date_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_date_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_date_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:full:field_test_datestamp_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:full:field_test_datestamp_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_datestamp_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_datestamp_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_datestamp_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:full:field_test_datetime_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:full:field_test_datetime_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_datetime_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_datetime_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_datetime_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:full:field_test_date_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:full:field_test_date_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_date_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_date_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_date_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datestamp_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datestamp_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datestamp_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datestamp_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datestamp_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datetime_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datetime_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datetime_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datetime_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datetime_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_date_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_date_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_date_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_date_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_date_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date_api_version',
  'value' => 's:3:"5.2";',
))
->values(array(
  'name' => 'date_default_timezone',
  'value' => 's:4:"3600";',
))
->values(array(
  'name' => 'date_first_day',
  'value' => 's:1:"4";',
))
->values(array(
  'name' => 'date_format_long',
  'value' => 's:24:"\L\O\N\G l, F j, Y - H:i";',
))
->values(array(
  'name' => 'date_format_medium',
  'value' => 's:27:"\M\E\D\I\U\M D, m/d/Y - H:i";',
))
->values(array(
  'name' => 'date_format_short',
  'value' => 's:22:"\S\H\O\R\T m/d/Y - H:i";',
))
->values(array(
  'name' => 'dblog_row_limit',
  'value' => 'i:10000;',
))
->values(array(
  'name' => 'drupal_badge_color',
  'value' => 's:12:"powered-blue";',
))
->values(array(
  'name' => 'drupal_badge_size',
  'value' => 's:5:"80x15";',
))
->values(array(
  'name' => 'drupal_http_request_fails',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'drupal_private_key',
  'value' => 's:43:"6bTz0JLHTM1R1c7VtbZtbio47JygBoNuGuzS5G0JYWs";',
))
->values(array(
  'name' => 'error_level',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'event_nodeapi_article',
  'value' => 's:5:"never";',
))
->values(array(
  'name' => 'event_nodeapi_event',
  'value' => 's:3:"all";',
))
->values(array(
  'name' => 'feed_default_items',
  'value' => 'i:10;',
))
->values(array(
  'name' => 'feed_item_length',
  'value' => 's:5:"title";',
))
->values(array(
  'name' => 'file_description_length',
  'value' => 'i:128;',
))
->values(array(
  'name' => 'file_description_type',
  'value' => 's:9:"textfield";',
))
->values(array(
  'name' => 'file_directory_path',
  'value' => 's:29:"core/modules/simpletest/files";',
))
->values(array(
  'name' => 'file_directory_temp',
  'value' => 's:10:"files/temp";',
))
->values(array(
  'name' => 'file_downloads',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'file_icon_directory',
  'value' => 's:25:"sites/default/files/icons";',
))
->values(array(
  'name' => 'filter_allowed_protocols',
  'value' => 'a:13:{i:0;s:4:"http";i:1;s:5:"https";i:2;s:3:"ftp";i:3;s:4:"news";i:4;s:4:"nntp";i:5;s:3:"tel";i:6;s:6:"telnet";i:7;s:6:"mailto";i:8;s:3:"irc";i:9;s:3:"ssh";i:10;s:4:"sftp";i:11;s:6:"webcal";i:12;s:4:"rtsp";}',
))
->values(array(
  'name' => 'filter_html_1',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'filter_html_help_1',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'filter_html_nofollow_1',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'filter_url_length_1',
  'value' => 's:2:"72";',
))
->values(array(
  'name' => 'form_build_id_article',
  'value' => 's:48:"form-mXZfFJxcCFGB80PPYtNOuwYbho6-xKTvrRLb3TAMkic";',
))
->values(array(
  'name' => 'forum_block_num_0',
  'value' => 's:1:"5";',
))
->values(array(
  'name' => 'forum_block_num_1',
  'value' => 's:1:"5";',
))
->values(array(
  'name' => 'forum_hot_topic',
  'value' => 's:2:"15";',
))
->values(array(
  'name' => 'forum_nav_vocabulary',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'forum_order',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'forum_per_page',
  'value' => 's:2:"25";',
))
->values(array(
  'name' => 'image_jpeg_quality',
  'value' => 'i:75;',
))
->values(array(
  'name' => 'image_toolkit',
  'value' => 's:2:"gd";',
))
->values(array(
  'name' => 'javascript_parsed',
  'value' => 'a:0:{}',
))
->values(array(
  'name' => 'language_content_type_article',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'language_count',
  'value' => 'i:2;',
))
->values(array(
  'name' => 'language_default',
  'value' => 'O:8:"stdClass":11:{s:8:"language";s:2:"en";s:4:"name";s:7:"English";s:6:"native";s:7:"English";s:9:"direction";s:1:"0";s:7:"enabled";i:1;s:7:"plurals";s:1:"0";s:7:"formula";s:0:"";s:6:"domain";s:0:"";s:6:"prefix";s:0:"";s:6:"weight";s:1:"0";s:10:"javascript";s:0:"";}',
))
->values(array(
  'name' => 'locale_cache_strings',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'locale_js_directory',
  'value' => 's:9:"languages";',
))
->values(array(
  'name' => 'menu_expanded',
  'value' => 'a:1:{i:0;s:15:"secondary-links";}',
))
->values(array(
  'name' => 'menu_masks',
  'value' => 'a:22:{i:0;i:127;i:1;i:63;i:2;i:62;i:3;i:61;i:4;i:59;i:5;i:31;i:6;i:30;i:7;i:29;i:8;i:24;i:9;i:21;i:10;i:15;i:11;i:14;i:12;i:13;i:13;i:12;i:14;i:11;i:15;i:7;i:16;i:6;i:17;i:5;i:18;i:4;i:19;i:3;i:20;i:2;i:21;i:1;}',
))
->values(array(
  'name' => 'menu_override_parent_selector',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'minimum_word_size',
  'value' => 's:1:"3";',
))
->values(array(
  'name' => 'node_admin_theme',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'node_options_article',
  'value' => 'a:1:{i:0;s:7:"promote";}',
))
->values(array(
  'name' => 'node_options_book',
  'value' => 'a:1:{i:0;s:6:"status";}',
))
->values(array(
  'name' => 'node_options_forum',
  'value' => 'a:1:{i:0;s:6:"status";}',
))
->values(array(
  'name' => 'node_options_test_event',
  'value' => 'a:2:{i:0;s:6:"sticky";i:1;s:8:"revision";}',
))
->values(array(
  'name' => 'node_options_test_page',
  'value' => 'a:3:{i:0;s:6:"status";i:1;s:7:"promote";i:2;s:6:"sticky";}',
))
->values(array(
  'name' => 'node_options_test_planet',
  'value' => 'a:2:{i:0;s:6:"sticky";i:1;s:8:"revision";}',
))
->values(array(
  'name' => 'node_options_test_story',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
))
->values(array(
  'name' => 'node_preview',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'node_rank_comments',
  'value' => 's:1:"5";',
))
->values(array(
  'name' => 'node_rank_promote',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'node_rank_recent',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'node_rank_relevance',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'node_rank_sticky',
  'value' => 's:1:"8";',
))
->values(array(
  'name' => 'node_rank_views',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'overlap_cjk',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'page_compression',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'preprocess_css',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'preprocess_js',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'search_cron_limit',
  'value' => 's:3:"100";',
))
->values(array(
  'name' => 'simpletest_clear_results',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'simpletest_httpauth_method',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'simpletest_httpauth_password',
  'value' => 'N;',
))
->values(array(
  'name' => 'simpletest_httpauth_username',
  'value' => 'N;',
))
->values(array(
  'name' => 'simpletest_verbose',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'site_403',
  'value' => 's:4:"user";',
))
->values(array(
  'name' => 'site_404',
  'value' => 's:14:"page-not-found";',
))
->values(array(
  'name' => 'site_frontpage',
  'value' => 's:4:"node";',
))
->values(array(
  'name' => 'site_mail',
  'value' => 's:21:"site_mail@example.com";',
))
->values(array(
  'name' => 'site_name',
  'value' => 's:9:"site_name";',
))
->values(array(
  'name' => 'site_offline',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'site_offline_message',
  'value' => 's:94:"Drupal is currently under maintenance. We should be back shortly. Thank you for your patience.";',
))
->values(array(
  'name' => 'site_slogan',
  'value' => 's:13:"Migrate rocks";',
))
->values(array(
  'name' => 'statistics_block_top_all_num',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'statistics_block_top_day_num',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'statistics_block_top_last_num',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'statistics_count_content_views',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'statistics_enable_access_log',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'statistics_flush_accesslog_timer',
  'value' => 'i:259200;',
))
->values(array(
  'name' => 'syslog_facility',
  'value' => 'i:128;',
))
->values(array(
  'name' => 'syslog_identity',
  'value' => 's:6:"drupal";',
))
->values(array(
  'name' => 'taxonomy_override_selector',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'taxonomy_terms_per_page_admin',
  'value' => 'i:100;',
))
->values(array(
  'name' => 'teaser_length',
  'value' => 'i:456;',
))
->values(array(
  'name' => 'theme_default',
  'value' => 's:7:"garland";',
))
->values(array(
  'name' => 'theme_settings',
  'value' => 'a:22:{s:11:"toggle_logo";i:1;s:11:"toggle_name";i:1;s:13:"toggle_slogan";i:0;s:14:"toggle_mission";i:1;s:24:"toggle_node_user_picture";i:0;s:27:"toggle_comment_user_picture";i:0;s:13:"toggle_search";i:0;s:14:"toggle_favicon";i:1;s:20:"toggle_primary_links";i:1;s:22:"toggle_secondary_links";i:1;s:21:"toggle_node_info_test";i:1;s:26:"toggle_node_info_something";i:1;s:12:"default_logo";i:1;s:9:"logo_path";s:0:"";s:11:"logo_upload";s:0:"";s:15:"default_favicon";i:1;s:12:"favicon_path";s:0:"";s:14:"favicon_upload";s:0:"";s:26:"toggle_node_info_test_page";i:1;s:27:"toggle_node_info_test_story";i:1;s:27:"toggle_node_info_test_event";i:1;s:28:"toggle_node_info_test_planet";i:1;}',
))
->values(array(
  'name' => 'update_check_frequency',
  'value' => 's:1:"7";',
))
->values(array(
  'name' => 'update_fetch_url',
  'value' => 's:41:"http://updates.drupal.org/release-history";',
))
->values(array(
  'name' => 'update_max_fetch_attempts',
  'value' => 'i:2;',
))
->values(array(
  'name' => 'update_notification_threshold',
  'value' => 's:3:"all";',
))
->values(array(
  'name' => 'update_notify_emails',
  'value' => 'a:0:{}',
))
->values(array(
  'name' => 'upload_article',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'upload_page',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'upload_story',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'user_block_max_list_count',
  'value' => 's:2:"10";',
))
->values(array(
  'name' => 'user_block_seconds_online',
  'value' => 's:3:"900";',
))
->values(array(
  'name' => 'user_block_whois_new_count',
  'value' => 's:1:"5";',
))
->values(array(
  'name' => 'user_email_verification',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'user_mail_password_reset_body',
  'value' => "s:409:\"!username,\n\nA request to reset the password for your account has been made at !site.\n\nYou may now log in to !uri_brief by clicking on this link or copying and pasting it in your browser:\n\n!login_url\n\nThis is a one-time login, so it can be used only once. It expires after one day and nothing will happen if it's not used.\n\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\";",
))
->values(array(
  'name' => 'user_mail_password_reset_subject',
  'value' => 's:52:"Replacement login information for !username at !site";',
))
->values(array(
  'name' => 'user_mail_register_admin_created_body',
  'value' => "s:452:\"!username,\n\nA site administrator at !site has created an account for you. You may now log in to !login_uri using the following username and password:\n\nusername: !username\npassword: !password\n\nYou may also log in by clicking on this link or copying and pasting it in your browser:\n\n!login_url\n\nThis is a one-time login, so it can be used only once.\n\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\n\n\n--  !site team\";",
))
->values(array(
  'name' => 'user_mail_register_admin_created_subject',
  'value' => 's:52:"An administrator created an account for you at !site";',
))
->values(array(
  'name' => 'user_mail_register_no_approval_required_body',
  'value' => "s:426:\"!username,\n\nThank you for registering at !site. You may now log in to !login_uri using the following username and password:\n\nusername: !username\npassword: !password\n\nYou may also log in by clicking on this link or copying and pasting it in your browser:\n\n!login_url\n\nThis is a one-time login, so it can be used only once.\n\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\n\n\n--  !site team\";",
))
->values(array(
  'name' => 'user_mail_register_no_approval_required_subject',
  'value' => 's:38:"Account details for !username at !site";',
))
->values(array(
  'name' => 'user_mail_register_pending_approval_body',
  'value' => "s:267:\"!username,\n\nThank you for registering at !site. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\n\n\n--  !site team\";",
))
->values(array(
  'name' => 'user_mail_register_pending_approval_subject',
  'value' => 's:63:"Account details for !username at !site (pending admin approval)";',
))
->values(array(
  'name' => 'user_mail_status_activated_body',
  'value' => "s:419:\"!username,\n\nYour account at !site has been activated.\n\nYou may now log in by clicking on this link or copying and pasting it in your browser:\n\n!login_url\n\nThis is a one-time login, so it can be used only once.\n\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\n\nOnce you have set your own password, you will be able to log in to !login_uri in the future using:\n\nusername: !username\n\";",
))
->values(array(
  'name' => 'user_mail_status_activated_notify',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'user_mail_status_activated_subject',
  'value' => 's:49:"Account details for !username at !site (approved)";',
))
->values(array(
  'name' => 'user_mail_status_blocked_body',
  'value' => "s:51:\"!username,\n\nYour account on !site has been blocked.\";",
))
->values(array(
  'name' => 'user_mail_status_blocked_notify',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'user_mail_status_blocked_subject',
  'value' => 's:48:"Account details for !username at !site (blocked)";',
))
->values(array(
  'name' => 'user_mail_status_deleted_body',
  'value' => "s:51:\"!username,\n\nYour account on !site has been deleted.\";",
))
->values(array(
  'name' => 'user_mail_status_deleted_subject',
  'value' => 's:48:"Account details for !username at !site (deleted)";',
))
->values(array(
  'name' => 'user_register',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'user_signatures',
  'value' => 's:1:"1";',
))
->execute();

$connection->schema()->createTable('vocabulary', array(
  'fields' => array(
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'help' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'relations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'hierarchy' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'multiple' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'required' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'tags' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('vocabulary')
->fields(array(
  'vid',
  'name',
  'description',
  'help',
  'relations',
  'hierarchy',
  'multiple',
  'required',
  'tags',
  'module',
  'weight',
))
->values(array(
  'vid' => '1',
  'name' => 'vocabulary 1 (i=0)',
  'description' => 'description of vocabulary 1 (i=0)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '0',
  'multiple' => '0',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '4',
))
->values(array(
  'vid' => '2',
  'name' => 'vocabulary 2 (i=1)',
  'description' => 'description of vocabulary 2 (i=1)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '1',
  'multiple' => '1',
  'required' => '0',
  'tags' => '1',
  'module' => 'taxonomy',
  'weight' => '5',
))
->values(array(
  'vid' => '3',
  'name' => 'vocabulary 3 (i=2)',
  'description' => 'description of vocabulary 3 (i=2)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '2',
  'multiple' => '0',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '6',
))
->values(array(
  'vid' => '4',
  'name' => 'Tags',
  'description' => 'Tags Vocabulary',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '0',
  'multiple' => '0',
  'required' => '1',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'vid' => '5',
  'name' => 'vocabulary name much longer than thirty two characters',
  'description' => 'description of vocabulary name much longer than thirty two characters',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '3',
  'multiple' => '1',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '7',
))
->execute();

$connection->schema()->createTable('vocabulary_node_types', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'vid',
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('vocabulary_node_types')
->fields(array(
  'vid',
  'type',
))
->values(array(
  'vid' => '4',
  'type' => 'article',
))
->values(array(
  'vid' => '4',
  'type' => 'page',
))
->values(array(
  'vid' => '1',
  'type' => 'story',
))
->values(array(
  'vid' => '2',
  'type' => 'story',
))
->values(array(
  'vid' => '3',
  'type' => 'story',
))
->execute();

$connection->schema()->createTable('watchdog', array(
  'fields' => array(
    'wid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '16',
      'default' => '',
    ),
    'message' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'variables' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'severity' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'link' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'location' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'referer' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'wid',
  ),
  'mysql_character_set' => 'utf8',
));
