/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.globals;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.globals.ReadThreadLocalGlobalVariableNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;

public class ReadLastBacktraceNode
extends RubyNode {
    @Node.Child
    private ReadThreadLocalGlobalVariableNode getLastExceptionNode;
    @Node.Child
    private CallDispatchHeadNode getBacktraceNode;

    public ReadLastBacktraceNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.getLastExceptionNode = new ReadThreadLocalGlobalVariableNode(context, sourceSection, "$!");
        this.getBacktraceNode = DispatchHeadNodeFactory.createMethodCall(this.getContext());
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.create7BitString(StringOperations.encodeByteList("global-variable", (Encoding)UTF8Encoding.INSTANCE));
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object lastException = this.getLastExceptionNode.execute(frame);
        if (lastException == this.nil()) {
            return this.nil();
        }
        return this.getBacktraceNode.call(frame, lastException, "backtrace", null, new Object[0]);
    }
}

