/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.nodes.RubyGuards;

@ImportStatic(value={RubyGuards.class})
public abstract class WriteFrameSlotNode
extends Node {
    protected final FrameSlot frameSlot;

    public WriteFrameSlotNode(FrameSlot frameSlot) {
        assert (frameSlot != null);
        this.frameSlot = frameSlot;
    }

    public abstract Object executeWrite(Frame var1, Object var2);

    @Specialization(guards={"isBooleanKind(frame)"})
    public boolean writeBoolean(Frame frame, boolean value) {
        frame.setBoolean(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"isIntegerKind(frame)"})
    public int writeInteger(Frame frame, int value) {
        frame.setInt(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"isLongKind(frame)"})
    public long writeLong(Frame frame, long value) {
        frame.setLong(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"isDoubleKind(frame)"})
    public double writeDouble(Frame frame, double value) {
        frame.setDouble(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"isObjectKind(frame)"})
    public Object writeObject(Frame frame, Object value) {
        assert (RubyGuards.wasProvided(value));
        frame.setObject(this.frameSlot, value);
        return value;
    }

    protected final boolean isBooleanKind(Frame frame) {
        return this.isKind(FrameSlotKind.Boolean);
    }

    protected final boolean isIntegerKind(Frame frame) {
        return this.isKind(FrameSlotKind.Int);
    }

    protected final boolean isLongKind(Frame frame) {
        return this.isKind(FrameSlotKind.Long);
    }

    protected final boolean isDoubleKind(Frame frame) {
        return this.isKind(FrameSlotKind.Double);
    }

    protected final boolean isObjectKind(Frame frame) {
        if (this.frameSlot.getKind() != FrameSlotKind.Object) {
            CompilerDirectives.transferToInterpreter();
            this.frameSlot.setKind(FrameSlotKind.Object);
        }
        return true;
    }

    private boolean isKind(FrameSlotKind kind) {
        if (this.frameSlot.getKind() == kind) {
            return true;
        }
        return this.initialSetKind(kind);
    }

    private boolean initialSetKind(FrameSlotKind kind) {
        if (this.frameSlot.getKind() == FrameSlotKind.Illegal) {
            CompilerDirectives.transferToInterpreter();
            this.frameSlot.setKind(kind);
            return true;
        }
        return false;
    }

    public final FrameSlot getFrameSlot() {
        return this.frameSlot;
    }
}

