/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.modules;

import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.pdfsam.module.Module;
import org.pdfsam.ui.commons.UrlButton;
import org.pdfsam.ui.event.SetActiveModuleRequest;
import org.sejda.eventstudio.StaticStudio;

class ModulesDashboardTile
extends Region {
    private static final PseudoClass ARMED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"armed");
    private VBox topTile = new VBox(5.0);
    private Button button = new Button();
    private VBox toolButtons = new VBox(5.0);
    private ReadOnlyBooleanWrapper armed = new ReadOnlyBooleanWrapper(false){

        protected void invalidated() {
            ModulesDashboardTile.this.pseudoClassStateChanged(ARMED_PSEUDOCLASS_STATE, this.get());
        }
    };

    ModulesDashboardTile(Module module) {
        this.getStyleClass().addAll((Object[])new String[]{"dashboard-modules-tile"});
        Label titleLabel = new Label(module.descriptor().getName());
        titleLabel.getStyleClass().add((Object)"dashboard-modules-tile-title");
        titleLabel.setGraphic(module.graphic());
        Label textLabel = new Label(module.descriptor().getDescription());
        textLabel.getStyleClass().add((Object)"dashboard-modules-tile-text");
        textLabel.setMinHeight(Double.NEGATIVE_INFINITY);
        this.topTile.getChildren().addAll((Object[])new Node[]{titleLabel, textLabel});
        this.button.getStyleClass().add((Object)"dashboard-modules-invisible-button");
        this.button.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.button.setOnAction(e -> StaticStudio.eventStudio().broadcast(SetActiveModuleRequest.activeteModule(module.id())));
        this.armed.bind((ObservableValue)this.button.armedProperty());
        VBox inner = new VBox(new Node[]{new StackPane(new Node[]{this.topTile, this.button})});
        this.prefHeightProperty().bind((ObservableValue)inner.heightProperty());
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        inner.getStyleClass().add((Object)"dashboard-modules-tile-inner");
        this.getChildren().add((Object)inner);
        module.descriptor().getSupportURL().ifPresent(url -> {
            UrlButton helpButton = UrlButton.urlButton(null, url, null, "pdfsam-toolbar-button");
            helpButton.setGraphic((Node)GlyphsDude.createIcon(MaterialDesignIcon.HELP_CIRCLE, "1.4em"));
            this.toolButtons.getChildren().add((Object)helpButton);
            this.toolButtons.getStyleClass().add((Object)"dashboard-modules-toolbar");
            inner.getChildren().add((Object)this.toolButtons);
        });
    }

    public final ReadOnlyBooleanProperty armedProperty() {
        return this.armed.getReadOnlyProperty();
    }

    public final boolean isArmed() {
        return this.armed.get();
    }
}

