/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple.move;

import java.util.Arrays;
import java.util.Collections;
import javafx.collections.ObservableList;
import org.apache.commons.lang3.ArrayUtils;
import org.pdfsam.ui.selection.multiple.move.MultipleSelectionAndFocus;
import org.pdfsam.ui.selection.multiple.move.SelectionAndFocus;
import org.pdfsam.ui.selection.multiple.move.SingleSelectionAndFocus;

public enum MoveType {
    TOP{

        @Override
        public <T> SelectionAndFocus move(Integer[] selected, ObservableList<T> items, int focused) {
            if (this.isSingleSelection(selected, items) && this.isNotFirst(selected)) {
                Object item = items.remove(selected[0].intValue());
                items.add(0, item);
                return new SingleSelectionAndFocus(0);
            }
            return SelectionAndFocus.NULL;
        }
    }
    ,
    UP{

        @Override
        public <T> SelectionAndFocus move(Integer[] selected, ObservableList<T> items, int focused) {
            if (this.isSubselection(selected, items)) {
                MultipleSelectionAndFocus newSelection = new MultipleSelectionAndFocus(focused);
                Arrays.parallelSort((Comparable[])selected);
                if (this.isNotFirst(selected)) {
                    Arrays.stream(selected).forEach(i -> {
                        Collections.swap(items, (int)i, i - 1);
                        newSelection.moveUp((int)i);
                    });
                    return newSelection;
                }
            }
            return SelectionAndFocus.NULL;
        }
    }
    ,
    DOWN{

        @Override
        public <T> SelectionAndFocus move(Integer[] selected, ObservableList<T> items, int focused) {
            if (this.isSubselection(selected, items)) {
                MultipleSelectionAndFocus newSelection = new MultipleSelectionAndFocus(focused);
                Arrays.parallelSort(selected, Collections.reverseOrder(Integer::compare));
                if (this.isNotLast(selected, items)) {
                    Arrays.stream(selected).forEach(i -> {
                        Collections.swap(items, (int)i, i + 1);
                        newSelection.moveDown((int)i);
                    });
                    return newSelection;
                }
            }
            return SelectionAndFocus.NULL;
        }
    }
    ,
    BOTTOM{

        @Override
        public <T> SelectionAndFocus move(Integer[] selected, ObservableList<T> items, int focused) {
            if (this.isSingleSelection(selected, items) && this.isNotLast(selected, items)) {
                Object item = items.remove(selected[0].intValue());
                items.add(items.size(), item);
                return new SingleSelectionAndFocus(items.size() - 1);
            }
            return SelectionAndFocus.NULL;
        }
    };


    boolean isNotFirst(Integer[] selected) {
        return selected[0] > 0;
    }

    boolean isNotLast(Integer[] selected, ObservableList<?> items) {
        return selected[0] < items.size() - 1;
    }

    boolean isSubselection(Integer[] toMove, ObservableList<?> items) {
        return !ArrayUtils.isEmpty((Object[])toMove) && toMove.length < items.size();
    }

    boolean isSingleSelection(Integer[] toMove, ObservableList<?> items) {
        return !ArrayUtils.isEmpty((Object[])toMove) && toMove.length == 1 && items.size() > 1;
    }

    public abstract <T> SelectionAndFocus move(Integer[] var1, ObservableList<T> var2, int var3);
}

