/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.CorruptStateException;
import org.elasticsearch.gateway.MetaDataStateFormat;

public final class ShardStateMetaData {
    private static final String SHARD_STATE_FILE_PREFIX = "state-";
    private static final String PRIMARY_KEY = "primary";
    private static final String VERSION_KEY = "version";
    private static final String INDEX_UUID_KEY = "index_uuid";
    public final long version;
    public final String indexUUID;
    public final boolean primary;
    public static final MetaDataStateFormat<ShardStateMetaData> FORMAT = new MetaDataStateFormat<ShardStateMetaData>(XContentType.JSON, "state-"){

        @Override
        protected XContentBuilder newXContentBuilder(XContentType type, OutputStream stream) throws IOException {
            XContentBuilder xContentBuilder = super.newXContentBuilder(type, stream);
            xContentBuilder.prettyPrint();
            return xContentBuilder;
        }

        @Override
        public void toXContent(XContentBuilder builder, ShardStateMetaData shardStateMetaData) throws IOException {
            builder.field(ShardStateMetaData.VERSION_KEY, shardStateMetaData.version);
            builder.field(ShardStateMetaData.PRIMARY_KEY, shardStateMetaData.primary);
            builder.field(ShardStateMetaData.INDEX_UUID_KEY, shardStateMetaData.indexUUID);
        }

        @Override
        public ShardStateMetaData fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                return null;
            }
            long version = -1L;
            Boolean primary = null;
            String currentFieldName = null;
            String indexUUID = "_na_";
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (ShardStateMetaData.VERSION_KEY.equals(currentFieldName)) {
                        version = parser.longValue();
                        continue;
                    }
                    if (ShardStateMetaData.PRIMARY_KEY.equals(currentFieldName)) {
                        primary = parser.booleanValue();
                        continue;
                    }
                    if (ShardStateMetaData.INDEX_UUID_KEY.equals(currentFieldName)) {
                        indexUUID = parser.text();
                        continue;
                    }
                    throw new CorruptStateException("unexpected field in shard state [" + currentFieldName + "]");
                }
                throw new CorruptStateException("unexpected token in shard state [" + token.name() + "]");
            }
            if (primary == null) {
                throw new CorruptStateException("missing value for [primary] in shard state");
            }
            if (version == -1L) {
                throw new CorruptStateException("missing value for [version] in shard state");
            }
            return new ShardStateMetaData(version, primary, indexUUID);
        }
    };

    public ShardStateMetaData(long version, boolean primary, String indexUUID) {
        assert (indexUUID != null);
        this.version = version;
        this.primary = primary;
        this.indexUUID = indexUUID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardStateMetaData that = (ShardStateMetaData)o;
        if (this.primary != that.primary) {
            return false;
        }
        if (this.version != that.version) {
            return false;
        }
        return !(this.indexUUID != null ? !this.indexUUID.equals(that.indexUUID) : that.indexUUID != null);
    }

    public int hashCode() {
        int result = (int)(this.version ^ this.version >>> 32);
        result = 31 * result + (this.indexUUID != null ? this.indexUUID.hashCode() : 0);
        result = 31 * result + (this.primary ? 1 : 0);
        return result;
    }

    public String toString() {
        return "version [" + this.version + "], primary [" + this.primary + "]";
    }
}

