/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.CancelledKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.ReleasablePagedBytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.math.MathUtils;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.netty.NettyUtils;
import org.elasticsearch.common.netty.OpenChannelsHandler;
import org.elasticsearch.common.netty.ReleaseChannelFutureListener;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.KeyedLock;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.BytesTransportRequest;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.netty.MessageChannelHandler;
import org.elasticsearch.transport.netty.NettyHeader;
import org.elasticsearch.transport.netty.SizeHeaderFrameDecoder;
import org.elasticsearch.transport.support.TransportStatus;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.AdaptiveReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.ReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class NettyTransport
extends AbstractLifecycleComponent<Transport>
implements Transport {
    public static final String HTTP_SERVER_WORKER_THREAD_NAME_PREFIX = "http_server_worker";
    public static final String HTTP_SERVER_BOSS_THREAD_NAME_PREFIX = "http_server_boss";
    public static final String TRANSPORT_CLIENT_WORKER_THREAD_NAME_PREFIX = "transport_client_worker";
    public static final String TRANSPORT_CLIENT_BOSS_THREAD_NAME_PREFIX = "transport_client_boss";
    public static final String WORKER_COUNT = "transport.netty.worker_count";
    public static final String CONNECTIONS_PER_NODE_RECOVERY = "transport.connections_per_node.recovery";
    public static final String CONNECTIONS_PER_NODE_BULK = "transport.connections_per_node.bulk";
    public static final String CONNECTIONS_PER_NODE_REG = "transport.connections_per_node.reg";
    public static final String CONNECTIONS_PER_NODE_STATE = "transport.connections_per_node.state";
    public static final String CONNECTIONS_PER_NODE_PING = "transport.connections_per_node.ping";
    public static final String PING_SCHEDULE = "transport.ping_schedule";
    public static final TimeValue DEFAULT_PING_SCHEDULE;
    public static final String DEFAULT_PORT_RANGE = "9300-9400";
    public static final String DEFAULT_PROFILE = "default";
    protected final NetworkService networkService;
    protected final Version version;
    protected final boolean blockingClient;
    protected final TimeValue connectTimeout;
    protected final ByteSizeValue maxCumulationBufferCapacity;
    protected final int maxCompositeBufferComponents;
    protected final boolean compress;
    protected final ReceiveBufferSizePredictorFactory receiveBufferSizePredictorFactory;
    protected final int workerCount;
    protected final ByteSizeValue receivePredictorMin;
    protected final ByteSizeValue receivePredictorMax;
    protected final int connectionsPerNodeRecovery;
    protected final int connectionsPerNodeBulk;
    protected final int connectionsPerNodeReg;
    protected final int connectionsPerNodeState;
    protected final int connectionsPerNodePing;
    private final TimeValue pingSchedule;
    protected final BigArrays bigArrays;
    protected final ThreadPool threadPool;
    volatile OpenChannelsHandler serverOpenChannels;
    protected volatile ClientBootstrap clientBootstrap;
    protected final ConcurrentMap<DiscoveryNode, NodeChannels> connectedNodes = ConcurrentCollections.newConcurrentMap();
    protected final Map<String, ServerBootstrap> serverBootstraps = ConcurrentCollections.newConcurrentMap();
    protected final Map<String, List<Channel>> serverChannels = ConcurrentCollections.newConcurrentMap();
    protected final ConcurrentMap<String, BoundTransportAddress> profileBoundAddresses = ConcurrentCollections.newConcurrentMap();
    protected volatile TransportServiceAdapter transportServiceAdapter;
    protected volatile BoundTransportAddress boundAddress;
    protected final KeyedLock<String> connectionLock = new KeyedLock();
    protected final NamedWriteableRegistry namedWriteableRegistry;
    private final ReadWriteLock globalLock = new ReentrantReadWriteLock();
    final ScheduledPing scheduledPing;
    private static final Pattern BRACKET_PATTERN;

    @Inject
    public NettyTransport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, Version version, NamedWriteableRegistry namedWriteableRegistry) {
        super(settings);
        this.threadPool = threadPool;
        this.networkService = networkService;
        this.bigArrays = bigArrays;
        this.version = version;
        if (settings.getAsBoolean("netty.epollBugWorkaround", (Boolean)false).booleanValue()) {
            System.setProperty("org.jboss.netty.epollBugWorkaround", "true");
        }
        this.workerCount = settings.getAsInt(WORKER_COUNT, (Integer)(EsExecutors.boundedNumberOfProcessors(settings) * 2));
        this.blockingClient = settings.getAsBoolean("transport.netty.transport.tcp.blocking_client", settings.getAsBoolean("network.tcp.blocking_client", settings.getAsBoolean("network.tcp.blocking", (Boolean)false)));
        this.connectTimeout = this.settings.getAsTime("transport.netty.connect_timeout", settings.getAsTime("transport.tcp.connect_timeout", settings.getAsTime("network.tcp.connect_timeout", NetworkService.TcpSettings.TCP_DEFAULT_CONNECT_TIMEOUT)));
        this.maxCumulationBufferCapacity = this.settings.getAsBytesSize("transport.netty.max_cumulation_buffer_capacity", null);
        this.maxCompositeBufferComponents = this.settings.getAsInt("transport.netty.max_composite_buffer_components", (Integer)-1);
        this.compress = settings.getAsBoolean("transport.tcp.compress", (Boolean)false);
        this.connectionsPerNodeRecovery = this.settings.getAsInt("transport.netty.connections_per_node.recovery", settings.getAsInt(CONNECTIONS_PER_NODE_RECOVERY, (Integer)2));
        this.connectionsPerNodeBulk = this.settings.getAsInt("transport.netty.connections_per_node.bulk", settings.getAsInt(CONNECTIONS_PER_NODE_BULK, (Integer)3));
        this.connectionsPerNodeReg = this.settings.getAsInt("transport.netty.connections_per_node.reg", settings.getAsInt(CONNECTIONS_PER_NODE_REG, (Integer)6));
        this.connectionsPerNodeState = this.settings.getAsInt("transport.netty.connections_per_node.high", settings.getAsInt(CONNECTIONS_PER_NODE_STATE, (Integer)1));
        this.connectionsPerNodePing = this.settings.getAsInt("transport.netty.connections_per_node.ping", settings.getAsInt(CONNECTIONS_PER_NODE_PING, (Integer)1));
        if (this.connectionsPerNodeReg == 0) {
            throw new IllegalArgumentException("can't set [connection_per_node.reg] to 0");
        }
        if (this.connectionsPerNodePing == 0) {
            throw new IllegalArgumentException("can't set [connection_per_node.ping] to 0");
        }
        if (this.connectionsPerNodeState == 0) {
            throw new IllegalArgumentException("can't set [connection_per_node.state] to 0");
        }
        long defaultReceiverPredictor = 524288L;
        if (JvmInfo.jvmInfo().getMem().getDirectMemoryMax().bytes() > 0L) {
            long l = (long)(0.3 * (double)JvmInfo.jvmInfo().getMem().getDirectMemoryMax().bytes() / (double)this.workerCount);
            defaultReceiverPredictor = Math.min(defaultReceiverPredictor, Math.max(l, 65536L));
        }
        this.receivePredictorMin = this.settings.getAsBytesSize("transport.netty.receive_predictor_min", this.settings.getAsBytesSize("transport.netty.receive_predictor_size", new ByteSizeValue(defaultReceiverPredictor)));
        this.receivePredictorMax = this.settings.getAsBytesSize("transport.netty.receive_predictor_max", this.settings.getAsBytesSize("transport.netty.receive_predictor_size", new ByteSizeValue(defaultReceiverPredictor)));
        this.receiveBufferSizePredictorFactory = this.receivePredictorMax.bytes() == this.receivePredictorMin.bytes() ? new FixedReceiveBufferSizePredictorFactory((int)this.receivePredictorMax.bytes()) : new AdaptiveReceiveBufferSizePredictorFactory((int)this.receivePredictorMin.bytes(), (int)this.receivePredictorMin.bytes(), (int)this.receivePredictorMax.bytes());
        this.scheduledPing = new ScheduledPing();
        this.pingSchedule = settings.getAsTime(PING_SCHEDULE, DEFAULT_PING_SCHEDULE);
        if (this.pingSchedule.millis() > 0L) {
            threadPool.schedule(this.pingSchedule, "generic", this.scheduledPing);
        }
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    public Settings settings() {
        return this.settings;
    }

    @Override
    public void transportServiceAdapter(TransportServiceAdapter service) {
        this.transportServiceAdapter = service;
    }

    TransportServiceAdapter transportServiceAdapter() {
        return this.transportServiceAdapter;
    }

    ThreadPool threadPool() {
        return this.threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        boolean success = false;
        try {
            this.clientBootstrap = this.createClientBootstrap();
            if (this.settings.getAsBoolean("network.server", (Boolean)true).booleanValue()) {
                OpenChannelsHandler openChannels;
                this.serverOpenChannels = openChannels = new OpenChannelsHandler(this.logger);
                HashMap profiles = this.settings.getGroups("transport.profiles", true);
                if (!profiles.containsKey(DEFAULT_PROFILE)) {
                    profiles = Maps.newHashMap(profiles);
                    profiles.put(DEFAULT_PROFILE, Settings.EMPTY);
                }
                Settings fallbackSettings = this.createFallbackSettings();
                Settings defaultSettings = (Settings)profiles.get(DEFAULT_PROFILE);
                for (Map.Entry entry : profiles.entrySet()) {
                    Settings profileSettings = (Settings)entry.getValue();
                    String name = (String)entry.getKey();
                    if (!Strings.hasLength(name)) {
                        this.logger.info("transport profile configured without a name. skipping profile with settings [{}]", profileSettings.toDelimitedString(','));
                        continue;
                    }
                    if (DEFAULT_PROFILE.equals(name)) {
                        profileSettings = Settings.settingsBuilder().put(profileSettings).put("port", profileSettings.get("port", this.settings.get("transport.tcp.port", DEFAULT_PORT_RANGE))).build();
                    } else if (profileSettings.get("port") == null) {
                        this.logger.info("No port configured for profile [{}], not binding", name);
                        continue;
                    }
                    Settings mergedSettings = Settings.settingsBuilder().put(fallbackSettings).put(defaultSettings).put(profileSettings).build();
                    this.createServerBootstrap(name, mergedSettings);
                    this.bindServerBootstrap(name, mergedSettings);
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    @Override
    public Map<String, BoundTransportAddress> profileBoundAddresses() {
        return ImmutableMap.copyOf(this.profileBoundAddresses);
    }

    private ClientBootstrap createClientBootstrap() {
        ByteSizeValue tcpReceiveBufferSize;
        ByteSizeValue tcpSendBufferSize;
        String tcpKeepAlive;
        if (this.blockingClient) {
            this.clientBootstrap = new ClientBootstrap((ChannelFactory)new OioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, TRANSPORT_CLIENT_WORKER_THREAD_NAME_PREFIX))));
        } else {
            int bossCount = this.settings.getAsInt("transport.netty.boss_count", (Integer)1);
            this.clientBootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, TRANSPORT_CLIENT_BOSS_THREAD_NAME_PREFIX)), bossCount, (WorkerPool)new NioWorkerPool((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, TRANSPORT_CLIENT_WORKER_THREAD_NAME_PREFIX)), this.workerCount), (Timer)new HashedWheelTimer(EsExecutors.daemonThreadFactory(this.settings, "transport_client_timer"))));
        }
        this.clientBootstrap.setPipelineFactory(this.configureClientChannelPipelineFactory());
        this.clientBootstrap.setOption("connectTimeoutMillis", (Object)this.connectTimeout.millis());
        String tcpNoDelay = this.settings.get("transport.netty.tcp_no_delay", this.settings.get("network.tcp.no_delay", "true"));
        if (!DEFAULT_PROFILE.equals(tcpNoDelay)) {
            this.clientBootstrap.setOption("tcpNoDelay", (Object)Booleans.parseBoolean(tcpNoDelay, null));
        }
        if (!DEFAULT_PROFILE.equals(tcpKeepAlive = this.settings.get("transport.netty.tcp_keep_alive", this.settings.get("network.tcp.keep_alive", "true")))) {
            this.clientBootstrap.setOption("keepAlive", (Object)Booleans.parseBoolean(tcpKeepAlive, null));
        }
        if ((tcpSendBufferSize = this.settings.getAsBytesSize("transport.netty.tcp_send_buffer_size", this.settings.getAsBytesSize("network.tcp.send_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_SEND_BUFFER_SIZE))) != null && tcpSendBufferSize.bytes() > 0L) {
            this.clientBootstrap.setOption("sendBufferSize", (Object)tcpSendBufferSize.bytes());
        }
        if ((tcpReceiveBufferSize = this.settings.getAsBytesSize("transport.netty.tcp_receive_buffer_size", this.settings.getAsBytesSize("network.tcp.receive_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_RECEIVE_BUFFER_SIZE))) != null && tcpReceiveBufferSize.bytes() > 0L) {
            this.clientBootstrap.setOption("receiveBufferSize", (Object)tcpReceiveBufferSize.bytes());
        }
        this.clientBootstrap.setOption("receiveBufferSizePredictorFactory", (Object)this.receiveBufferSizePredictorFactory);
        boolean reuseAddress = this.settings.getAsBoolean("transport.netty.reuse_address", this.settings.getAsBoolean("network.tcp.reuse_address", (Boolean)NetworkUtils.defaultReuseAddress()));
        this.clientBootstrap.setOption("reuseAddress", (Object)reuseAddress);
        return this.clientBootstrap;
    }

    private Settings createFallbackSettings() {
        ByteSizeValue fallbackTcpBufferSize;
        String fallbackTcpKeepAlive;
        String fallbackTcpNoDelay;
        String fallbackPublishHost;
        Settings.Builder fallbackSettingsBuilder = Settings.settingsBuilder();
        String fallbackBindHost = this.settings.get("transport.netty.bind_host", this.settings.get("transport.bind_host", this.settings.get("transport.host")));
        if (fallbackBindHost != null) {
            fallbackSettingsBuilder.put("bind_host", fallbackBindHost);
        }
        if ((fallbackPublishHost = this.settings.get("transport.netty.publish_host", this.settings.get("transport.publish_host", this.settings.get("transport.host")))) != null) {
            fallbackSettingsBuilder.put("publish_host", fallbackPublishHost);
        }
        if ((fallbackTcpNoDelay = this.settings.get("transport.netty.tcp_no_delay", this.settings.get("network.tcp.no_delay", "true"))) != null) {
            fallbackSettingsBuilder.put("tcp_no_delay", fallbackTcpNoDelay);
        }
        if ((fallbackTcpKeepAlive = this.settings.get("transport.netty.tcp_keep_alive", this.settings.get("network.tcp.keep_alive", "true"))) != null) {
            fallbackSettingsBuilder.put("tcp_keep_alive", fallbackTcpKeepAlive);
        }
        boolean fallbackReuseAddress = this.settings.getAsBoolean("transport.netty.reuse_address", this.settings.getAsBoolean("network.tcp.reuse_address", (Boolean)NetworkUtils.defaultReuseAddress()));
        fallbackSettingsBuilder.put("reuse_address", fallbackReuseAddress);
        ByteSizeValue fallbackTcpSendBufferSize = this.settings.getAsBytesSize("transport.netty.tcp_send_buffer_size", this.settings.getAsBytesSize("network.tcp.send_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_SEND_BUFFER_SIZE));
        if (fallbackTcpSendBufferSize != null) {
            fallbackSettingsBuilder.put("tcp_send_buffer_size", fallbackTcpSendBufferSize);
        }
        if ((fallbackTcpBufferSize = this.settings.getAsBytesSize("transport.netty.tcp_receive_buffer_size", this.settings.getAsBytesSize("network.tcp.receive_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_RECEIVE_BUFFER_SIZE))) != null) {
            fallbackSettingsBuilder.put("tcp_receive_buffer_size", fallbackTcpBufferSize);
        }
        return fallbackSettingsBuilder.build();
    }

    private void bindServerBootstrap(String name, Settings settings) {
        InetAddress[] hostAddresses;
        Object[] bindHosts = settings.getAsArray("bind_host", null);
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses((String[])bindHosts);
        }
        catch (IOException e) {
            throw new BindTransportException("Failed to resolve host " + Arrays.toString(bindHosts) + "", e);
        }
        if (this.logger.isDebugEnabled()) {
            Object[] addresses = new String[hostAddresses.length];
            for (int i = 0; i < hostAddresses.length; ++i) {
                addresses[i] = NetworkAddress.format(hostAddresses[i]);
            }
            this.logger.debug("binding server bootstrap to: {}", addresses);
        }
        assert (hostAddresses.length > 0);
        ArrayList<InetSocketAddress> boundAddresses = new ArrayList<InetSocketAddress>();
        for (InetAddress hostAddress : hostAddresses) {
            boundAddresses.add(this.bindToPort(name, hostAddress, settings.get("port")));
        }
        BoundTransportAddress boundTransportAddress = this.createBoundTransportAddress(name, settings, boundAddresses);
        if (DEFAULT_PROFILE.equals(name)) {
            this.boundAddress = boundTransportAddress;
        } else {
            this.profileBoundAddresses.put(name, boundTransportAddress);
        }
    }

    private InetSocketAddress bindToPort(final String name, final InetAddress hostAddress, String port) {
        PortsRange portsRange = new PortsRange(port);
        final AtomicReference boundSocket = new AtomicReference();
        final AtomicReference lastException = new AtomicReference();
        boolean success = portsRange.iterate(new PortsRange.PortCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onPortNumber(int portNumber) {
                try {
                    Channel channel = NettyTransport.this.serverBootstraps.get(name).bind((SocketAddress)new InetSocketAddress(hostAddress, portNumber));
                    Map<String, List<Channel>> map = NettyTransport.this.serverChannels;
                    synchronized (map) {
                        List<Channel> list = NettyTransport.this.serverChannels.get(name);
                        if (list == null) {
                            list = new ArrayList<Channel>();
                            NettyTransport.this.serverChannels.put(name, list);
                        }
                        list.add(channel);
                        boundSocket.set((InetSocketAddress)channel.getLocalAddress());
                    }
                }
                catch (Exception e) {
                    lastException.set(e);
                    return false;
                }
                return true;
            }
        });
        if (!success) {
            throw new BindTransportException("Failed to bind to [" + port + "]", (Throwable)lastException.get());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bound profile [{}] to address {{}}", name, NetworkAddress.format((InetSocketAddress)boundSocket.get()));
        }
        return (InetSocketAddress)boundSocket.get();
    }

    private BoundTransportAddress createBoundTransportAddress(String name, Settings profileSettings, List<InetSocketAddress> boundAddresses) {
        InetAddress publishInetAddress;
        String[] boundAddressesHostStrings = new String[boundAddresses.size()];
        TransportAddress[] transportBoundAddresses = new TransportAddress[boundAddresses.size()];
        for (int i = 0; i < boundAddresses.size(); ++i) {
            InetSocketAddress boundAddress = boundAddresses.get(i);
            boundAddressesHostStrings[i] = boundAddress.getHostString();
            transportBoundAddresses[i] = new InetSocketTransportAddress(boundAddress);
        }
        String[] publishHosts = DEFAULT_PROFILE.equals(name) ? this.settings.getAsArray("transport.netty.publish_host", this.settings.getAsArray("transport.publish_host", this.settings.getAsArray("transport.host", null))) : profileSettings.getAsArray("publish_host", boundAddressesHostStrings);
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(publishHosts);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        int publishPort = NettyTransport.resolvePublishPort(name, this.settings, profileSettings, boundAddresses, publishInetAddress);
        InetSocketTransportAddress publishAddress = new InetSocketTransportAddress(new InetSocketAddress(publishInetAddress, publishPort));
        return new BoundTransportAddress(transportBoundAddresses, publishAddress);
    }

    static int resolvePublishPort(String profileName, Settings settings, Settings profileSettings, List<InetSocketAddress> boundAddresses, InetAddress publishInetAddress) {
        int publishPort = DEFAULT_PROFILE.equals(profileName) ? settings.getAsInt("transport.netty.publish_port", settings.getAsInt("transport.publish_port", (Integer)-1)).intValue() : profileSettings.getAsInt("publish_port", (Integer)-1).intValue();
        if (publishPort < 0) {
            for (InetSocketAddress boundAddress : boundAddresses) {
                InetAddress boundInetAddress = boundAddress.getAddress();
                if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
                publishPort = boundAddress.getPort();
                break;
            }
        }
        if (publishPort < 0) {
            IntHashSet ports = new IntHashSet();
            for (InetSocketAddress boundAddress : boundAddresses) {
                ports.add(boundAddress.getPort());
            }
            if (ports.size() == 1) {
                publishPort = ((IntCursor)ports.iterator().next()).value;
            }
        }
        if (publishPort < 0) {
            String profileExplanation = DEFAULT_PROFILE.equals(profileName) ? "" : " for profile " + profileName;
            throw new BindTransportException("Failed to auto-resolve publish port" + profileExplanation + ", multiple bound addresses " + boundAddresses + " with distinct ports and none of them matched the publish address (" + publishInetAddress + "). " + "Please specify a unique port by setting transport.port or transport.publish_port");
        }
        return publishPort;
    }

    private void createServerBootstrap(String name, Settings settings) {
        boolean blockingServer = settings.getAsBoolean("transport.tcp.blocking_server", this.settings.getAsBoolean("network.tcp.blocking_server", this.settings.getAsBoolean("network.tcp.blocking", (Boolean)false)));
        String port = settings.get("port");
        String bindHost = settings.get("bind_host");
        String publishHost = settings.get("publish_host");
        String tcpNoDelay = settings.get("tcp_no_delay");
        String tcpKeepAlive = settings.get("tcp_keep_alive");
        boolean reuseAddress = settings.getAsBoolean("reuse_address", (Boolean)NetworkUtils.defaultReuseAddress());
        ByteSizeValue tcpSendBufferSize = settings.getAsBytesSize("tcp_send_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_SEND_BUFFER_SIZE);
        ByteSizeValue tcpReceiveBufferSize = settings.getAsBytesSize("tcp_receive_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_RECEIVE_BUFFER_SIZE);
        this.logger.debug("using profile[{}], worker_count[{}], port[{}], bind_host[{}], publish_host[{}], compress[{}], connect_timeout[{}], connections_per_node[{}/{}/{}/{}/{}], receive_predictor[{}->{}]", name, this.workerCount, port, bindHost, publishHost, this.compress, this.connectTimeout, this.connectionsPerNodeRecovery, this.connectionsPerNodeBulk, this.connectionsPerNodeReg, this.connectionsPerNodeState, this.connectionsPerNodePing, this.receivePredictorMin, this.receivePredictorMax);
        ThreadFactory bossFactory = EsExecutors.daemonThreadFactory(this.settings, HTTP_SERVER_BOSS_THREAD_NAME_PREFIX, name);
        ThreadFactory workerFactory = EsExecutors.daemonThreadFactory(this.settings, HTTP_SERVER_WORKER_THREAD_NAME_PREFIX, name);
        ServerBootstrap serverBootstrap = blockingServer ? new ServerBootstrap((ChannelFactory)new OioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(bossFactory), (Executor)Executors.newCachedThreadPool(workerFactory))) : new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(bossFactory), (Executor)Executors.newCachedThreadPool(workerFactory), this.workerCount));
        serverBootstrap.setPipelineFactory(this.configureServerChannelPipelineFactory(name, settings));
        if (!DEFAULT_PROFILE.equals(tcpNoDelay)) {
            serverBootstrap.setOption("child.tcpNoDelay", (Object)Booleans.parseBoolean(tcpNoDelay, null));
        }
        if (!DEFAULT_PROFILE.equals(tcpKeepAlive)) {
            serverBootstrap.setOption("child.keepAlive", (Object)Booleans.parseBoolean(tcpKeepAlive, null));
        }
        if (tcpSendBufferSize != null && tcpSendBufferSize.bytes() > 0L) {
            serverBootstrap.setOption("child.sendBufferSize", (Object)tcpSendBufferSize.bytes());
        }
        if (tcpReceiveBufferSize != null && tcpReceiveBufferSize.bytes() > 0L) {
            serverBootstrap.setOption("child.receiveBufferSize", (Object)tcpReceiveBufferSize.bytes());
        }
        serverBootstrap.setOption("receiveBufferSizePredictorFactory", (Object)this.receiveBufferSizePredictorFactory);
        serverBootstrap.setOption("child.receiveBufferSizePredictorFactory", (Object)this.receiveBufferSizePredictorFactory);
        serverBootstrap.setOption("reuseAddress", (Object)reuseAddress);
        serverBootstrap.setOption("child.reuseAddress", (Object)reuseAddress);
        this.serverBootstraps.put(name, serverBootstrap);
    }

    @Override
    protected void doStop() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.threadPool.generic().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NettyTransport.this.globalLock.writeLock().lock();
                try {
                    Iterator it = NettyTransport.this.connectedNodes.values().iterator();
                    while (it.hasNext()) {
                        NodeChannels nodeChannels = (NodeChannels)it.next();
                        it.remove();
                        nodeChannels.close();
                    }
                    Iterator<Map.Entry<String, List<Channel>>> serverChannelIterator = NettyTransport.this.serverChannels.entrySet().iterator();
                    while (serverChannelIterator.hasNext()) {
                        Map.Entry<String, List<Channel>> serverChannelEntry = serverChannelIterator.next();
                        String name = serverChannelEntry.getKey();
                        List<Channel> serverChannels = serverChannelEntry.getValue();
                        for (Channel serverChannel : serverChannels) {
                            try {
                                serverChannel.close().awaitUninterruptibly();
                            }
                            catch (Throwable t) {
                                NettyTransport.this.logger.debug("Error closing serverChannel for profile [{}]", t, name);
                            }
                        }
                        serverChannelIterator.remove();
                    }
                    if (NettyTransport.this.serverOpenChannels != null) {
                        NettyTransport.this.serverOpenChannels.close();
                        NettyTransport.this.serverOpenChannels = null;
                    }
                    Iterator<Map.Entry<String, ServerBootstrap>> serverBootstrapIterator = NettyTransport.this.serverBootstraps.entrySet().iterator();
                    while (serverBootstrapIterator.hasNext()) {
                        Map.Entry<String, ServerBootstrap> serverBootstrapEntry = serverBootstrapIterator.next();
                        String name = serverBootstrapEntry.getKey();
                        ServerBootstrap serverBootstrap = serverBootstrapEntry.getValue();
                        try {
                            serverBootstrap.releaseExternalResources();
                        }
                        catch (Throwable t) {
                            NettyTransport.this.logger.debug("Error closing serverBootstrap for profile [{}]", t, name);
                        }
                        serverBootstrapIterator.remove();
                    }
                    Iterator it2 = NettyTransport.this.connectedNodes.values().iterator();
                    while (it2.hasNext()) {
                        NodeChannels nodeChannels = (NodeChannels)it2.next();
                        it2.remove();
                        nodeChannels.close();
                    }
                    if (NettyTransport.this.clientBootstrap != null) {
                        NettyTransport.this.clientBootstrap.releaseExternalResources();
                        NettyTransport.this.clientBootstrap = null;
                    }
                }
                finally {
                    NettyTransport.this.globalLock.writeLock().unlock();
                    latch.countDown();
                }
            }
        });
        try {
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void doClose() {
    }

    @Override
    public TransportAddress[] addressesFromString(String address, int perAddressLimit) throws Exception {
        return NettyTransport.parse(address, this.settings.get("transport.profiles.default.port", this.settings.get("transport.netty.port", this.settings.get("transport.tcp.port", DEFAULT_PORT_RANGE))), perAddressLimit);
    }

    static TransportAddress[] parse(String hostPortString, String defaultPortRange, int perAddressLimit) throws UnknownHostException {
        String host;
        Objects.requireNonNull(hostPortString);
        String portString = null;
        if (hostPortString.startsWith("[")) {
            Matcher matcher = BRACKET_PATTERN.matcher(hostPortString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid bracketed host/port range: " + hostPortString);
            }
            host = matcher.group(1);
            portString = matcher.group(2);
        } else {
            int colonPos = hostPortString.indexOf(58);
            if (colonPos >= 0 && hostPortString.indexOf(58, colonPos + 1) == -1) {
                host = hostPortString.substring(0, colonPos);
                portString = hostPortString.substring(colonPos + 1);
            } else {
                host = hostPortString;
                if (colonPos >= 0) {
                    throw new IllegalArgumentException("IPv6 addresses must be bracketed: " + hostPortString);
                }
            }
        }
        if (portString == null || portString.isEmpty()) {
            portString = defaultPortRange;
        }
        HashSet<InetAddress> addresses = new HashSet<InetAddress>(Arrays.asList(InetAddress.getAllByName(host)));
        ArrayList<InetSocketTransportAddress> transportAddresses = new ArrayList<InetSocketTransportAddress>();
        int[] ports = new PortsRange(portString).ports();
        int limit = Math.min(ports.length, perAddressLimit);
        for (int i = 0; i < limit; ++i) {
            for (InetAddress address : addresses) {
                transportAddresses.add(new InetSocketTransportAddress(address, ports[i]));
            }
        }
        return transportAddresses.toArray(new TransportAddress[transportAddresses.size()]);
    }

    @Override
    public boolean addressSupported(Class<? extends TransportAddress> address) {
        return InetSocketTransportAddress.class.equals(address);
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    protected void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (!this.lifecycle.started()) {
            return;
        }
        if (NetworkExceptionHelper.isCloseConnectionException(e.getCause())) {
            this.logger.trace("close connection exception caught on transport layer [{}], disconnecting from relevant node", e.getCause(), ctx.getChannel());
            ctx.getChannel().close();
            this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
        } else if (NetworkExceptionHelper.isConnectException(e.getCause())) {
            this.logger.trace("connect exception caught on transport layer [{}]", e.getCause(), ctx.getChannel());
            ctx.getChannel().close();
            this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
        } else if (e.getCause() instanceof CancelledKeyException) {
            this.logger.trace("cancelled key exception caught on transport layer [{}], disconnecting from relevant node", e.getCause(), ctx.getChannel());
            ctx.getChannel().close();
            this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
        } else if (e.getCause() instanceof SizeHeaderFrameDecoder.HttpOnTransportException) {
            if (ctx.getChannel().isOpen()) {
                ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])e.getCause().getMessage().getBytes(Charsets.UTF_8));
                ChannelFuture channelFuture = ctx.getChannel().write((Object)buffer);
                channelFuture.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        future.getChannel().close();
                    }
                });
            }
        } else {
            this.logger.warn("exception caught on transport layer [{}], closing connection", e.getCause(), ctx.getChannel());
            ctx.getChannel().close();
            this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
        }
    }

    TransportAddress wrapAddress(SocketAddress socketAddress) {
        return new InetSocketTransportAddress((InetSocketAddress)socketAddress);
    }

    @Override
    public long serverOpen() {
        OpenChannelsHandler channels = this.serverOpenChannels;
        return channels == null ? 0L : channels.numberOfOpenChannels();
    }

    @Override
    public List<String> getLocalAddresses() {
        ArrayList<String> local = new ArrayList<String>();
        local.add("127.0.0.1");
        if (NetworkUtils.SUPPORTS_V6) {
            local.add("[::1]");
        }
        return local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendRequest(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
        Channel targetChannel = this.nodeChannel(node, options);
        if (this.compress) {
            options = TransportRequestOptions.builder(options).withCompress(true).build();
        }
        byte status = 0;
        status = TransportStatus.setRequest(status);
        ReleasableBytesStreamOutput bStream = new ReleasableBytesStreamOutput(this.bigArrays);
        boolean addedReleaseListener = false;
        try {
            ChannelBuffer buffer;
            ReleasablePagedBytesReference bytes;
            bStream.skip(19);
            StreamOutput stream = bStream;
            if (options.compress() && !(request instanceof BytesTransportRequest)) {
                status = TransportStatus.setCompress(status);
                stream = CompressorFactory.defaultCompressor().streamOutput(stream);
            }
            Version version = Version.smallest(this.version, node.version());
            stream.setVersion(version);
            stream.writeString(action);
            if (request instanceof BytesTransportRequest) {
                BytesTransportRequest bRequest = (BytesTransportRequest)request;
                assert (node.version().equals(bRequest.version()));
                bRequest.writeThin(stream);
                stream.close();
                bytes = bStream.bytes();
                ChannelBuffer headerBuffer = bytes.toChannelBuffer();
                ChannelBuffer contentBuffer = bRequest.bytes().toChannelBuffer();
                buffer = ChannelBuffers.wrappedBuffer((boolean)NettyUtils.DEFAULT_GATHERING, (ChannelBuffer[])new ChannelBuffer[]{headerBuffer, contentBuffer});
            } else {
                request.writeTo(stream);
                stream.close();
                bytes = bStream.bytes();
                buffer = bytes.toChannelBuffer();
            }
            NettyHeader.writeHeader(buffer, requestId, status, version);
            ChannelFuture future = targetChannel.write((Object)buffer);
            ReleaseChannelFutureListener listener = new ReleaseChannelFutureListener(bytes);
            future.addListener((ChannelFutureListener)listener);
            addedReleaseListener = true;
            this.transportServiceAdapter.onRequestSent(node, requestId, action, request, options);
            if (addedReleaseListener) return;
        }
        catch (Throwable throwable) {
            if (addedReleaseListener) throw throwable;
            Releasables.close(bStream.bytes());
            throw throwable;
        }
        Releasables.close(bStream.bytes());
    }

    @Override
    public boolean nodeConnected(DiscoveryNode node) {
        return this.connectedNodes.containsKey(node);
    }

    @Override
    public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
        this.connectToNode(node, true);
    }

    @Override
    public void connectToNode(DiscoveryNode node) {
        this.connectToNode(node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToNode(DiscoveryNode node, boolean light) {
        if (!this.lifecycle.started()) {
            throw new IllegalStateException("can't add nodes to a stopped transport");
        }
        if (node == null) {
            throw new ConnectTransportException(null, "can't connect to a null node");
        }
        this.globalLock.readLock().lock();
        try {
            this.connectionLock.acquire(node.id());
            try {
                if (!this.lifecycle.started()) {
                    throw new IllegalStateException("can't add nodes to a stopped transport");
                }
                NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.get(node);
                if (nodeChannels != null) {
                    return;
                }
                try {
                    if (light) {
                        nodeChannels = this.connectToChannelsLight(node);
                    } else {
                        nodeChannels = new NodeChannels(new Channel[this.connectionsPerNodeRecovery], new Channel[this.connectionsPerNodeBulk], new Channel[this.connectionsPerNodeReg], new Channel[this.connectionsPerNodeState], new Channel[this.connectionsPerNodePing]);
                        try {
                            this.connectToChannels(nodeChannels, node);
                        }
                        catch (Throwable e) {
                            this.logger.trace("failed to connect to [{}], cleaning dangling connections", e, node);
                            nodeChannels.close();
                            throw e;
                        }
                    }
                    nodeChannels.start();
                    this.connectedNodes.put(node, nodeChannels);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("connected to node [{}]", node);
                    }
                    this.transportServiceAdapter.raiseNodeConnected(node);
                }
                catch (ConnectTransportException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ConnectTransportException(node, "general node connection failure", e);
                }
            }
            finally {
                this.connectionLock.release(node.id());
            }
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    protected NodeChannels connectToChannelsLight(DiscoveryNode node) {
        InetSocketAddress address = ((InetSocketTransportAddress)node.address()).address();
        ChannelFuture connect = this.clientBootstrap.connect((SocketAddress)address);
        connect.awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
        if (!connect.isSuccess()) {
            throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connect.getCause());
        }
        Channel[] channels = new Channel[]{connect.getChannel()};
        channels[0].getCloseFuture().addListener((ChannelFutureListener)new ChannelCloseListener(node));
        return new NodeChannels(channels, channels, channels, channels, channels);
    }

    protected void connectToChannels(NodeChannels nodeChannels, DiscoveryNode node) {
        int i;
        ChannelFuture[] connectRecovery = new ChannelFuture[nodeChannels.recovery.length];
        ChannelFuture[] connectBulk = new ChannelFuture[nodeChannels.bulk.length];
        ChannelFuture[] connectReg = new ChannelFuture[nodeChannels.reg.length];
        ChannelFuture[] connectState = new ChannelFuture[nodeChannels.state.length];
        ChannelFuture[] connectPing = new ChannelFuture[nodeChannels.ping.length];
        InetSocketAddress address = ((InetSocketTransportAddress)node.address()).address();
        for (i = 0; i < connectRecovery.length; ++i) {
            connectRecovery[i] = this.clientBootstrap.connect((SocketAddress)address);
        }
        for (i = 0; i < connectBulk.length; ++i) {
            connectBulk[i] = this.clientBootstrap.connect((SocketAddress)address);
        }
        for (i = 0; i < connectReg.length; ++i) {
            connectReg[i] = this.clientBootstrap.connect((SocketAddress)address);
        }
        for (i = 0; i < connectState.length; ++i) {
            connectState[i] = this.clientBootstrap.connect((SocketAddress)address);
        }
        for (i = 0; i < connectPing.length; ++i) {
            connectPing[i] = this.clientBootstrap.connect((SocketAddress)address);
        }
        try {
            for (i = 0; i < connectRecovery.length; ++i) {
                connectRecovery[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectRecovery[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectRecovery[i].getCause());
                }
                ((NodeChannels)nodeChannels).recovery[i] = connectRecovery[i].getChannel();
                nodeChannels.recovery[i].getCloseFuture().addListener((ChannelFutureListener)new ChannelCloseListener(node));
            }
            for (i = 0; i < connectBulk.length; ++i) {
                connectBulk[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectBulk[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectBulk[i].getCause());
                }
                ((NodeChannels)nodeChannels).bulk[i] = connectBulk[i].getChannel();
                nodeChannels.bulk[i].getCloseFuture().addListener((ChannelFutureListener)new ChannelCloseListener(node));
            }
            for (i = 0; i < connectReg.length; ++i) {
                connectReg[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectReg[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectReg[i].getCause());
                }
                ((NodeChannels)nodeChannels).reg[i] = connectReg[i].getChannel();
                nodeChannels.reg[i].getCloseFuture().addListener((ChannelFutureListener)new ChannelCloseListener(node));
            }
            for (i = 0; i < connectState.length; ++i) {
                connectState[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectState[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectState[i].getCause());
                }
                ((NodeChannels)nodeChannels).state[i] = connectState[i].getChannel();
                nodeChannels.state[i].getCloseFuture().addListener((ChannelFutureListener)new ChannelCloseListener(node));
            }
            for (i = 0; i < connectPing.length; ++i) {
                connectPing[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectPing[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectPing[i].getCause());
                }
                ((NodeChannels)nodeChannels).ping[i] = connectPing[i].getChannel();
                nodeChannels.ping[i].getCloseFuture().addListener((ChannelFutureListener)new ChannelCloseListener(node));
            }
            if (nodeChannels.recovery.length == 0) {
                if (nodeChannels.bulk.length > 0) {
                    NodeChannels.access$402(nodeChannels, nodeChannels.bulk);
                } else {
                    NodeChannels.access$402(nodeChannels, nodeChannels.reg);
                }
            }
            if (nodeChannels.bulk.length == 0) {
                NodeChannels.access$502(nodeChannels, nodeChannels.reg);
            }
        }
        catch (RuntimeException e) {
            ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
            futures.addAll(Arrays.asList(connectRecovery));
            futures.addAll(Arrays.asList(connectBulk));
            futures.addAll(Arrays.asList(connectReg));
            futures.addAll(Arrays.asList(connectState));
            futures.addAll(Arrays.asList(connectPing));
            for (ChannelFuture future : Collections.unmodifiableList(futures)) {
                future.cancel();
                if (future.getChannel() == null || !future.getChannel().isOpen()) continue;
                try {
                    future.getChannel().close();
                }
                catch (Exception exception) {}
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectFromNode(DiscoveryNode node) {
        block5: {
            this.connectionLock.acquire(node.id());
            try {
                NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.remove(node);
                if (nodeChannels == null) break block5;
                try {
                    this.logger.debug("disconnecting from [{}] due to explicit disconnect call", node);
                    nodeChannels.close();
                }
                catch (Throwable throwable) {
                    this.logger.trace("disconnected from [{}] due to explicit disconnect call", node);
                    this.transportServiceAdapter.raiseNodeDisconnected(node);
                    throw throwable;
                }
                this.logger.trace("disconnected from [{}] due to explicit disconnect call", node);
                this.transportServiceAdapter.raiseNodeDisconnected(node);
            }
            finally {
                this.connectionLock.release(node.id());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean disconnectFromNode(DiscoveryNode node, Channel channel, String reason) {
        block5: {
            NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.get(node);
            if (nodeChannels == null || !nodeChannels.hasChannel(channel)) break block5;
            this.connectionLock.acquire(node.id());
            try {
                nodeChannels = (NodeChannels)this.connectedNodes.get(node);
                if (nodeChannels == null || !nodeChannels.hasChannel(channel)) break block5;
                this.connectedNodes.remove(node);
                try {
                    this.logger.debug("disconnecting from [{}], {}", node, reason);
                    nodeChannels.close();
                }
                catch (Throwable throwable) {
                    this.logger.trace("disconnected from [{}], {}", node, reason);
                    this.transportServiceAdapter.raiseNodeDisconnected(node);
                    throw throwable;
                }
                this.logger.trace("disconnected from [{}], {}", node, reason);
                this.transportServiceAdapter.raiseNodeDisconnected(node);
                boolean bl = true;
                return bl;
            }
            finally {
                this.connectionLock.release(node.id());
            }
        }
        return false;
    }

    protected void disconnectFromNodeChannel(final Channel channel, final Throwable failure) {
        this.threadPool().generic().execute(new Runnable(){

            @Override
            public void run() {
                DiscoveryNode node;
                Iterator i$ = NettyTransport.this.connectedNodes.keySet().iterator();
                while (i$.hasNext() && !NettyTransport.this.disconnectFromNode(node = (DiscoveryNode)i$.next(), channel, ExceptionsHelper.detailedMessage(failure))) {
                }
            }
        });
    }

    protected Channel nodeChannel(DiscoveryNode node, TransportRequestOptions options) throws ConnectTransportException {
        NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.get(node);
        if (nodeChannels == null) {
            throw new NodeNotConnectedException(node, "Node not connected");
        }
        return nodeChannels.channel(options.type());
    }

    public ChannelPipelineFactory configureClientChannelPipelineFactory() {
        return new ClientChannelPipelineFactory(this);
    }

    public ChannelPipelineFactory configureServerChannelPipelineFactory(String name, Settings settings) {
        return new ServerChannelPipelineFactory(this, name, settings);
    }

    static {
        NettyUtils.setup();
        DEFAULT_PING_SCHEDULE = TimeValue.timeValueMillis(-1L);
        BRACKET_PATTERN = Pattern.compile("^\\[(.*:.*)\\](?::([\\d\\-]*))?$");
    }

    class ScheduledPing
    extends AbstractRunnable {
        final CounterMetric successfulPings = new CounterMetric();
        final CounterMetric failedPings = new CounterMetric();

        ScheduledPing() {
        }

        @Override
        protected void doRun() throws Exception {
            if (NettyTransport.this.lifecycle.stoppedOrClosed()) {
                return;
            }
            for (Map.Entry entry : NettyTransport.this.connectedNodes.entrySet()) {
                DiscoveryNode node = (DiscoveryNode)entry.getKey();
                NodeChannels channels = (NodeChannels)entry.getValue();
                for (Channel channel : channels.allChannels) {
                    try {
                        ChannelFuture future = channel.write((Object)NettyHeader.pingHeader());
                        future.addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                ScheduledPing.this.successfulPings.inc();
                            }
                        });
                    }
                    catch (Throwable t) {
                        if (channel.isOpen()) {
                            NettyTransport.this.logger.debug("[{}] failed to send ping transport message", t, node);
                            this.failedPings.inc();
                            continue;
                        }
                        NettyTransport.this.logger.trace("[{}] failed to send ping transport message (channel closed)", t, node);
                    }
                }
            }
            NettyTransport.this.threadPool.schedule(NettyTransport.this.pingSchedule, "generic", this);
        }

        @Override
        public void onFailure(Throwable t) {
            if (NettyTransport.this.lifecycle.stoppedOrClosed()) {
                NettyTransport.this.logger.trace("failed to send ping transport message", t, new Object[0]);
            } else {
                NettyTransport.this.logger.warn("failed to send ping transport message", t, new Object[0]);
            }
        }
    }

    public static class NodeChannels {
        List<Channel> allChannels = Collections.emptyList();
        private Channel[] recovery;
        private final AtomicInteger recoveryCounter = new AtomicInteger();
        private Channel[] bulk;
        private final AtomicInteger bulkCounter = new AtomicInteger();
        private Channel[] reg;
        private final AtomicInteger regCounter = new AtomicInteger();
        private Channel[] state;
        private final AtomicInteger stateCounter = new AtomicInteger();
        private Channel[] ping;
        private final AtomicInteger pingCounter = new AtomicInteger();

        public NodeChannels(Channel[] recovery, Channel[] bulk, Channel[] reg, Channel[] state, Channel[] ping) {
            this.recovery = recovery;
            this.bulk = bulk;
            this.reg = reg;
            this.state = state;
            this.ping = ping;
        }

        public void start() {
            ArrayList<Channel> newAllChannels = new ArrayList<Channel>();
            newAllChannels.addAll(Arrays.asList(this.recovery));
            newAllChannels.addAll(Arrays.asList(this.bulk));
            newAllChannels.addAll(Arrays.asList(this.reg));
            newAllChannels.addAll(Arrays.asList(this.state));
            newAllChannels.addAll(Arrays.asList(this.ping));
            this.allChannels = Collections.unmodifiableList(newAllChannels);
        }

        public boolean hasChannel(Channel channel) {
            for (Channel channel1 : this.allChannels) {
                if (!channel.equals(channel1)) continue;
                return true;
            }
            return false;
        }

        public Channel channel(TransportRequestOptions.Type type) {
            if (type == TransportRequestOptions.Type.REG) {
                return this.reg[MathUtils.mod(this.regCounter.incrementAndGet(), this.reg.length)];
            }
            if (type == TransportRequestOptions.Type.STATE) {
                return this.state[MathUtils.mod(this.stateCounter.incrementAndGet(), this.state.length)];
            }
            if (type == TransportRequestOptions.Type.PING) {
                return this.ping[MathUtils.mod(this.pingCounter.incrementAndGet(), this.ping.length)];
            }
            if (type == TransportRequestOptions.Type.BULK) {
                return this.bulk[MathUtils.mod(this.bulkCounter.incrementAndGet(), this.bulk.length)];
            }
            if (type == TransportRequestOptions.Type.RECOVERY) {
                return this.recovery[MathUtils.mod(this.recoveryCounter.incrementAndGet(), this.recovery.length)];
            }
            throw new IllegalArgumentException("no type channel for [" + (Object)((Object)type) + "]");
        }

        public synchronized void close() {
            ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
            for (Channel channel : this.allChannels) {
                try {
                    if (channel == null || !channel.isOpen()) continue;
                    futures.add(channel.close());
                }
                catch (Exception exception) {}
            }
            for (ChannelFuture future : futures) {
                future.awaitUninterruptibly();
            }
        }

        static /* synthetic */ Channel[] access$402(NodeChannels x0, Channel[] x1) {
            x0.recovery = x1;
            return x1;
        }

        static /* synthetic */ Channel[] access$502(NodeChannels x0, Channel[] x1) {
            x0.bulk = x1;
            return x1;
        }
    }

    protected class ChannelCloseListener
    implements ChannelFutureListener {
        private final DiscoveryNode node;

        private ChannelCloseListener(DiscoveryNode node) {
            this.node = node;
        }

        public void operationComplete(final ChannelFuture future) throws Exception {
            NodeChannels nodeChannels = (NodeChannels)NettyTransport.this.connectedNodes.get(this.node);
            if (nodeChannels != null && nodeChannels.hasChannel(future.getChannel())) {
                NettyTransport.this.threadPool().generic().execute(new Runnable(){

                    @Override
                    public void run() {
                        NettyTransport.this.disconnectFromNode(ChannelCloseListener.this.node, future.getChannel(), "channel closed event");
                    }
                });
            }
        }
    }

    protected static class ServerChannelPipelineFactory
    implements ChannelPipelineFactory {
        protected final NettyTransport nettyTransport;
        protected final String name;
        protected final Settings settings;

        public ServerChannelPipelineFactory(NettyTransport nettyTransport, String name, Settings settings) {
            this.nettyTransport = nettyTransport;
            this.name = name;
            this.settings = settings;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline channelPipeline = Channels.pipeline();
            channelPipeline.addLast("openChannels", (ChannelHandler)this.nettyTransport.serverOpenChannels);
            SizeHeaderFrameDecoder sizeHeader = new SizeHeaderFrameDecoder();
            if (this.nettyTransport.maxCumulationBufferCapacity != null) {
                if (this.nettyTransport.maxCumulationBufferCapacity.bytes() > Integer.MAX_VALUE) {
                    sizeHeader.setMaxCumulationBufferCapacity(Integer.MAX_VALUE);
                } else {
                    sizeHeader.setMaxCumulationBufferCapacity((int)this.nettyTransport.maxCumulationBufferCapacity.bytes());
                }
            }
            if (this.nettyTransport.maxCompositeBufferComponents != -1) {
                sizeHeader.setMaxCumulationBufferComponents(this.nettyTransport.maxCompositeBufferComponents);
            }
            channelPipeline.addLast("size", (ChannelHandler)sizeHeader);
            channelPipeline.addLast("dispatcher", (ChannelHandler)new MessageChannelHandler(this.nettyTransport, this.nettyTransport.logger, this.name));
            return channelPipeline;
        }
    }

    protected static class ClientChannelPipelineFactory
    implements ChannelPipelineFactory {
        protected final NettyTransport nettyTransport;

        public ClientChannelPipelineFactory(NettyTransport nettyTransport) {
            this.nettyTransport = nettyTransport;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline channelPipeline = Channels.pipeline();
            SizeHeaderFrameDecoder sizeHeader = new SizeHeaderFrameDecoder();
            if (this.nettyTransport.maxCumulationBufferCapacity != null) {
                if (this.nettyTransport.maxCumulationBufferCapacity.bytes() > Integer.MAX_VALUE) {
                    sizeHeader.setMaxCumulationBufferCapacity(Integer.MAX_VALUE);
                } else {
                    sizeHeader.setMaxCumulationBufferCapacity((int)this.nettyTransport.maxCumulationBufferCapacity.bytes());
                }
            }
            if (this.nettyTransport.maxCompositeBufferComponents != -1) {
                sizeHeader.setMaxCumulationBufferComponents(this.nettyTransport.maxCompositeBufferComponents);
            }
            channelPipeline.addLast("size", (ChannelHandler)sizeHeader);
            channelPipeline.addLast("dispatcher", (ChannelHandler)new MessageChannelHandler(this.nettyTransport, this.nettyTransport.logger, ".client"));
            return channelPipeline;
        }
    }
}

