##############################################################################
##
#W  cat1data.g                  GAP4 package `XMod'              Chris Wensley
#W                                                                 & Murat Alp
##
##  This file contains data on cat1-groups and crossed modules up to size 70 
##
##  version 2.31, 21/10/2015 
##
#Y  Copyright (C) 2001-2015, Chris Wensley et al,  
#Y  School of Computer Science, Bangor University, U.K. 

##############################################################################
##
##  Cat1-structures for iso-classes of gps of size <= CAT1_LIST_MAX_SIZE
##

Info( InfoXMod, 1, "Loading cat1-group data into CAT1_LIST" );

CAT1_LIST := [
[1,1,"1",[[]],[
 ]],
[2,1,"C2",[[1,1]],[
 ]],
[3,1,"C3",[[1,1]],[
 ]],
[4,1,"C4",[[1,1]],[
 ]],
[4,2,"C2 x C2",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[1,1]],
  [[1,1],[]]]]],
[5,1,"C5",[[1,1]],[
 ]],
[6,1,"S3",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[6,2,"C6",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[7,1,"C7",[[1,1]],[
 ]],
[8,1,"C8",[[1,1]],[
 ]],
[8,2,"C4 x C2",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]],
[[[2,1]],
  [[2,1],[2,1]],
  [[],[2,1]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[3,1]]]]],
[8,3,"D8",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[1,1]],
  [[1,1],[1,1]]]]],
[8,4,"Q8",[[1,1],[2,1]],[
 ]],
[8,5,"C2 x C2 x C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[1,1],[1,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[1,1]]]]],
[9,1,"C9",[[1,1]],[
 ]],
[9,2,"C3 x C3",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[1,1]]]]],
[10,1,"D10",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[10,2,"C10",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[11,1,"C11",[[1,1]],[
 ]],
[12,1,"C3 : C4",[[1,1],[3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[12,2,"C12",[[1,1,2,1]],[
[[[2,1]],
  [[2,1]],
  [[2,1]]],
[[[1,1]],
  [[1,1]],
  [[1,1]]]]],
[12,3,"A4",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[12,4,"D12",[[1,1],[2,1,3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]]]],
[12,5,"C6 x C2",[[2,1],[1,1,3,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1]],
  [[1,1],[1,1]],
  [[],[1,1]]],
[[[3,1]],
  [[],[3,1]],
  [[],[3,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[1,1],[1,1,3,1]],
  [[],[1,1,3,1]]]]],
[13,1,"C13",[[1,1]],[
 ]],
[14,1,"D14",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[14,2,"C14",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[15,1,"C15",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[16,1,"C16",[[1,1]],[
 ]],
[16,2,"C4 x C4",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]],
[[[2,1]],
  [[],[2,1]],
  [[2,1],[2,1]]],
[[[2,1]],
  [[],[2,1]],
  [[4,1],[2,1]]]]],
[16,3,"(C4 x C2) : C2",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[4,1]]]]],
[16,4,"C4 : C4",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[4,1]]]]],
[16,5,"C8 x C2",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]],
[[[2,1]],
  [[],[2,1]],
  [[2,1],[2,1]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[4,1]]]]],
[16,6,"C8 : C2",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]]]],
[16,7,"D16",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[1,1]],
  [[1,1],[1,1]]]]],
[16,8,"QD16",[[1,1],[2,1]],[
[[[2,1]],
  [[2,1],[2,1]],
  [[2,1],[2,1]]]]],
[16,9,"Q16",[[1,1],[2,1]],[
 ]],
[16,10,"C4 x C2 x C2",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]],
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[2,1]]],
[[[2,1]],
  [[],[2,1],[]],
  [[2,1],[2,1],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[],[4,1]],
  [[1,1],[],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1]],
  [[],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1]],
  [[2,1],[2,1],[3,1]]],
[[[2,1],[1,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[2,1],[1,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[2,1]]],
[[[2,1],[1,1]],
  [[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[]]]]],
[16,11,"C2 x D8",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[1,1],[]],
  [[1,1],[1,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[1,1],[3,1]],
  [[1,1],[1,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[1,1],[3,1]],
  [[1,1],[1,1,3,1],[3,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[4,1]]]]],
[16,12,"C2 x Q8",[[1,1],[2,1],[3,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[]]]]],
[16,13,"(C4 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]]]],
[16,14,"C2 x C2 x C2 x C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[],[],[]]],
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[1,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[1,1],[2,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[1,1]]]]],
[17,1,"C17",[[1,1]],[
 ]],
[18,1,"D18",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[18,2,"C18",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[18,3,"C3 x S3",[[3,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1],[3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]]]],
[18,4,"(C3 x C3) : C2",[[1,1],[2,1],[2,1,3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[3,2],[]]]]],
[18,5,"C6 x C3",[[3,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[3,1]],
  [[3,1],[]],
  [[3,1],[]]],
[[[3,1]],
  [[3,1],[]],
  [[3,1],[3,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[2,1],[1,1,2,1]]],
[[[2,1],[3,1]],
  [[3,1],[2,1]],
  [[3,1],[2,1]]]]],
[19,1,"C19",[[1,1]],[
 ]],
[20,1,"C5 : C4",[[1,1],[3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[20,2,"C20",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[20,3,"C5 : C4",[[1,1],[3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[20,4,"D20",[[1,1],[2,1,3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]]]],
[20,5,"C10 x C2",[[2,1],[1,1,3,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1]],
  [[],[1,1]],
  [[1,1],[1,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[3,1]],
  [[],[3,1]],
  [[],[3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[1,1],[1,1,3,1]]]]],
[21,1,"C7 : C3",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[21,2,"C21",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[22,1,"D22",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[22,2,"C22",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[23,1,"C23",[[1,1]],[
 ]],
[24,1,"C3 : C8",[[1,1],[4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[24,2,"C24",[[1,1,2,1]],[
[[[2,1]],
  [[2,1]],
  [[2,1]]],
[[[1,1]],
  [[1,1]],
  [[1,1]]]]],
[24,3,"SL(2,3)",[[1,1],[2,1]],[
 ]],
[24,4,"C3 : Q8",[[1,1],[2,1,4,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[24,5,"C4 x S3",[[1,1],[2,1,4,1]],[
[[[1,1,3,1]],
  [[1,1,3,1],[]],
  [[1,1,3,1],[]]],
[[[4,1],[1,1,3,1]],
  [[1,1,3,1],[4,1]],
  [[1,1,3,1],[4,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[24,6,"D24",[[1,1],[2,1,4,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[]],
  [[1,1,2,1],[]]],
[[[4,1],[1,1,2,1]],
  [[1,1,2,1],[4,1]],
  [[1,1,2,1],[4,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[24,7,"C2 x (C3 : C4)",[[1,1],[2,1,4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[3,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[3,1,4,1]]]]],
[24,8,"(C6 x C2) : C2",[[1,1],[2,1,4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[4,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[24,9,"C12 x C2",[[2,1],[1,1,3,1]],[
[[[2,1]],
  [[2,1],[]],
  [[2,1],[]]],
[[[2,1]],
  [[2,1],[]],
  [[2,1],[2,1]]],
[[[3,1]],
  [[],[3,1]],
  [[],[3,1]]],
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1]],
  [[],[1,1]],
  [[4,1],[1,1]]],
[[[2,1,3,1]],
  [[2,1],[3,1]],
  [[2,1],[3,1]]],
[[[2,1,3,1]],
  [[2,1],[3,1]],
  [[2,1],[2,1,3,1]]],
[[[2,1],[1,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[4,1],[1,1,3,1]]]]],
[24,10,"C3 x D8",[[2,1],[1,1,3,1]],[
[[[1,1]],
  [[1,1],[1,1]],
  [[1,1],[1,1]]],
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1,3,1]],
  [[1,1],[1,1,3,1]],
  [[1,1],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]]]],
[24,11,"C3 x Q8",[[2,1],[1,1,3,1]],[
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]]]],
[24,12,"S4",[[2,1],[1,1,3,1]],[
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]]]],
[24,13,"C2 x A4",[[3,1],[1,1,2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]],
[[[2,1],[3,1]],
  [[3,1],[2,1]],
  [[3,1],[2,1]]]]],
[24,14,"C2 x C2 x S3",[[1,1],[3,1],[2,1,4,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[]],
  [[1,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[]],
  [[1,1],[3,1],[3,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[4,1]],
  [[1,1],[],[4,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[3,1],[2,1]],
  [[1,1],[3,1],[2,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[3,1],[4,1]],
  [[1,1],[3,1],[4,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[3,1],[3,1,4,1]],
  [[1,1],[3,1],[4,1]]]]],
[24,15,"C6 x C2 x C2",[[2,1],[3,1],[1,1,4,1]],[
[[[2,1]],
  [[2,1],[],[]],
  [[2,1],[],[]]],
[[[2,1]],
  [[2,1],[],[]],
  [[2,1],[2,1],[]]],
[[[4,1]],
  [[],[],[4,1]],
  [[],[],[4,1]]],
[[[1,1],[3,1]],
  [[],[3,1],[1,1]],
  [[],[3,1],[1,1]]],
[[[1,1],[3,1]],
  [[],[3,1],[1,1]],
  [[3,1],[3,1],[1,1]]],
[[[1,1,4,1]],
  [[],[],[1,1,4,1]],
  [[],[],[1,1,4,1]]],
[[[1,1,4,1]],
  [[],[],[1,1,4,1]],
  [[],[1,1],[1,1,4,1]]],
[[[1,1],[2,1],[3,1]],
  [[2,1],[3,1],[1,1]],
  [[2,1],[3,1],[1,1]]],
[[[3,1],[1,1,4,1]],
  [[],[3,1],[1,1,4,1]],
  [[],[3,1],[1,1,4,1]]],
[[[3,1],[1,1,4,1]],
  [[],[3,1],[1,1,4,1]],
  [[3,1],[3,1],[1,1,4,1]]]]],
[25,1,"C25",[[1,1]],[
 ]],
[25,2,"C5 x C5",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[1,1]]]]],
[26,1,"D26",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[26,2,"C26",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[27,1,"C27",[[1,1]],[
 ]],
[27,2,"C9 x C3",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]],
[[[2,1]],
  [[],[2,1]],
  [[2,1],[2,1]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[3,1]]]]],
[27,3,"(C3 x C3) : C3",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[27,4,"C9 : C3",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]]]],
[27,5,"C3 x C3 x C3",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[1,1]]]]],
[28,1,"C7 : C4",[[1,1],[3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[28,2,"C28",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[28,3,"D28",[[1,1],[2,1,3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]]]],
[28,4,"C14 x C2",[[2,1],[1,1,3,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1]],
  [[],[1,1]],
  [[1,1],[1,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[3,1]],
  [[],[3,1]],
  [[],[3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[1,1],[1,1,3,1]]]]],
[29,1,"C29",[[1,1]],[
 ]],
[30,1,"C5 x S3",[[3,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1],[3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]]]],
[30,2,"C3 x D10",[[3,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]],
[[[1,1],[3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]]]],
[30,3,"D30",[[1,1],[2,1,3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]]]],
[30,4,"C30",[[1,1,2,1,3,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]],
[[[3,1]],
  [[3,1]],
  [[3,1]]],
[[[1,1,2,1]],
  [[1,1,2,1]],
  [[1,1,2,1]]],
[[[1,1,3,1]],
  [[1,1,3,1]],
  [[1,1,3,1]]],
[[[2,1,3,1]],
  [[2,1,3,1]],
  [[2,1,3,1]]]]],
[31,1,"C31",[[1,1]],[
 ]],
[32,1,"C32",[[1,1]],[
 ]],
[32,2,"(C4 x C2) : C4",[[1,1],[2,1]],[
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]],
[[[1,1,2,1]],
  [[1,1,2,1],[]],
  [[1,1,2,1,3,1,4,1,5,1],[3,1,4,1,5,1]]]]],
[32,3,"C8 x C4",[[1,1],[2,1]],[
[[[2,1,3,1]],
  [[],[2,1,3,1]],
  [[],[2,1,3,1]]],
[[[2,1,3,1]],
  [[],[2,1,3,1]],
  [[2,1,3,1,4,1,5,1],[2,1,3,1,4,1,5,1]]],
[[[2,1,3,1]],
  [[],[2,1,3,1]],
  [[4,1,5,1],[2,1,3,1]]],
[[[1,1,3,1,4,1]],
  [[1,1,4,1],[]],
  [[1,1,4,1],[]]],
[[[1,1,3,1,4,1]],
  [[1,1,4,1],[]],
  [[1,1,4,1,5,1],[3,1]]],
[[[1,1,3,1,4,1]],
  [[1,1,4,1],[]],
  [[1,1,4,1],[5,1]]]]],
[32,4,"C8 : C4",[[1,1],[2,1]],[
[[[2,1,3,1]],
  [[],[2,1,3,1]],
  [[],[2,1,3,1]]],
[[[2,1,3,1]],
  [[],[2,1,3,1]],
  [[4,1,5,1],[2,1,3,1]]]]],
[32,5,"(C8 x C2) : C2",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[5,1]]]]],
[32,6,"((C4 x C2) : C2) : C2",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[4,1]],
  [[1,1],[4,1]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[32,7,"(C8 : C2) : C2",[[1,1],[2,1]],[
 ]],
[32,8,"C2 . ((C4 x C2) : C2) = (C2 x C2) . (C4 x C2)",[[1,1],[2,1]],[
 ]],
[32,9,"(C8 x C2) : C2",[[1,1],[2,1]],[
[[[2,1]],
  [[2,1],[2,1]],
  [[2,1],[2,1]]]]],
[32,10,"Q8 : C4",[[1,1],[2,1]],[
 ]],
[32,11,"(C4 x C4) : C2",[[1,1],[2,1]],[
[[[2,1]],
  [[2,1],[2,1]],
  [[2,1],[2,1]]]]],
[32,12,"C4 : C8",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[5,1]],
  [[1,1],[]]]]],
[32,13,"C8 : C4",[[1,1],[2,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[]],
  [[1,1,2,1],[]]],
[[[1,1,2,1]],
  [[1,1,2,1],[]],
  [[1,1,2,1,4,1,5,1],[4,1,5,1]]]]],
[32,14,"C8 : C4",[[1,1],[2,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[]],
  [[1,1,2,1],[]]],
[[[1,1,2,1,4,1]],
  [[1,1,2,1,4,1],[4,1]],
  [[1,1,2,1],[]]]]],
[32,15,"C4 . D8 = C4 . (C4 x C2)",[[1,1],[2,1]],[
 ]],
[32,16,"C16 x C2",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]],
[[[2,1]],
  [[],[2,1]],
  [[2,1],[2,1]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[5,1]]]]],
[32,17,"C16 : C2",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]]]],
[32,18,"D32",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[1,1]],
  [[1,1],[1,1]]]]],
[32,19,"QD32",[[1,1],[2,1]],[
[[[2,1]],
  [[2,1],[2,1]],
  [[2,1],[2,1]]]]],
[32,20,"Q32",[[1,1],[2,1]],[
 ]],
[32,21,"C4 x C4 x C2",[[1,1],[2,1],[3,1]],[
[[[3,1]],
  [[],[],[3,1]],
  [[],[],[3,1]]],
[[[3,1]],
  [[],[],[3,1]],
  [[3,1],[],[3,1]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[4,1]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[1,1],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[4,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[1,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[3,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[4,1],[3,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[4,1]]]]],
[32,22,"C2 x ((C4 x C2) : C2)",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1],[],[]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1],[],[4,1,5,1]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1,4,1,5,1],[4,1,5,1],[]]],
[[[2,1],[3,1,4,1]],
  [[],[2,1],[3,1,4,1]],
  [[],[2,1],[3,1,4,1]]],
[[[2,1],[3,1,4,1]],
  [[3,1,4,1],[2,1],[3,1,4,1]],
  [[],[2,1],[3,1,4,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1],[],[3,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1,3,1,4,1,5,1],[3,1,4,1,5,1],[3,1]]],
[[[3,1],[1,1,2,1,3,1]],
  [[1,1,2,1,3,1],[3,1],[3,1]],
  [[1,1,2,1,3,1,4,1,5,1],[3,1,4,1,5,1],[3,1]]],
[[[1,1],[2,1,3,1]],
  [[1,1],[2,1,3,1],[]],
  [[1,1],[2,1,3,1],[]]],
[[[1,1],[2,1,3,1,5,1]],
  [[1,1],[2,1,3,1,5,1],[5,1]],
  [[1,1],[2,1,3,1,4,1,5,1],[4,1,5,1]]],
[[[1,1],[2,1,3,1]],
  [[1,1],[2,1,3,1],[]],
  [[1,1],[2,1,3,1,4,1,5,1],[4,1,5,1]]]]],
[32,23,"C2 x (C4 : C4)",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[],[5,1]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[5,1],[]],
  [[1,1],[],[]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]],
  [[1,1],[5,1],[3,1,4,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[3,1,4,1],[3,1,4,1]],
  [[1,1],[5,1],[3,1,4,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1,4,1]],
  [[1,1,3,1,4,1],[2,1],[4,1]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1,5,1]],
  [[1,1,3,1,5,1],[2,1],[5,1]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1,5,1]],
  [[1,1,3,1,5,1],[2,1],[5,1]],
  [[1,1,3,1,4,1],[2,1],[4,1]]]]],
[32,24,"(C4 x C4) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[5,1],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[5,1]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[5,1],[5,1]]]]],
[32,25,"C4 x D8",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]],
[[[2,1]],
  [[2,1],[2,1],[]],
  [[2,1],[2,1],[]]],
[[[2,1,5,1],[1,1,3,1,5,1]],
  [[1,1,3,1,5,1],[2,1,5,1],[]],
  [[1,1,3,1,5,1],[2,1,5,1],[]]],
[[[2,1,5,1],[1,1,3,1,5,1]],
  [[1,1,3,1,5,1],[2,1,5,1],[]],
  [[1,1,3,1,4,1,5,1],[2,1,5,1],[4,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[5,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[1,1,3,1],[3,1]],
  [[1,1],[1,1,3,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[1,1,3,1],[3,1]],
  [[1,1],[1,1,3,1,5,1],[3,1]]]]],
[32,26,"C4 x Q8",[[1,1],[2,1],[3,1]],[
[[[2,1],[1,1,3,1,5,1]],
  [[1,1,3,1,5,1],[2,1],[4,1]],
  [[1,1,3,1,5,1],[2,1],[4,1]]],
[[[2,1],[1,1,3,1,4,1,5,1]],
  [[1,1,3,1,4,1,5,1],[2,1],[]],
  [[1,1,3,1,5,1],[2,1],[4,1]]]]],
[32,27,"(C2 x C2 x C2 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[2,1],[3,1]],
  [[3,1],[2,1],[3,1]],
  [[3,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1]],
  [[],[2,1],[3,1]]],
[[[1,1],[2,1,3,1,4,1]],
  [[1,1],[],[2,1,3,1,4,1]],
  [[1,1],[],[2,1,3,1,4,1]]],
[[[1,1],[2,1,3,1,5,1]],
  [[1,1],[2,1,3,1,5,1],[]],
  [[1,1],[2,1,3,1,4,1],[4,1,5,1]]],
[[[1,1],[2,1,3,1,5,1]],
  [[1,1],[2,1,3,1,5,1],[]],
  [[1,1],[],[2,1,3,1,4,1]]]]],
[32,28,"(C4 x C2 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1],[],[3,1]]],
[[[3,1],[1,1,2,1,5,1]],
  [[1,1,2,1,5,1],[5,1],[3,1]],
  [[1,1,2,1],[],[3,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[4,1]],
  [[1,1],[2,1,5,1],[]]]]],
[32,29,"(C2 x Q8) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[4,1]]]]],
[32,30,"(C4 x C2 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]]]],
[32,31,"(C4 x C4) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]]]],
[32,32,"(C2 x C2) . (C2 x C2 x C2)",[[1,1],[2,1],[3,1]],[
 ]],
[32,33,"(C4 x C4) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]]]],
[32,34,"(C4 x C4) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1,2,1,3,1]],
  [[1,1,2,1,3,1],[],[]],
  [[1,1,2,1,3,1],[],[]]],
[[[1,1,3,1],[2,1,5,1]],
  [[1,1,3,1],[2,1,5,1],[]],
  [[1,1,3,1],[2,1,5,1],[]]],
[[[1,1,3,1],[2,1,5,1]],
  [[1,1,3,1],[2,1,5,1],[]],
  [[1,1,3,1,4,1],[2,1,5,1],[4,1]]],
[[[1,1,3,1],[2,1,5,1]],
  [[1,1,3,1],[2,1,5,1],[]],
  [[1,1,2,1,3,1,5,1],[2,1,4,1,5,1],[2,1,4,1,5,1]]]]],
[32,35,"C4 : Q8",[[1,1],[2,1],[3,1]],[
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,2,1,3,1,4,1],[2,1],[2,1]]],
[[[2,1],[1,1,3,1,4,1]],
  [[1,1,3,1,4,1],[2,1],[4,1]],
  [[1,1,3,1],[2,1],[]]]]],
[32,36,"C8 x C2 x C2",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]],
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[2,1]]],
[[[2,1]],
  [[],[2,1],[]],
  [[2,1],[2,1],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1]],
  [[],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1]],
  [[2,1],[2,1],[3,1]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[5,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[2,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[5,1]]]]],
[32,37,"C2 x (C8 : C2)",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1]],
  [[],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1]],
  [[3,1],[2,1],[3,1]]],
[[[1,1],[2,1,3,1]],
  [[1,1],[2,1,3,1],[]],
  [[1,1],[2,1,3,1],[]]],
[[[1,1],[2,1,3,1,5,1]],
  [[1,1],[2,1,3,1,5,1],[5,1]],
  [[1,1],[2,1,3,1],[]]]]],
[32,38,"(C8 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]]]],
[32,39,"C2 x D16",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[2,1],[2,1],[]],
  [[2,1],[2,1],[]]],
[[[2,1],[3,1,5,1]],
  [[2,1],[2,1],[3,1,5,1]],
  [[2,1],[2,1],[3,1,5,1]]],
[[[2,1],[3,1,5,1]],
  [[2,1,3,1,5,1],[2,1],[3,1,5,1]],
  [[2,1],[2,1],[3,1,5,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[5,1]],
  [[1,1],[2,1],[]]]]],
[32,40,"C2 x QD16",[[1,1],[2,1],[3,1]],[
[[[2,1,3,1]],
  [[2,1,3,1],[2,1,3,1],[]],
  [[2,1,3,1],[2,1,3,1],[]]],
[[[2,1],[3,1,5,1]],
  [[2,1],[2,1],[3,1,5,1]],
  [[2,1],[2,1],[3,1,5,1]]],
[[[2,1],[3,1,5,1]],
  [[2,1,3,1,5,1],[2,1],[3,1,5,1]],
  [[2,1],[2,1],[3,1,5,1]]],
[[[1,1],[2,1,3,1]],
  [[1,1],[2,1,3,1],[]],
  [[1,1],[2,1,3,1],[]]],
[[[1,1],[2,1,3,1]],
  [[1,1],[2,1,3,1],[]],
  [[1,1],[2,1,3,1,5,1],[5,1]]]]],
[32,41,"C2 x Q16",[[1,1],[2,1],[3,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[5,1]]]]],
[32,42,"(C8 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[2,1],[2,1],[]],
  [[2,1],[2,1],[]]]]],
[32,43,"(C2 x D8) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1],[3,1]],
  [[2,1],[2,1],[3,1]],
  [[2,1],[2,1],[3,1]]]]],
[32,44,"(C2 x Q8) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[32,45,"C4 x C2 x C2 x C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1]],
  [[],[2,1],[],[]],
  [[],[2,1],[],[]]],
[[[2,1]],
  [[],[2,1],[],[]],
  [[],[2,1],[2,1],[]]],
[[[2,1]],
  [[],[2,1],[],[]],
  [[2,1],[2,1],[],[]]],
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[],[],[]]],
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[5,1],[],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1],[]],
  [[],[2,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1],[]],
  [[2,1],[2,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1],[]],
  [[],[2,1],[3,1],[3,1]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1],[]],
  [[2,1],[2,1],[3,1],[3,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[5,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[2,1],[5,1]]],
[[[2,1],[3,1],[4,1]],
  [[],[2,1],[3,1],[4,1]],
  [[],[2,1],[3,1],[4,1]]],
[[[2,1],[3,1],[4,1]],
  [[],[2,1],[3,1],[4,1]],
  [[2,1],[2,1],[3,1],[4,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[3,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[5,1]]]]],
[32,46,"C2 x C2 x D8",              ## redone 17/09/13
  [[1,1],[2,1],[3,1],[4,1]],[
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[],[],[]]],
[[[1,1]],
  [[1,1],[1,1],[],[]],
  [[1,1],[1,1],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[3,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[1,1],[3,1],[]],
  [[1,1],[1,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[1,1],[3,1],[]],
  [[1,1],[1,1,3,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[1,1],[3,1],[]],
  [[1,1],[1,1],[3,1],[3,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[5,1],[]]],
[[[1,1],[3,1],[4,1]],
  [[1,1],[],[3,1],[4,1]],
  [[1,1],[],[3,1],[4,1]]],
[[[1,1],[3,1],[4,1]],
  [[1,1],[],[3,1],[4,1]],
  [[1,1],[3,1],[3,1],[4,1]]],
[[[1,1],[3,1],[4,1]],
  [[1,1],[1,1],[3,1],[4,1]],
  [[1,1],[1,1],[3,1],[4,1]]],
[[[1,1],[3,1],[4,1]],
  [[1,1],[1,1],[3,1],[4,1]],
  [[1,1],[1,1,4,1],[3,1],[4,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[3,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[5,1]]]]],
[32,47,"C2 x C2 x Q8",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[5,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[5,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[3,1]]]]],
[32,48,"C2 x ((C4 x C2) : C2)",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1,2,1,3,1]],
  [[],[1,1,2,1,3,1],[],[]],
  [[],[1,1,2,1,3,1],[],[]]],
[[[1,1],[4,1,5,1]],
  [[1,1],[],[],[4,1,5,1]],
  [[1,1],[],[],[4,1,5,1]]],
[[[1,1],[4,1,5,1]],
  [[1,1],[],[],[4,1,5,1]],
  [[1,1],[],[4,1,5,1],[4,1,5,1]]],
[[[1,1],[4,1,5,1]],
  [[1,1],[4,1,5,1],[],[4,1,5,1]],
  [[1,1],[],[4,1,5,1],[4,1,5,1]]],
[[[1,1],[4,1,5,1]],
  [[1,1],[],[],[4,1,5,1]],
  [[1,1],[4,1,5,1],[],[4,1,5,1]]],
[[[2,1],[1,1,4,1],[3,1,4,1]],
  [[1,1,4,1],[2,1],[3,1,4,1],[]],
  [[1,1,4,1],[2,1],[3,1,4,1],[]]],
[[[2,1],[1,1,4,1],[3,1,4,1]],
  [[1,1,4,1],[2,1],[3,1,4,1],[]],
  [[1,1,4,1,5,1],[2,1],[3,1,4,1,5,1],[5,1]]]]],
[32,49,"(C2 x D8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[],[]],
  [[1,1,3,1],[2,1],[],[]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[],[1,1,3,1]],
  [[1,1,3,1],[2,1],[],[1,1,3,1]]],
[[[2,1],[1,1,3,1]],
  [[],[2,1],[1,1,3,1],[]],
  [[1,1,3,1],[2,1],[],[2,1]]],
[[[2,1],[1,1,3,1]],
  [[2,1],[2,1],[1,1,2,1,3,1,5,1],[1,1,3,1]],
  [[1,1,2,1,3,1,5,1],[2,1],[2,1], 
  [1,1,2,1,3,1,5,1]]]]],
[32,50,"(C2 x Q8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[32,51,"C2 x C2 x C2 x C2 x C2",[[1,1],[2,1],[3,1],[4,1],[5,1]],[
[[[1,1]],
  [[1,1],[],[],[],[]],
  [[1,1],[],[],[],[]]],
[[[1,1]],
  [[1,1],[],[],[],[]],
  [[1,1],[1,1],[],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[],[]],
  [[1,1],[2,1],[],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[],[]],
  [[1,1],[2,1],[1,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[],[]],
  [[1,1],[2,1],[1,1],[2,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[]],
  [[1,1],[2,1],[3,1],[],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[]],
  [[1,1],[2,1],[3,1],[1,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[]],
  [[1,1],[2,1],[3,1],[1,1],[2,1]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[1,1],[2,1],[3,1],[4,1],[]],
  [[1,1],[2,1],[3,1],[4,1],[]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[1,1],[2,1],[3,1],[4,1],[]],
  [[1,1],[2,1],[3,1],[4,1],[1,1]]]]],
[33,1,"C33",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[34,1,"D34",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[34,2,"C34",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[35,1,"C35",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[36,1,"C9 : C4",[[1,1],[3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[36,2,"C36",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[36,3,"(C2 x C2) : C9",[[1,1],[3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[36,4,"D36",[[1,1],[2,1,3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]]]],
[36,5,"C18 x C2",[[2,1],[1,1,3,1]],[
[[[2,1]],
  [[2,1],[]],
  [[2,1],[]]],
[[[2,1]],
  [[2,1],[]],
  [[2,1],[2,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[3,1]],
  [[],[3,1]],
  [[],[3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[1,1],[1,1,3,1]]]]],
[36,6,"C3 x (C3 : C4)",[[4,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1],[4,1]],
  [[4,1],[1,1]],
  [[4,1],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]]]],
[36,7,"(C3 x C3) : C4",[[1,1],[3,1],[3,1,4,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1],[4,1]],
  [[1,1],[],[4,1]],
  [[1,1],[],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[4,1]],
  [[1,1],[4,2],[]]]]],
[36,8,"C12 x C3",[[3,1],[1,1,2,1]],[
[[[3,1]],
  [[3,1],[]],
  [[3,1],[]]],
[[[3,1]],
  [[3,1],[]],
  [[3,1],[3,1]]],
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[2,1],[3,1]],
  [[3,1],[2,1]],
  [[3,1],[2,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[2,1],[1,1,2,1]]]]],
[36,9,"(C3 x C3) : C4",[[1,1],[3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[36,10,"S3 x S3",[[1,1,3,1],[2,1,4,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1,2,1],[3,1,4,1]],
  [[3,1,4,1],[1,1,2,1]],
  [[1,1,2,1],[3,1,4,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1]],
  [[1,1,3,1],[2,1]]]]],
[36,11,"C3 x A4",[[1,1],[2,1,3,1]],[
[[[1,1,2,2]],
  [[1,1,2,2],[]],
  [[1,1,2,2],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[3,1]],
  [[1,1,2,1],[3,1]]]]],
[36,12,"C6 x S3",[[1,1,3,1],[2,1,4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1,3,1]],
  [[1,1,3,1],[]],
  [[1,1,3,1],[]]],
[[[4,1],[1,1,2,1]],
  [[1,1,2,1],[4,1]],
  [[1,1,2,1],[4,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1]],
  [[1,1,3,1],[2,1]]],
[[[1,1],[2,1,4,1]],
  [[1,1],[2,1,4,1]],
  [[1,1],[2,1,4,1]]],
[[[4,1],[1,1,2,1,3,1]],
  [[1,1,2,1,3,1],[4,1]],
  [[1,1,2,1,3,1],[4,1]]]]],
[36,13,"C2 x ((C3 x C3) : C2)",[[1,1],[3,2],[2,1,3,1,4,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[],[2,1]],
  [[1,1],[],[2,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[3,2,4,2],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]]],
[[[1,1],[2,1,4,1]],
  [[1,1],[],[2,1,4,1]],
  [[1,1],[],[2,1,4,1]]],
[[[1,1],[2,1,4,1]],
  [[1,1],[4,2],[2,1,4,2]],
  [[1,1],[],[2,1,4,1]]],
[[[1,1],[3,1],[3,1,4,1]],
  [[1,1],[3,2],[3,1,4,1]],
  [[1,1],[3,2],[3,1,4,1]]]]],
[36,14,"C6 x C6",[[1,1,3,1],[2,1,4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[1,1]]],
[[[3,1]],
  [[3,1],[]],
  [[3,1],[]]],
[[[3,1]],
  [[3,1],[]],
  [[3,1],[3,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1,3,1]],
  [[1,1,3,1],[]],
  [[1,1,3,1],[]]],
[[[1,1,3,1]],
  [[1,1,3,1],[]],
  [[1,1,3,1],[1,1]]],
[[[1,1,3,1]],
  [[1,1,3,1],[]],
  [[1,1,3,1],[3,1]]],
[[[1,1,3,1]],
  [[1,1,3,1],[]],
  [[1,1,3,1],[1,1,3,1]]],
[[[3,1],[4,1]],
  [[3,1],[4,1]],
  [[3,1],[4,1]]],
[[[1,1,3,1],[2,1]],
  [[1,1,3,1],[2,1]],
  [[1,1,3,1],[2,1]]],
[[[1,1,3,1],[2,1]],
  [[1,1,3,1],[2,1]],
  [[1,1,3,1],[2,1,3,1]]],
[[[1,1,3,1],[4,1]],
  [[1,1,3,1],[4,1]],
  [[1,1,3,1],[4,1]]],
[[[1,1,3,1],[4,1]],
  [[1,1,3,1],[4,1]],
  [[1,1,3,1],[1,1,4,1]]]]],
[37,1,"C37",[[1,1]],[
 ]],
[38,1,"D38",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[38,2,"C38",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[39,1,"C13 : C3",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[39,2,"C39",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[40,1,"C5 : C8",[[1,1],[4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[40,2,"C40",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[40,3,"C5 : C8",[[1,1],[4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[40,4,"C5 : Q8",[[1,1],[2,1,4,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[40,5,"C4 x D10",[[1,1],[2,1,4,1]],[
[[[1,1,3,1]],
  [[1,1,3,1],[]],
  [[1,1,3,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[4,1],[1,1,3,1]],
  [[1,1,3,1],[4,1]],
  [[1,1,3,1],[4,1]]]]],
[40,6,"D40",[[1,1],[2,1,4,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[]],
  [[1,1,2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[4,1],[1,1,2,1]],
  [[1,1,2,1],[4,1]],
  [[1,1,2,1],[4,1]]]]],
[40,7,"C2 x (C5 : C4)",[[1,1],[2,1,4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[3,1]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[3,1,4,1]]]]],
[40,8,"(C10 x C2) : C2",[[1,1],[2,1,4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[4,1]]]]],
[40,9,"C20 x C2",[[2,1],[1,1,3,1]],[
[[[2,1]],
  [[2,1],[]],
  [[2,1],[]]],
[[[2,1]],
  [[2,1],[]],
  [[2,1],[2,1]]],
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1]],
  [[],[1,1]],
  [[4,1],[1,1]]],
[[[3,1]],
  [[],[3,1]],
  [[],[3,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[2,1,3,1]],
  [[2,1],[3,1]],
  [[2,1],[3,1]]],
[[[2,1,3,1]],
  [[2,1],[3,1]],
  [[2,1],[2,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[4,1],[1,1,3,1]]]]],
[40,10,"C5 x D8",[[2,1],[1,1,3,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1]],
  [[1,1],[1,1]],
  [[1,1],[1,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[1,1,3,1]],
  [[1,1],[1,1,3,1]],
  [[1,1],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]]]],
[40,11,"C5 x Q8",[[2,1],[1,1,3,1]],[
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]]]],
[40,12,"C2 x (C5 : C4)",[[1,1],[2,1,4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[4,1]]]]],
[40,13,"C2 x C2 x D10",[[1,1],[3,1],[2,1,4,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[]],
  [[1,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[3,1]],
  [[1,1],[3,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[3,1],[2,1]],
  [[1,1],[3,1],[2,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[4,1]],
  [[1,1],[],[4,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[3,1],[4,1]],
  [[1,1],[3,1],[4,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[3,1],[4,1]],
  [[1,1],[3,1],[3,1,4,1]]]]],
[40,14,"C10 x C2 x C2",[[2,1],[3,1],[1,1,4,1]],[
[[[2,1]],
  [[2,1],[],[]],
  [[2,1],[],[]]],
[[[2,1]],
  [[2,1],[],[]],
  [[2,1],[2,1],[]]],
[[[2,1],[3,1]],
  [[2,1],[3,1],[]],
  [[2,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[2,1],[3,1],[]],
  [[2,1],[3,1],[3,1]]],
[[[4,1]],
  [[],[],[4,1]],
  [[],[],[4,1]]],
[[[1,1],[2,1],[3,1]],
  [[2,1],[3,1],[1,1]],
  [[2,1],[3,1],[1,1]]],
[[[1,1,4,1]],
  [[],[],[1,1,4,1]],
  [[],[],[1,1,4,1]]],
[[[1,1,4,1]],
  [[],[],[1,1,4,1]],
  [[1,1],[],[1,1,4,1]]],
[[[2,1],[1,1,4,1]],
  [[2,1],[],[1,1,4,1]],
  [[2,1],[],[1,1,4,1]]],
[[[2,1],[1,1,4,1]],
  [[2,1],[],[1,1,4,1]],
  [[2,1],[2,1],[1,1,4,1]]]]],
[41,1,"C41",[[1,1]],[
 ]],
[42,1,"(C7 : C3) : C2",[[3,1],[1,1,2,1]],[
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]]]],
[42,2,"C2 x (C7 : C3)",[[3,1],[1,1,2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]],
[[[2,1],[3,1]],
  [[3,1],[2,1]],
  [[3,1],[2,1]]]]],
[42,3,"C7 x S3",[[3,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1],[3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]]]],
[42,4,"C3 x D14",[[3,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]],
[[[1,1],[3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]]]],
[42,5,"D42",[[1,1],[2,1,3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]]]],
[42,6,"C42",[[1,1,2,1,3,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]],
[[[1,1,2,1]],
  [[1,1,2,1]],
  [[1,1,2,1]]],
[[[3,1]],
  [[3,1]],
  [[3,1]]],
[[[1,1,3,1]],
  [[1,1,3,1]],
  [[1,1,3,1]]],
[[[2,1,3,1]],
  [[2,1,3,1]],
  [[2,1,3,1]]]]],
[43,1,"C43",[[1,1]],[
 ]],
[44,1,"C11 : C4",[[1,1],[3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[44,2,"C44",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[44,3,"D44",[[1,1],[2,1,3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]]]],
[44,4,"C22 x C2",[[2,1],[1,1,3,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1]],
  [[],[1,1]],
  [[1,1],[1,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[3,1]],
  [[],[3,1]],
  [[],[3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[1,1],[1,1,3,1]]]]],
[45,1,"C45",[[1,1,2,1]],[
[[[2,1]],
  [[2,1]],
  [[2,1]]],
[[[1,1]],
  [[1,1]],
  [[1,1]]]]],
[45,2,"C15 x C3",[[2,1],[1,1,3,1]],[
[[[2,1]],
  [[2,1],[]],
  [[2,1],[]]],
[[[2,1]],
  [[2,1],[]],
  [[2,1],[2,1]]],
[[[3,1]],
  [[],[3,1]],
  [[],[3,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[1,1],[1,1,3,1]]]]],
[46,1,"D46",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[46,2,"C46",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[47,1,"C47",[[1,1]],[
 ]],
[48,1,"C3 : C16",[[1,1],[5,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[48,2,"C48",[[1,1,2,1]],[
[[[2,1]],
  [[2,1]],
  [[2,1]]],
[[[1,1]],
  [[1,1]],
  [[1,1]]]]],
[48,3,"(C4 x C4) : C3",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[48,4,"C8 x S3",[[1,1],[2,1,5,1]],[
[[[1,1,4,1]],
  [[1,1,4,1],[]],
  [[1,1,4,1],[]]],
[[[5,1],[1,1,4,1]],
  [[1,1,4,1],[5,1]],
  [[1,1,4,1],[5,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[48,5,"C24 : C2",[[1,1],[2,1,5,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[5,1]],
  [[1,1],[5,1]],
  [[1,1],[5,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[48,6,"C24 : C2",[[1,1],[2,1,5,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[5,1]],
  [[1,1],[5,1]],
  [[1,1],[5,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[48,7,"D48",[[1,1],[2,1,5,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[5,1]],
  [[1,1],[5,1]],
  [[1,1],[5,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[48,8,"C3 : Q16",[[1,1],[2,1,5,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[48,9,"C2 x (C3 : C8)",[[1,1],[2,1,5,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[4,1]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[5,1]],
  [[1,1],[5,1]],
  [[1,1],[5,1]]],
[[[1,1],[5,1]],
  [[1,1],[4,1,5,1]],
  [[1,1],[5,1]]]]],
[48,10,"(C3 : C8) : C2",[[1,1],[2,1,5,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[48,11,"C4 x (C3 : C4)",[[1,1],[2,1,5,1]],[
[[[1,1,4,1]],
  [[1,1,4,1],[]],
  [[1,1,4,1],[]]],
[[[1,1,4,1]],
  [[1,1,4,1],[3,1]],
  [[1,1,4,1],[]]],
[[[5,1],[1,1,4,1]],
  [[1,1,4,1],[5,1]],
  [[1,1,4,1],[5,1]]],
[[[5,1],[1,1,4,1]],
  [[1,1,4,1],[5,1]],
  [[1,1,4,1],[3,1,5,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[48,12,"(C3 : C4) : C4",[[1,1],[2,1,5,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[48,13,"C12 : C4",[[1,1],[2,1,5,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[3,1]],
  [[1,1],[]]],
[[[1,1],[5,1]],
  [[1,1],[5,1]],
  [[1,1],[5,1]]],
[[[1,1],[5,1]],
  [[1,1],[5,1]],
  [[1,1],[3,1,5,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[48,14,"(C12 x C2) : C2",[[1,1],[2,1,5,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[5,1]],
  [[1,1],[5,1]],
  [[1,1],[5,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[48,15,"(C3 x D8) : C2",[[1,1],[2,1,5,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[48,16,"(C3 : C8) : C2",[[1,1],[2,1,5,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[48,17,"(C3 x Q8) : C2",[[1,1],[2,1,5,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[48,18,"C3 : Q16",[[1,1],[2,1,5,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[48,19,"(C2 x (C3 : C4)) : C2",[[1,1],[2,1,5,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[3,1]],
  [[1,1],[]]],
[[[1,1],[5,1]],
  [[1,1],[5,1]],
  [[1,1],[5,1]]],
[[[1,1],[5,1]],
  [[1,1],[3,1,5,1]],
  [[1,1],[5,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[48,20,"C12 x C4",[[2,1],[1,1,3,1]],[
[[[3,1]],
  [[],[3,1]],
  [[],[3,1]]],
[[[2,1]],
  [[2,1],[]],
  [[2,1],[]]],
[[[2,1]],
  [[2,1],[]],
  [[2,1],[5,1]]],
[[[2,1]],
  [[2,1],[]],
  [[2,1],[2,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[4,1],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[1,1],[1,1,3,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]]]],
[48,21,"C3 x ((C4 x C2) : C2)",[[2,1],[1,1,3,1]],[
[[[2,1]],
  [[2,1],[]],
  [[2,1],[]]],
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1]],
  [[],[1,1]],
  [[5,1],[1,1]]],
[[[2,1,3,1,5,1]],
  [[2,1,5,1],[3,1]],
  [[2,1,5,1],[3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[5,1],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]]]],
[48,22,"C3 x (C4 : C4)",[[2,1],[1,1,3,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1]],
  [[],[1,1]],
  [[5,1],[1,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[5,1],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]]]],
[48,23,"C24 x C2",[[2,1],[1,1,3,1]],[
[[[2,1]],
  [[2,1],[]],
  [[2,1],[]]],
[[[2,1]],
  [[2,1],[]],
  [[2,1],[2,1]]],
[[[3,1]],
  [[],[3,1]],
  [[],[3,1]]],
[[[2,1,3,1]],
  [[2,1],[3,1]],
  [[2,1],[3,1]]],
[[[2,1,3,1]],
  [[2,1],[3,1]],
  [[2,1],[2,1,3,1]]],
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1]],
  [[],[1,1]],
  [[5,1],[1,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[5,1],[1,1,3,1]]]]],
[48,24,"C3 x (C8 : C2)",[[2,1],[1,1,3,1]],[
[[[2,1]],
  [[2,1],[]],
  [[2,1],[]]],
[[[2,1,3,1]],
  [[2,1],[3,1]],
  [[2,1],[3,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]]]],
[48,25,"C3 x D16",[[2,1],[1,1,3,1]],[
[[[1,1]],
  [[1,1],[1,1]],
  [[1,1],[1,1]]],
[[[2,1,3,1]],
  [[2,1],[2,1,3,1]],
  [[2,1],[2,1,3,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]]]],
[48,26,"C3 x QD16",[[2,1],[1,1,3,1]],[
[[[2,1]],
  [[2,1],[2,1]],
  [[2,1],[2,1]]],
[[[2,1,3,1]],
  [[2,1],[2,1,3,1]],
  [[2,1],[2,1,3,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]]]],
[48,27,"C3 x Q16",[[2,1],[1,1,3,1]],[
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]]]],
[48,28,"C2 . S4 = SL(2,3) . C2",[[2,1],[1,1,3,1]],[
 ]],
[48,29,"GL(2,3)",[[2,1],[1,1,3,1]],[
 ]],
[48,30,"A4 : C4",[[3,1],[1,1,4,1]],[
[[[1,1],[3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]]]],
[48,31,"C4 x A4",[[4,1],[1,1,2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]],
[[[2,1],[4,1]],
  [[4,1],[2,1]],
  [[4,1],[2,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]]]],
[48,32,"C2 x SL(2,3)",[[3,1],[1,1,2,1]],[
[[[2,1],[3,1]],
  [[3,1],[2,1]],
  [[3,1],[2,1]]],
[[[2,1],[3,1]],
  [[3,1],[2,1]],
  [[3,1],[2,1,5,1]]]]],
[48,33,"SL(2,3) : C2",[[3,1],[1,1,2,1]],[
 ]],
[48,34,"C2 x (C3 : Q8)",[[1,1],[3,1],[2,1,5,1]],[
[[[1,1],[3,1]],
  [[1,1],[3,1],[]],
  [[1,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[4,1]],
  [[1,1],[3,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[3,1],[2,1]],
  [[1,1],[3,1],[2,1]]],
[[[1,1],[3,1,5,1]],
  [[1,1],[3,1],[5,1]],
  [[1,1],[3,1],[5,1]]],
[[[1,1],[3,1,5,1]],
  [[1,1],[3,1],[5,1]],
  [[1,1],[3,1],[4,1,5,1]]]]],
[48,35,"C2 x C4 x S3",[[1,1],[3,1],[2,1,5,1]],[
[[[1,1,4,1]],
  [[1,1,4,1],[],[]],
  [[1,1,4,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[],[2,1]],
  [[1,1],[],[2,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[2,1]],
  [[1,1],[],[2,1]]],
[[[5,1],[1,1,2,1]],
  [[1,1,2,1],[],[5,1]],
  [[1,1,2,1],[],[5,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[]],
  [[1,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[4,1]],
  [[1,1],[3,1],[]]],
[[[1,1,4,1],[2,1,5,1]],
  [[1,1,4,1],[],[2,1,5,1]],
  [[1,1,4,1],[],[2,1,5,1]]],
[[[1,1,4,1],[2,1,5,1]],
  [[1,1,4,1],[2,1],[2,1,5,1]],
  [[1,1,4,1],[],[2,1,5,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[3,1],[2,1]],
  [[1,1],[3,1],[2,1]]],
[[[1,1],[3,1,5,1]],
  [[1,1],[3,1],[5,1]],
  [[1,1],[3,1],[5,1]]],
[[[1,1],[3,1,5,1]],
  [[1,1],[3,1],[4,1,5,1]],
  [[1,1],[3,1],[5,1]]]]],
[48,36,"C2 x D24",[[1,1],[3,1],[2,1,5,1]],[
[[[1,1,3,1]],
  [[1,1,3,1],[],[]],
  [[1,1,3,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[],[2,1]],
  [[1,1],[],[2,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[2,1]],
  [[1,1],[],[2,1]]],
[[[5,1],[1,1,3,1]],
  [[1,1,3,1],[],[5,1]],
  [[1,1,3,1],[],[5,1]]],
[[[1,1],[2,1,3,1]],
  [[1,1],[2,1,3,1],[]],
  [[1,1],[2,1,3,1],[]]],
[[[1,1],[2,1,3,1,4,1]],
  [[1,1],[2,1,3,1,4,1],[4,1]],
  [[1,1],[2,1,3,1],[]]],
[[[1,1],[2,1,4,1,5,1]],
  [[1,1],[],[2,1,4,1,5,1]],
  [[1,1],[],[2,1,4,1,5,1]]],
[[[1,1],[2,1,4,1,5,1]],
  [[1,1],[],[2,1,4,1,5,1]],
  [[1,1],[2,1,4,1],[2,1,4,1,5,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[3,1],[2,1]],
  [[1,1],[3,1],[2,1]]],
[[[1,1],[3,1,5,1]],
  [[1,1],[3,1],[5,1]],
  [[1,1],[3,1],[5,1]]],
[[[1,1],[3,1,5,1]],
  [[1,1],[3,1],[5,1]],
  [[1,1],[3,1],[4,1,5,1]]]]],
[48,37,"(C12 x C2) : C2",[[1,1],[3,1],[2,1,5,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1],[5,1]],
  [[1,1],[],[5,1]],
  [[1,1],[],[5,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[3,1],[2,1]],
  [[1,1],[3,1],[2,1]]]]],
[48,38,"D8 x S3",[[1,1],[3,1],[2,1,5,1]],[
[[[1,1],[2,1]],
  [[1,1],[],[2,1]],
  [[1,1],[],[2,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[2,1]],
  [[1,1],[2,1],[2,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1],[2,1,5,1]],
  [[1,1],[2,1],[2,1,5,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[],[2,1,5,1]],
  [[1,1],[],[2,1,5,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[3,1],[2,1]],
  [[1,1],[3,1],[2,1]]]]],
[48,39,"(C2 x (C3 : C4)) : C2",[[1,1],[3,1],[2,1,5,1]],[
[[[1,1],[2,1],[3,1]],
  [[1,1],[3,1],[2,1]],
  [[1,1],[3,1],[2,1]]]]],
[48,40,"Q8 x S3",[[1,1],[3,1],[2,1,5,1]],[
[[[1,1],[2,1],[3,1]],
  [[1,1],[3,1],[2,1]],
  [[1,1],[3,1],[2,1]]]]],
[48,41,"(C4 x S3) : C2",[[1,1],[3,1],[2,1,5,1]],[
[[[1,1],[2,1],[3,1]],
  [[1,1],[3,1],[2,1]],
  [[1,1],[3,1],[2,1]]]]],
[48,42,"C2 x C2 x (C3 : C4)",[[1,1],[3,1],[2,1,5,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[4,1],[4,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[3,1],[]],
  [[1,1,2,1],[3,1],[]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[3,1],[]],
  [[1,1,2,1,3,1,4,1],[3,1],[3,1,4,1]]],
[[[3,1],[1,1,2,1,3,1]],
  [[1,1,2,1,3,1],[3,1],[3,1]],
  [[1,1,2,1,3,1,4,1],[3,1],[3,1,4,1]]],
[[[1,1],[5,1]],
  [[1,1],[],[5,1]],
  [[1,1],[],[5,1]]],
[[[1,1],[5,1]],
  [[1,1],[],[5,1]],
  [[1,1],[4,1],[4,1,5,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[3,1],[2,1]],
  [[1,1],[3,1],[2,1]]],
[[[1,1],[3,1,5,1]],
  [[1,1],[3,1],[5,1]],
  [[1,1],[3,1],[5,1]]],
[[[1,1],[3,1,5,1]],
  [[1,1],[3,1],[3,1,5,1]],
  [[1,1],[3,1],[5,1]]],
[[[1,1],[3,1,5,1]],
  [[1,1],[3,1],[4,1,5,1]],
  [[1,1],[3,1],[5,1]]]]],
[48,43,"C2 x ((C6 x C2) : C2)",[[1,1],[3,1],[2,1,5,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[],[2,1]],
  [[1,1],[],[2,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[2,1]],
  [[1,1],[],[2,1]]],
[[[5,1],[1,1,2,1]],
  [[1,1,2,1],[],[5,1]],
  [[1,1,2,1],[],[5,1]]],
[[[1,1],[2,1,3,1]],
  [[1,1],[2,1,3,1],[]],
  [[1,1],[2,1,3,1],[]]],
[[[1,1],[2,1,3,1]],
  [[1,1],[2,1,3,1],[]],
  [[1,1],[2,1,3,1,4,1],[4,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[],[2,1,5,1]],
  [[1,1],[],[2,1,5,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1],[2,1,5,1]],
  [[1,1],[],[2,1,5,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[3,1],[2,1]],
  [[1,1],[3,1],[2,1]]],
[[[1,1],[3,1,5,1]],
  [[1,1],[3,1],[5,1]],
  [[1,1],[3,1],[5,1]]],
[[[1,1],[3,1,5,1]],
  [[1,1],[3,1],[5,1]],
  [[1,1],[3,1],[4,1,5,1]]]]],
[48,44,"C12 x C2 x C2",[[2,1],[3,1],[1,1,4,1]],[
[[[2,1]],
  [[2,1],[],[]],
  [[2,1],[],[]]],
[[[2,1]],
  [[2,1],[],[]],
  [[2,1],[2,1],[]]],
[[[2,1]],
  [[2,1],[],[]],
  [[2,1],[],[2,1]]],
[[[4,1]],
  [[],[],[4,1]],
  [[],[],[4,1]]],
[[[1,1]],
  [[],[],[1,1]],
  [[],[],[1,1]]],
[[[1,1]],
  [[],[],[1,1]],
  [[5,1],[],[1,1]]],
[[[2,1],[3,1]],
  [[2,1],[3,1],[]],
  [[2,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[2,1],[3,1],[]],
  [[2,1],[3,1],[3,1]]],
[[[2,1,4,1]],
  [[2,1],[],[4,1]],
  [[2,1],[],[4,1]]],
[[[2,1,4,1]],
  [[2,1],[],[4,1]],
  [[2,1],[2,1],[4,1]]],
[[[2,1,4,1]],
  [[2,1],[],[4,1]],
  [[2,1],[],[2,1,4,1]]],
[[[1,1],[2,1]],
  [[2,1],[],[1,1]],
  [[2,1],[],[1,1]]],
[[[1,1],[2,1]],
  [[2,1],[],[1,1]],
  [[2,1],[2,1],[1,1]]],
[[[1,1],[2,1]],
  [[2,1],[],[1,1]],
  [[2,1],[5,1],[1,1]]],
[[[2,1,4,1],[3,1]],
  [[2,1],[3,1],[4,1]],
  [[2,1],[3,1],[4,1]]],
[[[2,1,4,1],[3,1]],
  [[2,1],[3,1],[4,1]],
  [[2,1],[3,1],[2,1,4,1]]],
[[[1,1,4,1]],
  [[],[],[1,1,4,1]],
  [[],[],[1,1,4,1]]],
[[[1,1,4,1]],
  [[],[],[1,1,4,1]],
  [[5,1],[],[1,1,4,1]]],
[[[1,1],[2,1],[3,1]],
  [[2,1],[3,1],[1,1]],
  [[2,1],[3,1],[1,1]]],
[[[1,1,4,1],[2,1]],
  [[2,1],[],[1,1,4,1]],
  [[2,1],[],[1,1,4,1]]],
[[[1,1,4,1],[2,1]],
  [[2,1],[],[1,1,4,1]],
  [[2,1],[2,1],[1,1,4,1]]],
[[[1,1,4,1],[2,1]],
  [[2,1],[],[1,1,4,1]],
  [[2,1],[5,1],[1,1,4,1]]]]],
[48,45,"C6 x D8",[[2,1],[3,1],[1,1,4,1]],[
[[[1,1]],
  [[],[],[1,1]],
  [[],[],[1,1]]],
[[[1,1]],
  [[1,1],[],[1,1]],
  [[1,1],[],[1,1]]],
[[[2,1],[3,1,5,1]],
  [[2,1],[3,1,5,1],[2,1]],
  [[2,1],[3,1,5,1],[2,1]]],
[[[2,1],[3,1,5,1]],
  [[2,1],[3,1,5,1],[2,1]],
  [[2,1],[3,1,5,1],[2,1,3,1,5,1]]],
[[[2,1],[3,1,5,1]],
  [[2,1],[3,1,5,1],[]],
  [[2,1],[3,1,5,1],[]]],
[[[2,1],[3,1,5,1]],
  [[2,1],[3,1,5,1],[3,1,5,1]],
  [[2,1],[3,1,5,1],[]]],
[[[1,1,3,1,4,1]],
  [[],[],[1,1,3,1,4,1]],
  [[],[],[1,1,3,1,4,1]]],
[[[1,1,3,1,4,1]],
  [[1,1,3,1],[],[1,1,3,1,4,1]],
  [[1,1,3,1],[],[1,1,3,1,4,1]]],
[[[1,1],[2,1]],
  [[2,1],[],[1,1]],
  [[2,1],[],[1,1]]],
[[[1,1],[2,1]],
  [[2,1],[5,1],[1,1]],
  [[2,1],[],[1,1]]],
[[[3,1],[1,1,4,1]],
  [[1,1],[3,1],[1,1,4,1]],
  [[1,1],[3,1],[1,1,4,1]]],
[[[3,1],[1,1,4,1]],
  [[1,1],[3,1],[1,1,4,1]],
  [[1,1,3,1],[3,1],[1,1,4,1]]],
[[[3,1],[1,1,4,1]],
  [[],[3,1],[1,1,4,1]],
  [[],[3,1],[1,1,4,1]]],
[[[3,1],[1,1,4,1]],
  [[],[3,1],[1,1,4,1]],
  [[3,1],[3,1],[1,1,4,1]]],
[[[1,1],[2,1],[3,1]],
  [[2,1],[3,1],[1,1]],
  [[2,1],[3,1],[1,1]]],
[[[2,1],[1,1,4,1]],
  [[2,1],[],[1,1,4,1]],
  [[2,1],[],[1,1,4,1]]],
[[[2,1],[1,1,4,1]],
  [[2,1],[5,1],[1,1,4,1]],
  [[2,1],[],[1,1,4,1]]]]],
[48,46,"C6 x Q8",[[2,1],[3,1],[1,1,4,1]],[
[[[1,1],[2,1]],
  [[2,1],[],[1,1]],
  [[2,1],[],[1,1]]],
[[[1,1],[2,1]],
  [[2,1],[5,1],[1,1]],
  [[2,1],[],[1,1]]],
[[[1,1],[2,1],[3,1]],
  [[2,1],[3,1],[1,1]],
  [[2,1],[3,1],[1,1]]],
[[[2,1],[1,1,4,1]],
  [[2,1],[],[1,1,4,1]],
  [[2,1],[],[1,1,4,1]]],
[[[2,1],[1,1,4,1]],
  [[2,1],[],[1,1,4,1]],
  [[2,1],[5,1],[1,1,4,1]]]]],
[48,47,"C3 x ((C4 x C2) : C2)",[[2,1],[3,1],[1,1,4,1]],[
[[[1,1]],
  [[],[],[1,1]],
  [[],[],[1,1]]],
[[[1,1,4,1]],
  [[],[],[1,1,4,1]],
  [[],[],[1,1,4,1]]],
[[[1,1],[2,1],[3,1]],
  [[2,1],[3,1],[1,1]],
  [[2,1],[3,1],[1,1]]]]],
[48,48,"C2 x S4",[[1,1,4,1],[2,1,3,1]],[
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[3,1]],
  [[1,1,2,1],[3,1]]],
[[[1,1],[2,1,3,1]],
  [[1,1],[2,1,3,1]],
  [[1,1],[2,1,3,1]]],
[[[3,1],[1,1,4,1]],
  [[1,1,4,1],[3,1]],
  [[1,1,4,1],[3,1]]]]],
[48,49,"C2 x C2 x A4",[[1,1,3,1],[2,1,4,1]],[
[[[3,1]],
  [[3,1],[]],
  [[3,1],[]]],
[[[1,1,2,1,3,1]],
  [[1,1,2,1,3,1],[]],
  [[1,1,2,1,3,1],[]]],
[[[1,1,2,1,3,1]],
  [[3,1],[1,1,2,1]],
  [[1,1,2,1,3,1],[]]],
[[[3,1],[4,1]],
  [[3,1],[4,1]],
  [[3,1],[4,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1]],
  [[1,1,3,1],[2,1]]],
[[[4,1],[1,1,2,1,3,1]],
  [[1,1,2,1,3,1],[4,1]],
  [[1,1,2,1,3,1],[4,1]]],
[[[4,1],[1,1,2,1,3,1]],
  [[3,1],[1,1,2,1,4,1]],
  [[1,1,2,1,3,1],[4,1]]]]],
[48,50,"(C2 x C2 x C2 x C2) : C3",[[1,1],[2,1],[2,1,4,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[2,1]],
  [[1,1],[2,1],[2,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[2,1]]]]],
[48,51,"C2 x C2 x C2 x S3",[[1,1],[3,1],[4,1],[2,1,5,1]],[
[[[1,1,3,1]],
  [[1,1,3,1],[],[],[]],
  [[1,1,3,1],[],[],[]]],
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[],[],[2,1,3,1]],
  [[1,1,3,1],[],[],[2,1,3,1]]],
[[[1,1,2,1],[2,1,3,1]],
  [[1,1,2,1],[2,1,3,1],[],[]],
  [[1,1,3,1],[],[],[2,1,3,1]]],
[[[5,1],[1,1,3,1]],
  [[1,1,3,1],[],[],[5,1]],
  [[1,1,3,1],[],[],[5,1]]],
[[[1,1],[3,1],[4,1]],
  [[1,1],[3,1],[4,1],[]],
  [[1,1],[3,1],[4,1],[]]],
[[[1,1],[3,1],[4,1]],
  [[1,1],[3,1],[4,1],[]],
  [[1,1],[3,1],[4,1],[4,1]]],
[[[1,1,3,1],[2,1,3,1,5,1]],
  [[1,1,3,1],[],[],[2,1,3,1,5,1]],
  [[1,1,3,1],[],[],[2,1,3,1,5,1]]],
[[[1,1,2,1],[2,1,3,1,5,1]],
  [[1,1,2,1],[2,1,3,1],[],[5,1]],
  [[1,1,3,1],[],[],[2,1,3,1,5,1]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[1,1],[3,1],[4,1],[2,1]],
  [[1,1],[3,1],[4,1],[2,1]]],
[[[1,1,3,1],[2,1,5,1],[3,1,4,1]],
  [[1,1,3,1],[],[3,1,4,1],[2,1,5,1]],
  [[1,1,3,1],[],[3,1,4,1],[2,1,5,1]]],
[[[1,1,4,1],[2,1,5,1],[3,1,4,1]],
  [[1,1,4,1],[3,1,4,1],[],[2,1,5,1]],
  [[1,1,3,1],[],[3,1,4,1],[2,1,5,1]]]]],
[48,52,"C6 x C2 x C2 x C2",[[2,1],[3,1],[4,1],[1,1,5,1]],[
[[[2,1]],
  [[2,1],[],[],[]],
  [[2,1],[],[],[]]],
[[[2,1]],
  [[2,1],[],[],[]],
  [[2,1],[2,1],[],[]]],
[[[5,1]],
  [[],[],[],[5,1]],
  [[],[],[],[5,1]]],
[[[2,1],[3,1]],
  [[2,1],[3,1],[],[]],
  [[2,1],[3,1],[],[]]],
[[[2,1],[3,1]],
  [[2,1],[3,1],[],[]],
  [[2,1],[3,1],[2,1],[]]],
[[[2,1],[3,1]],
  [[2,1],[3,1],[],[]],
  [[2,1],[3,1],[2,1],[3,1]]],
[[[1,1,5,1]],
  [[],[],[],[1,1,5,1]],
  [[],[],[],[1,1,5,1]]],
[[[1,1,5,1]],
  [[],[],[],[1,1,5,1]],
  [[1,1],[],[],[1,1,5,1]]],
[[[2,1],[3,1],[4,1]],
  [[2,1],[3,1],[4,1],[]],
  [[2,1],[3,1],[4,1],[]]],
[[[2,1],[3,1],[4,1]],
  [[2,1],[3,1],[4,1],[]],
  [[2,1],[3,1],[4,1],[4,1]]],
[[[2,1],[1,1,5,1]],
  [[2,1],[],[],[1,1,5,1]],
  [[2,1],[],[],[1,1,5,1]]],
[[[2,1],[1,1,5,1]],
  [[2,1],[],[],[1,1,5,1]],
  [[2,1],[2,1],[],[1,1,5,1]]],
[[[2,1],[1,1,5,1]],
  [[2,1],[],[],[1,1,5,1]],
  [[2,1],[2,1],[1,1],[1,1,5,1]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[2,1],[3,1],[4,1],[1,1]],
  [[2,1],[3,1],[4,1],[1,1]]],
[[[2,1],[3,1],[1,1,5,1]],
  [[2,1],[3,1],[],[1,1,5,1]],
  [[2,1],[3,1],[],[1,1,5,1]]],
[[[2,1],[3,1],[1,1,5,1]],
  [[2,1],[3,1],[],[1,1,5,1]],
  [[2,1],[3,1],[3,1],[1,1,5,1]]]]],
[49,1,"C49",[[1,1]],[
 ]],
[49,2,"C7 x C7",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[1,1]]]]],
[50,1,"D50",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[50,2,"C50",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[50,3,"C5 x D10",[[3,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1],[3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]]]],
[50,4,"(C5 x C5) : C2",[[1,1],[2,1],[2,1,3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[2,1]],
  [[1,1],[2,1],[2,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[2,1]],
  [[1,1],[2,1],[ 2, 3 ]]]]],
[50,5,"C10 x C5",[[3,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[3,1]],
  [[3,1],[]],
  [[3,1],[]]],
[[[3,1]],
  [[3,1],[]],
  [[3,1],[3,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[2,1],[1,1,2,1]]],
[[[2,1],[3,1]],
  [[3,1],[2,1]],
  [[3,1],[2,1]]]]],
[51,1,"C51",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[52,1,"C13 : C4",[[1,1],[3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[52,2,"C52",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[52,3,"C13 : C4",[[1,1],[3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[52,4,"D52",[[1,1],[2,1,3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]]]],
[52,5,"C26 x C2",[[2,1],[1,1,3,1]],[
[[[2,1]],
  [[2,1],[]],
  [[2,1],[]]],
[[[2,1]],
  [[2,1],[]],
  [[2,1],[2,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[3,1]],
  [[],[3,1]],
  [[],[3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[1,1],[1,1,3,1]]]]],
[53,1,"C53",[[1,1]],[
 ]],
[54,1,"D54",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[54,2,"C54",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[54,3,"C3 x D18",[[3,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]],
[[[1,1],[3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]]]],
[54,4,"C9 x S3",[[4,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1],[4,1]],
  [[4,1],[1,1]],
  [[4,1],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]]]],
[54,5,"((C3 x C3) : C3) : C2",[[3,1],[1,1,2,1]],[
[[[1,1],[3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]]]],
[54,6,"(C9 : C3) : C2",[[3,1],[1,1,2,1]],[
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]]]],
[54,7,"(C9 x C3) : C2",[[1,1],[2,1],[2,1,3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[3,2],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[2,1]],
  [[1,1],[2,1],[2,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[2,1]],
  [[1,1],[2,1],[2,1,4,1]]]]],
[54,8,"((C3 x C3) : C3) : C2",[[1,1],[2,1],[2,1,3,1]],[
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[],[3,1]]]]],
[54,9,"C18 x C3",[[3,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[3,1]],
  [[3,1],[]],
  [[3,1],[]]],
[[[3,1]],
  [[3,1],[]],
  [[3,1],[3,1]]],
[[[1,1,3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]],
[[[1,1,3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1,3,1]]],
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]],
[[[2,1]],
  [[],[2,1]],
  [[4,1],[2,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[4,1],[1,1,2,1]]],
[[[2,1],[3,1]],
  [[3,1],[2,1]],
  [[3,1],[2,1]]]]],
[54,10,"C2 x ((C3 x C3) : C3)",[[3,1],[1,1,2,1]],[
[[[3,1]],
  [[3,1],[]],
  [[3,1],[]]],
[[[1,1,3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]],
[[[2,1],[3,1]],
  [[3,1],[2,1]],
  [[3,1],[2,1]]]]],
[54,11,"C2 x (C9 : C3)",[[3,1],[1,1,2,1]],[
[[[3,1]],
  [[3,1],[]],
  [[3,1],[]]],
[[[1,1,3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]],
[[[2,1],[3,1]],
  [[3,1],[2,1]],
  [[3,1],[2,1]]]]],
[54,12,"C3 x C3 x S3",[[1,1,2,1],[3,1,4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[4,1]]],
[[[1,1,3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]],
[[[1,1,3,1]],
  [[1,1],[3,1]],
  [[1,1,3,1],[3,1]]],
[[[4,1],[1,1,3,1]],
  [[1,1],[3,1,4,1]],
  [[1,1],[3,1,4,1]]],
[[[4,1],[1,1,3,1]],
  [[1,1],[3,1,4,1]],
  [[1,1,3,2],[3,1,4,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[3,1]],
  [[1,1,2,1],[3,1]]]]],
[54,13,"C3 x ((C3 x C3) : C2)",[[3,1],[1,1,2,1],[3,1,4,1]],[
[[[1,1]],
  [[],[1,1],[]],
  [[],[1,1],[]]],
[[[1,1],[4,1]],
  [[],[1,1],[4,1]],
  [[],[1,1],[4,1]]],
[[[1,1],[4,1]],
  [[4,1],[1,1],[4,2]],
  [[],[1,1],[4,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1],[]],
  [[],[1,1,2,1],[]]],
[[[1,1],[3,1],[3,1,4,1]],
  [[3,1],[1,1],[3,1,4,1]],
  [[3,1],[1,1],[3,1,4,1]]],
[[[4,1],[1,1,2,1]],
  [[],[1,1,2,1],[4,1]],
  [[],[1,1,2,1],[4,1]]],
[[[4,1],[1,1,2,1]],
  [[],[1,1,2,1],[4,1]],
  [[4,2],[1,1,2,1],[]]]]],
[54,14,"(C3 x C3 x C3) : C2",[[1,1],[2,1],[3,1], 
  [2,1,3,1,4,1]],[
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[],[],[]]],
[[[1,1],[2,1,3,2]],
  [[1,1],[2,1,3,2],[],[2,1,3,2]],
  [[1,1],[2,1,3,2],[],[2,1,3,2]]],
[[[1,1],[2,1,3,2]],
  [[1,1],[2,1,3,2],[],[2,1,3,2]],
  [[1,1],[2,2,3,1],[2,1,3,2],[2,2,3,1]]],
[[[1,1],[2,1,3,1,4,1],[2,1,4,2]],
  [[1,1],[2,1,4,2],[ 3, 1, 4, 2 ],[2,1,3,1,4,1]],
  [[1,1],[2,1,4,2],[ 3, 1, 4, 2 ],[2,1,3,1,4,1]]],
[[[1,1],[2,2,3,1],[ 2, 2, 4, 1 ]],
  [[1,1],[],[2,2,3,1],[2,1,3,1,4,1]],
  [[1,1],[2,1,4,2],[ 3, 1, 4, 2 ],[2,1,3,1,4,1]]]]],
[54,15,"C6 x C3 x C3",[[3,1],[4,1],[1,1,2,1]],[
[[[1,1]],
  [[],[],[1,1]],
  [[],[],[1,1]]],
[[[3,1]],
  [[3,1],[],[]],
  [[3,1],[],[]]],
[[[3,1]],
  [[3,1],[],[]],
  [[3,1],[3,1],[]]],
[[[1,1,2,1]],
  [[],[],[1,1,2,1]],
  [[],[],[1,1,2,1]]],
[[[1,1,2,1]],
  [[],[],[1,1,2,1]],
  [[2,1],[],[1,1,2,1]]],
[[[3,1],[4,1]],
  [[3,1],[4,1],[]],
  [[3,1],[4,1],[]]],
[[[3,1],[4,1]],
  [[3,1],[4,1],[]],
  [[3,1],[4,1],[4,1]]],
[[[3,1],[1,1,2,1]],
  [[3,1],[],[1,1,2,1]],
  [[3,1],[],[1,1,2,1]]],
[[[3,1],[1,1,2,1]],
  [[3,1],[],[1,1,2,1]],
  [[3,1],[3,1],[1,1,2,1]]],
[[[2,1],[3,1],[4,1]],
  [[3,1],[4,1],[2,1]],
  [[3,1],[4,1],[2,1]]]]],
[55,1,"C11 : C5",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[55,2,"C55",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[56,1,"C7 : C8",[[1,1],[4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[56,2,"C56",[[1,1,2,1]],[
[[[2,1]],
  [[2,1]],
  [[2,1]]],
[[[1,1]],
  [[1,1]],
  [[1,1]]]]],
[56,3,"C7 : Q8",[[1,1],[2,1,4,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]]]],
[56,4,"C4 x D14",[[1,1],[2,1,4,1]],[
[[[1,1,3,1]],
  [[1,1,3,1],[]],
  [[1,1,3,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[4,1],[1,1,3,1]],
  [[1,1,3,1],[4,1]],
  [[1,1,3,1],[4,1]]]]],
[56,5,"D56",[[1,1],[2,1,4,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[]],
  [[1,1,2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[4,1],[1,1,2,1]],
  [[1,1,2,1],[4,1]],
  [[1,1,2,1],[4,1]]]]],
[56,6,"C2 x (C7 : C4)",[[1,1],[2,1,4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[3,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[3,1,4,1]]]]],
[56,7,"(C14 x C2) : C2",[[1,1],[2,1,4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[4,1]]]]],
[56,8,"C28 x C2",[[2,1],[1,1,3,1]],[
[[[2,1]],
  [[2,1],[]],
  [[2,1],[]]],
[[[2,1]],
  [[2,1],[]],
  [[2,1],[2,1]]],
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1]],
  [[],[1,1]],
  [[4,1],[1,1]]],
[[[3,1]],
  [[],[3,1]],
  [[],[3,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[2,1,3,1]],
  [[2,1],[3,1]],
  [[2,1],[3,1]]],
[[[2,1,3,1]],
  [[2,1],[3,1]],
  [[2,1],[2,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[4,1],[1,1,3,1]]]]],
[56,9,"C7 x D8",[[2,1],[1,1,3,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1]],
  [[1,1],[1,1]],
  [[1,1],[1,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[1,1],[1,1,3,1]],
  [[1,1],[1,1,3,1]]]]],
[56,10,"C7 x Q8",[[2,1],[1,1,3,1]],[
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]]]],
[56,11,"(C2 x C2 x C2) : C7",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[56,12,"C2 x C2 x D14",[[1,1],[3,1],[2,1,4,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[]],
  [[1,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[]],
  [[1,1],[3,1],[3,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[3,1],[2,1]],
  [[1,1],[3,1],[2,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[4,1]],
  [[1,1],[],[4,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[3,1],[4,1]],
  [[1,1],[3,1],[4,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[3,1],[3,1,4,1]],
  [[1,1],[3,1],[4,1]]]]],
[56,13,"C14 x C2 x C2",[[2,1],[3,1],[1,1,4,1]],[
[[[2,1]],
  [[2,1],[],[]],
  [[2,1],[],[]]],
[[[2,1]],
  [[2,1],[],[]],
  [[2,1],[2,1],[]]],
[[[2,1],[3,1]],
  [[2,1],[3,1],[]],
  [[2,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[2,1],[3,1],[]],
  [[2,1],[3,1],[3,1]]],
[[[4,1]],
  [[],[],[4,1]],
  [[],[],[4,1]]],
[[[1,1],[2,1],[3,1]],
  [[2,1],[3,1],[1,1]],
  [[2,1],[3,1],[1,1]]],
[[[1,1,4,1]],
  [[],[],[1,1,4,1]],
  [[],[],[1,1,4,1]]],
[[[1,1,4,1]],
  [[],[],[1,1,4,1]],
  [[1,1],[],[1,1,4,1]]],
[[[2,1],[1,1,4,1]],
  [[2,1],[],[1,1,4,1]],
  [[2,1],[],[1,1,4,1]]],
[[[2,1],[1,1,4,1]],
  [[2,1],[],[1,1,4,1]],
  [[2,1],[2,1],[1,1,4,1]]]]],
[57,1,"C19 : C3",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[57,2,"C57",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[58,1,"D58",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[58,2,"C58",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[59,1,"C59",[[1,1]],[
 ]],
[60,1,"C5 x (C3 : C4)",[[4,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1],[4,1]],
  [[4,1],[1,1]],
  [[4,1],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]]]],
[60,2,"C3 x (C5 : C4)",[[4,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]],
[[[1,1],[4,1]],
  [[4,1],[1,1]],
  [[4,1],[1,1]]]]],
[60,3,"C15 : C4",[[1,1],[3,1,4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[4,1]]]]],
[60,4,"C60",[[1,1,2,1,3,1]],[
[[[2,1]],
  [[2,1]],
  [[2,1]]],
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[3,1]],
  [[3,1]],
  [[3,1]]],
[[[1,1,2,1]],
  [[1,1,2,1]],
  [[1,1,2,1]]],
[[[2,1,3,1]],
  [[2,1,3,1]],
  [[2,1,3,1]]],
[[[1,1,3,1]],
  [[1,1,3,1]],
  [[1,1,3,1]]]]],
[60,5,"A5",[ (1,2,3,4,5), (1,2,3) ],[
 ]],
[60,6,"C3 x (C5 : C4)",[[4,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]],
[[[1,1],[4,1]],
  [[4,1],[1,1]],
  [[4,1],[1,1]]]]],
[60,7,"C15 : C4",[[1,1],[3,1,4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[4,1]]]]],
[60,8,"S3 x D10",[[1,1,3,1],[2,1,4,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1]],
  [[1,1,3,1],[2,1]]],
[[[1,1],[2,1,4,1]],
  [[1,1],[2,1,4,1]],
  [[1,1],[2,1,4,1]]]]],
[60,9,"C5 x A4",[[3,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1],[3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]]]],
[60,10,"C6 x D10",[[1,1,3,1],[2,1,4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1,3,1]],
  [[1,1,3,1],[]],
  [[1,1,3,1],[]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[4,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1]],
  [[1,1,3,1],[2,1]]],
[[[1,1],[2,1,4,1]],
  [[1,1],[2,1,4,1]],
  [[1,1],[2,1,4,1]]],
[[[4,1],[1,1,3,1]],
  [[1,1,3,1],[4,1]],
  [[1,1,3,1],[4,1]]]]],
[60,11,"C10 x S3",[[1,1,3,1],[2,1,4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[4,1]]],
[[[1,1,3,1]],
  [[1,1,3,1],[]],
  [[1,1,3,1],[]]],
[[[1,1],[2,1,4,1]],
  [[1,1],[2,1,4,1]],
  [[1,1],[2,1,4,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1]],
  [[1,1,3,1],[2,1]]],
[[[4,1],[1,1,3,1]],
  [[1,1,3,1],[4,1]],
  [[1,1,3,1],[4,1]]]]],
[60,12,"D60",[[1,1],[2,1,3,1,4,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1]],
  [[1,1],[4,1]]],
[[[1,1],[2,1,3,1]],
  [[1,1],[2,1,3,1]],
  [[1,1],[2,1,3,1]]],
[[[1,1],[2,1,4,1]],
  [[1,1],[2,1,4,1]],
  [[1,1],[2,1,4,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[3,1,4,1]],
  [[1,1],[3,1,4,1]]]]],
[60,13,"C30 x C2",[[2,1],[1,1,3,1,4,1]],[
[[[2,1]],
  [[2,1],[]],
  [[2,1],[]]],
[[[2,1]],
  [[2,1],[]],
  [[2,1],[2,1]]],
[[[3,1]],
  [[],[3,1]],
  [[],[3,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[4,1]],
  [[],[4,1]],
  [[],[4,1]]],
[[[2,1,3,1]],
  [[2,1],[3,1]],
  [[2,1],[3,1]]],
[[[2,1,3,1]],
  [[2,1],[3,1]],
  [[2,1],[2,1,3,1]]],
[[[1,1,4,1]],
  [[],[1,1,4,1]],
  [[],[1,1,4,1]]],
[[[1,1,4,1]],
  [[],[1,1,4,1]],
  [[1,1],[1,1,4,1]]],
[[[2,1],[1,1,3,1]],
  [[2,1],[1,1,3,1]],
  [[2,1],[1,1,3,1]]],
[[[3,1,4,1]],
  [[],[3,1,4,1]],
  [[],[3,1,4,1]]],
[[[2,1],[1,1,4,1]],
  [[2,1],[1,1,4,1]],
  [[2,1],[1,1,4,1]]],
[[[1,1,3,1,4,1]],
  [[],[1,1,3,1,4,1]],
  [[],[1,1,3,1,4,1]]],
[[[1,1,3,1,4,1]],
  [[],[1,1,3,1,4,1]],
  [[1,1],[1,1,3,1,4,1]]]]],
[61,1,"C61",[[1,1]],[
 ]],
[62,1,"D62",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[62,2,"C62",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[63,1,"C7 : C9",[[1,1],[3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[63,2,"C63",[[1,1,2,1]],[
[[[2,1]],
  [[2,1]],
  [[2,1]]],
[[[1,1]],
  [[1,1]],
  [[1,1]]]]],
[63,3,"C3 x (C7 : C3)",[[1,1],[2,1,3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]]]],
[63,4,"C21 x C3",[[2,1],[1,1,3,1]],[
[[[2,1]],
  [[2,1],[]],
  [[2,1],[]]],
[[[2,1]],
  [[2,1],[]],
  [[2,1],[2,1]]],
[[[3,1]],
  [[],[3,1]],
  [[],[3,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[1,1],[1,1,3,1]]]]],
## groups of order 64 removed from here, then re-instated 26/03/13 
[64,1,"C64",[[1,1]],[
 ]],
[64,2,"C8 x C8",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[1,1]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[3,1]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[5,1]]]]],
[64,3,"C8 : C8",[[1,1],[2,1]],[
[[[1,1,2,1,3,1,5,1]],
  [[],[1,1,2,1,3,1,5,1]],
  [[],[1,1,2,1,3,1,5,1]]],
[[[1,1,2,1,3,1,6,1]],
  [[5,1,6,1],[1,1,2,1,3,1,6,1]],
  [[3,1,4,1],[1,1,2,1,4,1]]],
[[[1,1,2,1,3,1,6,1]],
  [[5,1,6,1],[1,1,2,1,3,1,6,1]],
  [[],[1,1,2,1,3,1,5,1]]]]],
[64,4,"((C8 x C2) : C2) : C2",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[6,1]],
  [[1,1],[]]]]],
[64,5,"(C4 x C2) : C8",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[6,1]],
  [[1,1],[]]]]],
[64,6,"(C8 x C4) : C2",[[1,1],[2,1]],[
[[[2,1]],
  [[2,1],[2,1]],
  [[2,1],[2,1]]]]],
[64,7,"Q8 : C8",[[1,1],[2,1]],[
 ]],
[64,8,"((C8 x C2) : C2) : C2",[[1,1],[2,1]],[
 ]],
[64,9,"(C2 x Q8) : C4",[[1,1],[2,1]],[
 ]],
[64,10,"(C8 : C4) : C2",[[1,1],[2,1]],[
 ]],
[64,11,"(C2 x C2) . ((C4 x C2) : C2) = (C4 x C2) . (C4 x C2)",
[[1,1],[2,1]],[
 ]],
[64,12,"(C4 : C8) : C2",[[1,1],[2,1]],[
 ]],
[64,13,"(C2 x C2) . ((C4 x C2) : C2) = (C4 x C2) . (C4 x C2)",
[[1,1],[2,1]],[
 ]],
[64,14,"(C2 x C2) . ((C4 x C2) : C2) = (C4 x C2) . (C4 x C2)",
[[1,1],[2,1]],[
 ]],
[64,15,"C8 : C8",[[1,1],[2,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[]],
  [[1,1,2,1],[]]],
[[[1,1,2,1,6,1]],
  [[1,1,2,1,6,1],[6,1]],
  [[1,1,2,1],[]]]]],
[64,16,"C8 : C8",[[1,1],[2,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[]],
  [[1,1,2,1],[]]],
[[[1,1,2,1,6,1]],
  [[1,1,2,1,6,1],[6,1]],
  [[1,1,2,1],[]]]]],
[64,17,"(C8 x C2) : C4",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]],
[[[2,1]],
  [[5,1],[2,1]],
  [[],[2,1]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[4,1,6,1]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[6,1]]]]],
[64,18,"(C8 x C2) : C4",[[1,1],[2,1]],[
[[[1,1,5,1]],
  [[1,1,4,1,5,1,6,1],[1,1,5,1]],
  [[1,1,4,1,5,1,6,1],[1,1,5,1]]],
[[[1,1,5,1]],
  [[1,1,5,1],[]],
  [[1,1,5,1],[]]]]],
[64,19,"C4 . (C4 x C4)",[[1,1],[2,1]],[
 ]],
[64,20,"(C4 x C4) : C4",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[4,1]]]]],
[64,21,"(C8 x C2) : C4",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[4,1]]]]],
[64,22,"(C4 x C2) . D8 = C4 . (C4 x C4)",[[1,1],[2,1]],[
 ]],
[64,23,"(C4 x C2 x C2) : C4",[[1,1],[2,1]],[
[[[1,1,2,1,5,1]],
  [[1,1,2,1,5,1],[]],
  [[1,1,2,1,5,1],[]]]]],
[64,24,"(C8 : C2) : C4",[[1,1],[2,1]],[
 ]],
[64,25,"(C8 x C2) : C4",[[1,1],[2,1]],[
[[[1,1,5,1]],
  [[1,1,5,1],[]],
  [[1,1,5,1],[]]]]],
[64,26,"C16 x C4",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]],
[[[2,1]],
  [[],[2,1]],
  [[2,1],[2,1]]],
[[[2,1]],
  [[],[2,1]],
  [[4,1],[2,1]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[5,1]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[6,1]]]]],
[64,27,"C16 : C4",[[1,1],[2,1]],[
[[[2,1,5,1]],
  [[],[2,1,5,1]],
  [[],[2,1,5,1]]],
[[[2,1,5,1]],
  [[],[2,1,5,1]],
  [[4,1,6,1],[2,1,5,1]]]]],
[64,28,"C16 : C4",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]]]],
[64,29,"(C16 x C2) : C2",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[6,1]],
  [[1,1],[]]]]],
[64,30,"(C16 : C2) : C2",[[1,1],[2,1]],[
 ]],
[64,31,"(C16 x C2) : C2",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]]]],
[64,32,"((C8 : C2) : C2) : C2",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[64,33,"(C4 x C2 x C2) : C4",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[64,34,"(((C4 x C2) : C2) : C2) : C2",[[1,1],[2,1]],[
[[[1,1,2,1,3,1,4,1]],
  [[1,1,2,1,3,1,4,1],[3,1,4,1]],
  [[1,1,2,1,3,1,4,1],[3,1,4,1]]]]],
[64,35,"(C4 x C4) : C4",[[1,1],[2,1]],[
[[[1,1,2,1,3,1,4,1,6,1]],
  [[1,1,2,1,3,1,4,1,6,1],[3,1,4,1,6,1]],
  [[1,1,2,1,3,1,4,1,6,1],[3,1,4,1,6,1]]]]],
[64,36,"(C2 . ((C4 x C2) : C2) = (C2 x C2) . (C4 x C2)) : C2",
[[1,1],[2,1]],[
 ]],
[64,37,"C2 . (((C4 x C2) : C2) : C2) = (C4 x C2) . (C4 x C2)",
[[1,1],[2,1]],[
 ]],
[64,38,"(C16 x C2) : C2",[[1,1],[2,1]],[
[[[2,1]],
  [[2,1],[2,1]],
  [[2,1],[2,1]]]]],
[64,39,"Q16 : C4",[[1,1],[2,1]],[
 ]],
[64,40,"(C16 x C2) : C2",[[1,1],[2,1]],[
[[[2,1]],
  [[2,1],[2,1]],
  [[2,1],[2,1]]]]],
[64,41,"(C16 : C2) : C2",[[1,1],[2,1]],[
 ]],
[64,42,"(C16 : C2) : C2",[[1,1],[2,1]],[
 ]],
[64,43,"C2 . ((C8 x C2) : C2) = C8 . (C4 x C2)",[[1,1],[2,1]],[
 ]],
[64,44,"C4 : C16",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[6,1]]]]],
[64,45,"C8 . D8 = C4 . (C8 x C2)",[[1,1],[2,1]],[
 ]],
[64,46,"C16 : C4",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[64,47,"C16 : C4",[[1,1],[2,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[]],
  [[1,1,2,1],[]]],
[[[1,1,2,1,4,1]],
  [[1,1,2,1,4,1],[4,1]],
  [[1,1,2,1],[]]]]],
[64,48,"C16 : C4",[[1,1],[2,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[]],
  [[1,1,2,1],[]]],
[[[1,1,2,1,4,1,6,1]],
  [[1,1,2,1,4,1,6,1],[4,1,6,1]],
  [[1,1,2,1],[]]]]],
[64,49,"C4 . D16 = C8 . (C4 x C2)",[[1,1],[2,1]],[
 ]],
[64,50,"C32 x C2",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]],
[[[2,1]],
  [[],[2,1]],
  [[2,1],[2,1]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1]],
  [[1,1],[]],
  [[1,1],[6,1]]]]],
[64,51,"C32 : C2",[[1,1],[2,1]],[
[[[2,1]],
  [[],[2,1]],
  [[],[2,1]]]]],
[64,52,"D64",[[1,1],[2,1]],[
[[[2,1]],
  [[2,1],[2,1]],
  [[2,1],[2,1]]]]],
[64,53,"QD64",[[1,1],[2,1]],[
[[[2,1]],
  [[2,1],[2,1]],
  [[2,1],[2,1]]]]],
[64,54,"Q64",[[1,1],[2,1]],[
 ]],
[64,55,"C4 x C4 x C4",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[1,1],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[4,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[2,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[5,1]]]]],
[64,56,"C2 x ((C4 x C2) : C4)",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]],
[[[2,1]],
  [[],[2,1],[]],
  [[6,1],[2,1],[6,1]]],
[[[2,1]],
  [[],[2,1],[6,1]],
  [[6,1],[2,1],[6,1]]],
[[[3,1,6,1],[1,1,2,1,6,1]],
  [[1,1,2,1,6,1],[],[3,1,6,1]],
  [[1,1,2,1,6,1],[],[3,1,6,1]]],
[[[3,1,6,1],[1,1,2,1,6,1]],
  [[1,1,2,1,6,1],[],[3,1,6,1]],
  [[1,1,2,1,3,1],[3,1,6,1],[3,1,6,1]]],
[[[1,1,2,1,3,1],[3,1,4,1,5,1]],
  [[3,1,4,1,5,1],[1,1,2,1,3,1],[3,1,4,1,5,1]],
  [[3,1,6,1],[ 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1 ], 
  [3,1,4,1,5,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1,4,1],[2,1],[4,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1,6,1],[2,1],[6,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1,4,1,6,1],[2,1],[4,1,6,1]]]]],
[64,57,"(C4 x C4) : C4",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]],
[[[2,1]],
  [[],[2,1],[]],
  [[6,1],[2,1],[]]],
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[6,1]]]]],
[64,58,"C4 x ((C4 x C2) : C2)",[[1,1],[2,1],[3,1]],[
[[[1,1,3,1,5,1,6,1]],
  [[1,1,3,1,5,1,6,1],[],[]],
  [[1,1,3,1,5,1,6,1],[],[]]],
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]],
[[[2,1]],
  [[6,1],[2,1],[]],
  [[],[2,1],[]]],
[[[2,1]],
  [[],[2,1],[6,1]],
  [[6,1],[2,1],[]]],
[[[2,1]],
  [[],[2,1],[6,1]],
  [[],[2,1],[]]],
[[[1,1,6,1],[3,1,6,1]],
  [[1,1,6,1],[],[3,1,6,1]],
  [[1,1,6,1],[],[3,1,6,1]]],
[[[1,1,6,1],[3,1,6,1]],
  [[1,1,6,1],[],[3,1,6,1]],
  [[1,1,6,1],[5,1],[3,1,6,1]]],
[[[1,1,6,1],[3,1,6,1]],
  [[1,1,6,1],[],[3,1,6,1]],
  [[1,1,5,1,6,1],[3,1,6,1],[3,1,5,1,6,1]]],
[[[2,1],[3,1]],
  [[3,1],[2,1],[3,1]],
  [[3,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[3,1,5,1],[2,1],[3,1]],
  [[3,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[3,1,6,1],[2,1],[3,1]],
  [[3,1],[2,1],[3,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1,4,1],[2,1],[4,1]]],
[[[2,1],[1,1,3,1,6,1]],
  [[1,1,3,1,6,1],[2,1],[6,1]],
  [[1,1,3,1,4,1],[2,1],[4,1]]]]],
[64,59,"C4 x (C4 : C4)",[[1,1],[2,1],[3,1]],[
[[[1,1,2,1,3,1,5,1]],
  [[],[1,1,2,1,3,1,5,1],[]],
  [[],[1,1,2,1,3,1,5,1],[]]],
[[[1,1,2,1,3,1,5,1]],
  [[],[1,1,2,1,3,1,5,1],[]],
  [[6,1],[1,1,2,1,3,1,5,1],[6,1]]],
[[[1,1,2,1,3,1,5,1]],
  [[],[1,1,2,1,3,1,5,1],[]],
  [[],[1,1,2,1,3,1,5,1,6,1],[6,1]]],
[[[1,1,2,1,3,1,5,1]],
  [[],[1,1,2,1,3,1,5,1],[]],
  [[6,1],[1,1,2,1,3,1,5,1,6,1],[]]],
[[[2,1,4,1,5,1],[1,1,3,1,4,1,5,1]],
  [[1,1,3,1,4,1,5,1],[2,1,4,1,5,1],[]],
  [[1,1,3,1,4,1,5,1],[2,1,4,1,5,1],[]]],
[[[1,1,3,1,5,1],[2,1,4,1,5,1]],
  [[1,1,3,1,5,1],[2,1,4,1,5,1],[4,1]],
  [[1,1,3,1,4,1,5,1],[2,1,4,1,5,1],[]]],
[[[2,1,4,1,5,1],[1,1,3,1,4,1,5,1,6,1]],
  [[1,1,3,1,4,1,5,1,6,1],[2,1,4,1,5,1],[6,1]],
  [[1,1,3,1,4,1,5,1],[2,1,4,1,5,1],[]]],
[[[2,1,4,1,5,1],[1,1,3,1,5,1,6,1]],
  [[1,1,3,1,5,1,6,1],[2,1,4,1,5,1],[4,1,6,1]],
  [[1,1,3,1,4,1,5,1],[2,1,4,1,5,1],[]]],
[[[2,1],[3,1]],
  [[3,1],[2,1],[3,1]],
  [[3,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[3,1,6,1],[2,1],[3,1]],
  [[3,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[3,1,4,1,5,1],[2,1],[3,1]],
  [[3,1],[2,1],[3,1]]]]],
[64,60,"(C2 x ((C4 x C2) : C2)) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1,5,1,6,1],[3,1,4,1,5,1,6,1]],
  [[],[2,1,5,1,6,1],[3,1,4,1,5,1,6,1]],
  [[],[2,1,5,1,6,1],[3,1,4,1,5,1,6,1]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[6,1],[]],
  [[1,1],[],[]]],
[[[1,1],[2,1,3,1,4,1]],
  [[1,1],[],[2,1,3,1,4,1]],
  [[1,1],[],[2,1,3,1,4,1]]],
[[[1,1],[2,1,3,1,4,1]],
  [[1,1],[],[2,1,3,1,4,1]],
  [[1,1],[4,1,5,1,6,1],[2,1,3,1,5,1,6,1]]],
[[[1,1],[2,1,3,1,4,1]],
  [[1,1],[],[2,1,3,1,4,1]],
  [[1,1],[4,1,5,1],[2,1,3,1,5,1]]],
[[[1,1],[2,1,3,1,5,1]],
  [[1,1],[2,1,3,1,5,1],[]],
  [[1,1],[4,1,5,1],[2,1,3,1,5,1]]]]],
[64,61,"(C2 x (C4 : C4)) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[6,1],[6,1]]],
[[[1,1]],
  [[1,1],[],[6,1]],
  [[1,1],[6,1],[6,1]]],
[[[1,1]],
  [[1,1],[6,1],[]],
  [[1,1],[6,1],[6,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[4,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[6,1]],
  [[1,1],[2,1,5,1],[]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[6,1]],
  [[1,1],[2,1,5,1],[4,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1],[],[3,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1,5,1],[5,1],[3,1]]],
[[[3,1],[1,1,2,1,6,1]],
  [[1,1,2,1,6,1],[6,1],[3,1]],
  [[1,1,2,1,5,1],[5,1],[3,1]]]]],
[64,62,"((C4 x C2) : C4) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[6,1],[]]],
[[[1,1]],
  [[1,1],[],[6,1]],
  [[1,1],[],[]]]]],
[64,63,"(C4 x C4) : C4",[[1,1],[2,1],[3,1]],[
[[[1,1,3,1]],
  [[1,1,3,1],[],[]],
  [[1,1,3,1],[],[]]],
[[[1,1,3,1]],
  [[1,1,3,1],[],[]],
  [[1,1,3,1],[4,1,5,1,6,1],[]]],
[[[1,1,3,1]],
  [[1,1,3,1],[],[]],
  [[1,1,3,1,4,1,5,1,6,1],[4,1,5,1,6,1], 
  [4,1,5,1,6,1]]]]],
[64,64,"(C4 x C4) : C4",[[1,1],[2,1],[3,1]],[
[[[1,1,3,1]],
  [[1,1,3,1],[],[]],
  [[1,1,3,1],[],[]]],
[[[1,1,3,1]],
  [[1,1,3,1],[],[]],
  [[1,1,3,1,4,1,5,1,6,1],[4,1,5,1,6,1], 
  [4,1,5,1,6,1]]]]],
[64,65,"(C4 x C4) : C4",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[6,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[2,1,4,1,6,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[6,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[4,1,6,1]]]]],
[64,66,"(C2 x (C4 : C4)) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1],[3,1]],
  [[2,1],[2,1],[3,1]],
  [[2,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[2,1],[2,1],[3,1]],
  [[2,1,6,1],[2,1],[3,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[4,1]],
  [[1,1],[2,1,5,1],[]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[6,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[4,1,6,1]]]]],
[64,67,"(C4 x C2 x C2 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1],[],[]]],
[[[2,1],[3,1]],
  [[2,1],[2,1],[3,1]],
  [[2,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[2,1,4,1,6,1],[2,1],[3,1]],
  [[2,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[2,1,3,1],[2,1],[3,1]],
  [[2,1,3,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[2,1,3,1],[2,1],[3,1]],
  [[2,1,3,1,4,1,6,1],[2,1],[3,1]]],
[[[3,1,4,1],[1,1,2,1,6,1]],
  [[1,1,2,1,6,1],[],[3,1,4,1]],
  [[1,1,2,1,6,1],[],[3,1,4,1]]],
[[[3,1,4,1],[1,1,2,1,5,1,6,1]],
  [[1,1,2,1,5,1,6,1],[5,1],[3,1,4,1]],
  [[1,1,2,1,6,1],[],[3,1,4,1]]],
[[[3,1,4,1],[1,1,2,1,6,1]],
  [[1,1,2,1,6,1],[],[3,1,4,1]],
  [[1,1,2,1,3,1,4,1,6,1],[3,1,4,1,5,1], 
  [3,1,4,1,5,1]]],
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[2,1,3,1],[]],
  [[1,1,3,1],[2,1,3,1],[]]],
[[[1,1,3,1,4,1,5,1],[2,1,3,1,4,1,5,1]],
  [[1,1,3,1,4,1,5,1],[2,1,3,1,4,1,5,1],[4,1,5,1]],
  [[1,1,3,1],[2,1,3,1],[]]],
[[[1,1,3,1,5,1,6,1],[2,1,3,1,5,1,6,1]],
  [[1,1,3,1,5,1,6,1],[2,1,3,1,5,1,6,1],[5,1,6,1]],
  [[1,1,3,1],[2,1,3,1],[]]],
[[[1,1,3,1,4,1,6,1],[2,1,3,1,4,1,6,1]],
  [[1,1,3,1,4,1,6,1],[2,1,3,1,4,1,6,1],[4,1,6,1]],
  [[1,1,3,1],[2,1,3,1],[]]]]],
[64,68,"(C4 : C4) : C4",[[1,1],[2,1],[3,1]],[
 ]],
[64,69,"(C4 x C4 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1],[],[]]]]],
[64,70,"(C4 : C4) : C4",[[1,1],[2,1],[3,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[4,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[6,1]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[6,1]],
  [[1,1],[2,1],[4,1]]]]],
[64,71,"(C4 x C4 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1,2,1,3,1,6,1]],
  [[1,1,2,1,3,1,6,1],[],[]],
  [[1,1,2,1,3,1,6,1],[],[]]],
[[[1,1,2,1,6,1],[3,1,4,1,6,1]],
  [[1,1,2,1,6,1],[],[3,1,4,1,6,1]],
  [[1,1,2,1,6,1],[],[3,1,4,1,6,1]]],
[[[1,1,2,1,6,1],[3,1,4,1,6,1]],
  [[1,1,2,1,6,1],[],[3,1,4,1,6,1]],
  [[1,1,2,1,5,1,6,1],[5,1],[3,1,4,1,6,1]]],
[[[1,1,2,1,6,1],[3,1,4,1,6,1]],
  [[1,1,2,1,6,1],[],[3,1,4,1,6,1]],
  [[1,1,2,1,3,1,4,1,5,1],[3,1,4,1,6,1], 
  [3,1,4,1,5,1,6,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[6,1]],
  [[1,1],[2,1,5,1],[4,1,6,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[4,1,6,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[6,1]]]]],
[64,72,"(C2 x Q8) : C4",[[1,1],[2,1],[3,1]],[
[[[1,1,2,1,5,1,6,1],[3,1,4,1,5,1,6,1]],
  [[1,1,2,1,5,1,6,1],[],[3,1,4,1,5,1,6,1]],
  [[1,1,2,1,5,1,6,1],[],[3,1,4,1,5,1,6,1]]],
[[[1,1,2,1,6,1],[3,1,4,1,5,1,6,1]],
  [[1,1,2,1,6,1],[5,1],[3,1,4,1,5,1,6,1]],
  [[1,1,2,1,5,1,6,1],[],[3,1,4,1,5,1,6,1]]],
[[[1,1,2,1,5,1,6,1],[3,1,4,1,5,1,6,1]],
  [[1,1,2,1,5,1,6,1],[],[3,1,4,1,5,1,6,1]],
  [[1,1,2,1,3,1,4,1],[3,1,4,1,6,1],[3,1,4,1,6,1]]]]],
[64,73,"(C2 x C2 x D8) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1,6,1],[2,1,6,1]],
  [[1,1,6,1],[2,1,6,1],[]],
  [[1,1,6,1],[2,1,6,1],[]]],
[[[1,1,6,1],[2,1,6,1]],
  [[1,1,6,1],[2,1,6,1],[4,1]],
  [[1,1,6,1],[2,1,6,1],[]]],
[[[1,1,6,1],[2,1,6,1]],
  [[1,1,6,1],[2,1,6,1],[2,1,6,1]],
  [[1,1,6,1],[2,1,6,1],[2,1,6,1]]],
[[[1,1,6,1],[2,1,6,1]],
  [[1,1,6,1],[2,1,6,1],[2,1,6,1]],
  [[1,1,6,1],[2,1,6,1],[2,1,4,1,6,1]]]]],
[64,74,"(C2 x C2 x Q8) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1,6,1],[2,1,6,1]],
  [[1,1,6,1],[2,1,6,1],[]],
  [[1,1,6,1],[2,1,6,1],[]]],
[[[1,1,6,1],[2,1,6,1]],
  [[1,1,6,1],[2,1,6,1],[4,1]],
  [[1,1,6,1],[2,1,6,1],[]]]]],
[64,75,"(C2 x ((C4 x C2) : C2)) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1],[2,1,5,1,6,1]],
  [[1,1],[2,1,5,1,6,1],[1,1,2,1,5,1,6,1]],
  [[1,1],[2,1,5,1,6,1],[1,1,2,1,5,1,6,1]]],
[[[1,1],[2,1,5,1,6,1]],
  [[1,1],[2,1,5,1,6,1],[1,1,2,1,5,1,6,1]],
  [[1,1],[2,1,5,1,6,1],[1,1,2,1,4,1,5,1,6,1]]]]],
[64,76,"(C4 x C2) : Q8",[[1,1],[2,1],[3,1]],[
[[[1,1,6,1],[2,1,5,1,6,1]],
  [[1,1,6,1],[2,1,4,1,5,1,6,1],[2,1,5,1,6,1]],
  [[1,1,6,1],[2,1,4,1,5,1,6,1],[2,1,5,1,6,1]]],
[[[1,1,6,1],[2,1,4,1,5,1,6,1]],
  [[1,1,6,1],[2,1,4,1,5,1,6,1],[2,1,4,1,5,1,6,1]],
  [[1,1,6,1],[2,1,4,1,5,1,6,1],[2,1,5,1,6,1]]]]],
[64,77,"(C2 x (C4 : C4)) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,78,"(C2 x (C4 : C4)) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,79,"(C2 x C2 x C2) . (C2 x C2 x C2)",[[1,1],[2,1],[3,1]],[
 ]],
[64,80,"(C2 x (C4 : C4)) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,81,"(C2 x C2 x C2) . (C2 x C2 x C2)",[[1,1],[2,1],[3,1]],[
 ]],
[64,82,"(C2 x C2 x C2) . (C2 x C2 x C2)",[[1,1],[2,1],[3,1]],[
 ]],
[64,83,"C8 x C4 x C2",[[1,1],[2,1],[3,1]],[
[[[3,1]],
  [[],[],[3,1]],
  [[],[],[3,1]]],
[[[3,1]],
  [[],[],[3,1]],
  [[],[3,1],[3,1]]],
[[[3,1]],
  [[],[],[3,1]],
  [[3,1],[],[3,1]]],
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]],
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[5,1]]],
[[[2,1]],
  [[],[2,1],[]],
  [[2,1],[2,1],[]]],
[[[2,1]],
  [[],[2,1],[]],
  [[2,1],[2,1],[5,1]]],
[[[2,1]],
  [[],[2,1],[]],
  [[5,1],[2,1],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[6,1],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[4,1],[]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[6,1]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1]],
  [[],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1]],
  [[2,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1]],
  [[5,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1]],
  [[3,1],[2,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[3,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[4,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[6,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[3,1]],
  [[1,1],[4,1],[3,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[5,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[6,1]]]]],
[64,84,"C2 x (C8 : C4)",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]],
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[5,1]]],
[[[2,1]],
  [[],[2,1],[]],
  [[5,1],[2,1],[]]],
[[[2,1],[3,1,6,1]],
  [[],[2,1],[3,1,6,1]],
  [[],[2,1],[3,1,6,1]]],
[[[2,1],[3,1,6,1]],
  [[5,1],[2,1],[3,1,6,1]],
  [[],[2,1],[3,1,6,1]]],
[[[2,1],[3,1,6,1]],
  [[],[2,1],[3,1,6,1]],
  [[3,1,6,1],[2,1],[3,1,6,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1,5,1],[2,1],[5,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1,6,1],[2,1],[6,1]]]]],
[64,85,"C4 x (C8 : C2)",[[1,1],[2,1],[3,1]],[
[[[3,1]],
  [[],[],[3,1]],
  [[],[],[3,1]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1]],
  [[],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[5,1],[2,1],[3,1]],
  [[2,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[5,1],[2,1],[3,1]],
  [[],[2,1],[3,1]]],
[[[1,1,5,1],[3,1,5,1]],
  [[1,1,5,1],[],[3,1,5,1]],
  [[1,1,5,1],[],[3,1,5,1]]],
[[[1,1,5,1],[3,1,5,1]],
  [[1,1,5,1],[],[3,1,5,1]],
  [[1,1,5,1,6,1],[4,1],[3,1,5,1,6,1]]],
[[[1,1,5,1],[3,1,5,1]],
  [[1,1,5,1],[],[3,1,5,1]],
  [[1,1,5,1],[6,1],[3,1,5,1]]]]],
[64,86,"(C8 x C4) : C2",[[1,1],[2,1],[3,1]],[
[[[3,1,5,1]],
  [[],[],[3,1,5,1]],
  [[],[],[3,1,5,1]]],
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]],
[[[2,1]],
  [[5,1],[2,1],[]],
  [[5,1],[2,1],[5,1]]],
[[[2,1]],
  [[],[2,1],[]],
  [[5,1],[2,1],[5,1]]],
[[[2,1]],
  [[],[2,1],[]],
  [[5,1],[2,1],[]]]]],
[64,87,"C2 x ((C8 x C2) : C2)",[[1,1],[2,1],[3,1]],[
[[[2,1,3,1]],
  [[],[2,1,3,1],[]],
  [[],[2,1,3,1],[]]],
[[[2,1],[3,1,4,1]],
  [[],[2,1],[3,1,4,1]],
  [[],[2,1],[3,1,4,1]]],
[[[2,1],[3,1,4,1]],
  [[],[2,1],[3,1,4,1]],
  [[3,1,4,1],[2,1],[3,1,4,1]]],
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[],[6,1]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[6,1],[]],
  [[1,1],[],[]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[6,1],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[3,1,4,1],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1,4,1]],
  [[1,1,3,1,4,1],[2,1],[4,1]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1,6,1]],
  [[1,1,3,1,6,1],[2,1],[6,1]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1,6,1]],
  [[1,1,3,1,6,1],[2,1],[6,1]],
  [[1,1,3,1,4,1],[2,1],[4,1]]]]],
[64,88,"(C2 x (C8 : C2)) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1],[3,1,6,1]],
  [[],[2,1],[3,1,6,1]],
  [[],[2,1],[3,1,6,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1],[],[3,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1,3,1],[3,1],[3,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1,6,1],[6,1],[3,1]]]]],
[64,89,"(C8 x C2 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1,3,1,5,1]],
  [[],[2,1,3,1,5,1],[]],
  [[],[2,1,3,1,5,1],[]]]]],
[64,90,"C2 x (((C4 x C2) : C2) : C2)",[[1,1],[2,1],[3,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1],[],[]]],
[[[1,1,2,1,4,1,5,1]],
  [[1,1,2,1,4,1,5,1],[4,1,5,1],[]],
  [[1,1,2,1,4,1,5,1],[4,1,5,1],[]]],
[[[1,1],[3,1,6,1]],
  [[1,1],[5,1],[3,1,6,1]],
  [[1,1],[5,1],[3,1,6,1]]],
[[[1,1],[3,1,6,1]],
  [[1,1],[5,1],[3,1,6,1]],
  [[1,1],[3,1,5,1,6,1],[3,1,6,1]]],
[[[1,1],[3,1,6,1]],
  [[1,1],[],[3,1,6,1]],
  [[1,1],[],[3,1,6,1]]],
[[[1,1],[3,1,6,1]],
  [[1,1],[],[3,1,6,1]],
  [[1,1],[3,1,6,1],[3,1,6,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[6,1]],
  [[1,1],[2,1],[]]]]],
[64,91,"(((C4 x C2) : C2) : C2) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1],[],[]]]]],
[64,92,"C2 x ((C8 : C2) : C2)",[[1,1],[2,1],[3,1]],[
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[2,1,3,1],[]],
  [[1,1,3,1],[2,1,3,1],[]]],
[[[1,1,3,1,6,1],[2,1,3,1,6,1]],
  [[1,1,3,1,6,1],[2,1,3,1,6,1],[6,1]],
  [[1,1,3,1],[2,1,3,1],[]]]]],
[64,93,"C2 x (C2 . ((C4 x C2) : C2) = (C2 x C2) . (C4 x C2))",
[[1,1],[2,1],[3,1]],[
[[[1,1],[2,1,3,1]],
  [[1,1],[2,1,3,1],[]],
  [[1,1],[2,1,3,1],[]]],
[[[1,1],[2,1,3,1]],
  [[1,1],[2,1,3,1],[]],
  [[1,1],[2,1,3,1,6,1],[6,1]]]]],
[64,94,"(C2 x (C8 : C2)) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,95,"C2 x ((C8 x C2) : C2)",[[1,1],[2,1],[3,1]],[
[[[2,1,5,1]],
  [[2,1,5,1],[2,1,5,1],[]],
  [[2,1,5,1],[2,1,5,1],[]]],
[[[2,1],[3,1,6,1]],
  [[2,1],[2,1],[3,1,6,1]],
  [[2,1],[2,1],[3,1,6,1]]],
[[[2,1],[3,1,6,1]],
  [[2,1,3,1,6,1],[2,1],[3,1,6,1]],
  [[2,1],[2,1],[3,1,6,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1,5,1],[2,1],[5,1]]],
[[[2,1],[1,1,3,1,6,1]],
  [[1,1,3,1,6,1],[2,1],[6,1]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1,6,1]],
  [[1,1,3,1,6,1],[2,1],[6,1]],
  [[1,1,3,1,5,1],[2,1],[5,1]]]]],
[64,96,"C2 x (Q8 : C4)",[[1,1],[2,1],[3,1]],[
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[5,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[6,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[5,1,6,1]]]]],
[64,97,"(C8 x C2 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1,5,1]],
  [[2,1,5,1],[2,1,5,1],[]],
  [[2,1,5,1],[2,1,5,1],[]]]]],
[64,98,"(C2 x (C8 : C2)) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,99,"(C2 x (C8 : C2)) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1],[3,1,4,1,5,1]],
  [[2,1],[2,1],[3,1,4,1,5,1]],
  [[2,1],[2,1],[3,1,4,1,5,1]]]]],
[64,100,"(Q8 : C4) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,101,"C2 x ((C4 x C4) : C2)",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[2,1],[2,1],[]],
  [[2,1],[2,1],[]]],
[[[2,1],[3,1,6,1]],
  [[2,1],[2,1],[3,1,6,1]],
  [[2,1],[2,1],[3,1,6,1]]],
[[[2,1],[3,1,6,1]],
  [[2,1],[2,1],[3,1,6,1]],
  [[2,1,3,1,6,1],[2,1],[3,1,6,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[6,1]],
  [[1,1],[2,1],[]]]]],
[64,102,"(C2 x (C8 : C2)) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1],[3,1,4,1,5,1,6,1]],
  [[2,1],[2,1],[3,1,4,1,5,1,6,1]],
  [[2,1],[2,1],[3,1,4,1,5,1,6,1]]]]],
[64,103,"C2 x (C4 : C8)",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[],[6,1]],
  [[1,1],[],[]]],
[[[1,1]],
  [[1,1],[6,1],[]],
  [[1,1],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[6,1],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[2,1,3,1],[]],
  [[1,1,3,1],[2,1,3,1],[]]],
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[2,1,3,1],[]],
  [[1,1,3,1,4,1],[2,1,3,1,4,1],[4,1]]],
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[2,1,3,1],[]],
  [[1,1,3,1,6,1],[2,1,3,1,6,1],[6,1]]],
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[2,1,3,1],[]],
  [[1,1,3,1,4,1,6,1],[2,1,3,1,4,1,6,1],[4,1,6,1]]]]],
[64,104,"(C4 : C8) : C2",[[1,1],[2,1],[3,1]],[
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1],[],[3,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1,6,1],[6,1],[3,1]]],
[[[3,1],[1,1,2,1,3,1,5,1]],
  [[1,1,2,1,3,1,5,1],[3,1,5,1,6,1],[3,1]],
  [[1,1,2,1,6,1],[6,1],[3,1]]]]],
[64,105,"(C4 : C8) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,106,"C2 x (C8 : C4)",[[1,1],[2,1],[3,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1],[],[]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[5,1,6,1]],
  [[1,1,2,1],[],[]]],
[[[1,1,2,1,5,1,6,1]],
  [[1,1,2,1,5,1,6,1],[5,1,6,1],[]],
  [[1,1,2,1],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[3,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[5,1],[3,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1,5,1],[2,1],[5,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1,6,1],[2,1],[6,1]]]]],
[64,107,"C2 x (C8 : C4)",[[1,1],[2,1],[3,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1],[],[]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1],[],[5,1]]],
[[[1,1,2,1,5,1]],
  [[1,1,2,1,5,1],[5,1],[]],
  [[1,1,2,1],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[5,1],[3,1]],
  [[1,1],[],[3,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1,5,1],[2,1],[5,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1,6,1],[2,1],[6,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1,5,1,6,1],[2,1],[5,1,6,1]]]]],
[64,108,"(C8 : C4) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1],[],[]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1,5,1,6,1],[5,1,6,1],[]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1],[],[5,1,6,1]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1,5,1,6,1],[5,1,6,1],[5,1,6,1]]]]],
[64,109,"(C8 : C4) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1],[3,1,6,1]],
  [[1,1],[],[3,1,6,1]],
  [[1,1],[],[3,1,6,1]]],
[[[1,1],[3,1,6,1]],
  [[1,1],[],[3,1,6,1]],
  [[1,1],[5,1],[3,1,6,1]]]]],
[64,110,"C2 x (C4 . D8 = C4 . (C4 x C2))",[[1,1],[2,1],[3,1]],[
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1,6,1]],
  [[1,1,3,1,6,1],[2,1],[6,1]],
  [[1,1,3,1],[2,1],[]]]]],
[64,111,"(C4 . D8 = C4 . (C4 x C2)) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,112,"(C8 x C4) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[]],
  [[1,1,2,1],[],[]]],
[[[1,1,2,1,6,1]],
  [[1,1,2,1,6,1],[6,1],[]],
  [[1,1,2,1],[],[]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[6,1]],
  [[1,1,2,1],[],[]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[6,1]],
  [[1,1,2,1,6,1],[6,1],[]]]]],
[64,113,"(C4 : C8) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,114,"(C8 x C4) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]]]],
[64,115,"C8 x D8",[[1,1],[2,1],[3,1]],[
[[[1,1,3,1,5,1,6,1]],
  [[1,1,3,1,5,1,6,1],[],[]],
  [[1,1,3,1,5,1,6,1],[],[]]],
[[[1,1,3,1,5,1,6,1]],
  [[1,1,3,1,5,1,6,1],[1,1,3,1,5,1,6,1],[]],
  [[1,1,3,1,5,1,6,1],[1,1,3,1,5,1,6,1],[]]],
[[[2,1],[1,1,3,1,5,1]],
  [[1,1,3,1,5,1],[2,1],[]],
  [[1,1,3,1,5,1],[2,1],[]]],
[[[2,1],[1,1,3,1,4,1,5,1]],
  [[1,1,3,1,4,1,5,1],[2,1],[4,1]],
  [[1,1,3,1,5,1],[2,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[1,1,3,1,5,1],[3,1]],
  [[1,1],[1,1,3,1,5,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[1,1,3,1,5,1],[3,1]],
  [[1,1],[1,1,3,1,5,1,6,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[6,1],[3,1]],
  [[1,1],[],[3,1]]]]],
[64,116,"(C8 x C2 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1,3,1]],
  [[1,1,3,1],[],[]],
  [[1,1,3,1],[],[]]],
[[[1,1,3,1],[2,1,6,1]],
  [[1,1,3,1],[2,1,6,1],[]],
  [[1,1,3,1],[2,1,6,1],[]]],
[[[1,1,3,1],[2,1,6,1]],
  [[1,1,3,1],[2,1,6,1],[]],
  [[1,1,3,1,4,1],[2,1,6,1],[4,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[6,1],[3,1]]]]],
[64,117,"(C8 x C4) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1,3,1]],
  [[1,1,3,1],[1,1,3,1],[]],
  [[1,1,3,1],[1,1,3,1],[]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1,4,1,6,1]],
  [[1,1,3,1,4,1,6,1],[2,1],[4,1,6,1]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[3,1]],
  [[2,1,3,1,5,1],[2,1],[3,1]],
  [[2,1,3,1,5,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[2,1,3,1,5,1,6,1],[2,1],[3,1]],
  [[2,1,3,1,5,1],[2,1],[3,1]]]]],
[64,118,"C4 x D16",[[1,1],[2,1],[3,1]],[
[[[2,1,5,1]],
  [[2,1,5,1],[2,1,5,1],[]],
  [[2,1,5,1],[2,1,5,1],[]]],
[[[2,1],[3,1]],
  [[2,1,3,1],[2,1],[3,1]],
  [[2,1,3,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[2,1,3,1,5,1],[2,1],[3,1]],
  [[2,1,3,1],[2,1],[3,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1,6,1],[2,1],[6,1]]]]],
[64,119,"C4 x QD16",[[1,1],[2,1],[3,1]],[
[[[1,1,3,1]],
  [[1,1,3,1],[1,1,3,1],[]],
  [[1,1,3,1],[1,1,3,1],[]]],
[[[1,1],[3,1,6,1]],
  [[1,1],[1,1,3,1,6,1],[3,1,6,1]],
  [[1,1],[1,1,3,1,6,1],[3,1,6,1]]],
[[[1,1],[3,1,6,1]],
  [[1,1],[1,1,3,1,6,1],[3,1,6,1]],
  [[1,1],[1,1,3,1,5,1,6,1],[3,1,6,1]]],
[[[1,1,3,1],[2,1,5,1]],
  [[1,1,3,1],[2,1,5,1],[]],
  [[1,1,3,1],[2,1,5,1],[]]],
[[[2,1,5,1],[1,1,3,1,6,1]],
  [[1,1,3,1,6,1],[2,1,5,1],[6,1]],
  [[1,1,3,1],[2,1,5,1],[]]]]],
[64,120,"C4 x Q16",[[1,1],[2,1],[3,1]],[
[[[2,1,5,1,6,1],[1,1,3,1,5,1,6,1]],
  [[1,1,3,1,5,1,6,1],[2,1,5,1,6,1],[]],
  [[1,1,3,1,5,1,6,1],[2,1,5,1,6,1],[]]],
[[[1,1,3,1,5,1],[2,1,5,1,6,1]],
  [[1,1,3,1,5,1],[2,1,5,1,6,1],[6,1]],
  [[1,1,3,1,5,1,6,1],[2,1,5,1,6,1],[]]]]],
[64,121,"(C4 x Q8) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1],[3,1]],
  [[2,1,3,1],[2,1],[3,1]],
  [[2,1,3,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[2,1,3,1,5,1],[2,1],[3,1]],
  [[2,1,3,1],[2,1],[3,1]]]]],
[64,122,"Q16 : C4",[[1,1],[2,1],[3,1]],[
 ]],
[64,123,"(C4 x D8) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1],[3,1,6,1]],
  [[2,1,3,1,6,1],[2,1],[3,1,6,1]],
  [[2,1,3,1,6,1],[2,1],[3,1,6,1]]],
[[[2,1],[3,1,6,1]],
  [[2,1,3,1,5,1],[2,1],[3,1,6,1]],
  [[2,1,3,1,6,1],[2,1],[3,1,6,1]]]]],
[64,124,"(C8 x C4) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1,3,1,5,1]],
  [[1,1,3,1,5,1],[1,1,3,1,5,1],[]],
  [[1,1,3,1,5,1],[1,1,3,1,5,1],[]]]]],
[64,125,"((C4 x C4) : C2) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,126,"C8 x Q8",[[1,1],[2,1],[3,1]],[
[[[2,1],[1,1,3,1,5,1]],
  [[1,1,3,1,5,1],[2,1],[4,1]],
  [[1,1,3,1,5,1],[2,1],[4,1]]],
[[[2,1],[1,1,3,1,4,1,5,1]],
  [[1,1,3,1,4,1,5,1],[2,1],[]],
  [[1,1,3,1,5,1],[2,1],[4,1]]]]],
[64,127,"C8 : Q8",[[1,1],[2,1],[3,1]],[
[[[1,1,3,1],[2,1,6,1]],
  [[1,1,3,1],[2,1,6,1],[]],
  [[1,1,3,1],[2,1,6,1],[]]],
[[[2,1,6,1],[1,1,3,1,4,1]],
  [[1,1,3,1,4,1],[2,1,6,1],[4,1]],
  [[1,1,3,1],[2,1,6,1],[]]]]],
[64,128,"(C2 x C2 x D8) : C2",[[1,1],[2,1],[3,1]],[
[[[3,1],[2,1,5,1]],
  [[2,1,5,1],[2,1,5,1],[3,1]],
  [[2,1,5,1],[2,1,5,1],[3,1]]],
[[[1,1],[2,1,3,1,5,1]],
  [[1,1],[2,1,3,1,5,1],[]],
  [[1,1],[2,1,3,1,5,1],[]]],
[[[1,1],[2,1,3,1,5,1]],
  [[1,1],[2,1,3,1,5,1],[]],
  [[1,1],[2,1,3,1,5,1,6,1],[6,1]]]]],
[64,129,"(C2 x C2 x Q8) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1],[2,1,3,1]],
  [[1,1],[2,1,3,1],[]],
  [[1,1],[2,1,3,1],[]]],
[[[1,1],[2,1,3,1,6,1]],
  [[1,1],[2,1,3,1,6,1],[6,1]],
  [[1,1],[2,1,3,1],[]]]]],
[64,130,"(C2 x D16) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,131,"(C2 x QD16) : C2",[[1,1],[2,1],[3,1]],[
[[[3,1],[2,1,5,1]],
  [[2,1,5,1],[2,1,5,1],[3,1]],
  [[2,1,5,1],[2,1,5,1],[3,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[6,1]],
  [[1,1],[2,1,5,1],[]]]]],
[64,132,"(C2 x Q16) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1],[2,1,3,1,5,1]],
  [[1,1],[2,1,3,1,5,1],[]],
  [[1,1],[2,1,3,1,5,1],[]]],
[[[1,1],[2,1,3,1,5,1]],
  [[1,1],[2,1,3,1,5,1],[]],
  [[1,1],[2,1,3,1,5,1,6,1],[6,1]]]]],
[64,133,"(C2 x Q16) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,134,"((C4 x C4) : C2) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1],[3,1]],
  [[3,1],[2,1],[3,1]],
  [[3,1],[2,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[3,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1,5,1],[3,1]],
  [[1,1],[5,1],[3,1]]]]],
[64,135,"((C4 x C4) : C2) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,136,"((C4 x C4) : C2) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1],[3,1]],
  [[3,1],[2,1],[3,1]],
  [[3,1],[2,1],[3,1]]]]],
[64,137,"((C4 x C4) : C2) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,138,"(((C4 x C2) : C2) : C2) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1],[3,1]],
  [[],[2,1],[3,1]],
  [[],[2,1],[3,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[4,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]]]],
[64,139,"(((C4 x C2) : C2) : C2) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1],[3,1]],
  [[],[2,1],[3,1]],
  [[],[2,1],[3,1]]]]],
[64,140,"(C4 x D8) : C2",[[1,1],[2,1],[3,1]],[
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1],[],[3,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1,6,1],[6,1],[3,1]]]]],
[64,141,"(C2 x QD16) : C2",[[1,1],[2,1],[3,1]],[
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1],[],[3,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1,6,1],[6,1],[3,1]]]]],
[64,142,"(Q8 : C4) : C2",[[1,1],[2,1],[3,1]],[
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1],[],[3,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1,6,1],[6,1],[3,1]]]]],
[64,143,"C4 : Q16",[[1,1],[2,1],[3,1]],[
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1]],
  [[1,1,2,1],[],[3,1]]],
[[[3,1],[1,1,2,1,6,1]],
  [[1,1,2,1,6,1],[6,1],[3,1]],
  [[1,1,2,1],[],[3,1]]]]],
[64,144,"(C4 x D8) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,145,"(C2 x Q16) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,146,"(C8 x C2 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[5,1],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[]],
  [[1,1],[2,1],[6,1]]]]],
[64,147,"(C8 x C2 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[5,1],[3,1]],
  [[1,1],[],[3,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[6,1]]]]],
[64,148,"(C2 x Q16) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[6,1]],
  [[1,1],[2,1,5,1],[]]]]],
[64,149,"(C2 x (C8 : C2)) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1],[3,1,6,1]],
  [[1,1],[],[3,1,6,1]],
  [[1,1],[],[3,1,6,1]]],
[[[1,1],[3,1,6,1]],
  [[1,1],[5,1],[3,1,6,1]],
  [[1,1],[],[3,1,6,1]]]]],
[64,150,"(C2 x (C8 : C2)) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1,2,1],[3,1,6,1]],
  [[1,1,2,1],[],[3,1,6,1]],
  [[1,1,2,1],[],[3,1,6,1]]],
[[[3,1,6,1],[1,1,2,1,5,1,6,1]],
  [[1,1,2,1,5,1,6,1],[5,1,6,1],[3,1,6,1]],
  [[1,1,2,1],[],[3,1,6,1]]]]],
[64,151,"(C2 x Q16) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,152,"(C2 x QD16) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,153,"(C2 x D16) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,154,"(C2 x Q16) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,155,"(C8 : C4) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,156,"Q8 : Q8",[[1,1],[2,1],[3,1]],[
 ]],
[64,157,"(C8 : C4) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,158,"Q8 : Q8",[[1,1],[2,1],[3,1]],[
 ]],
[64,159,"(C8 : C4) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,160,"(C2 x C2) . (C2 x D8) = (C4 x C2) . (C2 x C2 x C2)",
[[1,1],[2,1],[3,1]],[
 ]],
[64,161,"(C2 x (C4 : C4)) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,162,"(C2 x (C4 : C4)) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,163,"((C8 x C2) : C2) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,164,"(Q8 : C4) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,165,"(Q8 : C4) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,166,"(C8 : C4) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,167,"(C8 x C4) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]]]],
[64,168,"(C2 x C2) . (C2 x D8) = (C4 x C2) . (C2 x C2 x C2)",
[[1,1],[2,1],[3,1]],[
 ]],
[64,169,"(C8 x C4) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]]]],
[64,170,"(Q8 : C4) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,171,"((C8 x C2) : C2) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,172,"(C2 x C2) . (C2 x D8) = (C4 x C2) . (C2 x C2 x C2)",
[[1,1],[2,1],[3,1]],[
 ]],
[64,173,"(C8 x C4) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1],[3,1,4,1,6,1]],
  [[1,1],[],[3,1,4,1,6,1]],
  [[1,1],[],[3,1,4,1,6,1]]],
[[[1,1],[3,1,4,1,6,1]],
  [[1,1],[],[3,1,4,1,6,1]],
  [[1,1],[5,1,6,1],[3,1,4,1,6,1]]],
[[[1,1],[3,1,4,1,6,1]],
  [[1,1],[],[3,1,4,1,6,1]],
  [[1,1],[3,1,4,1,5,1],[3,1,4,1,5,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1,6,1],[4,1]]],
[[[1,1],[2,1,5,1]],
  [[1,1],[2,1,5,1],[]],
  [[1,1],[2,1,5,1],[6,1]]]]],
[64,174,"(C8 x C4) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]],
  [[1,1],[5,1,6,1],[3,1,4,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]],
  [[1,1],[3,1,4,1],[3,1,4,1,5,1,6,1]]],
[[[1,1,3,1],[2,1,3,1,5,1]],
  [[1,1,3,1],[2,1,3,1,5,1],[]],
  [[1,1,3,1],[2,1,3,1,5,1],[]]],
[[[1,1,3,1],[2,1,3,1,5,1]],
  [[1,1,3,1],[2,1,3,1,5,1],[]],
  [[1,1,3,1,6,1],[2,1,3,1,5,1,6,1],[6,1]]],
[[[2,1,3,1,4,1],[1,1,3,1,4,1,5,1,6,1]],
  [[1,1,3,1,4,1,5,1,6,1],[2,1,3,1,4,1],[4,1,5,1]],
  [[1,1,3,1,6,1],[2,1,3,1,5,1,6,1],[6,1]]]]],
[64,175,"C4 : Q16",[[1,1],[2,1],[3,1]],[
[[[1,1,3,1],[2,1,5,1]],
  [[1,1,3,1],[2,1,5,1],[]],
  [[1,1,3,1],[2,1,5,1],[]]],
[[[2,1,5,1],[1,1,3,1,6,1]],
  [[1,1,3,1,6,1],[2,1,5,1],[6,1]],
  [[1,1,3,1,4,1,6,1],[2,1,5,1,6,1],[4,1]]],
[[[2,1,5,1],[1,1,3,1,6,1]],
  [[1,1,3,1,6,1],[2,1,5,1],[6,1]],
  [[1,1,3,1],[2,1,5,1],[]]]]],
[64,176,"(C8 x C4) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]]]],
[64,177,"(C2 x D16) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[],[3,1,4,1]],
  [[1,1],[5,1,6,1],[3,1,4,1]]]]],
[64,178,"(C2 x Q16) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,179,"C8 : Q8",[[1,1],[2,1],[3,1]],[
[[[1,1],[2,1,6,1]],
  [[1,1],[2,1,6,1],[]],
  [[1,1],[2,1,6,1],[]]],
[[[1,1],[2,1,6,1]],
  [[1,1],[2,1,6,1],[]],
  [[1,1],[2,1,6,1],[4,1]]],
[[[1,1],[2,1,6,1]],
  [[1,1],[2,1,6,1],[2,1,6,1]],
  [[1,1],[2,1,6,1],[4,1]]]]],
[64,180,"(C2 x C2) . (C2 x D8) = (C4 x C2) . (C2 x C2 x C2)",
[[1,1],[2,1],[3,1]],[
 ]],
[64,181,"C8 : Q8",[[1,1],[2,1],[3,1]],[
[[[1,1],[2,1,6,1]],
  [[1,1],[2,1,6,1],[]],
  [[1,1],[2,1,6,1],[]]],
[[[1,1],[2,1,6,1]],
  [[1,1],[2,1,6,1],[]],
  [[1,1],[2,1,6,1],[2,1,6,1]]],
[[[1,1],[2,1,6,1]],
  [[1,1],[2,1,6,1],[]],
  [[1,1],[2,1,6,1],[4,1]]]]],
[64,182,"C8 : Q8",[[1,1],[2,1],[3,1]],[
[[[1,1],[2,1,6,1]],
  [[1,1],[2,1,6,1],[]],
  [[1,1],[2,1,6,1],[]]],
[[[1,1],[2,1,6,1]],
  [[1,1],[2,1,6,1],[]],
  [[1,1],[2,1,6,1],[4,1]]]]],
[64,183,"C16 x C2 x C2",[[1,1],[2,1],[3,1]],[
[[[3,1]],
  [[],[],[3,1]],
  [[],[],[3,1]]],
[[[3,1]],
  [[],[3,1],[3,1]],
  [[],[],[3,1]]],
[[[3,1]],
  [[3,1],[],[3,1]],
  [[],[],[3,1]]],
[[[2,1,6,1],[3,1]],
  [[],[2,1,6,1],[3,1]],
  [[],[2,1,6,1],[3,1]]],
[[[2,1,6,1],[3,1]],
  [[],[2,1,6,1],[3,1]],
  [[2,1,6,1],[2,1,6,1],[3,1]]],
[[[1,1,5,1]],
  [[1,1],[],[]],
  [[1,1],[],[]]],
[[[1,1,5,1]],
  [[1,1],[],[]],
  [[1,1],[6,1],[]]],
[[[2,1,6,1],[1,1,3,1,5,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1,6,1],[1,1,3,1,5,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,2,1,3,1,6,1],[2,1],[2,1,6,1]]],
[[[2,1,6,1],[1,1,2,1,3,1,5,1]],
  [[1,1,2,1,3,1],[2,1],[2,1]],
  [[1,1,2,1,3,1,6,1],[2,1],[2,1,6,1]]]]],
[64,184,"C2 x (C16 : C2)",[[1,1],[2,1],[3,1]],[
[[[2,1]],
  [[],[2,1],[]],
  [[],[2,1],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1]],
  [[],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[3,1],[2,1],[3,1]],
  [[],[2,1],[3,1]]],
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[2,1,3,1],[]],
  [[1,1,3,1],[2,1,3,1],[]]],
[[[1,1,3,1,6,1],[2,1,3,1,6,1]],
  [[1,1,3,1,6,1],[2,1,3,1,6,1],[6,1]],
  [[1,1,3,1],[2,1,3,1],[]]]]],
[64,185,"(C16 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[3,1]],
  [[],[],[3,1]],
  [[],[],[3,1]]]]],
[64,186,"C2 x D32",[[1,1],[2,1],[3,1]],[
[[[1,1,3,1]],
  [[1,1,3,1],[1,1,3,1],[]],
  [[1,1,3,1],[1,1,3,1],[]]],
[[[2,1],[3,1,6,1]],
  [[2,1],[2,1],[3,1,6,1]],
  [[2,1],[2,1],[3,1,6,1]]],
[[[2,1],[3,1,6,1]],
  [[2,1],[2,1],[3,1,6,1]],
  [[2,1,3,1,6,1],[2,1],[3,1,6,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1,6,1],[2,1],[6,1]]]]],
[64,187,"C2 x QD32",[[1,1],[2,1],[3,1]],[
[[[2,1,3,1]],
  [[2,1,3,1],[2,1,3,1],[]],
  [[2,1,3,1],[2,1,3,1],[]]],
[[[2,1],[3,1]],
  [[2,1],[2,1],[3,1]],
  [[2,1],[2,1],[3,1]]],
[[[2,1],[3,1]],
  [[2,1],[2,1],[3,1]],
  [[2,1,3,1],[2,1],[3,1]]],
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[2,1,3,1],[]],
  [[1,1,3,1],[2,1,3,1],[]]],
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[2,1,3,1],[]],
  [[1,1,3,1,6,1],[2,1,3,1,6,1],[6,1]]]]],
[64,188,"C2 x Q32",[[1,1],[2,1],[3,1]],[
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[]],
  [[1,1,3,1],[2,1],[]]],
[[[2,1],[1,1,3,1,6,1]],
  [[1,1,3,1,6,1],[2,1],[6,1]],
  [[1,1,3,1],[2,1],[]]]]],
[64,189,"(C16 x C2) : C2",[[1,1],[2,1],[3,1]],[
[[[1,1]],
  [[1,1],[1,1],[]],
  [[1,1],[1,1],[]]]]],
[64,190,"(C2 x D16) : C2",[[1,1],[2,1],[3,1]],[
[[[2,1],[3,1]],
  [[2,1],[2,1],[3,1]],
  [[2,1],[2,1],[3,1]]]]],
[64,191,"(C2 x Q16) : C2",[[1,1],[2,1],[3,1]],[
 ]],
[64,192,"C4 x C4 x C2 x C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[3,1]],
  [[],[],[3,1],[]],
  [[],[],[3,1],[]]],
[[[3,1]],
  [[],[],[3,1],[]],
  [[],[],[3,1],[3,1]]],
[[[3,1]],
  [[],[],[3,1],[]],
  [[3,1],[],[3,1],[]]],
[[[1,1]],                                  ## 5  <a> 
  [[1,1],[],[],[]],
  [[1,1],[],[],[]]],
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[],[5,1],[]]],
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[5,1],[],[]]],
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[1,1],[],[]]],
[[[3,1],[4,1]],                        ## 9  <c,d>
  [[],[],[3,1],[4,1]],
  [[],[],[3,1],[4,1]]],
[[[3,1],[4,1]],
  [[],[],[3,1],[4,1]],
  [[3,1],[],[3,1],[4,1]]],
[[[3,1],[4,1]],
  [[],[],[3,1],[4,1]],
  [[3,1],[4,1],[3,1],[4,1]]],
[[[1,1],[3,1]],                       ## 12  <a,c> 
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[]]],
[[[1,1],[3,1]], 
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[5,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[1,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[1,1],[3,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[5,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[5,1],[3,1],[3,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[3,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[3,1],[3,1],[5,1]]],
[[[1,1],[2,1]],                         ## 21  <a,b>
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[],[]]], 
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[5,1],[]]], 
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[5,1],[6,1]]], 
[[[1,1],[3,1],[4,1]],               ## 24  <a,c,d>
  [[1,1],[],[3,1],[4,1]],
  [[1,1],[],[3,1],[4,1]]], 
[[[1,1],[3,1],[4,1]],
  [[1,1],[],[3,1],[4,1]],
  [[1,1],[1,1],[3,1],[4,1]]], 
[[[1,1],[3,1],[4,1]],
  [[1,1],[],[3,1],[4,1]],
  [[1,1],[5,1],[3,1],[4,1]]], 
[[[1,1],[3,1],[4,1]],
  [[1,1],[],[3,1],[4,1]],
  [[1,1],[3,1],[3,1],[4,1]]], 
[[[1,1],[2,1],[3,1]],               ## 28  <a,b,c>
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[]]], 
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[3,1]]], 
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[5,1]]]]],   
[64,193,"C2 x C2 x ((C4 x C2) : C2)",[[1,1],[2,1],[3,1],[4,1] 
 ],[
[[[2,1]],
  [[],[2,1],[],[]],
  [[],[2,1],[],[]]],
[[[2,1],[4,1,5,1,6,1]],
  [[],[2,1],[],[4,1,5,1,6,1]],
  [[],[2,1],[],[4,1,5,1,6,1]]],
[[[2,1],[4,1,5,1,6,1]],
  [[],[2,1],[],[4,1,5,1,6,1]],
  [[4,1,5,1,6,1],[2,1],[4,1,5,1,6,1], 
  [4,1,5,1,6,1]]],
[[[2,1],[4,1,5,1,6,1]],
  [[],[2,1],[],[4,1,5,1,6,1]],
  [[4,1,5,1,6,1],[2,1],[],[4,1,5,1,6,1]]],
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[],[],[]]],
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[6,1],[],[6,1]]],
[[[1,1]],
  [[1,1],[],[],[6,1]],
  [[1,1],[6,1],[],[6,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1],[]],
  [[1,1,2,1],[],[3,1],[]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1],[]],
  [[1,1,2,1],[],[3,1],[3,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1],[]],
  [[1,1,2,1,5,1,6,1],[5,1,6,1],[3,1],[5,1,6,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1],[]],
  [[1,1,2,1,3,1],[3,1],[3,1],[]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1],[]],
  [[1,1,2,1,5,1,6,1],[5,1,6,1],[3,1], 
  [3,1,5,1,6,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1],[]],
  [[1,1,2,1,3,1,5,1,6,1],[3,1,5,1,6,1],[3,1], 
  [5,1,6,1]]],
[[[3,1],[1,1,2,1]],
  [[1,1,2,1],[],[3,1],[5,1,6,1]],
  [[1,1,2,1,5,1,6,1],[5,1,6,1],[3,1],[5,1,6,1]]],
[[[2,1],[3,1,6,1],[4,1,5,1]],
  [[],[2,1],[3,1,6,1],[4,1,5,1]],
  [[],[2,1],[3,1,6,1],[4,1,5,1]]],
[[[2,1],[3,1,6,1],[4,1,5,1]],
  [[3,1,6,1],[2,1],[3,1,6,1],[4,1,5,1]],
  [[],[2,1],[3,1,6,1],[4,1,5,1]]],
[[[2,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[],[]],
  [[1,1,4,1],[2,1],[],[]]],
[[[2,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[],[]],
  [[1,1,4,1,5,1],[2,1],[],[5,1]]],
[[[2,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[6,1],[]],
  [[1,1,4,1],[2,1],[5,1],[]]],
[[[2,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[],[]],
  [[1,1,4,1,6,1],[2,1],[5,1,6,1],[6,1]]],
[[[1,1],[4,1],[3,1,5,1]],
  [[1,1],[],[3,1,5,1],[4,1]],
  [[1,1],[],[3,1,5,1],[4,1]]],
[[[1,1],[4,1],[3,1,5,1]],
  [[1,1],[4,1],[3,1,5,1],[4,1]],
  [[1,1],[],[3,1,5,1],[4,1]]],
[[[1,1],[4,1],[3,1,5,1]],
  [[1,1],[6,1],[3,1,5,1],[4,1]],
  [[1,1],[],[3,1,5,1],[4,1]]],
[[[1,1],[3,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[3,1],[]],
  [[1,1],[2,1,4,1],[3,1],[]]],
[[[1,1],[3,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[3,1],[]],
  [[1,1],[2,1,3,1,4,1,6,1],[3,1],[3,1,6,1]]],
[[[1,1],[3,1],[2,1,4,1,5,1]],
  [[1,1],[2,1,4,1,5,1],[3,1],[5,1]],
  [[1,1],[2,1,4,1],[3,1],[]]],
[[[1,1],[3,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[3,1],[]],
  [[1,1],[2,1,4,1,6,1],[3,1],[6,1]]]]],
[64,194,"C2 x C2 x (C4 : C4)",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[],[],[]],
  [[1,1,2,1],[],[],[]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[],[]],
  [[1,1,2,1],[],[],[6,1]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[],[]],
  [[1,1,2,1,6,1],[6,1],[],[]]],
[[[1,1],[4,1]],
  [[1,1],[],[],[4,1]],
  [[1,1],[],[],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[],[4,1]],
  [[1,1],[],[4,1],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[6,1],[4,1]],
  [[1,1],[],[],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[],[4,1]],
  [[1,1],[4,1],[],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[],[4,1]],
  [[1,1],[4,1,6,1],[6,1],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[],[4,1]],
  [[1,1],[6,1],[4,1,6,1],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[6,1],[],[4,1]],
  [[1,1],[],[],[4,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[],[]],
  [[1,1,3,1],[2,1],[],[]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[],[5,1]],
  [[1,1,3,1],[2,1],[],[]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[],[]],
  [[1,1,3,1,6,1],[2,1],[6,1],[6,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[],[]],
  [[1,1,3,1,5,1,6,1],[2,1],[5,1,6,1],[5,1,6,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[],[5,1]],
  [[1,1,3,1,6,1],[2,1],[6,1],[6,1]]],
[[[1,1],[4,1],[3,1,5,1]],
  [[1,1],[],[3,1,5,1],[4,1]],
  [[1,1],[],[3,1,5,1],[4,1]]],
[[[1,1],[4,1],[3,1,5,1]],
  [[1,1],[],[3,1,5,1],[4,1]],
  [[1,1],[4,1],[3,1,5,1],[4,1]]],
[[[1,1],[4,1],[3,1,5,1]],
  [[1,1],[],[3,1,5,1],[4,1]],
  [[1,1],[6,1],[3,1,5,1],[4,1]]],
[[[1,1],[3,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[3,1],[]],
  [[1,1],[2,1,4,1],[3,1],[]]],
[[[1,1],[3,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[3,1],[]],
  [[1,1],[2,1,3,1,4,1],[3,1],[3,1]]],
[[[1,1],[3,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[3,1],[]],
  [[1,1],[2,1,4,1,5,1],[3,1],[5,1]]],
[[[1,1],[3,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[3,1],[]],
  [[1,1],[2,1,4,1,6,1],[3,1],[6,1]]],
[[[1,1],[3,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[3,1],[]],
  [[1,1],[2,1,4,1,5,1,6,1],[3,1],[5,1,6,1]]]]],
[64,195,"C2 x ((C4 x C4) : C2)",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1]],
  [[],[2,1],[],[]],
  [[],[2,1],[],[]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[],[]],
  [[1,1,2,1],[],[],[]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[],[]],
  [[1,1,2,1],[],[5,1,6,1],[5,1,6,1]]],
[[[1,1,2,1,5,1,6,1]],
  [[1,1,2,1,5,1,6,1],[5,1,6,1],[],[]],
  [[1,1,2,1],[],[5,1,6,1],[]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[],[]],
  [[1,1,2,1],[],[5,1,6,1],[]]],
[[[1,1,2,1]],
  [[1,1,2,1],[],[],[]],
  [[1,1,2,1,5,1,6,1],[5,1,6,1],[],[]]],
[[[2,1],[4,1,5,1,6,1]],
  [[],[2,1],[],[4,1,5,1,6,1]],
  [[],[2,1],[],[4,1,5,1,6,1]]],
[[[2,1],[4,1,5,1,6,1]],
  [[2,1],[2,1],[],[4,1,5,1,6,1]],
  [[2,1],[2,1],[4,1,5,1,6,1],[4,1,5,1,6,1]]],
[[[2,1],[4,1,5,1,6,1]],
  [[],[2,1],[],[4,1,5,1,6,1]],
  [[4,1,5,1,6,1],[2,1],[],[4,1,5,1,6,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[],[4,1]],
  [[1,1],[],[],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[],[4,1]],
  [[1,1],[4,1,6,1],[4,1,6,1],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[4,1],[4,1]],
  [[1,1],[6,1],[4,1,6,1],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1],[],[4,1]],
  [[1,1],[],[],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[4,1],[4,1]],
  [[1,1],[],[],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[4,1],[4,1]],
  [[1,1],[4,1,6,1],[4,1,6,1],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1],[],[4,1]],
  [[1,1],[4,1,6,1],[4,1,6,1],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[6,1],[],[4,1]],
  [[1,1],[],[],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[6,1],[4,1]],
  [[1,1],[4,1,6,1],[4,1,6,1],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[6,1],[4,1]],
  [[1,1],[],[],[4,1]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1],[2,1],[3,1],[]]],
[[[2,1],[3,1],[1,1,4,1,6,1]],
  [[1,1,4,1,6,1],[2,1],[3,1],[6,1]],
  [[1,1,4,1,5,1,6,1],[2,1],[3,1],[5,1,6,1]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1,5,1,6,1],[2,1],[3,1],[5,1,6,1]]]]],
[64,196,"C2 x C4 x D8",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1]],
  [[2,1],[2,1],[],[]],
  [[2,1],[2,1],[],[]]],
[[[2,1]],
  [[],[2,1],[],[]],
  [[],[2,1],[],[]]],
[[[2,1,6,1],[4,1,5,1,6,1]],
  [[],[2,1,6,1],[],[4,1,5,1,6,1]],
  [[],[2,1,6,1],[],[4,1,5,1,6,1]]],
[[[2,1,6,1],[4,1,5,1,6,1]],
  [[],[2,1,6,1],[],[4,1,5,1,6,1]],
  [[],[2,1,6,1],[4,1,5,1,6,1],[4,1,5,1,6,1]]],
[[[2,1,6,1],[4,1,5,1,6,1]],
  [[4,1,5,1,6,1],[2,1,6,1],[],[4,1,5,1,6,1]],
  [[],[2,1,6,1],[],[4,1,5,1,6,1]]],
[[[2,1,6,1],[4,1,5,1,6,1]],
  [[4,1,5,1,6,1],[2,1,6,1],[],[4,1,5,1,6,1]],
  [[],[2,1,6,1],[4,1,5,1,6,1],[4,1,5,1,6,1]]],
[[[2,1,6,1],[4,1,5,1,6,1]],
  [[2,1,6,1],[2,1,6,1],[],[4,1,5,1,6,1]],
  [[2,1,6,1],[2,1,6,1],[],[4,1,5,1,6,1]]],
[[[2,1,6,1],[4,1,5,1,6,1]],
  [[2,1,4,1,5,1],[2,1,6,1],[],[4,1,5,1,6,1]],
  [[2,1,4,1,5,1],[2,1,6,1],[4,1,5,1,6,1], 
  [4,1,5,1,6,1]]],
[[[2,1,6,1],[4,1,5,1,6,1]],
  [[2,1,6,1],[2,1,6,1],[],[4,1,5,1,6,1]],
  [[2,1,4,1,5,1],[2,1,6,1],[4,1,5,1,6,1], 
  [4,1,5,1,6,1]]],
[[[2,1,6,1],[4,1,5,1,6,1]],
  [[2,1,6,1],[2,1,6,1],[],[4,1,5,1,6,1]],
  [[2,1,4,1,5,1],[2,1,6,1],[],[4,1,5,1,6,1]]],
[[[2,1],[3,1]],
  [[2,1,3,1],[2,1],[3,1],[]],
  [[2,1,3,1],[2,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[2,1,3,1],[2,1],[3,1],[]],
  [[2,1,3,1],[2,1],[3,1],[6,1]]],
[[[2,1],[3,1]],
  [[2,1,3,1,6,1],[2,1],[3,1],[]],
  [[2,1,3,1],[2,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[3,1],[2,1],[3,1],[]],
  [[3,1],[2,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[3,1],[2,1],[3,1],[]],
  [[3,1,6,1],[2,1],[3,1],[6,1]]],
[[[2,1],[3,1]],
  [[3,1],[2,1],[3,1],[6,1]],
  [[3,1,6,1],[2,1],[3,1],[6,1]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[],[]],
  [[1,1,3,1],[2,1],[],[]]],
[[[2,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[],[5,1]],
  [[1,1,3,1],[2,1],[],[]]],
[[[2,1],[1,1,3,1,5,1]],
  [[1,1,3,1,5,1],[2,1],[5,1],[]],
  [[1,1,3,1],[2,1],[],[]]],
[[[2,1],[4,1],[3,1,5,1]],
  [[3,1,5,1],[2,1],[3,1,5,1],[4,1]],
  [[3,1,5,1],[2,1],[3,1,5,1],[4,1]]],
[[[2,1],[4,1],[3,1,5,1]],
  [[3,1,5,1],[2,1],[3,1,5,1],[4,1]],
  [[3,1,4,1,5,1],[2,1],[3,1,5,1],[4,1]]],
[[[2,1],[4,1],[3,1,5,1]],
  [[3,1,5,1],[2,1],[3,1,5,1],[4,1]],
  [[3,1,5,1,6,1],[2,1],[3,1,5,1],[4,1]]],
[[[2,1],[4,1],[3,1,5,1]],
  [[2,1,3,1,5,1],[2,1],[3,1,5,1],[4,1]],
  [[2,1,3,1,5,1],[2,1],[3,1,5,1],[4,1]]],
[[[2,1],[4,1],[3,1,5,1]],
  [[2,1,3,1,4,1,5,1],[2,1],[3,1,5,1],[4,1]],
  [[2,1,3,1,5,1],[2,1],[3,1,5,1],[4,1]]],
[[[2,1],[4,1],[3,1,5,1]],
  [[2,1,3,1,5,1,6,1],[2,1],[3,1,5,1],[4,1]],
  [[2,1,3,1,5,1],[2,1],[3,1,5,1],[4,1]]],
[[[2,1],[4,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[],[4,1]],
  [[1,1,3,1],[2,1],[],[4,1]]],
[[[2,1],[4,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[],[4,1]],
  [[1,1,3,1,4,1],[2,1],[4,1],[4,1]]],
[[[2,1],[4,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[],[4,1]],
  [[1,1,3,1,5,1],[2,1],[5,1],[4,1]]],
[[[1,1],[3,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[3,1],[]],
  [[1,1],[2,1,4,1],[3,1],[]]],
[[[1,1],[3,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[3,1],[]],
  [[1,1],[2,1,4,1,5,1],[3,1],[5,1]]],
[[[1,1],[3,1],[2,1,4,1,6,1]],
  [[1,1],[2,1,4,1,6,1],[3,1],[6,1]],
  [[1,1],[2,1,4,1],[3,1],[]]],
[[[1,1],[3,1],[2,1,4,1,6,1]],
  [[1,1],[2,1,4,1,6,1],[3,1],[6,1]],
  [[1,1],[2,1,4,1,5,1],[3,1],[5,1]]]]],
[64,197,"C2 x C4 x Q8",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1,5,1,6,1],[1,1,3,1,5,1,6,1]],
  [[1,1,3,1,5,1,6,1],[2,1,5,1,6,1],[],[]],
  [[1,1,3,1,5,1,6,1],[2,1,5,1,6,1],[],[]]],
[[[2,1,5,1,6,1],[1,1,3,1,5,1,6,1]],
  [[1,1,3,1,5,1,6,1],[2,1,5,1,6,1],[],[]],
  [[1,1,3,1,5,1,6,1],[2,1,5,1,6,1],[],[5,1]]],
[[[1,1,3,1,6,1],[2,1,5,1,6,1]],
  [[1,1,3,1,6,1],[2,1,5,1,6,1],[5,1],[]],
  [[1,1,3,1,5,1,6,1],[2,1,5,1,6,1],[],[]]],
[[[1,1,3,1,6,1],[2,1,5,1,6,1],[4,1,5,1,6,1]],
  [[1,1,3,1,6,1],[2,1,5,1,6,1],[5,1], 
  [4,1,5,1,6,1]],
  [[1,1,3,1,6,1],[2,1,5,1,6,1],[5,1], 
  [4,1,5,1,6,1]]],
[[[2,1,5,1,6,1],[4,1,5,1,6,1],[1,1,3,1,5,1,6,1]],
  [[1,1,3,1,5,1,6,1],[2,1,5,1,6,1],[], 
  [4,1,5,1,6,1]],
  [[1,1,3,1,6,1],[2,1,5,1,6,1],[5,1], 
  [4,1,5,1,6,1]]],
[[[1,1,3,1,6,1],[2,1,5,1,6,1],[4,1,5,1,6,1]],
  [[1,1,3,1,6,1],[2,1,5,1,6,1],[5,1], 
  [4,1,5,1,6,1]],
  [[1,1,3,1,4,1],[2,1,5,1,6,1],[4,1,5,1,6,1], 
  [4,1,5,1,6,1]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1],[2,1],[3,1],[]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1,5,1],[2,1],[3,1],[5,1]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1,6,1],[2,1],[3,1],[6,1]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1,5,1,6,1],[2,1],[3,1],[5,1,6,1]]]]],
[64,198,"C4 x ((C4 x C2) : C2)",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1]],
  [[],[2,1],[],[]],
  [[],[2,1],[],[]]],
[[[2,1],[3,1]],
  [[3,1],[2,1],[3,1],[]],
  [[3,1],[2,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[3,1],[2,1],[3,1],[]],
  [[3,1,6,1],[2,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[3,1],[2,1],[3,1],[6,1]],
  [[3,1],[2,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[3,1],[2,1],[3,1],[6,1]],
  [[3,1,6,1],[2,1],[3,1],[]]],
[[[2,1,6,1],[4,1,6,1],[1,1,3,1,6,1]],
  [[1,1,3,1,6,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1,3,1,6,1],[2,1,6,1],[],[4,1,6,1]]],
[[[2,1,6,1],[4,1,6,1],[1,1,3,1,5,1,6,1]],
  [[1,1,3,1,5,1,6,1],[2,1,6,1],[5,1],[4,1,6,1]],
  [[1,1,3,1,6,1],[2,1,6,1],[],[4,1,6,1]]],
[[[4,1,6,1],[1,1,3,1,4,1],[2,1,5,1,6,1]],
  [[1,1,3,1,4,1],[2,1,5,1,6,1],[4,1,6,1], 
  [4,1,5,1,6,1]],
  [[1,1,3,1,6,1],[2,1,6,1],[],[4,1,6,1]]]]],
[64,199,"(C4 x D8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1],[4,1,6,1]],
  [[2,1],[2,1],[],[4,1,6,1]],
  [[4,1,6,1],[2,1],[4,1,6,1],[4,1,6,1]]],
[[[2,1],[4,1,6,1]],
  [[],[2,1],[],[4,1,6,1]],
  [[],[2,1],[],[4,1,6,1]]],
[[[2,1],[4,1,6,1]],
  [[2,1],[2,1],[2,1],[4,1,6,1]],
  [[2,1],[2,1],[2,1],[4,1,6,1]]],
[[[2,1],[4,1,6,1]],
  [[2,1],[2,1],[2,1,4,1,6,1],[4,1,6,1]],
  [[4,1,6,1],[2,1],[2,1],[4,1,6,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[6,1]],
  [[1,1],[],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[6,1],[3,1],[]],
  [[1,1],[],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[3,1],[]],
  [[1,1],[3,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[3,1],[6,1]],
  [[1,1],[3,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[3,1,6,1],[3,1],[]],
  [[1,1],[3,1],[3,1],[]]]]],
[64,200,"(C4 x Q8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[64,201,"(C4 x Q8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[3,1],[3,1],[]],
  [[1,1],[3,1,6,1],[3,1],[6,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[6,1],[3,1],[6,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[6,1],[3,1],[]]]]],
[64,202,"C2 x ((C2 x C2 x C2 x C2) : C2)",[[1,1],[2,1],[3,1], 
  [4,1]],[
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[],[],[]]],
[[[2,1],[3,1]],
  [[3,1],[2,1],[3,1],[]],
  [[3,1],[2,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1],[]],
  [[],[2,1],[3,1],[]]],
[[[1,1],[4,1]],
  [[1,1],[],[],[4,1]],
  [[1,1],[],[],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1],[],[4,1]],
  [[1,1],[],[],[4,1]]],
[[[1,1,4,1],[2,1,6,1]],
  [[1,1,4,1],[2,1,6,1],[],[]],
  [[1,1,4,1],[2,1,6,1],[],[]]],
[[[2,1,6,1],[1,1,4,1,5,1]],
  [[1,1,4,1,5,1],[2,1,6,1],[],[5,1]],
  [[1,1,4,1],[2,1,6,1],[],[]]],
[[[1,1,4,1],[2,1,6,1]],
  [[1,1,4,1],[2,1,6,1],[5,1],[]],
  [[1,1,4,1],[2,1,6,1],[],[]]],
[[[1,1,4,1],[2,1,6,1]],
  [[1,1,4,1],[2,1,6,1],[],[]],
  [[1,1,4,1,5,1],[2,1,5,1,6,1],[2,1,6,1],[5,1]]],
[[[2,1],[4,1,5,1],[3,1,5,1,6,1]],
  [[2,1],[2,1],[3,1,5,1,6,1],[4,1,5,1]],
  [[2,1],[2,1],[3,1,5,1,6,1],[4,1,5,1]]],
[[[2,1],[4,1,5,1],[3,1,5,1,6,1]],
  [[2,1],[2,1],[3,1,5,1,6,1],[4,1,5,1]],
  [[2,1,4,1,5,1],[2,1],[3,1,5,1,6,1],[4,1,5,1]]],
[[[2,1],[4,1,5,1],[3,1,5,1,6,1]],
  [[],[2,1],[3,1,5,1,6,1],[4,1,5,1]],
  [[],[2,1],[3,1,5,1,6,1],[4,1,5,1]]],
[[[2,1],[4,1,5,1],[3,1,5,1,6,1]],
  [[4,1,5,1],[2,1],[3,1,5,1,6,1],[4,1,5,1]],
  [[],[2,1],[3,1,5,1,6,1],[4,1,5,1]]],
[[[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[],[4,1]],
  [[1,1],[2,1],[],[4,1]]],
[[[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[],[4,1]],
  [[1,1],[2,1],[2,1,5,1],[4,1]]],
[[[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[],[4,1]],
  [[1,1],[2,1],[4,1],[4,1]]],
[[[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[],[4,1]],
  [[1,1],[2,1],[5,1],[4,1]]],
[[[1,1],[3,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[3,1],[]],
  [[1,1],[2,1,4,1],[3,1],[]]],
[[[1,1],[3,1],[2,1,4,1,5,1]],
  [[1,1],[2,1,4,1,5,1],[3,1],[5,1]],
  [[1,1],[2,1,4,1],[3,1],[]]]]],
[64,203,"C2 x ((C4 x C2 x C2) : C2)",[[1,1],[2,1],[3,1],[4,1] 
 ],[
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[],[],[]]],
[[[1,1],[4,1,5,1,6,1]],
  [[1,1],[],[],[4,1,5,1,6,1]],
  [[1,1],[],[],[4,1,5,1,6,1]]],
[[[1,1],[4,1,5,1,6,1]],
  [[1,1],[],[],[4,1,5,1,6,1]],
  [[1,1],[4,1,5,1,6,1],[4,1,5,1,6,1],[4,1,5,1,6,1] 
 ]],
[[[1,1],[4,1,5,1,6,1]],
  [[1,1],[4,1,5,1,6,1],[],[4,1,5,1,6,1]],
  [[1,1],[4,1,5,1,6,1],[4,1,5,1,6,1],[4,1,5,1,6,1] 
 ]],
[[[1,1],[4,1,5,1,6,1]],
  [[1,1],[],[4,1,5,1,6,1],[4,1,5,1,6,1]],
  [[1,1],[4,1,5,1,6,1],[4,1,5,1,6,1],[4,1,5,1,6,1] 
 ]],
[[[1,1],[2,1,6,1]],
  [[1,1],[2,1,6,1],[],[]],
  [[1,1],[2,1,6,1],[],[]]],
[[[1,1],[2,1,6,1]],
  [[1,1],[2,1,6,1],[],[5,1]],
  [[1,1],[2,1,6,1],[5,1],[5,1]]],
[[[1,1],[2,1,6,1]],
  [[1,1],[2,1,6,1],[],[]],
  [[1,1],[2,1,6,1],[5,1],[5,1]]],
[[[1,1,2,1],[3,1,5,1]],
  [[1,1,2,1],[],[3,1,5,1],[]],
  [[1,1,2,1],[],[3,1,5,1],[]]],
[[[1,1,2,1],[3,1,5,1]],
  [[1,1,2,1],[],[3,1,5,1],[]],
  [[1,1,2,1,6,1],[6,1],[3,1,5,1],[]]],
[[[1,1,2,1],[3,1,5,1]],
  [[1,1,2,1],[],[3,1,5,1],[]],
  [[1,1,2,1,6,1],[6,1],[3,1,5,1],[6,1]]],
[[[3,1],[1,1,2,1],[4,1,5,1]],
  [[1,1,2,1],[],[3,1],[4,1,5,1]],
  [[1,1,2,1],[],[3,1],[4,1,5,1]]],
[[[3,1],[4,1,5,1],[1,1,2,1,6,1]],
  [[1,1,2,1,6,1],[6,1],[3,1],[4,1,5,1]],
  [[1,1,2,1],[],[3,1],[4,1,5,1]]],
[[[3,1],[1,1,2,1],[4,1,5,1]],
  [[1,1,2,1],[],[3,1],[4,1,5,1]],
  [[1,1,2,1,4,1,5,1,6,1],[4,1,5,1,6,1],[3,1], 
  [4,1,5,1]]],
[[[1,1],[4,1],[2,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1]],
  [[1,1],[2,1,6,1],[],[4,1]]],
[[[1,1],[4,1],[2,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1]],
  [[1,1],[2,1,6,1],[4,1,5,1],[4,1]]],
[[[1,1],[4,1],[2,1,6,1]],
  [[1,1],[2,1,6,1],[4,1],[4,1]],
  [[1,1],[2,1,6,1],[4,1,5,1],[4,1]]],
[[[1,1],[3,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[3,1],[]],
  [[1,1],[2,1,4,1],[3,1],[]]],
[[[1,1],[3,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[3,1],[]],
  [[1,1],[2,1,4,1,5,1],[3,1],[5,1]]],
[[[1,1],[3,1],[2,1,4,1,6,1]],
  [[1,1],[2,1,4,1,6,1],[3,1],[6,1]],
  [[1,1],[2,1,4,1],[3,1],[]]],
[[[1,1],[3,1],[2,1,4,1,6,1]],
  [[1,1],[2,1,4,1,6,1],[3,1],[6,1]],
  [[1,1],[2,1,4,1,5,1],[3,1],[5,1]]]]],
[64,204,"C2 x ((C2 x Q8) : C2)",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1,4,1],[2,1,6,1]],
  [[1,1,4,1],[2,1,6,1],[],[]],
  [[1,1,4,1],[2,1,6,1],[],[]]],
[[[1,1,4,1],[2,1,6,1]],
  [[1,1,4,1],[2,1,6,1],[5,1],[]],
  [[1,1,4,1],[2,1,6,1],[],[]]],
[[[2,1,6,1],[1,1,4,1,5,1]],
  [[1,1,4,1,5,1],[2,1,6,1],[],[5,1]],
  [[1,1,4,1],[2,1,6,1],[],[]]],
[[[1,1],[2,1,6,1],[4,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1,6,1]]],
[[[1,1],[2,1,6,1],[4,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1],[2,1,6,1],[5,1],[4,1,6,1]]],
[[[1,1],[2,1,6,1],[4,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1],[2,1,6,1],[4,1,6,1],[4,1,6,1]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1],[2,1],[3,1],[]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1,5,1],[2,1],[3,1],[5,1]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1,6,1],[2,1],[3,1],[6,1]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1,5,1,6,1],[2,1],[3,1],[5,1,6,1]]]]],
[64,205,"C2 x ((C4 x C2 x C2) : C2)",[[1,1],[2,1],[3,1],[4,1] 
 ],[
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[],[],[]]],
[[[1,1],[4,1]],
  [[1,1],[],[],[4,1]],
  [[1,1],[],[],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[],[],[4,1]],
  [[1,1],[],[4,1],[4,1]]],
[[[1,1],[4,1]],
  [[1,1],[4,1],[],[4,1]],
  [[1,1],[],[4,1],[4,1]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1],[2,1],[3,1],[]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1,5,1],[2,1],[3,1],[5,1]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1,6,1],[2,1],[3,1],[6,1]]]]],
[64,206,"(C4 x C2 x C2 x C2) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1,2,1,4,1]],
  [[1,1,2,1,4,1],[],[],[]],
  [[1,1,2,1,4,1],[],[],[]]],
[[[2,1],[3,1]],
  [[3,1],[2,1],[3,1],[]],
  [[3,1],[2,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1],[]],
  [[],[2,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[6,1]],
  [[1,1],[],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[6,1],[3,1],[]],
  [[1,1],[],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[6,1],[3,1],[]],
  [[1,1],[],[3,1],[6,1]]],
[[[1,1],[2,1,6,1],[4,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1,6,1]]],
[[[1,1],[2,1,6,1],[4,1,6,1]],
  [[1,1],[2,1,6,1],[5,1],[4,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1,6,1]]],
[[[1,1],[2,1,6,1],[4,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1],[2,1,5,1,6,1],[2,1,5,1,6,1],[4,1,5,1,6,1] 
 ]]]],
[64,207,"C2 x ((C4 x C4) : C2)",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1,2,1,3,1,4,1]],
  [[1,1,2,1,3,1,4,1],[],[],[]],
  [[1,1,2,1,3,1,4,1],[],[],[]]],
[[[1,1],[4,1,6,1]],
  [[1,1],[],[],[4,1,6,1]],
  [[1,1],[],[],[4,1,6,1]]],
[[[1,1],[4,1,6,1]],
  [[1,1],[],[],[4,1,6,1]],
  [[1,1],[4,1,6,1],[4,1,6,1],[4,1,6,1]]],
[[[1,1],[4,1,6,1]],
  [[1,1],[],[],[4,1,6,1]],
  [[1,1],[],[4,1,6,1],[4,1,6,1]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1],[2,1],[3,1],[]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1,6,1],[2,1],[3,1],[6,1]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1,5,1,6,1],[2,1],[3,1],[5,1,6,1]]]]],
[64,208,"C2 x ((C2 x C2) . (C2 x C2 x C2))",[[1,1],[2,1],[3,1], 
  [4,1]],[
[[[2,1],[1,1,4,1],[3,1,4,1]],
  [[1,1,4,1],[2,1],[3,1,4,1],[]],
  [[1,1,4,1],[2,1],[3,1,4,1],[]]],
[[[2,1],[1,1,4,1],[3,1,4,1]],
  [[1,1,4,1],[2,1],[3,1,4,1],[]],
  [[1,1,4,1,5,1],[2,1],[3,1,4,1,5,1],[5,1]]],
[[[2,1],[1,1,4,1],[3,1,4,1]],
  [[1,1,4,1],[2,1],[3,1,4,1],[]],
  [[1,1,4,1,5,1,6,1],[2,1],[3,1,4,1,5,1,6,1], 
  [5,1,6,1]]]]],
[64,209,"C2 x ((C4 x C4) : C2)",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[],[],[]]],
[[[1,1],[4,1,5,1,6,1]],
  [[1,1],[],[],[4,1,5,1,6,1]],
  [[1,1],[],[],[4,1,5,1,6,1]]],
[[[1,1],[4,1,5,1,6,1]],
  [[1,1],[],[],[4,1,5,1,6,1]],
  [[1,1],[4,1,5,1,6,1],[4,1,5,1,6,1], 
  [4,1,5,1,6,1]]],
[[[2,1],[1,1,4,1],[3,1,4,1]],
  [[1,1,4,1],[2,1],[3,1,4,1],[]],
  [[1,1,4,1],[2,1],[3,1,4,1],[]]],
[[[2,1],[1,1,4,1],[3,1,4,1]],
  [[1,1,4,1],[2,1],[3,1,4,1],[]],
  [[1,1,4,1,5,1,6,1],[2,1],[3,1,4,1,5,1,6,1], 
  [5,1,6,1]]]]],
[64,210,"(C4 x C4 x C2) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[],[],[]]]]],
[64,211,"C2 x ((C4 x C4) : C2)",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1,2,1]],
  [[1,1,2,1],[],[],[]],
  [[1,1,2,1],[],[],[]]],
[[[1,1,3,1],[4,1,5,1]],
  [[1,1,3,1],[],[],[4,1,5,1]],
  [[1,1,3,1],[],[],[4,1,5,1]]],
[[[1,1,3,1],[4,1,5,1]],
  [[1,1,3,1],[],[],[4,1,5,1]],
  [[1,1,3,1],[4,1,5,1],[],[4,1,5,1]]],
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[2,1,3,1],[],[]],
  [[1,1,3,1],[2,1,3,1],[],[]]],
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[2,1,3,1],[],[]],
  [[1,1,3,1,5,1,6,1],[2,1,3,1,5,1,6,1],[5,1,6,1], 
  []]],
[[[2,1,3,1],[1,1,2,1,5,1]],
  [[1,1,2,1,5,1],[],[2,1,3,1],[]],
  [[1,1,2,1,6,1],[5,1,6,1],[2,1,3,1,5,1,6,1], 
  [5,1,6,1]]],
[[[2,1,3,1],[1,1,2,1,5,1]],
  [[1,1,2,1,5,1],[],[2,1,3,1],[]],
  [[1,1,3,1,5,1,6,1],[2,1,3,1,5,1,6,1],[5,1,6,1], 
  []]],
[[[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[],[4,1]],
  [[1,1],[2,1],[],[4,1]]],
[[[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[5,1],[4,1]],
  [[1,1],[2,1],[],[4,1]]],
[[[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[4,1],[4,1]],
  [[1,1],[2,1],[2,1],[4,1]]],
[[[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[4,1],[4,1]],
  [[1,1],[2,1],[],[4,1]]],
[[[1,1,4,1],[2,1,4,1],[3,1,4,1]],
  [[1,1,4,1],[2,1,4,1],[3,1,4,1],[]],
  [[1,1,4,1],[2,1,4,1],[3,1,4,1],[]]],
[[[1,1,4,1,6,1],[2,1,4,1,6,1],[3,1,4,1,6,1]],
  [[1,1,4,1,6,1],[2,1,4,1,6,1],[3,1,4,1,6,1], 
  [6,1]],
  [[1,1,4,1],[2,1,4,1],[3,1,4,1],[]]]]],
[64,212,"C2 x (C4 : Q8)",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[],[]],
  [[1,1],[2,1,4,1],[],[]]],
[[[1,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[],[]],
  [[1,1],[2,1,4,1],[5,1],[]]],
[[[1,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[],[]],
  [[1,1],[2,1,4,1,5,1],[5,1],[5,1]]],
[[[1,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[],[]],
  [[1,1],[2,1,4,1],[2,1,4,1],[]]],
[[[1,1,3,1],[2,1,6,1],[4,1,6,1]],
  [[1,1,3,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1,3,1],[2,1,6,1],[],[4,1,6,1]]],
[[[1,1,3,1],[2,1,6,1],[4,1,6,1]],
  [[1,1,3,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1,3,1,5,1],[2,1,6,1],[5,1],[4,1,6,1]]],
[[[1,1,3,1],[2,1,6,1],[4,1,6,1]],
  [[1,1,3,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1,2,1,3,1,4,1,5,1],[2,1,5,1,6,1],[2,1,4,1], 
  [4,1,5,1,6,1]]],
[[[1,1,3,1],[2,1,6,1],[4,1,6,1]],
  [[1,1,3,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1,3,1,4,1,5,1,6,1],[2,1,6,1],[4,1,5,1,6,1], 
  [4,1,6,1]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1],[2,1],[3,1],[]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1,5,1],[2,1],[3,1],[5,1]]],
[[[2,1],[3,1],[1,1,4,1,6,1]],
  [[1,1,4,1,6,1],[2,1],[3,1],[6,1]],
  [[1,1,4,1,5,1],[2,1],[3,1],[5,1]]]]],
[64,213,"(C4 x C4 x C2) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1,2,1,4,1]],
  [[1,1,2,1,4,1],[],[],[]],
  [[1,1,2,1,4,1],[],[],[]]],
[[[1,1],[3,1,5,1]],
  [[1,1],[],[3,1,5,1],[]],
  [[1,1],[],[3,1,5,1],[]]],
[[[1,1],[3,1,5,1]],
  [[1,1],[],[3,1,5,1],[6,1]],
  [[1,1],[6,1],[3,1,5,1],[6,1]]],
[[[1,1],[3,1,5,1]],
  [[1,1],[],[3,1,5,1],[]],
  [[1,1],[6,1],[3,1,5,1],[6,1]]],
[[[1,1],[3,1,5,1]],
  [[1,1],[],[3,1,5,1],[]],
  [[1,1],[],[3,1,5,1],[6,1]]],
[[[1,1,3,1],[2,1,6,1],[4,1,6,1]],
  [[1,1,3,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1,3,1],[2,1,6,1],[],[4,1,6,1]]],
[[[1,1,3,1],[2,1,6,1],[4,1,6,1]],
  [[1,1,3,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1,3,1,5,1],[2,1,6,1],[5,1],[4,1,6,1]]],
[[[1,1,3,1],[2,1,6,1],[4,1,6,1]],
  [[1,1,3,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1,2,1,3,1,4,1],[2,1,5,1,6,1],[2,1,4,1,5,1], 
  [4,1,5,1,6,1]]]]],
[64,214,"(C4 x Q8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[6,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[6,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[6,1],[3,1],[6,1]]]]],
[64,215,"(C2 x C2 x D8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[3,1],[4,1,5,1,6,1]],
  [[3,1],[],[3,1],[4,1,5,1,6,1]],
  [[3,1],[],[3,1],[4,1,5,1,6,1]]],
[[[3,1],[4,1,5,1,6,1]],
  [[],[4,1,5,1,6,1],[3,1],[4,1,5,1,6,1]],
  [[],[4,1,5,1,6,1],[3,1],[4,1,5,1,6,1]]],
[[[3,1],[4,1,5,1,6,1]],
  [[4,1,5,1,6,1],[4,1,5,1,6,1],[3,1], 
  [4,1,5,1,6,1]],
  [[4,1,5,1,6,1],[4,1,5,1,6,1],[3,1], 
  [4,1,5,1,6,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[],[3,1,4,1],[]],
  [[1,1],[],[3,1,4,1],[]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[],[3,1,4,1],[]],
  [[1,1],[5,1,6,1],[3,1,4,1,5,1,6,1],[5,1,6,1]]],
[[[1,1],[3,1,4,1]],
  [[1,1],[5,1,6,1],[3,1,4,1],[]],
  [[1,1],[5,1,6,1],[3,1,4,1,5,1,6,1],[5,1,6,1]]]]],
[64,216,"(C2 x C2 x D8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[3,1],[4,1,5,1,6,1]],
  [[],[4,1,5,1,6,1],[3,1],[4,1,5,1,6,1]],
  [[],[4,1,5,1,6,1],[3,1],[4,1,5,1,6,1]]],
[[[3,1],[4,1,5,1,6,1]],
  [[3,1],[],[3,1],[4,1,5,1,6,1]],
  [[3,1],[],[3,1],[4,1,5,1,6,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[6,1]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[6,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[6,1],[3,1],[6,1]]]]],
[64,217,"(C2 x C2 x Q8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[64,218,"(C2 x ((C4 x C2) : C2)) : C2",[[1,1],[2,1],[3,1], 
  [4,1]],[
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[6,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[6,1]]]]],
[64,219,"(C4 x D8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[3,1],[4,1,5,1]],
  [[3,1],[],[3,1],[4,1,5,1]],
  [[3,1],[],[3,1],[4,1,5,1]]],
[[[3,1],[4,1,5,1]],
  [[3,1,4,1,5,1],[],[3,1],[4,1,5,1]],
  [[3,1,4,1,5,1],[],[3,1],[4,1,5,1]]]]],
[64,220,"(C4 x D8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[64,221,"(C4 x D8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[64,222,"(C4 x Q8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[64,223,"(C4 x Q8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[64,224,"((C2 x Q8) : C2) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[3,1,4,1],[1,1,2,1,4,1]],
  [[1,1,2,1,4,1],[],[3,1,4,1],[]],
  [[1,1,2,1,4,1],[],[3,1,4,1],[]]],
[[[3,1,4,1],[1,1,2,1,4,1]],
  [[1,1,2,1,4,1],[],[3,1,4,1],[]],
  [[1,1,2,1,4,1,6,1],[],[3,1,4,1,6,1],[6,1]]]]],
[64,225,"(C4 : Q8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[6,1],[3,1],[]],
  [[1,1],[],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[]],
  [[1,1],[],[3,1],[6,1]]]]],
[64,226,"D8 x D8",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1,4,1],[2,1,6,1]],
  [[1,1,2,1,4,1,5,1,6,1],[2,1,6,1],[1,1,4,1], 
  [2,1,6,1]],
  [[1,1,2,1,4,1,5,1,6,1],[2,1,6,1],[1,1,4,1], 
  [2,1,6,1]]],
[[[1,1,4,1],[2,1,6,1]],
  [[1,1,4,1],[2,1,6,1],[1,1,4,1],[]],
  [[1,1,4,1],[2,1,6,1],[1,1,4,1],[]]],
[[[1,1,4,1],[2,1,6,1]],
  [[1,1,4,1],[2,1,6,1],[],[]],
  [[1,1,4,1],[2,1,6,1],[],[]]],
[[[3,1,4,1],[1,1,2,1,4,1]],
  [[3,1,4,1,5,1,6,1],[1,1,2,1,4,1],[],[3,1,4,1]],
  [[1,1,2,1,4,1],[],[3,1,4,1],[]]],
[[[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[1,1,4,1],[4,1]],
  [[1,1],[2,1],[1,1,4,1],[4,1]]],
[[[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[1,1,4,1],[4,1]],
  [[1,1],[2,1],[1,1,4,1,5,1],[4,1]]],
[[[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[],[4,1]],
  [[1,1],[2,1],[],[4,1]]],
[[[1,1],[2,1],[4,1]],
  [[1,1],[2,1],[5,1],[4,1]],
  [[1,1],[2,1],[],[4,1]]]]],
[64,227,"(C2 x C2 x D8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[3,1,5,1],[4,1,6,1]],
  [[3,1,4,1,5,1,6,1],[],[3,1,5,1],[4,1,6,1]],
  [[3,1,4,1,5,1,6,1],[],[3,1,5,1],[4,1,6,1]]],
[[[3,1,5,1],[4,1,6,1]],
  [[4,1,6,1],[4,1,6,1],[3,1,5,1],[4,1,6,1]],
  [[4,1,6,1],[4,1,6,1],[3,1,5,1],[4,1,6,1]]],
[[[3,1,5,1],[4,1,6,1]],
  [[4,1,6,1],[],[3,1,5,1],[4,1,6,1]],
  [[4,1,6,1],[],[3,1,5,1],[4,1,6,1]]],
[[[3,1,5,1],[4,1,6,1]],
  [[3,1,4,1,5,1,6,1],[4,1,6,1],[3,1,5,1], 
  [4,1,6,1]],
  [[3,1,4,1,5,1,6,1],[4,1,6,1],[3,1,5,1], 
  [4,1,6,1]]],
[[[1,1],[2,1,6,1],[4,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1,6,1]]],
[[[1,1],[2,1,6,1],[4,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1],[2,1,6,1],[5,1],[4,1,6,1]]]]],
[64,228,"(C4 x D8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[3,1],[4,1],[2,1,6,1]],
  [[3,1,4,1],[2,1,6,1],[3,1],[4,1]],
  [[3,1,4,1],[2,1,6,1],[3,1],[4,1]]],
[[[3,1],[4,1],[2,1,6,1]],
  [[3,1,4,1],[2,1,6,1],[3,1],[4,1]],
  [[3,1,4,1,5,1],[2,1,6,1],[3,1],[4,1]]]]],
[64,229,"(C2 x C2 x Q8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1],[2,1,6,1],[4,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1,6,1]]],
[[[1,1],[2,1,6,1],[4,1,6,1]],
  [[1,1],[2,1,6,1],[],[4,1,6,1]],
  [[1,1],[2,1,6,1],[5,1],[4,1,6,1]]]]],
[64,230,"Q8 x D8",[[1,1],[2,1],[3,1],[4,1]],[
[[[3,1],[4,1],[2,1,6,1]],
  [[4,1],[2,1,6,1],[3,1],[4,1]],
  [[4,1],[2,1,6,1],[3,1],[4,1]]],
[[[3,1],[4,1],[2,1,6,1]],
  [[4,1],[2,1,6,1],[3,1],[4,1]],
  [[4,1,5,1],[2,1,6,1],[3,1],[4,1]]],
[[[3,1],[4,1],[2,1,6,1]],
  [[3,1,4,1],[2,1,6,1],[3,1],[4,1]],
  [[3,1,4,1],[2,1,6,1],[3,1],[4,1]]],
[[[3,1],[4,1],[2,1,6,1]],
  [[3,1,4,1,5,1],[2,1,6,1],[3,1],[4,1]],
  [[3,1,4,1],[2,1,6,1],[3,1],[4,1]]]]],
[64,231,"(C4 x D8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[3,1],[4,1],[2,1,6,1]],
  [[3,1,4,1],[2,1,6,1],[3,1],[4,1]],
  [[3,1,4,1],[2,1,6,1],[3,1],[4,1]]],
[[[3,1],[4,1],[2,1,6,1]],
  [[3,1,4,1],[2,1,6,1],[3,1],[4,1]],
  [[3,1,4,1,5,1],[2,1,6,1],[3,1],[4,1]]]]],
[64,232,"(C4 x D8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[3,1,5,1],[4,1,6,1]],
  [[4,1,6,1],[],[3,1,5,1],[4,1,6,1]],
  [[4,1,6,1],[],[3,1,5,1],[4,1,6,1]]],
[[[3,1,5,1],[4,1,6,1]],
  [[4,1,6,1],[4,1,6,1],[3,1,5,1],[4,1,6,1]],
  [[4,1,6,1],[4,1,6,1],[3,1,5,1],[4,1,6,1]]],
[[[3,1,5,1],[4,1,6,1]],
  [[3,1,4,1,5,1,6,1],[4,1,6,1],[3,1,5,1], 
  [4,1,6,1]],
  [[3,1,4,1,5,1,6,1],[4,1,6,1],[3,1,5,1], 
  [4,1,6,1]]]]],
[64,233,"(C4 x Q8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[64,234,"(C4 x D8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[64,235,"(C4 x Q8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[64,236,"(C4 x D8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[64,237,"(C4 x Q8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[64,238,"Q8 : Q8",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[64,239,"Q8 x Q8",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1,3,1],[1,1,2,1,5,1]],
  [[1,1,2,1,5,1],[],[2,1,3,1],[]],
  [[1,1,3,1],[2,1,3,1],[],[1,1,3,1]]]]],
[64,240,"(C4 x D8) : C2",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[64,241,"((C4 x C2 x C2) : C2) : C2",[[1,1],[2,1],[3,1],[4,1] 
 ],[
[[[3,1],[4,1,5,1,6,1]],
  [[3,1],[3,1],[3,1],[4,1,5,1,6,1]],
  [[3,1],[3,1],[3,1],[4,1,5,1,6,1]]],
[[[3,1],[4,1,5,1,6,1]],
  [[4,1,5,1,6,1],[],[3,1],[4,1,5,1,6,1]],
  [[4,1,5,1,6,1],[],[3,1],[4,1,5,1,6,1]]]]],
[64,242,"((C4 x C4) : C2) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1,3,1,4,1],[2,1,4,1,5,1]],
  [[2,1,4,1,5,1],[],[1,1,3,1,4,1],[2,1,4,1,5,1]],
  [[2,1,4,1,5,1],[],[1,1,3,1,4,1],[2,1,4,1,5,1]]],
[[[1,1,3,1,4,1],[2,1,4,1,5,1]],
  [[1,1,3,1,4,1],[2,1,4,1,5,1],[],[]],
  [[1,1,3,1,4,1],[2,1,4,1,5,1],[],[]]]]],
[64,243,"((C2 x C2) . (C2 x C2 x C2)) : C2",[[1,1],[2,1],[3,1], 
  [4,1]],[
 ]],
[64,244,"((C4 x C4) : C2) : C2",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[64,245,"(C2 x C2) . (C2 x C2 x C2 x C2)",[[1,1],[2,1],[3,1], 
  [4,1]],[
 ]],
[64,246,"C8 x C2 x C2 x C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1]],
  [[],[2,1],[],[]],
  [[],[2,1],[],[]]],
[[[2,1]],
  [[],[2,1],[],[]],
  [[],[2,1],[2,1],[]]],
[[[2,1]],
  [[],[2,1],[],[]],
  [[2,1],[2,1],[],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1],[]],
  [[],[2,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1],[]],
  [[],[2,1],[3,1],[3,1]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1],[]],
  [[2,1],[2,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1],[]],
  [[2,1],[2,1],[3,1],[3,1]]],
[[[2,1],[3,1],[4,1]],
  [[],[2,1],[3,1],[4,1]],
  [[],[2,1],[3,1],[4,1]]],
[[[2,1],[3,1],[4,1]],
  [[],[2,1],[3,1],[4,1]],
  [[2,1],[2,1],[3,1],[4,1]]],
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[],[],[]]],
[[[1,1]],
  [[1,1],[],[],[]],
  [[1,1],[6,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[2,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[6,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[2,1],[6,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[6,1],[6,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[3,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[]],
  [[1,1],[2,1],[3,1],[6,1]]]]],
[64,247,"C2 x C2 x (C8 : C2)",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1,4,1]],
  [[],[2,1,4,1],[],[]],
  [[],[2,1,4,1],[],[]]],
[[[2,1],[4,1,6,1]],
  [[],[2,1],[],[4,1,6,1]],
  [[],[2,1],[],[4,1,6,1]]],
[[[2,1],[4,1,6,1]],
  [[],[2,1],[4,1,6,1],[4,1,6,1]],
  [[4,1,6,1],[2,1],[],[4,1,6,1]]],
[[[2,1],[4,1,6,1]],
  [[],[2,1],[],[4,1,6,1]],
  [[4,1,6,1],[2,1],[],[4,1,6,1]]],
[[[2,1],[3,1,6,1],[4,1,6,1]],
  [[],[2,1],[3,1,6,1],[4,1,6,1]],
  [[],[2,1],[3,1,6,1],[4,1,6,1]]],
[[[2,1],[3,1,6,1],[4,1,6,1]],
  [[],[2,1],[3,1,6,1],[4,1,6,1]],
  [[4,1,6,1],[2,1],[3,1,6,1],[4,1,6,1]]],
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[2,1,3,1],[],[]],
  [[1,1,3,1],[2,1,3,1],[],[]]],
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[2,1,3,1],[],[6,1]],
  [[1,1,3,1],[2,1,3,1],[],[]]],
[[[1,1],[2,1,3,1],[3,1,4,1]],
  [[1,1],[2,1,3,1],[],[3,1,4,1]],
  [[1,1],[2,1,3,1],[],[3,1,4,1]]],
[[[1,1],[2,1,3,1,6,1],[3,1,4,1,6,1]],
  [[1,1],[2,1,3,1,6,1],[6,1],[3,1,4,1,6,1]],
  [[1,1],[2,1,3,1],[],[3,1,4,1]]],
[[[1,1],[2,1,4,1],[3,1,4,1]],
  [[1,1],[2,1,4,1],[3,1,4,1],[]],
  [[1,1],[2,1,3,1],[],[3,1,4,1]]]]],
[64,248,"C2 x ((C8 x C2) : C2)",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1]],
  [[],[2,1],[],[]],
  [[],[2,1],[],[]]],
[[[4,1],[2,1,3,1,5,1]],
  [[],[],[2,1,3,1,5,1],[4,1]],
  [[],[],[2,1,3,1,5,1],[4,1]]],
[[[4,1],[2,1,3,1,5,1]],
  [[4,1],[],[2,1,3,1,5,1],[4,1]],
  [[],[4,1],[2,1,3,1,4,1,5,1],[4,1]]],
[[[4,1],[2,1,3,1,5,1]],
  [[4,1],[],[2,1,3,1,5,1],[4,1]],
  [[4,1],[4,1],[2,1,3,1,4,1,5,1],[4,1]]],
[[[4,1],[2,1,3,1,5,1]],
  [[4,1],[],[2,1,3,1,5,1],[4,1]],
  [[],[],[2,1,3,1,5,1],[4,1]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1],[2,1],[3,1],[]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1,6,1],[2,1],[3,1],[6,1]]]]],
[64,249,"(C2 x (C8 : C2)) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[3,1],[4,1]],
  [[],[],[3,1],[4,1]],
  [[],[],[3,1],[4,1]]],
[[[3,1],[4,1]],
  [[3,1],[],[3,1],[4,1]],
  [[],[4,1],[3,1],[4,1]]]]],
[64,250,"C2 x C2 x D16",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1,3,1,4,1]],
  [[2,1,3,1,4,1],[2,1,3,1,4,1],[],[]],
  [[2,1,3,1,4,1],[2,1,3,1,4,1],[],[]]],
[[[4,1],[2,1,3,1]],
  [[2,1,3,1],[2,1,3,1],[],[4,1]],
  [[2,1,3,1],[2,1,3,1],[],[4,1]]],
[[[4,1],[2,1,3,1]],
  [[2,1,3,1],[2,1,3,1],[],[4,1]],
  [[2,1,3,1],[2,1,3,1,4,1],[4,1],[4,1]]],
[[[4,1],[2,1,3,1]],
  [[2,1,3,1],[2,1,3,1],[],[4,1]],
  [[2,1,3,1,4,1],[2,1,3,1],[],[4,1]]],
[[[2,1],[3,1],[4,1]],
  [[2,1],[2,1],[3,1],[4,1]],
  [[2,1],[2,1],[3,1],[4,1]]],
[[[2,1],[3,1],[4,1]],
  [[2,1],[2,1],[3,1],[4,1]],
  [[2,1,3,1,4,1],[2,1],[3,1],[4,1]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[]],
  [[1,1],[2,1],[6,1],[]]],
[[[1,1],[3,1],[2,1,4,1]],
  [[1,1],[2,1,4,1],[3,1],[]],
  [[1,1],[2,1,4,1],[3,1],[]]],
[[[1,1],[3,1],[2,1,3,1,4,1]],
  [[1,1],[2,1,3,1,4,1],[3,1],[3,1]],
  [[1,1],[2,1,4,1],[3,1],[]]],
[[[1,1],[3,1],[2,1,4,1,6,1]],
  [[1,1],[2,1,4,1,6,1],[3,1],[6,1]],
  [[1,1],[2,1,4,1],[3,1],[]]]]],
[64,251,"C2 x C2 x QD16",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1]],
  [[2,1],[2,1],[],[]],
  [[2,1],[2,1],[],[]]],
[[[2,1],[4,1]],
  [[2,1],[2,1],[],[4,1]],
  [[2,1],[2,1],[],[4,1]]],
[[[2,1],[4,1]],
  [[2,1],[2,1],[],[4,1]],
  [[2,1,4,1],[2,1],[4,1],[4,1]]],
[[[2,1],[4,1]],
  [[2,1],[2,1],[],[4,1]],
  [[2,1,4,1],[2,1],[],[4,1]]],
[[[2,1],[3,1],[4,1]],
  [[2,1],[2,1],[3,1],[4,1]],
  [[2,1],[2,1],[3,1],[4,1]]],
[[[2,1],[3,1],[4,1]],
  [[2,1],[2,1],[3,1],[4,1]],
  [[2,1,3,1],[2,1],[3,1],[4,1]]],
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[2,1,3,1],[],[]],
  [[1,1,3,1],[2,1,3,1],[],[]]],
[[[1,1,3,1],[2,1,3,1]],
  [[1,1,3,1],[2,1,3,1],[],[]],
  [[1,1,3,1,6,1],[2,1,3,1,6,1],[6,1],[6,1]]],
[[[1,1],[2,1,3,1],[3,1,4,1]],
  [[1,1],[2,1,3,1],[],[3,1,4,1]],
  [[1,1],[2,1,3,1],[],[3,1,4,1]]],
[[[1,1],[2,1,3,1],[3,1,4,1]],
  [[1,1],[2,1,3,1],[],[3,1,4,1]],
  [[1,1],[2,1,3,1,6,1],[6,1],[3,1,4,1,6,1]]],
[[[1,1],[2,1,4,1],[3,1,4,1]],
  [[1,1],[2,1,4,1],[3,1,4,1],[]],
  [[1,1],[2,1,3,1,6,1],[6,1],[3,1,4,1,6,1]]]]],
[64,252,"C2 x C2 x Q16",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1,4,1],[2,1,4,1]],
  [[1,1,4,1],[2,1,4,1],[],[]],
  [[1,1,4,1],[2,1,4,1],[],[]]],
[[[1,1,4,1],[2,1,4,1]],
  [[1,1,4,1],[2,1,4,1],[],[]],
  [[1,1,4,1,6,1],[2,1,4,1,6,1],[],[6,1]]],
[[[2,1],[4,1],[1,1,3,1]],
  [[1,1,3,1],[2,1],[],[4,1]],
  [[1,1,3,1],[2,1],[],[4,1]]],
[[[2,1],[4,1],[1,1,3,1,4,1]],
  [[1,1,3,1,4,1],[2,1],[4,1],[4,1]],
  [[1,1,3,1],[2,1],[],[4,1]]],
[[[2,1],[4,1],[1,1,3,1,6,1]],
  [[1,1,3,1,6,1],[2,1],[6,1],[4,1]],
  [[1,1,3,1],[2,1],[],[4,1]]]]],
[64,253,"C2 x ((C8 x C2) : C2)",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1,4,1]],
  [[1,1,4,1],[1,1,4,1],[],[]],
  [[1,1,4,1],[1,1,4,1],[],[]]],
[[[2,1],[4,1,6,1]],
  [[2,1],[2,1],[],[4,1,6,1]],
  [[2,1],[2,1],[],[4,1,6,1]]],
[[[2,1],[4,1,6,1]],
  [[2,1],[2,1],[],[4,1,6,1]],
  [[2,1],[2,1],[4,1,6,1],[4,1,6,1]]],
[[[2,1],[4,1,6,1]],
  [[2,1],[2,1],[],[4,1,6,1]],
  [[2,1,4,1,6,1],[2,1],[],[4,1,6,1]]],
[[[2,1],[4,1,6,1]],
  [[2,1],[2,1],[],[4,1,6,1]],
  [[2,1,4,1,6,1],[2,1],[4,1,6,1],[4,1,6,1]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1],[2,1],[3,1],[]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1,6,1],[2,1],[3,1],[6,1]]]]],
[64,254,"C2 x ((C2 x D8) : C2)",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1],[3,1,4,1]],
  [[2,1],[2,1],[3,1,4,1],[]],
  [[2,1],[2,1],[3,1,4,1],[]]],
[[[2,1],[4,1],[3,1,6,1]],
  [[2,1],[2,1],[3,1,6,1],[4,1]],
  [[2,1],[2,1],[3,1,6,1],[4,1]]],
[[[2,1],[4,1],[3,1,6,1]],
  [[2,1,4,1],[2,1],[3,1,6,1],[4,1]],
  [[2,1],[2,1],[3,1,6,1],[4,1]]],
[[[1,1],[2,1,4,1],[3,1,4,1]],
  [[1,1],[2,1,4,1],[3,1,4,1],[]],
  [[1,1],[2,1,4,1],[3,1,4,1],[]]],
[[[1,1],[2,1,4,1],[3,1,4,1]],
  [[1,1],[2,1,4,1],[3,1,4,1],[]],
  [[1,1],[2,1,4,1,6,1],[3,1,4,1,6,1],[6,1]]]]],
[64,255,"C2 x ((C2 x Q8) : C2)",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1],[2,1],[3,1],[]]],
[[[2,1],[3,1],[1,1,4,1]],
  [[1,1,4,1],[2,1],[3,1],[]],
  [[1,1,4,1,6,1],[2,1],[3,1],[6,1]]]]],
[64,256,"(C2 x (C8 : C2)) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[1,1],[3,1,4,1,5,1,6,1]],
  [[1,1],[1,1],[3,1,4,1,5,1,6,1],[]],
  [[1,1],[1,1],[3,1,4,1,5,1,6,1],[]]]]],
[64,257,"(C2 x D16) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1],[4,1]],
  [[2,1],[2,1],[],[4,1]],
  [[2,1],[2,1],[],[4,1]]]]],
[64,258,"(C2 x QD16) : C2",[[1,1],[2,1],[3,1],[4,1]],[
[[[2,1],[4,1]],
  [[2,1],[2,1],[],[4,1]],
  [[2,1],[2,1],[],[4,1]]]]],
[64,259,"(C2 x Q16) : C2",[[1,1],[2,1],[3,1],[4,1]],[
 ]],
[64,260,"C4 x C2 x C2 x C2 x C2",[[1,1],[2,1],[3,1],[4,1], 
  [5,1]],[                        ###  done by hand  
[[[2,1]],
  [[],[2,1],[],[],[]],
  [[],[2,1],[],[],[]]],
[[[2,1]],
  [[],[2,1],[],[],[]],
  [[],[2,1],[2,1],[],[]]],
[[[2,1]],
  [[],[2,1],[],[],[]],
  [[2,1],[2,1],[],[],[]]],
[[[1,1]],
  [[1,1],[],[],[],[]],
  [[1,1],[],[],[],[]]],
[[[1,1]],
  [[1,1],[],[],[],[]],
  [[1,1],[6,1],[],[],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1],[],[]],
  [[],[2,1],[3,1],[],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1],[],[]],
  [[2,1],[2,1],[3,1],[],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1],[],[]],
  [[],[2,1],[3,1],[3,1],[]]],
[[[2,1],[3,1]],
  [[],[2,1],[3,1],[],[]],
  [[2,1],[2,1],[3,1],[3,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[],[]],
  [[1,1],[2,1],[],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[],[]],
  [[1,1],[2,1],[2,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[],[]],
  [[1,1],[2,1],[6,1],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[],[]],
  [[1,1],[2,1],[2,1],[6,1],[]]],
[[[2,1],[3,1],[4,1]],
  [[],[2,1],[3,1],[4,1],[]],
  [[],[2,1],[3,1],[4,1],[]]],
[[[2,1],[3,1],[4,1]],
  [[],[2,1],[3,1],[4,1],[]],
  [[2,1],[2,1],[3,1],[4,1],[]]],
[[[2,1],[3,1],[4,1]],
  [[],[2,1],[3,1],[4,1],[]],
  [[],[2,1],[3,1],[4,1],[4,1]]],
[[[2,1],[3,1],[4,1]],
  [[],[2,1],[3,1],[4,1],[]],
  [[2,1],[2,1],[3,1],[4,1],[4,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[]],
  [[1,1],[2,1],[3,1],[],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[]],
  [[1,1],[2,1],[3,1],[3,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[]],
  [[1,1],[2,1],[3,1],[6,1],[]]], 
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[]],
  [[1,1],[2,1],[3,1],[3,1],[6,1]]], 
[[[2,1],[3,1],[4,1],[5,1]],
  [[],[2,1],[3,1],[4,1],[5,1]],
  [[],[2,1],[3,1],[4,1],[5,1]]],
[[[2,1],[3,1],[4,1],[5,1]],
  [[],[2,1],[3,1],[4,1],[5,1]],
  [[2,1],[2,1],[3,1],[4,1],[5,1]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[1,1],[2,1],[3,1],[4,1],[]],
  [[1,1],[2,1],[3,1],[4,1],[]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[1,1],[2,1],[3,1],[4,1],[]],
  [[1,1],[2,1],[3,1],[4,1],[4,1]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[1,1],[2,1],[3,1],[4,1],[]],
  [[1,1],[2,1],[3,1],[4,1],[6,1]]]]],
[64,261,"C2 x C2 x C2 x D8",          ## done by hand 
  [[1,1],[2,1],[3,1],[4,1],[5,1]],[
[[[1,1]],
  [[1,1],[],[],[],[]],
  [[1,1],[],[],[],[]]],
[[[1,1]],
  [[1,1],[1,1],[],[],[]],
  [[1,1],[1,1],[],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[],[]],
  [[1,1],[],[3,1],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[],[]],
  [[1,1],[3,1],[3,1],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[],[3,1],[],[]],
  [[1,1],[],[3,1],[3,1],[]]],
[[[1,1],[3,1]],
  [[1,1],[1,1],[3,1],[],[]],
  [[1,1],[1,1],[3,1],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[1,1],[3,1],[],[]],
  [[1,1],[1,1,3,1],[3,1],[],[]]],
[[[1,1],[3,1]],
  [[1,1],[1,1],[3,1],[],[]],
  [[1,1],[1,1],[3,1],[3,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[],[]],
  [[1,1],[2,1],[],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[],[]],
  [[1,1],[2,1],[6,1],[],[]]],
[[[1,1],[3,1],[4,1]],
  [[1,1],[],[3,1],[4,1],[]],
  [[1,1],[],[3,1],[4,1],[]]],
[[[1,1],[3,1],[4,1]],
  [[1,1],[],[3,1],[4,1],[]],
  [[1,1],[3,1],[3,1],[4,1],[]]],
[[[1,1],[3,1],[4,1]],
  [[1,1],[],[3,1],[4,1],[]],
  [[1,1],[],[3,1],[4,1],[3,1]]],
[[[1,1],[3,1],[4,1]],
  [[1,1],[],[3,1],[4,1],[]],
  [[1,1],[3,1],[3,1],[4,1],[4,1]]],
[[[1,1],[3,1],[4,1]],
  [[1,1],[1,1],[3,1],[4,1],[]],
  [[1,1],[1,1],[3,1],[4,1],[]]],
[[[1,1],[3,1],[4,1]],
  [[1,1],[1,1],[3,1],[4,1],[]],
  [[1,1],[1,1,3,1],[3,1],[4,1],[]]],
[[[1,1],[3,1],[4,1]],
  [[1,1],[1,1],[3,1],[4,1],[]],
  [[1,1],[1,1],[3,1],[4,1],[3,1]]],
[[[1,1],[3,1],[4,1]],
  [[1,1],[1,1],[3,1],[4,1],[]],
  [[1,1],[1,1,3,1],[3,1],[4,1],[4,1]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[]],
  [[1,1],[2,1],[3,1],[],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[]],
  [[1,1],[2,1],[3,1],[3,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[]],
  [[1,1],[2,1],[3,1],[6,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[]],
  [[1,1],[2,1],[3,1],[3,1],[6,1]]],
[[[1,1],[3,1],[4,1],[5,1]],
  [[1,1],[],[3,1],[4,1],[5,1]],
  [[1,1],[],[3,1],[4,1],[5,1]]],
[[[1,1],[3,1],[4,1],[5,1]],
  [[1,1],[],[3,1],[4,1],[5,1]],
  [[1,1],[3,1],[3,1],[4,1],[5,1]]],
[[[1,1],[3,1],[4,1],[5,1]],
  [[1,1],[1,1],[3,1],[4,1],[5,1]],
  [[1,1],[1,1],[3,1],[4,1],[5,1]]],
[[[1,1],[3,1],[4,1],[5,1]],
  [[1,1],[1,1],[3,1],[4,1],[5,1]],
  [[1,1],[1,1,3,1],[3,1],[4,1],[5,1]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[1,1],[2,1],[3,1],[4,1],[]],
  [[1,1],[2,1],[3,1],[4,1],[]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[1,1],[2,1],[3,1],[4,1],[]],
  [[1,1],[2,1],[3,1],[4,1],[3,1]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[1,1],[2,1],[3,1],[4,1],[]],
  [[1,1],[2,1],[3,1],[4,1],[6,1]]]]],
[64,262,"C2 x C2 x C2 x Q8",          ### done partly by by hand 
  [[1,1],[2,1],[3,1],[4,1],[5,1]],[ 
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[],[]],
  [[1,1],[2,1],[],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[],[]],
  [[1,1],[2,1],[6,1],[],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[]],
  [[1,1],[2,1],[3,1],[],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[]],
  [[1,1],[2,1],[3,1],[3,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[]],
  [[1,1],[2,1],[3,1],[6,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[]],
  [[1,1],[2,1],[3,1],[3,1],[6,1]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[1,1],[2,1],[3,1],[4,1],[]],
  [[1,1],[2,1],[3,1],[4,1],[]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[1,1],[2,1],[3,1],[4,1],[]],
  [[1,1],[2,1],[3,1],[4,1],[4,1]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[1,1],[2,1],[3,1],[4,1],[]],
  [[1,1],[2,1],[3,1],[4,1],[6,1]]]]],
[64,263,"C2 x C2 x ((C4 x C2) : C2)",[[1,1],[2,1],[3,1], 
  [4,1],[5,1]],[
[[[1,1]],
  [[1,1],[],[],[],[]],
  [[1,1],[],[],[],[]]],
[[[1,1,5,1],[4,1,5,1,6,1]],
  [[1,1,5,1],[],[],[4,1,5,1,6,1],[]],
  [[1,1,5,1],[],[],[4,1,5,1,6,1],[]]],
[[[1,1,4,1,6,1],[4,1,5,1,6,1]],
  [[1,1,4,1,6,1],[],[],[],[4,1,5,1,6,1]],
  [[1,1,5,1],[],[],[4,1,5,1,6,1],[]]],
[[[1,1,5,1],[4,1,5,1,6,1]],
  [[1,1,5,1],[],[4,1,5,1,6,1],[4,1,5,1,6,1],[]],
  [[1,1,5,1],[],[],[4,1,5,1,6,1],[]]],
[[[1,1,5,1],[4,1,5,1,6,1]],
  [[1,1,5,1],[1,1,5,1],[],[4,1,5,1,6,1],[]],
  [[1,1,5,1],[1,1,4,1,6,1],[],[4,1,5,1,6,1],[]]],
[[[1,1,5,1],[4,1,5,1,6,1]],
  [[1,1,5,1],[1,1,5,1],[],[4,1,5,1,6,1],[]],
  [[1,1,5,1],[1,1,5,1],[4,1,5,1,6,1], 
  [4,1,5,1,6,1],[]]],
[[[1,1],[4,1],[5,1]],
  [[1,1],[],[],[4,1],[5,1]],
  [[1,1],[],[],[4,1],[5,1]]],
[[[1,1],[4,1],[5,1]],
  [[1,1],[],[],[4,1],[5,1]],
  [[1,1],[],[5,1],[4,1],[5,1]]],
[[[1,1],[4,1],[5,1]],
  [[1,1],[],[4,1],[4,1],[5,1]],
  [[1,1],[5,1],[],[4,1],[5,1]]],
[[[1,1],[4,1],[5,1]],
  [[1,1],[],[5,1],[4,1],[5,1]],
  [[1,1],[5,1],[],[4,1],[5,1]]],
[[[1,1],[4,1],[5,1]],
  [[1,1],[],[],[4,1],[5,1]],
  [[1,1],[5,1],[],[4,1],[5,1]]],
[[[1,1],[2,1],[3,1,5,1]],
  [[1,1],[2,1],[3,1,5,1],[],[]],
  [[1,1],[2,1],[3,1,5,1],[],[]]],
[[[1,1],[2,1],[3,1,5,1]],
  [[1,1],[2,1],[3,1,5,1],[],[]],
  [[1,1],[2,1],[3,1,5,1],[6,1],[]]],
[[[1,1],[2,1],[5,1],[3,1,4,1]],
  [[1,1],[2,1],[3,1,4,1],[],[5,1]],
  [[1,1],[2,1],[3,1,4,1],[],[5,1]]],
[[[1,1],[2,1],[5,1],[3,1,4,1]],
  [[1,1],[2,1],[3,1,4,1],[],[5,1]],
  [[1,1],[2,1],[3,1,4,1,5,1,6,1],[5,1,6,1],[5,1] 
 ]],
[[[1,1],[2,1],[5,1],[3,1,4,1,5,1]],
  [[1,1],[2,1],[3,1,4,1,5,1],[5,1],[5,1]],
  [[1,1],[2,1],[3,1,4,1,5,1,6,1],[5,1,6,1],[5,1] 
 ]]]],
[64,264,"C2 x ((C2 x D8) : C2)",
  [[1,1],[2,1],[3,1],[4,1],[5,1]],[
[[[2,1],[4,1,5,1]],
  [[2,1],[2,1],[2,1],[4,1,5,1],[]],
  [[2,1],[2,1],[2,1],[4,1,5,1],[]]],
[[[2,1],[4,1,5,1]],
  [[],[2,1],[],[4,1,5,1],[]],
  [[],[2,1],[],[4,1,5,1],[]]],
[[[2,1],[4,1,5,1]],
  [[2,1,4,1,5,1],[2,1],[],[4,1,5,1],[]],
  [[],[2,1],[4,1,5,1],[4,1,5,1],[]]],
[[[2,1],[4,1,5,1]],
  [[2,1],[2,1],[2,1,4,1,5,1],[4,1,5,1],[]],
  [[4,1,5,1],[2,1],[2,1],[4,1,5,1],[]]],
[[[3,1],[4,1],[5,1]],
  [[],[],[3,1],[4,1],[5,1]],
  [[3,1,5,1],[4,1],[3,1],[4,1],[5,1]]],
[[[3,1],[4,1],[5,1]],
  [[],[3,1,4,1],[3,1],[4,1],[5,1]],
  [[],[3,1,4,1],[3,1],[4,1],[5,1]]],
[[[3,1],[4,1],[5,1]],
  [[4,1],[4,1],[3,1],[4,1],[5,1]],
  [[4,1,5,1],[4,1],[3,1],[4,1],[5,1]]],
[[[3,1],[4,1],[5,1]],
  [[3,1,4,1],[],[3,1],[4,1],[5,1]],
  [[3,1,4,1,5,1],[5,1],[3,1],[4,1],[5,1]]],
[[[3,1],[4,1],[5,1]],
  [[],[4,1],[3,1],[4,1],[5,1]],
  [[],[4,1],[3,1],[4,1],[5,1]]],
[[[3,1],[4,1],[5,1]],
  [[3,1],[],[3,1],[4,1],[5,1]],
  [[3,1,5,1],[5,1],[3,1],[4,1],[5,1]]],
[[[3,1],[4,1],[5,1]],
  [[4,1],[3,1],[3,1],[4,1],[5,1]],
  [[3,1,4,1,5,1],[3,1,4,1],[3,1],[4,1],[5,1]]],
[[[2,1],[1,1,5,1],[3,1,5,1],[4,1,5,1]],
  [[1,1,5,1],[2,1],[3,1,5,1],[4,1,5,1],[]],
  [[1,1,5,1],[2,1],[3,1,5,1],[4,1,5,1],[]]],
[[[2,1],[1,1,5,1,6,1],[3,1,5,1,6,1], 
  [4,1,5,1,6,1]],
  [[1,1,5,1,6,1],[2,1],[3,1,5,1,6,1], 
  [4,1,5,1,6,1],[6,1]],
  [[1,1,5,1],[2,1],[3,1,5,1],[4,1,5,1],[]]]]],
[64,265,"C2 x ((C2 x Q8) : C2)",[[1,1],[2,1],[3,1],[4,1], 
  [5,1]],[
[[[2,1],[1,1,5,1],[3,1,5,1],[4,1,5,1]],
  [[1,1,5,1],[2,1],[3,1,5,1],[4,1,5,1],[]],
  [[1,1,5,1],[2,1],[3,1,5,1],[4,1,5,1],[]]],
[[[2,1],[1,1,5,1,6,1],[3,1,5,1,6,1], 
  [4,1,5,1,6,1]],
  [[1,1,5,1,6,1],[2,1],[3,1,5,1,6,1], 
  [4,1,5,1,6,1],[6,1]],
  [[1,1,5,1],[2,1],[3,1,5,1],[4,1,5,1],[]]]]],
[64,266,"(C2 x ((C4 x C2) : C2)) : C2",[[1,1],[2,1],[3,1], 
  [4,1],[5,1]],[
[[[3,1],[1,1,4,1,5,1]],
  [[1,1,4,1,5,1],[],[3,1],[],[]],
  [[1,1,4,1,5,1],[],[3,1],[],[]]],
[[[3,1],[1,1,4,1,5,1]],
  [[],[],[3,1],[1,1,4,1,5,1],[]],
  [[3,1],[1,1,3,1,4,1,5,1],[3,1], 
  [1,1,3,1,4,1,5,1],[]]]]],
[64,267,"C2 x C2 x C2 x C2 x C2 x C2",              ###  done by hand 
  [[1,1],[2,1],[3,1],[4,1],[5,1],[6,1]],[
[[[1,1]],
  [[1,1],[],[],[],[],[]],
  [[1,1],[],[],[],[],[]]],
[[[1,1]],
  [[1,1],[],[],[],[],[]],
  [[1,1],[1,1],[],[],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[],[],[]],
  [[1,1],[2,1],[],[],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[],[],[]],
  [[1,1],[2,1],[1,1],[],[],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1],[],[],[],[]],
  [[1,1],[2,1],[1,1],[2,1],[],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[],[]],
  [[1,1],[2,1],[3,1],[],[],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[],[]],
  [[1,1],[2,1],[3,1],[1,1],[],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[],[]],
  [[1,1],[2,1],[3,1],[1,1],[2,1],[]]],
[[[1,1],[2,1],[3,1]],
  [[1,1],[2,1],[3,1],[],[],[]],
  [[1,1],[2,1],[3,1],[1,1],[2,1],[3,1]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[1,1],[2,1],[3,1],[4,1],[],[]],
  [[1,1],[2,1],[3,1],[4,1],[],[]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[1,1],[2,1],[3,1],[4,1],[],[]],
  [[1,1],[2,1],[3,1],[4,1],[1,1],[]]],
[[[1,1],[2,1],[3,1],[4,1]],
  [[1,1],[2,1],[3,1],[4,1],[],[]],
  [[1,1],[2,1],[3,1],[4,1],[1,1],[2,1]]],
[[[1,1],[2,1],[3,1],[4,1],[5,1]],
  [[1,1],[2,1],[3,1],[4,1],[5,1],[]],
  [[1,1],[2,1],[3,1],[4,1],[5,1],[]]],
[[[1,1],[2,1],[3,1],[4,1],[5,1]],
  [[1,1],[2,1],[3,1],[4,1],[5,1],[]],
  [[1,1],[2,1],[3,1],[4,1],[5,1],[1,1]]]]],
[65,1,"C65",[[ 1, 2, 2, 5 ]],[
[[[1,1]],
  [[1,2]],
  [[1,2]]],
[[[2,1]],
  [[2,5]],
  [[2,5]]]]],
[66,1,"C11 x S3",[[3,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1],[3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]]]],
[66,2,"C3 x D22",[[3,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]],
[[[1,1],[3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]]]],
[66,3,"D66",[[1,1],[2,1,3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]]]],
[66,4,"C66",[[1,1,2,1,3,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]],
[[[1,1,2,2]],
  [[1,1,2,1]],
  [[1,1,2,1]]],
[[[3,1]],
  [[3,1]],
  [[3,1]]],
[[[1,1,3,2]],
  [[1,1,3,1]],
  [[1,1,3,1]]],
[[[2,1,3,3]],
  [[2,1,3,1]],
  [[2,1,3,1]]]]],
[67,1,"C67",[[1,1]],[
 ]],
[68,1,"C17 : C4",[[1,1],[3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[68,2,"C68",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[68,3,"C17 : C4",[[1,1],[3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[68,4,"D68",[[1,1],[2,1,3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]]]],
[68,5,"C34 x C2",[[2,1],[1,1,3,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1]],
  [[1,1],[1,1]],
  [[],[1,1]]],
[[[1,1],[2,1]],
  [[2,1],[1,1]],
  [[2,1],[1,1]]],
[[[3,1]],
  [[],[3,1]],
  [[],[3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[],[1,1,3,1]]],
[[[1,1,3,1]],
  [[],[1,1,3,1]],
  [[1,1],[1,1,3,1]]]]],
[69,1,"C69",[[1,1,2,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]]]],
[70,1,"C7 x D10",[[3,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1],[3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]]]],
[70,2,"C5 x D14",[[3,1],[1,1,2,1]],[
[[[1,1]],
  [[],[1,1]],
  [[],[1,1]]],
[[[1,1,2,1]],
  [[],[1,1,2,1]],
  [[],[1,1,2,1]]],
[[[1,1],[3,1]],
  [[3,1],[1,1]],
  [[3,1],[1,1]]]]],
[70,3,"D70",[[1,1],[2,1,3,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]],
[[[1,1],[2,1]],
  [[1,1],[2,1]],
  [[1,1],[2,1]]],
[[[1,1],[3,1]],
  [[1,1],[3,1]],
  [[1,1],[3,1]]]]],
[70,4,"C70",[[1,1,2,1,3,1]],[
[[[1,1]],
  [[1,1]],
  [[1,1]]],
[[[2,1]],
  [[2,1]],
  [[2,1]]],
[[[3,1]],
  [[3,1]],
  [[3,1]]],
[[[1,1,2,2]],
  [[1,1,2,1]],
  [[1,1,2,1]]],
[[[1,1,3,2]],
  [[1,1,3,1]],
  [[1,1,3,1]]],
[[[ 2, 3, 3, 5 ]],
  [[2,1,3,1]],
  [[2,1,3,1]]]]]
];
CAT1_LIST_LOADED := true;

#  end of file  cat1data.g
