/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharBox;
import org.scilab.forge.jlatexmath.Extension;
import org.scilab.forge.jlatexmath.Metrics;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.VerticalBox;

public class DelimiterFactory {
    public static Box create(SymbolAtom symbolAtom, TeXEnvironment teXEnvironment, int n) {
        int n2;
        if (n > 4) {
            return symbolAtom.createBox(teXEnvironment);
        }
        TeXFont teXFont = teXEnvironment.getTeXFont();
        int n3 = teXEnvironment.getStyle();
        Char char_ = teXFont.getChar(symbolAtom.getName(), n3);
        for (n2 = 1; n2 <= n && teXFont.hasNextLarger(char_); ++n2) {
            char_ = teXFont.getNextLarger(char_, n3);
        }
        if (n2 <= n && !teXFont.hasNextLarger(char_)) {
            CharBox charBox = new CharBox(teXFont.getChar('A', "mathnormal", n3));
            Box box = DelimiterFactory.create(symbolAtom.getName(), teXEnvironment, (float)n * (charBox.getHeight() + charBox.getDepth()));
            return box;
        }
        return new CharBox(char_);
    }

    public static Box create(String string, TeXEnvironment teXEnvironment, float f) {
        TeXFont teXFont = teXEnvironment.getTeXFont();
        int n = teXEnvironment.getStyle();
        Char char_ = teXFont.getChar(string, n);
        Metrics metrics = char_.getMetrics();
        float f2 = metrics.getHeight() + metrics.getDepth();
        while (f2 < f && teXFont.hasNextLarger(char_)) {
            char_ = teXFont.getNextLarger(char_, n);
            metrics = char_.getMetrics();
            f2 = metrics.getHeight() + metrics.getDepth();
        }
        if (f2 >= f) {
            return new CharBox(char_);
        }
        if (teXFont.isExtensionChar(char_)) {
            boolean bl;
            VerticalBox verticalBox = new VerticalBox();
            Extension extension = teXFont.getExtension(char_, n);
            if (extension.hasTop()) {
                char_ = extension.getTop();
                verticalBox.add(new CharBox(char_));
            }
            if (bl = extension.hasMiddle()) {
                char_ = extension.getMiddle();
                verticalBox.add(new CharBox(char_));
            }
            if (extension.hasBottom()) {
                char_ = extension.getBottom();
                verticalBox.add(new CharBox(char_));
            }
            char_ = extension.getRepeat();
            CharBox charBox = new CharBox(char_);
            while (verticalBox.getHeight() + verticalBox.getDepth() <= f) {
                if (extension.hasTop() && extension.hasBottom()) {
                    verticalBox.add(1, charBox);
                    if (!bl) continue;
                    verticalBox.add(verticalBox.getSize() - 1, charBox);
                    continue;
                }
                if (extension.hasBottom()) {
                    verticalBox.add(0, charBox);
                    continue;
                }
                verticalBox.add(charBox);
            }
            return verticalBox;
        }
        return new CharBox(char_);
    }
}

