/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.ProtocolContext;
import org.gradle.messaging.remote.internal.protocol.ConsumerAvailable;
import org.gradle.messaging.remote.internal.protocol.ConsumerReady;
import org.gradle.messaging.remote.internal.protocol.ConsumerStopped;
import org.gradle.messaging.remote.internal.protocol.ConsumerStopping;
import org.gradle.messaging.remote.internal.protocol.ConsumerUnavailable;
import org.gradle.messaging.remote.internal.protocol.EndOfStreamEvent;
import org.gradle.messaging.remote.internal.protocol.MessageCredits;
import org.gradle.messaging.remote.internal.protocol.ProducerAvailable;
import org.gradle.messaging.remote.internal.protocol.ProducerReady;
import org.gradle.messaging.remote.internal.protocol.ProducerStopped;
import org.gradle.messaging.remote.internal.protocol.ProducerUnavailable;
import org.gradle.messaging.remote.internal.protocol.Request;
import org.gradle.messaging.remote.internal.protocol.WorkerStopping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceiveProtocol
implements Protocol<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceiveProtocol.class);
    private final UUID id;
    private final String displayName;
    private final String channelKey;
    private final Set<Object> producers = new HashSet<Object>();
    private ProtocolContext<Message> context;
    private boolean stopping;

    public ReceiveProtocol(UUID id, String displayName, String channelKey) {
        this.id = id;
        this.displayName = displayName;
        this.channelKey = channelKey;
    }

    @Override
    public void start(ProtocolContext<Message> context) {
        this.context = context;
        LOGGER.debug("Starting receiver {}.", (Object)this.id);
        context.dispatchOutgoing(new ConsumerAvailable(this.id, this.displayName, this.channelKey));
    }

    @Override
    public void handleIncoming(Message message) {
        if (message instanceof ProducerReady) {
            LOGGER.debug("Producer ready: {}", (Object)message);
            ProducerReady producerReady = (ProducerReady)message;
            this.producers.add(producerReady.getProducerId());
            this.context.dispatchOutgoing(new ConsumerReady(this.id, producerReady.getProducerId()));
        } else if (message instanceof ProducerStopped) {
            LOGGER.debug("Producer stopped: {}", (Object)message);
            ProducerStopped producerStopped = (ProducerStopped)message;
            this.context.dispatchOutgoing(new ConsumerStopped(this.id, producerStopped.getProducerId()));
            this.removeProducer(producerStopped.getProducerId());
        } else if (message instanceof ProducerUnavailable) {
            LOGGER.debug("Producer unavailable: {}", (Object)message);
            ProducerUnavailable producerUnavailable = (ProducerUnavailable)message;
            this.removeProducer(producerUnavailable.getId());
        } else {
            if (message instanceof ProducerAvailable) {
                return;
            }
            if (message instanceof Request) {
                this.context.dispatchIncoming(message);
            } else {
                throw new IllegalArgumentException(String.format("Unexpected incoming message received: %s", message));
            }
        }
    }

    private void removeProducer(Object producerId) {
        this.producers.remove(producerId);
        if (this.stopping && this.producers.isEmpty()) {
            LOGGER.debug("All producers finished. Stopping now.");
            this.allProducersFinished();
        }
    }

    @Override
    public void handleOutgoing(Message message) {
        if (message instanceof WorkerStopping) {
            this.workerStopped();
        } else if (message instanceof MessageCredits) {
            LOGGER.debug("Discarding {}.", (Object)message);
        } else {
            throw new IllegalArgumentException(String.format("Unexpected outgoing message dispatched: %s", message));
        }
    }

    private void workerStopped() {
        this.stopping = true;
        if (this.producers.isEmpty()) {
            LOGGER.debug("No producers. Stopping now.");
            this.allProducersFinished();
            return;
        }
        LOGGER.debug("Waiting for producers to finish. Stopping later. Producers: {}", this.producers);
        for (Object producer : this.producers) {
            this.context.dispatchOutgoing(new ConsumerStopping(this.id, producer));
        }
    }

    private void allProducersFinished() {
        this.context.dispatchOutgoing(new ConsumerUnavailable(this.id));
        this.context.dispatchIncoming(new EndOfStreamEvent());
    }

    @Override
    public void stopRequested() {
        assert (this.stopping);
        this.context.stopped();
    }
}

