/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalModuleBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectBuildClasspathPojo;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementFinder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleClassFinder;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleBuildClasspathManager {
    @NotNull
    private final Project myProject;
    @NotNull
    private volatile List<VirtualFile> allFilesCache;
    @NotNull
    private final AtomicReference<Map<String, List<VirtualFile>>> myClasspathMap;

    public GradleBuildClasspathManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/GradleBuildClasspathManager", "<init>"));
        }
        this.myClasspathMap = new AtomicReference(new HashMap());
        this.myProject = project;
        this.allFilesCache = ContainerUtil.newArrayList();
    }

    @NotNull
    public static GradleBuildClasspathManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/GradleBuildClasspathManager", "getInstance"));
        }
        GradleBuildClasspathManager gradleBuildClasspathManager = (GradleBuildClasspathManager)ServiceManager.getService((Project)project, GradleBuildClasspathManager.class);
        if (gradleBuildClasspathManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/GradleBuildClasspathManager", "getInstance"));
        }
        return gradleBuildClasspathManager;
    }

    public void reload() {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        assert (manager != null);
        AbstractExternalSystemLocalSettings localSettings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)this.myProject);
        HashMap map = ContainerUtil.newHashMap();
        JarFileSystem jarFileSystem = JarFileSystem.getInstance();
        for (ExternalProjectBuildClasspathPojo projectBuildClasspathPojo : localSettings.getProjectBuildClasspath().values()) {
            ArrayList projectBuildClasspath = ContainerUtil.newArrayList();
            for (String path : projectBuildClasspathPojo.getProjectBuildClasspath()) {
                VirtualFile virtualFile = ExternalSystemUtil.findLocalFileByPath((String)path);
                ContainerUtil.addIfNotNull((Collection)projectBuildClasspath, (Object)(virtualFile == null || virtualFile.isDirectory() ? virtualFile : jarFileSystem.getJarRootForLocalFile(virtualFile)));
            }
            for (ExternalModuleBuildClasspathPojo moduleBuildClasspathPojo : projectBuildClasspathPojo.getModulesBuildClasspath().values()) {
                ArrayList moduleBuildClasspath = ContainerUtil.newArrayList((Iterable)projectBuildClasspath);
                for (String path : moduleBuildClasspathPojo.getEntries()) {
                    VirtualFile virtualFile = ExternalSystemUtil.findLocalFileByPath((String)path);
                    ContainerUtil.addIfNotNull((Collection)moduleBuildClasspath, (Object)(virtualFile == null || virtualFile.isDirectory() ? virtualFile : jarFileSystem.getJarRootForLocalFile(virtualFile)));
                }
                map.put(moduleBuildClasspathPojo.getPath(), moduleBuildClasspath);
            }
        }
        this.myClasspathMap.set(map);
        LinkedHashSet<VirtualFile> set = new LinkedHashSet<VirtualFile>();
        for (List<VirtualFile> virtualFiles : this.myClasspathMap.get().values()) {
            set.addAll(virtualFiles);
        }
        this.allFilesCache = ContainerUtil.newArrayList(set);
        ((GradleClassFinder)((Object)Extensions.findExtension((ExtensionPointName)PsiElementFinder.EP_NAME, (AreaInstance)this.myProject, GradleClassFinder.class))).clearCache();
    }

    @NotNull
    public List<VirtualFile> getAllClasspathEntries() {
        this.checkRootsValidity(this.allFilesCache);
        List<VirtualFile> list = this.allFilesCache;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/GradleBuildClasspathManager", "getAllClasspathEntries"));
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getModuleClasspathEntries(@NotNull String externalModulePath) {
        if (externalModulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalModulePath", "org/jetbrains/plugins/gradle/service/GradleBuildClasspathManager", "getModuleClasspathEntries"));
        }
        this.checkRootsValidity(this.myClasspathMap.get().get(externalModulePath));
        List<VirtualFile> virtualFiles = this.myClasspathMap.get().get(externalModulePath);
        List<Object> list = virtualFiles == null ? Collections.emptyList() : virtualFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/GradleBuildClasspathManager", "getModuleClasspathEntries"));
        }
        return list;
    }

    private void checkRootsValidity(@Nullable List<VirtualFile> virtualFiles) {
        if (virtualFiles == null) {
            return;
        }
        if (!virtualFiles.isEmpty()) {
            for (VirtualFile file : virtualFiles) {
                if (file.isValid()) continue;
                this.reload();
                break;
            }
        }
    }
}

