/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class SaveSchemeDialog
extends DialogWrapper {
    private final JTextField mySchemeName;
    private final List<String> myExistingNames;

    public SaveSchemeDialog(@NotNull Component parent, String title, @NotNull List<String> existingNames, @NotNull String selectedName) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/application/options/SaveSchemeDialog", "<init>"));
        }
        if (existingNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingNames", "com/intellij/application/options/SaveSchemeDialog", "<init>"));
        }
        if (selectedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedName", "com/intellij/application/options/SaveSchemeDialog", "<init>"));
        }
        super(parent, false);
        this.mySchemeName = new JTextField();
        this.myExistingNames = existingNames;
        this.setTitle(title);
        this.mySchemeName.setText(UniqueNameGenerator.generateUniqueName((String)(selectedName + " copy"), existingNames));
        this.init();
    }

    public String getSchemeName() {
        return this.mySchemeName.getText();
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 0.0;
        gc.insets = new Insets(5, 0, 5, 5);
        panel.add((Component)new JLabel(ApplicationBundle.message((String)"label.name", (Object[])new Object[0])), gc);
        gc = new GridBagConstraints();
        gc.gridx = 1;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.gridwidth = 2;
        gc.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)this.mySchemeName, gc);
        panel.setPreferredSize((Dimension)JBUI.size((int)220, (int)40));
        return panel;
    }

    protected void doOKAction() {
        if (this.getSchemeName().trim().isEmpty()) {
            Messages.showMessageDialog((Component)this.getContentPane(), (String)ApplicationBundle.message((String)"error.scheme.must.have.a.name", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        if ("default".equals(this.getSchemeName())) {
            Messages.showMessageDialog((Component)this.getContentPane(), (String)ApplicationBundle.message((String)"error.illegal.scheme.name", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        if (this.myExistingNames.contains(this.getSchemeName())) {
            Messages.showMessageDialog((Component)this.getContentPane(), (String)ApplicationBundle.message((String)"error.a.scheme.with.this.name.already.exists.or.was.deleted.without.applying.the.changes", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySchemeName;
    }
}

