/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.SaveSchemeDialog;
import com.intellij.application.options.SkipSelfSearchComponent;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.application.options.colors.FontOptions;
import com.intellij.application.options.colors.ImportHandler;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class SchemesPanel
extends JPanel
implements SkipSelfSearchComponent {
    private final ColorAndFontOptions myOptions;
    private JComboBox mySchemeComboBox;
    private JButton myDeleteButton;
    private JLabel myHintLabel;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private boolean myListLoaded = false;

    public SchemesPanel(ColorAndFontOptions options) {
        super(new BorderLayout());
        this.myOptions = options;
        JPanel schemesGroup = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        schemesGroup.add((Component)this.createSchemePanel(), "North");
        schemesGroup.add((Component)panel, "Center");
        this.add((Component)schemesGroup, "Center");
        this.mySchemeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/colors/SchemesPanel$1", "actionPerformed"));
                }
                if (SchemesPanel.this.mySchemeComboBox.getSelectedIndex() != -1) {
                    EditorColorsScheme selected = SchemesPanel.this.myOptions.selectScheme((String)SchemesPanel.this.mySchemeComboBox.getSelectedItem());
                    boolean readOnly = ColorAndFontOptions.isReadOnly(selected);
                    SchemesPanel.this.myDeleteButton.setEnabled(!readOnly);
                    SchemesPanel.this.myHintLabel.setVisible(readOnly);
                    if (SchemesPanel.this.areSchemesLoaded()) {
                        ((ColorAndFontSettingsListener)SchemesPanel.this.myDispatcher.getMulticaster()).schemeChanged(SchemesPanel.this);
                    }
                }
            }
        });
    }

    public boolean areSchemesLoaded() {
        return this.myListLoaded;
    }

    private JPanel createSchemePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        int gridx = 0;
        panel.add((Component)new JLabel(ApplicationBundle.message((String)"editbox.scheme.name", (Object[])new Object[0])), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)new JBInsets(0, 0, 5, 5), 0, 0));
        this.mySchemeComboBox = new JComboBox();
        panel.add((Component)this.mySchemeComboBox, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)new JBInsets(0, 0, 5, 10), 0, 0));
        JButton saveAsButton = new JButton(ApplicationBundle.message((String)"button.save.as", (Object[])new Object[0]));
        saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/colors/SchemesPanel$2", "actionPerformed"));
                }
                SchemesPanel.this.showSaveAsDialog();
            }
        });
        panel.add((Component)saveAsButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)new JBInsets(0, 0, 5, 5), 0, 0));
        this.myDeleteButton = new JButton(ApplicationBundle.message((String)"button.delete", (Object[])new Object[0]));
        this.myDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/colors/SchemesPanel$3", "actionPerformed"));
                }
                if (SchemesPanel.this.mySchemeComboBox.getSelectedIndex() != -1) {
                    SchemesPanel.this.myOptions.removeScheme((String)SchemesPanel.this.mySchemeComboBox.getSelectedItem());
                }
            }
        });
        panel.add((Component)this.myDeleteButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)new JBInsets(0, 0, 5, 5), 0, 0));
        this.myHintLabel = new JLabel(ApplicationBundle.message((String)"hint.readonly.scheme.cannot.be.modified", (Object[])new Object[0]));
        this.myHintLabel.setEnabled(false);
        panel.add((Component)this.myHintLabel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)new JBInsets(0, 0, 5, 5), 0, 0));
        for (final ImportHandler importHandler : (ImportHandler[])Extensions.getExtensions(ImportHandler.EP_NAME)) {
            final JButton button = new JButton(importHandler.getTitle());
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/colors/SchemesPanel$4", "actionPerformed"));
                    }
                    importHandler.performImport(button, new Consumer<EditorColorsScheme>(){

                        public void consume(EditorColorsScheme scheme) {
                            if (scheme != null) {
                                SchemesPanel.this.myOptions.addImportedScheme(scheme);
                            }
                        }
                    });
                }
            });
            panel.add((Component)button, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)new JBInsets(0, 0, 5, 5), 0, 0));
        }
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx + 1, 0, 1, 1, 1.0, 0.0, 17, 2, (Insets)new JBInsets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void showSaveAsDialog() {
        ArrayList names = ContainerUtil.newArrayList((Object[])this.myOptions.getSchemeNames());
        String selectedName = this.myOptions.getSelectedScheme().getName();
        SaveSchemeDialog dialog = new SaveSchemeDialog(this, ApplicationBundle.message((String)"title.save.color.scheme.as", (Object[])new Object[0]), names, selectedName);
        if (dialog.showAndGet()) {
            this.myOptions.saveSchemeAs(dialog.getSchemeName());
        }
    }

    private void changeToScheme() {
        this.updateDescription(false);
    }

    public boolean updateDescription(boolean modified) {
        EditorColorsScheme scheme = this.myOptions.getSelectedScheme();
        if (modified && (ColorAndFontOptions.isReadOnly(scheme) || ColorSettingsUtil.isSharedScheme(scheme))) {
            FontOptions.showReadOnlyMessage(this, ColorSettingsUtil.isSharedScheme(scheme));
            return false;
        }
        return true;
    }

    public void resetSchemesCombo(Object source) {
        if (this != source) {
            String[] schemeNames;
            this.setListLoaded(false);
            String selectedSchemeBackup = this.myOptions.getSelectedScheme().getName();
            this.mySchemeComboBox.removeAllItems();
            for (String schemeName : schemeNames = this.myOptions.getSchemeNames()) {
                this.mySchemeComboBox.addItem(schemeName);
            }
            this.mySchemeComboBox.setSelectedItem(selectedSchemeBackup);
            this.setListLoaded(true);
            this.changeToScheme();
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(this);
        }
    }

    private void setListLoaded(boolean b) {
        this.myListLoaded = b;
    }

    public void addListener(ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }
}

