/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.ui.HintHint;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class DaemonTooltipUtil {
    private static final TooltipGroup DAEMON_INFO_GROUP = new TooltipGroup("DAEMON_INFO_GROUP", 0);

    public static void showInfoTooltip(HighlightInfo info, Editor editor, int defaultOffset) {
        DaemonTooltipUtil.showInfoTooltip(info, editor, defaultOffset, -1);
    }

    public static void cancelTooltips() {
        TooltipController.getInstance().cancelTooltip(DAEMON_INFO_GROUP, null, true);
    }

    public static void showInfoTooltip(@NotNull HighlightInfo info, @NotNull Editor editor, int defaultOffset, int currentWidth) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/DaemonTooltipUtil", "showInfoTooltip"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/DaemonTooltipUtil", "showInfoTooltip"));
        }
        if (info.getToolTip() == null) {
            return;
        }
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        Point bestPoint = editor.logicalPositionToXY(editor.offsetToLogicalPosition(defaultOffset));
        bestPoint.y += editor.getLineHeight() / 2;
        if (!visibleArea.contains(bestPoint)) {
            bestPoint = editor.logicalPositionToXY(editor.offsetToLogicalPosition(defaultOffset));
        }
        Point p = SwingUtilities.convertPoint(editor.getContentComponent(), bestPoint, editor.getComponent().getRootPane().getLayeredPane());
        TooltipController.getInstance().showTooltip(editor, p, info.getToolTip(), currentWidth, false, DAEMON_INFO_GROUP, new HintHint(editor, bestPoint).setAwtTooltip(true).setHighlighterType(true).setCalloutShift(editor.getLineHeight() / 2 - 1));
    }
}

