/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.DialogUtil;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ImportPopupHectorComponentProvider
implements HectorComponentPanelsProvider {
    public HectorComponentPanel createConfigurable(final @NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ImportPopupHectorComponentProvider", "createConfigurable"));
        }
        Project project2 = file2.getProject();
        final DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)project2);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        VirtualFile virtualFile = file2.getVirtualFile();
        assert (virtualFile != null);
        final boolean notInLibrary = !fileIndex.isInLibrarySource(virtualFile) && !fileIndex.isInLibraryClasses(virtualFile) || fileIndex.isInContent(virtualFile);
        return new HectorComponentPanel(){
            private JCheckBox myImportPopupCheckBox = new JCheckBox(EditorBundle.message((String)"hector.import.popup.checkbox", (Object[])new Object[0]));

            public JComponent createComponent() {
                DialogUtil.registerMnemonic((AbstractButton)this.myImportPopupCheckBox);
                return this.myImportPopupCheckBox;
            }

            public boolean isModified() {
                return this.myImportPopupCheckBox.isSelected() != analyzer.isImportHintsEnabled(file2);
            }

            public void apply() throws ConfigurationException {
                analyzer.setImportHintsEnabled(file2, this.myImportPopupCheckBox.isSelected());
            }

            public void reset() {
                this.myImportPopupCheckBox.setSelected(analyzer.isImportHintsEnabled(file2));
                this.myImportPopupCheckBox.setEnabled(analyzer.isAutohintsAvailable(file2));
                this.myImportPopupCheckBox.setVisible(notInLibrary);
            }

            public void disposeUIResources() {
                this.myImportPopupCheckBox = null;
            }
        };
    }
}

