/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlipIntersectionSidesFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + FlipIntersectionSidesFix.class.getName()));
    private final String myClassName;
    private final List<PsiTypeElement> myConjuncts;
    private final PsiTypeElement myConjunct;
    private final PsiTypeElement myCastTypeElement;

    public FlipIntersectionSidesFix(String className, @NotNull List<PsiTypeElement> conjList, PsiTypeElement conjunct, PsiTypeElement castTypeElement) {
        if (conjList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conjList", "com/intellij/codeInsight/daemon/impl/quickfix/FlipIntersectionSidesFix", "<init>"));
        }
        this.myClassName = className;
        this.myConjuncts = conjList;
        LOG.assertTrue(!conjList.isEmpty());
        this.myConjunct = conjunct;
        this.myCastTypeElement = castTypeElement;
    }

    @NotNull
    public String getText() {
        String string = "Move '" + this.myClassName + "' to the beginning";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/FlipIntersectionSidesFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Move to front" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/FlipIntersectionSidesFix", "getFamilyName"));
        }
        return "Move to front";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/FlipIntersectionSidesFix", "isAvailable"));
        }
        for (PsiTypeElement typeElement : this.myConjuncts) {
            if (typeElement.isValid()) continue;
            return false;
        }
        return !Comparing.strEqual((String)this.myConjunct.getText(), (String)this.myConjuncts.get(0).getText());
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/FlipIntersectionSidesFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        this.myConjuncts.remove(this.myConjunct);
        this.myConjuncts.add(0, this.myConjunct);
        String intersectionTypeText = StringUtil.join(this.myConjuncts, (Function)new Function<PsiTypeElement, String>(){

            public String fun(PsiTypeElement element) {
                return element.getText();
            }
        }, (String)" & ");
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiTypeCastExpression fixedCast = (PsiTypeCastExpression)elementFactory.createExpressionFromText("(" + intersectionTypeText + ") a", (PsiElement)this.myCastTypeElement);
        PsiTypeElement fixedCastCastType = fixedCast.getCastType();
        LOG.assertTrue(fixedCastCastType != null);
        PsiElement flippedTypeElement = this.myCastTypeElement.replace((PsiElement)fixedCastCastType);
        CodeStyleManager.getInstance((Project)project2).reformat(flippedTypeElement);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

