/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DfaRelationValue
extends DfaValue {
    private DfaValue myLeftOperand;
    private DfaValue myRightOperand;
    private IElementType myRelation;
    private boolean myIsNegated;

    public static IElementType getSymmetricOperation(IElementType sign) {
        if (JavaTokenType.LT == sign) {
            return JavaTokenType.GT;
        }
        if (JavaTokenType.GE == sign) {
            return JavaTokenType.LE;
        }
        if (JavaTokenType.GT == sign) {
            return JavaTokenType.LT;
        }
        if (JavaTokenType.LE == sign) {
            return JavaTokenType.GE;
        }
        return sign;
    }

    private DfaRelationValue(DfaValueFactory factory) {
        super(factory);
    }

    private DfaRelationValue(DfaValue myLeftOperand, DfaValue myRightOperand, IElementType myRelation, boolean myIsNegated, DfaValueFactory factory) {
        super(factory);
        this.myLeftOperand = myLeftOperand;
        this.myRightOperand = myRightOperand;
        this.myRelation = myRelation;
        this.myIsNegated = myIsNegated;
    }

    public DfaValue getLeftOperand() {
        return this.myLeftOperand;
    }

    public DfaValue getRightOperand() {
        return this.myRightOperand;
    }

    public boolean isNegated() {
        return this.myIsNegated;
    }

    @Override
    public DfaValue createNegated() {
        return this.myFactory.getRelationFactory().createRelation(this.myLeftOperand, this.myRightOperand, this.myRelation, !this.myIsNegated);
    }

    private boolean hardEquals(DfaRelationValue rel) {
        return Comparing.equal((Object)rel.myLeftOperand, (Object)this.myLeftOperand) && Comparing.equal((Object)rel.myRightOperand, (Object)this.myRightOperand) && rel.myRelation == this.myRelation && rel.myIsNegated == this.myIsNegated;
    }

    public boolean isEquality() {
        return this.myRelation == JavaTokenType.EQEQ && !this.myIsNegated;
    }

    public boolean isNonEquality() {
        return this.myRelation == JavaTokenType.EQEQ && this.myIsNegated || this.myRelation == JavaTokenType.GT && !this.myIsNegated || this.myRelation == JavaTokenType.GE && this.myIsNegated;
    }

    public boolean isInstanceOf() {
        return this.myRelation == JavaTokenType.INSTANCEOF_KEYWORD;
    }

    @NonNls
    public String toString() {
        return (this.isNegated() ? "not " : "") + this.myLeftOperand + " " + this.myRelation + " " + this.myRightOperand;
    }

    public static class Factory {
        private final DfaRelationValue mySharedInstance;
        private final HashMap<String, ArrayList<DfaRelationValue>> myStringToObject;
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
            this.mySharedInstance = new DfaRelationValue(factory);
            this.myStringToObject = new HashMap();
        }

        public DfaRelationValue createRelation(DfaValue dfaLeft, DfaValue dfaRight, IElementType relation, boolean negated) {
            if (JavaTokenType.PLUS == relation) {
                return null;
            }
            if (dfaLeft instanceof DfaVariableValue || dfaLeft instanceof DfaBoxedValue || dfaLeft instanceof DfaUnboxedValue || dfaRight instanceof DfaVariableValue || dfaRight instanceof DfaBoxedValue || dfaRight instanceof DfaUnboxedValue) {
                if (!(dfaLeft instanceof DfaVariableValue || dfaLeft instanceof DfaBoxedValue || dfaLeft instanceof DfaUnboxedValue)) {
                    return this.createRelation(dfaRight, dfaLeft, DfaRelationValue.getSymmetricOperation(relation), negated);
                }
                return this.createCanonicalRelation(relation, negated, dfaLeft, dfaRight);
            }
            if (dfaLeft instanceof DfaTypeValue && ((DfaTypeValue)dfaLeft).isNotNull() && dfaRight instanceof DfaConstValue) {
                return this.createCanonicalRelation(relation, negated, dfaLeft, dfaRight);
            }
            if (dfaRight instanceof DfaTypeValue && ((DfaTypeValue)dfaRight).isNotNull() && dfaLeft instanceof DfaConstValue) {
                return this.createCanonicalRelation(relation, negated, dfaRight, dfaLeft);
            }
            return null;
        }

        private DfaRelationValue createCanonicalRelation(IElementType relation, boolean negated, @NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight) {
            if (dfaLeft == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaLeft", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$Factory", "createCanonicalRelation"));
            }
            if (dfaRight == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaRight", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$Factory", "createCanonicalRelation"));
            }
            if (JavaTokenType.NE == relation) {
                relation = JavaTokenType.EQEQ;
                negated = !negated;
            } else if (JavaTokenType.LT == relation) {
                relation = JavaTokenType.GE;
                negated = !negated;
            } else if (JavaTokenType.LE == relation) {
                relation = JavaTokenType.GT;
                negated = !negated;
            }
            this.mySharedInstance.myLeftOperand = dfaLeft;
            this.mySharedInstance.myRightOperand = dfaRight;
            this.mySharedInstance.myRelation = relation;
            this.mySharedInstance.myIsNegated = negated;
            String id = this.mySharedInstance.toString();
            ArrayList<DfaRelationValue> conditions = (ArrayList<DfaRelationValue>)this.myStringToObject.get((Object)id);
            if (conditions == null) {
                conditions = new ArrayList<DfaRelationValue>();
                this.myStringToObject.put((Object)id, conditions);
            } else {
                for (DfaRelationValue rel : conditions) {
                    if (!rel.hardEquals(this.mySharedInstance)) continue;
                    return rel;
                }
            }
            DfaRelationValue result = new DfaRelationValue(dfaLeft, dfaRight, relation, negated, this.myFactory);
            conditions.add(result);
            return result;
        }
    }
}

