/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.ExportableUserDataHolderBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileSetCompileScope
extends ExportableUserDataHolderBase
implements CompileScope {
    private final Set<VirtualFile> myRootFiles = new HashSet<VirtualFile>();
    private final Set<String> myDirectoryUrls = new HashSet<String>();
    private Set<String> myUrls = null;
    private final Module[] myAffectedModules;

    public FileSetCompileScope(final Collection<VirtualFile> files, Module[] modules) {
        this.myAffectedModules = modules;
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (VirtualFile file2 : files) {
                    assert (file2 != null);
                    FileSetCompileScope.this.addFile(file2);
                }
            }
        });
    }

    @NotNull
    public Module[] getAffectedModules() {
        if (this.myAffectedModules == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/FileSetCompileScope", "getAffectedModules"));
        }
        return this.myAffectedModules;
    }

    public Collection<VirtualFile> getRootFiles() {
        return Collections.unmodifiableCollection(this.myRootFiles);
    }

    @NotNull
    public VirtualFile[] getFiles(FileType fileType, boolean inSourceOnly) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        Iterator<VirtualFile> it = this.myRootFiles.iterator();
        while (it.hasNext()) {
            VirtualFile file2 = it.next();
            if (!file2.isValid()) {
                it.remove();
                continue;
            }
            if (file2.isDirectory()) {
                FileSetCompileScope.addRecursively(files, file2, fileType);
                continue;
            }
            if (fileType != null && !fileType.equals(file2.getFileType())) continue;
            files.add(file2);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(files);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/FileSetCompileScope", "getFiles"));
        }
        return virtualFileArray;
    }

    public boolean belongs(String url) {
        if (this.getUrls().contains(url)) {
            return true;
        }
        for (String directoryUrl : this.myDirectoryUrls) {
            if (!FileUtil.startsWith((String)url, (String)directoryUrl)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getUrls() {
        if (this.myUrls == null) {
            this.myUrls = new HashSet<String>();
            for (VirtualFile file2 : this.myRootFiles) {
                String url = file2.getUrl();
                this.myUrls.add(url);
            }
        }
        return this.myUrls;
    }

    private void addFile(VirtualFile file2) {
        if (file2.isDirectory()) {
            this.myDirectoryUrls.add(file2.getUrl() + "/");
        }
        this.myRootFiles.add(file2);
        this.myUrls = null;
    }

    private static void addRecursively(final Collection<VirtualFile> container, VirtualFile fromDirectory, final FileType fileType) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)fromDirectory, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT}){

            public boolean visitFile(@NotNull VirtualFile child) {
                if (child == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/compiler/impl/FileSetCompileScope$2", "visitFile"));
                }
                if (!child.isDirectory() && (fileType == null || fileType.equals(child.getFileType()))) {
                    container.add(child);
                }
                return true;
            }
        });
    }
}

