/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Location;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlternativeSourceNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"AlternativeSource");
    private static final Key<Boolean> FILE_PROCESSED_KEY = Key.create((String)"AlternativeSourceCheckDone");
    private final Project myProject;

    public AlternativeSourceNotificationProvider(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/AlternativeSourceNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/ui/AlternativeSourceNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/debugger/ui/AlternativeSourceNotificationProvider", "createNotificationPanel"));
        }
        if (!DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE) {
            return null;
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
        if (session == null) {
            FILE_PROCESSED_KEY.set((UserDataHolder)file2, null);
            return null;
        }
        XSourcePosition position = session.getCurrentPosition();
        if (position == null || !file2.equals(position.getFile())) {
            FILE_PROCESSED_KEY.set((UserDataHolder)file2, null);
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile == null) {
            return null;
        }
        if (!(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiClass[] classes = ((PsiJavaFile)psiFile).getClasses();
        if (classes.length == 0) {
            return null;
        }
        PsiClass baseClass = classes[0];
        String name = baseClass.getQualifiedName();
        if (name == null) {
            return null;
        }
        if (DumbService.getInstance((Project)this.myProject).isDumb()) {
            return null;
        }
        ArrayList alts = ContainerUtil.newArrayList((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(name, GlobalSearchScope.allScope((Project)this.myProject)));
        ContainerUtil.removeDuplicates((Collection)alts);
        FILE_PROCESSED_KEY.set((UserDataHolder)file2, (Object)true);
        if (alts.size() > 1) {
            for (PsiClass cls : alts) {
                if (!cls.equals(baseClass) && !cls.getNavigationElement().equals(baseClass)) continue;
                alts.remove(cls);
                break;
            }
            alts.add(0, baseClass);
            ComboBoxClassElement[] elems = (ComboBoxClassElement[])ContainerUtil.map2Array((Collection)alts, ComboBoxClassElement.class, (Function)new Function<PsiClass, ComboBoxClassElement>(){

                public ComboBoxClassElement fun(PsiClass psiClass) {
                    return new ComboBoxClassElement((PsiClass)psiClass.getNavigationElement());
                }
            });
            return new AlternativeSourceNotificationPanel(elems, baseClass, this.myProject, file2);
        }
        return null;
    }

    public static boolean fileProcessed(VirtualFile file2) {
        return FILE_PROCESSED_KEY.get((UserDataHolder)file2) != null;
    }

    private static class AlternativeSourceNotificationPanel
    extends EditorNotificationPanel {
        public AlternativeSourceNotificationPanel(ComboBoxClassElement[] alternatives, PsiClass aClass, final Project project2, final VirtualFile file2) {
            this.setText(DebuggerBundle.message((String)"editor.notification.alternative.source", (Object[])new Object[]{aClass.getQualifiedName()}));
            final ComboBox switcher = new ComboBox((Object[])alternatives);
            switcher.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project2).getContext();
                    final DebuggerSession session = context.getDebuggerSession();
                    PsiClass item = ((ComboBoxClassElement)switcher.getSelectedItem()).myClass;
                    final VirtualFile vFile = item.getContainingFile().getVirtualFile();
                    if (session != null && vFile != null) {
                        session.getProcess().getManagerThread().schedule(new DebuggerCommandImpl(){

                            @Override
                            protected void action() throws Exception {
                                Location location;
                                StackFrameProxyImpl proxy = context.getFrameProxy();
                                Location location2 = location = proxy != null ? proxy.location() : null;
                                if (location != null) {
                                    DebuggerUtilsEx.setAlternativeSourceUrl(location.declaringType().name(), vFile.getUrl(), project2);
                                }
                                DebuggerUIUtil.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        FileEditorManager.getInstance((Project)project2).closeFile(file2);
                                        session.refresh(true);
                                    }
                                });
                            }
                        });
                    } else {
                        FileEditorManager.getInstance((Project)project2).closeFile(file2);
                        item.navigate(true);
                    }
                }
            });
            this.myLinksPanel.add((Component)switcher);
            this.createActionLabel(DebuggerBundle.message((String)"action.disable.text", (Object[])new Object[0]), new Runnable(){

                @Override
                public void run() {
                    DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE = false;
                    FILE_PROCESSED_KEY.set((UserDataHolder)file2, null);
                    FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
                    FileEditor editor = fileEditorManager.getSelectedEditor(file2);
                    if (editor != null) {
                        fileEditorManager.removeTopComponent(editor, (JComponent)((Object)this));
                    }
                }
            });
        }
    }

    private static class ComboBoxClassElement {
        private final PsiClass myClass;
        private String myText;
        private static JList ourDummyList = new JBList();

        public ComboBoxClassElement(PsiClass aClass) {
            this.myClass = aClass;
        }

        public String toString() {
            if (this.myText == null) {
                ModuleRendererFactory factory = ModuleRendererFactory.findInstance(this.myClass);
                DefaultListCellRenderer moduleRenderer = factory.getModuleRenderer();
                moduleRenderer.getListCellRendererComponent((JList<?>)ourDummyList, this.myClass, 1, false, false);
                this.myText = moduleRenderer.getText();
            }
            return this.myText;
        }
    }
}

