/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.actions.VcsQuickListContentProvider;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsQuickListContentProvider
implements VcsQuickListContentProvider {
    @Nullable
    public List<AnAction> getVcsActions(@Nullable Project project2, @Nullable AbstractVcs activeVcs, @Nullable DataContext dataContext) {
        if (activeVcs == null || !this.getVcsName().equals(activeVcs.getName())) {
            return null;
        }
        ActionManager manager = ActionManager.getInstance();
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add((AnAction)new Separator(activeVcs.getDisplayName()));
        DvcsQuickListContentProvider.add("CheckinProject", manager, actions);
        DvcsQuickListContentProvider.add("CheckinFiles", manager, actions);
        DvcsQuickListContentProvider.add("ChangesView.Revert", manager, actions);
        DvcsQuickListContentProvider.addSeparator(actions);
        DvcsQuickListContentProvider.add("Vcs.ShowTabbedFileHistory", manager, actions);
        DvcsQuickListContentProvider.add("Annotate", manager, actions);
        DvcsQuickListContentProvider.add("Compare.SameVersion", manager, actions);
        DvcsQuickListContentProvider.addSeparator(actions);
        this.addVcsSpecificActions(manager, actions);
        return actions;
    }

    @NotNull
    protected abstract String getVcsName();

    protected abstract void addVcsSpecificActions(@NotNull ActionManager var1, @NotNull List<AnAction> var2);

    public boolean replaceVcsActionsFor(@NotNull AbstractVcs activeVcs, @Nullable DataContext dataContext) {
        if (activeVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeVcs", "com/intellij/dvcs/actions/DvcsQuickListContentProvider", "replaceVcsActionsFor"));
        }
        return this.getVcsName().equals(activeVcs.getName());
    }

    protected static void addSeparator(@NotNull List<AnAction> actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/dvcs/actions/DvcsQuickListContentProvider", "addSeparator"));
        }
        actions.add((AnAction)new Separator());
    }

    protected static void add(String actionName, ActionManager manager, List<AnAction> actions) {
        AnAction action = manager.getAction(actionName);
        assert (action != null) : "Can not find action " + actionName;
        actions.add(action);
    }
}

