/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.applet;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.execution.applet.AppletConfigurable;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.SmartSerializer;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AppletConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements SingleClassConfiguration,
RefactoringListenerProvider {
    public String MAIN_CLASS_NAME;
    public String HTML_FILE_NAME;
    public boolean HTML_USED;
    public int WIDTH;
    public int HEIGHT;
    public String POLICY_FILE;
    public String VM_PARAMETERS;
    private AppletParameter[] myAppletParameters;
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    public String ALTERNATIVE_JRE_PATH;
    @NonNls
    protected static final String NAME_ATTR = "name";
    @NonNls
    protected static final String VALUE_ATTR = "value";
    @NonNls
    protected static final String PARAMETER_ELEMENT_NAME = "parameter";
    private final SmartSerializer mySerializer;

    public AppletConfiguration(@NotNull Project project2, ConfigurationFactory factory) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/applet/AppletConfiguration", "<init>"));
        }
        super((RunConfigurationModule)new JavaRunConfigurationModule(project2, false), factory);
        this.mySerializer = new SmartSerializer(!project2.isDefault(), true);
    }

    @Override
    public void setMainClass(PsiClass psiClass) {
        Module originalModule = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        this.setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass));
        this.setModule(JavaExecutionUtil.findModule((PsiClass)psiClass));
        this.restoreOriginalModule(originalModule);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/applet/AppletConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/applet/AppletConfiguration", "getState"));
        }
        return new JavaCommandLineState(env){
            private AppletHtmlFile myHtmlURL;
            {
                this.myHtmlURL = null;
            }

            protected JavaParameters createJavaParameters() throws ExecutionException {
                JavaParameters params = new JavaParameters();
                this.myHtmlURL = AppletConfiguration.this.getHtmlURL();
                if (this.myHtmlURL != null) {
                    int classPathType = this.myHtmlURL.isHttp() ? 1 : 3;
                    RunConfigurationModule runConfigurationModule = AppletConfiguration.this.getConfigurationModule();
                    JavaParametersUtil.configureModule(runConfigurationModule, params, classPathType, AppletConfiguration.this.ALTERNATIVE_JRE_PATH_ENABLED ? AppletConfiguration.this.ALTERNATIVE_JRE_PATH : null);
                    String policyFileParameter = AppletConfiguration.this.getPolicyFileParameter();
                    if (policyFileParameter != null) {
                        params.getVMParametersList().add(policyFileParameter);
                    }
                    params.getVMParametersList().addParametersString(AppletConfiguration.this.VM_PARAMETERS);
                    params.setMainClass("sun.applet.AppletViewer");
                    params.getProgramParametersList().add(this.myHtmlURL.getUrl());
                }
                return params;
            }

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                OSProcessHandler handler2 = super.startProcess();
                final AppletHtmlFile htmlUrl = this.myHtmlURL;
                if (htmlUrl != null) {
                    handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(ProcessEvent event) {
                            htmlUrl.deleteFile();
                        }
                    });
                }
                OSProcessHandler oSProcessHandler = handler2;
                if (oSProcessHandler == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/applet/AppletConfiguration$1", "startProcess"));
                }
                return oSProcessHandler;
            }
        };
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        AppletConfigurable appletConfigurable = new AppletConfigurable(this.getProject());
        if (appletConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/applet/AppletConfiguration", "getConfigurationEditor"));
        }
        return appletConfigurable;
    }

    @NonNls
    private String getPolicyFileParameter() {
        if (this.POLICY_FILE != null && this.POLICY_FILE.length() > 0) {
            return "-Djava.security.policy=" + this.getPolicyFile();
        }
        return null;
    }

    @Transient
    public String getPolicyFile() {
        return ExternalizablePath.localPathValue(this.POLICY_FILE);
    }

    public void setPolicyFile(String localPath) {
        this.POLICY_FILE = ExternalizablePath.urlValue(localPath);
    }

    public Collection<Module> getValidModules() {
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.MAIN_CLASS_NAME);
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        this.mySerializer.readExternal((Object)this, parentNode);
        List paramList = parentNode.getChildren(PARAMETER_ELEMENT_NAME);
        if (paramList.isEmpty()) {
            this.myAppletParameters = null;
        } else {
            SmartList parameters = new SmartList();
            for (Element element : paramList) {
                parameters.add(new AppletParameter(element.getAttributeValue(NAME_ATTR), element.getAttributeValue(VALUE_ATTR)));
            }
            this.myAppletParameters = parameters.toArray(new AppletParameter[parameters.size()]);
        }
    }

    protected boolean isNewSerializationUsed() {
        return true;
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        this.mySerializer.writeExternal((Object)this, parentNode);
        if (this.myAppletParameters != null) {
            for (AppletParameter myAppletParameter : this.myAppletParameters) {
                Element element = new Element(PARAMETER_ELEMENT_NAME);
                parentNode.addContent(element);
                element.setAttribute(NAME_ATTR, myAppletParameter.getName());
                element.setAttribute(VALUE_ATTR, myAppletParameter.getValue());
            }
        }
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (this.HTML_USED) {
            return null;
        }
        return RefactoringListeners.getClassOrPackageListener(element, new RefactoringListeners.SingleClassConfigurationAccessor(this));
    }

    @Override
    @Transient
    public PsiClass getMainClass() {
        return ((JavaRunConfigurationModule)this.getConfigurationModule()).findClass(this.MAIN_CLASS_NAME);
    }

    public String suggestedName() {
        if (this.MAIN_CLASS_NAME == null) {
            return null;
        }
        return ProgramRunnerUtil.shortenName(JavaExecutionUtil.getShortClassName((String)this.MAIN_CLASS_NAME), 0);
    }

    @Override
    public void setMainClassName(String qualifiedName) {
        this.MAIN_CLASS_NAME = qualifiedName;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.ALTERNATIVE_JRE_PATH_ENABLED && (this.ALTERNATIVE_JRE_PATH == null || this.ALTERNATIVE_JRE_PATH.length() == 0 || !JavaSdk.checkForJre((String)this.ALTERNATIVE_JRE_PATH))) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"jre.not.valid.error.message", (Object[])new Object[]{this.ALTERNATIVE_JRE_PATH}));
        }
        ((JavaRunConfigurationModule)this.getConfigurationModule()).checkForWarning();
        if (this.HTML_USED) {
            if (this.HTML_FILE_NAME == null || this.HTML_FILE_NAME.length() == 0) {
                throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"html.file.not.specified.error.message", (Object[])new Object[0]));
            }
            try {
                new URL(this.getHtmlURL().getUrl());
            }
            catch (CantRunException ex) {
                this.checkUrlIsValid((Exception)((Object)ex));
            }
            catch (MalformedURLException ex) {
                this.checkUrlIsValid(ex);
            }
        } else {
            ((JavaRunConfigurationModule)this.getConfigurationModule()).checkClassName(this.MAIN_CLASS_NAME, ExecutionBundle.message((String)"no.applet.class.specified.error.message", (Object[])new Object[0]));
        }
    }

    private void checkUrlIsValid(Exception ex) throws RuntimeConfigurationWarning {
        throw new RuntimeConfigurationWarning("URL " + this.HTML_FILE_NAME + " is not valid: " + ex.getLocalizedMessage());
    }

    @Transient
    public AppletParameter[] getAppletParameters() {
        return this.myAppletParameters;
    }

    public void setAppletParameters(AppletParameter[] appletParameters) {
        this.myAppletParameters = appletParameters;
    }

    public void setAppletParameters(List<AppletParameter> parameters) {
        this.setAppletParameters(parameters.toArray(new AppletParameter[parameters.size()]));
    }

    private AppletHtmlFile getHtmlURL() throws CantRunException {
        if (this.HTML_USED) {
            if (this.HTML_FILE_NAME == null || this.HTML_FILE_NAME.length() == 0) {
                throw new CantRunException(ExecutionBundle.message((String)"html.file.not.specified.error.message", (Object[])new Object[0]));
            }
            return new AppletHtmlFile(this.HTML_FILE_NAME, null);
        }
        if (this.MAIN_CLASS_NAME == null || this.MAIN_CLASS_NAME.length() == 0) {
            throw new CantRunException(ExecutionBundle.message((String)"class.not.specified.error.message", (Object[])new Object[0]));
        }
        try {
            return this.generateAppletTempPage();
        }
        catch (IOException ignored) {
            throw new CantRunException(ExecutionBundle.message((String)"failed.to.generate.wrapper.error.message", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppletHtmlFile generateAppletTempPage() throws IOException {
        File tempFile2 = FileUtil.createTempFile((String)"AppletPage", (String)".html");
        try (FileWriter writer = new FileWriter(tempFile2);){
            writer.write("<html>\n<head>\n<title>" + this.MAIN_CLASS_NAME + "</title>\n" + "</head>\n" + "<applet codebase=\".\"\n" + "code=\"" + this.MAIN_CLASS_NAME + "\"\n" + "name=\"" + this.MAIN_CLASS_NAME + "\"\n" + "width=" + this.WIDTH + "\n" + "height=" + this.HEIGHT + "\n" + "align=top>\n");
            AppletParameter[] appletParameters = this.getAppletParameters();
            if (appletParameters != null) {
                for (AppletParameter parameter : appletParameters) {
                    writer.write("<param name=\"" + parameter.getName() + "\" value=\"" + parameter.getValue() + "\">\n");
                }
            }
            writer.write("</applet>\n</body>\n</html>\n");
        }
        return new AppletHtmlFile(tempFile2.getAbsolutePath(), tempFile2);
    }

    private static class AppletHtmlFile {
        private final String myHtmlFile;
        private final File myFileToDelete;
        @NonNls
        protected static final String FILE_PREFIX = "file:/";
        @NonNls
        protected static final String HTTP_PREFIX = "http:/";
        @NonNls
        protected static final String HTTPS_PREFIX = "https:/";

        protected AppletHtmlFile(String htmlFile, File fileToDelete) {
            this.myHtmlFile = htmlFile;
            this.myFileToDelete = fileToDelete;
        }

        public String getUrl() {
            if (!StringUtil.startsWithIgnoreCase((String)this.myHtmlFile, (String)FILE_PREFIX) && !this.isHttp()) {
                try {
                    return new File(this.myHtmlFile).toURL().toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return this.myHtmlFile;
        }

        public boolean isHttp() {
            return StringUtil.startsWithIgnoreCase((String)this.myHtmlFile, (String)HTTP_PREFIX) || StringUtil.startsWithIgnoreCase((String)this.myHtmlFile, (String)HTTPS_PREFIX);
        }

        public void deleteFile() {
            if (this.myFileToDelete != null) {
                this.myFileToDelete.delete();
            }
        }
    }

    public static class AppletParameter {
        public String myName;
        public String myValue;

        public AppletParameter(@NonNls String name, String value) {
            this.myName = name;
            this.myValue = value;
        }

        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public String getValue() {
            return this.myValue;
        }

        public void setValue(String value) {
            this.myValue = value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AppletParameter)) {
                return false;
            }
            AppletParameter second = (AppletParameter)obj;
            return Comparing.equal((String)this.myName, (String)second.myName) && Comparing.equal((String)this.myValue, (String)second.myValue);
        }

        public int hashCode() {
            return Comparing.hashcode((Object)this.myName, (Object)this.myValue);
        }
    }
}

