/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.help.impl;

import com.intellij.CommonBundle;
import com.intellij.help.impl.IdeaHelpBroker;
import com.intellij.help.impl.MacHelpUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.HelpSetPath;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.reference.SoftReference;
import com.intellij.util.PlatformUtils;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.help.BadIDException;
import javax.help.HelpSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class HelpManagerImpl
extends HelpManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.help.impl.HelpManagerImpl");
    @NonNls
    private static final String HELP_HS = "Help.hs";
    private WeakReference<IdeaHelpBroker> myBrokerReference = null;

    public void invokeHelp(@Nullable String id) {
        HelpSet set;
        UsageTrigger.trigger("ide.help." + id);
        if (MacHelpUtil.isApplicable() && MacHelpUtil.invokeHelp(id)) {
            return;
        }
        IdeaHelpBroker broker = (IdeaHelpBroker)SoftReference.dereference(this.myBrokerReference);
        if (broker == null && (set = HelpManagerImpl.createHelpSet()) != null) {
            broker = new IdeaHelpBroker(set);
            this.myBrokerReference = new WeakReference<IdeaHelpBroker>(broker);
        }
        if (broker == null) {
            ApplicationInfoEx info = ApplicationInfoEx.getInstanceEx();
            String url = info.getWebHelpUrl() + "?";
            if (PlatformUtils.isCLion()) {
                url = url + "Keyword=" + id;
                url = url + "&ProductVersion=" + info.getMajorVersion() + "." + info.getMinorVersion();
                if (info.isEAP()) {
                    url = url + "&EAP";
                }
            } else {
                url = url + id;
            }
            BrowserUtil.browse((String)url);
            return;
        }
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        broker.setActivationWindow(activeWindow);
        if (id != null) {
            try {
                broker.setCurrentID(id);
            }
            catch (BadIDException e) {
                Messages.showErrorDialog((String)IdeBundle.message((String)"help.topic.not.found.error", (Object[])new Object[]{id}), (String)CommonBundle.getErrorTitle());
                return;
            }
        }
        broker.setDisplayed(true);
    }

    @Nullable
    private static HelpSet createHelpSet() {
        IdeaPluginDescriptor[] pluginDescriptors;
        String urlToHelp = ApplicationInfo.getInstance().getHelpURL() + "/" + HELP_HS;
        HelpSet mainHelpSet = HelpManagerImpl.loadHelpSet(urlToHelp);
        if (mainHelpSet == null) {
            return null;
        }
        for (IdeaPluginDescriptor pluginDescriptor : pluginDescriptors = PluginManagerCore.getPlugins()) {
            HelpSetPath[] sets;
            for (HelpSetPath hsPath : sets = pluginDescriptor.getHelpSets()) {
                HelpSet pluginHelpSet;
                String url = "jar:file:///" + pluginDescriptor.getPath().getAbsolutePath() + "/help/" + hsPath.getFile() + "!";
                if (!hsPath.getPath().startsWith("/")) {
                    url = url + "/";
                }
                if ((pluginHelpSet = HelpManagerImpl.loadHelpSet(url = url + hsPath.getPath())) == null) continue;
                mainHelpSet.add(pluginHelpSet);
            }
        }
        return mainHelpSet;
    }

    @Nullable
    private static HelpSet loadHelpSet(String url) {
        try {
            return new HelpSet(null, new URL(url));
        }
        catch (Exception e) {
            LOG.info("Failed to load help set from '" + url + "'", (Throwable)e);
            return null;
        }
    }
}

