/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;

public class GoToLinkTargetAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GoToLinkTargetAction", "update"));
        }
        Project project2 = GoToLinkTargetAction.getEventProject((AnActionEvent)e);
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(project2 != null && file2 != null && file2.is(VFileProperty.SYMLINK));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile target;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GoToLinkTargetAction", "actionPerformed"));
        }
        Project project2 = GoToLinkTargetAction.getEventProject((AnActionEvent)e);
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        if (project2 != null && file2 != null && file2.is(VFileProperty.SYMLINK) && (target = file2.getCanonicalFile()) != null) {
            PsiDirectory psiFile;
            PsiManager psiManager = PsiManager.getInstance((Project)project2);
            Object object = psiFile = target.isDirectory() ? psiManager.findDirectory(target) : psiManager.findFile(target);
            if (psiFile != null) {
                ProjectView.getInstance(project2).select(psiFile, target, false);
            }
        }
    }
}

