/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Composite;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSettingsUtilImpl
extends ShowSettingsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.ShowSettingsUtilImpl");
    private final AtomicBoolean myShown = new AtomicBoolean(false);

    @NotNull
    private static Project getProject(@Nullable Project project2) {
        Project project3 = project2 != null ? project2 : ProjectManager.getInstance().getDefaultProject();
        if (project3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getProject"));
        }
        return project3;
    }

    @NotNull
    public static DialogWrapper getDialog(@Nullable Project project2, @NotNull ConfigurableGroup[] groups, @Nullable Configurable toSelect) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getDialog"));
        }
        project2 = ShowSettingsUtilImpl.getProject(project2);
        ConfigurableGroup[] filteredGroups = ShowSettingsUtilImpl.filterEmptyGroups(groups);
        SettingsDialog settingsDialog = new SettingsDialog(project2, filteredGroups, toSelect, null);
        if (settingsDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getDialog"));
        }
        return settingsDialog;
    }

    @NotNull
    public static ConfigurableGroup[] getConfigurableGroups(@Nullable Project project2, boolean withIdeSettings) {
        if (!withIdeSettings) {
            project2 = ShowSettingsUtilImpl.getProject(project2);
        }
        ConfigurableGroup[] configurableGroupArray = new ConfigurableGroup[]{ConfigurableExtensionPointUtil.getConfigurableGroup(project2, withIdeSettings)};
        if (configurableGroupArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getConfigurableGroups"));
        }
        return configurableGroupArray;
    }

    @NotNull
    public static Configurable[] getConfigurables(@Nullable Project project2, boolean withGroupReverseOrder) {
        Configurable[] configurableArray = ShowSettingsUtilImpl.getConfigurables(ShowSettingsUtilImpl.getConfigurableGroups(project2, true), withGroupReverseOrder);
        if (configurableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getConfigurables"));
        }
        return configurableArray;
    }

    @NotNull
    private static Configurable[] getConfigurables(@NotNull ConfigurableGroup[] groups, boolean withGroupReverseOrder) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getConfigurables"));
        }
        Configurable[][] arrays = new Configurable[groups.length][];
        int length = 0;
        for (int i = 0; i < groups.length; ++i) {
            arrays[i] = groups[withGroupReverseOrder ? groups.length - 1 - i : i].getConfigurables();
            length += arrays[i].length;
        }
        Configurable[] configurables = new Configurable[length];
        int offset = 0;
        for (Configurable[] array : arrays) {
            System.arraycopy(array, 0, configurables, offset, array.length);
            offset += array.length;
        }
        if (configurables == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getConfigurables"));
        }
        return configurables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showSettingsDialog(@NotNull Project project2, @NotNull ConfigurableGroup[] group) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        try {
            this.myShown.set(true);
            ShowSettingsUtilImpl.getDialog(project2, group, null).show();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myShown.set(false);
        }
    }

    public void showSettingsDialog(@Nullable Project project2, Class configurableClass) {
        assert (Configurable.class.isAssignableFrom(configurableClass)) : "Not a configurable: " + configurableClass.getName();
        ConfigurableGroup[] groups = ShowSettingsUtilImpl.getConfigurableGroups(project2, true);
        Configurable config = new ConfigurableVisitor.ByType(configurableClass).find(groups);
        assert (config != null) : "Cannot find configurable: " + configurableClass.getName();
        ShowSettingsUtilImpl.getDialog(project2, groups, config).show();
    }

    public void showSettingsDialog(@Nullable Project project2, @NotNull String nameToSelect) {
        if (nameToSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameToSelect", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        ConfigurableGroup[] groups = ShowSettingsUtilImpl.getConfigurableGroups(project2, true);
        Project actualProject = ShowSettingsUtilImpl.getProject(project2);
        groups = ShowSettingsUtilImpl.filterEmptyGroups(groups);
        ShowSettingsUtilImpl.getDialog(actualProject, groups, ShowSettingsUtilImpl.findPreselectedByDisplayName(nameToSelect, groups)).show();
    }

    @Nullable
    private static Configurable findPreselectedByDisplayName(String preselectedConfigurableDisplayName, ConfigurableGroup[] groups) {
        List<Configurable> all = SearchUtil.expand(groups);
        for (Configurable each : all) {
            if (!preselectedConfigurableDisplayName.equals(each.getDisplayName())) continue;
            return each;
        }
        return null;
    }

    public static void showSettingsDialog(@Nullable Project project2, String id2Select, String filter) {
        ConfigurableGroup[] group = ShowSettingsUtilImpl.getConfigurableGroups(project2, true);
        group = ShowSettingsUtilImpl.filterEmptyGroups(group);
        Configurable configurable2Select = id2Select == null ? null : new ConfigurableVisitor.ByID(id2Select).find(group);
        new SettingsDialog(ShowSettingsUtilImpl.getProject(project2), group, configurable2Select, filter).show();
    }

    public void showSettingsDialog(@NotNull Project project2, Configurable toSelect) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        ShowSettingsUtilImpl.getDialog(project2, ShowSettingsUtilImpl.getConfigurableGroups(project2, true), toSelect).show();
    }

    @NotNull
    private static ConfigurableGroup[] filterEmptyGroups(@NotNull ConfigurableGroup[] group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/actions/ShowSettingsUtilImpl", "filterEmptyGroups"));
        }
        ArrayList<ConfigurableGroup> groups = new ArrayList<ConfigurableGroup>();
        for (ConfigurableGroup g : group) {
            if (g.getConfigurables().length <= 0) continue;
            groups.add(g);
        }
        ConfigurableGroup[] configurableGroupArray = groups.toArray(new ConfigurableGroup[groups.size()]);
        if (configurableGroupArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "filterEmptyGroups"));
        }
        return configurableGroupArray;
    }

    public boolean editConfigurable(Project project2, Configurable configurable) {
        return this.editConfigurable(project2, ShowSettingsUtilImpl.createDimensionKey(configurable), configurable);
    }

    public <T extends Configurable> T findApplicationConfigurable(Class<T> confClass) {
        return ConfigurableExtensionPointUtil.findApplicationConfigurable(confClass);
    }

    public <T extends Configurable> T findProjectConfigurable(Project project2, Class<T> confClass) {
        return ConfigurableExtensionPointUtil.findProjectConfigurable(project2, confClass);
    }

    public boolean editConfigurable(Project project2, String dimensionServiceKey, @NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        return this.editConfigurable(project2, dimensionServiceKey, configurable, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    private static boolean isWorthToShowApplyButton(@NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "isWorthToShowApplyButton"));
        }
        return configurable instanceof Place.Navigator || configurable instanceof Composite || configurable instanceof TabbedConfigurable;
    }

    public boolean editConfigurable(Project project2, String dimensionServiceKey, @NotNull Configurable configurable, boolean showApplyButton) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        return ShowSettingsUtilImpl.editConfigurable(null, project2, configurable, dimensionServiceKey, null, showApplyButton);
    }

    public boolean editConfigurable(Project project2, Configurable configurable, Runnable advancedInitialization) {
        return ShowSettingsUtilImpl.editConfigurable(null, project2, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        return this.editConfigurable(parent, configurable, null);
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable, @Nullable Runnable advancedInitialization) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    private static boolean editConfigurable(@Nullable Component parent, @Nullable Project project2, @NotNull Configurable configurable, String dimensionKey, final @Nullable Runnable advancedInitialization, boolean showApplyButton) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        SettingsDialog editor = parent == null ? new SettingsDialog(project2, dimensionKey, configurable, showApplyButton, false) : new SettingsDialog(parent, dimensionKey, configurable, showApplyButton, false);
        if (advancedInitialization != null) {
            new UiNotifyConnector.Once((Component)editor.getContentPane(), (Activatable)new Activatable.Adapter(){

                public void showNotify() {
                    advancedInitialization.run();
                }
            });
        }
        return editor.showAndGet();
    }

    @NotNull
    public static String createDimensionKey(@NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "createDimensionKey"));
        }
        String string = '#' + StringUtil.replaceChar((String)StringUtil.replaceChar((String)configurable.getDisplayName(), (char)'\n', (char)'_'), (char)' ', (char)'_');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "createDimensionKey"));
        }
        return string;
    }

    public boolean editConfigurable(Component parent, String dimensionServiceKey, Configurable configurable) {
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable, dimensionServiceKey, null, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    public boolean isAlreadyShown() {
        return this.myShown.get();
    }
}

