/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmarks.BookmarkItem;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.actions.BookmarksAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ListUtil;
import javax.swing.JList;

class MoveBookmarkDownAction
extends DumbAwareAction {
    private final Project myProject;
    private final JList myList;

    MoveBookmarkDownAction(Project project2, JList list) {
        super("Down", "Move current bookmark down", AllIcons.Actions.NextOccurence);
        this.myProject = project2;
        this.myList = list;
        this.registerCustomShortcutSet(CommonShortcuts.MOVE_DOWN, list);
    }

    public void update(AnActionEvent e) {
        int modelSize = this.myList.getModel().getSize();
        if (modelSize == 0 || !BookmarksAction.notFiltered(this.myList) || UISettings.getInstance().SORT_BOOKMARKS) {
            e.getPresentation().setEnabled(false);
        } else {
            int lastIndex = modelSize - 1;
            if (!(this.myList.getModel().getElementAt(lastIndex) instanceof BookmarkItem)) {
                --lastIndex;
            }
            e.getPresentation().setEnabled(BookmarksAction.getSelectedBookmarks(this.myList).size() == 1 && this.myList.getSelectedIndex() < lastIndex);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        ListUtil.moveSelectedItemsDown((JList)this.myList);
        BookmarkManager.getInstance(this.myProject).moveBookmarkDown(BookmarksAction.getSelectedBookmarks(this.myList).get(0));
    }
}

