/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;

public class ProjectPaneSelectInTarget
extends ProjectViewSelectInTarget
implements DumbAware {
    public ProjectPaneSelectInTarget(Project project2) {
        super(project2);
    }

    @Override
    public String toString() {
        return SelectInManager.PROJECT;
    }

    @Override
    public boolean canSelect(PsiFileSystemItem file2) {
        return super.canSelect(file2) && this.canSelect(file2.getVirtualFile());
    }

    @Override
    public boolean isSubIdSelectable(String subId, SelectInContext context) {
        return this.canSelect(context);
    }

    private boolean canSelect(VirtualFile vFile) {
        if (vFile != null && vFile.isValid()) {
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            if (index.getContentRootForFile(vFile, false) != null) {
                return true;
            }
            if (index.isInLibraryClasses(vFile) || index.isInLibrarySource(vFile)) {
                return true;
            }
            return Comparing.equal((Object)vFile.getParent(), (Object)this.myProject.getBaseDir());
        }
        return false;
    }

    public String getMinorViewId() {
        return "ProjectPane";
    }

    public float getWeight() {
        return 1.0f;
    }

    @Override
    protected boolean canWorkWithCustomObjects() {
        return false;
    }
}

