/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.StructureViewElementWrapper;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class StructureViewModelWrapper
implements StructureViewModel {
    private final StructureViewModel myStructureViewModel;
    private final PsiFile myMainFile;

    public StructureViewModelWrapper(StructureViewModel structureViewModel, PsiFile mainFile) {
        this.myStructureViewModel = structureViewModel;
        this.myMainFile = mainFile;
    }

    public Object getCurrentEditorElement() {
        return this.myStructureViewModel.getCurrentEditorElement();
    }

    public void addEditorPositionListener(@NotNull FileEditorPositionListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/structureView/impl/StructureViewModelWrapper", "addEditorPositionListener"));
        }
        this.myStructureViewModel.addEditorPositionListener(listener2);
    }

    public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/structureView/impl/StructureViewModelWrapper", "removeEditorPositionListener"));
        }
        this.myStructureViewModel.removeEditorPositionListener(listener2);
    }

    public void addModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelListener", "com/intellij/ide/structureView/impl/StructureViewModelWrapper", "addModelListener"));
        }
        this.myStructureViewModel.addModelListener(modelListener);
    }

    public void removeModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelListener", "com/intellij/ide/structureView/impl/StructureViewModelWrapper", "removeModelListener"));
        }
        this.myStructureViewModel.removeModelListener(modelListener);
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        StructureViewElementWrapper structureViewElementWrapper = new StructureViewElementWrapper(this.myStructureViewModel.getRoot(), this.myMainFile);
        if (structureViewElementWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewModelWrapper", "getRoot"));
        }
        return structureViewElementWrapper;
    }

    public void dispose() {
        this.myStructureViewModel.dispose();
    }

    public boolean shouldEnterElement(Object element) {
        return false;
    }

    @NotNull
    public Grouper[] getGroupers() {
        Grouper[] grouperArray = this.myStructureViewModel.getGroupers();
        if (grouperArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewModelWrapper", "getGroupers"));
        }
        return grouperArray;
    }

    @NotNull
    public Sorter[] getSorters() {
        Sorter[] sorterArray = this.myStructureViewModel.getSorters();
        if (sorterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewModelWrapper", "getSorters"));
        }
        return sorterArray;
    }

    @NotNull
    public Filter[] getFilters() {
        Filter[] filterArray = this.myStructureViewModel.getFilters();
        if (filterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewModelWrapper", "getFilters"));
        }
        return filterArray;
    }
}

