/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.DataManager;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandMerger;
import com.intellij.openapi.command.impl.CurrentEditorProvider;
import com.intellij.openapi.command.impl.DocumentUndoProvider;
import com.intellij.openapi.command.impl.DummyProject;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.FocusBasedCurrentEditorProvider;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.UndoProvider;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.DocumentReferenceProvider;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UndoManagerImpl
extends UndoManager
implements ProjectComponent,
ApplicationComponent,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.command.impl.UndoManagerImpl");
    private static final int COMMANDS_TO_KEEP_LIVE_QUEUES = 100;
    private static final int COMMAND_TO_RUN_COMPACT = 20;
    private static final int FREE_QUEUES_LIMIT = 30;
    @Nullable
    private final ProjectEx myProject;
    private final CommandProcessor myCommandProcessor;
    private final StartupManager myStartupManager;
    private UndoProvider[] myUndoProviders;
    private CurrentEditorProvider myEditorProvider;
    private final UndoRedoStacksHolder myUndoStacksHolder = new UndoRedoStacksHolder(true);
    private final UndoRedoStacksHolder myRedoStacksHolder = new UndoRedoStacksHolder(false);
    private final CommandMerger myMerger;
    private CommandMerger myCurrentMerger;
    private Project myCurrentActionProject = DummyProject.getInstance();
    private int myCommandTimestamp = 1;
    private int myCommandLevel;
    private static final int NONE = 0;
    private static final int UNDO = 1;
    private static final int REDO = 2;
    private int myCurrentOperationState = 0;
    private DocumentReference myOriginatorReference;

    public static boolean isRefresh() {
        return ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.class);
    }

    public static int getGlobalUndoLimit() {
        return Registry.intValue((String)"undo.globalUndoLimit");
    }

    public static int getDocumentUndoLimit() {
        return Registry.intValue((String)"undo.documentUndoLimit");
    }

    public UndoManagerImpl(Application application, CommandProcessor commandProcessor) {
        this(application, null, commandProcessor, null);
    }

    public UndoManagerImpl(Application application, @Nullable ProjectEx project2, CommandProcessor commandProcessor, StartupManager startupManager) {
        this.myProject = project2;
        this.myCommandProcessor = commandProcessor;
        this.myStartupManager = startupManager;
        this.init(application);
        this.myMerger = new CommandMerger(this);
    }

    private void init(@NotNull Application application) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "com/intellij/openapi/command/impl/UndoManagerImpl", "init"));
        }
        if (this.myProject == null || application.isUnitTestMode() && !this.myProject.isDefault()) {
            this.initialize();
        }
    }

    @NotNull
    public String getComponentName() {
        if ("UndoManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoManagerImpl", "getComponentName"));
        }
        return "UndoManager";
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public void initComponent() {
    }

    public void projectOpened() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.initialize();
        }
    }

    public void projectClosed() {
    }

    public void disposeComponent() {
    }

    public void dispose() {
    }

    private void initialize() {
        if (this.myProject == null) {
            this.runStartupActivity();
        } else {
            this.myStartupManager.registerStartupActivity(new Runnable(){

                @Override
                public void run() {
                    UndoManagerImpl.this.runStartupActivity();
                }
            });
        }
    }

    private void runStartupActivity() {
        this.myEditorProvider = new FocusBasedCurrentEditorProvider();
        CommandAdapter commandListener = new CommandAdapter(){
            private boolean myStarted;

            public void commandStarted(CommandEvent event) {
                UndoManagerImpl.this.onCommandStarted(event.getProject(), event.getUndoConfirmationPolicy());
            }

            public void commandFinished(CommandEvent event) {
                UndoManagerImpl.this.onCommandFinished(event.getProject(), event.getCommandName(), event.getCommandGroupId());
            }

            public void undoTransparentActionStarted() {
                if (!UndoManagerImpl.this.isInsideCommand()) {
                    this.myStarted = true;
                    UndoManagerImpl.this.onCommandStarted(UndoManagerImpl.this.myProject, UndoConfirmationPolicy.DEFAULT);
                }
            }

            public void undoTransparentActionFinished() {
                if (this.myStarted) {
                    this.myStarted = false;
                    UndoManagerImpl.this.onCommandFinished(UndoManagerImpl.this.myProject, "", null);
                }
            }
        };
        this.myCommandProcessor.addCommandListener((CommandListener)commandListener, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)new DocumentUndoProvider(this.myProject));
        for (UndoProvider undoProvider : this.myUndoProviders = this.myProject == null ? (UndoProvider[])Extensions.getExtensions(UndoProvider.EP_NAME) : (UndoProvider[])Extensions.getExtensions(UndoProvider.PROJECT_EP_NAME, (AreaInstance)this.myProject)) {
            if (!(undoProvider instanceof Disposable)) continue;
            Disposer.register((Disposable)this, (Disposable)((Disposable)undoProvider));
        }
    }

    public boolean isActive() {
        return Comparing.equal((Object)this.myProject, (Object)this.myCurrentActionProject);
    }

    private boolean isInsideCommand() {
        return this.myCommandLevel > 0;
    }

    private void onCommandStarted(Project project2, UndoConfirmationPolicy undoConfirmationPolicy) {
        if (this.myCommandLevel == 0) {
            for (UndoProvider undoProvider : this.myUndoProviders) {
                undoProvider.commandStarted(project2);
            }
            this.myCurrentActionProject = project2;
        }
        this.commandStarted(undoConfirmationPolicy, this.myProject == project2);
        LOG.assertTrue(this.myCommandLevel == 0 || !(this.myCurrentActionProject instanceof DummyProject));
    }

    private void onCommandFinished(Project project2, String commandName, Object commandGroupId) {
        this.commandFinished(commandName, commandGroupId);
        if (this.myCommandLevel == 0) {
            for (UndoProvider undoProvider : this.myUndoProviders) {
                undoProvider.commandFinished(project2);
            }
            this.myCurrentActionProject = DummyProject.getInstance();
        }
        LOG.assertTrue(this.myCommandLevel == 0 || !(this.myCurrentActionProject instanceof DummyProject));
    }

    private void commandStarted(UndoConfirmationPolicy undoConfirmationPolicy, boolean recordOriginalReference) {
        if (this.myCommandLevel == 0) {
            this.myCurrentMerger = new CommandMerger(this, CommandProcessor.getInstance().isUndoTransparentActionInProgress());
            if (recordOriginalReference && this.myProject != null) {
                Editor editor = null;
                Application application = ApplicationManager.getApplication();
                if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
                    editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext());
                } else {
                    Component component = WindowManagerEx.getInstanceEx().getFocusedComponent(this.myProject);
                    if (component != null) {
                        editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext(component));
                    }
                }
                if (editor != null) {
                    Document document = editor.getDocument();
                    VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
                    if (file2 != null && file2.isValid()) {
                        this.myOriginatorReference = DocumentReferenceManager.getInstance().create(file2);
                    }
                }
            }
        }
        LOG.assertTrue(this.myCurrentMerger != null, (Object)String.valueOf(this.myCommandLevel));
        this.myCurrentMerger.setBeforeState(this.getCurrentState());
        this.myCurrentMerger.mergeUndoConfirmationPolicy(undoConfirmationPolicy);
        ++this.myCommandLevel;
    }

    private void commandFinished(String commandName, Object groupId) {
        if (this.myCommandLevel == 0) {
            return;
        }
        --this.myCommandLevel;
        if (this.myCommandLevel > 0) {
            return;
        }
        if (this.myProject != null && this.myCurrentMerger.hasActions() && !this.myCurrentMerger.isTransparent() && this.myCurrentMerger.isPhysical()) {
            this.addFocusedDocumentAsAffected();
        }
        this.myOriginatorReference = null;
        this.myCurrentMerger.setAfterState(this.getCurrentState());
        this.myMerger.commandFinished(commandName, groupId, this.myCurrentMerger);
        this.disposeCurrentMerger();
    }

    private void addFocusedDocumentAsAffected() {
        if (this.myOriginatorReference == null || this.myCurrentMerger.hasChangesOf(this.myOriginatorReference, true)) {
            return;
        }
        final DocumentReference[] refs = new DocumentReference[]{this.myOriginatorReference};
        this.myCurrentMerger.addAction((UndoableAction)new BasicUndoableAction(){

            public void undo() throws UnexpectedUndoException {
            }

            public void redo() throws UnexpectedUndoException {
            }

            public DocumentReference[] getAffectedDocuments() {
                return refs;
            }
        });
    }

    private EditorAndState getCurrentState() {
        FileEditor editor = this.myEditorProvider.getCurrentEditor();
        if (editor == null) {
            return null;
        }
        if (Registry.is((String)"editor.new.rendering") && !editor.isValid()) {
            return null;
        }
        return new EditorAndState(editor, editor.getState(FileEditorStateLevel.UNDO));
    }

    private void disposeCurrentMerger() {
        LOG.assertTrue(this.myCommandLevel == 0);
        if (this.myCurrentMerger != null) {
            this.myCurrentMerger = null;
        }
    }

    public void nonundoableActionPerformed(@NotNull DocumentReference ref, boolean isGlobal) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/openapi/command/impl/UndoManagerImpl", "nonundoableActionPerformed"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.undoableActionPerformed(new NonUndoableAction(ref, isGlobal));
    }

    public void undoableActionPerformed(@NotNull UndoableAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/command/impl/UndoManagerImpl", "undoableActionPerformed"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myCurrentOperationState != 0) {
            return;
        }
        if (this.myCommandLevel == 0) {
            LOG.assertTrue(action instanceof NonUndoableAction, (Object)"Undoable actions allowed inside commands only (see com.intellij.openapi.command.CommandProcessor.executeCommand())");
            this.commandStarted(UndoConfirmationPolicy.DEFAULT, false);
            this.myCurrentMerger.addAction(action);
            this.commandFinished("", null);
            return;
        }
        if (UndoManagerImpl.isRefresh()) {
            this.myOriginatorReference = null;
        }
        this.myCurrentMerger.addAction(action);
    }

    public void markCurrentCommandAsGlobal() {
        this.myCurrentMerger.markAsGlobal();
    }

    void addAffectedDocuments(Document ... docs) {
        if (docs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docs", "com/intellij/openapi/command/impl/UndoManagerImpl", "addAffectedDocuments"));
        }
        if (!this.isInsideCommand()) {
            LOG.error("Must be called inside command");
            return;
        }
        ArrayList<DocumentReference> refs = new ArrayList<DocumentReference>(docs.length);
        for (Document each : docs) {
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(each);
            if (file2 != null && !file2.isValid()) continue;
            refs.add(DocumentReferenceManager.getInstance().create(each));
        }
        this.myCurrentMerger.addAdditionalAffectedDocuments(refs);
    }

    public void addAffectedFiles(VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/command/impl/UndoManagerImpl", "addAffectedFiles"));
        }
        if (!this.isInsideCommand()) {
            LOG.error("Must be called inside command");
            return;
        }
        ArrayList<DocumentReference> refs = new ArrayList<DocumentReference>(files.length);
        for (VirtualFile each : files) {
            refs.add(DocumentReferenceManager.getInstance().create(each));
        }
        this.myCurrentMerger.addAdditionalAffectedDocuments(refs);
    }

    public void invalidateActionsFor(@NotNull DocumentReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/openapi/command/impl/UndoManagerImpl", "invalidateActionsFor"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myMerger.invalidateActionsFor(ref);
        if (this.myCurrentMerger != null) {
            this.myCurrentMerger.invalidateActionsFor(ref);
        }
        this.myUndoStacksHolder.invalidateActionsFor(ref);
        this.myRedoStacksHolder.invalidateActionsFor(ref);
    }

    public void undo(@Nullable FileEditor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.isUndoAvailable(editor));
        this.undoOrRedo(editor, true);
    }

    public void redo(@Nullable FileEditor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.isRedoAvailable(editor));
        this.undoOrRedo(editor, false);
    }

    private void undoOrRedo(final FileEditor editor, final boolean isUndo) {
        this.myCurrentOperationState = isUndo ? 1 : 2;
        final RuntimeException[] exception = new RuntimeException[1];
        Runnable executeUndoOrRedoAction = new Runnable(){

            @Override
            public void run() {
                try {
                    if (UndoManagerImpl.this.myProject != null) {
                        PsiDocumentManager.getInstance((Project)UndoManagerImpl.this.myProject).commitAllDocuments();
                    }
                    CopyPasteManager.getInstance().stopKillRings();
                    UndoManagerImpl.this.myMerger.undoOrRedo(editor, isUndo);
                }
                catch (RuntimeException ex) {
                    exception[0] = ex;
                }
                finally {
                    UndoManagerImpl.this.myCurrentOperationState = 0;
                }
            }
        };
        String name = (String)this.getUndoOrRedoActionNameAndDescription((FileEditor)editor, (boolean)this.isUndoInProgress()).second;
        CommandProcessor.getInstance().executeCommand((Project)this.myProject, executeUndoOrRedoAction, name, null, this.myMerger.getUndoConfirmationPolicy());
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    public boolean isUndoInProgress() {
        return this.myCurrentOperationState == 1;
    }

    public boolean isRedoInProgress() {
        return this.myCurrentOperationState == 2;
    }

    public boolean isUndoAvailable(@Nullable FileEditor editor) {
        return this.isUndoOrRedoAvailable(editor, true);
    }

    public boolean isRedoAvailable(@Nullable FileEditor editor) {
        return this.isUndoOrRedoAvailable(editor, false);
    }

    boolean isUndoOrRedoAvailable(@Nullable FileEditor editor, boolean undo) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Collection<DocumentReference> refs = UndoManagerImpl.getDocRefs(editor);
        return refs != null && this.isUndoOrRedoAvailable(refs, undo);
    }

    boolean isUndoOrRedoAvailable(@NotNull DocumentReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/openapi/command/impl/UndoManagerImpl", "isUndoOrRedoAvailable"));
        }
        Set<DocumentReference> refs = Collections.singleton(ref);
        return this.isUndoOrRedoAvailable(refs, true) || this.isUndoOrRedoAvailable(refs, false);
    }

    private boolean isUndoOrRedoAvailable(@NotNull Collection<DocumentReference> refs, boolean isUndo) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/openapi/command/impl/UndoManagerImpl", "isUndoOrRedoAvailable"));
        }
        if (isUndo && this.myMerger.isUndoAvailable(refs)) {
            return true;
        }
        UndoRedoStacksHolder stackHolder = this.getStackHolder(isUndo);
        return stackHolder.canBeUndoneOrRedone(refs);
    }

    private static Collection<DocumentReference> getDocRefs(@Nullable FileEditor editor) {
        if (editor instanceof TextEditor && ((TextEditor)editor).getEditor().isViewer()) {
            return null;
        }
        if (editor == null) {
            return Collections.emptyList();
        }
        return UndoManagerImpl.getDocumentReferences(editor);
    }

    @NotNull
    static Set<DocumentReference> getDocumentReferences(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/command/impl/UndoManagerImpl", "getDocumentReferences"));
        }
        THashSet result = new THashSet();
        if (editor instanceof DocumentReferenceProvider) {
            result.addAll(((DocumentReferenceProvider)editor).getDocumentReferences());
            THashSet tHashSet = result;
            if (tHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoManagerImpl", "getDocumentReferences"));
            }
            return tHashSet;
        }
        Document[] documents = TextEditorProvider.getDocuments(editor);
        if (documents != null) {
            for (Document each : documents) {
                Document original = UndoManagerImpl.getOriginal(each);
                VirtualFile f = FileDocumentManager.getInstance().getFile(each);
                if (f != null && !f.isValid()) continue;
                result.add(DocumentReferenceManager.getInstance().create(original));
            }
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoManagerImpl", "getDocumentReferences"));
        }
        return tHashSet;
    }

    @NotNull
    private UndoRedoStacksHolder getStackHolder(boolean isUndo) {
        UndoRedoStacksHolder undoRedoStacksHolder = isUndo ? this.myUndoStacksHolder : this.myRedoStacksHolder;
        if (undoRedoStacksHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoManagerImpl", "getStackHolder"));
        }
        return undoRedoStacksHolder;
    }

    @NotNull
    public Pair<String, String> getUndoActionNameAndDescription(FileEditor editor) {
        Pair<String, String> pair = this.getUndoOrRedoActionNameAndDescription(editor, true);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoManagerImpl", "getUndoActionNameAndDescription"));
        }
        return pair;
    }

    @NotNull
    public Pair<String, String> getRedoActionNameAndDescription(FileEditor editor) {
        Pair<String, String> pair = this.getUndoOrRedoActionNameAndDescription(editor, false);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoManagerImpl", "getRedoActionNameAndDescription"));
        }
        return pair;
    }

    @NotNull
    private Pair<String, String> getUndoOrRedoActionNameAndDescription(FileEditor editor, boolean undo) {
        String desc;
        String string = desc = this.isUndoOrRedoAvailable(editor, undo) ? this.doFormatAvailableUndoRedoAction(editor, undo) : null;
        if (desc == null) {
            desc = "";
        }
        String shortActionName = StringUtil.first((String)desc, (int)30, (boolean)true);
        if (desc.isEmpty()) {
            desc = undo ? ActionsBundle.message((String)"action.undo.description.empty", (Object[])new Object[0]) : ActionsBundle.message((String)"action.redo.description.empty", (Object[])new Object[0]);
        }
        Pair pair = Pair.create((Object)(undo ? ActionsBundle.message((String)"action.undo.text", (Object[])new Object[]{shortActionName}) : ActionsBundle.message((String)"action.redo.text", (Object[])new Object[]{shortActionName})).trim(), (Object)(undo ? ActionsBundle.message((String)"action.undo.description", (Object[])new Object[]{desc}) : ActionsBundle.message((String)"action.redo.description", (Object[])new Object[]{desc})).trim());
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoManagerImpl", "getUndoOrRedoActionNameAndDescription"));
        }
        return pair;
    }

    @Nullable
    private String doFormatAvailableUndoRedoAction(FileEditor editor, boolean isUndo) {
        Collection<DocumentReference> refs = UndoManagerImpl.getDocRefs(editor);
        if (refs == null) {
            return null;
        }
        if (isUndo && this.myMerger.isUndoAvailable(refs)) {
            return this.myMerger.getCommandName();
        }
        return this.getStackHolder(isUndo).getLastAction(refs).getCommandName();
    }

    @NotNull
    UndoRedoStacksHolder getUndoStacksHolder() {
        UndoRedoStacksHolder undoRedoStacksHolder = this.myUndoStacksHolder;
        if (undoRedoStacksHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoManagerImpl", "getUndoStacksHolder"));
        }
        return undoRedoStacksHolder;
    }

    @NotNull
    UndoRedoStacksHolder getRedoStacksHolder() {
        UndoRedoStacksHolder undoRedoStacksHolder = this.myRedoStacksHolder;
        if (undoRedoStacksHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoManagerImpl", "getRedoStacksHolder"));
        }
        return undoRedoStacksHolder;
    }

    int nextCommandTimestamp() {
        return ++this.myCommandTimestamp;
    }

    @NotNull
    private static Document getOriginal(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/command/impl/UndoManagerImpl", "getOriginal"));
        }
        Document result = (Document)document.getUserData(ORIGINAL_DOCUMENT);
        Document document2 = result == null ? document : result;
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoManagerImpl", "getOriginal"));
        }
        return document2;
    }

    static boolean isCopy(@NotNull Document d) {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/intellij/openapi/command/impl/UndoManagerImpl", "isCopy"));
        }
        return d.getUserData(ORIGINAL_DOCUMENT) != null;
    }

    protected void compact() {
        if (this.myCurrentOperationState == 0 && this.myCommandTimestamp % 20 == 0) {
            this.doCompact();
        }
    }

    private void doCompact() {
        DocumentReference each;
        Collection<DocumentReference> refs = this.collectReferencesWithoutMergers();
        HashSet openDocs = new HashSet();
        for (DocumentReference each2 : refs) {
            VirtualFile file2 = each2.getFile();
            if (file2 == null) {
                Document document = each2.getDocument();
                if (document == null || EditorFactory.getInstance().getEditors(document, (Project)this.myProject).length <= 0) continue;
                openDocs.add(each2);
                continue;
            }
            if (this.myProject == null || !FileEditorManager.getInstance((Project)this.myProject).isFileOpen(file2)) continue;
            openDocs.add(each2);
        }
        refs.removeAll((Collection<?>)openDocs);
        if (refs.size() <= 30) {
            return;
        }
        DocumentReference[] backSorted = refs.toArray(new DocumentReference[refs.size()]);
        Arrays.sort(backSorted, new Comparator<DocumentReference>(){

            @Override
            public int compare(DocumentReference a, DocumentReference b) {
                return UndoManagerImpl.this.getLastCommandTimestamp(a) - UndoManagerImpl.this.getLastCommandTimestamp(b);
            }
        });
        for (int i = 0; i < backSorted.length - 30 && this.getLastCommandTimestamp(each = backSorted[i]) + 100 <= this.myCommandTimestamp; ++i) {
            this.clearUndoRedoQueue(each);
        }
    }

    private int getLastCommandTimestamp(@NotNull DocumentReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/openapi/command/impl/UndoManagerImpl", "getLastCommandTimestamp"));
        }
        return Math.max(this.myUndoStacksHolder.getLastCommandTimestamp(ref), this.myRedoStacksHolder.getLastCommandTimestamp(ref));
    }

    @NotNull
    private Collection<DocumentReference> collectReferencesWithoutMergers() {
        THashSet result = new THashSet();
        this.myUndoStacksHolder.collectAllAffectedDocuments((Collection<DocumentReference>)result);
        this.myRedoStacksHolder.collectAllAffectedDocuments((Collection<DocumentReference>)result);
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoManagerImpl", "collectReferencesWithoutMergers"));
        }
        return tHashSet;
    }

    private void clearUndoRedoQueue(@NotNull DocumentReference docRef) {
        if (docRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docRef", "com/intellij/openapi/command/impl/UndoManagerImpl", "clearUndoRedoQueue"));
        }
        this.myMerger.flushCurrentCommand();
        this.disposeCurrentMerger();
        this.myUndoStacksHolder.clearStacks(false, Collections.singleton(docRef));
        this.myRedoStacksHolder.clearStacks(false, Collections.singleton(docRef));
    }

    public void setEditorProvider(@NotNull CurrentEditorProvider p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/command/impl/UndoManagerImpl", "setEditorProvider"));
        }
        this.myEditorProvider = p;
    }

    @NotNull
    public CurrentEditorProvider getEditorProvider() {
        CurrentEditorProvider currentEditorProvider = this.myEditorProvider;
        if (currentEditorProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoManagerImpl", "getEditorProvider"));
        }
        return currentEditorProvider;
    }

    public void dropHistoryInTests() {
        this.flushMergers();
        LOG.assertTrue(this.myCommandLevel == 0);
        this.myUndoStacksHolder.clearAllStacksInTests();
        this.myRedoStacksHolder.clearAllStacksInTests();
    }

    private void flushMergers() {
        CommandProcessor.getInstance().executeCommand((Project)this.myProject, EmptyRunnable.getInstance(), CommonBundle.message((String)"drop.undo.history.command.name", (Object[])new Object[0]), null);
    }

    public void flushCurrentCommandMerger() {
        this.myMerger.flushCurrentCommand();
    }

    public void clearUndoRedoQueueInTests(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/command/impl/UndoManagerImpl", "clearUndoRedoQueueInTests"));
        }
        this.clearUndoRedoQueue(DocumentReferenceManager.getInstance().create(file2));
    }

    public void clearUndoRedoQueueInTests(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/command/impl/UndoManagerImpl", "clearUndoRedoQueueInTests"));
        }
        this.clearUndoRedoQueue(DocumentReferenceManager.getInstance().create(document));
    }
}

