/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.ui.SimpleTextAttributes;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Hyperlink {
    @Nullable
    private final Icon myIcon;
    @NotNull
    private final String linkText;
    @NotNull
    private final SimpleTextAttributes textAttributes;

    protected Hyperlink(@NotNull String linkText) {
        if (linkText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkText", "com/intellij/openapi/keymap/impl/ui/Hyperlink", "<init>"));
        }
        this(null, linkText, SimpleTextAttributes.LINK_ATTRIBUTES);
    }

    protected Hyperlink(@Nullable Icon icon, @NotNull String linkText) {
        if (linkText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkText", "com/intellij/openapi/keymap/impl/ui/Hyperlink", "<init>"));
        }
        this(icon, linkText, SimpleTextAttributes.LINK_ATTRIBUTES);
    }

    protected Hyperlink(@Nullable Icon icon, @NotNull String linkText, @NotNull SimpleTextAttributes textAttributes) {
        if (linkText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkText", "com/intellij/openapi/keymap/impl/ui/Hyperlink", "<init>"));
        }
        if (textAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textAttributes", "com/intellij/openapi/keymap/impl/ui/Hyperlink", "<init>"));
        }
        this.myIcon = icon;
        this.linkText = linkText;
        this.textAttributes = textAttributes;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public String getLinkText() {
        String string = this.linkText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/Hyperlink", "getLinkText"));
        }
        return string;
    }

    @NotNull
    public SimpleTextAttributes getTextAttributes() {
        SimpleTextAttributes simpleTextAttributes = this.textAttributes;
        if (simpleTextAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/Hyperlink", "getTextAttributes"));
        }
        return simpleTextAttributes;
    }

    public abstract void onClick(MouseEvent var1);
}

