/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbPermissionService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumbPermissionServiceImpl
implements DumbPermissionService {
    private final ThreadLocal<DumbModePermission> myPermission = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allowStartingDumbModeInside(@NotNull DumbModePermission permission, @NotNull Runnable runnable2) {
        if (permission == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permission", "com/intellij/openapi/project/DumbPermissionServiceImpl", "allowStartingDumbModeInside"));
        }
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/project/DumbPermissionServiceImpl", "allowStartingDumbModeInside"));
        }
        DumbModePermission prev = this.myPermission.get();
        if (prev == DumbModePermission.MAY_START_MODAL && permission == DumbModePermission.MAY_START_BACKGROUND) {
            runnable2.run();
            return;
        }
        this.myPermission.set(permission);
        try {
            runnable2.run();
        }
        finally {
            if (prev == null) {
                this.myPermission.remove();
            } else {
                this.myPermission.set(prev);
            }
        }
    }

    @Nullable
    public DumbModePermission getPermission() {
        return this.myPermission.get();
    }
}

