/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateResult;
import com.intellij.openapi.updateSettings.impl.NewChannelDialog;
import com.intellij.openapi.updateSettings.impl.NoUpdatesDialog;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.swing.event.HyperlinkEvent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001uB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004H\u0007JF\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020'2\u0006\u00102\u001a\u0002032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020'052\u000e\u00107\u001a\n\u0012\u0004\u0012\u000209\u0018\u0001082\b\u0010:\u001a\u0004\u0018\u00010;H\u0007J\u0010\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020>H\u0007J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J<\u0010C\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010D2\u0006\u0010E\u001a\u00020B2\b\u0010:\u001a\u0004\u0018\u00010;2\u000e\u00107\u001a\n\u0012\u0004\u0012\u000209\u0018\u0001082\b\u0010F\u001a\u0004\u0018\u00010GH\u0002J\u0014\u0010H\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020905H\u0002J>\u0010I\u001a\u00020-2\b\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u00020#2\u0006\u0010M\u001a\u00020#2\u0006\u0010E\u001a\u00020B2\b\u0010:\u001a\u0004\u0018\u00010;2\b\u0010N\u001a\u0004\u0018\u00010OH\u0002J(\u0010P\u001a\u00020-2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020G2\u0006\u0010T\u001a\u00020#2\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010U\u001a\u00020\u0004H\u0002J\u0010\u0010V\u001a\u00020\u00042\u0006\u0010W\u001a\u00020XH\u0007J\u0012\u0010Y\u001a\u0004\u0018\u00010\u00042\u0006\u0010W\u001a\u00020XH\u0002J \u0010Z\u001a\u00020-2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020G2\u0006\u0010T\u001a\u00020#H\u0007J\u001e\u0010[\u001a\u00020#2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020'0D2\u0006\u0010:\u001a\u00020;H\u0007J\u0010\u0010]\u001a\u00020#2\u0006\u0010^\u001a\u00020\u0004H\u0002J\u0018\u0010_\u001a\u00020#2\u0006\u0010J\u001a\u00020K2\u0006\u0010^\u001a\u00020\u0004H\u0002J\u0012\u0010`\u001a\u00020#2\b\u0010a\u001a\u0004\u0018\u00010bH\u0003J\u0010\u0010c\u001a\u00020-2\u0006\u0010d\u001a\u00020eH\u0002J\b\u0010f\u001a\u00020-H\u0007J\u0018\u0010g\u001a\u00020-2\u0006\u0010h\u001a\u00020#2\u0006\u0010i\u001a\u00020\u0004H\u0002J0\u0010j\u001a\u00020-2\b\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010i\u001a\u00020\u00042\f\u0010k\u001a\b\u0012\u0004\u0012\u00020-0l2\u0006\u0010m\u001a\u00020%H\u0002JR\u0010n\u001a\u00020-2\b\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010o\u001a\u00020@2\u0006\u0010E\u001a\u00020B2\u000e\u0010p\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010D2\u000e\u00107\u001a\n\u0012\u0004\u0012\u000209\u0018\u00010D2\u0006\u0010q\u001a\u00020#2\u0006\u0010r\u001a\u00020#H\u0002J\b\u0010s\u001a\u00020OH\u0007J\u001c\u0010s\u001a\u00020-2\b\u0010J\u001a\u0004\u0018\u00010K2\b\u0010t\u001a\u0004\u0018\u00010BH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\n \b*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\rR\"\u0010\u0012\u001a\n \b*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\rR \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00168FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010$\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010%0% \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010%0%\u0018\u00010\u00160!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020'0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\rR\u0014\u0010*\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\r\u00a8\u0006v"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker;", "", "()V", "DISABLED_UPDATE", "", "INSTALLATION_UID", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.jvm.PlatformType", "NOTIFICATIONS", "Lcom/intellij/notification/NotificationGroup;", "NO_PLATFORM_UPDATE", "getNO_PLATFORM_UPDATE", "()Ljava/lang/String;", "PATCHES_URL", "getPATCHES_URL", "PATCHES_URL$delegate", "Lkotlin/Lazy;", "UPDATE_URL", "getUPDATE_URL", "UPDATE_URL$delegate", "disabledToUpdatePlugins", "", "disabledToUpdatePlugins$annotations", "getDisabledToUpdatePlugins", "()Ljava/util/Set;", "excludedFromUpdateCheckPlugins", "Ljava/util/HashSet;", "getExcludedFromUpdateCheckPlugins", "()Ljava/util/HashSet;", "ourAdditionalRequestOptions", "Ljava/util/HashMap;", "ourDisabledToUpdatePlugins", "", "ourHasFailedPlugins", "", "ourShownNotificationTypes", "Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$NotificationUniqueType;", "ourUpdatedPlugins", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "patchesUrl", "getPatchesUrl", "updateUrl", "getUpdateUrl", "addUpdateRequestParameter", "", "name", "value", "checkAndPrepareToInstall", "downloader", "state", "Lcom/intellij/ide/plugins/InstalledPluginsState;", "toUpdate", "", "Lcom/intellij/openapi/extensions/PluginId;", "incompatiblePlugins", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "checkForUpdate", "event", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "checkPlatformUpdate", "Lcom/intellij/openapi/updateSettings/impl/CheckForUpdateResult;", "settings", "Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;", "checkPluginsUpdate", "", "updateSettings", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "collectUpdateablePlugins", "doUpdateAndShowResult", "project", "Lcom/intellij/openapi/project/Project;", "fromSettings", "manualCheck", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "downloadAndInstallPatch", "patch", "Lcom/intellij/openapi/updateSettings/impl/PatchInfo;", "toBuild", "forceHttps", "generateUUID", "getInstallationUID", "propertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "getInstallationUIDOnWindows", "installPlatformUpdate", "installPluginUpdates", "downloaders", "isRequiredForAnyOpenProject", "pluginId", "isRequiredForProject", "newChannelReady", "channelToPropose", "Lcom/intellij/openapi/updateSettings/impl/UpdateChannel;", "prepareUpdateCheckArgs", "uriBuilder", "Lorg/apache/http/client/utils/URIBuilder;", "saveDisabledToUpdatePlugins", "showErrorMessage", "showDialog", "message", "showNotification", "action", "Lkotlin/Function0;", "notificationType", "showUpdateResult", "checkForUpdateResult", "updatedPlugins", "enableLink", "alwaysShowResults", "updateAndShowResult", "customSettings", "NotificationUniqueType", "platform-impl"})
public final class UpdateChecker {
    private static final Logger LOG;
    @NotNull
    private static final String NO_PLATFORM_UPDATE = "ide.no.platform.update";
    @JvmField
    @NotNull
    public static final NotificationGroup NOTIFICATIONS;
    private static final String INSTALLATION_UID = "installation.uid";
    private static final String DISABLED_UPDATE = "disabled_update.txt";
    private static Set<String> ourDisabledToUpdatePlugins;
    private static final HashMap<String, String> ourAdditionalRequestOptions;
    private static final HashMap<String, PluginDownloader> ourUpdatedPlugins;
    private static final Set<NotificationUniqueType> ourShownNotificationTypes;
    private static final Lazy<String> UPDATE_URL$delegate;
    private static final Lazy<String> PATCHES_URL$delegate;
    @NotNull
    private static final HashSet<String> excludedFromUpdateCheckPlugins;
    private static boolean ourHasFailedPlugins;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final UpdateChecker INSTANCE;

    @NotNull
    public final String getNO_PLATFORM_UPDATE() {
        return NO_PLATFORM_UPDATE;
    }

    /*
     * WARNING - void declaration
     */
    private final String getUPDATE_URL() {
        void $receiver$iv;
        Lazy<String> lazy = UPDATE_URL$delegate;
        UpdateChecker updateChecker = this;
        KProperty property$iv = $$delegatedProperties[0];
        return (String)$receiver$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final String getPATCHES_URL() {
        void $receiver$iv;
        Lazy<String> lazy = PATCHES_URL$delegate;
        UpdateChecker updateChecker = this;
        KProperty property$iv = $$delegatedProperties[1];
        return (String)$receiver$iv.getValue();
    }

    @NotNull
    public final HashSet<String> getExcludedFromUpdateCheckPlugins() {
        return excludedFromUpdateCheckPlugins;
    }

    private final String getUpdateUrl() {
        String string = System.getProperty("idea.updates.url");
        if (string == null) {
            String string2 = this.getUPDATE_URL();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UPDATE_URL");
        }
        return string;
    }

    private final String getPatchesUrl() {
        String string = System.getProperty("idea.patches.url");
        if (string == null) {
            String string2 = this.getPATCHES_URL();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PATCHES_URL");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ActionCallback updateAndShowResult() {
        ActionCallback callback = new ActionCallback();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(callback){
            final /* synthetic */ ActionCallback $callback;

            public final void run() {
                Project project2 = null;
                UpdateSettings updateSettings = UpdateSettings.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"UpdateSettings.getInstance()");
                UpdateChecker.access$doUpdateAndShowResult(UpdateChecker.INSTANCE, project2, true, false, updateSettings, null, this.$callback);
            }
            {
                this.$callback = actionCallback;
            }
        });
        return callback;
    }

    @JvmStatic
    public static final void updateAndShowResult(@Nullable Project project2, @Nullable UpdateSettings customSettings) {
        UpdateSettings updateSettings = customSettings;
        if (updateSettings == null) {
            updateSettings = UpdateSettings.getInstance();
        }
        UpdateSettings settings = updateSettings;
        boolean fromSettings = customSettings != null;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(fromSettings, settings, project2, IdeBundle.message((String)"updates.checking.progress", (Object[])new Object[0]), true){
            final /* synthetic */ boolean $fromSettings;
            final /* synthetic */ UpdateSettings $settings;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                Project project2 = this.getProject();
                UpdateSettings updateSettings = this.$settings;
                Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"settings");
                UpdateChecker.access$doUpdateAndShowResult(UpdateChecker.INSTANCE, project2, this.$fromSettings, true, updateSettings, indicator, null);
            }

            public boolean isConditionalModal() {
                return this.$fromSettings;
            }

            public boolean shouldStartInBackground() {
                return !this.$fromSettings;
            }
            {
                this.$fromSettings = $captured_local_variable$0;
                this.$settings = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
    }

    private final void doUpdateAndShowResult(Project project2, boolean fromSettings, boolean manualCheck, UpdateSettings updateSettings, ProgressIndicator indicator, ActionCallback callback) {
        Collection incompatiblePlugins;
        Collection<PluginDownloader> updatedPlugins;
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setText(IdeBundle.message((String)"updates.checking.platform", (Object[])new Object[0]));
        }
        CheckForUpdateResult result = this.checkPlatformUpdate(updateSettings);
        if (manualCheck && Intrinsics.areEqual((Object)((Object)result.getState()), (Object)((Object)UpdateStrategy.State.LOADED))) {
            UpdateSettings settings = UpdateSettings.getInstance();
            settings.saveLastCheckedInfo();
            settings.setKnownChannelIds(result.getAllChannelsIds());
        } else if (Intrinsics.areEqual((Object)((Object)result.getState()), (Object)((Object)UpdateStrategy.State.CONNECTION_ERROR))) {
            Object object;
            Exception e = result.getError();
            if (e != null) {
                LOG.debug((Throwable)e);
            }
            if ((object = e) == null || (object = ((Throwable)object).getMessage()) == null) {
                object = "internal error";
            }
            Object cause = object;
            String string = IdeBundle.message((String)"updates.error.connection.failed", (Object[])new Object[]{cause});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IdeBundle.message(\"updat\u2026onnection.failed\", cause)");
            this.showErrorMessage(manualCheck, string);
            return;
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(IdeBundle.message((String)"updates.checking.plugins", (Object[])new Object[0]));
        }
        if (this.newChannelReady(result.getChannelToPropose())) {
            updatedPlugins = null;
            incompatiblePlugins = null;
        } else {
            BuildInfo buildInfo = result.getNewBuildInSelectedChannel();
            BuildNumber buildNumber = buildInfo != null ? buildInfo.getApiVersion() : null;
            incompatiblePlugins = buildNumber != null ? (Collection)new HashSet() : (Collection)null;
            try {
                updatedPlugins = this.checkPluginsUpdate(updateSettings, indicator, incompatiblePlugins, buildNumber);
            }
            catch (IOException e) {
                String string = IdeBundle.message((String)"updates.error.connection.failed", (Object[])new Object[]{e.getMessage()});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IdeBundle.message(\"updat\u2026ction.failed\", e.message)");
                this.showErrorMessage(manualCheck, string);
                return;
            }
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(project2, result, updateSettings, updatedPlugins, incompatiblePlugins, fromSettings, manualCheck, callback){
            final /* synthetic */ Project $project;
            final /* synthetic */ CheckForUpdateResult $result;
            final /* synthetic */ UpdateSettings $updateSettings;
            final /* synthetic */ Collection $updatedPlugins;
            final /* synthetic */ Collection $incompatiblePlugins;
            final /* synthetic */ boolean $fromSettings;
            final /* synthetic */ boolean $manualCheck;
            final /* synthetic */ ActionCallback $callback;

            public final void run() {
                Unit unit;
                UpdateChecker.access$showUpdateResult(UpdateChecker.INSTANCE, this.$project, this.$result, this.$updateSettings, this.$updatedPlugins, this.$incompatiblePlugins, !this.$fromSettings, this.$manualCheck);
                ActionCallback actionCallback = this.$callback;
                if (actionCallback != null) {
                    actionCallback.setDone();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            {
                this.$project = project2;
                this.$result = checkForUpdateResult;
                this.$updateSettings = updateSettings;
                this.$updatedPlugins = collection;
                this.$incompatiblePlugins = collection2;
                this.$fromSettings = bl;
                this.$manualCheck = bl2;
                this.$callback = actionCallback;
            }
        }, fromSettings ? ModalityState.any() : ModalityState.NON_MODAL);
    }

    private final CheckForUpdateResult checkPlatformUpdate(UpdateSettings settings) {
        UpdatesInfo updateInfo;
        String $receiver$iv = System.getProperty(NO_PLATFORM_UPDATE, "false");
        if (Boolean.parseBoolean($receiver$iv)) {
            return new CheckForUpdateResult(UpdateStrategy.State.NOTHING_LOADED, null);
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(this.getUpdateUrl());
            if (Intrinsics.areEqual((Object)"file", (Object)uriBuilder.getScheme()) ^ true) {
                this.prepareUpdateCheckArgs(uriBuilder);
            }
            String updateUrl = uriBuilder.build().toString();
            LogUtil.debug((Logger)LOG, (String)"load update xml (UPDATE_URL='%s')", (Object[])new Object[]{updateUrl});
            updateInfo = (UpdatesInfo)HttpRequests.request((String)updateUrl).forceHttps(settings.canUseSecureConnection()).connect((HttpRequests.RequestProcessor)checkPlatformUpdate.1.INSTANCE);
        }
        catch (URISyntaxException e) {
            return new CheckForUpdateResult(UpdateStrategy.State.CONNECTION_ERROR, e);
        }
        catch (IOException e) {
            return new CheckForUpdateResult(UpdateStrategy.State.CONNECTION_ERROR, e);
        }
        if (updateInfo == null) {
            return new CheckForUpdateResult(UpdateStrategy.State.NOTHING_LOADED, null);
        }
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        int majorVersion = Integer.parseInt(appInfo.getMajorVersion());
        UpdateStrategyCustomization customization = UpdateStrategyCustomization.getInstance();
        UpdateStrategy strategy = new UpdateStrategy(majorVersion, appInfo.getBuild(), updateInfo, settings, customization);
        CheckForUpdateResult checkForUpdateResult = strategy.checkForUpdates();
        Intrinsics.checkExpressionValueIsNotNull((Object)checkForUpdateResult, (String)"strategy.checkForUpdates()");
        return checkForUpdateResult;
    }

    private final Collection<PluginDownloader> checkPluginsUpdate(UpdateSettings updateSettings, ProgressIndicator indicator, Collection<IdeaPluginDescriptor> incompatiblePlugins, BuildNumber buildNumber) {
        Map<PluginId, IdeaPluginDescriptor> updateable = this.collectUpdateablePlugins();
        if (updateable.isEmpty()) {
            return null;
        }
        THashMap toUpdate = ContainerUtil.newTroveMap();
        List<String> hosts = RepositoryHelper.getPluginHosts();
        InstalledPluginsState state = InstalledPluginsState.getInstance();
        block2: for (String host : hosts) {
            try {
                boolean forceHttps = host == null && updateSettings.canUseSecureConnection();
                List<IdeaPluginDescriptor> list = RepositoryHelper.loadPlugins(host, buildNumber, forceHttps, indicator);
                for (IdeaPluginDescriptor descriptor : list) {
                    PluginId id = descriptor.getPluginId();
                    if (!updateable.containsKey(id)) continue;
                    updateable.remove(id);
                    state.onDescriptorDownload(descriptor);
                    PluginDownloader downloader = PluginDownloader.createDownloader(descriptor, host, buildNumber);
                    downloader.setForceHttps(forceHttps);
                    PluginDownloader pluginDownloader = downloader;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pluginDownloader, (String)"downloader");
                    InstalledPluginsState installedPluginsState = state;
                    Intrinsics.checkExpressionValueIsNotNull((Object)installedPluginsState, (String)"state");
                    Map map = (Map)toUpdate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"toUpdate");
                    UpdateChecker.checkAndPrepareToInstall(pluginDownloader, installedPluginsState, map, incompatiblePlugins, indicator);
                    if (!updateable.isEmpty()) continue;
                    break block2;
                }
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                if (host != null) {
                    LOG.info("failed to load plugin descriptions from " + host + ": " + e.getMessage());
                    continue;
                }
                throw (Throwable)e;
            }
        }
        return toUpdate.isEmpty() ? (Collection)null : toUpdate.values();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<PluginId, IdeaPluginDescriptor> collectUpdateablePlugins() {
        void $receiver$iv;
        String destination$iv$iv;
        void $receiver$iv$iv;
        Object destination$iv$iv2;
        Object element$iv$iv;
        void $receiver$iv$iv2;
        THashMap updateable = ContainerUtil.newTroveMap();
        Map map = (Map)updateable;
        Object $receiver$iv2 = PluginManagerCore.getPlugins();
        Object[] objectArray = $receiver$iv2;
        Collection collection = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv2).length; ++i) {
            element$iv$iv = $receiver$iv$iv2[i];
            IdeaPluginDescriptor it = (IdeaPluginDescriptor)element$iv$iv;
            if (!(!it.isBundled())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10)), (int)16);
        destination$iv$iv2 = $receiver$iv2;
        Map map2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv2 : $receiver$iv$iv) {
            void it;
            IdeaPluginDescriptor $i$a$1 = (IdeaPluginDescriptor)element$iv$iv2;
            void var17_15 = destination$iv$iv;
            PluginId pluginId = it.getPluginId();
            var17_15.put(pluginId, element$iv$iv2);
        }
        void map$iv = destination$iv$iv;
        $receiver$iv.putAll(map$iv);
        File onceInstalled = PluginManager.getOnceInstalledIfExists();
        if (onceInstalled != null) {
            try {
                Iterator iterator = FileUtil.loadLines((File)onceInstalled).iterator();
                while (iterator.hasNext()) {
                    PluginId id;
                    void $receiver$iv$iv3;
                    void $receiver$iv3;
                    String line;
                    destination$iv$iv = line = (String)iterator.next();
                    void v0 = $receiver$iv3;
                    if (v0 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    element$iv$iv = (CharSequence)v0;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $receiver$iv$iv3.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $receiver$iv$iv3.charAt(index$iv$iv);
                        boolean bl = match$iv$iv = it <= ' ';
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    if (!(updateable.contains((Object)(id = PluginId.getId((String)((Object)$receiver$iv$iv3.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()))) ^ true)) continue;
                    updateable.put((Object)id, null);
                }
            }
            catch (IOException e) {
                LOG.error(onceInstalled.getPath(), (Throwable)e);
            }
            onceInstalled.deleteOnExit();
        }
        Iterator<String> iterator = excludedFromUpdateCheckPlugins.iterator();
        while (iterator.hasNext()) {
            String excludedPluginId;
            String string = excludedPluginId = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"excludedPluginId");
            if (this.isRequiredForAnyOpenProject(string)) continue;
            updateable.remove((Object)PluginId.getId((String)excludedPluginId));
        }
        Map map3 = (Map)updateable;
        Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"updateable");
        return map3;
    }

    private final boolean isRequiredForAnyOpenProject(String pluginId) {
        boolean bl;
        block1: {
            Object[] $receiver$iv = ProjectManager.getInstance().getOpenProjects();
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Project it;
                Object element$iv = $receiver$iv[i];
                Project project2 = it = (Project)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"it");
                if (!INSTANCE.isRequiredForProject(project2, pluginId)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isRequiredForProject(Project project2, String pluginId) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = ExternalDependenciesManager.getInstance(project2).getDependencies(DependencyOnPlugin.class);
            for (Object element$iv : $receiver$iv) {
                DependencyOnPlugin it = (DependencyOnPlugin)element$iv;
                if (!Intrinsics.areEqual((Object)it.getPluginId(), (Object)pluginId)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final void checkAndPrepareToInstall(@NotNull PluginDownloader downloader, @NotNull InstalledPluginsState state, @NotNull Map<PluginId, PluginDownloader> toUpdate, @Nullable Collection<IdeaPluginDescriptor> incompatiblePlugins, @Nullable ProgressIndicator indicator) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull(toUpdate, (String)"toUpdate");
        PluginDownloader downloader2 = downloader;
        String pluginId = downloader2.getPluginId();
        if (PluginManagerCore.getDisabledPlugins().contains(pluginId)) {
            return;
        }
        String pluginVersion = downloader2.getPluginVersion();
        IdeaPluginDescriptor installedPlugin = PluginManager.getPlugin(PluginId.getId((String)pluginId));
        if (installedPlugin == null || pluginVersion == null || PluginDownloader.compareVersionsSkipBrokenAndIncompatible(installedPlugin, pluginVersion) > 0) {
            IdeaPluginDescriptor descriptor;
            PluginDownloader oldDownloader = ourUpdatedPlugins.get(pluginId);
            if (oldDownloader == null || StringUtil.compareVersionNumbers((String)pluginVersion, (String)oldDownloader.getPluginVersion()) > 0) {
                descriptor = downloader2.getDescriptor();
                if (descriptor instanceof PluginNode && ((PluginNode)descriptor).isIncomplete()) {
                    ProgressIndicator progressIndicator = indicator;
                    if (progressIndicator == null) {
                        progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
                    }
                    if (downloader2.prepareToInstall(progressIndicator)) {
                        descriptor = downloader2.getDescriptor();
                    }
                    ourUpdatedPlugins.put(pluginId, downloader2);
                }
            } else {
                downloader2 = oldDownloader;
                descriptor = oldDownloader.getDescriptor();
            }
            if (descriptor != null && PluginManagerCore.isCompatible(descriptor, downloader2.getBuildNumber()) && !state.wasUpdated(descriptor.getPluginId())) {
                PluginId pluginId2 = PluginId.getId((String)pluginId);
                Intrinsics.checkExpressionValueIsNotNull((Object)pluginId2, (String)"PluginId.getId(pluginId)");
                toUpdate.put(pluginId2, downloader2);
            }
        }
        if (incompatiblePlugins != null && installedPlugin != null && installedPlugin.isEnabled() && !toUpdate.containsKey(installedPlugin.getPluginId()) && PluginManagerCore.isIncompatible(installedPlugin, downloader2.getBuildNumber())) {
            incompatiblePlugins.add(installedPlugin);
        }
    }

    private final void showErrorMessage(boolean showDialog, String message) {
        LOG.info(message);
        if (showDialog) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(message){
                final /* synthetic */ String $message;

                public final void run() {
                    Messages.showErrorDialog((String)this.$message, (String)IdeBundle.message((String)"updates.error.connection.title", (Object[])new Object[0]));
                }
                {
                    this.$message = string;
                }
            });
        }
    }

    @Contract(value="null -> false")
    private final boolean newChannelReady(UpdateChannel channelToPropose) {
        UpdateChannel updateChannel = channelToPropose;
        return (updateChannel != null ? updateChannel.getLatestBuild() : null) != null;
    }

    private final void showUpdateResult(Project project2, CheckForUpdateResult checkForUpdateResult, UpdateSettings updateSettings, Collection<? extends PluginDownloader> updatedPlugins, Collection<? extends IdeaPluginDescriptor> incompatiblePlugins, boolean enableLink, boolean alwaysShowResults) {
        UpdateChannel channelToPropose = checkForUpdateResult.getChannelToPropose();
        UpdateChannel updatedChannel = checkForUpdateResult.getUpdatedChannel();
        BuildInfo latestBuild = checkForUpdateResult.getNewBuildInSelectedChannel();
        if (updatedChannel != null && latestBuild != null) {
            Function0 runnable2 = (Function0)new Function0<Unit>(updateSettings, updatedChannel, latestBuild, enableLink, updatedPlugins, incompatiblePlugins){
                final /* synthetic */ UpdateSettings $updateSettings;
                final /* synthetic */ UpdateChannel $updatedChannel;
                final /* synthetic */ BuildInfo $latestBuild;
                final /* synthetic */ boolean $enableLink;
                final /* synthetic */ Collection $updatedPlugins;
                final /* synthetic */ Collection $incompatiblePlugins;

                public final void invoke() {
                    boolean forceHttps = this.$updateSettings.canUseSecureConnection();
                    new UpdateInfoDialog(this.$updatedChannel, this.$latestBuild, this.$enableLink, forceHttps, this.$updatedPlugins, this.$incompatiblePlugins).show();
                }
                {
                    this.$updateSettings = updateSettings;
                    this.$updatedChannel = updateChannel;
                    this.$latestBuild = buildInfo;
                    this.$enableLink = bl;
                    this.$updatedPlugins = collection;
                    this.$incompatiblePlugins = collection2;
                    super(0);
                }
            };
            if (alwaysShowResults) {
                runnable2.invoke();
            } else {
                String message;
                String string = message = IdeBundle.message((String)"updates.ready.message", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
                this.showNotification(project2, string, (Function0<Unit>)runnable2, NotificationUniqueType.UPDATE_IN_CHANNEL);
            }
        } else if (this.newChannelReady(channelToPropose)) {
            Function0 runnable3 = (Function0)new Function0<Unit>(channelToPropose, checkForUpdateResult, updateSettings){
                final /* synthetic */ UpdateChannel $channelToPropose;
                final /* synthetic */ CheckForUpdateResult $checkForUpdateResult;
                final /* synthetic */ UpdateSettings $updateSettings;

                public final void invoke() {
                    UpdateChannel updateChannel = this.$channelToPropose;
                    if (updateChannel == null) {
                        Intrinsics.throwNpe();
                    }
                    NewChannelDialog dialog = new NewChannelDialog(updateChannel);
                    dialog.show();
                    if (dialog.getExitCode() == 1 && Intrinsics.areEqual((Object)((Object)this.$checkForUpdateResult.getState()), (Object)((Object)UpdateStrategy.State.LOADED)) && !this.$updateSettings.getKnownChannelsIds().contains(this.$channelToPropose.getId())) {
                        ArrayList<String> newIds = new ArrayList<String>((Collection)this.$updateSettings.getKnownChannelsIds());
                        newIds.add(this.$channelToPropose.getId());
                        this.$updateSettings.setKnownChannelIds((List<String>)newIds);
                    }
                }
                {
                    this.$channelToPropose = updateChannel;
                    this.$checkForUpdateResult = checkForUpdateResult;
                    this.$updateSettings = updateSettings;
                    super(0);
                }
            };
            if (alwaysShowResults) {
                runnable3.invoke();
            } else {
                String message;
                String string = message = IdeBundle.message((String)"updates.new.version.available", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
                this.showNotification(project2, string, (Function0<Unit>)runnable3, NotificationUniqueType.NEW_CHANNEL);
            }
        } else if (updatedPlugins != null && !updatedPlugins.isEmpty()) {
            Function0 runnable4 = (Function0)new Function0<Unit>(updatedPlugins, enableLink){
                final /* synthetic */ Collection $updatedPlugins;
                final /* synthetic */ boolean $enableLink;

                public final void invoke() {
                    new PluginUpdateInfoDialog(this.$updatedPlugins, this.$enableLink).show();
                }
                {
                    this.$updatedPlugins = collection;
                    this.$enableLink = bl;
                    super(0);
                }
            };
            if (alwaysShowResults) {
                runnable4.invoke();
            } else {
                String message;
                String plugins2 = CollectionsKt.joinToString$default((Iterable)updatedPlugins, null, null, null, (int)0, null, (Function1)showUpdateResult.plugins.1.INSTANCE, (int)31, null);
                String string = message = IdeBundle.message((String)"updates.plugins.ready.message", (Object[])new Object[]{updatedPlugins.size(), plugins2});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
                this.showNotification(project2, string, (Function0<Unit>)runnable4, NotificationUniqueType.PLUGINS_UPDATE);
            }
        } else if (alwaysShowResults) {
            new NoUpdatesDialog(enableLink).show();
        }
    }

    private final void showNotification(Project project2, String message, Function0<Unit> action, NotificationUniqueType notificationType) {
        if (!ourShownNotificationTypes.add(notificationType)) {
            return;
        }
        NotificationListener listener2 = new NotificationListener(action){
            final /* synthetic */ Function0 $action;

            public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                notification.expire();
                this.$action.invoke();
            }
            {
                this.$action = function0;
            }
        };
        String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
        NOTIFICATIONS.createNotification(title, XmlStringUtil.wrapInHtml((CharSequence)message), NotificationType.INFORMATION, listener2).whenExpired(new Runnable(notificationType){
            final /* synthetic */ NotificationUniqueType $notificationType;

            public final void run() {
                UpdateChecker.access$getOurShownNotificationTypes$p(UpdateChecker.INSTANCE).remove((Object)((Object)this.$notificationType));
            }
            {
                this.$notificationType = notificationUniqueType;
            }
        }).notify(project2);
    }

    @JvmStatic
    public static final void addUpdateRequestParameter(@NotNull String name, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        ourAdditionalRequestOptions.put(name, value);
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareUpdateCheckArgs(URIBuilder uriBuilder) {
        void $receiver$iv;
        String string = ApplicationInfo.getInstance().getBuild().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ApplicationInfo.getInstance().build.asString()");
        UpdateChecker.addUpdateRequestParameter("build", string);
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)propertiesComponent, (String)"PropertiesComponent.getInstance()");
        UpdateChecker.addUpdateRequestParameter("uid", UpdateChecker.getInstallationUID(propertiesComponent));
        UpdateChecker.addUpdateRequestParameter("os", SystemInfo.OS_NAME + ' ' + SystemInfo.OS_VERSION);
        if (ApplicationInfoEx.getInstanceEx().isEAP()) {
            UpdateChecker.addUpdateRequestParameter("eap", "");
        }
        Map map = ourAdditionalRequestOptions;
        Iterator iterator = $receiver$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $receiver$iv2;
            void $receiver$iv3;
            Map.Entry entry;
            Map.Entry $i$f$iterator = entry = iterator.next();
            String name = (String)$receiver$iv3.getKey();
            Map.Entry $i$f$component1 = entry;
            String value = (String)$receiver$iv2.getValue();
            uriBuilder.addParameter(name, StringUtil.isEmpty((String)value) ? (String)null : value);
        }
    }

    @JvmStatic
    @NotNull
    public static final String getInstallationUID(@NotNull PropertiesComponent propertiesComponent) {
        String uid;
        Intrinsics.checkParameterIsNotNull((Object)propertiesComponent, (String)"propertiesComponent");
        if (SystemInfo.isWindows && (uid = INSTANCE.getInstallationUIDOnWindows(propertiesComponent)) != null) {
            return uid;
        }
        uid = propertiesComponent.getValue(INSTALLATION_UID);
        if (uid == null) {
            uid = INSTANCE.generateUUID();
            propertiesComponent.setValue(INSTALLATION_UID, uid);
        }
        return uid;
    }

    /*
     * WARNING - void declaration
     */
    private final String getInstallationUIDOnWindows(PropertiesComponent propertiesComponent) {
        File jetBrainsDir;
        String appdata = System.getenv("APPDATA");
        if (appdata != null && ((jetBrainsDir = new File(appdata, "JetBrains")).exists() || jetBrainsDir.mkdirs())) {
            File permanentIdFile = new File(jetBrainsDir, "PermanentUserId");
            try {
                if (permanentIdFile.exists()) {
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    String string = FileUtil.loadFile((File)permanentIdFile);
                    void v0 = $receiver$iv;
                    if (v0 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    CharSequence charSequence = (CharSequence)v0;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $receiver$iv$iv.charAt(index$iv$iv);
                        boolean bl = match$iv$iv = it <= ' ';
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    return ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                }
                String uuid = propertiesComponent.getValue(INSTALLATION_UID);
                if (uuid == null) {
                    uuid = this.generateUUID();
                }
                FileUtil.writeToFile((File)permanentIdFile, (String)uuid);
                return uuid;
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    private final String generateUUID() {
        String string;
        try {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UUID.randomUUID().toString()");
            string = string2;
        }
        catch (Exception ignored) {
            string = "";
        }
        catch (InternalError ignored) {
            string = "";
        }
        return string;
    }

    @JvmStatic
    public static final void installPlatformUpdate(@NotNull PatchInfo patch, @NotNull BuildNumber toBuild, boolean forceHttps) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)patch, (String)"patch");
        Intrinsics.checkParameterIsNotNull((Object)toBuild, (String)"toBuild");
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(patch, toBuild, forceHttps){
            final /* synthetic */ PatchInfo $patch;
            final /* synthetic */ BuildNumber $toBuild;
            final /* synthetic */ boolean $forceHttps;

            public final void run() {
                ProgressIndicator indicator;
                ProgressIndicator progressIndicator = indicator = ProgressManager.getInstance().getProgressIndicator();
                Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"indicator");
                UpdateChecker.access$downloadAndInstallPatch(UpdateChecker.INSTANCE, this.$patch, this.$toBuild, this.$forceHttps, progressIndicator);
            }
            {
                this.$patch = patchInfo;
                this.$toBuild = buildNumber;
                this.$forceHttps = bl;
            }
        }, IdeBundle.message((String)"update.downloading.patch.progress.title", (Object[])new Object[0]), true, (Project)null);
    }

    /*
     * WARNING - void declaration
     */
    private final void downloadAndInstallPatch(PatchInfo patch, BuildNumber toBuild, boolean forceHttps, ProgressIndicator indicator) {
        void locale$iv;
        void $receiver$iv;
        String productCode = ApplicationInfo.getInstance().getBuild().getProductCode();
        String fromBuildNumber = patch.getFromBuild().asStringWithoutProductCode();
        String toBuildNumber = toBuild.asStringWithoutProductCode();
        String bundledJdk = "";
        String jdkRedist = System.getProperty("idea.java.redist");
        if (jdkRedist != null && StringsKt.lastIndexOf$default((CharSequence)jdkRedist, (String)"NoJavaDistribution", (int)0, (boolean)false, (int)6, null) >= 0) {
            bundledJdk = "-no-jdk";
        }
        String osSuffix = "-" + patch.getOsSuffix();
        String fileName = productCode + "-" + fromBuildNumber + "-" + toBuildNumber + "-patch" + bundledJdk + osSuffix + ".jar";
        String url = new URL(new URL(this.getPatchesUrl()), fileName).toString();
        File tempFile2 = (File)HttpRequests.request((String)url).gzip(false).forceHttps(forceHttps).connect(new HttpRequests.RequestProcessor<T>(indicator){
            final /* synthetic */ ProgressIndicator $indicator;

            @NotNull
            public final File process(@NotNull HttpRequests.Request request) {
                return request.saveToFile(FileUtil.createTempFile((String)"ij.platform.", (String)".patch", (boolean)true), this.$indicator);
            }
            {
                this.$indicator = progressIndicator;
            }
        });
        String string = "jetbrains.patch.jar." + PlatformUtils.getPlatformPrefix();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        void v1 = $receiver$iv;
        if (v1 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)v1).toLowerCase((Locale)locale$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
        String patchFileName = string2;
        File patchFile = new File(FileUtil.getTempDirectory(), patchFileName);
        FileUtil.copy((File)tempFile2, (File)patchFile);
        FileUtil.delete((File)tempFile2);
    }

    @JvmStatic
    public static final boolean installPluginUpdates(@NotNull Collection<? extends PluginDownloader> downloaders, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull(downloaders, (String)"downloaders");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        boolean installed = false;
        Set<String> disabledToUpdate = UpdateChecker.getDisabledToUpdatePlugins();
        for (PluginDownloader pluginDownloader : downloaders) {
            if (disabledToUpdate.contains(pluginDownloader.getPluginId())) continue;
            try {
                IdeaPluginDescriptor descriptor;
                if (!pluginDownloader.prepareToInstall(indicator) || (descriptor = pluginDownloader.getDescriptor()) == null) continue;
                pluginDownloader.install();
                installed = true;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return installed;
    }

    @JvmStatic
    private static final /* synthetic */ void disabledToUpdatePlugins$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> getDisabledToUpdatePlugins() {
        if (ourDisabledToUpdatePlugins == null) {
            ourDisabledToUpdatePlugins = new TreeSet();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    File file2 = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
                    if (file2.isFile()) {
                        Iterator iterator;
                        CharSequence it;
                        void $receiver$iv$iv;
                        CharSequence charSequence = FileUtil.loadFile((File)file2);
                        Object $receiver$iv = "[\\s]";
                        $receiver$iv = new Regex((String)$receiver$iv);
                        int $i$f$toRegex = 0;
                        int n = 2;
                        Object var5_8 = null;
                        if (var5_8 != null) {
                            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: split");
                        }
                        if ((n & 2) != 0) {
                            $i$f$toRegex = 0;
                        }
                        Iterable $receiver$iv2 = $receiver$iv.split(charSequence, $i$f$toRegex);
                        $receiver$iv = $receiver$iv2;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                        for (Object item$iv$iv : $receiver$iv$iv) {
                            void $receiver$iv3;
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            void var7_10 = it;
                            void v0 = $receiver$iv3;
                            if (v0 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
                            collection.add(string2);
                        }
                        $receiver$iv2 = (List)((Object)iterator);
                        Set<String> set = ourDisabledToUpdatePlugins;
                        if (set == null) {
                            Intrinsics.throwNpe();
                        }
                        Collection destination$iv = set;
                        for (Object element$iv : $receiver$iv2) {
                            void $receiver$iv4;
                            String it2 = (String)element$iv;
                            it = it2;
                            if (!($receiver$iv4.length() > 0)) continue;
                            destination$iv.add(element$iv);
                        }
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        Set<String> set = ourDisabledToUpdatePlugins;
        if (set == null) {
            Intrinsics.throwNpe();
        }
        return set;
    }

    @JvmStatic
    public static final void saveDisabledToUpdatePlugins() {
        File plugins2 = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
        try {
            PluginManagerCore.savePluginsList((Collection<String>)UpdateChecker.getDisabledToUpdatePlugins(), false, plugins2);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @JvmStatic
    public static final void checkForUpdate(@NotNull IdeaLoggingEvent event) {
        IdeaPluginDescriptor pluginDescriptor;
        UpdateSettings settings;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!ourHasFailedPlugins && (settings = UpdateSettings.getInstance()) != null && settings.isCheckNeeded() && (pluginDescriptor = PluginManager.getPlugin(IdeErrorsDialog.findPluginId(event.getThrowable()))) != null && !pluginDescriptor.isBundled()) {
            ourHasFailedPlugins = true;
            UpdateChecker.updateAndShowResult();
        }
    }

    private UpdateChecker() {
        INSTANCE = this;
        LOG = Logger.getInstance((String)"#com.intellij.openapi.updateSettings.impl.UpdateChecker");
        NO_PLATFORM_UPDATE = NO_PLATFORM_UPDATE;
        NOTIFICATIONS = new NotificationGroup(IdeBundle.message((String)"update.notifications.group", (Object[])new Object[0]), NotificationDisplayType.STICKY_BALLOON, true);
        INSTALLATION_UID = INSTALLATION_UID;
        DISABLED_UPDATE = DISABLED_UPDATE;
        ourAdditionalRequestOptions = MapsKt.hashMapOf((Pair[])new Pair[0]);
        ourUpdatedPlugins = MapsKt.hashMapOf((Pair[])new Pair[0]);
        ourShownNotificationTypes = Collections.synchronizedSet((Set)EnumSet.noneOf(NotificationUniqueType.class));
        UPDATE_URL$delegate = LazyKt.lazy((Function0)UPDATE_URL.2.INSTANCE);
        PATCHES_URL$delegate = LazyKt.lazy((Function0)PATCHES_URL.2.INSTANCE);
        excludedFromUpdateCheckPlugins = SetsKt.hashSetOf((Object[])new String[0]);
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(UpdateChecker.class), "UPDATE_URL", "getUPDATE_URL()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(UpdateChecker.class), "PATCHES_URL", "getPATCHES_URL()Ljava/lang/String;"))};
        new UpdateChecker();
    }

    public static final /* synthetic */ void access$doUpdateAndShowResult(UpdateChecker $this, @Nullable Project project2, boolean fromSettings, boolean manualCheck, @NotNull UpdateSettings updateSettings, @Nullable ProgressIndicator indicator, @Nullable ActionCallback callback) {
        $this.doUpdateAndShowResult(project2, fromSettings, manualCheck, updateSettings, indicator, callback);
    }

    public static final /* synthetic */ void access$showUpdateResult(UpdateChecker $this, @Nullable Project project2, @NotNull CheckForUpdateResult checkForUpdateResult, @NotNull UpdateSettings updateSettings, @Nullable Collection updatedPlugins, @Nullable Collection incompatiblePlugins, boolean enableLink, boolean alwaysShowResults) {
        $this.showUpdateResult(project2, checkForUpdateResult, updateSettings, updatedPlugins, incompatiblePlugins, enableLink, alwaysShowResults);
    }

    public static final /* synthetic */ Logger access$getLOG$p(UpdateChecker $this) {
        UpdateChecker updateChecker = $this;
        return LOG;
    }

    public static final /* synthetic */ Set access$getOurShownNotificationTypes$p(UpdateChecker $this) {
        UpdateChecker updateChecker = $this;
        return ourShownNotificationTypes;
    }

    public static final /* synthetic */ void access$downloadAndInstallPatch(UpdateChecker $this, @NotNull PatchInfo patch, @NotNull BuildNumber toBuild, boolean forceHttps, @NotNull ProgressIndicator indicator) {
        $this.downloadAndInstallPatch(patch, toBuild, forceHttps, indicator);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$NotificationUniqueType;", "", "(Ljava/lang/String;I)V", "NEW_CHANNEL", "UPDATE_IN_CHANNEL", "PLUGINS_UPDATE", "platform-impl"})
    private static final class NotificationUniqueType
    extends Enum<NotificationUniqueType> {
        public static final /* enum */ NotificationUniqueType NEW_CHANNEL;
        public static final /* enum */ NotificationUniqueType UPDATE_IN_CHANNEL;
        public static final /* enum */ NotificationUniqueType PLUGINS_UPDATE;
        private static final /* synthetic */ NotificationUniqueType[] $VALUES;

        static {
            NotificationUniqueType[] notificationUniqueTypeArray = new NotificationUniqueType[3];
            NotificationUniqueType[] notificationUniqueTypeArray2 = notificationUniqueTypeArray;
            notificationUniqueTypeArray[0] = NEW_CHANNEL = new NotificationUniqueType();
            notificationUniqueTypeArray[1] = UPDATE_IN_CHANNEL = new NotificationUniqueType();
            notificationUniqueTypeArray[2] = PLUGINS_UPDATE = new NotificationUniqueType();
            $VALUES = notificationUniqueTypeArray;
        }

        public static NotificationUniqueType[] values() {
            return (NotificationUniqueType[])$VALUES.clone();
        }

        public static NotificationUniqueType valueOf(String string) {
            return Enum.valueOf(NotificationUniqueType.class, string);
        }
    }
}

