/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.DiffExtension;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.base.DiffViewerListener;
import com.intellij.diff.tools.util.side.OnesideTextDiffViewer;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.util.BackgroundTaskUtil;
import com.intellij.diff.util.Side;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.UpToDateLineNumberProviderImpl;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateDiffViewerAction
extends ToggleAction
implements DumbAware {
    public static final Logger LOG = Logger.getInstance(AnnotateDiffViewerAction.class);
    private static final Key<AnnotationData[]> CACHE_KEY = Key.create((String)"Diff.AnnotateAction.Cache");
    private static final Key<boolean[]> ANNOTATIONS_SHOWN_KEY = Key.create((String)"Diff.AnnotateAction.AnnotationShown");
    private static final ViewerAnnotator[] ANNOTATORS = new ViewerAnnotator[]{new TwosideAnnotator(), new OnesideAnnotator(), new UnifiedAnnotator()};

    public AnnotateDiffViewerAction() {
        EmptyAction.setupAction((AnAction)this, (String)"Annotate", null);
        this.setEnabledInModalContext(true);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabledAndVisible(AnnotateDiffViewerAction.isEnabled(e));
    }

    @Nullable
    private static ViewerAnnotator getAnnotator(@NotNull DiffViewerBase viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "getAnnotator"));
        }
        for (ViewerAnnotator annotator : ANNOTATORS) {
            if (!annotator.getViewerClass().isInstance(viewer)) continue;
            return annotator;
        }
        return null;
    }

    @Nullable
    private static EventData collectEventData(AnActionEvent e) {
        DiffViewerBase viewer = (DiffViewerBase)ObjectUtils.tryCast((Object)e.getData(DiffDataKeys.DIFF_VIEWER), DiffViewerBase.class);
        if (viewer == null) {
            return null;
        }
        if (viewer.getProject() == null) {
            return null;
        }
        if (viewer.isDisposed()) {
            return null;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        ViewerAnnotator annotator = AnnotateDiffViewerAction.getAnnotator(viewer);
        if (annotator == null) {
            return null;
        }
        Side side = annotator.getCurrentSide(viewer, editor);
        if (side == null) {
            return null;
        }
        return new EventData(viewer, editor, annotator, side);
    }

    public static boolean isEnabled(AnActionEvent e) {
        EventData data = AnnotateDiffViewerAction.collectEventData(e);
        if (data == null) {
            return false;
        }
        if (data.annotator.isAnnotationShown(data.viewer, data.side)) {
            return true;
        }
        if (AnnotateDiffViewerAction.getBackgroundableLock(data.viewer, data.side).isLocked()) {
            return false;
        }
        return AnnotateDiffViewerAction.createAnnotationsLoader(data.viewer.getProject(), (DiffRequest)data.viewer.getRequest(), data.side) != null;
    }

    public static void perform(AnActionEvent e) {
        EventData data = AnnotateDiffViewerAction.collectEventData(e);
        assert (data != null);
        boolean annotationShown = data.annotator.isAnnotationShown(data.viewer, data.side);
        if (annotationShown) {
            data.annotator.hideAnnotation(data.viewer, data.side);
        } else {
            AnnotateDiffViewerAction.doAnnotate(data.annotator, data.viewer, data.side);
        }
    }

    public boolean isSelected(AnActionEvent e) {
        EventData data = AnnotateDiffViewerAction.collectEventData(e);
        return data != null && data.annotator.isAnnotationShown(data.viewer, data.side);
    }

    public void setSelected(AnActionEvent e, boolean state) {
        AnnotateDiffViewerAction.perform(e);
    }

    public static <T extends DiffViewerBase> void doAnnotate(final @NotNull ViewerAnnotator<T> annotator, final @NotNull T viewer, final @NotNull Side side) {
        if (annotator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotator", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "doAnnotate"));
        }
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "doAnnotate"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "doAnnotate"));
        }
        Project project2 = viewer.getProject();
        if (project2 == null) {
            return;
        }
        final ContentDiffRequest request = viewer.getRequest();
        AnnotationData data = AnnotateDiffViewerAction.getDataFromCache((DiffRequest)request, side);
        if (data != null) {
            annotator.showAnnotation(viewer, side, data);
            return;
        }
        final FileAnnotationLoader loader = AnnotateDiffViewerAction.createAnnotationsLoader(project2, (DiffRequest)request, side);
        if (loader == null) {
            return;
        }
        final DiffContextEx diffContext = (DiffContextEx)((Object)ObjectUtils.tryCast((Object)viewer.getContext(), DiffContextEx.class));
        AnnotateDiffViewerAction.getBackgroundableLock(viewer, side).lock();
        if (diffContext != null) {
            diffContext.showProgressBar(true);
        }
        BackgroundTaskUtil.executeOnPooledThread(new Consumer<ProgressIndicator>(){

            public void consume(ProgressIndicator indicator) {
                try {
                    loader.run();
                }
                catch (Throwable throwable) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            if (this.this$0.diffContext != null) {
                                this.this$0.diffContext.showProgressBar(false);
                            }
                            AnnotateDiffViewerAction.getBackgroundableLock(this.this$0.viewer, this.this$0.side).unlock();
                            VcsException exception = this.this$0.loader.getException();
                            if (exception != null) {
                                Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification("Can't Load Annotations", exception.getMessage(), NotificationType.ERROR, null);
                                AnnotateDiffViewerAction.showNotification(this.this$0.viewer, notification);
                                LOG.warn((Throwable)exception);
                                return;
                            }
                            if (this.this$0.loader.getResult() == null) {
                                return;
                            }
                            if (this.this$0.loader.shouldCache()) {
                                AnnotateDiffViewerAction.putDataToCache((DiffRequest)this.this$0.request, this.this$0.side, this.this$0.loader.getResult());
                            }
                            if (this.this$0.viewer.isDisposed()) {
                                return;
                            }
                            this.this$0.annotator.showAnnotation(this.this$0.viewer, this.this$0.side, this.this$0.loader.getResult());
                        }
                    }, indicator.getModalityState());
                    throw throwable;
                }
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, indicator.getModalityState());
            }
        }, viewer);
    }

    @Nullable
    private static FileAnnotationLoader createAnnotationsLoader(@NotNull Project project2, @NotNull DiffRequest request, @NotNull Side side) {
        ContentDiffRequest requestEx;
        VirtualFile file2;
        ContentRevision revision;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "createAnnotationsLoader"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "createAnnotationsLoader"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "createAnnotationsLoader"));
        }
        Change change = (Change)request.getUserData(ChangeDiffRequestProducer.CHANGE_KEY);
        if (change != null && (revision = (ContentRevision)side.select((Object)change.getBeforeRevision(), (Object)change.getAfterRevision())) != null) {
            AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)change, (Project)project2);
            if (revision instanceof CurrentContentRevision) {
                file2 = ((CurrentContentRevision)revision).getVirtualFile();
                FileAnnotationLoader loader = AnnotateDiffViewerAction.doCreateAnnotationsLoader(project2, vcs, file2);
                if (loader != null) {
                    return loader;
                }
            } else {
                FileAnnotationLoader loader = AnnotateDiffViewerAction.doCreateAnnotationsLoader(vcs, revision.getFile(), revision.getRevisionNumber());
                if (loader != null) {
                    return loader;
                }
            }
        }
        if (request instanceof ContentDiffRequest && (requestEx = (ContentDiffRequest)request).getContents().size() == 2) {
            FilePath filePath;
            AbstractVcs vcs;
            FileAnnotationLoader loader;
            AbstractVcs vcs2;
            FileAnnotationLoader loader2;
            DiffContent content = (DiffContent)side.select(requestEx.getContents());
            if (content instanceof FileContent && (loader2 = AnnotateDiffViewerAction.doCreateAnnotationsLoader(project2, vcs2 = VcsUtil.getVcsFor((Project)project2, (VirtualFile)(file2 = ((FileContent)content).getFile())), file2)) != null) {
                return loader2;
            }
            Pair info = (Pair)content.getUserData(VcsHistoryUtil.REVISION_INFO_KEY);
            if (info != null && (loader = AnnotateDiffViewerAction.doCreateAnnotationsLoader(vcs = VcsUtil.getVcsFor((Project)project2, (FilePath)(filePath = (FilePath)info.first)), filePath, (VcsRevisionNumber)info.second)) != null) {
                return loader;
            }
        }
        return null;
    }

    @Nullable
    private static FileAnnotationLoader doCreateAnnotationsLoader(@NotNull Project project2, @Nullable AbstractVcs vcs, final @Nullable VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "doCreateAnnotationsLoader"));
        }
        if (vcs == null || file2 == null) {
            return null;
        }
        final AnnotationProvider annotationProvider = vcs.getCachingAnnotationProvider();
        if (annotationProvider == null) {
            return null;
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project2).getStatus(file2);
        if (fileStatus == FileStatus.UNKNOWN || fileStatus == FileStatus.ADDED || fileStatus == FileStatus.IGNORED) {
            return null;
        }
        return new FileAnnotationLoader(vcs, false){

            @Override
            public FileAnnotation compute() throws VcsException {
                return annotationProvider.annotate(file2);
            }
        };
    }

    @Nullable
    private static FileAnnotationLoader doCreateAnnotationsLoader(@Nullable AbstractVcs vcs, final @Nullable FilePath path, final @Nullable VcsRevisionNumber revisionNumber) {
        if (vcs == null || path == null || revisionNumber == null) {
            return null;
        }
        final AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        if (!(annotationProvider instanceof AnnotationProviderEx)) {
            return null;
        }
        return new FileAnnotationLoader(vcs, true){

            @Override
            public FileAnnotation compute() throws VcsException {
                return ((AnnotationProviderEx)annotationProvider).annotate(path, revisionNumber);
            }
        };
    }

    private static void putDataToCache(@NotNull DiffRequest request, @NotNull Side side, @NotNull AnnotationData data) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "putDataToCache"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "putDataToCache"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "putDataToCache"));
        }
        AnnotationData[] cache = (AnnotationData[])request.getUserData(CACHE_KEY);
        if (cache == null || cache.length != 2) {
            cache = new AnnotationData[2];
            request.putUserData(CACHE_KEY, (Object)cache);
        }
        cache[side.getIndex()] = data;
    }

    @Nullable
    private static AnnotationData getDataFromCache(@NotNull DiffRequest request, @NotNull Side side) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "getDataFromCache"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "getDataFromCache"));
        }
        Object[] cache = (AnnotationData[])request.getUserData(CACHE_KEY);
        if (cache != null && cache.length == 2) {
            return (AnnotationData)side.select(cache);
        }
        return null;
    }

    private static void showNotification(@NotNull DiffViewerBase viewer, @NotNull Notification notification) {
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "showNotification"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "showNotification"));
        }
        JComponent component = viewer.getComponent();
        Window window = UIUtil.getWindow((Component)component);
        if (window instanceof IdeFrame && NotificationsManagerImpl.findWindowForBalloon(viewer.getProject()) == window) {
            notification.notify(viewer.getProject());
            return;
        }
        Balloon balloon = NotificationsManagerImpl.createBalloon(component, notification, false, true, null);
        Disposer.register((Disposable)viewer, (Disposable)balloon);
        Dimension componentSize = component.getSize();
        Dimension balloonSize = balloon.getPreferredSize();
        int width = Math.min(balloonSize.width, componentSize.width);
        int height = Math.min(balloonSize.height, componentSize.height);
        RelativePoint point = new RelativePoint((Component)component, new Point(componentSize.width - 20 - width / 2, 20 + height / 2));
        balloon.show(point, Balloon.Position.above);
    }

    @NotNull
    private static BackgroundableActionLock getBackgroundableLock(@NotNull DiffViewerBase viewer, @NotNull Side side) {
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "getBackgroundableLock"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "getBackgroundableLock"));
        }
        BackgroundableActionLock backgroundableActionLock = BackgroundableActionLock.getLock(viewer.getProject(), new Object[]{VcsBackgroundableActions.ANNOTATE, viewer, side});
        if (backgroundableActionLock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "getBackgroundableLock"));
        }
        return backgroundableActionLock;
    }

    private static class EventData {
        @NotNull
        public final DiffViewerBase viewer;
        @NotNull
        public final Editor editor;
        @NotNull
        public final ViewerAnnotator annotator;
        @NotNull
        public final Side side;

        public EventData(@NotNull DiffViewerBase viewer, @NotNull Editor editor, @NotNull ViewerAnnotator annotator, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$EventData", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$EventData", "<init>"));
            }
            if (annotator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotator", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$EventData", "<init>"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$EventData", "<init>"));
            }
            this.viewer = viewer;
            this.editor = editor;
            this.annotator = annotator;
            this.side = side;
        }
    }

    private static class AnnotationData {
        @NotNull
        public final AbstractVcs vcs;
        @NotNull
        public final FileAnnotation annotation;

        public AnnotationData(@NotNull AbstractVcs vcs, @NotNull FileAnnotation annotation) {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$AnnotationData", "<init>"));
            }
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$AnnotationData", "<init>"));
            }
            this.vcs = vcs;
            this.annotation = annotation;
        }
    }

    private static abstract class FileAnnotationLoader {
        @NotNull
        private final AbstractVcs myVcs;
        private final boolean myShouldCache;
        @Nullable
        private VcsException myException;
        @Nullable
        private FileAnnotation myResult;

        public FileAnnotationLoader(@NotNull AbstractVcs vcs, boolean cache) {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$FileAnnotationLoader", "<init>"));
            }
            this.myVcs = vcs;
            this.myShouldCache = cache;
        }

        @Nullable
        public VcsException getException() {
            return this.myException;
        }

        @Nullable
        public AnnotationData getResult() {
            return this.myResult != null ? new AnnotationData(this.myVcs, this.myResult) : null;
        }

        public boolean shouldCache() {
            return this.myShouldCache;
        }

        public void run() {
            try {
                this.myResult = this.compute();
            }
            catch (VcsException e) {
                this.myException = e;
            }
        }

        protected abstract FileAnnotation compute() throws VcsException;
    }

    private static abstract class ViewerAnnotator<T extends DiffViewerBase> {
        private ViewerAnnotator() {
        }

        @NotNull
        public abstract Class<T> getViewerClass();

        @Nullable
        public abstract Side getCurrentSide(@NotNull T var1, @NotNull Editor var2);

        public abstract boolean isAnnotationShown(@NotNull T var1, @NotNull Side var2);

        public abstract void showAnnotation(@NotNull T var1, @NotNull Side var2, @NotNull AnnotationData var3);

        public abstract void hideAnnotation(@NotNull T var1, @NotNull Side var2);
    }

    private static class UnifiedUpToDateLineNumberProvider
    implements UpToDateLineNumberProvider {
        @NotNull
        private final UnifiedDiffViewer myViewer;
        @NotNull
        private final Side mySide;
        @NotNull
        private final UpToDateLineNumberProvider myLocalChangesProvider;

        public UnifiedUpToDateLineNumberProvider(@NotNull UnifiedDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedUpToDateLineNumberProvider", "<init>"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedUpToDateLineNumberProvider", "<init>"));
            }
            this.myViewer = viewer;
            this.mySide = side;
            this.myLocalChangesProvider = new UpToDateLineNumberProviderImpl(this.myViewer.getDocument(this.mySide), viewer.getProject());
        }

        public int getLineNumber(int currentNumber) {
            int number = this.myViewer.transferLineFromOnesideStrict(this.mySide, currentNumber);
            return number != -1 ? this.myLocalChangesProvider.getLineNumber(number) : -2;
        }

        public boolean isLineChanged(int currentNumber) {
            return this.getLineNumber(currentNumber) == -1;
        }

        public boolean isRangeChanged(int start, int end) {
            int line1 = this.myViewer.transferLineFromOnesideStrict(this.mySide, start);
            int line2 = this.myViewer.transferLineFromOnesideStrict(this.mySide, end);
            if (line2 - line1 != end - start) {
                return true;
            }
            for (int i = start; i <= end; ++i) {
                if (!this.isLineChanged(i)) continue;
                return true;
            }
            return this.myLocalChangesProvider.isRangeChanged(line1, line2);
        }
    }

    private static class UnifiedAnnotator
    extends ViewerAnnotator<UnifiedDiffViewer> {
        private UnifiedAnnotator() {
        }

        @Override
        @NotNull
        public Class<UnifiedDiffViewer> getViewerClass() {
            if (UnifiedDiffViewer.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotator", "getViewerClass"));
            }
            return UnifiedDiffViewer.class;
        }

        @Override
        @Nullable
        public Side getCurrentSide(@NotNull UnifiedDiffViewer viewer, @NotNull Editor editor) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotator", "getCurrentSide"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotator", "getCurrentSide"));
            }
            if (viewer.getEditor() != editor) {
                return null;
            }
            return viewer.getMasterSide();
        }

        @Override
        public boolean isAnnotationShown(@NotNull UnifiedDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotator", "isAnnotationShown"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotator", "isAnnotationShown"));
            }
            if (side != viewer.getMasterSide()) {
                return false;
            }
            return viewer.getEditor().getGutter().isAnnotationsShown();
        }

        @Override
        public void showAnnotation(@NotNull UnifiedDiffViewer viewer, @NotNull Side side, @NotNull AnnotationData data) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotator", "showAnnotation"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotator", "showAnnotation"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotator", "showAnnotation"));
            }
            if (side != viewer.getMasterSide()) {
                return;
            }
            Project project2 = (Project)ObjectUtils.assertNotNull((Object)viewer.getProject());
            UnifiedUpToDateLineNumberProvider lineNumberProvider = new UnifiedUpToDateLineNumberProvider(viewer, side);
            AnnotateToggleAction.doAnnotate(viewer.getEditor(), project2, null, data.annotation, data.vcs, lineNumberProvider);
        }

        @Override
        public void hideAnnotation(@NotNull UnifiedDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotator", "hideAnnotation"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotator", "hideAnnotation"));
            }
            viewer.getEditor().getGutter().closeAllAnnotations();
        }
    }

    private static class OnesideAnnotator
    extends ViewerAnnotator<OnesideTextDiffViewer> {
        private OnesideAnnotator() {
        }

        @Override
        @NotNull
        public Class<OnesideTextDiffViewer> getViewerClass() {
            if (OnesideTextDiffViewer.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotator", "getViewerClass"));
            }
            return OnesideTextDiffViewer.class;
        }

        @Override
        @Nullable
        public Side getCurrentSide(@NotNull OnesideTextDiffViewer viewer, @NotNull Editor editor) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotator", "getCurrentSide"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotator", "getCurrentSide"));
            }
            if (viewer.getEditor() != editor) {
                return null;
            }
            return viewer.getSide();
        }

        @Override
        public boolean isAnnotationShown(@NotNull OnesideTextDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotator", "isAnnotationShown"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotator", "isAnnotationShown"));
            }
            if (side != viewer.getSide()) {
                return false;
            }
            return viewer.getEditor().getGutter().isAnnotationsShown();
        }

        @Override
        public void showAnnotation(@NotNull OnesideTextDiffViewer viewer, @NotNull Side side, @NotNull AnnotationData data) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotator", "showAnnotation"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotator", "showAnnotation"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotator", "showAnnotation"));
            }
            if (side != viewer.getSide()) {
                return;
            }
            Project project2 = (Project)ObjectUtils.assertNotNull((Object)viewer.getProject());
            AnnotateToggleAction.doAnnotate(viewer.getEditor(), project2, null, data.annotation, data.vcs);
        }

        @Override
        public void hideAnnotation(@NotNull OnesideTextDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotator", "hideAnnotation"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotator", "hideAnnotation"));
            }
            viewer.getEditor().getGutter().closeAllAnnotations();
        }
    }

    private static class TwosideAnnotator
    extends ViewerAnnotator<TwosideTextDiffViewer> {
        private TwosideAnnotator() {
        }

        @Override
        @NotNull
        public Class<TwosideTextDiffViewer> getViewerClass() {
            if (TwosideTextDiffViewer.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotator", "getViewerClass"));
            }
            return TwosideTextDiffViewer.class;
        }

        @Override
        @Nullable
        public Side getCurrentSide(@NotNull TwosideTextDiffViewer viewer, @NotNull Editor editor) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotator", "getCurrentSide"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotator", "getCurrentSide"));
            }
            Side side = null;
            if (viewer.getEditor(Side.LEFT) == editor) {
                side = Side.LEFT;
            }
            if (viewer.getEditor(Side.RIGHT) == editor) {
                side = Side.RIGHT;
            }
            return side;
        }

        @Override
        public boolean isAnnotationShown(@NotNull TwosideTextDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotator", "isAnnotationShown"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotator", "isAnnotationShown"));
            }
            return viewer.getEditor(side).getGutter().isAnnotationsShown();
        }

        @Override
        public void showAnnotation(@NotNull TwosideTextDiffViewer viewer, @NotNull Side side, @NotNull AnnotationData data) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotator", "showAnnotation"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotator", "showAnnotation"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotator", "showAnnotation"));
            }
            Project project2 = (Project)ObjectUtils.assertNotNull((Object)viewer.getProject());
            AnnotateToggleAction.doAnnotate(viewer.getEditor(side), project2, null, data.annotation, data.vcs);
        }

        @Override
        public void hideAnnotation(@NotNull TwosideTextDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotator", "hideAnnotation"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotator", "hideAnnotation"));
            }
            viewer.getEditor(side).getGutter().closeAllAnnotations();
        }
    }

    private static class MyDiffViewerListener
    extends DiffViewerListener {
        @NotNull
        private final DiffViewerBase myViewer;

        public MyDiffViewerListener(@NotNull DiffViewerBase viewer) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$MyDiffViewerListener", "<init>"));
            }
            this.myViewer = viewer;
        }

        @Override
        public void onInit() {
            if (this.myViewer.getProject() == null) {
                return;
            }
            boolean[] annotationsShown = (boolean[])this.myViewer.getRequest().getUserData(ANNOTATIONS_SHOWN_KEY);
            if (annotationsShown == null || annotationsShown.length != 2) {
                return;
            }
            ViewerAnnotator annotator = AnnotateDiffViewerAction.getAnnotator(this.myViewer);
            if (annotator == null) {
                return;
            }
            if (annotationsShown[0]) {
                AnnotateDiffViewerAction.doAnnotate(annotator, this.myViewer, Side.LEFT);
            }
            if (annotationsShown[1]) {
                AnnotateDiffViewerAction.doAnnotate(annotator, this.myViewer, Side.RIGHT);
            }
        }

        @Override
        public void onDispose() {
            ViewerAnnotator annotator = AnnotateDiffViewerAction.getAnnotator(this.myViewer);
            if (annotator == null) {
                return;
            }
            boolean[] annotationsShown = new boolean[]{annotator.isAnnotationShown(this.myViewer, Side.LEFT), annotator.isAnnotationShown(this.myViewer, Side.RIGHT)};
            this.myViewer.getRequest().putUserData(ANNOTATIONS_SHOWN_KEY, (Object)annotationsShown);
        }
    }

    public static class MyDiffExtension
    extends DiffExtension {
        public void onViewerCreated(@NotNull FrameDiffTool.DiffViewer diffViewer, @NotNull DiffContext context, @NotNull DiffRequest request) {
            if (diffViewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffViewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$MyDiffExtension", "onViewerCreated"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$MyDiffExtension", "onViewerCreated"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$MyDiffExtension", "onViewerCreated"));
            }
            if (diffViewer instanceof DiffViewerBase) {
                DiffViewerBase viewer = (DiffViewerBase)diffViewer;
                viewer.addListener(new MyDiffViewerListener(viewer));
            }
        }
    }
}

