/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCommitChangesAction
extends AbstractCommonCheckinAction {
    @Override
    @NotNull
    protected FilePath[] getRoots(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/AbstractCommitChangesAction", "getRoots"));
        }
        FilePath[] filePathArray = AbstractCommitChangesAction.getAllContentRoots(context);
        if (filePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/AbstractCommitChangesAction", "getRoots"));
        }
        return filePathArray;
    }

    @Override
    protected boolean approximatelyHasRoots(VcsContext dataContext) {
        Project project2 = dataContext.getProject();
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project2);
        return manager.hasAnyMappings();
    }

    @Override
    protected boolean filterRootsBeforeAction() {
        return false;
    }

    @Override
    protected void update(VcsContext vcsContext, Presentation presentation) {
        super.update(vcsContext, presentation);
        if (presentation.isVisible() && presentation.isEnabled()) {
            ChangeList[] selectedChangeLists = vcsContext.getSelectedChangeLists();
            Change[] selectedChanges = vcsContext.getSelectedChanges();
            if (((String)vcsContext.getPlace()).equals("ChangesViewPopup")) {
                if (selectedChangeLists != null && selectedChangeLists.length > 0) {
                    presentation.setEnabled(selectedChangeLists.length == 1 && !ContainerUtil.isEmpty((Collection)selectedChangeLists[0].getChanges()));
                } else {
                    presentation.setEnabled(selectedChanges != null && selectedChanges.length > 0);
                }
            }
            if (presentation.isEnabled() && selectedChanges != null) {
                ChangeListManager changeListManager = ChangeListManager.getInstance((Project)vcsContext.getProject());
                for (Change c : selectedChanges) {
                    if (c.getFileStatus() != FileStatus.HIJACKED || changeListManager.getChangeList(c) != null) continue;
                    presentation.setEnabled(false);
                    break;
                }
            }
        }
    }
}

