/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.update.FileOrDirectoryTreeNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DirectoryTreeNode
extends FileOrDirectoryTreeNode {
    public DirectoryTreeNode(String path, Project project2, String parentPath) {
        super(path, SimpleTextAttributes.ERROR_ATTRIBUTES, project2, parentPath);
    }

    @Override
    protected int getItemsCount() {
        int result = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            result += ((FileOrDirectoryTreeNode)this.getChildAt(i)).getItemsCount();
        }
        return result;
    }

    @Override
    protected boolean showStatistics() {
        return true;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        return AllIcons.Nodes.Folder;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getVirtualFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            FileOrDirectoryTreeNode child = (FileOrDirectoryTreeNode)this.getChildAt(i);
            result.addAll(child.getVirtualFiles());
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/DirectoryTreeNode", "getVirtualFiles"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<File> getFiles() {
        ArrayList<File> result = new ArrayList<File>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            FileOrDirectoryTreeNode child = (FileOrDirectoryTreeNode)this.getChildAt(i);
            result.addAll(child.getFiles());
        }
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/DirectoryTreeNode", "getFiles"));
        }
        return arrayList;
    }
}

