/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileDirectoryImpl;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

class VirtualFileDataImpl
extends VirtualFileImpl {
    private byte[] myContents = ArrayUtil.EMPTY_BYTE_ARRAY;
    private long myModificationStamp = LocalTimeCounter.currentTime();

    public VirtualFileDataImpl(DummyFileSystem fileSystem, VirtualFileDirectoryImpl parent, String name) {
        super(fileSystem, parent, name);
    }

    public boolean isDirectory() {
        return false;
    }

    public long getLength() {
        return this.myContents.length;
    }

    public VirtualFile[] getChildren() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM((byte[])this.myContents, (VirtualFile)this);
    }

    @NotNull
    public OutputStream getOutputStream(final Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM((OutputStream)new ByteArrayOutputStream(){

            @Override
            public void close() {
                DummyFileSystem fs = (DummyFileSystem)VirtualFileDataImpl.this.getFileSystem();
                fs.fireBeforeContentsChange(requestor, VirtualFileDataImpl.this);
                long oldModStamp = VirtualFileDataImpl.this.myModificationStamp;
                VirtualFileDataImpl.access$102(VirtualFileDataImpl.this, this.toByteArray());
                VirtualFileDataImpl.this.myModificationStamp = newModificationStamp >= 0L ? newModificationStamp : LocalTimeCounter.currentTime();
                fs.fireContentsChanged(requestor, VirtualFileDataImpl.this, oldModStamp);
            }
        }, (VirtualFile)this);
        if (outputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/ex/dummy/VirtualFileDataImpl", "getOutputStream"));
        }
        return outputStream;
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (this.myContents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/ex/dummy/VirtualFileDataImpl", "contentsToByteArray"));
        }
        return this.myContents;
    }

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    public void setModificationStamp(long modificationStamp, Object requestor) {
        this.myModificationStamp = modificationStamp;
    }

    static /* synthetic */ byte[] access$102(VirtualFileDataImpl x0, byte[] x1) {
        x0.myContents = x1;
        return x1;
    }
}

