/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile;

import com.intellij.openapi.project.Project;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import com.intellij.util.xmlb.SmartSerializer;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Transient;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class ProfileEx
implements Profile {
    public static final String SCOPE = "scope";
    public static final String NAME = "name";
    private final SmartSerializer mySerializer;
    @NotNull
    protected String myName;
    @OptionTag(value="myLocal")
    private boolean myLocal;
    protected ProfileManager myProfileManager;
    private boolean myIsProjectLevel;

    public ProfileEx(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/intellij/profile/ProfileEx", "<init>"));
        }
        this(name, SmartSerializer.skipEmptySerializer());
    }

    protected ProfileEx(@NotNull String name, @NotNull SmartSerializer serializer) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/intellij/profile/ProfileEx", "<init>"));
        }
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/profile/ProfileEx", "<init>"));
        }
        this.myName = name;
        this.mySerializer = serializer;
    }

    @OptionTag(value="myName")
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/ProfileEx", "getName"));
        }
        return string;
    }

    public void copyFrom(@NotNull Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/ProfileEx", "copyFrom"));
        }
        Element config = new Element("config");
        profile.writeExternal(config);
        this.readExternal(config);
    }

    @Transient
    public boolean isLocal() {
        return !this.myIsProjectLevel;
    }

    @Transient
    public boolean isProjectLevel() {
        return this.myIsProjectLevel;
    }

    public void setProjectLevel(boolean isProjectLevel) {
        this.myIsProjectLevel = isProjectLevel;
    }

    public void setLocal(boolean isLocal) {
        this.myIsProjectLevel = !isLocal;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/intellij/profile/ProfileEx", "setName"));
        }
        this.myName = name;
    }

    @Transient
    @NotNull
    public ProfileManager getProfileManager() {
        ProfileManager profileManager = this.myProfileManager;
        if (profileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/ProfileEx", "getProfileManager"));
        }
        return profileManager;
    }

    public void setProfileManager(@NotNull ProfileManager profileManager) {
        if (profileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileManager", "com/intellij/profile/ProfileEx", "setProfileManager"));
        }
        this.myProfileManager = profileManager;
    }

    public void readExternal(Element element) {
        this.mySerializer.readExternal((Object)this, element);
    }

    public void serializeInto(@NotNull Element element, boolean preserveCompatibility) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/profile/ProfileEx", "serializeInto"));
        }
        this.mySerializer.writeExternal((Object)this, element, preserveCompatibility);
    }

    public void writeExternal(Element element) {
        this.serializeInto(element, true);
    }

    public void profileChanged() {
    }

    public boolean equals(Object o) {
        return this == o || o instanceof ProfileEx && this.myName.equals(((ProfileEx)o).myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public int compareTo(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/profile/ProfileEx", "compareTo"));
        }
        if (o instanceof Profile) {
            return this.getName().compareToIgnoreCase(((Profile)o).getName());
        }
        return 0;
    }

    public void convert(@NotNull Element element, @NotNull Project project2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/profile/ProfileEx", "convert"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/profile/ProfileEx", "convert"));
        }
    }
}

