/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.profile.codeInspection.ui.header.SaveInputComponentValidator;
import com.intellij.profile.codeInspection.ui.header.ValidatedTextField;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuxiliaryRightPanel
extends JPanel {
    private static final String SHOW_DESCRIPTION_CARD = "show.description.card";
    private static final String EDIT_DESCRIPTION_CARD = "edit.description.card";
    private static final String ERROR_CARD = "error.card";
    private final DescriptionLabel myDescriptionLabel;
    private final JLabel myErrorLabel;
    private final ValidatedTextField myValidatedTextField;
    private final CardLayout myLayout;
    private final JPanel myCardPanel = new JPanel();

    public AuxiliaryRightPanel(final DescriptionSaveListener descriptionListener) {
        this.myDescriptionLabel = new DescriptionLabel();
        this.myErrorLabel = new JLabel();
        this.myErrorLabel.setBackground(UIUtil.isUnderDarcula() ? JBColor.PINK.darker() : JBColor.PINK);
        this.myErrorLabel.setForeground((Color)JBColor.BLACK);
        this.myErrorLabel.setOpaque(true);
        this.myValidatedTextField = new ValidatedTextField(new SaveInputComponentValidator(){

            @Override
            public void doSave(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/profile/codeInspection/ui/header/AuxiliaryRightPanel$1", "doSave"));
                }
                descriptionListener.saveDescription(text.trim());
            }

            @Override
            public boolean checkValid(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/profile/codeInspection/ui/header/AuxiliaryRightPanel$1", "checkValid"));
                }
                return true;
            }

            @Override
            public void cancel() {
                descriptionListener.cancel();
            }
        });
        this.myLayout = new CardLayout();
        this.myCardPanel.setLayout(this.myLayout);
        this.myCardPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 4, 0));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/profile/codeInspection/ui/header/AuxiliaryRightPanel$2", "onClick"));
                }
                if (clickCount != 2) {
                    return false;
                }
                AuxiliaryRightPanel.this.editDescription(AuxiliaryRightPanel.this.myDescriptionLabel.getText());
                return true;
            }
        }.installOn((Component)this.myDescriptionLabel);
        this.myCardPanel.add((Component)this.myDescriptionLabel, SHOW_DESCRIPTION_CARD);
        this.myCardPanel.add((Component)this.myErrorLabel, ERROR_CARD);
        this.myCardPanel.add((Component)((Object)this.myValidatedTextField), EDIT_DESCRIPTION_CARD);
        this.showDescription(null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myValidatedTextField.getHintLabel(), "North");
        this.add((Component)this.myCardPanel, "Center");
    }

    public void showDescription(@Nullable String newDescription) {
        if (newDescription == null) {
            newDescription = "";
        }
        this.myDescriptionLabel.setAllText(newDescription);
        this.myLayout.show(this.myCardPanel, SHOW_DESCRIPTION_CARD);
    }

    public void editDescription(@Nullable String startValue) {
        if (startValue == null) {
            startValue = "";
        }
        this.myValidatedTextField.setText(startValue);
        this.myLayout.show(this.myCardPanel, EDIT_DESCRIPTION_CARD);
        this.myValidatedTextField.requestFocus();
    }

    public void showError(@NotNull String errorText) {
        if (errorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorText", "com/intellij/profile/codeInspection/ui/header/AuxiliaryRightPanel", "showError"));
        }
        this.myErrorLabel.setText(errorText);
        this.myLayout.show(this.myCardPanel, ERROR_CARD);
    }

    private static class DescriptionLabel
    extends MultiLineLabel {
        private String myAllText;

        public DescriptionLabel() {
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this);
            this.setVerticalAlignment(0);
            this.setHorizontalAlignment(2);
        }

        public void setAllText(String allText) {
            this.myAllText = allText;
            this.revalidate();
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getSize().width;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int charWidth = fontMetrics.charWidth('a');
            int firstLineSize = Math.max(0, width / charWidth);
            if (this.myAllText.length() <= firstLineSize) {
                this.setText(this.myAllText);
                this.setToolTipText(null);
            } else {
                String firstLine = this.myAllText.substring(0, firstLineSize);
                String remainPart = this.myAllText.substring(firstLineSize);
                int lastWhitespace = firstLine.lastIndexOf(32);
                if (lastWhitespace > -1) {
                    remainPart = firstLine.substring(lastWhitespace) + remainPart;
                    firstLine = firstLine.substring(0, lastWhitespace);
                }
                String visibleText = firstLine + "\n";
                int secondLineSize = Math.max(0, (width - 3 * fontMetrics.charWidth('.')) / charWidth);
                if (remainPart.length() <= secondLineSize) {
                    this.setText(visibleText + remainPart.trim());
                    this.setToolTipText(null);
                } else {
                    this.setText(visibleText + remainPart.trim().substring(0, secondLineSize) + "...");
                    this.setToolTipText("..." + remainPart.substring(secondLineSize));
                }
            }
            super.paintComponent(g);
        }
    }

    public static interface DescriptionSaveListener {
        public void saveDescription(@NotNull String var1);

        public void cancel();
    }
}

