/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.ui.header.SaveInputComponentValidator;
import com.intellij.profile.codeInspection.ui.header.ValidatedTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class ProfilesConfigurableComboBox
extends JPanel {
    private static final String COMBO_CARD = "combo.card";
    private static final String EDIT_CARD = "edit.card";
    private final JComboBox myProfilesComboBox;
    private final CardLayout myCardLayout;
    private final ValidatedTextField mySubmitNameComponent;
    private final SaveInputComponentValidator.Wrapper mySaveListener;
    private final JPanel myComboBoxPanel = new JPanel();

    public ProfilesConfigurableComboBox(ListCellRendererWrapper<Profile> comboBoxItemsRenderer) {
        this.myCardLayout = new CardLayout();
        this.myComboBoxPanel.setLayout(this.myCardLayout);
        this.setBorder(IdeBorderFactory.createEmptyBorder((Insets)new Insets(4, 0, 6, 0)));
        this.myProfilesComboBox = new JComboBox();
        this.myComboBoxPanel.add((Component)this.myProfilesComboBox, COMBO_CARD);
        this.mySaveListener = new SaveInputComponentValidator.Wrapper();
        this.mySubmitNameComponent = new ValidatedTextField(this.mySaveListener);
        this.myComboBoxPanel.add((Component)((Object)this.mySubmitNameComponent), EDIT_CARD);
        this.myProfilesComboBox.setRenderer(comboBoxItemsRenderer);
        this.myProfilesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectionProfileImpl profile = ProfilesConfigurableComboBox.this.getSelectedProfile();
                if (profile != null) {
                    ProfilesConfigurableComboBox.this.onProfileChosen(profile);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.mySubmitNameComponent.getHintLabel(), "North");
        this.add((Component)this.myComboBoxPanel, "Center");
        this.showComboBoxCard();
    }

    protected abstract void onProfileChosen(InspectionProfileImpl var1);

    public void showEditCard(String initialValue, SaveInputComponentValidator inputValidator) {
        this.mySaveListener.setDelegate(inputValidator);
        this.mySubmitNameComponent.setText(initialValue);
        this.myCardLayout.show(this.myComboBoxPanel, EDIT_CARD);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfilesConfigurableComboBox.this.mySubmitNameComponent.requestFocus();
            }
        });
    }

    public void reset(Collection<Profile> profiles) {
        DefaultComboBoxModel<Profile> aModel = new DefaultComboBoxModel<Profile>();
        this.myProfilesComboBox.setModel(aModel);
        for (Profile profile : profiles) {
            aModel.addElement(profile);
        }
        this.myProfilesComboBox.setSelectedIndex(0);
    }

    public DefaultComboBoxModel getModel() {
        return (DefaultComboBoxModel)this.myProfilesComboBox.getModel();
    }

    public InspectionProfileImpl getSelectedProfile() {
        return (InspectionProfileImpl)this.myProfilesComboBox.getSelectedItem();
    }

    public void selectProfile(Profile inspectionProfile) {
        this.myProfilesComboBox.setSelectedItem(inspectionProfile);
    }

    public void showComboBoxCard() {
        this.myCardLayout.show(this.myComboBoxPanel, COMBO_CARD);
    }
}

