/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.ui;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.presentation.CodeStyleSelectSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSettingsNameProvider
implements CodeStyleSettingsCustomizable {
    protected Map<LanguageCodeStyleSettingsProvider.SettingsType, Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>> mySettings = ContainerUtil.newHashMap();
    private Map<LanguageCodeStyleSettingsProvider.SettingsType, Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>> standardSettings = ContainerUtil.newHashMap();

    public CodeStyleSettingsNameProvider() {
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            this.standardSettings.put(settingsType, CodeStyleSettingPresentation.getStandardSettings((LanguageCodeStyleSettingsProvider.SettingsType)settingsType));
        }
    }

    protected void addSetting(@NotNull CodeStyleSettingPresentation.SettingsGroup group, @NotNull CodeStyleSettingPresentation setting, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @Nullable String anchorFieldName) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/psi/codeStyle/extractor/ui/CodeStyleSettingsNameProvider", "addSetting"));
        }
        if (setting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setting", "com/intellij/psi/codeStyle/extractor/ui/CodeStyleSettingsNameProvider", "addSetting"));
        }
        for (Map.Entry<LanguageCodeStyleSettingsProvider.SettingsType, Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>> entry : this.mySettings.entrySet()) {
            if (!entry.getValue().containsKey(group)) continue;
            this.addSetting(entry.getKey(), group, setting, anchor, anchorFieldName);
            return;
        }
        this.addSetting(LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC, group, setting, anchor, anchorFieldName);
    }

    protected void addSetting(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType, @NotNull CodeStyleSettingPresentation.SettingsGroup group, @NotNull CodeStyleSettingPresentation setting, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @Nullable String anchorFieldName) {
        List settingsList;
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/intellij/psi/codeStyle/extractor/ui/CodeStyleSettingsNameProvider", "addSetting"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/psi/codeStyle/extractor/ui/CodeStyleSettingsNameProvider", "addSetting"));
        }
        if (setting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setting", "com/intellij/psi/codeStyle/extractor/ui/CodeStyleSettingsNameProvider", "addSetting"));
        }
        LinkedHashMap groups = this.mySettings.get(settingsType);
        if (groups == null) {
            groups = ContainerUtil.newLinkedHashMap();
        }
        if ((settingsList = (List)groups.get(group)) == null) {
            settingsList = ContainerUtil.newLinkedList();
        }
        if (settingsList.contains(setting)) {
            return;
        }
        if (anchor != null && anchorFieldName != null) {
            CodeStyleSettingPresentation anchorSettingRepresentation = new CodeStyleSettingPresentation(anchorFieldName, anchorFieldName);
            int insertIndex = settingsList.indexOf(anchorSettingRepresentation);
            if (insertIndex < 0) {
                insertIndex = settingsList.size();
            } else {
                switch (anchor) {
                    case BEFORE: {
                        break;
                    }
                    case AFTER: {
                        ++insertIndex;
                        break;
                    }
                    case NONE: {
                        insertIndex = settingsList.size();
                    }
                }
            }
            settingsList.add(insertIndex, setting);
        } else {
            settingsList.add(setting);
        }
        groups.put(group, settingsList);
    }

    public void showAllStandardOptions() {
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> standardGroups = this.standardSettings.get(settingsType);
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> entry : standardGroups.entrySet()) {
                for (CodeStyleSettingPresentation setting : entry.getValue()) {
                    this.addSetting(settingsType, entry.getKey(), setting, null, null);
                }
            }
        }
    }

    public void showStandardOptions(String ... optionNames) {
        List<String> options = Arrays.asList(optionNames);
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> standardGroups = this.standardSettings.get(settingsType);
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> entry : standardGroups.entrySet()) {
                for (CodeStyleSettingPresentation setting : entry.getValue()) {
                    if (!options.contains(setting.getFieldName())) continue;
                    this.addSetting(settingsType, entry.getKey(), setting, null, null);
                }
            }
        }
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, @NotNull String fieldName, @NotNull String title, @Nullable String groupName, Object ... options) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/psi/codeStyle/extractor/ui/CodeStyleSettingsNameProvider", "showCustomOption"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/psi/codeStyle/extractor/ui/CodeStyleSettingsNameProvider", "showCustomOption"));
        }
        this.showCustomOption(settingsClass, fieldName, title, groupName, null, null, options);
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, @NotNull String fieldName, @NotNull String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @Nullable String anchorFieldName, Object ... options) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/psi/codeStyle/extractor/ui/CodeStyleSettingsNameProvider", "showCustomOption"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/psi/codeStyle/extractor/ui/CodeStyleSettingsNameProvider", "showCustomOption"));
        }
        if (options.length == 2) {
            this.addSetting(new CodeStyleSettingPresentation.SettingsGroup(groupName), (CodeStyleSettingPresentation)new CodeStyleSelectSettingPresentation(fieldName, title, (int[])options[1], (String[])options[0]), anchor, anchorFieldName);
        } else {
            this.addSetting(new CodeStyleSettingPresentation.SettingsGroup(groupName), new CodeStyleSettingPresentation(fieldName, title), anchor, anchorFieldName);
        }
    }

    public void renameStandardOption(String fieldName, String newTitle) {
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> standardGroups = this.mySettings.get(settingsType);
            if (standardGroups == null) continue;
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> entry : standardGroups.entrySet()) {
                for (CodeStyleSettingPresentation setting : entry.getValue()) {
                    if (!setting.getFieldName().equals(fieldName)) continue;
                    setting.setUiName(newTitle);
                    return;
                }
            }
        }
    }

    public void moveStandardOption(String fieldName, String newGroup) {
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            LinkedHashMap standardGroups = this.mySettings.get(settingsType);
            if (standardGroups == null) {
                standardGroups = ContainerUtil.newLinkedHashMap();
                this.mySettings.put(settingsType, standardGroups);
            }
            for (Map.Entry entry : standardGroups.entrySet()) {
                CodeStyleSettingPresentation moveSetting = null;
                for (CodeStyleSettingPresentation setting : (List)entry.getValue()) {
                    if (!setting.getFieldName().equals(fieldName)) continue;
                    moveSetting = setting;
                    break;
                }
                if (moveSetting == null) continue;
                ((List)entry.getValue()).remove(moveSetting);
                this.addSetting(new CodeStyleSettingPresentation.SettingsGroup(newGroup), moveSetting, null, null);
            }
        }
    }

    public static String getSettingsTypeName(LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        switch (settingsType) {
            case BLANK_LINES_SETTINGS: {
                return ApplicationBundle.message((String)"title.blank.lines", (Object[])new Object[0]);
            }
            case SPACING_SETTINGS: {
                return ApplicationBundle.message((String)"title.spaces", (Object[])new Object[0]);
            }
            case WRAPPING_AND_BRACES_SETTINGS: {
                return ApplicationBundle.message((String)"wrapping.and.braces", (Object[])new Object[0]);
            }
            case INDENT_SETTINGS: {
                return ApplicationBundle.message((String)"title.tabs.and.indents", (Object[])new Object[0]);
            }
            case LANGUAGE_SPECIFIC: {
                return "Language-specific";
            }
        }
        throw new IllegalArgumentException("Unknown settings type: " + settingsType);
    }

    public void addSettings(LanguageCodeStyleSettingsProvider provider) {
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            provider.customizeSettings((CodeStyleSettingsCustomizable)this, settingsType);
        }
    }

    public static Value getValue(final CodeStyleSettingPresentation representation, List<Value> values) {
        Value myValue = (Value)ContainerUtil.find(values, (Condition)new Condition<Value>(){

            public boolean value(Value value) {
                return value.state == Value.STATE.SELECTED && value.name.equals(representation.getFieldName());
            }
        });
        return myValue;
    }

    public String getSettings(List<Value> values) {
        StringBuilder builder = new StringBuilder();
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            builder.append("<br><b><u>").append(CodeStyleSettingsNameProvider.getSettingsTypeName(settingsType)).append("</u></b>");
            Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> groups = this.mySettings.get(settingsType);
            if (groups == null) continue;
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> entry : groups.entrySet()) {
                boolean firstSettingGroupTop = entry.getKey().isNull();
                boolean groupReported = false;
                for (final CodeStyleSettingPresentation setting : entry.getValue()) {
                    Value myValue = (Value)ContainerUtil.find(values, (Condition)new Condition<Value>(){

                        public boolean value(Value value) {
                            return value.state == Value.STATE.SELECTED && value.name.equals(setting.getFieldName());
                        }
                    });
                    if (myValue == null) continue;
                    if (!groupReported) {
                        if (firstSettingGroupTop) {
                            builder.append("<b>");
                        } else {
                            builder.append("<br><b>").append(entry.getKey().name).append("</b>");
                        }
                    }
                    builder.append("<br>");
                    String postNameSign = setting.getUiName().endsWith(":") ? " " : ": ";
                    builder.append(setting.getUiName()).append(postNameSign).append(setting.getValueUiName(myValue.value));
                    if (!groupReported && firstSettingGroupTop) {
                        builder.append("</b>");
                    }
                    groupReported = true;
                }
            }
        }
        return builder.toString();
    }
}

