/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaAnchorProvider
extends SmartPointerAnchorProvider {
    @Override
    public PsiElement getAnchor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/JavaAnchorProvider", "getAnchor"));
        }
        if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) || !element.isPhysical()) {
            return null;
        }
        if (element instanceof PsiClass) {
            if (element instanceof PsiAnonymousClass) {
                return ((PsiAnonymousClass)element).getBaseClassReference().getReferenceNameElement();
            }
            return ((PsiClass)element).getNameIdentifier();
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getNameIdentifier();
        }
        if (element instanceof PsiVariable) {
            return ((PsiVariable)element).getNameIdentifier();
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement restoreElement(@NotNull PsiElement anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/psi/impl/smartPointers/JavaAnchorProvider", "restoreElement"));
        }
        if (anchor instanceof PsiIdentifier) {
            PsiElement parent = anchor.getParent();
            if (parent instanceof PsiJavaCodeReferenceElement) {
                parent = parent.getParent();
            }
            return parent;
        }
        return null;
    }
}

