/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceListWeigher
extends ProximityWeigher {
    public static final ReferenceListWeigher INSTANCE = new ReferenceListWeigher();
    public static final ElementPattern<PsiElement> INSIDE_REFERENCE_LIST = PlatformPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiReferenceList.class});

    @Nullable
    protected Preference getPreferredCondition(@NotNull PsiElement position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/util/proximity/ReferenceListWeigher", "getPreferredCondition"));
        }
        if (INSIDE_REFERENCE_LIST.accepts((Object)position)) {
            PsiReferenceList.Role role;
            PsiReferenceList list = (PsiReferenceList)position.getParent().getParent();
            if (ReferenceListWeigher.shouldContainInterfaces(list, role = list.getRole())) {
                return Preference.Interfaces;
            }
            if (role == PsiReferenceList.Role.EXTENDS_LIST) {
                return Preference.Classes;
            }
            if (role == PsiReferenceList.Role.THROWS_LIST) {
                return Preference.Exceptions;
            }
        }
        return null;
    }

    private static boolean shouldContainInterfaces(PsiReferenceList list, PsiReferenceList.Role role) {
        if (role == PsiReferenceList.Role.EXTENDS_LIST) {
            PsiElement parent = list.getParent();
            return parent instanceof PsiClass && ((PsiClass)parent).isInterface();
        }
        return role == PsiReferenceList.Role.IMPLEMENTS_LIST;
    }

    public ReferenceListApplicability weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/proximity/ReferenceListWeigher", "weigh"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/psi/util/proximity/ReferenceListWeigher", "weigh"));
        }
        if (element instanceof PsiClass && location.getPosition() != null) {
            return this.getApplicability((PsiClass)element, location.getPosition());
        }
        return ReferenceListApplicability.unknown;
    }

    @NotNull
    public ReferenceListApplicability getApplicability(@NotNull PsiClass aClass, @NotNull PsiElement position) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/proximity/ReferenceListWeigher", "getApplicability"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/util/proximity/ReferenceListWeigher", "getApplicability"));
        }
        Preference condition = this.getPreferredCondition(position);
        if (condition == Preference.Interfaces) {
            ReferenceListApplicability referenceListApplicability = aClass.isInterface() ? ReferenceListApplicability.applicableByKind : ReferenceListApplicability.inapplicable;
            if (referenceListApplicability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/proximity/ReferenceListWeigher", "getApplicability"));
            }
            return referenceListApplicability;
        }
        if (condition == Preference.Classes) {
            VirtualFile vFile;
            if (aClass.isInterface()) {
                ReferenceListApplicability referenceListApplicability = ReferenceListApplicability.inapplicable;
                if (referenceListApplicability == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/proximity/ReferenceListWeigher", "getApplicability"));
                }
                return referenceListApplicability;
            }
            String name = aClass.getName();
            if (name != null && name.endsWith("TestCase") && (vFile = aClass.getContainingFile().getVirtualFile()) != null && ProjectFileIndex.SERVICE.getInstance((Project)aClass.getProject()).isInTestSourceContent(vFile)) {
                ReferenceListApplicability referenceListApplicability = ReferenceListApplicability.applicableByName;
                if (referenceListApplicability == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/proximity/ReferenceListWeigher", "getApplicability"));
                }
                return referenceListApplicability;
            }
            ReferenceListApplicability referenceListApplicability = ReferenceListApplicability.applicableByKind;
            if (referenceListApplicability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/proximity/ReferenceListWeigher", "getApplicability"));
            }
            return referenceListApplicability;
        }
        if (condition == Preference.Exceptions) {
            ReferenceListApplicability referenceListApplicability = InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Throwable") ? ReferenceListApplicability.applicableByKind : ReferenceListApplicability.inapplicable;
            if (referenceListApplicability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/proximity/ReferenceListWeigher", "getApplicability"));
            }
            return referenceListApplicability;
        }
        ReferenceListApplicability referenceListApplicability = ReferenceListApplicability.unknown;
        if (referenceListApplicability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/proximity/ReferenceListWeigher", "getApplicability"));
        }
        return referenceListApplicability;
    }

    public static enum ReferenceListApplicability {
        inapplicable,
        unknown,
        applicableByKind,
        applicableByName;

    }

    protected static enum Preference {
        Interfaces,
        Classes,
        Exceptions;

    }
}

