/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.CodeFragmentTableCellEditorBase;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.DelegationPanel;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeSignatureDialogBase<ParamInfo extends ParameterInfo, Method extends PsiElement, Visibility, Descriptor extends MethodDescriptor<ParamInfo, Visibility>, ParameterTableModelItem extends ParameterTableModelItemBase<ParamInfo>, ParameterTableModel extends ParameterTableModelBase<ParamInfo, ParameterTableModelItem>>
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance(ChangeSignatureDialogBase.class);
    protected static final String EXIT_SILENTLY = "";
    protected final Descriptor myMethod;
    private final boolean myAllowDelegation;
    protected JPanel myNamePanel;
    protected EditorTextField myNameField;
    protected EditorTextField myReturnTypeField;
    protected JBListTable myParametersList;
    protected TableView<ParameterTableModelItem> myParametersTable;
    protected final ParameterTableModel myParametersTableModel;
    protected final UpdateSignatureListener mySignatureUpdater = new UpdateSignatureListener();
    private MethodSignatureComponent mySignatureArea;
    private final Alarm myUpdateSignatureAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    protected VisibilityPanelBase<Visibility> myVisibilityPanel;
    @Nullable
    protected PsiCodeFragment myReturnTypeCodeFragment;
    private DelegationPanel myDelegationPanel;
    protected AnActionButton myPropagateParamChangesButton;
    protected Set<Method> myMethodsToPropagateParameters = null;
    private boolean myDisposed;
    private Tree myParameterPropagationTreeToReuse;
    protected final PsiElement myDefaultValueContext;

    protected abstract LanguageFileType getFileType();

    protected abstract ParameterTableModel createParametersInfoModel(Descriptor var1);

    protected abstract BaseRefactoringProcessor createRefactoringProcessor();

    protected abstract PsiCodeFragment createReturnTypeCodeFragment();

    @Nullable
    protected abstract CallerChooserBase<Method> createCallerChooser(String var1, Tree var2, Consumer<Set<Method>> var3);

    @Nullable
    protected abstract String validateAndCommitData();

    protected abstract String calculateSignature();

    protected abstract VisibilityPanelBase<Visibility> createVisibilityControl();

    public ChangeSignatureDialogBase(Project project2, Descriptor method, boolean allowDelegation, PsiElement defaultValueContext) {
        super(project2, true);
        this.myMethod = method;
        this.myDefaultValueContext = defaultValueContext;
        this.myParametersTableModel = this.createParametersInfoModel(method);
        this.myAllowDelegation = allowDelegation;
        this.setParameterInfos(method.getParameters());
        this.setTitle(ChangeSignatureHandler.REFACTORING_NAME);
        this.init();
        this.doUpdateSignature();
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ChangeSignatureDialogBase.this.myUpdateSignatureAlarm.cancelAllRequests();
                ChangeSignatureDialogBase.this.myDisposed = true;
            }
        });
    }

    public void setParameterInfos(List<ParamInfo> parameterInfos) {
        ((ParameterTableModelBase)((Object)this.myParametersTableModel)).setParameterInfos(parameterInfos);
        this.updateSignature();
    }

    protected String getMethodName() {
        if (this.myNameField != null) {
            return this.myNameField.getText().trim();
        }
        return this.myMethod.getName();
    }

    @Nullable
    protected Visibility getVisibility() {
        if (this.myVisibilityPanel != null) {
            return this.myVisibilityPanel.getVisibility();
        }
        return (Visibility)this.myMethod.getVisibility();
    }

    public List<ParamInfo> getParameters() {
        ArrayList result = new ArrayList(this.myParametersTableModel.getRowCount());
        for (ParameterTableModelItemBase item : this.myParametersTableModel.getItems()) {
            result.add(item.parameter);
        }
        return result;
    }

    public boolean isGenerateDelegate() {
        return this.myAllowDelegation && this.myDelegationPanel.isGenerateDelegate();
    }

    public JComponent getPreferredFocusedComponent() {
        JBTable table = this.getTableComponent();
        if (table != null && table.getRowCount() > 0) {
            if (table.getColumnModel().getSelectedColumnCount() == 0) {
                int selectedIdx = this.getSelectedIdx();
                table.getSelectionModel().setSelectionInterval(selectedIdx, selectedIdx);
                table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
            }
            return table;
        }
        if (UIUtil.isFocusable((JComponent)((Object)this.myNameField))) {
            return this.myNameField;
        }
        if (UIUtil.isFocusable((JComponent)((Object)this.myReturnTypeField))) {
            return this.myReturnTypeField;
        }
        return super.getPreferredFocusedComponent();
    }

    protected int getSelectedIdx() {
        return 0;
    }

    protected JBTable getTableComponent() {
        return this.myParametersList == null ? this.myParametersTable : this.myParametersList.getTable();
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.myNamePanel = new JPanel(new BorderLayout(0, 2));
        this.myNameField = new EditorTextField(this.myMethod.getName());
        JLabel nameLabel = new JLabel(RefactoringBundle.message((String)"changeSignature.name.prompt"));
        nameLabel.setLabelFor((Component)((Object)this.myNameField));
        this.myNameField.setEnabled(this.myMethod.canChangeName());
        if (this.myMethod.canChangeName()) {
            this.myNameField.addDocumentListener(this.mySignatureUpdater);
            this.myNameField.setPreferredWidth(200);
        }
        this.myNamePanel.add((Component)nameLabel, "North");
        IJSwingUtilities.adjustComponentsOnMac(nameLabel, (JComponent)((Object)this.myNameField));
        this.myNamePanel.add((Component)((Object)this.myNameField), "South");
        this.createVisibilityPanel();
        if (this.myMethod.canChangeVisibility() && this.myVisibilityPanel instanceof ComboBoxVisibilityPanel) {
            ((ComboBoxVisibilityPanel)this.myVisibilityPanel).registerUpDownActionsFor((JComponent)((Object)this.myNameField));
            this.myVisibilityPanel.setBorder(new EmptyBorder(0, 0, 0, 8));
            panel.add(this.myVisibilityPanel, gbc);
            ++gbc.gridx;
        }
        gbc.weightx = 1.0;
        if (this.myMethod.canChangeReturnType() != MethodDescriptor.ReadWriteOption.None) {
            JPanel typePanel = new JPanel(new BorderLayout(0, 2));
            typePanel.setBorder(new EmptyBorder(0, 0, 0, 8));
            JLabel typeLabel = new JLabel(RefactoringBundle.message((String)"changeSignature.return.type.prompt"));
            this.myReturnTypeCodeFragment = this.createReturnTypeCodeFragment();
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)this.myReturnTypeCodeFragment);
            this.myReturnTypeField = this.createReturnTypeTextField(document);
            ((ComboBoxVisibilityPanel)this.myVisibilityPanel).registerUpDownActionsFor((JComponent)((Object)this.myReturnTypeField));
            typeLabel.setLabelFor((Component)((Object)this.myReturnTypeField));
            if (this.myMethod.canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite) {
                this.myReturnTypeField.setPreferredWidth(200);
                this.myReturnTypeField.addDocumentListener(this.mySignatureUpdater);
            } else {
                this.myReturnTypeField.setEnabled(false);
            }
            typePanel.add((Component)typeLabel, "North");
            IJSwingUtilities.adjustComponentsOnMac(typeLabel, (JComponent)((Object)this.myReturnTypeField));
            typePanel.add((Component)((Object)this.myReturnTypeField), "South");
            panel.add((Component)typePanel, gbc);
            ++gbc.gridx;
        }
        panel.add((Component)this.myNamePanel, gbc);
        return panel;
    }

    protected EditorTextField createReturnTypeTextField(Document document) {
        return new EditorTextField(document, this.myProject, (FileType)this.getFileType());
    }

    private DelegationPanel createDelegationPanel() {
        return new DelegationPanel(){

            @Override
            protected void stateModified() {
                ChangeSignatureDialogBase.this.myParametersTableModel.fireTableDataChanged();
                ChangeSignatureDialogBase.this.myParametersTable.repaint();
            }
        };
    }

    protected JComponent createCenterPanel() {
        JPanel main;
        JPanel panel = new JPanel(new BorderLayout());
        JComponent optionsPanel = this.createOptionsPanel();
        JPanel subPanel = new JPanel(new BorderLayout());
        List<Pair<String, JPanel>> panels = this.createAdditionalPanels();
        if (this.myMethod.canChangeParameters()) {
            JPanel parametersPanel = this.createParametersPanel(!panels.isEmpty());
            if (!panels.isEmpty()) {
                parametersPanel.setBorder(IdeBorderFactory.createEmptyBorder());
            }
            subPanel.add((Component)parametersPanel, "Center");
        }
        if (this.myMethod.canChangeVisibility() && !(this.myVisibilityPanel instanceof ComboBoxVisibilityPanel)) {
            subPanel.add(this.myVisibilityPanel, this.myMethod.canChangeParameters() ? "East" : "Center");
        }
        panel.add((Component)subPanel, "Center");
        if (panels.isEmpty()) {
            main = panel;
        } else {
            TabbedPaneWrapper tabbedPane = new TabbedPaneWrapper(this.getDisposable());
            tabbedPane.addTab(RefactoringBundle.message((String)"parameters.border.title"), panel);
            for (Pair<String, JPanel> extraPanel : panels) {
                tabbedPane.addTab((String)extraPanel.first, (JComponent)extraPanel.second);
            }
            main = new JPanel(new BorderLayout());
            JComponent tabs = tabbedPane.getComponent();
            main.add((Component)tabs, "Center");
            for (JComponent c : UIUtil.findComponentsOfType((JComponent)tabs, JComponent.class)) {
                c.setFocusCycleRoot(false);
                c.setFocusTraversalPolicy(null);
            }
        }
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.add((Component)optionsPanel, "North");
        bottom.add((Component)this.createSignaturePanel(), "South");
        main.add((Component)bottom, "South");
        main.setBorder(IdeBorderFactory.createEmptyBorder((int)5, (int)0, (int)0, (int)0));
        return main;
    }

    protected JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        if (this.myAllowDelegation) {
            this.myDelegationPanel = this.createDelegationPanel();
            panel.add((Component)this.myDelegationPanel, "West");
        }
        this.myPropagateParamChangesButton = new AnActionButton(RefactoringBundle.message((String)"changeSignature.propagate.parameters.title"), null, AllIcons.Hierarchy.Caller){

            public void actionPerformed(AnActionEvent e) {
                final Ref chooser = new Ref();
                Consumer callback = new Consumer<Set<Method>>(){

                    public void consume(Set<Method> callers) {
                        ChangeSignatureDialogBase.this.myMethodsToPropagateParameters = callers;
                        ChangeSignatureDialogBase.this.myParameterPropagationTreeToReuse = ((CallerChooserBase)((Object)chooser.get())).getTree();
                    }
                };
                try {
                    String message = RefactoringBundle.message((String)"changeSignature.parameter.caller.chooser");
                    chooser.set(ChangeSignatureDialogBase.this.createCallerChooser(message, ChangeSignatureDialogBase.this.myParameterPropagationTreeToReuse, callback));
                }
                catch (ProcessCanceledException ex) {
                    return;
                }
                ((CallerChooserBase)((Object)chooser.get())).show();
            }
        };
        JPanel result = new JPanel((LayoutManager)new VerticalFlowLayout(0));
        result.add(panel);
        return result;
    }

    protected JPanel createVisibilityPanel() {
        this.myVisibilityPanel = this.createVisibilityControl();
        this.myVisibilityPanel.setVisibility(this.myMethod.getVisibility());
        this.myVisibilityPanel.addListener(this.mySignatureUpdater);
        return this.myVisibilityPanel;
    }

    @NotNull
    protected List<Pair<String, JPanel>> createAdditionalPanels() {
        List<Pair<String, JPanel>> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase", "createAdditionalPanels"));
        }
        return list;
    }

    protected String getDimensionServiceKey() {
        return "refactoring.ChangeSignatureDialog";
    }

    protected boolean isListTableViewSupported() {
        return false;
    }

    protected JPanel createParametersPanel(boolean hasTabsInDialog) {
        this.myParametersTable = new TableView<ParameterTableModelItem>((ListTableModel)this.myParametersTableModel){

            public void removeEditor() {
                this.clearEditorListeners();
                super.removeEditor();
            }

            public void editingStopped(ChangeEvent e) {
                super.editingStopped(e);
                this.repaint();
            }

            private void clearEditorListeners() {
                TableCellEditor editor = this.getCellEditor();
                if (editor instanceof StringTableCellEditor) {
                    StringTableCellEditor ed = (StringTableCellEditor)editor;
                    ed.clearListeners();
                } else if (editor instanceof CodeFragmentTableCellEditorBase) {
                    ((CodeFragmentTableCellEditorBase)editor).clearListeners();
                }
            }

            public Component prepareEditor(TableCellEditor editor, final int row, final int column) {
                DocumentAdapter listener2 = new DocumentAdapter(){

                    public void documentChanged(DocumentEvent e) {
                        TableCellEditor ed = ChangeSignatureDialogBase.this.myParametersTable.getCellEditor();
                        if (ed != null) {
                            Object editorValue = ed.getCellEditorValue();
                            ((ParameterTableModelBase)((Object)ChangeSignatureDialogBase.this.myParametersTableModel)).setValueAtWithoutUpdate(editorValue, row, column);
                            ChangeSignatureDialogBase.this.updateSignature();
                        }
                    }
                };
                if (editor instanceof StringTableCellEditor) {
                    StringTableCellEditor ed = (StringTableCellEditor)editor;
                    ed.addDocumentListener((DocumentListener)listener2);
                } else if (editor instanceof CodeFragmentTableCellEditorBase) {
                    ((CodeFragmentTableCellEditorBase)editor).addDocumentListener((DocumentListener)listener2);
                }
                return super.prepareEditor(editor, row, column);
            }

            public void editingCanceled(ChangeEvent e) {
                super.editingCanceled(e);
            }
        };
        this.myParametersTable.setCellSelectionEnabled(true);
        this.myParametersTable.getSelectionModel().setSelectionMode(0);
        this.myParametersTable.getSelectionModel().setSelectionInterval(0, 0);
        this.myParametersTable.setSurrendersFocusOnKeystroke(true);
        this.myPropagateParamChangesButton.setShortcut((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"alt G"}));
        if (this.isListTableViewSupported()) {
            this.myParametersList = this.createParametersListTable();
            JPanel buttonsPanel = ToolbarDecorator.createDecorator((JTable)this.myParametersList.getTable()).addExtraAction(this.myPropagateParamChangesButton).createPanel();
            this.myParametersList.getTable().getModel().addTableModelListener(this.mySignatureUpdater);
            return buttonsPanel;
        }
        JPanel buttonsPanel = ToolbarDecorator.createDecorator((JTable)this.getTableComponent()).addExtraAction(this.myPropagateParamChangesButton).createPanel();
        this.myPropagateParamChangesButton.setEnabled(false);
        this.myPropagateParamChangesButton.setVisible(false);
        this.myParametersTable.setStriped(true);
        this.myParametersTableModel.addTableModelListener((TableModelListener)this.mySignatureUpdater);
        this.customizeParametersTable(this.myParametersTable);
        return buttonsPanel;
    }

    protected ParametersListTable createParametersListTable() {
        return new ParametersListTable(){

            @Override
            protected JBTableRowRenderer getRowRenderer(int row) {
                return new JBTableRowRenderer(){

                    @Override
                    public JComponent getRowRendererComponent(JTable table, int row, boolean selected, boolean focused) {
                        JComponent presentation = ChangeSignatureDialogBase.this.getRowPresentation(this.getRowItem(row), selected, focused);
                        LOG.assertTrue(presentation != null);
                        return presentation;
                    }
                };
            }

            @Override
            @NotNull
            protected JBTableRowEditor getRowEditor(ParameterTableModelItemBase<ParamInfo> item) {
                JBTableRowEditor editor = ChangeSignatureDialogBase.this.getTableEditor((JTable)this.getTable(), item);
                LOG.assertTrue(editor != null);
                JBTableRowEditor jBTableRowEditor = editor;
                if (jBTableRowEditor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase$5", "getRowEditor"));
                }
                return jBTableRowEditor;
            }

            @Override
            protected boolean isRowEmpty(int row) {
                return ChangeSignatureDialogBase.this.isEmptyRow(this.getRowItem(row));
            }
        };
    }

    @Deprecated
    @Nullable
    protected JBTableRowEditor getTableEditor(JTable table, ParameterTableModelItemBase<ParamInfo> item) {
        return null;
    }

    @Deprecated
    protected boolean isEmptyRow(ParameterTableModelItemBase<ParamInfo> row) {
        return false;
    }

    @Deprecated
    @Nullable
    protected JComponent getRowPresentation(ParameterTableModelItemBase<ParamInfo> item, boolean selected, boolean focused) {
        return null;
    }

    protected void customizeParametersTable(TableView<ParameterTableModelItem> table) {
    }

    private JComponent createSignaturePanel() {
        this.mySignatureArea = this.createSignaturePreviewComponent();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)SeparatorFactory.createSeparator((String)RefactoringBundle.message((String)"signature.preview.border.title"), null), "North");
        panel.add((Component)((Object)this.mySignatureArea), "Center");
        this.mySignatureArea.setPreferredSize(new Dimension(-1, 130));
        this.mySignatureArea.setMinimumSize(new Dimension(-1, 130));
        this.mySignatureArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Component c;
                Container root = ChangeSignatureDialogBase.findTraversalRoot(ChangeSignatureDialogBase.this.getContentPane());
                if (root != null && (c = root.getFocusTraversalPolicy().getComponentAfter(root, (Component)((Object)ChangeSignatureDialogBase.this.mySignatureArea))) != null) {
                    IdeFocusManager.findInstance().requestFocus(c, true);
                }
            }
        });
        this.updateSignature();
        return panel;
    }

    private static Container findTraversalRoot(Container container) {
        Container root;
        Container current = KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentFocusCycleRoot();
        if (current == container) {
            root = container;
        } else {
            root = container.getFocusCycleRootAncestor();
            if (root == null) {
                root = container;
            }
        }
        if (root != current) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(root);
        }
        return root;
    }

    protected MethodSignatureComponent createSignaturePreviewComponent() {
        return new MethodSignatureComponent(this.calculateSignature(), this.getProject(), (FileType)this.getFileType());
    }

    protected void updateSignature() {
        if (this.mySignatureArea == null || this.myPropagateParamChangesButton == null) {
            return;
        }
        Runnable updateRunnable = new Runnable(){

            @Override
            public void run() {
                if (ChangeSignatureDialogBase.this.myDisposed) {
                    return;
                }
                ChangeSignatureDialogBase.this.myUpdateSignatureAlarm.cancelAllRequests();
                ChangeSignatureDialogBase.this.myUpdateSignatureAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        ChangeSignatureDialogBase.this.updateSignatureAlarmFired();
                    }
                }, 100, ModalityState.stateForComponent((Component)((Object)ChangeSignatureDialogBase.this.mySignatureArea)));
            }
        };
        SwingUtilities.invokeLater(updateRunnable);
    }

    protected void updateSignatureAlarmFired() {
        this.doUpdateSignature();
        this.updatePropagateButtons();
    }

    private void doUpdateSignature() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        this.mySignatureArea.setSignature(this.calculateSignature());
    }

    protected void updatePropagateButtons() {
        if (this.myPropagateParamChangesButton != null) {
            this.myPropagateParamChangesButton.setEnabled(!this.isGenerateDelegate() && this.mayPropagateParameters());
        }
    }

    protected boolean mayPropagateParameters() {
        List<ParamInfo> infos = this.getParameters();
        if (infos.size() <= this.myMethod.getParametersCount()) {
            return false;
        }
        for (int i = 0; i < this.myMethod.getParametersCount(); ++i) {
            if (((ParameterInfo)infos.get(i)).getOldIndex() == i) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doAction() {
        String message;
        if (this.myParametersTable != null) {
            TableUtil.stopEditing(this.myParametersTable);
        }
        if ((message = this.validateAndCommitData()) != null) {
            if (message != EXIT_SILENTLY) {
                CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)message, (String)this.getHelpId(), (Project)this.myProject);
            }
            return;
        }
        if (this.myMethodsToPropagateParameters != null && !this.mayPropagateParameters()) {
            Messages.showWarningDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"changeSignature.parameters.wont.propagate"), (String)ChangeSignatureHandler.REFACTORING_NAME);
            this.myMethodsToPropagateParameters = null;
        }
        this.myDisposed = true;
        this.invokeRefactoring(this.createRefactoringProcessor());
    }

    protected String getHelpId() {
        return "refactoring.changeSignature";
    }

    protected abstract class ParametersListTable
    extends JBListTable {
        public ParametersListTable() {
            super((JTable)ChangeSignatureDialogBase.this.myParametersTable, ChangeSignatureDialogBase.this.getDisposable());
        }

        @Override
        protected final JBTableRowEditor getRowEditor(final int row) {
            JBTableRowEditor editor = this.getRowEditor((ParameterTableModelItemBase)this.getRowItem(row));
            editor.addDocumentListener(new JBTableRowEditor.RowDocumentListener(){

                @Override
                public void documentChanged(DocumentEvent e, int column) {
                    if (String.class.equals((Object)ChangeSignatureDialogBase.this.myParametersTableModel.getColumnClass(column))) {
                        ((ParameterTableModelBase)((Object)ChangeSignatureDialogBase.this.myParametersTableModel)).setValueAtWithoutUpdate(e.getDocument().getText(), row, column);
                    }
                    ChangeSignatureDialogBase.this.updateSignature();
                }
            });
            return editor;
        }

        @NotNull
        protected abstract JBTableRowEditor getRowEditor(ParameterTableModelItemBase<ParamInfo> var1);

        @Override
        protected abstract boolean isRowEmpty(int var1);

        protected ParameterTableModelItem getRowItem(int row) {
            return (ParameterTableModelItemBase)ChangeSignatureDialogBase.this.myParametersTable.getItems().get(row);
        }
    }

    class UpdateSignatureListener
    implements ChangeListener,
    DocumentListener,
    TableModelListener {
        UpdateSignatureListener() {
        }

        private void update() {
            ChangeSignatureDialogBase.this.updateSignature();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.update();
        }

        public void documentChanged(DocumentEvent event) {
            this.update();
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.update();
        }

        public void beforeDocumentChange(DocumentEvent event) {
        }
    }
}

