/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.SimpleDuplicatesFinder;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.ui.ReplacePromptDialog;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodHelper {
    public static void processDuplicates(final @NotNull PsiElement callElement, final @NotNull PsiElement generatedMethod, final @NotNull List<PsiElement> scope, final @NotNull SimpleDuplicatesFinder finder, final @NotNull Editor editor, final @NotNull Consumer<Pair<SimpleMatch, PsiElement>> replacer) {
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "com/intellij/refactoring/extractMethod/ExtractMethodHelper", "processDuplicates"));
        }
        if (generatedMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generatedMethod", "com/intellij/refactoring/extractMethod/ExtractMethodHelper", "processDuplicates"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/refactoring/extractMethod/ExtractMethodHelper", "processDuplicates"));
        }
        if (finder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finder", "com/intellij/refactoring/extractMethod/ExtractMethodHelper", "processDuplicates"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/extractMethod/ExtractMethodHelper", "processDuplicates"));
        }
        if (replacer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacer", "com/intellij/refactoring/extractMethod/ExtractMethodHelper", "processDuplicates"));
        }
        finder.setReplacement(callElement);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ExtractMethodHelper.replaceDuplicates(callElement, editor, replacer, finder.findDuplicates(scope, generatedMethod));
            return;
        }
        Project project2 = callElement.getProject();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Searching for duplicates...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/refactoring/extractMethod/ExtractMethodHelper$1", "run"));
                }
                if (this.myProject == null || this.myProject.isDisposed()) {
                    return;
                }
                final List duplicates = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<SimpleMatch>>(){

                    public List<SimpleMatch> compute() {
                        return finder.findDuplicates(scope, generatedMethod);
                    }
                });
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExtractMethodHelper.replaceDuplicates(callElement, editor, (Consumer<Pair<SimpleMatch, PsiElement>>)replacer, duplicates);
                    }
                });
            }
        });
    }

    private static void replaceDuplicates(PsiElement callElement, Editor editor, Consumer<Pair<SimpleMatch, PsiElement>> replacer, List<SimpleMatch> duplicates) {
        if (duplicates.size() > 0) {
            int exitCode;
            String message = RefactoringBundle.message((String)"0.has.detected.1.code.fragments.in.this.file.that.can.be.replaced.with.a.call.to.extracted.method", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), duplicates.size()});
            boolean isUnittest = ApplicationManager.getApplication().isUnitTestMode();
            Project project2 = callElement.getProject();
            int n = exitCode = !isUnittest ? Messages.showYesNoDialog((Project)project2, (String)message, (String)RefactoringBundle.message((String)"refactoring.extract.method.dialog.title"), (Icon)Messages.getInformationIcon()) : 0;
            if (exitCode == 0) {
                boolean replaceAll = false;
                HashMap<SimpleMatch, RangeHighlighter> highlighterMap = new HashMap<SimpleMatch, RangeHighlighter>();
                for (SimpleMatch match : duplicates) {
                    if (!match.getStartElement().isValid() || !match.getEndElement().isValid()) continue;
                    Pair replacement = Pair.create((Object)match, (Object)callElement);
                    if (!replaceAll) {
                        ExtractMethodHelper.highlightInEditor(project2, match, editor, highlighterMap);
                        int promptResult = 3;
                        if (!isUnittest) {
                            ReplacePromptDialog promptDialog = new ReplacePromptDialog(false, RefactoringBundle.message((String)"replace.fragment"), project2);
                            promptDialog.show();
                            promptResult = promptDialog.getExitCode();
                        }
                        if (promptResult == 2) {
                            HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
                            RangeHighlighter highlighter = (RangeHighlighter)highlighterMap.get(match);
                            if (highlighter == null) continue;
                            highlightManager.removeSegmentHighlighter(editor, highlighter);
                            continue;
                        }
                        if (promptResult == 1) break;
                        if (promptResult == 0) {
                            ExtractMethodHelper.replaceDuplicate(project2, replacer, (Pair<SimpleMatch, PsiElement>)replacement);
                            continue;
                        }
                        if (promptResult != 3) continue;
                        ExtractMethodHelper.replaceDuplicate(project2, replacer, (Pair<SimpleMatch, PsiElement>)replacement);
                        replaceAll = true;
                        continue;
                    }
                    ExtractMethodHelper.replaceDuplicate(project2, replacer, (Pair<SimpleMatch, PsiElement>)replacement);
                }
            }
        }
    }

    private static void replaceDuplicate(Project project2, final Consumer<Pair<SimpleMatch, PsiElement>> replacer, final Pair<SimpleMatch, PsiElement> replacement) {
        CommandProcessor.getInstance().executeCommand(project2, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        replacer.consume((Object)replacement);
                    }
                });
            }
        }, "Replace duplicate", null);
    }

    private static void highlightInEditor(@NotNull Project project2, @NotNull SimpleMatch match, @NotNull Editor editor, Map<SimpleMatch, RangeHighlighter> highlighterMap) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethod/ExtractMethodHelper", "highlightInEditor"));
        }
        if (match == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "match", "com/intellij/refactoring/extractMethod/ExtractMethodHelper", "highlightInEditor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/extractMethod/ExtractMethodHelper", "highlightInEditor"));
        }
        ArrayList highlighters = new ArrayList();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        int startOffset = match.getStartElement().getTextRange().getStartOffset();
        int endOffset = match.getEndElement().getTextRange().getEndOffset();
        highlightManager.addRangeHighlight(editor, startOffset, endOffset, attributes, true, highlighters);
        highlighterMap.put(match, (RangeHighlighter)highlighters.get(0));
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(startOffset);
        editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.MAKE_VISIBLE);
    }
}

